/**
 **	$Header: /import/dev-vis/image/imtools/v2.0/imtools/src/include/RCS/imtools.h,v 1.1 91/10/22 14:05:43 nadeau Exp $
 **	Copyright (c) 1989, 1990  San Diego Supercomputer Center (SDSC)
 **		San Diego, California, USA
 **
 **	Users and possessors of this source code are hereby granted a
 **	nonexclusive, royalty-free copyright and design patent license to
 **	use this code in individual software.  License is not granted for
 **	commercial resale, in whole or in part, without prior written
 **	permission from SDSC.  This source is provided "AS IS" without express
 **	or implied warranty of any kind.
 **
 **	For further information contact:
 **		E-Mail:		info@sds.sdsc.edu
 **
 **		Surface Mail:	Information Center
 **				San Diego Supercomputer Center
 **				P.O. Box 85608
 **				San Diego, CA  92138-5608
 **				(619) 534-5000
 **/

/**
 **  FILE
 **	imtools.h	-  general include file for all image tools
 **
 **  PROJECT
 **	IM		-  Image Manipulation Tools
 **
 **  DESCRIPTION
 **	imtools.h contains generic macros and extern declarations for
 **	variables and functions used by most of the image tools.
 **
 **  PUBLIC CONTENTS
 **			d =defined constant
 **			f =function
 **			m =defined macro
 **			t =typedef/struct/union
 **			v =variable
 **			? =other
 **
 **	IMTOOLS...	d  tool version
 **	ImTools*	v  extern global declarations
 **	ImTools*	f  extern function declarations
 **
 **  PRIVATE CONTENTS
 **	none
 **
 **  HISTORY
 **	$Log:	imtools.h,v $
 **	Revision 1.1  91/10/22  14:05:43  nadeau
 **	Initial revision
 **	
 **/

#ifndef __IMTOOLS_H__


#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/file.h>
#include "sdsc.h"
#include "im.h"

#ifndef NULL
#define NULL
#endif





/*
 *  CONSTANTS
 *	IMTOOLS...		-  tool version
 *
 *  DESCRIPTION
 *	This is the current version number for the tools.  Note that all
 *	tools use this same version number, and thus track release versions
 *	together.
 */
#define IMTOOLSMAJOR	2
#define IMTOOLSMINOR	0
#define IMTOOLSSUBMINOR	0





/*
 *  GLOBALS
 *	ImTools*		-  extern global declarations
 *
 *  DESCRIPTION
 *	ImToolsProgram holds the argv[0] name of the program and is used
 *	in various error messages.
 *
 *	ImToolsVerbose flags whether we should print out verbose messages
 *	about what we are doing, or not.
 *
 *	ImToolsBaseHelp is the generic basic help string used by most of
 *	the image tools to describe the basic options.
 *
 *	ImToolsRegister and ImToolsFeedback are the user registration and
 *	feedback forms used by the image tools.
 *
 *	ImToolsBaseOptions and ImToolsBaseEquivs are the generic basic
 *	command-line options and equivalent option keywords used by most
 *	of the image tools.
 */
extern char   *ImToolsProgram;
extern boolean ImToolsVerbose;

extern char   *ImToolsBaseHelp;

extern char   *ImToolsRegister;
extern char   *ImToolsFeedback;

#define IMTOOLSNBASEOPTIONS	10
#define IMTOOLSNBASEEQUIVS	0
extern ArgOption ImToolsBaseOptions[];
extern ArgEquiv  ImToolsBaseEquivs[];





/*
 *  FUNCTIONS
 *	ImTools*		-  extern function declarations
 */

extern int	 ImToolsMergeOptions( );
extern int	 ImToolsMergeEquivs( );
extern boolean	 ImToolsIsFormat( );
extern TagTable	*ImToolsBuildFlagsTable( );
extern void	 ImToolsChangeTagEntry( );
extern int	 ImToolsErrorHandler( );
extern FILE	*ImToolsOpen( );
extern void	 ImToolsFileRead( );
extern void	 ImToolsFileWrite( );

#endif /* __IMTOOLS_H__ */
