/* copyright 1989 Phil Andrews, Pittsburgh Supercomputing Center */
/* this whole thing is very VMS specific and should only be linked under VMS */
#include "defs.h"
#include <uisentry.h>	/* entry points in lower case */
#include <uisusrdef.h>	/* constants in upper case */
#include descrip	/* descriptors */
#include stdio
#include <math.h>
#define byte_size 8
/* store these pointers to allow lookups into the CGM data structures */
static struct one_opt 		*popt;	/* the command line options, in only */
static struct mf_d_struct 	*pc1;	/* the class 1 elements, in only */
static struct pic_d_struct 	*pc2;	/* the class 2 elements, in only */
static struct control_struct	*pc3;	/* the class 3 elements, in only */
static struct attrib_struct	*pc5;	/* the class 5 elements, in only */
static struct info_struct 	*dptr;	/* device info in and out */

static $DESCRIPTOR(devnam, "SYS$WORKSTATION");
static int vcm_size;
static unsigned int wd_id, vd_id, vcm_id;

/* these are the screen variables */
static unsigned int retpwidth, retpheight;
static float retwidth, retheight, retresolx, retresoly;
static unsigned int dev_type, tot_indices, colors, maps, rbits, gbits, bbits,
	ibits, res_indices, regen;
static int max_uis_index;
#define max_str 128
static char fname[max_str + 1];
static int fname_l;
static int state_level;
static unsigned int gbl_style = ~0;
/* arrange the attribute blocks */
static unsigned int atb_template = 0, 	/* the template provided by UIS */
atb_defaults,			/* keep defaults here */
atb_active;			/* the one we are using */

void set_colour();
char *allocate_mem();
static int base_index;		/* necessary offset */
static int bits_pixel;
static int my_inds[3];
static float back_grey;		/* how dark is the background ? */
/* return a real value for the grey associated with a colour (0->light) */
#define col_grey(r, g, b)  (1.0 - (0.3 * r + 0.59 * g + 0.11 * b))
static float grey_col(cptr)
struct rgbi_struct *cptr;
{
float r, g, b;

	if (pc2->c_s_mode == i_c_mode) {	/* indexed */
	    r = pc5->ctab[cptr->ind * 3];
	    g = pc5->ctab[cptr->ind * 3 + 1];
	    b = pc5->ctab[cptr->ind * 3 + 2];
	}
	else if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
	    r = cptr->red;
	    g = cptr->green;
	    r = cptr->blue;
	}
	return(col_grey(r, g, b));
}
/* start everything up */
uis_begin(comment, file_name, prog_name)
char *comment, *file_name, *prog_name;

{
float x1, x2, y1, y2, width, height;
int mode;
unsigned int *vcm_ptr;
static $DESCRIPTOR(vcmnam, "COLOUR");
	++state_level;

	if (state_level < 1) {
	    wd_id = 0;
	    strncpy(fname, file_name, max_str);
	    fname[max_str] = 0;	    /* for safety */
	    fname_l = strlen(fname);
	    x1 = 0.0;
	    y1 = 0.0;
	    x2 = dptr->x_size * dptr->pxl_in / retresolx;
	    y2 = dptr->y_size * dptr->ypxl_in / retresoly;
	    width = x2 - x1;
	    height = y2 - y1;
	    vcm_size = tot_indices - res_indices;
	    vcm_id = uis$create_color_map(&vcm_size, 0, 0);
	    vcm_ptr = &vcm_id;
	    vd_id = uis$create_display(&x1, &y1, &x2, &y2, &width, &height, 
		vcm_ptr);
	}
	/* now set up the attribute block */
	atb_active = atb_defaults = atb_template + 1 + 2 * state_level;
	mode = (state_level > 0) ? UIS$C_MODE_OVER : UIS$C_MODE_REPL;
	uis$set_writing_mode(&vd_id, &atb_template, &atb_active, &mode);
	return(1);
}
/* start a page  */
uis_bpage(pic_name, xoffset, yoffset, rotation, rb, gb, bb, page_no, 
    xsize, ysize)
char *pic_name;
float rotation;
int xoffset, yoffset, page_no, xsize, ysize;
float rb, gb, bb;	/* background colour values */
{
float x1, x2, y1, y2, width, height;
int zero = 0;
struct dsc$descriptor_s title;
int mode, back_index;
struct rgbi_struct back_cstruct;
unsigned int atb_back;

	/* figure out the writing mode */
	if (bits_pixel == 1) { 
	    back_cstruct.ind = 0;
	    back_cstruct.red = rb;
	    back_cstruct.green = gb;
	    back_cstruct.blue = bb;
	    back_grey = grey_col(&back_cstruct);
	    mode = (back_grey > 0.5) ? UIS$C_MODE_COPY : UIS$C_MODE_COPYN;
	} else mode = UIS$C_MODE_COPY;	/* want the index */

	if (state_level < 1) {	/* not included */
	    if ((wd_id == 0) || (uis$get_viewport_icon(&wd_id))) {
		/* no window */
		title.dsc$w_length 	= strlen(fname);
		title.dsc$a_pointer 	= fname;
		title.dsc$b_class	= DSC$K_CLASS_S;
		title.dsc$b_dtype	= DSC$K_DTYPE_T;

		x1 = 0.0;
		y1 = 0.0;
		x2 = (xsize + 40)/ retresolx;	/* plus to allow for edges */
		y2 = (ysize + 40)/ retresoly;
		width = x2 - x1;
		height = y2 - y1;
		if (height > retheight) height = retheight;
		if (width > retwidth) width = retwidth;
		wd_id = uis$create_window(&vd_id, &devnam, &title, &x1, &y1, &x2,
		    &y2, &width, &height, 0);
	    }
/* take care of colour problems */

	    back_index = 0;
	    if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
		base_index = (bits_pixel == 8) ? 1 : 0;
	        get_cinds(vcm_size - base_index, my_inds);
	        load_dcmap(my_inds);
	        /* now set the background colour */
	        uis$set_color(&vd_id, &back_index, &rb, &gb, &bb);
	    } else if (pc2->c_s_mode == i_c_mode) {	/* indexed colour */
	        /* fill out the colour map, if we have one */
	        if (maps) set_uismap(pc5->ctab, 0, pc1->max_c_index + 1);
		base_index = 0;
	    }
	    uis$set_background_index(&vd_id, &atb_defaults, &atb_defaults,
	        &back_index);
	    if (bits_pixel == 1) { 
	        /* set the background grey scale, if only 1 bit per pixel */
	        if (back_grey > 0.1) {
	    	    atb_back = atb_defaults + 200;	/* temp use */
		    set_fill(&back_cstruct, &atb_defaults, &atb_back);
		    uisdc$plot(&wd_id, &atb_back, &zero, &zero, &zero, 
		        &ysize, &xsize, &ysize, &xsize, &zero, &zero, &zero);
    	        } else uis$erase(&vd_id, NULL, NULL, NULL, NULL);
	    } else uis$erase(&vd_id, NULL, NULL, NULL, NULL);
	}

	/* any changes from now on are local to this page */
	atb_active = atb_defaults + 1;		/* keep defaults */
	uis$set_writing_mode(&vd_id, &atb_defaults, &atb_active, &mode);
	return(1);
}
/* end a page */
uis_epage(copies)
int copies;
{
	return(1);
}
/* end the metafile */
uis_end(pages_done)
int pages_done;
{
	--state_level;
	return(1);
}
/* plot a set of lines between alternate points */
uis_dpline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
unsigned int dpl_atb;

	dpl_atb = atb_active + 1;
	set_colour(&pc5->line_colour, &atb_active, &dpl_atb);
	uisdc$line_array(&wd_id, &dpl_atb, &no_pairs, x1_ptr, y1_ptr);
	return(1);
}
/* do line between a series of points */
uis_pline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
unsigned int atb_pline;

	atb_pline = atb_active + 1;

	set_colour(&pc5->line_colour, &atb_active, &atb_pline);

	uisdc$plot_array(&wd_id, &atb_pline, &no_pairs, x1_ptr, y1_ptr);
}

/* load the DC colour map */
static load_dcmap(ninds)
int *ninds;
{
int i, j, k, no_entries, c_index, ind1;
#define no_colours 3
float *col_tab[no_colours], top0, top1, top2;

	no_entries = ninds[0] * ninds[1] * ninds[2];
	ind1 = base_index;
	/* allocate the memory */
	for (i=0; i<no_colours; ++i) {
	    col_tab[i] = (float *) allocate_mem(sizeof(float) * no_entries, 0);
	    if (!col_tab[i]) {
		fprintf(stderr, "couldn't get memory for load_dcmap !\n");
	    	return(0);
	    }
	}

	/* establish bounds */
	top0 = (ninds[0] > 1) ? ninds[0] - 1.0 : 1.0;
	top1 = (ninds[1] > 1) ? ninds[1] - 1.0 : 1.0;
	top2 = (ninds[2] > 1) ? ninds[2] - 1.0 : 1.0;
	/* move over the info */
	for (i=0; i<ninds[2]; ++i) {
	    for (j=0; j<ninds[1]; ++j) {
		for (k=0; k<ninds[0]; ++k) {
		    c_index = ind_ijk(ninds, i, j, k);
		    *(col_tab[0] + c_index) = (float) k / top0;
		    *(col_tab[1] + c_index) = (float) j / top1;
		    *(col_tab[2] + c_index) = (float) i / top2;
		}
	    }
	}
	/* now put it into UIS */
  	uis$set_colors(&vd_id, &ind1, &no_entries, col_tab[0], 
	    col_tab[1], col_tab[2]);
	for (i=0; i<no_colours; ++i) free(col_tab[i]);
	return(1);
}
/* general colour setting routine */
static void set_colour(cptr, old_atb, new_atb)
struct rgbi_struct *cptr;
unsigned int *old_atb, *new_atb;
{
int col_index;

	if (pc2->c_s_mode == i_c_mode) {	/* indexed */
	    col_index = (cptr->ind >= tot_indices) ? 1 : cptr->ind;
	}
	else if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
	    col_index = int_rgb(cptr->red, cptr->green, cptr->blue, my_inds);
	    col_index += base_index;
	}

	uis$set_writing_index(&vd_id, old_atb, new_atb, &col_index);
	return;
}
/* do a polygon, may want to fill it */
uis_pgon(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
unsigned int atb_pgon;
int want_edge, tot_pairs, *new_x, *new_y, i;
char * allocate_mem();

	atb_pgon = atb_active + 1;

	want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);
	switch (pc5->int_style) {
	case hollow :	break;	/* don't try to fill these */
	case empty :	break;
	
	case pattern :		/* no pattern fill yet */
	case hatch :		/* no hatch fill yet */
	case solid_i :	set_fill(&pc5->fill_colour, &atb_active, &atb_pgon);
			uisdc$plot_array(&wd_id, &atb_pgon, &no_pairs, x1_ptr,
			    y1_ptr); 
			break;
	}

	/* may want visible edge */
	if (want_edge){	
	    tot_pairs = no_pairs + 1;
	    new_x = (int *) allocate_mem(tot_pairs * sizeof(int), 0);
	    new_y = (int *) allocate_mem(tot_pairs * sizeof(int), 0);
	    if (new_x && new_y) {
		for (i=0; i<no_pairs; ++i) {
		    new_x[i] = x1_ptr[i];
		    new_y[i] = y1_ptr[i];
		}
		new_x[i] = x1_ptr[0];
		new_y[i] = y1_ptr[0];
		if (pc5->edge_vis == on) 
		    set_colour(&pc5->edge_colour, &atb_active, &atb_pgon);
	    	else set_colour(&pc5->fill_colour, &atb_active, &atb_pgon);
	        uisdc$plot_array(&wd_id, &atb_pgon, &tot_pairs, new_x, new_y);
		free(new_x);
		free(new_y);
	    }
	}
	return(1);
}
static set_fill(cptr, old_ptr, atb_ptr)
struct rgbi_struct *cptr;
unsigned int *old_ptr, *atb_ptr;
{
float grey_col(), grey_val;
unsigned int fill_num, mode;
static $DESCRIPTOR(fill_font, "UIS$FILL_PATTERNS");
#define max_fill_char 16
static unsigned int fill_char[max_fill_char] = { PATT$C_GREY1_16, 
PATT$C_GREY2_16, PATT$C_GREY3_16, PATT$C_GREY4_16, PATT$C_GREY5_16,
PATT$C_GREY6_16, PATT$C_GREY7_16, PATT$C_GREY8_16, PATT$C_GREY9_16,
PATT$C_GREY10_16, PATT$C_GREY11_16, PATT$C_GREY12_16, PATT$C_GREY13_16,
PATT$C_GREY14_16, PATT$C_GREY15_16};

	if (bits_pixel > 1) {
	    fill_num = max_fill_char - 2;
	    set_colour(cptr, old_ptr, atb_ptr);
	    uis$set_font(&vd_id, atb_ptr, atb_ptr, &fill_font); 
	    mode = UIS$C_MODE_ERASN;
	} else {
	    mode = UIS$C_MODE_REPL;
	    grey_val = grey_col(cptr);
 	    fill_num = max_fill_char * grey_val;
	    if (fill_num < 0) fill_num = 0;
	    else if (fill_num >= (max_fill_char - 1) ) {
	        fill_num = max_fill_char - 2;
	        mode = UIS$C_MODE_ERASN;
	    }
	    uis$set_font(&vd_id, old_ptr, atb_ptr, &fill_font); 
	}
	uis$set_writing_mode(&vd_id, atb_ptr, atb_ptr, &mode);
	uis$set_fill_pattern(&vd_id, atb_ptr, atb_ptr, fill_char + fill_num);
	return(1);
}
#undef max_fill_char

/* do a rectangle */
uis_rectangle(x1, y1, x2, y2)
int x1, x2, y1, y2;
{
unsigned int atb_rect;

	atb_rect = atb_active + 1;
	set_fill(&pc5->fill_colour, &atb_active, &atb_rect);

	uisdc$plot(&wd_id, &atb_rect, &x1, &y1, &x1, &y2, &x2, &y2, &x2, &y1,
	    &x1, &y1);
	if (pc5->edge_vis) {	/* visible edge */
	    uisdc$plot(&wd_id, &atb_active, &x1, &y1, &x1, &y2, &x2, &y2, &x2, &y1,
	    &x1, &y1);
	}
	return(1);
}
/* first the basic UIS circle routine */
static do_circle(x, y, r, deg0, deg1, use_atb)
int x, y, r;	/* position of centre and radius */
float deg0, deg1;	/* beginning and ending degrees (start at top) */
unsigned int use_atb;
{
unsigned int mode;
float r_width, d0, d1, dif;


	/* UIS can only handle line width of 1 if not solid */
	if (gbl_style != ~0) {
	    r_width = 1.0;
	    mode = UIS$C_WIDTH_PIXELS;
	    uis$set_line_width(&vd_id, &use_atb, &use_atb, &r_width, &mode);
	}

	/* subtract 90 from each degree to move origin to UIS co-ords */

	if ((deg0 == 0.0) && (deg1 == 360.0)) {
	    d0 = 0.0;
	    d1 = 360.0;
	} else {
	    d1 = 90.0 - deg0;
	    d0 = 90.0 - deg1;
	}

	uisdc$circle(&wd_id, &use_atb, &x, &y, &r, &d0, &d1);
	return(1);
}
/* set  a Circle */
uis_circle(x, y, r)
int x, y, r;
{
unsigned int use_atb;
int want_edge;

	use_atb = atb_active + 1;
	want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);

	switch (pc5->int_style) {
	case hollow :	break;	/* don't try to fill these */
	case empty :	break;
	
	case pattern :		/* no pattern fill yet */
	case hatch :		/* no hatch fill yet */
	case solid_i :	set_fill(&pc5->fill_colour, &atb_active, &use_atb);
			do_circle(x, y, r, 0.0, 360.0, use_atb);
			break;
	}
	/* may want visible edge */
	if (want_edge){	
	    if (pc5->edge_vis == on) 
		set_colour(&pc5->edge_colour, &atb_active, &use_atb);
	    else set_colour(&pc5->fill_colour, &atb_active, &use_atb);
	    do_circle(x, y, r, 0.0, 360.0, use_atb);
	}
	return(1);
}

/* set an arc, we get the positions of 1st pt, intermediate pt, end pt */
/* see utils.c for details */
uis_c3(pt_ptr)
int *pt_ptr;
{
int xc, yc, r;		/* circle centre and radius */
float deg[3];		/* starting and ending degrees (0 at top) */
double theta[3];
extern get_c_info();	/* utils.c */
unsigned int use_atb;

	if (!get_c_info(pt_ptr, &xc, &yc, &r, theta, deg)) return(2);
	use_atb = atb_active + 1;
	set_colour(&pc5->line_colour, &atb_active, &use_atb); 

	return(do_circle(xc, yc, r, deg[0], deg[2], use_atb));
}
/* set  a closed arc, get the positions of 1st pt, intermdiate pt, end pt */
uis_c3_close(pt_ptr, chord)
int *pt_ptr;
enum boolean chord;
{
int x, y, r;		/* circle centre and radius */
float deg[3];		/* starting and ending degrees (0 at top) */
double theta[3];
extern get_c_info();	/* utils.c */
unsigned int use_atb, arc_type;
int want_edge;

	if (!get_c_info(pt_ptr, &x, &y, &r, theta, deg)) return(2);

	use_atb = atb_active + 1;
	arc_type = (chord) ? UIS$C_ARC_CHORD : UIS$C_ARC_PIE;
	want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);

	uis$set_arc_type(&vd_id, &atb_active, &use_atb, &arc_type);

	switch (pc5->int_style) {
	case hollow :	break;	/* don't try to fill these */
	case empty :	break;
	
	case pattern :		/* no pattern fill yet */
	case hatch :		/* no hatch fill yet */
	case solid_i :	set_fill(&pc5->fill_colour, &use_atb, &use_atb);
			do_circle(x, y, r, deg[0], deg[2], use_atb);
			break;
	}
	/* may want visible edge */
	if (want_edge){	
	    uis$set_arc_type(&vd_id, &atb_active, &use_atb, &arc_type);
	    if (pc5->edge_vis == on) 
		set_colour(&pc5->edge_colour, &use_atb, &use_atb);
	    else set_colour(&pc5->fill_colour, &use_atb, &use_atb);
	    do_circle(x, y, r, deg[0], deg[2], use_atb);
	}
	return(1);
}
/* set an arc, ends specified by vectors */
uis_c_centre(x, y, vec_array, r)
int x, y, *vec_array, r;
{
float deg0, deg1;
double theta;
extern get_angle();	/* utils.c */
unsigned int use_atb;

	get_angle(vec_array, &deg0, &theta);
	get_angle(vec_array + 2, &deg1, &theta);
	use_atb = atb_active + 1;
	set_colour(&pc5->line_colour, &atb_active, &use_atb); 

	return(do_circle(x, y, r, deg0, deg1, use_atb));
}
/* set an arc, ends specified by vectors, but close it */
uis_c_c_close(x, y, vec_array, r, chord)
int x, y, *vec_array, r;
enum boolean chord;
{
float deg0, deg1;
double theta;
extern get_angle();	/* utils.c */
unsigned int use_atb, arc_type;
int want_edge;

	get_angle(vec_array, &deg0, &theta);
	get_angle(vec_array + 2, &deg1, &theta);

	use_atb = atb_active + 1;
	arc_type = (chord) ? UIS$C_ARC_CHORD : UIS$C_ARC_PIE;
	want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);

	uis$set_arc_type(&vd_id, &atb_active, &use_atb, &arc_type);

	switch (pc5->int_style) {
	case hollow :	break;	/* don't try to fill these */
	case empty :	break;
	
	case pattern :		/* no pattern fill yet */
	case hatch :		/* no hatch fill yet */
	case solid_i :	set_fill(&pc5->fill_colour, &use_atb, &use_atb);
			do_circle(x, y, r, deg0, deg1, use_atb);
			break;
	}
	/* may want visible edge */
	if (want_edge){	
	    uis$set_arc_type(&vd_id, &atb_active, &use_atb, &arc_type);
	    if (pc5->edge_vis == on) 
		set_colour(&pc5->edge_colour, &use_atb, &use_atb);
	    else set_colour(&pc5->fill_colour, &use_atb, &use_atb);
	    do_circle(x, y, r, deg0, deg1, use_atb);
	}
	return(1);
}
/* first the basic UIS ellipse routine */
static do_ellipse(x, y, r, deg0, deg1)
int x, y, r;	/* position of centre and radius */
float *deg0, *deg1;	/* beginning and ending degrees (start at top) */
{
unsigned int c_atb, mode;
float r_width, d0, d1;

	c_atb = atb_active + 1;
	set_colour(&pc5->line_colour, &atb_active, &c_atb); 

	/* UIS can only handle line width of 1 if not solid */
	if (gbl_style != ~0) {
	    r_width = 1.0;
	    mode = UIS$C_WIDTH_PIXELS;
	    uis$set_line_width(&vd_id, &c_atb, &c_atb, &r_width, &mode);
	}

	d0 = *deg0;
	d1 = *deg1;
	while (d0 < 0.0) d0 += 360.0;
	while (d1 < 0.0) d1 += 360.0;

	uisdc$ellipse(&wd_id, &c_atb, &x, &y, &r, &d0, &d1);
	return(1);
}
/* set an ellipse, centre and two endpoints */
uis_ellipse(pt_array)
int *pt_array;
{

	return(1);
}
/* set an elliptical arc, centre, two endpoints, vectors for ends */
uis_ell_arc(pt_array, vec_array)
int *pt_array, *vec_array;
{

	return(1);
}
/* set an elliptical arc, close it */
uis_e_a_close(pt_array, vec_array, chord)
int *pt_array, *vec_array;
enum boolean chord;
{

	return(1);
}

/* set marker at a series of points, uis routines set at upper left corner */
uis_pmarker(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
register int i;
struct dsc$descriptor_s text;
unsigned int retwidth, retheight, pm_atb;
int x, y, x_adjust, y_adjust;

	pm_atb = atb_active + 1;
	set_colour(&pc5->mk_colour, &atb_active, &pm_atb);
	text.dsc$w_length 	= 1;
	text.dsc$a_pointer 	= c_mark + pc5->mk_type;
	text.dsc$b_class	= DSC$K_CLASS_S;
	text.dsc$b_dtype	= DSC$K_DTYPE_T;

	uisdc$measure_text(&wd_id, &atb_active, &text, &retwidth, &retheight,
	    0, 0, 0);

	switch (pc5->mk_type) {
case 1 : x_adjust = - 0.4 * retwidth; y_adjust = 0.9 * retheight; break;
case 2 : x_adjust = - 0.5 * retwidth; y_adjust = 0.7 * retheight; break;
case 3 : x_adjust = - 0.5 * retwidth; y_adjust = 0.55 * retheight; break;
case 4 : x_adjust = - 0.5 * retwidth; y_adjust = 0.77 * retheight; break;
case 5 : x_adjust = - 0.5 * retwidth; y_adjust = 0.77 * retheight; break;
default: fprintf(stderr, "illegal marker type ! = %d\n", (int) pc5->mk_type);
	   x_adjust = -retwidth / 2; y_adjust = retheight / 2; 
}

	for (i=0; i<no_pairs; ++i) {
	    x = x1_ptr[i] + x_adjust;
	    y = y1_ptr[i] + y_adjust;
	    uisdc$text(&wd_id, &pm_atb, &text, &x, &y, 0, 0);
	}
	return(1);
}
/* for cell arrays */
uis_carray(cp, cq, cr, nx, ny, col_prec, dat_ptr, rep_mode, no_bytes)
int *cp;	/* first corner */
int *cq;	/* the diagonal to cp p*/
int *cr;	/* first row is from cp to cr */
int nx;		/* number of elements in x rows (i.e., parallel to cp-cr) */
int ny;		/* number of rows */
int col_prec;	/* the colour precision (how many possible colour values */
unsigned char *dat_ptr;	/* pointer to the body of information */
int rep_mode;	/* the representation mode; 0, run length encoded, 1 normal */
int no_bytes;	/* number of data bytes */
{
unsigned carray_atb, mode;
unsigned char *bit_ptr = NULL, *new_ptr = NULL, *uis_ptr, *old_ptr;
unsigned int new_bytes, i, j, row_size, bdone, c_size, new_size;
static unsigned char bit1_flag[byte_size] = {128, 64, 32, 16, 8, 4, 2, 1};
static unsigned char bit2_flag[byte_size] = {1, 2, 4, 8, 16, 32, 64, 128};
unsigned int x1, x2, y1, y2;
#define lctab_size 2
static float lctab[3 * lctab_size] = {1.0, 1.0, 1.0, 0.0, 0.0, 0.0};
int out_flag;
int my_flag = 0;
int want_rmode = 1;
int want_cp;
int want_csmode = 0;
int new_nx, new_ny;
int bytes_needed, bits_row, bytes_row, first_index;
int px, py, qx, qy, rx, ry;	/* the contorted UIS co-ord system */

	px = cp[0];
	py = cq[1];
	qx = cr[0];
	qy = cr[1];
	rx = cq[0];
	ry = cp[1];
	carray_atb = atb_active + 1;
	want_cp = bits_pixel;
	first_index =  (pc2->c_s_mode == d_c_mode) ? 1 : 0;
	/* the rows and columns we need */
	new_nx = (rx > px) ? 1 + rx - px : 1 + px - rx;
	new_ny = (qy > py) ? 1 + qy - py : 1 + py - qy;
	
	bits_row = new_nx * bits_pixel;
	bytes_row = (bits_row + byte_size - 1) / byte_size;
	bytes_needed = bytes_row * new_ny;

	if (!(new_ptr = (unsigned char *) allocate_mem(bytes_needed, 1)))
	    return(2);

/* get the appropriate UIS coordinates */
	/* basically only need the bottom left hand corner, nx and ny */
	x1 = (cp[0] < cr[0]) ? cp[0] : cr[0];
	y1 = (cp[1] < cq[1]) ? cp[1] : cq[1];
	x2 = x1 + new_nx - 1;
	y2 = y1 + new_ny - 1;

	/* lets make the cell array fit */
	/* note that UIS wants rows from the top down */
	new_carray(NULL, nx, ny, col_prec, rep_mode, 
	    0, dat_ptr, no_bytes, pc2->c_s_mode,
	    pc5->ctab, pc1->max_c_index, px, py, qx, qy,
	    rx, ry, want_cp, want_rmode, bits_row, new_ptr, bytes_needed, 
	    want_csmode, lctab, lctab_size, my_flag, &out_flag, 
	    first_index, my_inds, &(pc1->c_v_extent));

	/* at this point we are sure of a normal cell array in cgm format;
	   (except no silly row padding to even no. of bytes)
	   we may need to repack it for the uis routine */
	/* to take care of all of the nasty problems that may arise,
	   we'll do this one bit at a time (ugh !) */
	bdone = 0;
	if (bits_pixel == 1) {
	    new_bytes = (bits_row * new_ny + byte_size - 1) / byte_size;
	    if (!(uis_ptr = allocate_mem(new_bytes, 1))) return(2);
	    row_size = (bits_row + byte_size - 1) / byte_size;
	    for (i=0; i < new_ny; ++i) {
	    	for (j=0; j < new_nx; ++j) {
		    old_ptr = new_ptr + row_size * i
		    	+ j / byte_size;
		    if (*old_ptr & bit1_flag[j % byte_size]){
		    	*(uis_ptr + bdone / byte_size) |= 
			    bit2_flag[bdone % byte_size];
		    }
		    ++bdone;
	    	}
	    }
	    mode = (back_grey > 0.5) ? UIS$C_MODE_COPY : UIS$C_MODE_COPYN;
	} else if (bits_pixel == 8) {	/* everything almost in shape */
	    uis_ptr = new_ptr;
	    if (pc2->c_s_mode == d_c_mode)
		for (i=0; i<new_nx*new_ny; ++i) uis_ptr[i] += base_index;
	    mode = UIS$C_MODE_COPY;	/* want the index */
	}
	uis$set_writing_mode(&vd_id, &atb_active, &carray_atb, &mode);
	uisdc$image(&wd_id, &carray_atb, &x1, &y1, &x2, &y2, &new_nx, &new_ny, 
	    &bits_pixel, uis_ptr);
	
	if (uis_ptr != new_ptr) (void) free(uis_ptr);
	(void) free(new_ptr);
	return(1);
}

/* set text, note that uis routines set the upper left corner */
uis_text(x, y, final, buffer)
int x, y, final;
char *buffer;
{
struct dsc$descriptor_s text;
unsigned int retwidth, retheight, text_atb;

	text_atb = atb_active + 1;
	set_colour(&pc5->text_colour, &atb_active, &text_atb);
	text.dsc$w_length 	= strlen(buffer);
	text.dsc$a_pointer 	= buffer;
	text.dsc$b_class	= DSC$K_CLASS_S;
	text.dsc$b_dtype	= DSC$K_DTYPE_T;

	uisdc$measure_text(&wd_id, &text_atb, &text, &retwidth, &retheight,
	    0, 0, 0);

	switch (pc5->text_align.hor) {
case normal_h:		break;
case left_h:		break;
case center_h:		x -= retwidth / 2; break;
case right_h:		x -= retwidth; break;
case cont_h:		break;
}
	switch (pc5->text_align.ver) {
case normal_v:		y += retheight; break;
case top_v:		break;
case cap_v:		y += retheight * 0.1; break;
case half_v:		y += retheight * 0.5; break;
case base_v:		y += retheight; break;
case bottom_v:		y += retheight * 1.1; break;
case cont_v:		break;
}

	uisdc$text(&wd_id, &text_atb, &text, &x, &y, 0, 0);
	return(1);

}
/* now set the attributes */
/* set the line type */
uis_l_type(l_type)
enum line_enum l_type;
{
unsigned int style;

#define pdash 255
#define pdd 63
#define pdot 3

	switch (l_type) {
case solid_l:	style = ~0; break;
case dash:	style = pdash + (pdash << 16);break;
case dot_l:	style = pdot + (pdot << 8) + (pdot << 16) + (pdot << 24);break;

case dash_dot:	style = pdash + (pdot << 12) + (pdash << 16) + (pdot << 28);
		break;

case dash_d_d:	style = pdd + (pdot << 8) + (pdot << 12) + (pdd << 16) + 
		(pdot << 24) + (pdot << 28); break;

default:	fprintf(stderr, "unknown line type [%d]!\n", l_type);
	}

	gbl_style = style;
	uis$set_line_style(&vd_id, &atb_active, &atb_active, &style);

	return(1);
}
#undef pdash
#undef pdd
#undef pdot
/* set the line width */
uis_l_width(l_width, rmul)
int l_width;
float rmul;
{
float r_width;
unsigned int mode;

	r_width = l_width;
	mode = 	UIS$C_WIDTH_PIXELS;
	uis$set_line_width(&vd_id, &atb_active, &atb_active, &r_width, &mode);

	return(1);
}
/* set the character height */
uis_cheight(size)
int size;
{

	uisdc$set_char_size(&wd_id, &atb_active, &atb_active, 0, 0, &size);
	return(1);
}
/* get a colour table here */
uis_ctab(beg_index, no_entries, ctab)
int beg_index, 	/* beginning index */
no_entries; 	/* number of entries to add starting at beg_index */
float *ctab;	/* direct colour array, *(ctab + i*3) is the red
		   entry for the i'th index, followed by g and b */
{

	if (pc2->c_s_mode != i_c_mode) return(2);
	if (maps && !set_uismap(ctab, beg_index, no_entries)) return(0);
	return(1);
}

/* set a font */
uis_font(index, size)
int index, size;
{
	
	return(1);
}
/* this is the routine that sets everything up */
/* the initialising routine for the uis module */
void uis_setup(opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl,
	gprim, attr, escfun, extfun, ctrl, pargc, argv)

struct one_opt 		*opt;	/* the command line options, in only */
struct info_struct *dev_info;	/* device info to fill out, out only */
struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
struct control_struct	*c3;	/* the class 3 elements, in only */
struct attrib_struct	*c5;	/* the class 5 elements, in only */
int (*delim[])();    		/* delimiter functions */
int (*mfdesc[])();     		/* metafile descriptor functions */
int (*pdesc[])();      		/* page descriptor functions */
int (*mfctrl[])();     		/* control functions */
int (*gprim[])();      		/* graphical primitives */
int (*attr[])();       		/* the attribute functions */
int (*escfun[])();     		/* the escape functions */
int (*extfun[])();     		/* the external functions */
int (*ctrl[])();       		/* external controller functions */
int *pargc;			/* argc pointer */
char **argv;			/* argv */	
{
#define prop_used 0.95	/* how much of the screen we will use */
	/* store the command line argument pointer */
	popt = opt;
	/* store the device info pointer */
	dptr = dev_info;
	/* store the CGM data structure pointers */
	pc1 = c1;
	pc2 = c2;
	pc3 = c3;
	pc5 = c5;

/* get the details of the workstation */
	uis$get_display_size(&devnam, &retwidth, &retheight, &retresolx,
	     &retresoly, &retpwidth, &retpheight);

	uis$get_hw_color_info(&devnam, &dev_type, &tot_indices, &colors,
	    &maps, &rbits, &gbits, &bbits, &ibits, &res_indices, &regen);

	/* how many colour map bits do we have ? */
	bits_pixel = ibits;
	/* operator may want some output */
	if (opt[debug].set) {
	    fprintf(stderr, 
	    "%s, %d indices, %d colours, %d map%s, (%d, %d, %d) colour bits\n", 
	    (dev_type == UIS$C_DEV_MONO) ? "monochrome" :
	    (dev_type == UIS$C_DEV_INTENSITY) ? "intensity" :
	    (dev_type == UIS$C_DEV_COLOR) ? "colour" : "unknown",
	    tot_indices, colors, maps, (maps > 1) ? "s" : "", rbits, gbits, bbits);
	    fprintf(stderr, 
	    "%d intensity bits, %d reserved indices, %s regeneration\n",
	    ibits, res_indices, 
	    (regen == UIS$C_DEV_RETRO) ? "retroactive" :
	    (regen == UIS$C_DEV_NONRETRO) ? "non-retroactive" :
	    "unknown");
	}
	max_uis_index = tot_indices - res_indices - 1;
	/* fill out the device info structure */
	dev_info->pxl_in 	= 100.0;	/* arbitrary decision */
	dev_info->ypxl_in 	= dev_info->pxl_in * retresoly / retresolx;
	dev_info->x_size 	= retpwidth * prop_used / dev_info->pxl_in;
	dev_info->y_size 	= retpheight * prop_used / dev_info->ypxl_in;
	dev_info->x_offset	= 0.0;	/* fix later */
	dev_info->y_offset	= 0.0;
	dev_info->c_height	= 12;
	dev_info->c_width	= 12;
	dev_info->d_l_width	= 1;				
	dev_info->d_e_width	= 1;				
	dev_info->d_m_size	= dev_info->c_height;	/* marker size */
	*dev_info->out_name	= '\0';		/* no output file */
	dev_info->capability	= /* stroke_text + char_text + */ string_text + 
				v_center + h_center;
	dev_info->rec_size	= 80;

	/* now fill out the function pointer arrays for CGM */
	/* the delimiter functions */
	delim[(int) B_Mf] 	= uis_begin;
	delim[(int) E_Mf]	= uis_end;
	delim[(int) B_Pic_Body]	= uis_bpage;
	delim[(int) E_Pic]	= uis_epage;

	/* the graphical primitives */
	gprim[(int) PolyLine]	= uis_pline;
	gprim[(int) Dis_Poly]	= uis_dpline;
	gprim[(int) PolyMarker]	= uis_pmarker;
	gprim[(int) Text]	= uis_text;
	gprim[(int) Polygon]	= uis_pgon;
	gprim[(int) Cell_Array]	= uis_carray; 
	gprim[(int) Rectangle]	= uis_rectangle;
	gprim[(int) Cgm_Circle]	= uis_circle;
	gprim[(int) Circ_3]	= uis_c3;
	gprim[(int) Circ_3_Close]	= uis_c3_close;
	gprim[(int) Circ_Centre]	= uis_c_centre;
	gprim[(int) Circ_C_Close]	= uis_c_c_close;
	gprim[(int) Ellipse]	= uis_ellipse;
	gprim[(int) Ellip_Arc]	= uis_ell_arc;
	gprim[(int) El_Arc_Close] 	= uis_e_a_close;

	/* the attributes */
	attr[(int) LType]	= uis_l_type;
	attr[(int) LWidth]	= uis_l_width;
	attr[(int) CHeight]	= uis_cheight;
	attr[(int) ColTab] = uis_ctab;

	state_level = -1;	/* just starting */
	return;
}
/* the colour routines */
set_uismap(ctab, ind1, no_entries)
float *ctab;
int ind1, no_entries;
{
int i = 0, j = 0;
#define no_colours 3
float *col_tab[no_colours];

	/* make sure everything is kosher */
	if ((ind1 + no_entries) > vcm_size)
	    no_entries = vcm_size - ind1;
	if (no_entries < 1) return(2);
	if (ind1 < 0) return(2);

	/* allocate the memory */
	for (i=0; i<no_colours; ++i) {
	    col_tab[i] = (float *) allocate_mem(sizeof(float) * no_entries, 0);
	    if (!col_tab[i]) {
		fprintf(stderr, "couldn't get memory for set_uismap !\n");
	    	return(0);
	    }
	}

	/* move over the info */
	for (i=0; i<no_entries; ++i) {
	    for (j=0; j<no_colours; ++j) {
		*(col_tab[j] + i) = *(ctab + i * 3 + j);
		if (col_tab[j][i] < 0.0) col_tab[j][i] = 0.0;
		if (col_tab[j][i] > 1.0) col_tab[j][i] = 1.0;
	    }
	}
  	uis$set_colors(&vd_id, &ind1, &no_entries, col_tab[0], 
	    col_tab[1], col_tab[2]);
	for (i=0; i<no_colours; ++i) free(col_tab[i]);
	return(1);
}
#undef no_colours

