/* SUNView module */
#include <suntool/sunview.h> 
#include <suntool/canvas.h>
#include <pixrect/pixrect_hs.h>
#ifdef min
#undef min
#endif
#ifdef max
#undef max
#endif
#include "defs.h"
#include <stdio.h>
#include <math.h>
#define byte_size 8
#define BASE_INDEX 0
/* store these pointers to allow lookups into the CGM data structures */
static struct one_opt 		*popt;	/* the command line options, in only */
static struct mf_d_struct 	*pc1;	/* the class 1 elements, in only */
static struct pic_d_struct 	*pc2;	/* the class 2 elements, in only */
static struct control_struct	*pc3;	/* the class 3 elements, in only */
static struct attrib_struct	*pc5;	/* the class 5 elements, in only */
static struct info_struct 	*dptr;	/* device info in and out */


/* these are the screen variables */
static int xw_size, yw_size;
Frame frame = NULL;
Canvas canvas = NULL;
Pixwin *pw = NULL, *frame_pw = NULL, *panel_pw = NULL; 
static unsigned int retpwidth, retpheight, no_controller = 0;
static float retwidth, retheight, retresolx, retresoly;
static unsigned int dev_type, tot_indices, colors, maps, rbits, gbits, bbits,
  ibits, res_indices, regen;
#define max_str 128
static char fname[max_str + 1];
static int fname_l;
static int state_level;
static unsigned int gbl_style = ~0;
static char file_buffer[max_str + 1], prog_buffer[max_str + 1];
extern char *allocate_mem();
static int no_colours;	/*  no. of colours */
static int max_val;	/* maximum colour value */
static int no_planes;
#define MAX_D_VAL 255		/* max direct colour value */
#define CMS_SIZE 256 
static unsigned char red_array[CMS_SIZE], green_array[CMS_SIZE], 
  blue_array[CMS_SIZE];
static unsigned char old_red[CMS_SIZE], old_green[CMS_SIZE], old_blue[CMS_SIZE];
/* macro to convert from unsigned char to integer colour value */
#define uchar_col(r_col) ((unsigned char) ((r_col) * MAX_D_VAL + 0.49999))
static struct rgbi_struct back_col;
static int my_inds[3];
static int set_colour();
char cmsname[20];
/* start everything up */
sv_begin(comment, file_name, prog_name)
     char *comment, *file_name, *prog_name;
     
{
  if (*file_name) {
    strncpy(file_buffer, file_name, max_str);
    file_buffer[max_str] = '\0';
  } else file_buffer[0] = '\0';
  if (*prog_name) {
    strncpy(prog_buffer, prog_name, max_str);
    prog_buffer[max_str] = '\0';
  } else prog_buffer[0] = '\0';
  return(1);
}
/* start a page  */
sv_bpage(pic_name, xoffset, yoffset, rotation, rb, gb, bb, page_no, 
	 xsize, ysize)
     char *pic_name;
     float rotation;
     int xoffset, yoffset, page_no, xsize, ysize;
     float rb, gb, bb;	/* background colour values */
{
  int i, j, k, no_to_do, c_index;
  long xorig, yorig, x2, y2;
  short red, green, blue;
  extern int get_cinds();
  float top0, top1, top2;
  /* take care of colours */
  if (pc2->c_s_mode == i_c_mode) {         /* indexed colour  */
    /* fill out the colour map  */
    no_to_do = ((pc1->max_c_index + BASE_INDEX) > max_val) ? max_val :
      pc1->max_c_index + BASE_INDEX;
    for (i=0; i < no_to_do; ++i) {
      red_array[i] = uchar_col(*(pc5->ctab + i * 3));
      green_array[i] = uchar_col(*(pc5->ctab + i * 3 + 1));
      blue_array[i] = uchar_col(*(pc5->ctab + i * 3 + 2));
    }
  } else { /* direct colour */
    get_cinds(no_colours - BASE_INDEX, my_inds);
    /* establish bounds */
    top0 = (my_inds[0] > 1) ? my_inds[0] - 1.0 : 1.0;
    top1 = (my_inds[1] > 1) ? my_inds[1] - 1.0 : 1.0;
    top2 = (my_inds[2] > 1) ? my_inds[2] - 1.0 : 1.0;
    
    for (i=0; i<my_inds[2]; ++i) {
      for (j=0; j<my_inds[1]; ++j) {
	for (k=0; k<my_inds[0]; ++k) {
	  c_index = (ind_ijk(my_inds, i, j, k) + BASE_INDEX);
	  red_array[c_index] =  (MAX_D_VAL * k) / top0;
	  green_array[c_index] =  (MAX_D_VAL * j) / top1;
	  blue_array[c_index] =  (MAX_D_VAL * i) / top2;
	}
      }
    }
    no_to_do = my_inds[0] * my_inds[1] * my_inds[2];
  } 
  /* try to keep as much of the original colour map as possible */
  for (i=no_to_do; i<no_colours; ++i) {
    red_array[i] = old_red[i];
    green_array[i] = old_green[i];
    blue_array[i] = old_blue[i];
  }
  window_set(canvas, CANVAS_RETAINED, FALSE, 0);
 /*  use unique name for cmsname to keep from interfering with
     other gplottools on the screen  */
  sprintf (cmsname, "test%d", getpid());
  pw_setcmsname(pw, cmsname);
/*  pw_setcmsname(pw, "test"); */
  pw_putcolormap(pw, 0, no_colours,
		 red_array,green_array,blue_array);
  window_set(canvas, CANVAS_RETAINED, TRUE, 0);
  /* set the background colour */
  back_col.ind = 0;
  back_col.red = rb;
  back_col.green = gb;
  back_col.blue = bb;
  
  c_index = set_colour(&back_col);
  pw_rop(pw, 0, 0, xw_size, yw_size, PIX_SRC | PIX_COLOR(c_index),
	 NULL, 0, 0);	
  
  return(1);
  
}
/* end a page */
sv_epage(copies)
     int copies;
{
  if (no_controller) { /* need to force display */
    notify_dispatch();
  }
    
  return(1);
}
/* end the metafile */
sv_end(pages_done)
     int pages_done;
{
  return(1);
}
/* plot a set of lines between alternate points */
sv_dpline(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  int i, c_index;
  struct pr_brush brush;
  
  /* set the line width */
  brush.width = pc5->line_width.i;
  c_index = set_colour(&pc5->line_colour);
  
  for (i=1; i<no_pairs; i+=2) {
    pw_line(pw, x1_ptr[i-1], yw_size-y1_ptr[i-1], x1_ptr[i], 
	    yw_size-y1_ptr[i], &brush, NULL, 
	    PIX_SRC | PIX_COLOR(c_index) );
  }
  
  return(1);
}
/* do line between a series of points */
sv_pline(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  int i, c_index;
  struct pr_brush brush;
  static struct pr_texture texture, *tex;
  extern short pr_tex_dotted[], pr_tex_dashed[], pr_tex_dashdot[],
  pr_tex_dashdotdotted[];
  
  /* set the line type */
  switch(pc5->line_type) {
  case solid_l: tex = NULL; break;
  case dash:	texture.pattern = pr_tex_dashed; tex = &texture; break;
  case dot_l:	texture.pattern = pr_tex_dotted; tex = &texture; break;
  case dash_dot:	texture.pattern = pr_tex_dashdot; tex = &texture; break;
  case dash_d_d:	texture.pattern = pr_tex_dashdotdotted; tex = &texture; break;
  default:	(void) fprintf(stderr, "illegal line type %d\n", 
			       pc5->line_type); break;
  }
  /* set the line width */
  brush.width = pc5->line_width.i;
  if (popt[(int) debug].set && (brush.width != 1))
    fprintf(stderr, "line width %d\n", brush.width);	
  c_index = set_colour(&pc5->line_colour);
  
  for (i=1; i<no_pairs; ++i) {
    pw_line(pw, x1_ptr[i-1], yw_size-y1_ptr[i-1], x1_ptr[i], 
	    yw_size-y1_ptr[i], &brush, tex, 
	    PIX_SRC | PIX_COLOR(c_index) );
  }
  
  return(1);
}

/* do a polygon, may want to fill it */
sv_pgon(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
#define MAX_VERTICES 256
  long my_vert[2];
  int i, want_edge, c_index;
  struct pr_pos *vlist;
  struct pr_brush brush;
  static struct pr_texture texture, *tex;
  extern short pr_tex_dotted[], pr_tex_dashed[], pr_tex_dashdot[],
  pr_tex_dashdotdotted[];
  
  /* set the edge type */
  switch(pc5->edge_type) {
  case solid_l: tex = NULL; break;
  case dash:	texture.pattern = pr_tex_dashed; tex = &texture; break;
  case dot_l:	texture.pattern = pr_tex_dotted; tex = &texture; break;
  case dash_dot:	texture.pattern = pr_tex_dashdot; tex = &texture; break;
  case dash_d_d:	texture.pattern = pr_tex_dashdotdotted; tex = &texture; break;
  default:	(void) fprintf(stderr, "illegal edge type %d\n", 
			       pc5->edge_type); break;
  }
  /* set the edge width */
  brush.width = pc5->edge_width.i;
  if ( no_pairs <= 1 ) return(1);
  if (no_pairs > MAX_VERTICES) no_pairs = MAX_VERTICES; /* for now */
  
  vlist = (struct pr_pos *) allocate_mem
    (no_pairs * sizeof(struct pr_pos), 0);	
  /* first do the polygon interior */
  switch (pc5->int_style) {
  case hollow :
  case empty :	c_index = 	set_colour(&back_col); break;
    
    
  case pattern :	
    /* no pattern fill yet */
  case hatch :	
    /* no hatch fill yet */
  case solid_i :	c_index =	set_colour(&pc5->fill_colour);
    break;
  }
  for (i=0; i<no_pairs; ++i) {
    vlist[i].x = x1_ptr[i];
    vlist[i].y = yw_size - y1_ptr[i];
  }
  /* draw the polygon */
  pw_polygon_2(pw, 0, 0, 1, &no_pairs, vlist, 
	       PIX_SRC | PIX_COLOR(c_index), NULL, 0, 0);
  
  
  /* may want visible edge */
  want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);
  if (want_edge){	
    if (pc5->edge_vis == on) c_index = set_colour(&pc5->edge_colour);
    else c_index = set_colour(&pc5->fill_colour);
    for (i=1; i<no_pairs; ++i) {
      pw_line(pw, x1_ptr[i-1], yw_size-y1_ptr[i-1], x1_ptr[i],
	      yw_size-y1_ptr[i], &brush, tex, PIX_SRC | PIX_COLOR(c_index) );
    }
  }
  free(vlist);
  return(1);
}
#undef MAX_VERTICES
/* do a rectangle */
sv_rectangle(x1, y1, x2, y2)
     int x1, x2, y1, y2;
{
  return(1);
}
/* first the basic circle routine */
static do_circle(x, y, r, deg0, deg1, use_atb)
     int x, y, r;	/* position of centre and radius */
     float deg0, deg1;	/* beginning and ending degrees (start at top) */
     unsigned int use_atb;
{
  return(1);
}
/* set  a Circle */
sv_circle(x, y, r)
     int x, y, r;
{
  return(1);
}

/* set an arc, we get the positions of 1st pt, intermediate pt, end pt */
/* see utils.c for details */
sv_c3(pt_ptr)
     int *pt_ptr;
{
  return(1);
}
/* set  a closed arc, get the positions of 1st pt, intermdiate pt, end pt */
sv_c3_close(pt_ptr, chord)
     int *pt_ptr;
     enum boolean chord;
{
  return(1);
}
/* set an arc, ends specified by vectors */
sv_c_centre(x, y, vec_array, r)
     int x, y, *vec_array, r;
{
  return(1);
}
/* set an arc, ends specified by vectors, but close it */
sv_c_c_close(x, y, vec_array, r, chord)
     int x, y, *vec_array, r;
     enum boolean chord;
{
  return(1);
}
/* first the basic  ellipse routine */
static do_ellipse(x, y, r, deg0, deg1)
     int x, y, r;	/* position of centre and radius */
     float *deg0, *deg1;	/* beginning and ending degrees (start at top) */
{
  return(1);
}
/* set an ellipse, centre and two endpoints */
sv_ellipse(pt_array)
     int *pt_array;
{
  
  return(1);
}
/* set an elliptical arc, centre, two endpoints, vectors for ends */
sv_ell_arc(pt_array, vec_array)
     int *pt_array, *vec_array;
{
  
  return(1);
}
/* set an elliptical arc, close it */
sv_e_a_close(pt_array, vec_array, chord)
     int *pt_array, *vec_array;
     enum boolean chord;
{
  
  return(1);
}

/* set marker at a series of points */
sv_pmarker(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  return(1);
}
/* for cell arrays */
sv_carray(cp, cq, cr, nx, ny, col_prec, dat_ptr, rep_mode, no_bytes)
     int *cp;	/* first corner */
     int *cq;	/* the diagonal to cp p*/
     int *cr;	/* first row is from cp to cr */
     int nx;		/* number of elements in x rows (i.e., parallel to cp-cr) */
     int ny;		/* number of rows */
     int col_prec;	/* the colour precision (how many possible colour values */
     unsigned char *dat_ptr;	/* pointer to the body of information */
     int rep_mode;	/* the representation mode; 0, run length encoded, 1 normal */
     int no_bytes;	/* number of data bytes */
{
  char *new_ptr;
  unsigned int new_bytes, i, j, row_size, bdone, c_size, new_size;
  int x1, x2, y1, y2;
  int dx, dy, dw, dh;
#define lctab_size 2
  static float lctab[3 * lctab_size] = {1.0, 1.0, 1.0, 0.0, 0.0, 0.0};
  int out_flag;
  int my_flag = 0;
  int want_rmode = 1;
  int want_cp;
  int want_csmode = 0;
  int new_nx, new_ny;
  int bytes_needed, bits_row, bytes_row, first_index;
  Pixrect *tmp;
  short *start;
  int px, py, qx, qy, rx, ry;	/* the inverted SUN co-ord system */
  
  px = cp[0];
  py = cq[1];
  qx = cr[0];
  qy = cr[1];
  rx = cq[0];
  ry = cp[1];
  want_cp = no_planes  /* bits per pixel */;
  first_index =  (pc2->c_s_mode == d_c_mode) ? 1 : 0;
  /* the rows and columns we need */
  new_nx = (rx > px) ? 1 + rx - px : 1 + px - rx;
  new_ny = (qy > py) ? 1 + qy - py : 1 + py - qy;
  
  
  /* get the appropriate SUN coordinates */
  /* basically only need the bottom left hand corner, nx and ny */
  x1 = (cp[0] < cr[0]) ? cp[0] : cr[0];
  y1 = (cp[1] < cq[1]) ? cp[1] : cq[1];
  x2 = x1 + new_nx - 1;
  y2 = y1 + new_ny - 1;
  
  /* get the top left-hand corner, width and height */           
  dx = x1;
  dy = yw_size - y2;
  dw = new_nx;
  dh = new_ny;
  
  /* create memory pixrect  */
  tmp = mem_create(dw, dh, no_planes);
  new_ptr = (char *) mpr_d(tmp)->md_image;
  /* how many bytes row (padded) ? */
  bytes_row = mpr_d(tmp)->md_linebytes;
  
  bits_row = 8 * bytes_row; 
  bytes_needed = bytes_row * new_ny;
  
  /* lets make the cell array fit */
  
  new_carray(NULL, nx, ny, col_prec, rep_mode, 
	     0, dat_ptr, no_bytes, pc2->c_s_mode,
	     pc5->ctab, pc1->max_c_index, px, py, qx, qy,
	     rx, ry, new_nx, new_ny, want_cp, want_rmode, 
	     bits_row, new_ptr, bytes_needed, 
	     want_csmode, lctab, lctab_size, my_flag, &out_flag, 
	     first_index, my_inds, &(pc1->c_v_extent));
  
  /* at this point we are sure of a normal cell array in cgm format; */
  /* everything almost in shape */
  
  /* write out the array */
  pw_rop(pw, dx, dy, dw, dh, PIX_SRC, tmp, 0, 0);
  
  pr_close(tmp);	
  return(1);
}
/* set text */
sv_text(x, y, final, buffer)
     int x, y, final;
     char *buffer;
{
  return(1);
  
}
/* now set the attributes */
/* set the character height */
sv_cheight(size)
     int size;
{
  
  return(1);
}
/* get a colour table here */
sv_ctab(beg_index, no_entries, ctab)
     int beg_index, 	/* beginning index */
       no_entries; 	/* number of entries to add starting at beg_index */
     float *ctab;	/* direct colour array, *(ctab + i*3) is the red
			   entry for the i'th index, followed by g and b */
{
  int i, top_index;
  
  if (pc2->c_s_mode != i_c_mode) return(2);
  /* fill out the colour map */
  top_index = beg_index + no_entries;
  top_index = ((top_index + BASE_INDEX) > no_colours) ? no_colours :
    top_index + BASE_INDEX;
  for (i=beg_index; i < top_index; ++i) {
    red_array[i] = uchar_col(*(ctab + i * 3));
    green_array[i] = uchar_col(*(ctab + i * 3 + 1));
    blue_array[i] = uchar_col(*(ctab + i * 3 + 2));
  }
  /* try to keep as much of the original colour map as possible */
  for (i=top_index; i<no_colours; ++i) {
    red_array[i] = old_red[i];
    green_array[i] = old_green[i];
    blue_array[i] = old_blue[i];
  }
  pw_putcolormap(pw, beg_index, top_index - beg_index,
		 red_array,green_array,blue_array); 
  return(1);
}

/* set a font */
sv_font(index, size)
     int index, size;
{
  
  return(1);
}
/* this is the routine that sets everything up */
/* the initialising routine for the SUN module */
void sv_setup(opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl,
	      gprim, attr, escfun, extfun, ctrl, pargc, argv)
     
     struct one_opt 		*opt;	/* the command line options, in only */
     struct info_struct *dev_info;	/* device info to fill out, out only */
     struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
     struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
     struct control_struct	*c3;	/* the class 3 elements, in only */
     struct attrib_struct	*c5;	/* the class 5 elements, in only */
     int (*delim[])(); 		/* delimiter functions */
     int (*mfdesc[])();		/* metafile descriptor functions */
     int (*pdesc[])(); 		/* page descriptor functions */
     int (*mfctrl[])();		/* control functions */
     int (*gprim[])(); 		/* graphical primitives */
     int (*attr[])();  		/* the attribute functions */
     int (*escfun[])();		/* the escape functions */
     int (*extfun[])();		/* the external functions */
     int (*ctrl[])();  		/* external controller functions */
     int *pargc;			/* argc pointer */
     char **argv;			/* argv */	
{
  int x_wanted, y_wanted, x_start, y_start;
  
  /* store the command line argument pointer */
  popt = opt;
  /* store the device info pointer */
  dptr = dev_info;
  /* store the CGM data structure pointers */
  pc1 = c1;
  pc2 = c2;
  pc3 = c3;
  pc5 = c5;
  
  /* fill out the device info structure */
  dev_info->pxl_in 	= 100.0;	/* arbitrary decision */
  dev_info->ypxl_in 	= 100.0;
  
  /* do we want a particular size or position ? */
  
  if (popt[(int) x_size].set && popt[(int) y_size].set) {
    x_wanted = popt[(int) x_size].val.r * dev_info->pxl_in;
    y_wanted = popt[(int) y_size].val.r * dev_info->ypxl_in;
  } else {
    x_wanted = y_wanted = 512;
  }
  if (!frame) { /* no window created */
    frame = window_create(NULL, FRAME,
			  FRAME_LABEL, "Gplot",
			  WIN_ERROR_MSG,  "Can't create a window.",
			  FRAME_ARGS, pargc, argv,
			  FRAME_INHERIT_COLORS, TRUE,
			  WIN_SHOW, TRUE,
			  0);
    /* make the canvas */
    canvas = window_create(frame, CANVAS,
			   WIN_X, 0,
			   WIN_WIDTH, x_wanted,
			   WIN_HEIGHT, y_wanted,
			   CANVAS_WIDTH, x_wanted,
			   CANVAS_HEIGHT, y_wanted,
			   0);
    /* make the pix window */
    pw = canvas_pixwin(canvas);
    /* fit the window */
    window_fit(frame);
    no_controller = 1;
  }
  
  
  /* get the details of the workstation */
  xw_size = (int) window_get(canvas, WIN_WIDTH);
  yw_size = (int) window_get(canvas, WIN_HEIGHT);
  no_planes = pw->pw_pixrect->pr_depth;
  no_colours = 1 << no_planes;
  max_val = no_colours - 1;
  if (max_val <BASE_INDEX) {
    fprintf(stderr, " no colours available !\n");
  }
  /* get the existing colour table */
  /*	pw_getcolormap(pw, 0, no_colours, old_red, old_green, old_blue); */
  old_red[max_val] = old_green[max_val] = old_blue[max_val] = 255;
  if (opt[(int) debug].set)
    
    {
      fprintf(stderr, "%d planes, window size = (%d,%d)\n",
	      no_planes, (int) xw_size, (int) yw_size);
    }
  dev_info->x_size 	= xw_size / dev_info->pxl_in;
  dev_info->y_size 	= yw_size / dev_info->ypxl_in;
  dev_info->x_offset	= 0.0;	/* fix later */
  dev_info->y_offset	= 0.0;
  dev_info->c_height	= 12;
  dev_info->c_width	= 12;
  dev_info->d_l_width	= 1;				
  dev_info->d_e_width	= 1;				
  dev_info->d_m_size	= dev_info->c_height;	/* marker size */
  *dev_info->out_name	= '\0';		/* no output file */
  dev_info->capability	= 0;	/* for now */
  
  	/* now fill out the function pointer arrays for CGM */
  /* the delimiter functions */
  delim[(int) B_Mf] 	= sv_begin;
  delim[(int) E_Mf]	= sv_end;
  delim[(int) B_Pic_Body]	= sv_bpage;
  delim[(int) E_Pic]	= sv_epage;
  
  /* the graphical primitives */
  gprim[(int) PolyLine]	= sv_pline;
  gprim[(int) Polygon]	= sv_pgon;
  gprim[(int) Cell_Array]	= sv_carray; 
  gprim[(int) Dis_Poly]	= sv_dpline;
  /*	gprim[(int) PolyMarker]	= sv_pmarker;
	gprim[(int) Text]	= sv_text;
	gprim[(int) Rectangle]	= sv_rectangle;
	gprim[(int) Cgm_Circle]	= sv_circle;
	gprim[(int) Circ_3]	= sv_c3;
	gprim[(int) Circ_3_Close]	= sv_c3_close;
	gprim[(int) Circ_Centre]	= sv_c_centre;
	gprim[(int) Circ_C_Close]	= sv_c_c_close;
	gprim[(int) Ellipse]	= sv_ellipse;
	gprim[(int) Ellip_Arc]	= sv_ell_arc;
	gprim[(int) El_Arc_Close] 	= sv_e_a_close;
	*/
  attr[(int) ColTab] 	= sv_ctab;
  return;
}
/* general colour index routine */
static int set_colour(cptr)
     struct rgbi_struct *cptr;
{
  int c;
  
  if (pc2->c_s_mode == i_c_mode) {	/* indexed */
    c =  (BASE_INDEX + cptr->ind); 
  }
  else if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
    c =  int_rgb(cptr->red, cptr->green, cptr->blue,
		 my_inds);
    c += BASE_INDEX;
  }
  return(c);
}
/* routine to handle canvas resizing */
void sv_resize(in_canvas, new_width, new_height)
     Canvas in_canvas;
     int new_width, new_height;
{
  if (!dptr) return;	/* not setup yet */
  
  xw_size = new_width;
  yw_size = new_height;
  
  dptr->x_size = xw_size / dptr->pxl_in;
  dptr->y_size = yw_size / dptr->ypxl_in;
  return;
}

