/* contains all of the caching code for GTEX (highly system dependent !!!) */
/* these are for VMS calls */
#include <stdio.h>
#include "defs.h"
#ifdef VMS
#include rms
#include ssdef
#include descrip	

/* now the RMS I/O stuff */
static int rms_status;
#define do_rms(rms_fun, rms_arg) rms_status = rms_fun(rms_arg);\
	if(rms_status != RMS$_NORMAL) {printf("\nerror in rms_fun");\
		lib$signal(rms_status);}
/* now the new caching code */
static char def_name[NAM$C_MAXRSS + 1] = "def.out";
extern int need_to_trim;
extern int chars_cached;
extern int replace;
static int cache_upper = 20000;	/* upper limit for cache size */
struct FAB cfb;
struct RAB crb;
struct XABKEY char_key, date_key;
struct XABFHC cxbfhc;
struct NAM cnb;

extern struct record_type crec;
#endif

/* show what we have in cache */
show_cache_file()
{
int time_now;
int total_bytes = 0;
int total_chars = 0;
#ifdef VMS
	time_now = time();
	crb.rab$l_ubf = &crec;
	crb.rab$b_rac = RAB$C_SEQ;
	crb.rab$b_krf = 1;
	do_rms(sys$rewind, &crb);
	fprintf(stderr, "\ncached characters sorted by date\n");
	fprintf(stderr, "format is [character i.d.], size in bytes, date entered\n");

	while ((rms_status = sys$get(&crb)) == RMS$_NORMAL){
	    fprintf(stderr, "[%-35s], %5d, %s", crec.c_id, crec.bytes,
		ctime(&(crec.date)));
	    ++total_chars;
	    total_bytes += crec.bytes;
	}
	fprintf(stderr, "%d total characters, %d total bytes of font definitions",
	    total_chars, total_bytes);

	if (rms_status != RMS$_EOF) lib$signal(rms_status);
#endif
	return(0);
}
/* cut the caching down if it got too big */
trim_cache_file(chars_laid_off)
{
int chars_deleted = 0;
int chars_to_go;
#ifdef VMS

	crb.rab$l_ubf = &crec;
	crb.rab$b_rac = RAB$C_SEQ;
	crb.rab$b_krf = 1;	/* date key */

	chars_to_go = chars_laid_off;
	do_rms(sys$rewind, &crb);
	while ( (chars_to_go > 0) && (sys$get(&crb) == RMS$_NORMAL)){
	    --chars_to_go;
	    do_rms(sys$delete, &crb);
	    ++chars_deleted;
	}
	if (debug) fprintf(stderr, ", %d characters deleted", chars_deleted);

/* note need this code if want to do more I/O */
/*	crb.rab$b_rac = RAB$C_KEY;
	crb.rab$b_krf = 0;
	do_rms(sys$rewind, &crb);

*/	
#endif
	return(1);
}
/* open the caching file */
index_open(file_name)
char *file_name;
{
static char tab_name[] = "LNM$FILE_DEV";
char trans_result[50];
int used, ret = 1;
#ifdef VMS
	/* initialize RMS stuff */

	cfb = cc$rms_fab;
	char_key = cc$rms_xabkey;
	date_key = cc$rms_xabkey;
	cxbfhc = cc$rms_xabfhc;
	cnb = cc$rms_nam;
	crb = cc$rms_rab;

	crb.rab$l_fab = &cfb;
	crb.rab$b_rac = RAB$C_KEY;		/* keyed file 		*/
	crb.rab$w_usz = sizeof crec;
	crb.rab$b_krf = 0;
	crb.rab$l_kbf = crec.c_id;
	crb.rab$b_ksz = key_str_l;
	crb.rab$b_mbf = 5;	/* try this no. of buffers */

	cfb.fab$l_fna = file_name;
	cfb.fab$b_fns = strlen(file_name);
	cfb.fab$l_xab = &char_key;
	cfb.fab$b_org = FAB$C_IDX;	/* indexed file 		*/
	cfb.fab$b_rfm = FAB$C_VAR;	/* variable record format 	*/
	cfb.fab$l_fop = FAB$M_CIF | FAB$M_OFP | FAB$M_DFW ;
	cfb.fab$w_mrs = sizeof crec;
	cfb.fab$b_rat = FAB$M_CR;	/* carriage return		*/
	cfb.fab$b_fac = FAB$M_DEL | FAB$M_UPD | FAB$M_GET | FAB$M_PUT;
	cfb.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRUPD | FAB$M_SHRGET 
	    | FAB$M_SHRPUT;
	cfb.fab$l_nam = &cnb;

	cnb.nam$l_esa = def_name;
	cnb.nam$b_ess = sizeof def_name - 1;

	char_key.xab$b_dtp = XAB$C_STG;	/* string key			*/
	char_key.xab$l_knm = "character key                   ";
					/* key name (32 char)		*/
	char_key.xab$w_pos0 = 0;		/* key position			*/
	char_key.xab$b_siz0 = key_str_l;		/* size of key in bytes		*/
	char_key.xab$b_ref = 0;
	char_key.xab$l_nxt = &date_key;

	date_key.xab$b_dtp = XAB$C_BN4;	/* integer key			*/
	date_key.xab$l_knm = "date key                        ";
					/* key name (32 char)		*/
	date_key.xab$w_pos0 = key_str_l;	/* key position			*/
	date_key.xab$b_flg = XAB$M_DUP | XAB$M_CHG;
	date_key.xab$b_ref = 1;
	date_key.xab$b_siz0 = 4;		/* size of key in bytes		*/
	date_key.xab$l_nxt = &cxbfhc;		/* header info */

	rms_status = sys$create(&cfb);
	def_name[cnb.nam$b_ess] = '\0';

	switch (rms_status) {
	    case RMS$_CREATED: 
		fprintf(stderr, "\ncreated cache file %s", def_name);
		break;
	    case RMS$_NORMAL: break;
	    case RMS$_FNF: fprintf(stderr, "\ncouldn't find file %s", def_name);
		return(0); break;
	    case RMS$_DNF: fprintf(stderr, "\ncouldn't find directory for %s",def_name);
		return(0); break;
	    default: lib$signal(rms_status); return(0);
	}


	/* connect file and record */
	
	rms_status = sys$connect(&crb);

/* now see if we need to trim the size of the cache file */
	if (translate("GTEX_CACHE_UPPER", tab_name, trans_result) &1)
	    sscanf(trans_result, "%d", &cache_upper);

	used = cxbfhc.xab$l_ebk - 1;

	need_to_trim = (used >= cache_upper);
	ret = rms_status;
#endif
	return(ret);

}
/* add a character description to the caching file */
add_char(record, size)
struct record_type *record;
int size;
{
int ret = 1;
#ifdef VMS

	crb.rab$l_rbf = record;
	crb.rab$w_rsz = size;

 	crb.rab$l_rop = RAB$M_RLK |	/* lock record while writing */
	    RAB$M_RAH |			/* read ahead */
	    RAB$M_WBH ;			/* write behind */
	if (replace) crb.rab$l_rop |= RAB$M_UIF;
	rms_status = sys$put(&crb);

	switch (rms_status) {
	case RMS$_NORMAL: ++chars_cached; break;
	case RMS$_OK_DUP: ++chars_cached; break;/* date key duplicate (O.K.) */
	case RMS$_RLK: break;		/* somebody else writing it */
	case RMS$_DUP: break;	/* primary key duplicate (assume was 
	    written by other process since checked) */
	default: lib$signal(rms_status); 
	}
	ret = rms_status;
#endif
	return(ret);
}	
/* get a character description from the caching file */
get_char(record)
struct record_type *record;
{
int ret = 1;
#ifdef VMS
	if (replace) return(0);	/* don't want to use it */
	crb.rab$l_ubf = record;
	rms_status = sys$get(&crb);
	ret =  (rms_status == RMS$_NORMAL) ? crb.rab$w_rsz : 0;
#endif
	return(ret);
}
/* make the correct key for the character */
make_key1(dev_type, local_name, orientation, char_no, buffer)
char *dev_type, *local_name, orientation, *buffer;
int char_no;
{
int i;
#ifdef VMS
	sprintf(buffer, "%s,%s,%c,%d,", dev_type, local_name,
	    orientation, char_no);
	for (i = strlen(buffer) + 1; i<key_str_l; ++i) *(buffer + i) = ' ';
#endif
	return(1);
}
/* close the cache file */
close_cache()
{
#ifdef VMS
	do_rms(sys$close, &cfb); 
#endif
	return(1);
}
