/* $Id: window2.c,v 2.3 89/09/20 17:01:51 mbp Exp $
 *
 * window2.c:
 *   This is the 2nd half of window.c; it is #included by window.c.
 *   Do not try to compile this separately!
 */

/************************************************************************
 *									*
 *		 P R I V A T E    P R O C E D U R E S			*
 *                                                                      *
 *	 Anything below here is for use only within this file           *
 ************************************************************************/

/************************************************************************
 *       PRIVATE PROCEDURES COMMON TO 2D VERSION AND 3D VERSION:        *
 ************************************************************************/

/*-----------------------------------------------------------------------
 * Function:	quit_button_proc
 * Description:	respond to quit button
 * Args:	(none)
 * Notes:	Causes gr_main_loop to return (after user confirmation).
 *		Normally this is the end of the program.
 */
static int
quit_button_proc()
{
  window_done(GR_base_frame);
}

/*-----------------------------------------------------------------------
 * Function:	button_event_proc
 * Description:	respond to a button in the control panel
 * Args  IN:	item: handle of button which received event
 *		event: the event
 * Notes:	Display's button's menu if appropriate
 */
static int
button_event_proc(item, event)
     Panel_item item;
     Event *event;
{
  /* If event is right mouse button going down, display button's menu */
  if ( (event_id(event)==MS_RIGHT) && (event_is_down(event)) ) {

    /* Buttons present in both 2D and 3D versions: */

    /* control panel buttons */
    if (item==help_button)
      menu_show(help_button_menu, GR_control_panel, event, 0);
    else if (item==print_button)
      menu_show(print_button_menu, GR_control_panel, event, 0);
    else if (item==quit_button)
      menu_show(quit_button_menu, GR_control_panel, event, 0);

    /* Buttons present in 3D version only: */
#ifdef THREE_D

    /* view control panel buttons: */
    else if (item==horizontal_pan_button)
      menu_show(horizontal_pan_button_menu, GR_view_control_panel, event, 0);
    else if (item==horizontal_sweep_button)
      menu_show(horizontal_sweep_button_menu, GR_view_control_panel, event, 0);
    else if (item==perspective_button)
      menu_show(perspective_button_menu, GR_view_control_panel, event, 0);
    else if (item==anim_button)
      menu_show(anim_button_menu, GR_view_control_panel, event, 0);
    else if (item==reset_button)
      menu_show(reset_button_menu, GR_view_control_panel, event, 0);
    else if (item==tilt_button)
      menu_show(tilt_button_menu, GR_view_control_panel, event, 0);
    else if (item==vertical_pan_button)
      menu_show(vertical_pan_button_menu, GR_view_control_panel, event, 0);
    else if (item==vertical_sweep_button)
      menu_show(vertical_sweep_button_menu, GR_view_control_panel, event, 0);
    else if (item==view_data_button)
      menu_show(view_data_button_menu, GR_view_control_panel, event, 0);
    else if (item==zoom_button)
      menu_show(zoom_button_menu, GR_view_control_panel, event, 0);
    else if (item==redraw_button)
      menu_show(redraw_button_menu, GR_view_control_panel, event, 0);

    /* view_data_panel buttons: */
    else if (item==view_data_redraw_button)
      menu_show(redraw_button_menu, view_data_panel, event, 0);

#endif /* End of 3D version buttons */

    /* Then move mouse cursor back to where it was before menu display */
    window_set((Panel)panel_get(item, PANEL_PARENT_PANEL),
	       WIN_MOUSE_XY, event_x(event), event_y(event),
	       0);
  }

  /* Otherwise, do the normal thing for this button */
  else
    panel_default_handle_event(item, event);
}

/*-----------------------------------------------------------------------
 * Function:	help_button_proc
 * Description:	respond to help button
 * Args:	(none)
 * Notes:	displays the help window
 */
static int
help_button_proc()
{
  GR_display_help_window();
}

/*-----------------------------------------------------------------------
 * Function:	canvas_event_proc
 * Description:	Handle an event which has occurred in the canvas
 * Args  IN:	window: canvas's handle
 *		*event: the event
 *		arg: ?????? (unused)
 * Returns:	success status
 */
static int
canvas_event_proc(window, event, arg)
     Window window;
     Event *event;
     caddr_t arg;
{
  int menu_opt;
  
  /* Make sure that an application menu is defined; (if none is, just
   * ignore all events) */
  if (GR_current_menu.title != NULL) {
    
    /* If the event was the right mouse button going down, */
    if ( (event_id(event) == MS_RIGHT) && (event_is_down(event)) ) {
      
      /* display the application menu and get option from user. */
      menu_opt = (int)menu_show(app_menu, window, event, 0);
      
      /* If number returned is >0, execute corresponding menu proc. */
      if (menu_opt>0) (*(GR_current_menu.list[menu_opt-1].proc))();
      
      /* (0 means user didn't pick an option, so don't do anything.) */
    }
  }
  
}

/*-----------------------------------------------------------------------
 * Function:	app_menu_operation
 * Description:	do an operation with the application menu
 * Args  IN:	m: the menu's handle
 *		operation: the operation to perform
 * Returns:	m
 */
static Menu
app_menu_operation(m, operation)
     Menu		m;
     Menu_generate	operation;
{
  int i;
  static int display_is_current_menu=0;
  
  switch (operation) {
  case MENU_DISPLAY:
    /* The menu is about to be displayed; set the entries to those of
     * the current menu, unless this has already been done for this
     * menu. */
    if (!display_is_current_menu) {
      menu_set(m, MENU_TITLE_ITEM, GR_current_menu.title, 0);
      for (i=0; i<GR_current_menu.nopts; ++i)
	menu_set(m, MENU_STRING_ITEM, GR_current_menu.list[i].string, i+1, 0);
      display_is_current_menu=1;
    }
    break;
  
  case MENU_DISPLAY_DONE:
  case MENU_NOTIFY:
    /* Don't do anything for these cases */
    break;
  
  case MENU_NOTIFY_DONE:
    /* We are finished with the menu for this round.
     * Destroy it and make a new one to be used next
     * time. */
    menu_destroy(m);
    m = menu_create(MENU_GEN_PROC, app_menu_operation, 0);
    display_is_current_menu=0;
    app_menu = m;
    break;
  }

  return(m);
}

/*-----------------------------------------------------------------------
 * Function:	process_ascii_event
 * Description:	Process an ascii event which occured while waiting for
 *		the user to type in a string.
 * Args  IN:	*event: the event to process
 * Returns:	1 if we're done (i.e. the event was a carriage return),
 *		0 otherwise
 */
static
process_ascii_event(event)
     Event *event;
{
#define CR		0x0d	/* <carriage return>	*/
#define DEL		0x7f	/* <del>		*/
#define BS		0x08	/* <ctrl>-h		*/
#define LINEKILL	0x15	/* <ctrl>-u		*/
#define DONE		1
#define NOT_DONE	0

   char *str, text_string[GR_INPUT_TEXT_LENGTH+1];
   int len;

   /* If this is not the event going down, do nothing */
   if (!event_is_down(event)) return(NOT_DONE);

   /* Get the current string from the application text item */
   str = (char *)panel_get (app_text, PANEL_VALUE);
   len = strlen (str);

   /* Copy it to our buffer */
   strcpy (text_string, str);

   /* Now act on the buffer according to what the event was */
   switch (event_id(event)) {

   case CR:			/* We are done reading */
     return(DONE);
     break;

   case BS:			/* backspace or delete */
   case DEL:
     if (len > 0) {
       text_string[len-1] = '\0';
     }
     break;

   case LINEKILL:		/* kill entire line */
     text_string[0]='\0';
     break;

   default:			/* just append the char */
     /* ... but first make sure there's room! */
     if (len < GR_INPUT_TEXT_LENGTH) {
       text_string[len] = (char)event_id(event);
       text_string[len+1] = '\0';
     }
     break;

   }

   /* Now redisplay the string, since it might have been modified */
   panel_set(app_text, PANEL_VALUE, text_string, 0 );

   return(NOT_DONE);

#undef CR
#undef DEL
#undef BS
#undef LINEKILL
#undef DONE
#undef NOT_DONE
}

/* -----------------------------------------------------------------------
 * Function:	interposer
 * Description:	interposition proc to clear error messages
 * Args:	(see SunView Programmer's Guide)
 * Notes:	This procedure is placed just ahead of (in the notification
 * 		sequence) the event procedure for every window in the
 * 		program (except the confirmer window) to do any
 * 		necessary preprocessing of events.  At present, it is
 * 		used just to clear any error messages which need to be
 * 		cleared from the error panel.
 */
static Notify_value
interposer(client, event, arg, type)
     Notify_client;
     Event *event;
     Notify_arg arg;
     Notify_event_type type;
{
  Notify_value value;

  /* If this is a mouse event, clear any error messages */
  switch (event_id(event)) {
  case MS_LEFT:
  case MS_MIDDLE:
  case MS_RIGHT:
    if (error_message_present) {
      if (!hold_error_message) {
	GR_message("");
	error_message_present = 0;
      }
      else
	--hold_error_message;
    }
    break;
  default:
    break;
  }

  /* proceed with normal notification */
  return( notify_next_event_func(client, event, arg, type) );
}

/*-----------------------------------------------------------------------
 * Function:	register_interposer_window
 * Description:	register our interposer (procedure "interposer" above)
 *		  for a window
 * Args  IN:	window: the window's handle
 * Notes:	This procedure does it for a single window.
 *		GR_register_interposer does it for a whole window tree.
 */
static int
register_interposer_window(window)
     Window window;
{
  notify_interpose_event_func(window, interposer, NOTIFY_SAFE);
}

/************************************************************************
 *	      PRIVATE PROCEDURES SPECIFIC TO 3D VERSION:                *
 ************************************************************************/

#ifdef THREE_D

static int
initialize_view_control_panel()
{
  int i;

  read_defaults();

  GR_view_control_panel =
     window_create(GR_base_frame, PANEL,
	WIN_X, 840,
	WIN_Y, 85,
	WIN_WIDTH, 150,
	WIN_HEIGHT, 692,
	WIN_FONT, GR_regular_font,
	0);
  if (GR_view_control_panel == NULL) goto BAD_WINDOW_ERROR;

  horizontal_sweep_button =
     panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		       PANEL_ITEM_X, 1,
		       PANEL_ITEM_Y, 1,
		       PANEL_LABEL_IMAGE, &horizontal_sweep_pr,
		       PANEL_EVENT_PROC, button_event_proc,
		       PANEL_NOTIFY_PROC, view_button_proc,
		       0);

  horizontal_sweep_button_menu =
    menu_create(MENU_STRINGS, "Horizontal Sweep", 0, 0);
  
  vertical_sweep_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 51,
		      PANEL_ITEM_Y, 1,
		      PANEL_LABEL_IMAGE, &vertical_sweep_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  vertical_sweep_button_menu =
    menu_create(MENU_STRINGS, "Vertical Sweep", 0, 0);
  
  tilt_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 101,
		      PANEL_ITEM_Y, 1,
		      PANEL_LABEL_IMAGE, &tilt_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  tilt_button_menu =
    menu_create(MENU_STRINGS, "Tilt", 0, 0);
  
  horizontal_pan_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 1,
		      PANEL_ITEM_Y, 50,
		      PANEL_LABEL_IMAGE, &horizontal_pan_pr,
		      PANEL_EVENT_PROC,  button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);

  horizontal_pan_button_menu =
    menu_create(MENU_STRINGS, "Horizontal Pan", 0, 0);
  
  vertical_pan_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 51,
		      PANEL_ITEM_Y, 50,
		      PANEL_LABEL_IMAGE, &vertical_pan_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  vertical_pan_button_menu =
    menu_create(MENU_STRINGS, "Vertical Pan", 0, 0);
  
  perspective_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 101,
		      PANEL_ITEM_Y, 50,
		      PANEL_LABEL_IMAGE, &perspective_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  perspective_button_menu =
    menu_create(MENU_STRINGS, "Perspective", 0, 0);
  
  zoom_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 1,
		      PANEL_ITEM_Y, 99,
		      PANEL_LABEL_IMAGE, &zoom_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  zoom_button_menu =
    menu_create(MENU_STRINGS, "Zoom", 0, 0);
  
  redraw_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 51,
		      PANEL_ITEM_Y, 99,
		      PANEL_LABEL_IMAGE, &redraw_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  redraw_button_menu =
    menu_create(MENU_STRINGS, "Redraw", 0,0);
  
  reset_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 101,
		      PANEL_ITEM_Y, 99,
		      PANEL_LABEL_IMAGE, &reset_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  reset_button_menu =
    menu_create(MENU_STRINGS, "Reset", 0, 0);
  
  anim_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 51,
		      PANEL_ITEM_Y, 148,
		      PANEL_LABEL_IMAGE, &anim_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, anim_button_proc,
		      0);
  
  anim_button_menu =
    menu_create(MENU_STRINGS, "Animation", 0, 0);
  
  view_data_button =
    panel_create_item(GR_view_control_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 1,
		      PANEL_ITEM_Y, 148,
		      PANEL_LABEL_IMAGE, &view_data_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_data_button_proc,
		      0);
  
  view_data_button_menu =
    menu_create(MENU_STRINGS, "Viewing Transformation", 0, 0);
  
  rotation_angle_slider =
    panel_create_item(GR_view_control_panel, PANEL_SLIDER, 
		      PANEL_ITEM_X, 14,
		      PANEL_ITEM_Y, 234,
		      PANEL_VALUE, GR_rotation_angle_slider_value,
		      PANEL_SLIDER_WIDTH, 120, 
		      PANEL_MIN_VALUE, 0, 
		      PANEL_MAX_VALUE, 360, 
		      PANEL_SHOW_RANGE, FALSE,
		      PANEL_SHOW_VALUE, FALSE,
		      PANEL_NOTIFY_LEVEL, PANEL_ALL,
		      PANEL_NOTIFY_PROC, rotation_angle_slider_proc,
		      0);
  
  rotation_angle_label =
    panel_create_item(GR_view_control_panel, PANEL_MESSAGE,
		      PANEL_ITEM_X, 22,
		      PANEL_ITEM_Y, 216,
		      PANEL_LABEL_STRING, "Rotation Angle",
		      0);
  
  rotation_angle_value =
    panel_create_item(GR_view_control_panel, PANEL_MESSAGE,
		      PANEL_ITEM_X, 55,
		      PANEL_ITEM_Y, 254,
		      PANEL_LABEL_STRING,
		      	rotation_angle_string(GR_rotation_angle_slider_value),
		      0);
  
  zoom_factor_slider =
    panel_create_item(GR_view_control_panel, PANEL_SLIDER, 
		      PANEL_ITEM_X, 14,
		      PANEL_ITEM_Y, 303,
		      PANEL_VALUE, GR_zoom_factor_slider_value,
		      PANEL_SLIDER_WIDTH, 120, 
		      PANEL_MIN_VALUE, 10, 
		      PANEL_MAX_VALUE, 20, 
		      PANEL_SHOW_RANGE, FALSE,
		      PANEL_SHOW_VALUE, FALSE,
		      PANEL_NOTIFY_LEVEL, PANEL_ALL,
		      PANEL_NOTIFY_PROC, zoom_factor_slider_proc,
		      0);

  zoom_factor_label =
    panel_create_item(GR_view_control_panel, PANEL_MESSAGE,
		      PANEL_ITEM_X, 37,
		      PANEL_ITEM_Y, 285,
		      PANEL_LABEL_STRING, "Zoom Factor",
		      0);
  
  zoom_factor_value =
    panel_create_item(GR_view_control_panel, PANEL_MESSAGE,
		      PANEL_ITEM_X, 55,
		      PANEL_ITEM_Y, 323,
		      PANEL_LABEL_STRING,
		      	zoom_factor_string(GR_zoom_factor_slider_value),
		      0);
  
  perspective_factor_slider =
    panel_create_item(GR_view_control_panel, PANEL_SLIDER, 
		      PANEL_ITEM_X, 14,
		      PANEL_ITEM_Y, 377,
		      PANEL_VALUE, GR_perspective_factor_slider_value,
		      PANEL_SLIDER_WIDTH, 120, 
		      PANEL_MIN_VALUE, 10, 
		      PANEL_MAX_VALUE, 20, 
		      PANEL_SHOW_RANGE, FALSE,
		      PANEL_SHOW_VALUE, FALSE,
		      PANEL_NOTIFY_LEVEL, PANEL_ALL,
		      PANEL_NOTIFY_PROC, perspective_factor_slider_proc,
		      0);
  
  perspective_factor_label =
    panel_create_item(GR_view_control_panel, PANEL_MESSAGE,
		      PANEL_ITEM_X, 3,
		      PANEL_ITEM_Y, 359,
		      PANEL_LABEL_STRING, "Perspective Factor",
		      0);
  
  perspective_factor_value =
    panel_create_item(GR_view_control_panel, PANEL_MESSAGE,
		      PANEL_ITEM_X, 55,
		      PANEL_ITEM_Y, 397,
		      PANEL_LABEL_STRING,
		 perspective_factor_string(GR_perspective_factor_slider_value),
		      0);

  drawing_mode_cycle =
    panel_create_item(GR_view_control_panel, PANEL_CYCLE, 
		      PANEL_ITEM_X, 22,
		      PANEL_ITEM_Y, 435,
		      PANEL_LAYOUT, PANEL_VERTICAL,
		      PANEL_LABEL_STRING, "Drawing Mode:",
		      PANEL_CHOICE_STRINGS,
		        "Continuous", /* panel_value = 0 */
		        "Batch",      /* panel_value = 1 */
		        0,
		      PANEL_NOTIFY_PROC, drawing_mode_cycle_proc,
		      PANEL_VALUE, GR_drawing_mode_value,
		      0);
  gr_set_batch_mode(GR_drawing_mode_value==1);
  
  for (i=0; i<4; ++i) {
    view_control_panel_message[i] =
      panel_create_item(GR_view_control_panel, PANEL_MESSAGE, 
			PANEL_ITEM_X, view_control_panel_message_x[i],
			PANEL_ITEM_Y, view_control_panel_message_y[i],
			PANEL_LABEL_STRING, "",
			PANEL_LABEL_FONT, GR_bold_font,
			0);
  }

  view_data_frame =
    window_create(GR_base_frame, FRAME,
		  WIN_FONT, GR_regular_font,
		  WIN_X, 587,
		  WIN_Y, 618,
		  WIN_WIDTH, 411,
		  WIN_HEIGHT, 180,
		  FRAME_LABEL, "Viewing Transformation",
		  FRAME_SHOW_LABEL, TRUE,
		  0);
  if (view_data_frame == NULL) goto BAD_WINDOW_ERROR;
  
  view_data_panel =
    window_create(view_data_frame, PANEL,
		  WIN_X, 0,
		  WIN_Y, 0,
		  WIN_FONT, GR_regular_font,
		  0);
  if (view_data_panel == NULL) goto BAD_WINDOW_ERROR;
  
  eye_text =
    panel_create_item(view_data_panel, PANEL_TEXT, 
		      PANEL_ITEM_X, 15,
		      PANEL_ITEM_Y, 10,
		      PANEL_VALUE_DISPLAY_LENGTH, VIEW_DATA_TEXT_LENGTH,
		      PANEL_LABEL_STRING, "Eye:",
		      0);

  focus_text =
    panel_create_item(view_data_panel, PANEL_TEXT, 
		      PANEL_ITEM_X, 15,
		      PANEL_ITEM_Y, 34,
		      PANEL_VALUE_DISPLAY_LENGTH, VIEW_DATA_TEXT_LENGTH,
		      PANEL_LABEL_STRING, "Focus:",
		      0);
  
  up_text =
    panel_create_item(view_data_panel, PANEL_TEXT, 
		      PANEL_ITEM_X, 15,
		      PANEL_ITEM_Y, 58,
		      PANEL_VALUE_DISPLAY_LENGTH, VIEW_DATA_TEXT_LENGTH,
		      PANEL_LABEL_STRING, "Up:",
		      0);
  
  vpw_message =
    panel_create_item(view_data_panel, PANEL_MESSAGE, 
		      PANEL_ITEM_X, 15,
		      PANEL_ITEM_Y, 82,
		      PANEL_LABEL_STRING, "View Plane Window:",
		      0);
  
  vpw_horizontal_text =
    panel_create_item(view_data_panel, PANEL_TEXT, 
		      PANEL_ITEM_X, 30,
		      PANEL_ITEM_Y, 106,
		      PANEL_VALUE_DISPLAY_LENGTH, VIEW_DATA_TEXT_LENGTH,
		      PANEL_LABEL_STRING, "Horizontal:",
		      0);
  
  vpw_vertical_text =
    panel_create_item(view_data_panel, PANEL_TEXT, 
		      PANEL_ITEM_X, 30,
		      PANEL_ITEM_Y, 130,
		      PANEL_VALUE_DISPLAY_LENGTH, VIEW_DATA_TEXT_LENGTH,
		      PANEL_LABEL_STRING, "Vertical:",
		      0);
  
  view_data_done_button =
    panel_create_item(view_data_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 343,
		      PANEL_ITEM_Y, 9,
		      PANEL_LABEL_IMAGE,
		      	panel_button_image(view_data_panel, "Done", 3, 0),
		      PANEL_NOTIFY_PROC, view_data_done_button_proc,
		      0);
  
  view_data_redraw_button =
    panel_create_item(view_data_panel, PANEL_BUTTON, 
		      PANEL_ITEM_X, 341,
		      PANEL_ITEM_Y, 41,
		      PANEL_LABEL_IMAGE, &redraw_pr,
		      PANEL_EVENT_PROC, button_event_proc,
		      PANEL_NOTIFY_PROC, view_button_proc,
		      0);
  
  redraw_button_menu =
    menu_create(MENU_STRINGS, "Redraw", 0, 0);
  return(0);

  BAD_WINDOW_ERROR:
  GR_error("Can't create any more windows !");
  return(1);

}

/*-----------------------------------------------------------------------
 * Function:	view_data_button_proc
 * Description:	respond to view_data button
 * Args:	(none)
 * Notes:	Turns on view data frame
 */
static int
view_data_button_proc()
{
  window_set( view_data_frame, WIN_SHOW, TRUE, 0 );
}

/*-----------------------------------------------------------------------
 * Function:	view_data_done_button
 * Description:	respond to view data frames 'done' button
 * Args:	(none)
 * Notes:	Closes the view data frame
 */
static int
view_data_done_button_proc()
{
  window_set( view_data_frame, WIN_SHOW, FALSE, 0 );
}

/*-----------------------------------------------------------------------
 * Function:	rotation_angle_slider_proc
 * Description:	respond to change in value of rotation angle slider
 * Args  IN:	item: slider's handle
 *		value: new value for slider
 *		event: the event which caused the value change
 * Notes:	This updates the display of the slider value and
 *		stores the new value in the static global variable
 *		GR_rotation_angle_slider_value.
 */
static int
rotation_angle_slider_proc(item, value, event)
     Panel_item item;
     int value;
     Event *event;
{
  panel_set(rotation_angle_value,
	    PANEL_LABEL_STRING, 
	      rotation_angle_string(GR_rotation_angle_slider_value=value),
	    0);
}

/*-----------------------------------------------------------------------
 * Function:	zoom_factor_slider_proc
 * Description:	respond to change in value of zoom factor slider
 * Args  IN:	item: slider's handle
 *		value: new value for slider
 *		event: the event which caused the value change
 * Notes:	This updates the display of the slider value and
 *		stores the new value in the static global variable
 *		GR_zoom_factor_slider_value.
 */
static int
zoom_factor_slider_proc(item, value, event)
     Panel_item item;
     int value;
     Event *event;
{
  panel_set(zoom_factor_value,
	    PANEL_LABEL_STRING, 
	      zoom_factor_string(GR_zoom_factor_slider_value=value),
	    0);
}

/*-----------------------------------------------------------------------
 * Function:	perspective_factor_slider_proc
 * Description:	respond to change in value of perspective factor slider
 * Args  IN:	item: slider's handle
 *		value: new value for slider
 *		event: the event which caused the value change
 * Notes:	This updates the display of the slider value and
 *		stores the new value in the static global variable
 *		GR_perspective_factor_slider_value.
 */
static int
perspective_factor_slider_proc(item, value, event)
     Panel_item item;
     int value;
     Event *event;
{
  panel_set(perspective_factor_value,
	    PANEL_LABEL_STRING, 
	      perspective_factor_string(GR_perspective_factor_slider_value=value),
	    0);
}

/*-----------------------------------------------------------------------
 * Function:	rotation_angle_string
 * Description:	format a string for displaying the rotation angle
 * Args  IN:	value: integer value of rotation angle slider
 * Returns:	pointer to formatting string
 */
static char *
rotation_angle_string(value)
     int value;
{
  static char buf[10];

  sprintf(buf, "[%3d]",
	(int)SLIDER_VALUE_TO_ROTATION_ANGLE(GR_rotation_angle_slider_value));
  return(buf);
}

/*-----------------------------------------------------------------------
 * Function:	zoom_factor_string
 * Description:	format a string for displaying the zoom factor
 * Args  IN:	value: integer value of zoom factor slider
 * Returns:	pointer to formatting string
 */
static char *
zoom_factor_string(value)
     int value;
{
  static char buf[10];

  sprintf(buf, "[%3.1f]",
	  SLIDER_VALUE_TO_ZOOM_FACTOR(GR_zoom_factor_slider_value));
  return(buf);
}

/*-----------------------------------------------------------------------
 * Function:	perspective_factor_string
 * Description:	format a string for displaying the perspective factor
 * Args  IN:	value: integer value of perspective factor slider
 * Returns:	pointer to formatting string
 */
static char *
perspective_factor_string(value)
     int value;
{
  static char buf[10];

  sprintf(buf, "[%3.1f]",
	  SLIDER_VALUE_TO_ZOOM_FACTOR(GR_perspective_factor_slider_value));
  return(buf);
}

static int
drawing_mode_cycle_proc()
{
  int batching;

  batching = ((int)panel_get_value(drawing_mode_cycle) == 1);
  gr_set_batch_mode(batching);
}

static int
view_button_proc(item, event)
     Panel_item item;
     Event *event;
{
  int sign, frame;
  char msg[GR_ANIM_MESSAGE_LENGTH+1];

  if (GR_recording_trigger) {
    GR_recording_trigger=0;
    GR_interrupted=0;
    GR_anim_message_clear();
    GR_show_error_message("Hit the STOP key (L1) to interrupt the filming");
    for (frame=0;
	 ((frame<GR_recording_count) && (!GR_interrupted));
	 ++frame) {
      GR_save_frame();
      sprintf(msg,"Saved Frame %2d", frame+1);
      GR_show_anim_message(msg,0);
      if (!GR_interrupted) view_button_proc(item, event);
    }
    GR_anim_message_clear();
    GR_show_error_message("");
    if (GR_interrupted) {
      sprintf(msg,"Recording stoped after %1d frames", frame);
      GR_show_anim_message(msg,1);
    }
    else {
      sprintf(msg,"%1d frames saved", GR_recording_count);
      GR_show_anim_message(msg,0);
    }
    return;
  }

  sign = event_shift_is_down(event) ? -1 : 1;

  if (item == vertical_sweep_button)
    gr_vertical_sweep(sign * 
	      SLIDER_VALUE_TO_ROTATION_ANGLE(GR_rotation_angle_slider_value));

  else if (item == horizontal_sweep_button)
    gr_horizontal_sweep(sign *
	      SLIDER_VALUE_TO_ROTATION_ANGLE(GR_rotation_angle_slider_value));

  else if (item == vertical_pan_button)
    gr_vertical_pan(sign * GR_pan_factor *
	      SLIDER_VALUE_TO_ROTATION_ANGLE(GR_rotation_angle_slider_value));

  else if (item == horizontal_pan_button)
    gr_horizontal_pan(sign * GR_pan_factor *
	      SLIDER_VALUE_TO_ROTATION_ANGLE(GR_rotation_angle_slider_value));

  else if (item == tilt_button)
    gr_tilt(sign *
	      SLIDER_VALUE_TO_ROTATION_ANGLE(GR_rotation_angle_slider_value));

  else if (item == zoom_button)
    gr_zoom(sign == 1
	    ? SLIDER_VALUE_TO_ZOOM_FACTOR(GR_zoom_factor_slider_value)
	    : 1/SLIDER_VALUE_TO_ZOOM_FACTOR(GR_zoom_factor_slider_value));

  else if (item == perspective_button)
    gr_perspective(sign == 1
    ? SLIDER_VALUE_TO_PERSPECTIVE_FACTOR(GR_perspective_factor_slider_value)
    : 1/SLIDER_VALUE_TO_PERSPECTIVE_FACTOR(GR_perspective_factor_slider_value));

  else if (item == reset_button)
    gr_reset();
  else if ( (item == redraw_button) || (item == view_data_redraw_button) )
    gr_redraw();
  else
    GR_error("Unknown button event !");
}

static int
  anim_button_proc()
{
  GR_show_anim_frame();
}

static int
  read_defaults()
{
  char current[80], *cval, buf[10];
  double dval;
  int ival, i;

  sprintf(current, "%s",
	  (GR_drawing_mode_value == 0) ? "Continuous" : "Batch");
  cval = defaults_get_string("/LGD/DrawingMode", current, 0);
  GR_drawing_mode_value = (strcmp(cval, "Batch") == 0);
  
  sprintf(current, "%1d", GR_rotation_angle_slider_value);
  ival = atoi(defaults_get_string("/LGD/RotationAngle", current, 0));
  if ((ival >= 0) && (ival <= 360))
    GR_rotation_angle_slider_value = ival;

  sprintf(current, "%f", ((double)GR_zoom_factor_slider_value)/10.0);
  dval = atof(defaults_get_string("/LGD/ZoomFactor", current, 0));
  if ((dval >= 1.0) && (dval <= 2.0))
    GR_zoom_factor_slider_value = (int)(10*dval+.5);

  sprintf(current, "%f", ((double)GR_perspective_factor_slider_value)/10.0);
  dval = atof(defaults_get_string("/LGD/PerspectiveFactor", current, 0));
  if ((dval >= 1.0) && (dval <= 2.0))
    GR_perspective_factor_slider_value = (int)(10*dval+.5);

  sprintf(current, "%f", GR_pan_factor);
  GR_pan_factor =
    atof(defaults_get_string("/LGD/PanFactor", current, 0));

  current[0] = '\0';
  for (i=0; i<GR_point_list_count; ++i)
    strcat(current,sprintf(buf," %1d %1d",
			   GR_point_list[2*i],
			   GR_point_list[2*i+1]));
  cval = defaults_get_string("/LGD/PointList", current, 0);
  interpret_point_list_string(cval);
}

/*-----------------------------------------------------------------------
 * Function:	interpret_point_list_string
 * Description:	interpret a character string representing a list of
 *		  pixels to plot when plotting points, and set the
 *		  global variables GR_point_list and GR_point_list_count
 *		  accordingly.
 * Args  IN:	s: the string to interpret
 * Returns:	nothing
 */
static int
  interpret_point_list_string(s)
char *s;
{
  char *x, *y, string[80], *seps = " ,";
  int i, list[80], done;

  /* Make a private copy of s to work with */
  strcpy(string, s);

  GR_point_list_count = 0;
  done = 0;
  x = strtok(string, seps);
  y = strtok(NULL, seps);
  if ((x == NULL) || (y == NULL))
    done = 1;
  else {
    list[2*GR_point_list_count] = atoi(x);
    list[2*GR_point_list_count+1] = atoi(y);
  }
  while (!done) {
    ++GR_point_list_count;
    x = strtok(NULL, seps);
    y = strtok(NULL, seps);
    if ((x == NULL) || (y == NULL))
      done = 1;
    else {
      list[2*GR_point_list_count] = atoi(x);
      list[2*GR_point_list_count+1] = atoi(y);
    }
  }
  GR_point_list = (int*)malloc(2*GR_point_list_count*sizeof(int));
  for (i=0; i<GR_point_list_count; ++i) {
    GR_point_list[2*i] = list[2*i];
    GR_point_list[2*i+1] = list[2*i+1];
  }
}

#endif /* End of private 3D version procedures */
