#include	"extern.h"

/* these functions solve the newton linear system (first partial derivatives)*radii = curvature. */

getkappa (ccnum, s,m,i,j,b)		/* Returns the curvature determined by the radii s.	*/
double 		*s;		/* The neighboring radii */
int 		*ccnum;		/* The neighboring cnum indices */
int	m;			/* The number of neighbors */
int	i, j;			/* The position of the central circle in the circleinfo arrays, or (0,0) if a hole */
int 	b;			/* The index of the hole if the central circle is a hole, otherwise -1 */
{
	double 		phisum, d0phisum, d1phisum, r0, r1, r2, r3;
	int 		k, n, rownum, colnum;
	double		r0r1, r0r2, r1r2, targ;

	int		rownorm, colcount, tempj, pivot;
	rowpartial	arow;

	pivot = j+i*width;
	if (pivot != 0)	{	/* Computing at a circle in the region */
		rownum = DCirc[pivot].cnum;
		r0 = DCirc[pivot].r;
	}
	else	{	/* Computing at a hole in the region */
		rownum = DHole[b].cnum;
		r0 = DHole[b].r;
	}

	colcount = 0;
	rownorm = 0;
	/* If ccnum is nonzero and less than maxvars, the corresponding radius is variable */
	for (k=0; k<m; ++k) 
		if ((ccnum[k] != 0) && (abs(ccnum[k])<maxvars))	 ++rownorm;
	++rownorm;

	for (k=0; k<m; ++k) {
		/* Get three consecutive neighboring radii */
		r1 = s[k];
		r2 = s[(k+1)%m];
		r3 = s[(k-1+m)%m];

		if ((bdrymode == THURSTONMODE)	
		&& ((DCirc[pivot].state > DEEPINSIDE) || (pivot == 0)))	{
		/* Some circles might intersect; compute triangle of circle centers */

			double		capa, capb, capc, capu, capv, capw, phi01, phi02, phi12;
			double		r0r0, r1r1, r2r2, t01, t02, t12;
			double		dudr0, dvdr0, dwdr0, dudr1, dwdr1, dvdr2, dwdr2;
			int		cnum0, cnum1, cnum2, cnum3;
			double		capuu, capvv, capww, capy, phi03, phi13;
			double		r3r3, r0r3, r1r3, t03, t13;
			double		dvvdr0, dwwdr0, dwwdr1, dvvdr3, dwwdr3;
			double		man2, man3;

			cnum0 = rownum;
			cnum1 = ccnum[k];
			cnum2 = ccnum[(k+1)%m];
			cnum3 = ccnum[(k-1+m)%m];

			if (DCirc[pivot].state > DEEPINSIDE)	{
			/* All edge angles are accessible via getxangle */
				phi01 = getxangle(cnum0, cnum1);
				phi02 = getxangle(cnum0, cnum2);
				phi03 = getxangle(cnum0, cnum3);
				phi12 = getxangle(cnum1, cnum2);
				phi13 = getxangle(cnum1, cnum3);
			}

			if (pivot == 0)	{
			/* At a hole; neighboring circles are tangent to the hole but not necessarily to each other */
				phi01 = 0.0;
				phi02 = 0.0;
				phi03 = 0.0;
				phi12 = getxangle(cnum1, cnum2);
				phi13 = getxangle(cnum1, cnum3);
			}
	
			/* Compute triangle of centers */
			r0r0 = r0*r0;
			r1r1 = r1*r1;
			r2r2 = r2*r2;
			r3r3 = r3*r3;
			r0r1 = r0*r1;
			r0r2 = r0*r2;
			r1r2 = r1*r2;
			r0r3 = r0*r3;
			r1r3 = r1*r3;
	
			t01 = cos(phi01);
			t02 = cos(phi02);
			t12 = cos(phi12);
			t03 = cos(phi03);
			t13 = cos(phi13);
	
			capu = r0r0 + r1r1 + 2.0*r0r1*t01;
			capv = r0r0 + r2r2 + 2.0*r0r2*t02;
			capw = r0r0 + r0r1*t01 + r0r2*t02 - r1r2*t12;
			capvv = r0r0 + r3r3 + 2.0*r0r3*t03;
			capww = r0r0 + r0r1*t01 + r0r3*t03 - r1r3*t13;

			targ = capw/sqrt(capu*capv);
			/* phi[k] is a central angle; ie, a curvature summand */
			if (fabs(targ) <= 1.0)
				phi[k] = acos(targ);
			else
				phi[k] = 0.0;

			/* Compute partial derivatives */
	
			dudr0 = 2.0*(r0 + r1*t01);
			dvdr0 = 2.0*(r0 + r2*t02);
			dwdr0 = 2.0*r0 + r1*t01 + r2*t02;
	
			dudr1 = 2.0*(r1 + r0*t01);
			dwdr1 = r0*t01 - r2*t12;
	
			dvdr2 = 2.0*(r2 + r0*t02);
			dwdr2 = r0*t02 - r1*t12;
	
	
			dvvdr0 = 2.0*(r0 + r3*t03);
			dwwdr0 = 2.0*r0 + r1*t01 + r3*t03;
	
			dwwdr1 = r0*t01 - r3*t13;
	
			dvvdr3 = 2.0*(r3 + r0*t03);
			dwwdr3 = r0*t03 - r1*t13;
	
	
			/* Summands of the partial with respect to the central radius */
	    		d0phi[k] = (capw/2.0)*(capu*dvdr0 + capv*dudr0) - capu*capv*dwdr0;
	    		d0phi[k] = - d0phi[k]/( sqrt(capu*capv - capw*capw) *capu*capv);
	
			if ((ccnum[k] != 0) && (abs(ccnum[k])<maxvars))	{
			/* The neighboring radius is variable, so we must compute a partial with respect to this radius */
				colnum = abs(ccnum[k]);
	
				/* Partial with respect to a neighboring radius */
	    			man2 = (capw/2.0)*(capv*dudr1) - capu*capv*dwdr1;
	    			man2 = man2/( sqrt(capu*capv - capw*capw) *capu*capv);
	    			man3 = (capww/2.0)*(capvv*dudr1) - capu*capvv*dwwdr1;
	    			man3 = man3/( sqrt(capu*capvv - capww*capww) * capu*capvv);
				d1phi[k] = - man2 - man3;
				
				myrow[colcount].i = rownum;
				myrow[colcount].j = colnum;
				myrow[colcount].dr = d1phi[k];
				++colcount;
			} /*if*/
		}
		else	{
		/* All edge angles are zero; compute triangle of circle centers */

			r0r2 = (r0+r1)*(r0+r2);
			r1r2 = r1*r2;
			r0r1 = r0*r1;

	  		phi[k] = acos(1.0-2.0*r1r2/(r0r2));	/* Summands of curvature */

			/* Summands of the partial with respect to the central radius */
	    		d0phi[k] = r1r2*(2.0*r0+r1+r2) / (r0r2*sqrt (r0*r1r2*(r0+r1+r2)));

			if ((ccnum[k] != 0) && (abs(ccnum[k])<maxvars))	{
			/* The neighboring radius is variable, so we must compute a partial with respect to this radius */
				colnum = abs(ccnum[k]);

				/* Partial with respect to a neighboring radius */
				d1phi[k] = (-r0*r2 / ((r0+r1) *sqrt(r0r1*r2*(r0+r1+r2))))
					- (r0*r3 / ((r0+r1) *sqrt(r0r1*r3*(r0+r1+r3))));
				
				myrow[colcount].i = rownum;
				myrow[colcount].j = colnum;
				myrow[colcount].dr = d1phi[k];
				++colcount;
			} /*if*/
		}
	} /*for*/
	/* Add central angles and central partial derivatives */
	phisum = d0phisum = 0;
	for (k=0; k<m; ++k) {
     		phisum += phi[k];
     		d0phisum += d0phi[k];
    	} /*for*/
    	curvature[rownum] = phisum-2.0*PI;

	myrow[colcount].i = rownum;
	myrow[colcount].j = rownum;
	myrow[colcount].dr = d0phisum;
	/* sort the nonzero partials in increasing j for the smpak function ndrv() */
	for (i=0; i<rownorm-1; ++i)	{
		tempj = -1;
		k = myrow[i].j;
		for (j=i+1; j<rownorm; ++j)	{
			if (myrow[j].j<k)	{
				k = myrow[j].j;
				tempj = j;
			}
		}
		if (tempj >= 0)	{
			arow = myrow[i];
			myrow[i] = myrow[tempj];
			myrow[tempj] = arow;
		}
	}
	for (i=0; i<rownorm; ++i)	{
		JA[JAindex] = myrow[i].j;
		A[JAindex] = myrow[i].dr;
		++JAindex;
	}
	IA[IAindex] = IAsum;
	IAsum += rownorm;
	++IAindex;
	IA[IAindex] = IAsum;
} /*getkappa*/

getvalues ()	/*	Compute curvatures, their partials and radii.	*/
{
	int			cyclelength, mystate[6], u, v, indx, vcount, fixed, k, m, mypos[6][2], yonum[6];
	double 			s[6];
	char 			d;
	int			i, j, firsti, firstj, myitem, tempindex;
	Bool			cycling, moretofind, notcycled;

	fixed = fixradj+fixradi*width;
	for (i=0; i<height; ++i)	{
		for (j=0; j<width; ++j)	{
			indx = j+i*width;
			if (DCirc[indx].state > OUTSIDE) {
				getccindices (i, j, mypos);
				for (m=0; m<NUMNBRS; ++m)	{
					u = mypos[m][1]+mypos[m][0]*width;
					/* Find the neighboring radii s[] */
					if (DCirc[u].state == 0)	s[m] = -1.0;
					else	s[m] = DCirc[u].r;
					/* Find the neighboring cnum flags  mynum[] */
					mynum[m] = DCirc[u].cnum;
				} /*for*/
				
				if ((DCirc[indx].state == INTERIOR)	
				|| (DCirc[indx].state == DEEPINSIDE))	
				/* All six neighbors contribute to the curvature */
					getkappa (mynum, s,6,i,j, -1);
	
				if ((DCirc[indx].state == OUTERBDRY)
				&&(indx!=fixed) 
				&&(indx!=fixed-1)) {
				/* Not all neighbors contribute to the curvature */
			   		u=v=0;
					do {
						if (s[u]<0) {
						/* One neighboring radius is that of the added circle at infinity */
							s[u]= DISKRAD;
							v=1;
						} /*if*/
	   					++u;
					} while (v==0);
					v = 0;
					for (u=0; u<6; ++u) {
					/* Want only the neighboring positive radii and their cnums */
						if (s[u] > 0.0) {
							z[v]=s[u];
							yonum[v] = mynum[u];
							++v;
						} /*if*/
					}
	                		getkappa (yonum, z,v,i,j, -1);
				} /*if OUTERBDRY*/
				
				if (DCirc[indx].state >= INNERBDRY)	{
			   		u=v=0;
					do {
						if (s[u] < 0) {
						/* Neighboring radius is that of a hole */
							tempindex = DCirc[indx].state-INNERBDRY;
							s[u] = DHole[tempindex].r;
							mynum[u] = -DHole[tempindex].cnum;
							/* Send a negative cnum here to let getkappa know that 
							all neighbors of this circle are tangent to this circle */
							v=1;
						} /*if*/
	   					++u;
					} while (v==0);
					v = 0;
					for (u=0; u<6; ++u) {
					/* Want only the neighboring positive radii and their cnums */
						if (s[u] > 0.0) {
							z[v] = s[u];
							yonum[v] = mynum[u];
							++v;
						} /*if*/
					}
	                		getkappa (yonum, z,v,i,j, -1);
				} /*if	INNERBDRY*/
			} /*if	!OUTSIDE*/
		} /*for i*/
	} /*for j*/

	/* Assign the curvature partials at the holes */
	for (u=0; u<numholes; ++u)	{
		for (i=0; i<height; ++i) {
    			for (j=0; j<width; ++j) {
    				indx = j+i*width;
				if (DCirc[indx].state == u+INNERBDRY)	{
				/* Found an inner boundary cycle */
					z[0] = DCirc[indx].r;
					mynum[0] = DCirc[indx].cnum;
					goto	cycler;
				} /*if*/
			} /*for*/
		} /*for*/
		
		cycler:	{
		/* Find all radii and cnums in this inner boundary cycle */
			firsti = i;
			firstj = j;
			DCirc[indx].state = 1;
			for (v=1; v<DHole[u].state; ++v)	{
				getccindices (i, j, mypos);
				for (m=0; m<NUMNBRS; ++m)	{	
					tempindex = mypos[m][1]+mypos[m][0]*width;
					mystate[m] = DCirc [tempindex].state;
				}
				getccindices (i, j, mypos);
				moretofind = TRUE;
				m = 0;
				
				do {
					if (mystate[m] == u+INNERBDRY) {
					/* Found another circle in the cycle */
						i = mypos[m][0];
						j = mypos[m][1];
						indx = j+i*width;
						DCirc[indx].state = 1;
						z[v] = DCirc[indx].r;		/* Inner boundary radius */
						mynum[v] = DCirc[indx].cnum;	/* Inner boundary cnum */
						moretofind  = FALSE;
					} /*if*/
					if (m > 4)	break;	/* cycle has been completely traversed */
					else	++m;
				} while (moretofind);
		   	} /*for v cyclelength*/
		   	getkappa (mynum, z, DHole[u].state, 0, 0, u);
			/* Restore original state flag of cycle */
		   	docycle (firsti, firstj, u+INNERBDRY);
		} /*cycler*/
	} /*for u numholes*/

	/* Now that all curvatures have been computed, find the largest curvature in absolute value */
	maxkappa = 0.0;
	for (i=0; i<N+2; ++i)	{
		if (maxkappa < fabs(curvature[i]))
			maxkappa = fabs(curvature[i]);
	}
	printf ("Maximum |curvature| = %.14lf\n", maxkappa);
} /*getvalues*/


mynewton (itercount)
/* Compute a N-dimensional newton step */
int		itercount;
{
	int		i, j, k, vcount, fix, nonzerocount, colcount;
	double		d, lowratio, temp, stepsize;
	Bool		first;
#ifdef CRAY
	fortran		void	NDRV();
#endif

	int		PATH, FLAG, ESP, NSP = 500*N;

	IAindex = JAindex = IAsum = 1;
	
	/* Get the values of the first partials, the radii and the curvatures */
	getvalues ();

	PATH = (itercount == 0) ? 1 : 2;	
#ifdef CRAY
	NDRV(&N, &R[1],&C[1],&IC[1],&IA[1],&JA[1],&A[1],&curvature[1],&curvature[1],&NSP,&ISP[1],&ISP[1],&ESP,&PATH,&FLAG);
#else 
	ndrv_(N, R, C, IC, IA, JA, A, curvature, curvature, NSP, ISP, RSP, ESP, PATH, FLAG);
#endif
	if (ESP < 0)
		printf("ESP flag from NDRV is %d. must increase working storage NSP\n",ESP);
	if (FLAG != 0)
		printf("Error flag from NDRV is %d\n",FLAG);

	/* If the full step yields negative radii, take only a partial step */
	lowratio = 1.00;
	for (i=0; i<mynorm-2; i++)	{		
		if (curvature[i+1] < 0.0)	{
			temp = -DCirc[myindex[i]].r/curvature[i+1];
			if (temp<lowratio)
				lowratio = temp;
		}
	}
	vcount = 0;
	for (i=mynorm-2; i<mynorm-2+numholes; ++i)	{
		if (curvature[i+1] < 0.0)	{
			temp = -DHole[vcount].r/curvature[i+1];
			if (temp<lowratio)
				lowratio = temp;
		}
		++vcount;
	} /*for i*/

	/* Assign step size for Newton radius increment vector */
	if (lowratio < 1.00)	 stepsize = 0.9*lowratio;
	else	stepsize = 1.0;

	/* Change radii of all variable circles */
	for (i=0; i<mynorm-2; i++)			
		DCirc[myindex[i]].r += stepsize*curvature[i+1];
	
	vcount = 0;
	for (i=mynorm-2; i<mynorm-2+numholes; ++i)	{
		DHole[vcount].r += stepsize*curvature[i+1];
		++vcount;
	}
} /*mynewton*/


