#include "extern.h"

findboundary()	{
/* input:	state:	INTERIOR:	
			connected component of nullcircle AND surrounded by 6 nhbr
		state:	CANDIDATE:
			any other circle inside the region
 Note: Some circles lying inside the bounding curves may be discarded */
	int	i, j, k, mypos[6][2], mynbrs[6], n, indx;
	Bool	outer, connected;
	
	for (i=1; i<height-1; ++i)	{
		for (j=1; j<width-1; ++j)	{
			indx = j+i*width;
			/* mark non-INTERIOR circles which connect to some
			INTERIOR circle */
			if (DCirc[indx].state == CANDIDATE)	{
				getccindices(i, j, mypos);
				for (n=0; n<NUMNBRS; ++n)	
					mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
				connected = FALSE;
				for (n=0; n<NUMNBRS; ++n)	
					if (mynbrs[n] == INTERIOR)	connected = TRUE;
				if (connected)	DCirc[indx].state = OUTERBDRY;
			}
		}
	}	
	/* other CANDIDATE's are now considered OUTSIDE */
	for (i=0; i<hw; ++i)	
		if (DCirc[i].state == CANDIDATE)	DCirc[i].state = OUTSIDE;
	/* and OUTERBDRY are now CANDIDATE's */
	for (i=0; i<hw; ++i)	
		if (DCirc[i].state == OUTERBDRY)	DCirc[i].state = CANDIDATE;

	/* Differentiate between outer and inner boundary circles */
	k = INNERBDRY;
	outer = TRUE;
	numholes = 0;
	for (i=1; i<height-1; ++i)	
		for (j=1; j<width-1; ++j)	
			if (DCirc[j+i*width].state == CANDIDATE)	{
				if (outer)	{	/* Label the outer boundary cycle states */
					docycle(i, j, OUTERBDRY);
					outer = FALSE;	
				}
				else	{	/* Label the inner boundary cycle states */
					docycle(i, j, k);
					++k;
				}
			}
	numholes = k-INNERBDRY;
	for (i=0; i<hw; ++i)	
		DPlot[i].state = DCirc[i].state;
#ifdef DEBUG2
	doinfo(DCirc); 
#endif
} /*findboundary*/


findfix()	{
/*Find two boundary circles of fixed radius.
By convention, we choose the lower right circle and its neighbor to the left */
	int 		i, j;	
	Bool		notfixed;

	i = height-1;
	j = width-1;
	notfixed = TRUE;
	while (notfixed)	{
		if (DCirc[j+i*width].state == OUTERBDRY) {	/* Found the lower right circle in the region */
			fixradi = i;
			fixradj = j;
			notfixed = FALSE;
		} /*if*/
		else	{
			if (j>0)	--j;
			else	{
				j = width-1;
				--i;
			}
		} /*else*/
	} /*while*/
} /*findfix*/

getccindices(i, j, mypos)	
/* Return in mypos the DCirc coordinates of the six neighbors of the (i,j) entry, ordered counterclockwise.
Start at lower left neighbor. */
int	i, j, mypos[6][2];
{
	mypos[0][0] = i+1;
	mypos[0][1] = j-1;
	mypos[1][0] = i+1;
	mypos[1][1] = j;
	mypos[2][0] = i;
	mypos[2][1] = j+1;
	mypos[3][0] = i-1;
	mypos[3][1] = j+1;
	mypos[4][0] = i-1;
	mypos[4][1] = j;
	mypos[5][0] = i;
	mypos[5][1] = j-1;
} /*getccindices*/


getcindices(i, j, mypos)	
/* Return in mypos the DCirc coordinates of the six neighbors of the (i,j) entry, ordered clockwise.
Start at neighbor to immediate left. */
int	i, j, mypos[6][2];
{
	mypos[0][0] = i;
	mypos[0][1] = j-1;
	mypos[1][0] = i-1;
	mypos[1][1] = j;
	mypos[2][0] = i-1;
	mypos[2][1] = j+1;
	mypos[3][0] = i;
	mypos[3][1] = j+1;
	mypos[4][0] = i+1;
	mypos[4][1] = j;
	mypos[5][0] = i+1;
	mypos[5][1] = j-1;
} /*getcindices*/


getplotnull(myPlot, a, b)
/* Find the circle entry (nulli, nullj) whose screen coordinates in myPlot are closest to (a,b) */
plotinfo	*myPlot;
int		a, b;
{
	int	i, j, x, y, tempdist, mindist;

	if (myPlot == RPlot)	{	/* A hole might be closest */
		for (i=0; i<numholes; ++i)	{
			DPlot[i].state = RPlot[i].state = 1;
			RPlot[i].x = RHole[i].x;
			RPlot[i].y = RHole[i].y;
		}
	}

	mindist = 9999;
	for (i=0; i<height; ++i)	
		for (j=0; j<width; ++j)	
			if ((DPlot[j+i*width].state > OUTSIDE)	
			&& (DPlot[j+i*width].state != OUTERBDRY))	{
			/* Find which non-OUTERBDRY circle is closest to (a, b) */
				x = myPlot[j+i*width].x;
				y = myPlot[j+i*width].y;
				tempdist = (int) abs(x-a)+abs(y-b);
				if (tempdist < mindist)	{
					mindist = tempdist;
					nullj = j;
					nulli = i;
				}
			}

	if (myPlot == RPlot)	{
		for (i=0; i<numholes; ++i)	{
			DPlot[i].state = RPlot[i].state = 0;
		}
	}
} /* getplotnull */
	

static struct	pair { int x,y}	*mystack, *this, *stackptr;
static int ssize = STACKSIZE;

/* in this stack, stackptr always points to first unused slot */
struct pair *
popm()	{
	if (stackptr <= mystack) return(0);

	return(--stackptr);
} /* popm */ 

pushm(i,j)
int i,j;
{
	/* check valid cords */
	if ( (i<0) || (j<0) || (i>(width-1)) || (j>(height-1))) return;
	stackptr->x = i;
	stackptr->y = j;
	stackptr++;
	/* realloc */
	if (stackptr == &(mystack[ssize-1]))	
		{
		int tt = stackptr - mystack;
		ssize *= 2;
#ifdef DEBUG
		printf("Reallocating: ssize=%d; mystack=%d; stackptr=%d; tt = %d\n",ssize, mystack, stackptr, tt);
#endif
		mystack = (struct pair *) realloc(mystack, sizeof(struct pair)*ssize);
		stackptr = &(mystack[ssize/2-1]);
#ifdef DEBUG
		printf("	Done: mystack=%d; stackptr=%d; \n",mystack, stackptr);
#endif
		if (mystack == NULL)
			exit(printf("konnect: Unable to allocate stack storage\n"));
		printf("konnect: doubling stack storage\n");
		}
} /* pushm */

konnect(u, v)
/* on input:	all circles inside region have state = CANDIDATE */
/* on output:	all circles inside region and surrounded by circles 
	inside region and connected to the (i,j) one 
	have state = INTERIOR, other states left alone */
/* 	strategy: use the numnbr field to identify circles which
	are totally inside region */
int	u, v;
{
	int	mypos[6][2], i, j, k, indx;
	Bool	morepoints;
	
	stackptr = mystack = (struct pair *) malloc(ssize * sizeof(struct pair));
	if (mystack == NULL)
		exit(printf("konnect: Unable to allocate stack storage\n"));

	pushm(u,v);

	while ( ( this = popm() ) != 0)
		{
		indx = this->x + this->y*width;
		/* process circles which haven't been processed but shouldbe*/
		if (DCirc[indx].state == CANDIDATE &&
			DCirc[indx].numnbr == NUMNBRS) 
			{
			DCirc[indx].state = INTERIOR;
			getccindices(this->x, this->y, mypos);
			/* push all of its neighbors */
			for (i=0; i<NUMNBRS; ++i)	
				pushm(mypos[i][0], mypos[i][1]);
			}
		}
#ifdef DEBUG2
	doinfo(DCirc);
#endif
}
	
Bool	nullok(i, j)
/* Return TRUE if the (i,j) entry of DCirc is an allowable nullcircle.
The nullcircle is allowable if it and its six neighbors lie inside the region */
int	i, j;
{
	int	mynbrs[6], mypos[6][2], n;
	Bool	goodnull;
	
	goodnull = TRUE;
	if ((i<1)
	|| (i>=height)
	|| (j<1)
	|| (j>=width))	{
		goodnull = FALSE;
	}
	else	{
		getccindices(i, j, mypos);
		for (n=0; n<NUMNBRS; ++n)	{
			mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
			if (mynbrs[n] <= OUTSIDE)	{
				goodnull = FALSE;
				break;
			}
		}
	}
	return(goodnull);
} /*nullok*/

mygetnull()	{
/* Choose the nullcircle, the circle which is mapped to the origin */
	int	downx, downy, temp, i, j, x, y, goodct, sumj;
	Bool	waiting;
    	XEvent      		myevent;	

	if (runcount == 0)	 {
	/* User selects the nullcircle */
		waiting = TRUE;
               	XSelectInput(dpy, domainwin, ButtonPressMask);
               	printf("Click on the nullcircle.\n");
               	/* Wait for mouse click on an interior circle */
                while (waiting) {
                       	XNextEvent(dpy, &myevent);
                       	if (myevent.type == ButtonPress) {
                               	downx = myevent.xbutton.x;
                               	downy = myevent.xbutton.y;
                               	getplotnull(DPlot, downx, downy);	/* Find domain circle closest to mouse press */
				/* Nullcircle must be interior */
                               	if (nullok(nulli, nullj))       {
#ifdef DEBUG
                                       	printf ("Normalizing boundary...\n");
#endif
                                       	waiting = FALSE;
                               	}
                               	else
                                       	printf("The nullcircle must be interior - select again.\n");
			}
		}
	}
	else 	{
	/* Nullcircle is chopsen automatically.
	Recompute indices of old null-circle in new coords */
		nulli *= 2;
		nullj *= 2;
		nulli -= 1;
		nullj -= 2;
               	if (!nullok(nulli, nullj))       {
			/* Must choose an acceptable nullpoint */
			/* First try nullpoint at middle of region */
			sumj = goodct = 0;
			i = height/2.0;
			for (j=1; j<width-1; ++j)	{
				if (nullok(i, j))	{
					++goodct;
					sumj += j;
				}
			}
			nulli = i;
			nullj = sumj/(double)goodct;
			/* If nullpoint is still not acceptable be stupid and scan middle row for first good nullpoint */
               		if (!nullok(nulli, nullj))       {
				for (j=1; j<width-1; ++j)	{
					if (nullok(i, j))	{
						nulli = i;
						nullj = j;
						goto outlet;
					}
				}
			}
		}
		outlet: ;
	}
} /* mygetnull */


mygetmesh()	{
/* Set up the domain circle packing */
	Bool			goodbound;

	for (goodbound = 0;	!goodbound;	) 	{
		mygetradius();	/* get the filling radius and fill */
	
		mygetnull();	/* get the nullcircle */

		konnect(nullj, nulli);	/* Find the largest connected component of domain circles containing the null circle */

		findboundary();		/* Distinguish circle state values as INTERIOR, OUTERBDRY or INNERBDRY */

		/* Check the boundary cycles */
		if ( !(goodbound = goodbdry()))	{
			printf("The mesh must be smaller.\n"); 
		}
	}
	if (bdrymode == THURSTONMODE)	getdeepin();	/* Flag the state value of circles away from the boundary */
} /* mygetmesh */

