#include <omni_proc.h>

int rchunk; 

global_init ()
{
  A = 1.0;
}

global_function ()
{
  rchunk = (int) A;
  if(chunk % rchunk != 0) {
    fprintf(stderr,"A must divide chunk.\n");
    exit(0);
   }
  if(rchunk < 0) {
    fprintf(stderr,"Hey!  Don't set A negative!\n");
    exit(0);
   }
}

float_function (in, out, pos)
double *in, *out;
int pos;
{
  int i,j;
  for(i=0;i<chunk;i+=rchunk) 
    for(j=0;j<rchunk;++j) 
       out[i+j] = in[chunk - rchunk - i + j];
}

Usage ()
{
  fprintf(stderr,"Usage: treverse <options> infile outfile\n");
  fprintf(stderr,"  reverses data in infile to outfile.\n");
  fprintf(stderr,"  options:  -skip  #lines.\n");
  fprintf(stderr,"  options:  -tail  #lines.\n");
  fprintf(stderr,"  options:  -chunk  data_chunk.\n");
  fprintf(stderr,"  options:  -A reverse_chunk. (default = 1)\n");
  fprintf(stderr,"  (reverse data reverse_chunk at a time.\n");
}
