(*^

::[paletteColors = 128; 
	fontset = title, "Times-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Times-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Times-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Times-Bold", 18, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Times-Bold", 14, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Times-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 14, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
'The Midpoint Polygon Transformation'
:[font = subtitle; inactive; ]
by Arek Goetz 
at Geometry Center 
:[font = subsubtitle; inactive; ]
University of Illinois at Chicago
:[font = postscript; inactive; PostScript; output; pictureLeft = 62; pictureWidth = 337; pictureHeight = 337; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.11284 1.14279 moveto
0.63892 1.48481 lineto
0.1 1.36603 lineto
-0.25175 0.84202 lineto
-0.25175 0.15798 lineto
0.1 -0.36603 lineto
0.63892 -0.48481 lineto
1.11284 -0.14279 lineto
1.3 0.5 lineto
1.11284 1.14279 lineto
0.7179 1.4278 lineto
0.18982 1.38582 lineto
-0.19313 0.92935 lineto
-0.25175 0.27199 lineto
0.04137 -0.27869 lineto
0.5491 -0.46501 lineto
1.03385 -0.19979 lineto
1.26881 0.39287 lineto
1.14403 1.03566 lineto
0.7179 1.4278 lineto
0.27783 1.39282 lineto
-0.1293 1.00543 lineto
-0.24198 0.38155 lineto
-0.00748 -0.18691 lineto
0.46448 -0.43396 lineto
0.95306 -0.24399 lineto
1.22965 0.29409 lineto
1.16483 0.92853 lineto
0.78893 1.36245 lineto
0.27783 1.39282 lineto
-0.06145 1.07 lineto
-0.2232 0.48553 lineto
-0.04656 -0.09217 lineto
0.38582 -0.39278 lineto
0.87163 -0.27565 lineto
1.18355 0.20441 lineto
1.17563 0.82279 lineto
0.85158 1.29013 lineto
0.36302 1.38776 lineto
-0.06145 1.07 lineto
-0.19624 0.58294 lineto
-0.076 0.00411 lineto
0.31375 -0.34268 lineto
0.79066 -0.29518 lineto
1.13156 0.1244 lineto
1.17695 0.71972 lineto
0.90558 1.21224 lineto
0.44444 1.37149 lineto
0.0093 1.12296 lineto
-0.19624 0.58294 lineto
Mistroke
-0.09604 0.10059 lineto
0.24879 -0.28488 lineto
0.71118 -0.30309 lineto
1.07474 0.05447 lineto
1.16938 0.6205 lineto
0.95081 1.13015 lineto
0.5213 1.34494 lineto
0.08182 1.16438 lineto
-0.16199 0.67294 lineto
-0.09604 0.10059 lineto
0.19132 -0.22064 lineto
0.63411 -0.30006 lineto
1.01415 -0.00512 lineto
1.15361 0.52616 lineto
0.98724 1.04521 lineto
0.59288 1.30915 lineto
0.15507 1.19447 lineto
-0.12135 0.75485 lineto
-0.10703 0.19598 lineto
0.19132 -0.22064 lineto
0.56031 -0.28682 lineto
0.95081 -0.05428 lineto
1.13037 0.43762 lineto
1.01497 0.9587 lineto
0.65861 1.26516 lineto
0.22804 1.21358 lineto
-0.07528 0.82812 lineto
-0.10942 0.28912 lineto
0.1416 -0.1512 lineto
0.56031 -0.28682 lineto
0.88573 -0.09304 lineto
1.10044 0.35563 lineto
1.0342 0.87185 lineto
0.718 1.21408 lineto
0.2998 1.22218 lineto
-0.02473 0.89236 lineto
-0.10373 0.37896 lineto
0.09976 -0.07781 lineto
0.49053 -0.26422 lineto
0.88573 -0.09304 lineto
1.06466 0.28086 lineto
1.04524 0.78582 lineto
0.7707 1.15704 lineto
0.3695 1.22083 lineto
0.02936 0.94733 lineto
-0.09056 0.46452 lineto
0.06584 -0.00169 lineto
0.4254 -0.23315 lineto
0.81986 -0.12157 lineto
1.06466 0.28086 lineto
Mistroke
1.04848 0.70166 lineto
0.81646 1.09517 lineto
0.43637 1.2102 lineto
0.08605 0.99292 lineto
-0.07058 0.54499 lineto
0.03978 0.07602 lineto
0.36547 -0.19457 lineto
0.75412 -0.14016 lineto
1.02386 0.21379 lineto
1.04848 0.70166 lineto
0.85513 1.02959 lineto
0.49972 1.19103 lineto
0.14444 1.02913 lineto
-0.04447 0.61965 lineto
0.02138 0.15418 lineto
0.31119 -0.14947 lineto
0.68934 -0.14923 lineto
0.9789 0.15479 lineto
1.04437 0.62035 lineto
0.85513 1.02959 lineto
0.55895 1.16412 lineto
0.20365 1.05611 lineto
-0.01299 0.68789 lineto
0.01041 0.23176 lineto
0.26289 -0.09887 lineto
0.62632 -0.14927 lineto
0.93064 0.10412 lineto
1.03346 0.54275 lineto
0.88667 0.96138 lineto
0.55895 1.16412 lineto
0.26287 1.07411 lineto
0.02312 0.74926 lineto
0.00651 0.30778 lineto
0.22081 -0.04376 lineto
0.56575 -0.14087 lineto
0.87992 0.06189 lineto
1.01632 0.46965 lineto
0.91114 0.89161 lineto
0.61357 1.13033 lineto
0.26287 1.07411 lineto
0.06308 0.80341 lineto
0.00928 0.38136 lineto
0.18509 0.01483 lineto
0.50826 -0.12469 lineto
0.82756 0.0281 lineto
0.99359 0.40169 lineto
0.92867 0.82128 lineto
0.66317 1.09054 lineto
0.32132 1.08348 lineto
0.06308 0.80341 lineto
Mistroke
0.01824 0.4517 lineto
0.15579 0.07592 lineto
0.4544 -0.10143 lineto
0.77434 0.00263 lineto
0.96592 0.33942 lineto
0.93949 0.75135 lineto
0.70742 1.04567 lineto
0.37829 1.08466 lineto
0.10612 0.85008 lineto
0.01824 0.4517 lineto
0.13287 0.13855 lineto
0.40463 -0.07188 lineto
0.72102 -0.01471 lineto
0.93399 0.28329 lineto
0.94389 0.6827 lineto
0.74609 0.99661 lineto
0.43315 1.07816 lineto
0.15148 0.88918 lineto
0.03289 0.5181 lineto
0.13287 0.13855 lineto
0.35933 -0.03681 lineto
0.66829 -0.02424 lineto
0.89849 0.23362 lineto
0.94224 0.61613 lineto
0.77906 0.94429 lineto
0.4853 1.06457 lineto
0.19842 0.92068 lineto
0.05265 0.57995 lineto
0.1162 0.20181 lineto
0.35933 -0.03681 lineto
0.61679 -0.02633 lineto
0.86013 0.19065 lineto
0.93495 0.55238 lineto
0.80626 0.8896 lineto
0.53426 1.04452 lineto
0.24624 0.94466 lineto
0.07695 0.63673 lineto
0.10561 0.26483 lineto
0.31881 0.00296 lineto
0.61679 -0.02633 lineto
0.81957 0.15448 lineto
0.92248 0.49209 lineto
0.82771 0.8334 lineto
0.5796 1.0187 lineto
0.29424 0.9613 lineto
0.10516 0.68805 lineto
0.10083 0.32681 lineto
0.28328 0.04661 lineto
0.56713 -0.02145 lineto
0.81957 0.15448 lineto
Mistroke
0.90533 0.43582 lineto
0.8435 0.77651 lineto
0.62095 0.98782 lineto
0.3418 0.97087 lineto
0.13668 0.7336 lineto
0.10156 0.38702 lineto
0.25287 0.09331 lineto
0.51982 -0.01011 lineto
0.7775 0.12516 lineto
0.90533 0.43582 lineto
0.85381 0.71973 lineto
0.65804 0.9526 lineto
0.38832 0.97369 lineto
0.17086 0.77314 lineto
0.10741 0.44478 lineto
0.22765 0.14226 lineto
0.47533 0.00713 lineto
0.73455 0.10262 lineto
0.88402 0.38404 lineto
0.85381 0.71973 lineto
0.69067 0.91379 lineto
0.43328 0.97018 lineto
0.20711 0.80657 lineto
0.11798 0.49951 lineto
0.20761 0.19268 lineto
0.43405 0.02965 lineto
0.69135 0.0867 lineto
0.85911 0.33714 lineto
0.85884 0.66378 lineto
0.69067 0.91379 lineto
0.47618 0.96078 lineto
0.2448 0.83384 lineto
0.13284 0.55069 lineto
0.19267 0.24382 lineto
0.39631 0.05682 lineto
0.64846 0.07719 lineto
0.83115 0.2954 lineto
0.85889 0.60934 lineto
0.7187 0.87212 lineto
0.47618 0.96078 lineto
0.28336 0.85499 lineto
0.1515 0.59788 lineto
0.1827 0.29496 lineto
0.36237 0.08799 lineto
0.60644 0.0738 lineto
0.8007 0.25903 lineto
0.85426 0.55702 lineto
0.74206 0.82832 lineto
0.5166 0.946 lineto
0.28336 0.85499 lineto
Mistroke
0.17348 0.64073 lineto
0.1775 0.34545 lineto
0.33243 0.12248 lineto
0.56576 0.07616 lineto
0.76833 0.22816 lineto
0.84534 0.50735 lineto
0.76076 0.78311 lineto
0.55417 0.92639 lineto
0.32224 0.87016 lineto
0.17348 0.64073 lineto
0.17683 0.39466 lineto
0.30661 0.15965 lineto
0.52687 0.08388 lineto
0.73456 0.20283 lineto
0.8325 0.46082 lineto
0.77486 0.73715 lineto
0.5886 0.90251 lineto
0.36089 0.87953 lineto
0.19827 0.67897 lineto
0.17683 0.39466 lineto
0.28498 0.19881 lineto
0.49016 0.09651 lineto
0.69995 0.183 lineto
0.81618 0.41782 lineto
0.78447 0.69109 lineto
0.61965 0.87495 lineto
0.39884 0.88336 lineto
0.22537 0.7124 lineto
0.1804 0.44205 lineto
0.28498 0.19881 lineto
0.45596 0.11356 lineto
0.66498 0.16859 lineto
0.79681 0.37869 lineto
0.78975 0.64555 lineto
0.64712 0.84431 lineto
0.43565 0.88196 lineto
0.25429 0.74089 lineto
0.1879 0.48711 lineto
0.26755 0.23935 lineto
0.45596 0.11356 lineto
0.63015 0.15942 lineto
0.77484 0.34367 lineto
0.79093 0.60107 lineto
0.67089 0.81118 lineto
0.47089 0.87569 lineto
0.28451 0.7644 lineto
0.19896 0.5294 lineto
0.25427 0.28065 lineto
0.42456 0.13453 lineto
0.63015 0.15942 lineto
Mistroke
0.75072 0.31296 lineto
0.78825 0.55817 lineto
0.6909 0.77616 lineto
0.50422 0.86493 lineto
0.31558 0.78295 lineto
0.21322 0.56857 lineto
0.24505 0.3221 lineto
0.39618 0.15888 lineto
0.59588 0.15527 lineto
0.75072 0.31296 lineto
0.78199 0.5173 lineto
0.70712 0.73983 lineto
0.53534 0.85014 lineto
0.34702 0.79661 lineto
0.23028 0.6043 lineto
0.23975 0.36318 lineto
0.37099 0.18608 lineto
0.5626 0.15587 lineto
0.72492 0.28668 lineto
0.78199 0.5173 lineto
0.7196 0.70274 lineto
0.56397 0.83175 lineto
0.3784 0.80553 lineto
0.24974 0.63635 lineto
0.23817 0.40337 lineto
0.34912 0.2156 lineto
0.53066 0.16091 lineto
0.69786 0.26488 lineto
0.77248 0.47887 lineto
0.7196 0.70274 lineto
0.58991 0.81025 lineto
0.40933 0.8099 lineto
0.27118 0.66455 lineto
0.2401 0.4422 lineto
0.33063 0.24689 lineto
0.50041 0.17002 lineto
0.67 0.24755 lineto
0.76004 0.4432 lineto
0.72841 0.66543 lineto
0.58991 0.81025 lineto
0.43943 0.80996 lineto
0.29421 0.68877 lineto
0.24528 0.47926 lineto
0.31554 0.27945 lineto
0.47211 0.18283 lineto
0.64173 0.23463 lineto
0.74504 0.41059 lineto
0.73368 0.62839 lineto
0.61299 0.78612 lineto
0.43943 0.80996 lineto
Mistroke
0.31841 0.70897 lineto
0.25343 0.51418 lineto
0.30383 0.31275 lineto
0.44601 0.19894 lineto
0.61346 0.226 lineto
0.72782 0.38126 lineto
0.73558 0.59209 lineto
0.63311 0.75983 lineto
0.46835 0.80599 lineto
0.31841 0.70897 lineto
0.26426 0.54664 lineto
0.29543 0.34632 lineto
0.42232 0.2179 lineto
0.58555 0.22149 lineto
0.70876 0.35539 lineto
0.73428 0.55695 lineto
0.65018 0.73187 lineto
0.49581 0.79829 lineto
0.3434 0.72514 lineto
0.26426 0.54664 lineto
0.29023 0.37971 lineto
0.40117 0.23931 lineto
0.55835 0.22089 lineto
0.68822 0.33307 lineto
0.73003 0.52336 lineto
0.6642 0.70272 lineto
0.52154 0.78722 lineto
0.3688 0.73733 lineto
0.27745 0.57639 lineto
0.29023 0.37971 lineto
0.38268 0.26271 lineto
0.53215 0.22396 lineto
0.66658 0.31437 lineto
0.72306 0.49164 lineto
0.67517 0.67283 lineto
0.54532 0.77314 lineto
0.39426 0.74565 lineto
0.29268 0.60322 lineto
0.2881 0.41249 lineto
0.38268 0.26271 lineto
0.50724 0.23042 lineto
0.64417 0.2993 lineto
0.71365 0.4621 lineto
0.68315 0.64263 lineto
0.56696 0.75642 lineto
0.41943 0.75023 lineto
0.30961 0.62696 lineto
0.28887 0.44428 lineto
0.36692 0.28767 lineto
0.50724 0.23042 lineto
Mistroke
0.62135 0.28782 lineto
0.70207 0.43497 lineto
0.68824 0.61254 lineto
0.58633 0.73746 lineto
0.44402 0.75126 lineto
0.32791 0.6475 lineto
0.29232 0.47472 lineto
0.35391 0.31377 lineto
0.48385 0.23996 lineto
0.62135 0.28782 lineto
0.68862 0.41044 lineto
0.69054 0.58294 lineto
0.60331 0.71664 lineto
0.46774 0.74896 lineto
0.34726 0.66479 lineto
0.29825 0.50352 lineto
0.34364 0.3406 lineto
0.4622 0.25226 lineto
0.59843 0.27985 lineto
0.68862 0.41044 lineto
0.69022 0.55419 lineto
0.61785 0.69435 lineto
0.49033 0.74357 lineto
0.36734 0.67882 lineto
0.30642 0.5304 lineto
0.33608 0.36775 lineto
0.44244 0.26698 lineto
0.57573 0.27525 lineto
0.67359 0.38868 lineto
0.69022 0.55419 lineto
0.62991 0.67099 lineto
0.51159 0.73537 lineto
0.38784 0.68961 lineto
0.31658 0.55514 lineto
0.33114 0.39486 lineto
0.42471 0.28378 lineto
0.55351 0.27387 lineto
0.65728 0.36977 lineto
0.68745 0.52661 lineto
0.62991 0.67099 lineto
0.53131 0.72464 lineto
0.40847 0.69724 lineto
0.32845 0.57755 lineto
0.32871 0.42157 lineto
0.40911 0.30229 lineto
0.53205 0.27552 lineto
0.63998 0.35379 lineto
0.68242 0.50047 lineto
0.6395 0.64693 lineto
0.53131 0.72464 lineto
Mistroke
0.42894 0.70181 lineto
0.34179 0.5975 lineto
0.32867 0.44757 lineto
0.39571 0.32217 lineto
0.51156 0.27998 lineto
0.62199 0.34074 lineto
0.67535 0.47602 lineto
0.64665 0.62252 lineto
0.54934 0.71169 lineto
0.42894 0.70181 lineto
0.35631 0.61488 lineto
0.33085 0.47256 lineto
0.38454 0.34307 lineto
0.49225 0.28701 lineto
0.60359 0.33062 lineto
0.66645 0.45348 lineto
0.65144 0.5981 lineto
0.56556 0.69683 lineto
0.44901 0.70345 lineto
0.35631 0.61488 lineto
0.3351 0.49628 lineto
0.37559 0.36465 lineto
0.4743 0.29636 lineto
0.58503 0.32335 lineto
0.65598 0.433 lineto
0.65394 0.574 lineto
0.57987 0.68037 lineto
0.46843 0.70235 lineto
0.37176 0.62964 lineto
0.3351 0.49628 lineto
0.36884 0.38659 lineto
0.45785 0.30774 lineto
0.56658 0.31885 lineto
0.64415 0.41472 lineto
0.65428 0.5505 lineto
0.59222 0.66264 lineto
0.487 0.69869 lineto
0.38787 0.64176 lineto
0.34121 0.5185 lineto
0.36884 0.38659 lineto
0.44301 0.32088 lineto
0.54845 0.317 lineto
0.63122 0.39875 lineto
0.65259 0.52787 lineto
0.60256 0.64395 lineto
0.50454 0.69268 lineto
0.4044 0.65125 lineto
0.34899 0.53905 lineto
0.36424 0.40857 lineto
0.44301 0.32088 lineto
Mistroke
0.53088 0.31765 lineto
0.61743 0.38512 lineto
0.64903 0.50635 lineto
0.6109 0.62461 lineto
0.52088 0.68456 lineto
0.42109 0.65815 lineto
0.35822 0.55775 lineto
0.3617 0.43032 lineto
0.42988 0.3355 lineto
0.53088 0.31765 lineto
0.603 0.37388 lineto
0.64376 0.48614 lineto
0.61725 0.6049 lineto
0.53588 0.67457 lineto
0.43772 0.66256 lineto
0.3687 0.57448 lineto
0.36112 0.45156 lineto
0.41852 0.3513 lineto
0.51405 0.32062 lineto
0.603 0.37388 lineto
0.63697 0.46743 lineto
0.62167 0.5851 lineto
0.54944 0.66296 lineto
0.45408 0.66456 lineto
0.3802 0.58916 lineto
0.36238 0.47205 lineto
0.40895 0.36801 lineto
0.49813 0.32573 lineto
0.58818 0.365 lineto
0.63697 0.46743 lineto
0.62422 0.56549 lineto
0.56148 0.64998 lineto
0.46997 0.66429 lineto
0.39251 0.60173 lineto
0.36535 0.49156 lineto
0.40119 0.38535 lineto
0.48326 0.33278 lineto
0.57317 0.35846 lineto
0.62884 0.45036 lineto
0.62422 0.56549 lineto
0.57194 0.6359 lineto
0.48522 0.66191 lineto
0.40542 0.61215 lineto
0.36988 0.50993 lineto
0.39522 0.40305 lineto
0.46959 0.34154 lineto
0.55818 0.35418 lineto
0.61956 0.43504 lineto
0.62499 0.5463 lineto
0.57194 0.6359 lineto
Mistroke
0.49968 0.65757 lineto
0.41872 0.62045 lineto
0.3758 0.52696 lineto
0.39099 0.42086 lineto
0.45719 0.35179 lineto
0.54342 0.35207 lineto
0.60933 0.42157 lineto
0.62409 0.52776 lineto
0.58078 0.62097 lineto
0.49968 0.65757 lineto
0.43222 0.62663 lineto
0.38296 0.54254 lineto
0.38846 0.43855 lineto
0.44616 0.36331 lineto
0.52905 0.35202 lineto
0.59834 0.40998 lineto
0.62163 0.51006 lineto
0.588 0.60543 lineto
0.51319 0.65147 lineto
0.43222 0.62663 lineto
0.39117 0.55656 lineto
0.38754 0.45588 lineto
0.43654 0.37585 lineto
0.51523 0.3539 lineto
0.5868 0.40032 lineto
0.61775 0.49338 lineto
0.5936 0.58954 lineto
0.52566 0.6438 lineto
0.44571 0.63077 lineto
0.39117 0.55656 lineto
0.38815 0.47266 lineto
0.42838 0.38918 lineto
0.50212 0.35756 lineto
0.57487 0.39259 lineto
0.61259 0.47787 lineto
0.59763 0.57351 lineto
0.53698 0.63475 lineto
0.45904 0.63294 lineto
0.40026 0.56893 lineto
0.38815 0.47266 lineto
0.42167 0.4031 lineto
0.48983 0.36283 lineto
0.56274 0.38675 lineto
0.6063 0.46366 lineto
0.60012 0.55757 lineto
0.54709 0.62455 lineto
0.47203 0.63325 lineto
0.41005 0.5796 lineto
0.39017 0.4887 lineto
0.42167 0.4031 lineto
Mistroke
0.47847 0.36954 lineto
0.55059 0.38276 lineto
0.59904 0.45084 lineto
0.60115 0.54192 lineto
0.55593 0.61338 lineto
0.48454 0.6318 lineto
0.42038 0.58854 lineto
0.39348 0.50385 lineto
0.41642 0.41737 lineto
0.47847 0.36954 lineto
0.53857 0.38056 lineto
0.59097 0.43949 lineto
0.6008 0.52674 lineto
0.56347 0.60147 lineto
0.49644 0.62873 lineto
0.43108 0.59575 lineto
0.39796 0.51797 lineto
0.4126 0.43178 lineto
0.46813 0.37751 lineto
0.53857 0.38056 lineto
0.58223 0.42967 lineto
0.59916 0.5122 lineto
0.56969 0.58902 lineto
0.50761 0.62418 lineto
0.44197 0.60124 lineto
0.40348 0.53093 lineto
0.41016 0.44614 lineto
0.45887 0.38656 lineto
0.52683 0.38005 lineto
0.58223 0.42967 lineto
0.59634 0.49844 lineto
0.5746 0.57621 lineto
0.51796 0.61832 lineto
0.45291 0.60507 lineto
0.4099 0.54265 lineto
0.40905 0.46028 lineto
0.45075 0.39649 lineto
0.5155 0.38114 lineto
0.573 0.4214 lineto
0.59634 0.49844 lineto
0.57822 0.56325 lineto
0.5274 0.61131 lineto
0.46375 0.60728 lineto
0.41707 0.55305 lineto
0.40919 0.474 lineto
0.4438 0.40712 lineto
0.50471 0.38369 lineto
0.56342 0.41469 lineto
0.59245 0.4856 lineto
0.57822 0.56325 lineto
Mistroke
0.53587 0.6033 lineto
0.47436 0.60795 lineto
0.42485 0.56209 lineto
0.4105 0.48718 lineto
0.43803 0.41827 lineto
0.49456 0.3876 lineto
0.55363 0.40952 lineto
0.58761 0.47378 lineto
0.58059 0.55031 lineto
0.53587 0.6033 lineto
0.48461 0.60717 lineto
0.4331 0.56973 lineto
0.41289 0.49966 lineto
0.43344 0.42975 lineto
0.48514 0.39271 lineto
0.54379 0.40587 lineto
0.58195 0.46307 lineto
0.58176 0.53756 lineto
0.54332 0.59447 lineto
0.48461 0.60717 lineto
0.44168 0.57597 lineto
0.41626 0.51134 lineto
0.43002 0.4414 lineto
0.47652 0.39888 lineto
0.53401 0.40368 lineto
0.57559 0.45354 lineto
0.58179 0.52514 lineto
0.54973 0.58498 lineto
0.49439 0.60506 lineto
0.44168 0.57597 lineto
0.4205 0.52211 lineto
0.42773 0.45306 lineto
0.46877 0.40597 lineto
0.52443 0.40288 lineto
0.56866 0.44523 lineto
0.58076 0.51321 lineto
0.55507 0.57501 lineto
0.50362 0.60171 lineto
0.45047 0.58082 lineto
0.4205 0.52211 lineto
0.42652 0.46457 lineto
0.46193 0.41382 lineto
0.51515 0.40339 lineto
0.56129 0.43817 lineto
0.57874 0.50188 lineto
0.55935 0.56471 lineto
0.51219 0.59726 lineto
0.45933 0.5843 lineto
0.42549 0.5319 lineto
0.42652 0.46457 lineto
Mistroke
0.45603 0.42228 lineto
0.50628 0.40513 lineto
0.5536 0.43237 lineto
0.57583 0.49126 lineto
0.56259 0.55424 lineto
0.52005 0.59183 lineto
0.46814 0.58646 lineto
0.43113 0.54063 lineto
0.42635 0.47579 lineto
0.45603 0.42228 lineto
0.49791 0.40799 lineto
0.54571 0.42783 lineto
0.57213 0.48145 lineto
0.56479 0.54374 lineto
0.52714 0.58557 lineto
0.47679 0.58736 lineto
0.4373 0.54827 lineto
0.42715 0.4866 lineto
0.45108 0.4312 lineto
0.49791 0.40799 lineto
0.53774 0.42453 lineto
0.56772 0.47251 lineto
0.56602 0.53336 lineto
0.53342 0.5786 lineto
0.48518 0.58706 lineto
0.44388 0.55478 lineto
0.42884 0.49688 lineto
0.44709 0.44043 lineto
0.4901 0.41186 lineto
0.53774 0.42453 lineto
0.56273 0.46451 lineto
0.5663 0.52322 lineto
0.53885 0.57106 lineto
0.49322 0.58565 lineto
0.45076 0.56016 lineto
0.43135 0.50653 lineto
0.44405 0.44984 lineto
0.48293 0.41662 lineto
0.5298 0.42242 lineto
0.56273 0.46451 lineto
0.56571 0.51343 lineto
0.54343 0.56308 lineto
0.50083 0.58322 lineto
0.45784 0.56441 lineto
0.43458 0.51547 lineto
0.44193 0.45929 lineto
0.47645 0.42216 lineto
0.52199 0.42145 lineto
0.55724 0.4575 lineto
0.56571 0.51343 lineto
Mistroke
0.54714 0.55481 lineto
0.50793 0.57986 lineto
0.465 0.56755 lineto
0.43846 0.52362 lineto
0.44071 0.46865 lineto
0.4707 0.42834 lineto
0.5144 0.42157 lineto
0.55137 0.45149 lineto
0.56429 0.50411 lineto
0.54714 0.55481 lineto
0.51446 0.57569 lineto
0.47216 0.5696 lineto
0.44288 0.53094 lineto
0.44033 0.47781 lineto
0.4657 0.43506 lineto
0.50712 0.4227 lineto
0.54521 0.4465 lineto
0.56214 0.49534 lineto
0.55 0.54636 lineto
0.51446 0.57569 lineto
0.47921 0.57061 lineto
0.44776 0.53739 lineto
0.44076 0.48667 lineto
0.46147 0.44219 lineto
0.50022 0.42476 lineto
0.53886 0.44253 lineto
0.55932 0.4872 lineto
0.55202 0.53786 lineto
0.52038 0.5708 lineto
0.47921 0.57061 lineto
0.453 0.54292 lineto
0.44193 0.49512 lineto
0.45802 0.4496 lineto
0.49376 0.42766 lineto
0.53242 0.43957 lineto
0.55591 0.47976 lineto
0.55324 0.52941 lineto
0.52566 0.56531 lineto
0.48607 0.57064 lineto
0.453 0.54292 lineto
0.44377 0.50309 lineto
0.45534 0.45719 lineto
0.4878 0.43132 lineto
0.52597 0.43759 lineto
0.55199 0.47306 lineto
0.55368 0.52114 lineto
0.53025 0.55932 lineto
0.49267 0.56975 lineto
0.45851 0.54754 lineto
0.44377 0.50309 lineto
Mistroke
0.45341 0.46484 lineto
0.48239 0.43563 lineto
0.51961 0.43654 lineto
0.54766 0.46715 lineto
0.5534 0.51312 lineto
0.53416 0.55296 lineto
0.49893 0.56802 lineto
0.46421 0.55125 lineto
0.44623 0.5105 lineto
0.45341 0.46484 lineto
0.47756 0.4405 lineto
0.51341 0.43639 lineto
0.54298 0.46205 lineto
0.55244 0.50546 lineto
0.53737 0.54632 lineto
0.5048 0.56551 lineto
0.46999 0.55404 lineto
0.44923 0.51729 lineto
0.45221 0.47245 lineto
0.47756 0.4405 lineto
0.50743 0.43707 lineto
0.53805 0.45777 lineto
0.55087 0.49823 lineto
0.53988 0.53951 lineto
0.51023 0.56231 lineto
0.4758 0.55595 lineto
0.45269 0.52341 lineto
0.45172 0.47992 lineto
0.47334 0.44582 lineto
0.50743 0.43707 lineto
0.53295 0.45432 lineto
0.54873 0.49148 lineto
0.54171 0.53263 lineto
0.51517 0.55851 lineto
0.48154 0.55701 lineto
0.45654 0.52884 lineto
0.45188 0.48717 lineto
0.46973 0.45151 lineto
0.50175 0.43853 lineto
0.53295 0.45432 lineto
0.5461 0.48529 lineto
0.54288 0.52577 lineto
0.5196 0.5542 lineto
0.48714 0.55726 lineto
0.4607 0.53353 lineto
0.45265 0.49411 lineto
0.46676 0.45745 lineto
0.49642 0.44069 lineto
0.52775 0.45169 lineto
0.5461 0.48529 lineto
Mistroke
0.54342 0.51902 lineto
0.52348 0.54946 lineto
0.49255 0.55675 lineto
0.46511 0.53749 lineto
0.454 0.50068 lineto
0.46441 0.46356 lineto
0.49147 0.44349 lineto
0.52253 0.44986 lineto
0.54304 0.47969 lineto
0.54342 0.51902 lineto
0.5268 0.54439 lineto
0.4977 0.55554 lineto
0.46968 0.5407 lineto
0.45585 0.50682 lineto
0.46267 0.46975 lineto
0.48696 0.44683 lineto
0.51735 0.4488 lineto
0.53962 0.47472 lineto
0.54335 0.51247 lineto
0.5268 0.54439 lineto
0.50255 0.55368 lineto
0.47435 0.54317 lineto
0.45815 0.51246 lineto
0.46153 0.47593 lineto
0.48291 0.45065 lineto
0.51229 0.44847 lineto
0.53591 0.4704 lineto
0.54273 0.50618 lineto
0.52956 0.53907 lineto
0.50255 0.55368 lineto
0.47905 0.54492 lineto
0.46085 0.51758 lineto
0.46097 0.48202 lineto
0.47935 0.45486 lineto
0.50739 0.44883 lineto
0.53197 0.46674 lineto
0.5416 0.50021 lineto
0.53175 0.53359 lineto
0.50705 0.55124 lineto
0.47905 0.54492 lineto
0.46389 0.52214 lineto
0.46095 0.48794 lineto
0.47629 0.45939 lineto
0.50272 0.44984 lineto
0.52788 0.46376 lineto
0.53999 0.49464 lineto
0.53339 0.52802 lineto
0.51117 0.5483 lineto
0.48372 0.54598 lineto
0.46389 0.52214 lineto
Mistroke
0.46144 0.49364 lineto
0.47373 0.46415 lineto
0.49831 0.45143 lineto
0.52368 0.46144 lineto
0.53797 0.48949 lineto
0.53449 0.52246 lineto
0.51488 0.54492 lineto
0.4883 0.54636 lineto
0.46719 0.52611 lineto
0.46144 0.49364 lineto
0.47168 0.46906 lineto
0.49422 0.45355 lineto
0.51946 0.45977 lineto
0.53559 0.48481 lineto
0.53507 0.51696 lineto
0.51815 0.54118 lineto
0.49273 0.54612 lineto
0.47071 0.52949 lineto
0.4624 0.49905 lineto
0.47168 0.46906 lineto
0.49046 0.45614 lineto
0.51525 0.45873 lineto
0.5329 0.48064 lineto
0.53516 0.51161 lineto
0.52097 0.53714 lineto
0.49696 0.5453 lineto
0.47438 0.53226 lineto
0.46378 0.50413 lineto
0.47014 0.47406 lineto
0.49046 0.45614 lineto
0.51112 0.4583 lineto
0.52996 0.47699 lineto
0.53478 0.50644 lineto
0.52333 0.53288 lineto
0.50096 0.54394 lineto
0.47814 0.53443 lineto
0.46555 0.50882 lineto
0.46908 0.47907 lineto
0.48707 0.45912 lineto
0.51112 0.4583 lineto
0.52682 0.47387 lineto
0.53398 0.50153 lineto
0.52524 0.52848 lineto
0.50469 0.5421 lineto
0.48195 0.53602 lineto
0.46765 0.51308 lineto
0.46849 0.48403 lineto
0.48407 0.46245 lineto
0.50711 0.45844 lineto
0.52682 0.47387 lineto
Mistroke
0.53279 0.49692 lineto
0.5267 0.52399 lineto
0.50812 0.53983 lineto
0.48574 0.53703 lineto
0.47003 0.51691 lineto
0.46835 0.48887 lineto
0.48148 0.46605 lineto
0.50327 0.45911 lineto
0.52353 0.4713 lineto
0.53279 0.49692 lineto
0.52771 0.51948 lineto
0.51121 0.53719 lineto
0.48947 0.5375 lineto
0.47265 0.52026 lineto
0.46863 0.49355 lineto
0.47929 0.46985 lineto
0.49964 0.46026 lineto
0.52016 0.46927 lineto
0.53124 0.49265 lineto
0.52771 0.51948 lineto
0.51396 0.53424 lineto
0.49309 0.53744 lineto
0.47545 0.52313 lineto
0.4693 0.498 lineto
0.47751 0.4738 lineto
0.49625 0.46186 lineto
0.51674 0.46777 lineto
0.5294 0.48876 lineto
0.5283 0.51501 lineto
0.51396 0.53424 lineto
0.49657 0.53691 lineto
0.47839 0.52552 lineto
0.47033 0.50219 lineto
0.47614 0.47783 lineto
0.49312 0.46385 lineto
0.51332 0.46678 lineto
0.52729 0.48526 lineto
0.52848 0.51063 lineto
0.51635 0.53103 lineto
0.49657 0.53691 lineto
0.48142 0.52742 lineto
0.47167 0.50608 lineto
0.47517 0.48189 lineto
0.49029 0.46618 lineto
0.50996 0.46629 lineto
0.52496 0.48218 lineto
0.52828 0.5064 lineto
0.51837 0.52763 lineto
0.49987 0.53593 lineto
0.48142 0.52742 lineto
Mistroke
0.4733 0.50963 lineto
0.47459 0.48592 lineto
0.48777 0.4688 lineto
0.50668 0.46627 lineto
0.52246 0.47953 lineto
0.52773 0.50237 lineto
0.52003 0.52409 lineto
0.50295 0.53455 lineto
0.4845 0.52884 lineto
0.4733 0.50963 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = section; inactive; startGroup; Cclosed; ]
Info...

:[font = text; inactive; endGroup; ]
The  package  mppt.m   (Midpoint Polygon Transformation)   and  this  notebook mpptnotebook.m was created during Summer  Research Project at Geometry Center,  Minneapolis, Minnesota, summer 1991. The program was sponsored by the National Science Foundation. The documentation to the package is stored under the name: mppt.doc .                                             
                                                                                      
                                                                                     Arek Goetz, 
                                                                             u21569@uicvm.uic.edu,
                                                                Department of Mathematics, Statistics
                                                                     and Computer Science (M/C 249)
                                                                                       Box 4348
                                                                              Chicago, Illinois 60680.
  
:[font = section; inactive; startGroup; Cclosed; ]
Mathematical introduction.

:[font = text; inactive; ]
   The package and this notebook is devoted to a transformation of polygons.
For any polygon P0 we construct another polygon P1 by joining the midpoints of P0. This transformation will be called the MidPointPolygonTransformation or just T. 
:[font = postscript; inactive; PostScript; output; pictureLeft = 82; pictureTop = 2; pictureWidth = 282; pictureHeight = 174; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 0.61803 
MathPictureStart
% Scaling calculations
0.4793 0.58269 0.47063 0.47877 [
[ 0 0 0 0 ]
[ 1 0.618034 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 0.618034 lineto
0 0.618034 lineto
closepath
clip
newpath
0 setgray
gsave
0.004 setlinewidth
0.45445 0.60332 moveto
0.97619 0.45021 lineto
stroke
0.45445 0.60332 moveto
0.10248 0.47403 lineto
0.02381 0.15081 lineto
0.56211 0.01472 lineto
0.97619 0.45021 lineto
stroke
0.27847 0.53867 moveto
0.71532 0.52677 lineto
stroke
0.27847 0.53867 moveto
0.06315 0.31242 lineto
0.29296 0.08276 lineto
0.76915 0.23246 lineto
0.71532 0.52677 lineto
stroke
0.17081 0.42555 moveto
0.49689 0.53272 lineto
stroke
0.17081 0.42555 moveto
0.17805 0.19759 lineto
0.53106 0.15761 lineto
0.74224 0.37962 lineto
0.49689 0.53272 lineto
stroke
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
To represent polygons we will use complex numbers. For example a square can be represented by:  (1,  I, -1, -I). The transformation T  has the following matrix in the standard basis:

           | 1/2    1/2    0 ....................0  |
           |   0     1/2   1/2...................0  |
           |   0       0     1/2 .................0  |
  T  =  |    ........................................  |
           |   0       0       0          1/2  1/2 |
           |  1/2     0       0            0   1/2 |         .
           
  The above (n by n) matrix    has exactly n different eigenvalues. Therefore, there exist n linearly independent eigenvectors which form a basis of the transformation. Analyzing the multiple composition of  T in this  eigenvector basis one can prove the following

  
  THEOREM 1: 
  
   Let P be any polygon whose center of mass is at the origin.
                     n
   *)   lim    T (P) = (0, 0, ..., 0).
       n->inf
       
  **)   If   P <> (A,B,A,B,....,B) where A and  B are complex numbers, then there is  an ellipse  E and a positive number   such that :
                                   n    n
                lim     D(      T  (P)[j]    ,    E  ) = 0
              n->inf         
              
    where  D( R, E ) denotes the distance between  the ellipse E and the point R and  P[j] denotes the j-th vertex of the polygon P.
    
    
    
 In other words the theorem says that the descendants of the  polygon P converge to the center of mass of  P. However, if we resize each descendant, then in the limit all vertices will lie on an ellipse. The ellipse E will be further called the 'midpoint' ellipse. The proof of this theorem may be found in my paper.
    

 The transformation T is a smoothing operator. The precise meaning of this is the following:
 
 THEOREM 2:  For almost all n-gons there exist n such that all descendants of the       
    n
 T    (P)  are convex. "Almost all" means these polygons whose first and peniultima coefficient in the eigenvector basis representation of  P  have different absolute values.  The polygons for which  both first and peniultima coeffitient are 0  will be called RandomStellarPolygons. 
 
 
 We can also consider a more general transformation where we do not take midpoints but points which divide the sides of a polygon in different ratio. The matrix will be slightly different: 
 
 
 
           |   fr   1-fr    0 ....................0  |
           |   0     fr    1-fr...................0  |
           |   0       0    fr ....................0  |
  T=    |    ........................................  |
           |   0       0       0          fr    1-fr |
           | 1- fr     0       0         0      fr   |        where 0<fr<1. 
           
    All of the stated theorems will still hold.          
:[font = postscript; inactive; PostScript; output; pictureLeft = 69; pictureWidth = 282; pictureHeight = 174; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 0.61803 
MathPictureStart
% Scaling calculations
0.50397 0.55841 0.3065 0.35396 [
[ 0 0 0 0 ]
[ 1 0.618034 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 0.618034 lineto
0 0.618034 lineto
closepath
clip
newpath
0 setgray
gsave
0.004 setlinewidth
0.80159 0.03735 moveto
0.97619 0.22601 lineto
stroke
0.80159 0.03735 moveto
0.11508 0.01472 lineto
0.02381 0.31656 lineto
0.29762 0.5832 lineto
0.72222 0.60332 lineto
0.97619 0.22601 lineto
stroke
0.28671 0.02037 moveto
0.84524 0.08452 lineto
stroke
0.28671 0.02037 moveto
0.04663 0.2411 lineto
0.22917 0.51654 lineto
0.61607 0.59829 lineto
0.9127 0.32034 lineto
0.84524 0.08452 lineto
stroke
0.10665 0.18592 moveto
0.42634 0.03641 lineto
stroke
0.10665 0.18592 moveto
0.18353 0.44768 lineto
0.51934 0.57785 lineto
0.83854 0.38982 lineto
0.8621 0.14347 lineto
0.42634 0.03641 lineto
stroke
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
               This picture shows a polygon and its two descendant were fr=1/4.


We can approximate a closed, parametrized curve C(t) , 0<=t<=2 Pi by a polygon: 
Q=( C(t1), C(t2), . . . , C(tN) ) where ti = 2 Pi / N. The coefficients  (b1, b2, . . . , bN) of the polygon Q in the eigenvector basis approximate the coefficients of Fourier expansion of the curve C(t)!  For almost all curves the  theorem below is satisfied: 
                                                                 ('Almost all' means that at least 
                                                                     one of  the first  two  coeffincient
                                                                     in the  Fourier   expansion of a  
                                                                     curve has  to be different from 0.)
 

                                                                                                                                                                          
THEOREM 3:

The 'midpoint' ellipses of  the polygons Q  approximating the curve  C(t) converge to a fixed  ellipse, as the number of vertices of Q tends to infinity.   All approximating polygons   Q (when N is large enough) are convex.
                                                                                                                                                                                                                                                      
  
:[font = name; inactive; endGroup; ]
References:
[1]  J. H. Cadwell; Math. Gazette 37 (1953), p. 85.
[2]  E.R. Berlekamp, E. N. Gilbert, and W. Sinden; American Math. Monthly, 1965, p.233.
[3]  A. Goetz, " The Midpoint  Polygon Transformation", Geometry Center, Minneapolis, MN  (1991).
:[font = section; inactive; startGroup; Cclosed; ]
The package and its functions.

:[font = text; inactive; ]
In order to load the package type:
:[font = input; ]
<<mppt.m
:[font = text; inactive; ]
      The package mppt.m might be a helpful tool  in:
 * illustrating transformations of polygons and curves and the theorems
    regarding these transformations,
 * in exploring properties of particular polygons,
 * for various animations.


      The package defines the following functions:
   MidPointPolygonMovie,
   SelfIntersecting,
   RandomStellarPolygon,
   Basis,
   Perimeter,
   MidPointPolygon,
   Ellipse,
   ScalingFactor.
   
   
   The definitions and the information regarding particular functions and their options are obtainable  in usage messages.   
  
   Example:
:[font = input; startGroup; ]
?Ellipse
:[font = info; inactive; endGroup; endGroup; ]
The function Ellipse[{{x1,y1},...,{xn,yn}}] returns the
   complex coeficients a and b, and the lengths: c,d of
   the semiexis in the form {a,b,c,d} such that the
   equation:      z[]= a Cos[] + b Sin[]               
    (0<=<2Pi)    is the parametric equation of the
   'midpoint ellipse'.
:[font = section; inactive; startGroup; Cclosed; ]
Examples.

:[font = subsection; inactive; startGroup; Cclosed; ]
Discovering properties...
:[font = text; inactive; ]
     If we connect the midpoints of a triangle,  we obtain a similar triangle. It will be rotated 180' and shrinked two times. Thus the area will be 4 times smaller. MidPointPolygonMovie will generate both triangles. 
:[font = input; startGroup; ]
MidPointPolygonMovie[{{-1,0},{1,0},{0,1}}]
:[font = postscript; inactive; PostScript; output; pictureLeft = 144; pictureTop = 2; pictureWidth = 114; pictureHeight = 114; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(3)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0 0.33333 moveto
1 0.33333 lineto
0.5 0.83333 lineto
stroke
0 0.33333 moveto
0.5 0.83333 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 144; pictureTop = 2; pictureWidth = 114; pictureHeight = 114; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(3)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.5 0.33333 moveto
0.75 0.58333 lineto
0.25 0.58333 lineto
stroke
0.5 0.33333 moveto
0.25 0.58333 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
The first picture shows the triangle whose  vertices are  {{-1,0},{1,0},{0,1}} but translated in such a way that the center of mass is at the origin.  In the second frame, there is the 'midpoint' triangle.

For any quadrilateral  the oposite sides of  the 'midpoint' polygon are parallel. Hence, we get a parallelogram.

:[font = input; startGroup; ]
MidPointPolygonMovie[{{-0.77, 0.85},{-0.37, -0.63}, 
                      {0.83, 0.48},{0.05, 0.35}}
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 147; pictureTop = 5; pictureWidth = 112; pictureHeight = 112; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(4)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.1475 0.79375 moveto
0.3475 0.05375 lineto
0.9475 0.60875 lineto
0.5575 0.54375 lineto
stroke
0.1475 0.79375 moveto
0.5575 0.54375 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 147; pictureTop = 5; pictureWidth = 112; pictureHeight = 112; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(4)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.2475 0.42375 moveto
0.6475 0.33125 lineto
0.7525 0.57625 lineto
0.3525 0.66875 lineto
stroke
0.2475 0.42375 moveto
0.3525 0.66875 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
If the quadrilateral is convex, then the area of consecutive descendants decreases two times after each iteration.
:[font = input; startGroup; ]
MidPointPolygonMovie[{{-0.77, -0.39},{0.50, -0.79},
                      {0.86, 0.16},{-0.34, 0.80}},
                      Style->Filled,
                      TotalFrameNumber->4
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 151; pictureTop = 2; pictureWidth = 114; pictureHeight = 114; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(4)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
0.08375 0.3325 moveto
0.71875 0.1325 lineto
0.89875 0.6075 lineto
0.29875 0.9275 lineto
fill
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 151; pictureTop = 2; pictureWidth = 114; pictureHeight = 114; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(4)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
0.40125 0.2325 moveto
0.80875 0.37 lineto
0.59875 0.7675 lineto
0.19125 0.63 lineto
fill
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 151; pictureTop = 2; pictureWidth = 114; pictureHeight = 114; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(4)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
0.605 0.30125 moveto
0.70375 0.56875 lineto
0.395 0.69875 lineto
0.29625 0.43125 lineto
fill
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
The behavior for triangles and quadrillaterals is easy to predict.  We obtain sequences of similar figures aproaching a point in the limit. What happen if we take  n-gons where n is greater then 4 ? Is situation different for  selfintersecting polygons?
:[font = input; startGroup; ]
MidPointPolygonMovie[{{-0.66, -0.67},{-0.27, -0.87},
                      {0.85, 0.22},{0.61, 0.90},
                      {-0.66, 0.69}, {-0.03, 0.08}},
                     TotalFrameNumber ->6
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 149; pictureWidth = 115; pictureHeight = 115; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.18333 0.13583 moveto
0.37833 0.03583 lineto
0.93833 0.58083 lineto
0.81833 0.92083 lineto
0.18333 0.81583 lineto
0.49833 0.51083 lineto
stroke
0.18333 0.13583 moveto
0.49833 0.51083 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 149; pictureWidth = 115; pictureHeight = 115; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.28083 0.08583 moveto
0.65833 0.30833 lineto
0.87833 0.75083 lineto
0.50083 0.86833 lineto
0.34083 0.66333 lineto
0.34083 0.32333 lineto
stroke
0.28083 0.08583 moveto
0.34083 0.32333 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 149; pictureWidth = 115; pictureHeight = 115; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.46958 0.19708 moveto
0.76833 0.52958 lineto
0.68958 0.80958 lineto
0.42083 0.76583 lineto
0.34083 0.49333 lineto
0.31083 0.20458 lineto
stroke
0.46958 0.19708 moveto
0.31083 0.20458 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 149; pictureWidth = 115; pictureHeight = 115; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.61896 0.36333 moveto
0.72896 0.66958 lineto
0.55521 0.78771 lineto
0.38083 0.62958 lineto
0.32583 0.34896 lineto
0.39021 0.20083 lineto
stroke
0.61896 0.36333 moveto
0.39021 0.20083 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 149; pictureWidth = 115; pictureHeight = 115; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(4)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.67396 0.51646 moveto
0.64208 0.72865 lineto
0.46802 0.70865 lineto
0.35333 0.48927 lineto
0.35802 0.2749 lineto
0.50458 0.28208 lineto
stroke
0.67396 0.51646 moveto
0.50458 0.28208 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 149; pictureWidth = 115; pictureHeight = 115; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(5)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.65802 0.62255 moveto
0.55505 0.71865 lineto
0.41068 0.59896 lineto
0.35568 0.38208 lineto
0.4313 0.27849 lineto
0.58927 0.39927 lineto
stroke
0.65802 0.62255 moveto
0.58927 0.39927 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
Even if the original hexagon was concave, its descendants are convex and smaller. More, the hexagon in the sixth frame seems to have some regularity. And what are the descandants of a self intersecting polygon?
:[font = input; startGroup; ]
MidPointPolygonMovie[{{-0.09,0.78}, {-0.48,-0.58},
                      {0.77,0.11},{-0.71,0.25},
                       {0.49,-0.80}},
                       TotalFrameNumber ->4
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 136; pictureTop = 2; pictureWidth = 144; pictureHeight = 144; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.457 0.91363 moveto
0.262 0.23363 lineto
0.887 0.58048 lineto
0.147 0.64863 lineto
0.747 0.12363 lineto
stroke
0.457 0.91363 moveto
0.747 0.12363 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 136; pictureTop = 2; pictureWidth = 144; pictureHeight = 144; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.3595 0.57363 moveto
0.5745 0.40706 lineto
0.517 0.61456 lineto
0.447 0.38613 lineto
0.602 0.51863 lineto
stroke
0.3595 0.57363 moveto
0.602 0.51863 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 136; pictureTop = 2; pictureWidth = 144; pictureHeight = 144; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.467 0.49034 moveto
0.54575 0.51081 lineto
0.482 0.50034 lineto
0.5245 0.45238 lineto
0.48075 0.54613 lineto
stroke
0.467 0.49034 moveto
0.48075 0.54613 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 136; pictureTop = 2; pictureWidth = 144; pictureHeight = 144; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.50638 0.50057 moveto
0.51388 0.50557 lineto
0.50325 0.47636 lineto
0.50263 0.49925 lineto
0.47388 0.51824 lineto
stroke
0.50638 0.50057 moveto
0.47388 0.51824 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; ]

:[font = text; inactive; ]
 The convergence to a point for the above figure is very rapid at the biginning. We would like to see what is the shape of  let say 10th  and 20th  descendant. It will be very small, so let us resize the pictures.
:[font = input; startGroup; ]
MidPointPolygonMovie[{{-0.09,0.78},{-0.48,-0.58},
                      {0.77,0.11},{-0.71,0.25},
                       {0.49,-0.80}},
                       Blowing->Resized,
                       IterationStep->10,
                       TotalFrameNumber->3
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 145; pictureTop = 2; pictureWidth = 134; pictureHeight = 134; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.20773)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.44807 1 moveto
0.21256 0.17874 lineto
0.96739 0.59541 lineto
0.07367 0.67995 lineto
0.79831 0.04589 lineto
stroke
0.44807 1 moveto
0.79831 0.04589 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 145; pictureTop = 2; pictureWidth = 134; pictureHeight = 134; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(148.277)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.01752 0.72242 moveto
0.17246 0.99826 lineto
0.78063 0.5863 lineto
1 0.05488 lineto
0.52939 0.13814 lineto
stroke
0.01752 0.72242 moveto
0.52939 0.13814 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 145; pictureTop = 2; pictureWidth = 134; pictureHeight = 134; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(20)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1233.41)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.01797 0.72174 moveto
0.17301 0.99816 lineto
0.77994 0.58614 lineto
1 0.05507 lineto
0.52908 0.13888 lineto
stroke
0.01797 0.72174 moveto
0.52908 0.13888 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
They are convex and their shape is nearly exactly the same.  Is it true that all polygons will eventually become convex? Let us take any random polygon and look at every other iteration.
:[font = input; startGroup; ]
MidPointPolygonMovie[Table[{Random[],Random[]},{10}],
                      Blowing->Resized,
                      TotalFrameNumber->8,
                      IterationStep->2,
                      
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.10305)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.58801 0.87938 Mdot
0.67307 0.28048 Mdot
0.43726 0.52967 Mdot
0.78032 0.37486 Mdot
0.31044 0.48664 Mdot
0.25199 0.1973 Mdot
0.63663 0.13198 Mdot
0.45174 1 Mdot
0.60471 0.53528 Mdot
0.26582 0.58442 Mdot
0.004 setlinewidth
0.58801 0.87938 moveto
0.67307 0.28048 lineto
0.43726 0.52967 lineto
0.78032 0.37486 lineto
0.31044 0.48664 lineto
0.25199 0.1973 lineto
0.63663 0.13198 lineto
0.45174 1 lineto
0.60471 0.53528 lineto
0.26582 0.58442 lineto
stroke
0.58801 0.87938 moveto
0.26582 0.58442 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.26241)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.68819 0.4848 Mdot
0.66615 0.35543 Mdot
0.65624 0.38145 Mdot
0.32428 0.26967 Mdot
0.22185 0 Mdot
0.48834 0.22702 Mdot
0.57338 0.8381 Mdot
0.463 0.83187 Mdot
0.36033 0.79566 Mdot
0.55823 0.816 Mdot
0.004 setlinewidth
0.68819 0.4848 moveto
0.66615 0.35543 lineto
0.65624 0.38145 lineto
0.32428 0.26967 lineto
0.22185 0 lineto
0.48834 0.22702 lineto
0.57338 0.8381 lineto
0.463 0.83187 lineto
0.36033 0.79566 lineto
0.55823 0.816 lineto
stroke
0.68819 0.4848 moveto
0.55823 0.816 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(4)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.67072)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.72508 0.35934 Mdot
0.60075 0.29645 Mdot
0.34256 0.14106 Mdot
0.25265 0 Mdot
0.42414 0.26457 Mdot
0.53263 0.74449 Mdot
0.45334 0.93155 Mdot
0.41415 0.91215 Mdot
0.55487 0.80349 Mdot
0.69982 0.54691 Mdot
0.004 setlinewidth
0.72508 0.35934 moveto
0.60075 0.29645 lineto
0.34256 0.14106 lineto
0.25265 0 lineto
0.42414 0.26457 lineto
0.53263 0.74449 lineto
0.45334 0.93155 lineto
0.41415 0.91215 lineto
0.55487 0.80349 lineto
0.69982 0.54691 lineto
stroke
0.72508 0.35934 moveto
0.69982 0.54691 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(6)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(7.11338)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.5844 0.21566 Mdot
0.35528 0.05423 Mdot
0.2717 0 Mdot
0.38508 0.27221 Mdot
0.48204 0.71485 Mdot
0.45405 0.97659 Mdot
0.44873 0.98901 Mdot
0.57016 0.83431 Mdot
0.71312 0.58049 Mdot
0.73543 0.36266 Mdot
0.004 setlinewidth
0.5844 0.21566 moveto
0.35528 0.05423 lineto
0.2717 0 lineto
0.38508 0.27221 lineto
0.48204 0.71485 lineto
0.45405 0.97659 lineto
0.44873 0.98901 lineto
0.57016 0.83431 lineto
0.71312 0.58049 lineto
0.73543 0.36266 lineto
stroke
0.5844 0.21566 moveto
0.73543 0.36266 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(8)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(7.95267)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.37889 0.0316 Mdot
0.29982 0.03225 Mdot
0.36693 0.29297 Mdot
0.445 0.68964 Mdot
0.45496 0.96314 Mdot
0.47811 1 Mdot
0.58445 0.84605 Mdot
0.70454 0.60004 Mdot
0.71476 0.36625 Mdot
0.57254 0.17808 Mdot
0.004 setlinewidth
0.37889 0.0316 moveto
0.29982 0.03225 lineto
0.36693 0.29297 lineto
0.445 0.68964 lineto
0.45496 0.96314 lineto
0.47811 1 lineto
0.58445 0.84605 lineto
0.70454 0.60004 lineto
0.71476 0.36625 lineto
0.57254 0.17808 lineto
stroke
0.37889 0.0316 moveto
0.57254 0.17808 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.79142)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.3191 0.05479 Mdot
0.35593 0.3087 Mdot
0.42038 0.6756 Mdot
0.45386 0.94658 Mdot
0.49879 1 Mdot
0.59716 0.85711 Mdot
0.69575 0.61397 Mdot
0.69528 0.36475 Mdot
0.56597 0.15565 Mdot
0.39778 0.02286 Mdot
0.004 setlinewidth
0.3191 0.05479 moveto
0.35593 0.3087 lineto
0.42038 0.6756 lineto
0.45386 0.94658 lineto
0.49879 1 lineto
0.59716 0.85711 lineto
0.69575 0.61397 lineto
0.69528 0.36475 lineto
0.56597 0.15565 lineto
0.39778 0.02286 lineto
stroke
0.3191 0.05479 moveto
0.39778 0.02286 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(12)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(9.74826)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.3479 0.3192 Mdot
0.40313 0.66812 Mdot
0.45201 0.93488 Mdot
0.51347 1 Mdot
0.6078 0.86818 Mdot
0.6896 0.62469 Mdot
0.68082 0.36115 Mdot
0.56237 0.13932 Mdot
0.41147 0.01659 Mdot
0.33143 0.06787 Mdot
0.004 setlinewidth
0.3479 0.3192 moveto
0.40313 0.66812 lineto
0.45201 0.93488 lineto
0.51347 1 lineto
0.6078 0.86818 lineto
0.6896 0.62469 lineto
0.68082 0.36115 lineto
0.56237 0.13932 lineto
0.41147 0.01659 lineto
0.33143 0.06787 lineto
stroke
0.3479 0.3192 moveto
0.33143 0.06787 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 146; pictureTop = 2; pictureWidth = 143; pictureHeight = 143; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(14)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(10)] 1 1 1.7 1.7 Mshowa
0 setgray
[(10.813)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.39079 0.6637 Mdot
0.45026 0.92646 Mdot
0.52406 1 Mdot
0.6161 0.87743 Mdot
0.68519 0.63275 Mdot
0.67016 0.35755 Mdot
0.56019 0.12741 Mdot
0.42145 0.01204 Mdot
0.33978 0.07614 Mdot
0.34204 0.32651 Mdot
0.004 setlinewidth
0.39079 0.6637 moveto
0.45026 0.92646 lineto
0.52406 1 lineto
0.6161 0.87743 lineto
0.68519 0.63275 lineto
0.67016 0.35755 lineto
0.56019 0.12741 lineto
0.42145 0.01204 lineto
0.33978 0.07614 lineto
0.34204 0.32651 lineto
stroke
0.39079 0.6637 moveto
0.34204 0.32651 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
You can look at the descandants of a random polygon again and again. And during each time you will obtain the convex polygons. Does it mean that all polygons will eventually become convex? The answer is no! There are polygons whose all descendants are even selfintersecting. However, the co-dimension of  all of them is 1 with respect to the dimension of all polygons (for fixed number of vertices). Therefore, it  is imposible to find them randomly. The function RandomStellarPolygon generates such polygons.  Let us show a RandomStellarPolygon when the number of vertices is 7 (for quadrillaterals we already know that descendants of  all of them are convex figures; you can also do i t for 5 and 6 vertices instead of 7).
:[font = input; startGroup; ]
MidPointPolygonMovie[RandomStellarPolygon[7],
                     Blowing->Resized,
                     TotalFrameNumber->6
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 154; pictureTop = 2; pictureWidth = 132; pictureHeight = 132; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.44606 0.74376 moveto
0.86408 0.33793 lineto
0 0.41654 lineto
0.77164 0.51738 lineto
0.52647 0.81518 lineto
0.43882 0.09268 lineto
0.45293 0.57652 lineto
stroke
0.44606 0.74376 moveto
0.45293 0.57652 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 154; pictureTop = 2; pictureWidth = 132; pictureHeight = 132; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.0069)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.96627 0.62282 moveto
0.29565 0.13086 lineto
0.15667 0.40066 lineto
0.94819 1 lineto
0.44782 0.36147 lineto
0.33726 0.00265 lineto
0.34814 0.98153 lineto
stroke
0.96627 0.62282 moveto
0.34814 0.98153 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 154; pictureTop = 2; pictureWidth = 132; pictureHeight = 132; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.72874)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.70595 0.30632 moveto
0.06935 0.13163 lineto
0.58245 0.81505 lineto
0.81139 0.78423 lineto
0.331 0 lineto
0.25263 0.48756 lineto
0.74723 0.97521 lineto
stroke
0.70595 0.30632 moveto
0.74723 0.97521 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 154; pictureTop = 2; pictureWidth = 132; pictureHeight = 132; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(7.89074)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.31253 0.03106 moveto
0.20948 0.45551 lineto
0.8286 1 lineto
0.6188 0.31998 lineto
0.15261 0.07245 lineto
0.49988 0.88611 lineto
0.87811 0.73489 lineto
stroke
0.31253 0.03106 moveto
0.87811 0.73489 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 154; pictureTop = 2; pictureWidth = 132; pictureHeight = 132; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(4)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(12.7064)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.11515 0.08661 moveto
0.53066 0.86675 lineto
0.86022 0.75763 lineto
0.31595 0.01081 lineto
0.2202 0.46664 lineto
0.80433 1 lineto
0.65349 0.31156 lineto
stroke
0.11515 0.08661 moveto
0.65349 0.31156 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 154; pictureTop = 2; pictureWidth = 132; pictureHeight = 132; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(5)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(20.3505)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.21636 0.46265 moveto
0.81302 1 lineto
0.64108 0.31457 lineto
0.12855 0.08155 lineto
0.51965 0.87368 lineto
0.86662 0.74949 lineto
0.31472 0.01806 lineto
stroke
0.21636 0.46265 moveto
0.31472 0.01806 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
The iterations far enough are similar. If we look at all above frames, we can easily notice that all vertices lie on an ellipse. This is true even for 'stellar polygons' . The only difference is that they are not situated  in a consecutive manner. There is an option which shows the limit ellipse. (Obviously, we have to enlarge each picture. But the scaling factor is constant according to the theorem 1.)
:[font = input; startGroup; ]
MidPointPolygonMovie[{{...........}},
                      Style->VerticesOnBoundary,
                      TotalFrameNumber->4,
                      ShowEllipse ->True
                    ]
:[font = print; inactive; ]
                                                     1
Each picture is resized by the the scaling factor:-------
                                                      Pi
                                                  Cos[--]
                                                      8
:[font = postscript; inactive; PostScript; output; pictureLeft = 100; pictureTop = 2; pictureWidth = 232; pictureHeight = 232; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(8)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.50968 0.06938 moveto
0.48261 0.0646 lineto
0.45565 0.06251 lineto
0.42896 0.06312 lineto
0.40271 0.06641 lineto
0.37706 0.07239 lineto
0.35217 0.081 lineto
0.32819 0.09219 lineto
0.30527 0.10589 lineto
0.28355 0.12203 lineto
0.26317 0.1405 lineto
0.24424 0.16118 lineto
0.22689 0.18395 lineto
0.21123 0.20867 lineto
0.19734 0.23519 lineto
0.18532 0.26334 lineto
0.17524 0.29295 lineto
0.16717 0.32383 lineto
0.16114 0.3558 lineto
0.15721 0.38866 lineto
0.15539 0.42221 lineto
0.15569 0.45624 lineto
0.15811 0.49053 lineto
0.16265 0.52489 lineto
0.16926 0.55909 lineto
0.17791 0.59292 lineto
0.18855 0.62619 lineto
0.20111 0.65867 lineto
0.21551 0.69018 lineto
0.23167 0.72052 lineto
0.24948 0.74949 lineto
0.26883 0.77693 lineto
0.28961 0.80266 lineto
0.31169 0.82652 lineto
0.33492 0.84837 lineto
0.35918 0.86807 lineto
0.3843 0.88551 lineto
0.41014 0.90057 lineto
0.43653 0.91315 lineto
0.46331 0.92319 lineto
0.49032 0.93062 lineto
0.51739 0.9354 lineto
0.54435 0.93749 lineto
0.57104 0.93688 lineto
0.59729 0.93359 lineto
0.62294 0.92761 lineto
0.64783 0.919 lineto
0.67181 0.90781 lineto
0.69473 0.89411 lineto
0.71645 0.87797 lineto
Mistroke
0.73683 0.8595 lineto
0.75576 0.83882 lineto
0.77311 0.81605 lineto
0.78877 0.79133 lineto
0.80266 0.76481 lineto
0.81468 0.73666 lineto
0.82476 0.70705 lineto
0.83283 0.67617 lineto
0.83886 0.6442 lineto
0.84279 0.61134 lineto
0.84461 0.57779 lineto
0.84431 0.54376 lineto
0.84189 0.50947 lineto
0.83735 0.47511 lineto
0.83074 0.44091 lineto
0.82209 0.40708 lineto
0.81145 0.37381 lineto
0.79889 0.34133 lineto
0.78449 0.30982 lineto
0.76833 0.27948 lineto
0.75052 0.25051 lineto
0.73117 0.22307 lineto
0.71039 0.19734 lineto
0.68831 0.17348 lineto
0.66508 0.15163 lineto
0.64082 0.13193 lineto
0.6157 0.11449 lineto
0.58986 0.09943 lineto
0.56347 0.08685 lineto
0.53669 0.07681 lineto
0.50968 0.06938 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.1641 0.11761 Mdot
0.35388 0.42884 Mdot
0.11856 0.66415 Mdot
0.39942 0.99056 Mdot
0.96115 0.92224 Mdot
0.68028 0.51993 Mdot
0.80933 0.17074 Mdot
0.51328 0.18593 Mdot
0.004 setlinewidth
0.1641 0.11761 moveto
0.35388 0.42884 lineto
0.11856 0.66415 lineto
0.39942 0.99056 lineto
0.96115 0.92224 lineto
0.68028 0.51993 lineto
0.80933 0.17074 lineto
0.51328 0.18593 lineto
stroke
0.1641 0.11761 moveto
0.51328 0.18593 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 100; pictureTop = 2; pictureWidth = 232; pictureHeight = 232; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(8)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.08239)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.50968 0.06938 moveto
0.48261 0.0646 lineto
0.45565 0.06251 lineto
0.42896 0.06312 lineto
0.40271 0.06641 lineto
0.37706 0.07239 lineto
0.35217 0.081 lineto
0.32819 0.09219 lineto
0.30527 0.10589 lineto
0.28355 0.12203 lineto
0.26317 0.1405 lineto
0.24424 0.16118 lineto
0.22689 0.18395 lineto
0.21123 0.20867 lineto
0.19734 0.23519 lineto
0.18532 0.26334 lineto
0.17524 0.29295 lineto
0.16717 0.32383 lineto
0.16114 0.3558 lineto
0.15721 0.38866 lineto
0.15539 0.42221 lineto
0.15569 0.45624 lineto
0.15811 0.49053 lineto
0.16265 0.52489 lineto
0.16926 0.55909 lineto
0.17791 0.59292 lineto
0.18855 0.62619 lineto
0.20111 0.65867 lineto
0.21551 0.69018 lineto
0.23167 0.72052 lineto
0.24948 0.74949 lineto
0.26883 0.77693 lineto
0.28961 0.80266 lineto
0.31169 0.82652 lineto
0.33492 0.84837 lineto
0.35918 0.86807 lineto
0.3843 0.88551 lineto
0.41014 0.90057 lineto
0.43653 0.91315 lineto
0.46331 0.92319 lineto
0.49032 0.93062 lineto
0.51739 0.9354 lineto
0.54435 0.93749 lineto
0.57104 0.93688 lineto
0.59729 0.93359 lineto
0.62294 0.92761 lineto
0.64783 0.919 lineto
0.67181 0.90781 lineto
0.69473 0.89411 lineto
0.71645 0.87797 lineto
Mistroke
0.73683 0.8595 lineto
0.75576 0.83882 lineto
0.77311 0.81605 lineto
0.78877 0.79133 lineto
0.80266 0.76481 lineto
0.81468 0.73666 lineto
0.82476 0.70705 lineto
0.83283 0.67617 lineto
0.83886 0.6442 lineto
0.84279 0.61134 lineto
0.84461 0.57779 lineto
0.84431 0.54376 lineto
0.84189 0.50947 lineto
0.83735 0.47511 lineto
0.83074 0.44091 lineto
0.82209 0.40708 lineto
0.81145 0.37381 lineto
0.79889 0.34133 lineto
0.78449 0.30982 lineto
0.76833 0.27948 lineto
0.75052 0.25051 lineto
0.73117 0.22307 lineto
0.71039 0.19734 lineto
0.68831 0.17348 lineto
0.66508 0.15163 lineto
0.64082 0.13193 lineto
0.6157 0.11449 lineto
0.58986 0.09943 lineto
0.56347 0.08685 lineto
0.53669 0.07681 lineto
0.50968 0.06938 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.23913 0.25454 Mdot
0.21448 0.55033 Mdot
0.23913 0.85433 Mdot
0.69514 0.99401 Mdot
0.84714 0.7393 Mdot
0.76498 0.33259 Mdot
0.6746 0.15183 Mdot
0.3254 0.12308 Mdot
0.004 setlinewidth
0.23913 0.25454 moveto
0.21448 0.55033 lineto
0.23913 0.85433 lineto
0.69514 0.99401 lineto
0.84714 0.7393 lineto
0.76498 0.33259 lineto
0.6746 0.15183 lineto
0.3254 0.12308 lineto
stroke
0.23913 0.25454 moveto
0.3254 0.12308 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 100; pictureTop = 2; pictureWidth = 232; pictureHeight = 232; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(8)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.17157)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.50968 0.06938 moveto
0.48261 0.0646 lineto
0.45565 0.06251 lineto
0.42896 0.06312 lineto
0.40271 0.06641 lineto
0.37706 0.07239 lineto
0.35217 0.081 lineto
0.32819 0.09219 lineto
0.30527 0.10589 lineto
0.28355 0.12203 lineto
0.26317 0.1405 lineto
0.24424 0.16118 lineto
0.22689 0.18395 lineto
0.21123 0.20867 lineto
0.19734 0.23519 lineto
0.18532 0.26334 lineto
0.17524 0.29295 lineto
0.16717 0.32383 lineto
0.16114 0.3558 lineto
0.15721 0.38866 lineto
0.15539 0.42221 lineto
0.15569 0.45624 lineto
0.15811 0.49053 lineto
0.16265 0.52489 lineto
0.16926 0.55909 lineto
0.17791 0.59292 lineto
0.18855 0.62619 lineto
0.20111 0.65867 lineto
0.21551 0.69018 lineto
0.23167 0.72052 lineto
0.24948 0.74949 lineto
0.26883 0.77693 lineto
0.28961 0.80266 lineto
0.31169 0.82652 lineto
0.33492 0.84837 lineto
0.35918 0.86807 lineto
0.3843 0.88551 lineto
0.41014 0.90057 lineto
0.43653 0.91315 lineto
0.46331 0.92319 lineto
0.49032 0.93062 lineto
0.51739 0.9354 lineto
0.54435 0.93749 lineto
0.57104 0.93688 lineto
0.59729 0.93359 lineto
0.62294 0.92761 lineto
0.64783 0.919 lineto
0.67181 0.90781 lineto
0.69473 0.89411 lineto
0.71645 0.87797 lineto
Mistroke
0.73683 0.8595 lineto
0.75576 0.83882 lineto
0.77311 0.81605 lineto
0.78877 0.79133 lineto
0.80266 0.76481 lineto
0.81468 0.73666 lineto
0.82476 0.70705 lineto
0.83283 0.67617 lineto
0.83886 0.6442 lineto
0.84279 0.61134 lineto
0.84461 0.57779 lineto
0.84431 0.54376 lineto
0.84189 0.50947 lineto
0.83735 0.47511 lineto
0.83074 0.44091 lineto
0.82209 0.40708 lineto
0.81145 0.37381 lineto
0.79889 0.34133 lineto
0.78449 0.30982 lineto
0.76833 0.27948 lineto
0.75052 0.25051 lineto
0.73117 0.22307 lineto
0.71039 0.19734 lineto
0.68831 0.17348 lineto
0.66508 0.15163 lineto
0.64082 0.13193 lineto
0.6157 0.11449 lineto
0.58986 0.09943 lineto
0.56347 0.08685 lineto
0.53669 0.07681 lineto
0.50968 0.06938 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.2043 0.39439 Mdot
0.2043 0.719 Mdot
0.46443 0.95912 Mdot
0.79348 0.89686 Mdot
0.83128 0.53891 Mdot
0.7379 0.22097 Mdot
0.5 0.10758 Mdot
0.26433 0.16317 Mdot
0.004 setlinewidth
0.2043 0.39439 moveto
0.2043 0.719 lineto
0.46443 0.95912 lineto
0.79348 0.89686 lineto
0.83128 0.53891 lineto
0.7379 0.22097 lineto
0.5 0.10758 lineto
0.26433 0.16317 lineto
stroke
0.2043 0.39439 moveto
0.26433 0.16317 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 100; pictureTop = 2; pictureWidth = 232; pictureHeight = 232; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(8)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.2681)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.50968 0.06938 moveto
0.48261 0.0646 lineto
0.45565 0.06251 lineto
0.42896 0.06312 lineto
0.40271 0.06641 lineto
0.37706 0.07239 lineto
0.35217 0.081 lineto
0.32819 0.09219 lineto
0.30527 0.10589 lineto
0.28355 0.12203 lineto
0.26317 0.1405 lineto
0.24424 0.16118 lineto
0.22689 0.18395 lineto
0.21123 0.20867 lineto
0.19734 0.23519 lineto
0.18532 0.26334 lineto
0.17524 0.29295 lineto
0.16717 0.32383 lineto
0.16114 0.3558 lineto
0.15721 0.38866 lineto
0.15539 0.42221 lineto
0.15569 0.45624 lineto
0.15811 0.49053 lineto
0.16265 0.52489 lineto
0.16926 0.55909 lineto
0.17791 0.59292 lineto
0.18855 0.62619 lineto
0.20111 0.65867 lineto
0.21551 0.69018 lineto
0.23167 0.72052 lineto
0.24948 0.74949 lineto
0.26883 0.77693 lineto
0.28961 0.80266 lineto
0.31169 0.82652 lineto
0.33492 0.84837 lineto
0.35918 0.86807 lineto
0.3843 0.88551 lineto
0.41014 0.90057 lineto
0.43653 0.91315 lineto
0.46331 0.92319 lineto
0.49032 0.93062 lineto
0.51739 0.9354 lineto
0.54435 0.93749 lineto
0.57104 0.93688 lineto
0.59729 0.93359 lineto
0.62294 0.92761 lineto
0.64783 0.919 lineto
0.67181 0.90781 lineto
0.69473 0.89411 lineto
0.71645 0.87797 lineto
Mistroke
0.73683 0.8595 lineto
0.75576 0.83882 lineto
0.77311 0.81605 lineto
0.78877 0.79133 lineto
0.80266 0.76481 lineto
0.81468 0.73666 lineto
0.82476 0.70705 lineto
0.83283 0.67617 lineto
0.83886 0.6442 lineto
0.84279 0.61134 lineto
0.84461 0.57779 lineto
0.84431 0.54376 lineto
0.84189 0.50947 lineto
0.83735 0.47511 lineto
0.83074 0.44091 lineto
0.82209 0.40708 lineto
0.81145 0.37381 lineto
0.79889 0.34133 lineto
0.78449 0.30982 lineto
0.76833 0.27948 lineto
0.75052 0.25051 lineto
0.73117 0.22307 lineto
0.71039 0.19734 lineto
0.68831 0.17348 lineto
0.66508 0.15163 lineto
0.64082 0.13193 lineto
0.6157 0.11449 lineto
0.58986 0.09943 lineto
0.56347 0.08685 lineto
0.53669 0.07681 lineto
0.50968 0.06938 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.17993 0.56137 Mdot
0.32072 0.86699 Mdot
0.63958 0.96325 Mdot
0.83811 0.73584 Mdot
0.80803 0.37005 Mdot
0.62875 0.13662 Mdot
0.37245 0.10533 Mdot
0.21242 0.26055 Mdot
0.004 setlinewidth
0.17993 0.56137 moveto
0.32072 0.86699 lineto
0.63958 0.96325 lineto
0.83811 0.73584 lineto
0.80803 0.37005 lineto
0.62875 0.13662 lineto
0.37245 0.10533 lineto
0.21242 0.26055 lineto
stroke
0.17993 0.56137 moveto
0.21242 0.26055 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
The vertices of every other descendant lie at the same points on the ellipse. The scaling factor is the same for all polygons whose descendants become convex. For  other polygons the scaling factor is  different.
:[font = input; startGroup; ]
MidPointPolygonMovie[RandomStellarPolygon[9],
                      IterationStep->10,
                      ShowEllipse ->True
                    ]
:[font = print; inactive; ]
Each picture is resized by the the scaling factor:
 
      1
  ---------
      2 Pi
  Cos[----]
       9
:[font = postscript; inactive; PostScript; output; pictureLeft = 96; pictureTop = 2; pictureWidth = 236; pictureHeight = 236; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(9)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.41659 0.62965 moveto
0.40937 0.617 lineto
0.40271 0.60363 lineto
0.39665 0.58962 lineto
0.39122 0.57506 lineto
0.38647 0.56004 lineto
0.38241 0.54464 lineto
0.37908 0.52897 lineto
0.3765 0.51312 lineto
0.37467 0.49719 lineto
0.37362 0.48128 lineto
0.37335 0.46548 lineto
0.37386 0.4499 lineto
0.37515 0.43463 lineto
0.3772 0.41975 lineto
0.38002 0.40538 lineto
0.38357 0.39158 lineto
0.38784 0.37846 lineto
0.39281 0.36608 lineto
0.39843 0.35453 lineto
0.40468 0.34388 lineto
0.41152 0.33419 lineto
0.4189 0.32552 lineto
0.42678 0.31793 lineto
0.43512 0.31146 lineto
0.44385 0.30615 lineto
0.45293 0.30203 lineto
0.46231 0.29914 lineto
0.47191 0.29749 lineto
0.48169 0.29708 lineto
0.49158 0.29793 lineto
0.50152 0.30002 lineto
0.51145 0.30334 lineto
0.52131 0.30788 lineto
0.53104 0.3136 lineto
0.54058 0.32047 lineto
0.54987 0.32845 lineto
0.55885 0.33749 lineto
0.56747 0.34752 lineto
0.57567 0.3585 lineto
0.58341 0.37035 lineto
0.59063 0.383 lineto
0.59729 0.39637 lineto
0.60335 0.41038 lineto
0.60878 0.42494 lineto
0.61353 0.43996 lineto
0.61759 0.45536 lineto
0.62092 0.47103 lineto
0.6235 0.48688 lineto
0.62533 0.50281 lineto
Mistroke
0.62638 0.51872 lineto
0.62665 0.53452 lineto
0.62614 0.5501 lineto
0.62485 0.56537 lineto
0.6228 0.58025 lineto
0.61998 0.59462 lineto
0.61643 0.60842 lineto
0.61216 0.62154 lineto
0.60719 0.63392 lineto
0.60157 0.64547 lineto
0.59532 0.65612 lineto
0.58848 0.66581 lineto
0.5811 0.67448 lineto
0.57322 0.68207 lineto
0.56488 0.68854 lineto
0.55615 0.69385 lineto
0.54707 0.69797 lineto
0.53769 0.70086 lineto
0.52809 0.70251 lineto
0.51831 0.70292 lineto
0.50842 0.70207 lineto
0.49848 0.69998 lineto
0.48855 0.69666 lineto
0.47869 0.69212 lineto
0.46896 0.6864 lineto
0.45942 0.67953 lineto
0.45013 0.67155 lineto
0.44115 0.66251 lineto
0.43253 0.65248 lineto
0.42433 0.6415 lineto
0.41659 0.62965 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.52764 0.19747 moveto
0.4594 0.77434 lineto
0.65671 0.13039 lineto
0.47274 0.82738 lineto
0.43257 0.71494 lineto
0.38141 0 lineto
0.64934 0.52972 lineto
0.62892 0.80776 lineto
0.29127 0.518 lineto
stroke
0.52764 0.19747 moveto
0.29127 0.518 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 96; pictureTop = 2; pictureWidth = 236; pictureHeight = 236; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(9)] 1 1 1.7 1.7 Mshowa
0 setgray
[(14.3701)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.41659 0.62965 moveto
0.40937 0.617 lineto
0.40271 0.60363 lineto
0.39665 0.58962 lineto
0.39122 0.57506 lineto
0.38647 0.56004 lineto
0.38241 0.54464 lineto
0.37908 0.52897 lineto
0.3765 0.51312 lineto
0.37467 0.49719 lineto
0.37362 0.48128 lineto
0.37335 0.46548 lineto
0.37386 0.4499 lineto
0.37515 0.43463 lineto
0.3772 0.41975 lineto
0.38002 0.40538 lineto
0.38357 0.39158 lineto
0.38784 0.37846 lineto
0.39281 0.36608 lineto
0.39843 0.35453 lineto
0.40468 0.34388 lineto
0.41152 0.33419 lineto
0.4189 0.32552 lineto
0.42678 0.31793 lineto
0.43512 0.31146 lineto
0.44385 0.30615 lineto
0.45293 0.30203 lineto
0.46231 0.29914 lineto
0.47191 0.29749 lineto
0.48169 0.29708 lineto
0.49158 0.29793 lineto
0.50152 0.30002 lineto
0.51145 0.30334 lineto
0.52131 0.30788 lineto
0.53104 0.3136 lineto
0.54058 0.32047 lineto
0.54987 0.32845 lineto
0.55885 0.33749 lineto
0.56747 0.34752 lineto
0.57567 0.3585 lineto
0.58341 0.37035 lineto
0.59063 0.383 lineto
0.59729 0.39637 lineto
0.60335 0.41038 lineto
0.60878 0.42494 lineto
0.61353 0.43996 lineto
0.61759 0.45536 lineto
0.62092 0.47103 lineto
0.6235 0.48688 lineto
0.62533 0.50281 lineto
Mistroke
0.62638 0.51872 lineto
0.62665 0.53452 lineto
0.62614 0.5501 lineto
0.62485 0.56537 lineto
0.6228 0.58025 lineto
0.61998 0.59462 lineto
0.61643 0.60842 lineto
0.61216 0.62154 lineto
0.60719 0.63392 lineto
0.60157 0.64547 lineto
0.59532 0.65612 lineto
0.58848 0.66581 lineto
0.5811 0.67448 lineto
0.57322 0.68207 lineto
0.56488 0.68854 lineto
0.55615 0.69385 lineto
0.54707 0.69797 lineto
0.53769 0.70086 lineto
0.52809 0.70251 lineto
0.51831 0.70292 lineto
0.50842 0.70207 lineto
0.49848 0.69998 lineto
0.48855 0.69666 lineto
0.47869 0.69212 lineto
0.46896 0.6864 lineto
0.45942 0.67953 lineto
0.45013 0.67155 lineto
0.44115 0.66251 lineto
0.43253 0.65248 lineto
0.42433 0.6415 lineto
0.41659 0.62965 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.45836 0.29599 moveto
0.61168 0.43182 lineto
0.57949 0.67999 lineto
0.4158 0.62567 lineto
0.39235 0.36902 lineto
0.54587 0.3285 lineto
0.62345 0.5664 lineto
0.49808 0.69993 lineto
0.37493 0.50269 lineto
stroke
0.45836 0.29599 moveto
0.37493 0.50269 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
The options ShowEllipse and RandomStellarPolygon are designed mainly to illustrate the  theorems stated in the mathematical introduction.



:[font = text; inactive; ]
It is interesting to notice that the oposite sides of  any random stellar hexagon  have the  same midpoints.
:[font = input; startGroup; ]
MidPointPolygonMovie[RandomStellarPolygon[6],TotalFrameNumber->1]
:[font = postscript; inactive; PostScript; output; endGroup; endGroup; pictureLeft = 37; pictureTop = 2; pictureWidth = 282; pictureHeight = 282; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(6)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Real)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
1 0.52463 moveto
0.14964 0.58012 lineto
0.51606 0.50039 lineto
0.66859 0.31435 lineto
0.48105 0.7904 lineto
0.18465 0.29011 lineto
stroke
1 0.52463 moveto
0.18465 0.29011 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = subsection; inactive; startGroup; Cclosed; ]
More advanced examples.
:[font = text; inactive; ]
    In above subsection we have illustrated that all polygons finally lie on the 'midpoint' ellipse. One can notice more, namely that if we connect the vertices of descendents with the origin, the constucted triangles will have the same area in the limit. (Obviously, this has nothing to do with Kepler's low  since the origin is at the center of the ellipse.) This fact is clear if we notice that  the descendants in the limit are the affine images of regular stellar polygons. (The affine projection preserves the ratio of areas.)
:[font = input; ]
MidPointPolygonMovie[{{................}},
                      TotalFrameNumber->3,
                      IterationStep->40,
                      ShowEllipse ->True,
                      Style->Spokes
                    ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 241; pictureHeight = 241; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(26)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.57028 0.71794 moveto
0.55724 0.73576 lineto
0.54385 0.75213 lineto
0.53019 0.76695 lineto
0.51635 0.78012 lineto
0.5024 0.79156 lineto
0.48844 0.80121 lineto
0.47455 0.80899 lineto
0.46082 0.81488 lineto
0.44732 0.81882 lineto
0.43416 0.8208 lineto
0.4214 0.82079 lineto
0.40912 0.81881 lineto
0.3974 0.81487 lineto
0.38632 0.80898 lineto
0.37594 0.80119 lineto
0.36632 0.79154 lineto
0.35753 0.7801 lineto
0.34961 0.76693 lineto
0.34262 0.75211 lineto
0.3366 0.73574 lineto
0.33159 0.71791 lineto
0.32762 0.69874 lineto
0.32471 0.67835 lineto
0.32288 0.65685 lineto
0.32215 0.63439 lineto
0.32251 0.6111 lineto
0.32396 0.58713 lineto
0.3265 0.56261 lineto
0.33011 0.53772 lineto
0.33477 0.51258 lineto
0.34044 0.48738 lineto
0.3471 0.46225 lineto
0.3547 0.43735 lineto
0.3632 0.41284 lineto
0.37254 0.38886 lineto
0.38267 0.36557 lineto
0.39352 0.34311 lineto
0.40502 0.32162 lineto
0.41712 0.30123 lineto
0.42972 0.28206 lineto
0.44276 0.26424 lineto
0.45615 0.24787 lineto
0.46981 0.23305 lineto
0.48365 0.21988 lineto
0.4976 0.20844 lineto
0.51156 0.19879 lineto
0.52545 0.19101 lineto
0.53918 0.18512 lineto
0.55268 0.18118 lineto
Mistroke
0.56584 0.1792 lineto
0.5786 0.17921 lineto
0.59088 0.18119 lineto
0.6026 0.18513 lineto
0.61368 0.19102 lineto
0.62406 0.19881 lineto
0.63368 0.20846 lineto
0.64247 0.2199 lineto
0.65039 0.23307 lineto
0.65738 0.24789 lineto
0.6634 0.26426 lineto
0.66841 0.28209 lineto
0.67238 0.30126 lineto
0.67529 0.32165 lineto
0.67712 0.34315 lineto
0.67785 0.36561 lineto
0.67749 0.3889 lineto
0.67604 0.41287 lineto
0.6735 0.43739 lineto
0.66989 0.46228 lineto
0.66523 0.48742 lineto
0.65956 0.51262 lineto
0.6529 0.53775 lineto
0.6453 0.56265 lineto
0.6368 0.58716 lineto
0.62746 0.61114 lineto
0.61733 0.63443 lineto
0.60648 0.65689 lineto
0.59498 0.67838 lineto
0.58288 0.69877 lineto
0.57028 0.71794 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.44178 0.96219 Mdot
0.31742 0.91955 Mdot
0.39914 0.82006 Mdot
0.31031 0.75255 Mdot
0.13621 0.72412 Mdot
0.19661 0.57844 Mdot
0.05093 0.43987 Mdot
0.30321 0.41855 Mdot
0.39914 0.48251 Mdot
0.53417 0.61753 Mdot
0.67274 0.6424 Mdot
0.74025 0.51093 Mdot
0.72248 0.39368 Mdot
0.60523 0.31195 Mdot
0.38848 0.26576 Mdot
0.15042 0.23023 Mdot
0.1824 0.12008 Mdot
0.33874 0.14495 Mdot
0.50219 0.12719 Mdot
0.69761 0.21246 Mdot
0.80421 0.081 Mdot
0.87527 0.25155 Mdot
0.81131 0.51093 Mdot
0.93568 0.67793 Mdot
0.82908 0.85204 Mdot
0.65497 0.95153 Mdot
0.004 setlinewidth
0.44178 0.96219 moveto
0.31742 0.91955 lineto
0.39914 0.82006 lineto
0.31031 0.75255 lineto
0.13621 0.72412 lineto
0.19661 0.57844 lineto
0.05093 0.43987 lineto
0.30321 0.41855 lineto
0.39914 0.48251 lineto
0.53417 0.61753 lineto
0.67274 0.6424 lineto
0.74025 0.51093 lineto
0.72248 0.39368 lineto
0.60523 0.31195 lineto
0.38848 0.26576 lineto
0.15042 0.23023 lineto
0.1824 0.12008 lineto
0.33874 0.14495 lineto
0.50219 0.12719 lineto
0.69761 0.21246 lineto
0.80421 0.081 lineto
0.87527 0.25155 lineto
0.81131 0.51093 lineto
0.93568 0.67793 lineto
0.82908 0.85204 lineto
0.65497 0.95153 lineto
stroke
0.44178 0.96219 moveto
0.65497 0.95153 lineto
stroke
0.5 0.5 moveto
0.44178 0.96219 lineto
stroke
0.5 0.5 moveto
0.31742 0.91955 lineto
stroke
0.5 0.5 moveto
0.39914 0.82006 lineto
stroke
0.5 0.5 moveto
0.31031 0.75255 lineto
stroke
0.5 0.5 moveto
0.13621 0.72412 lineto
stroke
0.5 0.5 moveto
0.19661 0.57844 lineto
stroke
0.5 0.5 moveto
0.05093 0.43987 lineto
stroke
0.5 0.5 moveto
0.30321 0.41855 lineto
stroke
0.5 0.5 moveto
0.39914 0.48251 lineto
stroke
0.5 0.5 moveto
0.53417 0.61753 lineto
stroke
0.5 0.5 moveto
0.67274 0.6424 lineto
stroke
0.5 0.5 moveto
0.74025 0.51093 lineto
stroke
0.5 0.5 moveto
0.72248 0.39368 lineto
stroke
0.5 0.5 moveto
0.60523 0.31195 lineto
stroke
0.5 0.5 moveto
0.38848 0.26576 lineto
stroke
0.5 0.5 moveto
0.15042 0.23023 lineto
stroke
0.5 0.5 moveto
0.1824 0.12008 lineto
stroke
0.5 0.5 moveto
0.33874 0.14495 lineto
stroke
0.5 0.5 moveto
0.50219 0.12719 lineto
stroke
0.5 0.5 moveto
0.69761 0.21246 lineto
stroke
0.5 0.5 moveto
0.80421 0.081 lineto
stroke
0.5 0.5 moveto
0.87527 0.25155 lineto
stroke
0.5 0.5 moveto
0.81131 0.51093 lineto
stroke
0.5 0.5 moveto
0.93568 0.67793 lineto
stroke
0.5 0.5 moveto
0.82908 0.85204 lineto
stroke
0.5 0.5 moveto
0.65497 0.95153 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 241; pictureHeight = 241; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(40)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(26)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.34006)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.57028 0.71794 moveto
0.55724 0.73576 lineto
0.54385 0.75213 lineto
0.53019 0.76695 lineto
0.51635 0.78012 lineto
0.5024 0.79156 lineto
0.48844 0.80121 lineto
0.47455 0.80899 lineto
0.46082 0.81488 lineto
0.44732 0.81882 lineto
0.43416 0.8208 lineto
0.4214 0.82079 lineto
0.40912 0.81881 lineto
0.3974 0.81487 lineto
0.38632 0.80898 lineto
0.37594 0.80119 lineto
0.36632 0.79154 lineto
0.35753 0.7801 lineto
0.34961 0.76693 lineto
0.34262 0.75211 lineto
0.3366 0.73574 lineto
0.33159 0.71791 lineto
0.32762 0.69874 lineto
0.32471 0.67835 lineto
0.32288 0.65685 lineto
0.32215 0.63439 lineto
0.32251 0.6111 lineto
0.32396 0.58713 lineto
0.3265 0.56261 lineto
0.33011 0.53772 lineto
0.33477 0.51258 lineto
0.34044 0.48738 lineto
0.3471 0.46225 lineto
0.3547 0.43735 lineto
0.3632 0.41284 lineto
0.37254 0.38886 lineto
0.38267 0.36557 lineto
0.39352 0.34311 lineto
0.40502 0.32162 lineto
0.41712 0.30123 lineto
0.42972 0.28206 lineto
0.44276 0.26424 lineto
0.45615 0.24787 lineto
0.46981 0.23305 lineto
0.48365 0.21988 lineto
0.4976 0.20844 lineto
0.51156 0.19879 lineto
0.52545 0.19101 lineto
0.53918 0.18512 lineto
0.55268 0.18118 lineto
Mistroke
0.56584 0.1792 lineto
0.5786 0.17921 lineto
0.59088 0.18119 lineto
0.6026 0.18513 lineto
0.61368 0.19102 lineto
0.62406 0.19881 lineto
0.63368 0.20846 lineto
0.64247 0.2199 lineto
0.65039 0.23307 lineto
0.65738 0.24789 lineto
0.6634 0.26426 lineto
0.66841 0.28209 lineto
0.67238 0.30126 lineto
0.67529 0.32165 lineto
0.67712 0.34315 lineto
0.67785 0.36561 lineto
0.67749 0.3889 lineto
0.67604 0.41287 lineto
0.6735 0.43739 lineto
0.66989 0.46228 lineto
0.66523 0.48742 lineto
0.65956 0.51262 lineto
0.6529 0.53775 lineto
0.6453 0.56265 lineto
0.6368 0.58716 lineto
0.62746 0.61114 lineto
0.61733 0.63443 lineto
0.60648 0.65689 lineto
0.59498 0.67838 lineto
0.58288 0.69877 lineto
0.57028 0.71794 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.70179 0.29393 Mdot
0.74665 0.39339 Mdot
0.7628 0.50654 Mdot
0.74589 0.62061 Mdot
0.69765 0.72192 Mdot
0.62498 0.79869 Mdot
0.53816 0.84346 Mdot
0.44883 0.85437 Mdot
0.36824 0.83504 Mdot
0.30603 0.79328 Mdot
0.26926 0.73898 Mdot
0.26153 0.68167 Mdot
0.28212 0.62832 Mdot
0.32541 0.58195 Mdot
0.3813 0.5414 Mdot
0.43704 0.50256 Mdot
0.48034 0.46055 Mdot
0.50299 0.41206 Mdot
0.50366 0.35682 Mdot
0.48865 0.29795 Mdot
0.47006 0.24113 Mdot
0.46171 0.19334 Mdot
0.47435 0.16163 Mdot
0.51193 0.15234 Mdot
0.57026 0.17026 Mdot
0.63836 0.2178 Mdot
0.004 setlinewidth
0.70179 0.29393 moveto
0.74665 0.39339 lineto
0.7628 0.50654 lineto
0.74589 0.62061 lineto
0.69765 0.72192 lineto
0.62498 0.79869 lineto
0.53816 0.84346 lineto
0.44883 0.85437 lineto
0.36824 0.83504 lineto
0.30603 0.79328 lineto
0.26926 0.73898 lineto
0.26153 0.68167 lineto
0.28212 0.62832 lineto
0.32541 0.58195 lineto
0.3813 0.5414 lineto
0.43704 0.50256 lineto
0.48034 0.46055 lineto
0.50299 0.41206 lineto
0.50366 0.35682 lineto
0.48865 0.29795 lineto
0.47006 0.24113 lineto
0.46171 0.19334 lineto
0.47435 0.16163 lineto
0.51193 0.15234 lineto
0.57026 0.17026 lineto
0.63836 0.2178 lineto
stroke
0.70179 0.29393 moveto
0.63836 0.2178 lineto
stroke
0.5 0.5 moveto
0.70179 0.29393 lineto
stroke
0.5 0.5 moveto
0.74665 0.39339 lineto
stroke
0.5 0.5 moveto
0.7628 0.50654 lineto
stroke
0.5 0.5 moveto
0.74589 0.62061 lineto
stroke
0.5 0.5 moveto
0.69765 0.72192 lineto
stroke
0.5 0.5 moveto
0.62498 0.79869 lineto
stroke
0.5 0.5 moveto
0.53816 0.84346 lineto
stroke
0.5 0.5 moveto
0.44883 0.85437 lineto
stroke
0.5 0.5 moveto
0.36824 0.83504 lineto
stroke
0.5 0.5 moveto
0.30603 0.79328 lineto
stroke
0.5 0.5 moveto
0.26926 0.73898 lineto
stroke
0.5 0.5 moveto
0.26153 0.68167 lineto
stroke
0.5 0.5 moveto
0.28212 0.62832 lineto
stroke
0.5 0.5 moveto
0.32541 0.58195 lineto
stroke
0.5 0.5 moveto
0.3813 0.5414 lineto
stroke
0.5 0.5 moveto
0.43704 0.50256 lineto
stroke
0.5 0.5 moveto
0.48034 0.46055 lineto
stroke
0.5 0.5 moveto
0.50299 0.41206 lineto
stroke
0.5 0.5 moveto
0.50366 0.35682 lineto
stroke
0.5 0.5 moveto
0.48865 0.29795 lineto
stroke
0.5 0.5 moveto
0.47006 0.24113 lineto
stroke
0.5 0.5 moveto
0.46171 0.19334 lineto
stroke
0.5 0.5 moveto
0.47435 0.16163 lineto
stroke
0.5 0.5 moveto
0.51193 0.15234 lineto
stroke
0.5 0.5 moveto
0.57026 0.17026 lineto
stroke
0.5 0.5 moveto
0.63836 0.2178 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 241; pictureHeight = 241; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(80)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(26)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.79576)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.57028 0.71794 moveto
0.55724 0.73576 lineto
0.54385 0.75213 lineto
0.53019 0.76695 lineto
0.51635 0.78012 lineto
0.5024 0.79156 lineto
0.48844 0.80121 lineto
0.47455 0.80899 lineto
0.46082 0.81488 lineto
0.44732 0.81882 lineto
0.43416 0.8208 lineto
0.4214 0.82079 lineto
0.40912 0.81881 lineto
0.3974 0.81487 lineto
0.38632 0.80898 lineto
0.37594 0.80119 lineto
0.36632 0.79154 lineto
0.35753 0.7801 lineto
0.34961 0.76693 lineto
0.34262 0.75211 lineto
0.3366 0.73574 lineto
0.33159 0.71791 lineto
0.32762 0.69874 lineto
0.32471 0.67835 lineto
0.32288 0.65685 lineto
0.32215 0.63439 lineto
0.32251 0.6111 lineto
0.32396 0.58713 lineto
0.3265 0.56261 lineto
0.33011 0.53772 lineto
0.33477 0.51258 lineto
0.34044 0.48738 lineto
0.3471 0.46225 lineto
0.3547 0.43735 lineto
0.3632 0.41284 lineto
0.37254 0.38886 lineto
0.38267 0.36557 lineto
0.39352 0.34311 lineto
0.40502 0.32162 lineto
0.41712 0.30123 lineto
0.42972 0.28206 lineto
0.44276 0.26424 lineto
0.45615 0.24787 lineto
0.46981 0.23305 lineto
0.48365 0.21988 lineto
0.4976 0.20844 lineto
0.51156 0.19879 lineto
0.52545 0.19101 lineto
0.53918 0.18512 lineto
0.55268 0.18118 lineto
Mistroke
0.56584 0.1792 lineto
0.5786 0.17921 lineto
0.59088 0.18119 lineto
0.6026 0.18513 lineto
0.61368 0.19102 lineto
0.62406 0.19881 lineto
0.63368 0.20846 lineto
0.64247 0.2199 lineto
0.65039 0.23307 lineto
0.65738 0.24789 lineto
0.6634 0.26426 lineto
0.66841 0.28209 lineto
0.67238 0.30126 lineto
0.67529 0.32165 lineto
0.67712 0.34315 lineto
0.67785 0.36561 lineto
0.67749 0.3889 lineto
0.67604 0.41287 lineto
0.6735 0.43739 lineto
0.66989 0.46228 lineto
0.66523 0.48742 lineto
0.65956 0.51262 lineto
0.6529 0.53775 lineto
0.6453 0.56265 lineto
0.6368 0.58716 lineto
0.62746 0.61114 lineto
0.61733 0.63443 lineto
0.60648 0.65689 lineto
0.59498 0.67838 lineto
0.58288 0.69877 lineto
0.57028 0.71794 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.025 setlinewidth
0.49684 0.21698 Mdot
0.52003 0.18632 Mdot
0.54839 0.17294 Mdot
0.58209 0.1801 Mdot
0.619 0.20953 Mdot
0.65492 0.26088 Mdot
0.68434 0.33144 Mdot
0.70165 0.41617 Mdot
0.70238 0.50819 Mdot
0.68422 0.59962 Mdot
0.64761 0.68258 Mdot
0.59579 0.75024 Mdot
0.53428 0.79776 Mdot
0.47 0.82278 Mdot
0.41018 0.82548 Mdot
0.36118 0.80819 Mdot
0.32756 0.77469 Mdot
0.31142 0.72926 Mdot
0.31221 0.67593 Mdot
0.32703 0.61787 Mdot
0.35135 0.55727 Mdot
0.38012 0.49545 Mdot
0.40888 0.4334 Mdot
0.43476 0.37225 Mdot
0.45698 0.31382 Mdot
0.4768 0.26086 Mdot
0.004 setlinewidth
0.49684 0.21698 moveto
0.52003 0.18632 lineto
0.54839 0.17294 lineto
0.58209 0.1801 lineto
0.619 0.20953 lineto
0.65492 0.26088 lineto
0.68434 0.33144 lineto
0.70165 0.41617 lineto
0.70238 0.50819 lineto
0.68422 0.59962 lineto
0.64761 0.68258 lineto
0.59579 0.75024 lineto
0.53428 0.79776 lineto
0.47 0.82278 lineto
0.41018 0.82548 lineto
0.36118 0.80819 lineto
0.32756 0.77469 lineto
0.31142 0.72926 lineto
0.31221 0.67593 lineto
0.32703 0.61787 lineto
0.35135 0.55727 lineto
0.38012 0.49545 lineto
0.40888 0.4334 lineto
0.43476 0.37225 lineto
0.45698 0.31382 lineto
0.4768 0.26086 lineto
stroke
0.49684 0.21698 moveto
0.4768 0.26086 lineto
stroke
0.5 0.5 moveto
0.49684 0.21698 lineto
stroke
0.5 0.5 moveto
0.52003 0.18632 lineto
stroke
0.5 0.5 moveto
0.54839 0.17294 lineto
stroke
0.5 0.5 moveto
0.58209 0.1801 lineto
stroke
0.5 0.5 moveto
0.619 0.20953 lineto
stroke
0.5 0.5 moveto
0.65492 0.26088 lineto
stroke
0.5 0.5 moveto
0.68434 0.33144 lineto
stroke
0.5 0.5 moveto
0.70165 0.41617 lineto
stroke
0.5 0.5 moveto
0.70238 0.50819 lineto
stroke
0.5 0.5 moveto
0.68422 0.59962 lineto
stroke
0.5 0.5 moveto
0.64761 0.68258 lineto
stroke
0.5 0.5 moveto
0.59579 0.75024 lineto
stroke
0.5 0.5 moveto
0.53428 0.79776 lineto
stroke
0.5 0.5 moveto
0.47 0.82278 lineto
stroke
0.5 0.5 moveto
0.41018 0.82548 lineto
stroke
0.5 0.5 moveto
0.36118 0.80819 lineto
stroke
0.5 0.5 moveto
0.32756 0.77469 lineto
stroke
0.5 0.5 moveto
0.31142 0.72926 lineto
stroke
0.5 0.5 moveto
0.31221 0.67593 lineto
stroke
0.5 0.5 moveto
0.32703 0.61787 lineto
stroke
0.5 0.5 moveto
0.35135 0.55727 lineto
stroke
0.5 0.5 moveto
0.38012 0.49545 lineto
stroke
0.5 0.5 moveto
0.40888 0.4334 lineto
stroke
0.5 0.5 moveto
0.43476 0.37225 lineto
stroke
0.5 0.5 moveto
0.45698 0.31382 lineto
stroke
0.5 0.5 moveto
0.4768 0.26086 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
In genreral we can consider the transformation in which we do not take the  midpoints of the sides of a polygon but we can take points which divide each side in different ratio than 1:1. The transformation will be still linear and polygons will converge to a point. If we resize descendants, their vertices  will still lie on the same 'midpoint' ellipse in the limit. However, the scaling factor will be smaller and more complicated.
:[font = input; startGroup; ]
MidPointPolygonMovie[{{................}},
                      IterationStep->10,
                      ShowEllipse ->True,
                      FractionPoint->1/5
                    ]
:[font = print; inactive; ]
Each picture is resized by the the scaling factor:
 
            1
  ----------------------
             (2 I)/5 Pi
      1   4 E
  Abs[- + -------------]
      5         5
:[font = postscript; inactive; PostScript; output; pictureLeft = 112; pictureTop = 2; pictureWidth = 220; pictureHeight = 220; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.22745 0.38469 moveto
0.24423 0.36892 lineto
0.26258 0.35397 lineto
0.28239 0.33992 lineto
0.30354 0.32685 lineto
0.32591 0.31485 lineto
0.34935 0.304 lineto
0.37371 0.29435 lineto
0.39886 0.28597 lineto
0.42463 0.2789 lineto
0.45086 0.27321 lineto
0.4774 0.26891 lineto
0.50408 0.26603 lineto
0.53073 0.2646 lineto
0.55719 0.26462 lineto
0.5833 0.26609 lineto
0.6089 0.269 lineto
0.63382 0.27333 lineto
0.65792 0.27907 lineto
0.68105 0.28616 lineto
0.70306 0.29458 lineto
0.72381 0.30426 lineto
0.74319 0.31515 lineto
0.76107 0.32717 lineto
0.77734 0.34027 lineto
0.7919 0.35434 lineto
0.80466 0.36932 lineto
0.81554 0.3851 lineto
0.82447 0.40159 lineto
0.83141 0.41869 lineto
0.8363 0.43628 lineto
0.83912 0.45427 lineto
0.83985 0.47255 lineto
0.83848 0.49099 lineto
0.83503 0.50949 lineto
0.82951 0.52792 lineto
0.82195 0.54619 lineto
0.81242 0.56417 lineto
0.80095 0.58176 lineto
0.78764 0.59884 lineto
0.77255 0.61531 lineto
0.75577 0.63108 lineto
0.73742 0.64603 lineto
0.71761 0.66008 lineto
0.69646 0.67315 lineto
0.67409 0.68515 lineto
0.65065 0.696 lineto
0.62629 0.70565 lineto
0.60114 0.71403 lineto
0.57537 0.7211 lineto
Mistroke
0.54914 0.72679 lineto
0.5226 0.73109 lineto
0.49592 0.73397 lineto
0.46927 0.7354 lineto
0.44281 0.73538 lineto
0.4167 0.73391 lineto
0.3911 0.731 lineto
0.36618 0.72667 lineto
0.34208 0.72093 lineto
0.31895 0.71384 lineto
0.29694 0.70542 lineto
0.27619 0.69574 lineto
0.25681 0.68485 lineto
0.23893 0.67283 lineto
0.22266 0.65973 lineto
0.2081 0.64566 lineto
0.19534 0.63068 lineto
0.18446 0.6149 lineto
0.17553 0.59841 lineto
0.16859 0.58131 lineto
0.1637 0.56372 lineto
0.16088 0.54573 lineto
0.16015 0.52745 lineto
0.16152 0.50901 lineto
0.16497 0.49051 lineto
0.17049 0.47208 lineto
0.17805 0.45381 lineto
0.18758 0.43583 lineto
0.19905 0.41824 lineto
0.21236 0.40116 lineto
0.22745 0.38469 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.81642 0.2181 moveto
0.5815 0.52014 lineto
0.81163 0.68794 lineto
0.14043 0.65438 lineto
0.15002 0.41946 lineto
stroke
0.81642 0.2181 moveto
0.15002 0.41946 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 112; pictureTop = 2; pictureWidth = 220; pictureHeight = 220; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.48845)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.22745 0.38469 moveto
0.24423 0.36892 lineto
0.26258 0.35397 lineto
0.28239 0.33992 lineto
0.30354 0.32685 lineto
0.32591 0.31485 lineto
0.34935 0.304 lineto
0.37371 0.29435 lineto
0.39886 0.28597 lineto
0.42463 0.2789 lineto
0.45086 0.27321 lineto
0.4774 0.26891 lineto
0.50408 0.26603 lineto
0.53073 0.2646 lineto
0.55719 0.26462 lineto
0.5833 0.26609 lineto
0.6089 0.269 lineto
0.63382 0.27333 lineto
0.65792 0.27907 lineto
0.68105 0.28616 lineto
0.70306 0.29458 lineto
0.72381 0.30426 lineto
0.74319 0.31515 lineto
0.76107 0.32717 lineto
0.77734 0.34027 lineto
0.7919 0.35434 lineto
0.80466 0.36932 lineto
0.81554 0.3851 lineto
0.82447 0.40159 lineto
0.83141 0.41869 lineto
0.8363 0.43628 lineto
0.83912 0.45427 lineto
0.83985 0.47255 lineto
0.83848 0.49099 lineto
0.83503 0.50949 lineto
0.82951 0.52792 lineto
0.82195 0.54619 lineto
0.81242 0.56417 lineto
0.80095 0.58176 lineto
0.78764 0.59884 lineto
0.77255 0.61531 lineto
0.75577 0.63108 lineto
0.73742 0.64603 lineto
0.71761 0.66008 lineto
0.69646 0.67315 lineto
0.67409 0.68515 lineto
0.65065 0.696 lineto
0.62629 0.70565 lineto
0.60114 0.71403 lineto
0.57537 0.7211 lineto
Mistroke
0.54914 0.72679 lineto
0.5226 0.73109 lineto
0.49592 0.73397 lineto
0.46927 0.7354 lineto
0.44281 0.73538 lineto
0.4167 0.73391 lineto
0.3911 0.731 lineto
0.36618 0.72667 lineto
0.34208 0.72093 lineto
0.31895 0.71384 lineto
0.29694 0.70542 lineto
0.27619 0.69574 lineto
0.25681 0.68485 lineto
0.23893 0.67283 lineto
0.22266 0.65973 lineto
0.2081 0.64566 lineto
0.19534 0.63068 lineto
0.18446 0.6149 lineto
0.17553 0.59841 lineto
0.16859 0.58131 lineto
0.1637 0.56372 lineto
0.16088 0.54573 lineto
0.16015 0.52745 lineto
0.16152 0.50901 lineto
0.16497 0.49051 lineto
0.17049 0.47208 lineto
0.17805 0.45381 lineto
0.18758 0.43583 lineto
0.19905 0.41824 lineto
0.21236 0.40116 lineto
0.22745 0.38469 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.17744 0.59273 moveto
0.3139 0.32114 lineto
0.70117 0.30006 lineto
0.83082 0.55011 lineto
0.47667 0.73596 lineto
stroke
0.17744 0.59273 moveto
0.47667 0.73596 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
There are polygons wich are nonselfintersecting but their descendants will never become  convex. However, the 'midpoint' ellipse is degenerate in these cases (but I don't know if it has to be degenerate).
:[font = input; startGroup; ]
MidPointPolygonMovie[1/3{{0,-1},{3+Sqrt[5],0},{0,1},
                     {1+Sqrt[5],.2},{1+Sqrt[5],-.2}}//N,
                    
                      ShowEllipse ->True,
                      TotalFrameNumber->3
                      
                    ]
:[font = print; inactive; ]
                                                     1
Each picture is resized by the the scaling factor:-------
                                                      Pi
                                                  Cos[--]
                                                      5
:[font = postscript; inactive; PostScript; output; pictureLeft = 120; pictureTop = 2; pictureWidth = 211; pictureHeight = 211; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.5 0.41625 moveto
0.5 0.40747 lineto
0.5 0.39925 lineto
0.5 0.39166 lineto
0.5 0.38473 lineto
0.5 0.37851 lineto
0.5 0.37305 lineto
0.5 0.36836 lineto
0.5 0.36449 lineto
0.5 0.36145 lineto
0.5 0.35927 lineto
0.5 0.35796 lineto
0.5 0.35752 lineto
0.5 0.35796 lineto
0.5 0.35927 lineto
0.5 0.36145 lineto
0.5 0.36449 lineto
0.5 0.36836 lineto
0.5 0.37305 lineto
0.5 0.37851 lineto
0.5 0.38473 lineto
0.5 0.39166 lineto
0.5 0.39925 lineto
0.5 0.40747 lineto
0.5 0.41625 lineto
0.5 0.42555 lineto
0.5 0.43531 lineto
0.5 0.44547 lineto
0.5 0.45597 lineto
0.5 0.46674 lineto
0.5 0.47771 lineto
0.5 0.48882 lineto
0.5 0.5 lineto
0.5 0.51118 lineto
0.5 0.52229 lineto
0.5 0.53326 lineto
0.5 0.54403 lineto
0.5 0.55453 lineto
0.5 0.56469 lineto
0.5 0.57445 lineto
0.5 0.58375 lineto
0.5 0.59253 lineto
0.5 0.60075 lineto
0.5 0.60834 lineto
0.5 0.61527 lineto
0.5 0.62149 lineto
0.5 0.62695 lineto
0.5 0.63164 lineto
0.5 0.63551 lineto
0.5 0.63855 lineto
Mistroke
0.5 0.64073 lineto
0.5 0.64204 lineto
0.5 0.64248 lineto
0.5 0.64204 lineto
0.5 0.64073 lineto
0.5 0.63855 lineto
0.5 0.63551 lineto
0.5 0.63164 lineto
0.5 0.62695 lineto
0.5 0.62149 lineto
0.5 0.61527 lineto
0.5 0.60834 lineto
0.5 0.60075 lineto
0.5 0.59253 lineto
0.5 0.58375 lineto
0.5 0.57445 lineto
0.5 0.56469 lineto
0.5 0.55453 lineto
0.5 0.54403 lineto
0.5 0.53326 lineto
0.5 0.52229 lineto
0.5 0.51118 lineto
0.5 0.5 lineto
0.5 0.48882 lineto
0.5 0.47771 lineto
0.5 0.46674 lineto
0.5 0.45597 lineto
0.5 0.44547 lineto
0.5 0.43531 lineto
0.5 0.42555 lineto
0.5 0.41625 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.10973 0.33333 moveto
0.9824 0.5 lineto
0.10973 0.66667 lineto
0.64907 0.53333 lineto
0.64907 0.46667 lineto
stroke
0.10973 0.33333 moveto
0.64907 0.46667 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 120; pictureTop = 2; pictureWidth = 211; pictureHeight = 211; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.23607)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.5 0.41625 moveto
0.5 0.40747 lineto
0.5 0.39925 lineto
0.5 0.39166 lineto
0.5 0.38473 lineto
0.5 0.37851 lineto
0.5 0.37305 lineto
0.5 0.36836 lineto
0.5 0.36449 lineto
0.5 0.36145 lineto
0.5 0.35927 lineto
0.5 0.35796 lineto
0.5 0.35752 lineto
0.5 0.35796 lineto
0.5 0.35927 lineto
0.5 0.36145 lineto
0.5 0.36449 lineto
0.5 0.36836 lineto
0.5 0.37305 lineto
0.5 0.37851 lineto
0.5 0.38473 lineto
0.5 0.39166 lineto
0.5 0.39925 lineto
0.5 0.40747 lineto
0.5 0.41625 lineto
0.5 0.42555 lineto
0.5 0.43531 lineto
0.5 0.44547 lineto
0.5 0.45597 lineto
0.5 0.46674 lineto
0.5 0.47771 lineto
0.5 0.48882 lineto
0.5 0.5 lineto
0.5 0.51118 lineto
0.5 0.52229 lineto
0.5 0.53326 lineto
0.5 0.54403 lineto
0.5 0.55453 lineto
0.5 0.56469 lineto
0.5 0.57445 lineto
0.5 0.58375 lineto
0.5 0.59253 lineto
0.5 0.60075 lineto
0.5 0.60834 lineto
0.5 0.61527 lineto
0.5 0.62149 lineto
0.5 0.62695 lineto
0.5 0.63164 lineto
0.5 0.63551 lineto
0.5 0.63855 lineto
Mistroke
0.5 0.64073 lineto
0.5 0.64204 lineto
0.5 0.64248 lineto
0.5 0.64204 lineto
0.5 0.64073 lineto
0.5 0.63855 lineto
0.5 0.63551 lineto
0.5 0.63164 lineto
0.5 0.62695 lineto
0.5 0.62149 lineto
0.5 0.61527 lineto
0.5 0.60834 lineto
0.5 0.60075 lineto
0.5 0.59253 lineto
0.5 0.58375 lineto
0.5 0.57445 lineto
0.5 0.56469 lineto
0.5 0.55453 lineto
0.5 0.54403 lineto
0.5 0.53326 lineto
0.5 0.52229 lineto
0.5 0.51118 lineto
0.5 0.5 lineto
0.5 0.48882 lineto
0.5 0.47771 lineto
0.5 0.46674 lineto
0.5 0.45597 lineto
0.5 0.44547 lineto
0.5 0.43531 lineto
0.5 0.42555 lineto
0.5 0.41625 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.55694 0.39699 moveto
0.55694 0.60301 lineto
0.35093 0.62361 lineto
0.68426 0.5 lineto
0.35093 0.37639 lineto
stroke
0.55694 0.39699 moveto
0.35093 0.37639 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 120; pictureTop = 2; pictureWidth = 211; pictureHeight = 211; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.52786)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.5 0.41625 moveto
0.5 0.40747 lineto
0.5 0.39925 lineto
0.5 0.39166 lineto
0.5 0.38473 lineto
0.5 0.37851 lineto
0.5 0.37305 lineto
0.5 0.36836 lineto
0.5 0.36449 lineto
0.5 0.36145 lineto
0.5 0.35927 lineto
0.5 0.35796 lineto
0.5 0.35752 lineto
0.5 0.35796 lineto
0.5 0.35927 lineto
0.5 0.36145 lineto
0.5 0.36449 lineto
0.5 0.36836 lineto
0.5 0.37305 lineto
0.5 0.37851 lineto
0.5 0.38473 lineto
0.5 0.39166 lineto
0.5 0.39925 lineto
0.5 0.40747 lineto
0.5 0.41625 lineto
0.5 0.42555 lineto
0.5 0.43531 lineto
0.5 0.44547 lineto
0.5 0.45597 lineto
0.5 0.46674 lineto
0.5 0.47771 lineto
0.5 0.48882 lineto
0.5 0.5 lineto
0.5 0.51118 lineto
0.5 0.52229 lineto
0.5 0.53326 lineto
0.5 0.54403 lineto
0.5 0.55453 lineto
0.5 0.56469 lineto
0.5 0.57445 lineto
0.5 0.58375 lineto
0.5 0.59253 lineto
0.5 0.60075 lineto
0.5 0.60834 lineto
0.5 0.61527 lineto
0.5 0.62149 lineto
0.5 0.62695 lineto
0.5 0.63164 lineto
0.5 0.63551 lineto
0.5 0.63855 lineto
Mistroke
0.5 0.64073 lineto
0.5 0.64204 lineto
0.5 0.64248 lineto
0.5 0.64204 lineto
0.5 0.64073 lineto
0.5 0.63855 lineto
0.5 0.63551 lineto
0.5 0.63164 lineto
0.5 0.62695 lineto
0.5 0.62149 lineto
0.5 0.61527 lineto
0.5 0.60834 lineto
0.5 0.60075 lineto
0.5 0.59253 lineto
0.5 0.58375 lineto
0.5 0.57445 lineto
0.5 0.56469 lineto
0.5 0.55453 lineto
0.5 0.54403 lineto
0.5 0.53326 lineto
0.5 0.52229 lineto
0.5 0.51118 lineto
0.5 0.5 lineto
0.5 0.48882 lineto
0.5 0.47771 lineto
0.5 0.46674 lineto
0.5 0.45597 lineto
0.5 0.44547 lineto
0.5 0.43531 lineto
0.5 0.42555 lineto
0.5 0.41625 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.57038 0.5 moveto
0.44306 0.64005 lineto
0.52175 0.57639 lineto
0.52175 0.42361 lineto
0.44306 0.35995 lineto
stroke
0.57038 0.5 moveto
0.44306 0.35995 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
Now, let us look at other functions defined in the package. The function Basis[pol] returns  all complex coefficients in the form of a list of the polygon pol written in the
following eigenvector basis described in the mathematical introduction.

Example:
:[font = input; startGroup; ]
Basis[{{0,1},{-1,0},{0,-1},{1,0}}]
:[font = output; inactive; output; endGroup; ]
{1, 0, 0, 0}
;[o]
{1, 0, 0, 0}
:[font = text; inactive; ]
The first and peniultimate coefficient of the above polygon have the same absolute value different from 0. This is why the 'midpoint' ellipse is degenerate.
:[font = input; startGroup; ]
Basis[1/3{{0,-1},{3+Sqrt[5],0},{0,1},
      {1+Sqrt[5],.2},{1+Sqrt[5],-.2}}//N]
:[font = output; inactive; output; endGroup; ]
{-0.1152702047897772 - 0.0837487059916604*I, 
  0.1654521460695983 + 0.5092093461487182*I, 
  0.1326902509303737 - 0.4083786008320643*I, 
  0.1152702047897773 - 0.0837487059916604*I, 
  0.7805469288332912}
;[o]
{-0.11527 - 0.0837487 I, 0.165452 + 0.509209 I, 
 
  0.13269 - 0.408379 I, 0.11527 - 0.0837487 I, 0.780547}
:[font = text; inactive; ]
RandomStellarPolygons are chosen randomly in such a way that  at least first and the penultimate coefficient in the eigenvector basis is set to 0. 
:[font = input; startGroup; ]
w=RandomStellarPolygon[7];
Chop[Basis[w]]
:[font = output; inactive; output; endGroup; ]
{0, 0, 0.6606730798846209 - 0.3079216521338828*I, 
  -0.2208345775047994 - 0.1905781797634972*I, 0, 0, 0}
;[o]
{0, 0, 0.6606730798846209 - 0.3079216521338828 I, 
 
  -0.2208345775047994 - 0.1905781797634972 I, 0, 0, 0}
:[font = text; inactive; ]
The above RandomStellarPolygon has the first two and the last three coefficients set to 0. Hence, in the limit  we obtain the (7,3) stellargon. The constant scaling factor depends only on the number of 0 coefficients in the beginning and in the end.  (Setting the last coefficient to 0 is the representation in the eigenvector basis means exactly that the center of mass of the polygon is at the origin.) The RandomStellarPolygons converge to its centroids faster then other polygons.
:[font = input; startGroup; ]
MidPointPolygonMovie[w,ShowEllipse->True]
:[font = print; inactive; ]
                                                      1
Each picture is resized by the the scaling factor:---------
                                                      3 Pi
                                                  Cos[----]
                                                       7
:[font = postscript; inactive; PostScript; output; pictureLeft = 140; pictureWidth = 178; pictureHeight = 178; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.71992 0.25075 moveto
0.72384 0.2861 lineto
0.72639 0.32277 lineto
0.72754 0.36053 lineto
0.72729 0.39915 lineto
0.72563 0.43839 lineto
0.72259 0.47801 lineto
0.71817 0.51777 lineto
0.7124 0.55742 lineto
0.70533 0.59672 lineto
0.69699 0.63541 lineto
0.68744 0.67328 lineto
0.67673 0.71007 lineto
0.66493 0.74557 lineto
0.65212 0.77956 lineto
0.63837 0.81182 lineto
0.62376 0.84216 lineto
0.60839 0.87039 lineto
0.59235 0.89634 lineto
0.57575 0.91984 lineto
0.55867 0.94075 lineto
0.54124 0.95895 lineto
0.52355 0.97432 lineto
0.50571 0.98676 lineto
0.48784 0.9962 lineto
0.47005 1.00259 lineto
0.45244 1.00587 lineto
0.43512 1.00604 lineto
0.4182 1.00308 lineto
0.40179 0.99703 lineto
0.38598 0.98791 lineto
0.37088 0.97578 lineto
0.35657 0.96072 lineto
0.34314 0.94281 lineto
0.33069 0.92218 lineto
0.31927 0.89895 lineto
0.30897 0.87325 lineto
0.29985 0.84526 lineto
0.29197 0.81513 lineto
0.28536 0.78306 lineto
0.28008 0.74925 lineto
0.27616 0.7139 lineto
0.27361 0.67723 lineto
0.27246 0.63947 lineto
0.27271 0.60085 lineto
0.27437 0.56161 lineto
0.27741 0.52199 lineto
0.28183 0.48223 lineto
0.2876 0.44258 lineto
0.29467 0.40328 lineto
Mistroke
0.30301 0.36459 lineto
0.31256 0.32672 lineto
0.32327 0.28993 lineto
0.33507 0.25443 lineto
0.34788 0.22044 lineto
0.36163 0.18818 lineto
0.37624 0.15784 lineto
0.39161 0.12961 lineto
0.40765 0.10366 lineto
0.42425 0.08016 lineto
0.44133 0.05925 lineto
0.45876 0.04105 lineto
0.47645 0.02568 lineto
0.49429 0.01324 lineto
0.51216 0.0038 lineto
0.52995 -0.00259 lineto
0.54756 -0.00587 lineto
0.56488 -0.00604 lineto
0.5818 -0.00308 lineto
0.59821 0.00297 lineto
0.61402 0.01209 lineto
0.62912 0.02422 lineto
0.64343 0.03928 lineto
0.65686 0.05719 lineto
0.66931 0.07782 lineto
0.68073 0.10105 lineto
0.69103 0.12675 lineto
0.70015 0.15474 lineto
0.70803 0.18487 lineto
0.71464 0.21694 lineto
0.71992 0.25075 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.32732 0.9158 moveto
0.59125 0 lineto
0.50826 0.98517 lineto
0.39386 0.12576 lineto
0.68299 0.68919 lineto
0.2764 0.53333 lineto
0.71992 0.25075 lineto
stroke
0.32732 0.9158 moveto
0.71992 0.25075 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; pictureLeft = 140; pictureWidth = 178; pictureHeight = 178; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(7)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.49396)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.71992 0.25075 moveto
0.72384 0.2861 lineto
0.72639 0.32277 lineto
0.72754 0.36053 lineto
0.72729 0.39915 lineto
0.72563 0.43839 lineto
0.72259 0.47801 lineto
0.71817 0.51777 lineto
0.7124 0.55742 lineto
0.70533 0.59672 lineto
0.69699 0.63541 lineto
0.68744 0.67328 lineto
0.67673 0.71007 lineto
0.66493 0.74557 lineto
0.65212 0.77956 lineto
0.63837 0.81182 lineto
0.62376 0.84216 lineto
0.60839 0.87039 lineto
0.59235 0.89634 lineto
0.57575 0.91984 lineto
0.55867 0.94075 lineto
0.54124 0.95895 lineto
0.52355 0.97432 lineto
0.50571 0.98676 lineto
0.48784 0.9962 lineto
0.47005 1.00259 lineto
0.45244 1.00587 lineto
0.43512 1.00604 lineto
0.4182 1.00308 lineto
0.40179 0.99703 lineto
0.38598 0.98791 lineto
0.37088 0.97578 lineto
0.35657 0.96072 lineto
0.34314 0.94281 lineto
0.33069 0.92218 lineto
0.31927 0.89895 lineto
0.30897 0.87325 lineto
0.29985 0.84526 lineto
0.29197 0.81513 lineto
0.28536 0.78306 lineto
0.28008 0.74925 lineto
0.27616 0.7139 lineto
0.27361 0.67723 lineto
0.27246 0.63947 lineto
0.27271 0.60085 lineto
0.27437 0.56161 lineto
0.27741 0.52199 lineto
0.28183 0.48223 lineto
0.2876 0.44258 lineto
0.29467 0.40328 lineto
Mistroke
0.30301 0.36459 lineto
0.31256 0.32672 lineto
0.32327 0.28993 lineto
0.33507 0.25443 lineto
0.34788 0.22044 lineto
0.36163 0.18818 lineto
0.37624 0.15784 lineto
0.39161 0.12961 lineto
0.40765 0.10366 lineto
0.42425 0.08016 lineto
0.44133 0.05925 lineto
0.45876 0.04105 lineto
0.47645 0.02568 lineto
0.49429 0.01324 lineto
0.51216 0.0038 lineto
0.52995 -0.00259 lineto
0.54756 -0.00587 lineto
0.56488 -0.00604 lineto
0.5818 -0.00308 lineto
0.59821 0.00297 lineto
0.61402 0.01209 lineto
0.62912 0.02422 lineto
0.64343 0.03928 lineto
0.65686 0.05719 lineto
0.66931 0.07782 lineto
0.68073 0.10105 lineto
0.69103 0.12675 lineto
0.70015 0.15474 lineto
0.70803 0.18487 lineto
0.71464 0.21694 lineto
0.71992 0.25075 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.31701 0.31081 moveto
0.7236 0.46667 lineto
0.28008 0.74925 lineto
0.67268 0.0842 lineto
0.40875 1 lineto
0.49174 0.01483 lineto
0.60614 0.87424 lineto
stroke
0.31701 0.31081 moveto
0.60614 0.87424 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = text; inactive; ]
Finally we can write a simple code using the MidPointPolygon function which will show a polygon and its  descandants  in one frame:
:[font = input; ]
Picture[pol_,n_,fr_]:=
Block[{i,line},

       f[t_]:=MidPointPolygon[t,fr];
       g[x_]:=Append[x,First[x]];
       line=Flatten[Table[g[Nest[f,pol,i]],{i,0,n}],1];
       Show[Graphics[Line[line],AspectRatio->Automatic,
                       PlotRange->{{-1,1},{-1,1}}
                    ]
           ]
      ]          
:[font = input; startGroup; ]
Picture[{{0.902, 0.689}, {0.616, 0.241},
         {0.873, -0.333},{-0.127, -0.252},{-0.603, -0.839},
         {-0.852, 0.735}},40,1/10]
:[font = postscript; inactive; PostScript; output; pictureLeft = 70; pictureTop = 2; pictureWidth = 282; pictureHeight = 282; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
0.95109 0.84482 moveto
0.80902 0.62068 lineto
0.93689 0.33333 lineto
0.43607 0.37356 lineto
0.19809 0.08046 lineto
0.07377 0.86781 lineto
0.95109 0.84482 lineto
0.82322 0.6431 lineto
0.9241 0.36207 lineto
0.48615 0.36954 lineto
0.22188 0.10977 lineto
0.0862 0.78907 lineto
0.86336 0.84712 lineto
0.82322 0.6431 lineto
0.91401 0.39017 lineto
0.52994 0.36879 lineto
0.24831 0.13575 lineto
0.09977 0.72114 lineto
0.78565 0.84131 lineto
0.82724 0.6635 lineto
0.91401 0.39017 lineto
0.56835 0.37093 lineto
0.27647 0.15905 lineto
0.11462 0.6626 lineto
0.71706 0.8293 lineto
0.82308 0.68128 lineto
0.90533 0.4175 lineto
0.56835 0.37093 lineto
0.30566 0.18024 lineto
0.13081 0.61225 lineto
0.65681 0.81263 lineto
0.81248 0.69608 lineto
0.89711 0.44388 lineto
0.60205 0.37558 lineto
0.30566 0.18024 lineto
0.14829 0.56905 lineto
0.60421 0.79259 lineto
0.79691 0.70774 lineto
0.88865 0.4691 lineto
0.63155 0.38241 lineto
0.3353 0.19977 lineto
0.14829 0.56905 lineto
0.55862 0.77023 lineto
0.77764 0.71622 lineto
0.87947 0.49296 lineto
0.65726 0.39108 lineto
0.36493 0.21804 lineto
0.16699 0.53212 lineto
0.55862 0.77023 lineto
0.75574 0.72162 lineto
Mistroke
0.86929 0.51529 lineto
0.67948 0.40127 lineto
0.39416 0.23534 lineto
0.18679 0.50071 lineto
0.51946 0.74642 lineto
0.75574 0.72162 lineto
0.85793 0.53592 lineto
0.69846 0.41267 lineto
0.42269 0.25193 lineto
0.20753 0.47417 lineto
0.48619 0.72185 lineto
0.73211 0.7241 lineto
0.85793 0.53592 lineto
0.71441 0.425 lineto
0.45027 0.26801 lineto
0.22904 0.45195 lineto
0.45833 0.69708 lineto
0.70752 0.72388 lineto
0.84535 0.55474 lineto
0.71441 0.425 lineto
0.47668 0.28371 lineto
0.25116 0.43356 lineto
0.4354 0.67257 lineto
0.6826 0.7212 lineto
0.83157 0.57165 lineto
0.72751 0.43797 lineto
0.47668 0.28371 lineto
0.27372 0.41857 lineto
0.41697 0.64867 lineto
0.65788 0.71634 lineto
0.81667 0.58661 lineto
0.73791 0.45134 lineto
0.50177 0.29913 lineto
0.27372 0.41857 lineto
0.40265 0.62566 lineto
0.63379 0.70957 lineto
0.80079 0.59958 lineto
0.74579 0.46487 lineto
0.52538 0.31435 lineto
0.29652 0.40663 lineto
0.40265 0.62566 lineto
0.61067 0.70118 lineto
0.78409 0.61058 lineto
0.75129 0.47834 lineto
0.54742 0.32941 lineto
0.31941 0.3974 lineto
0.39204 0.60376 lineto
0.61067 0.70118 lineto
0.76675 0.61964 lineto
0.75457 0.49156 lineto
Mistroke
0.56781 0.3443 lineto
0.34221 0.3906 lineto
0.38477 0.58312 lineto
0.58881 0.69144 lineto
0.76675 0.61964 lineto
0.75579 0.50437 lineto
0.58648 0.35903 lineto
0.36477 0.38597 lineto
0.38052 0.56387 lineto
0.56841 0.6806 lineto
0.74896 0.62682 lineto
0.75579 0.50437 lineto
0.60341 0.37356 lineto
0.38694 0.38328 lineto
0.37894 0.54608 lineto
0.54962 0.66893 lineto
0.7309 0.6322 lineto
0.7551 0.51662 lineto
0.60341 0.37356 lineto
0.40859 0.3823 lineto
0.37974 0.5298 lineto
0.53255 0.65665 lineto
0.71277 0.63587 lineto
0.75268 0.52817 lineto
0.61858 0.38787 lineto
0.40859 0.3823 lineto
0.38263 0.51505 lineto
0.51727 0.64396 lineto
0.69475 0.63795 lineto
0.74869 0.53894 lineto
0.63199 0.4019 lineto
0.42959 0.38286 lineto
0.38263 0.51505 lineto
0.50381 0.63107 lineto
0.677 0.63855 lineto
0.7433 0.54884 lineto
0.64366 0.4156 lineto
0.44983 0.38476 lineto
0.38732 0.50183 lineto
0.50381 0.63107 lineto
0.65968 0.6378 lineto
0.73667 0.55781 lineto
0.65363 0.42893 lineto
0.46921 0.38785 lineto
0.39357 0.49012 lineto
0.49216 0.61815 lineto
0.65968 0.6378 lineto
0.72897 0.56581 lineto
0.66193 0.44181 lineto
0.48765 0.39196 lineto
Mistroke
0.40114 0.4799 lineto
0.4823 0.60534 lineto
0.64293 0.63584 lineto
0.72897 0.56581 lineto
0.66863 0.45421 lineto
0.50508 0.39694 lineto
0.40979 0.4711 lineto
0.47418 0.5928 lineto
0.62687 0.63279 lineto
0.72037 0.57282 lineto
0.66863 0.45421 lineto
0.52144 0.40267 lineto
0.41932 0.46369 lineto
0.46774 0.58063 lineto
0.6116 0.62879 lineto
0.71102 0.57881 lineto
0.67381 0.46607 lineto
0.52144 0.40267 lineto
0.42953 0.45758 lineto
0.4629 0.56893 lineto
0.59721 0.62397 lineto
0.70107 0.58381 lineto
0.67753 0.47735 lineto
0.53667 0.40901 lineto
0.42953 0.45758 lineto
0.45956 0.5578 lineto
0.58378 0.61847 lineto
0.69069 0.58783 lineto
0.67988 0.48799 lineto
0.55076 0.41584 lineto
0.44024 0.45273 lineto
0.45956 0.5578 lineto
0.57136 0.6124 lineto
0.68 0.59089 lineto
0.68096 0.49798 lineto
0.56367 0.42306 lineto
0.4513 0.44904 lineto
0.45763 0.54729 lineto
0.57136 0.6124 lineto
0.66913 0.59304 lineto
0.68087 0.50727 lineto
0.5754 0.43055 lineto
0.46253 0.44644 lineto
0.457 0.53747 lineto
0.55999 0.60589 lineto
0.66913 0.59304 lineto
0.67969 0.51585 lineto
0.58595 0.43822 lineto
0.47382 0.44485 lineto
0.45755 0.52836 lineto
Mistroke
0.54969 0.59905 lineto
0.65822 0.59433 lineto
0.67969 0.51585 lineto
0.59532 0.44598 lineto
0.48503 0.44419 lineto
0.45918 0.52001 lineto
0.54047 0.59198 lineto
0.64737 0.5948 lineto
0.67755 0.52369 lineto
0.59532 0.44598 lineto
0.49606 0.44437 lineto
0.46176 0.51243 lineto
0.53234 0.58478 lineto
0.63668 0.59452 lineto
0.67453 0.5308 lineto
0.60354 0.45376 lineto
0.49606 0.44437 lineto
0.46519 0.50562 lineto
0.52529 0.57755 lineto
0.62624 0.59354 lineto
0.67074 0.53718 lineto
0.61064 0.46146 lineto
0.50681 0.44531 lineto
0.46519 0.50562 lineto
0.51928 0.57036 lineto
0.61615 0.59194 lineto
0.66629 0.54281 lineto
0.61665 0.46903 lineto
0.51719 0.44692 lineto
0.46935 0.49959 lineto
0.51928 0.57036 lineto
0.60646 0.58979 lineto
0.66128 0.54773 lineto
0.62162 0.47641 lineto
0.52714 0.44913 lineto
0.47414 0.49433 lineto
0.51428 0.56328 lineto
0.60646 0.58979 lineto
0.6558 0.55193 lineto
0.62558 0.48354 lineto
0.53659 0.45186 lineto
0.47944 0.48981 lineto
0.51027 0.55638 lineto
0.59724 0.58713 lineto
0.6558 0.55193 lineto
0.6286 0.49038 lineto
0.54549 0.45503 lineto
0.48515 0.48601 lineto
0.50719 0.54973 lineto
0.58855 0.58406 lineto
Mistroke
0.64994 0.55545 lineto
0.6286 0.49038 lineto
0.5538 0.45856 lineto
0.49119 0.48291 lineto
0.50498 0.54335 lineto
0.58041 0.58063 lineto
0.6438 0.55831 lineto
0.63074 0.49689 lineto
0.5538 0.45856 lineto
0.49745 0.48048 lineto
0.5036 0.53731 lineto
0.57287 0.5769 lineto
0.63746 0.56054 lineto
0.63204 0.50303 lineto
0.56149 0.4624 lineto
0.49745 0.48048 lineto
0.50299 0.53163 lineto
0.56594 0.57294 lineto
0.631 0.56218 lineto
0.63259 0.50878 lineto
0.56855 0.46646 lineto
0.50385 0.47867 lineto
0.50299 0.53163 lineto
0.55965 0.56881 lineto
0.6245 0.56326 lineto
0.63243 0.51412 lineto
0.57495 0.47069 lineto
0.51032 0.47745 lineto
0.50307 0.52633 lineto
0.55965 0.56881 lineto
0.61801 0.56381 lineto
0.63163 0.51903 lineto
0.5807 0.47503 lineto
0.51678 0.47677 lineto
0.5038 0.52144 lineto
0.55399 0.56456 lineto
0.61801 0.56381 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = output; inactive; output; endGroup; ]
The Unformatted text for this cell was not generated.
Use options in the Actions Settings dialog box to control
when Unformatted text is generated.
;[o]
-Graphics-
:[font = text; inactive; ]
   The  curve C(t) , 0<=t<2 Pi  can be parametrized by a polygon  Q=( C(t1), C(t2), . . . , C(tN) ) where 0<=t1 < . . . < tN < 2 Pi. 
   The Fourier coefficients of the curve C(t) are defined as:  
   
                                                                     2 Pi                        - I t n
                                  (n) =  1 / (2 Pi)     Integral  ( C(t)      E              ).
                                                                       0
                                                
 Let us check that  the coefficients  (b1, b2, . . . , bN) of the polygon Q in the eigenvector basis really approximate the  Fourier coefficients . As an example, let us take the function:
  
        C(t)= Sin[3 t]  + I t Sin[t]  ,  0<=t<2 Pi
:[font = postscript; inactive; PostScript; output; pictureLeft = 89; pictureTop = 2; pictureWidth = 241; pictureHeight = 241; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(100)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.262381)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.53644 0.63244 moveto
0.55929 0.6345 lineto
0.58005 0.63756 lineto
0.59797 0.64162 lineto
0.61242 0.64662 lineto
0.62289 0.65253 lineto
0.629 0.65932 lineto
0.63054 0.66691 lineto
0.62746 0.67525 lineto
0.61987 0.68427 lineto
0.60802 0.6939 lineto
0.59235 0.70406 lineto
0.57341 0.71466 lineto
0.55187 0.72562 lineto
0.52849 0.73684 lineto
0.5041 0.74822 lineto
0.47957 0.75967 lineto
0.45576 0.77108 lineto
0.43352 0.78235 lineto
0.41363 0.79337 lineto
0.3968 0.80405 lineto
0.38363 0.81426 lineto
0.37458 0.82391 lineto
0.36997 0.8329 lineto
0.36997 0.84113 lineto
0.37458 0.8485 lineto
0.38363 0.85491 lineto
0.3968 0.86027 lineto
0.41363 0.86451 lineto
0.43352 0.86753 lineto
0.45576 0.86928 lineto
0.47957 0.86967 lineto
0.5041 0.86865 lineto
0.52849 0.86616 lineto
0.55187 0.86217 lineto
0.57341 0.85663 lineto
0.59235 0.84952 lineto
0.60802 0.84082 lineto
0.61987 0.83051 lineto
0.62746 0.81859 lineto
0.63054 0.80508 lineto
0.629 0.79 lineto
0.62289 0.77336 lineto
0.61242 0.75522 lineto
0.59797 0.73561 lineto
0.58005 0.71459 lineto
0.55929 0.69224 lineto
0.53644 0.66862 lineto
0.51229 0.64383 lineto
0.48771 0.61795 lineto
Mistroke
0.46356 0.59109 lineto
0.44071 0.56336 lineto
0.41995 0.53487 lineto
0.40203 0.50575 lineto
0.38758 0.47614 lineto
0.37711 0.44616 lineto
0.371 0.41596 lineto
0.36946 0.38569 lineto
0.37254 0.3555 lineto
0.38013 0.32554 lineto
0.39198 0.29597 lineto
0.40765 0.26695 lineto
0.42659 0.23863 lineto
0.44813 0.21117 lineto
0.47151 0.18474 lineto
0.4959 0.15949 lineto
0.52043 0.13558 lineto
0.54424 0.11315 lineto
0.56648 0.09235 lineto
0.58637 0.07333 lineto
0.6032 0.05623 lineto
0.61637 0.04116 lineto
0.62542 0.02827 lineto
0.63003 0.01765 lineto
0.63003 0.00942 lineto
0.62542 0.00368 lineto
0.61637 0.00052 lineto
0.6032 0 lineto
0.58637 0.0022 lineto
0.56648 0.00717 lineto
0.54424 0.01496 lineto
0.52043 0.02558 lineto
0.4959 0.03907 lineto
0.47151 0.05542 lineto
0.44813 0.07462 lineto
0.42659 0.09666 lineto
0.40765 0.12148 lineto
0.39198 0.14906 lineto
0.38013 0.1793 lineto
0.37254 0.21215 lineto
0.36946 0.24751 lineto
0.371 0.28528 lineto
0.37711 0.32533 lineto
0.38758 0.36754 lineto
0.40203 0.41176 lineto
0.41995 0.45784 lineto
0.44071 0.50561 lineto
0.46356 0.5549 lineto
0.48771 0.60553 lineto
0.51229 0.63141 lineto
Mistroke
Mfstroke
0.53644 0.63244 moveto
0.51229 0.63141 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; ]


     (*b[n] is a list of the coeffincients of the  *)
     (*        approximating polygon.            *)
c[t_]:=Sin[3t]  + I t Sin[t];
b[n_]:=Basis[Table[{Re[c[t]],Im[c[t]]}//N,{t,2Pi/n,2Pi,2Pi/n}
                  ]
            ]
:[font = text; inactive; ]
Let us look at the first coefficient  of the approximating pentagon, 50-gon and 100-gon:
:[font = input; startGroup; ]
b[10][[1]]
:[font = output; inactive; output; endGroup; ]
1.570796326794897 - 0.2162015664943025*I
;[o]
1.570796326794897 - 0.2162015664943025 I
:[font = input; startGroup; ]
b[50][[1]]
:[font = output; inactive; output; endGroup; ]
1.570796326794897 - 0.2486826652859682*I
;[o]
1.570796326794897 - 0.2486826652859682 I
:[font = input; startGroup; ]
b[100][[1]]
:[font = output; inactive; output; endGroup; ]
1.570796326794897 - 0.2496709265682039*I
;[o]
1.570796326794897 - 0.2496709265682039 I
:[font = text; inactive; ]
Finally let compute the first Fourier coefficient of the curve C(t).
:[font = input; startGroup; ]
1/(2 Pi) NIntegrate[c[t] E^(-I t), {t,0, 2Pi}]//N
:[font = output; inactive; output; endGroup; ]
1.570796326794896 - 0.2499999999999999*I
;[o]
1.5708 - 0.25 I
:[font = text; inactive; endGroup; ]
Indeed, the last complex number corresponds  well to the numbers  b[5][[1]], b[50][[1]], and b[100][[1]]. You may try to check other coefficients as well.
:[font = subsection; inactive; startGroup; Cclosed; ]
Animations.
:[font = subsubsection; inactive; startGroup; Cclosed; ]
Introduction.
:[font = text; inactive; endGroup; ]
   In order to attain smooth animations we need a lot of pictures, at least 50-100. Therefore it is impossible to show nice and valuable animations in this notebook since it would require too much memory.  However, some examples can be proposed and the user may execute the code himself.  Below, there are some very simple examples of different type of animation. The user might make figures more complicated (e.g. increase the number of vertices and frames). 
   
   
   
:[font = subsubsection; inactive; startGroup; Cclosed; ]
 Rotating affine image of a regular stellar pentagon.
:[font = input; startGroup; ]
MidPointPolygonMovie[RandomStellarPolygon[5],
                     FractionPoint->.1,
                     ShowEllipse->True,
                     TotalFrameNumber->18]
:[font = postscript; inactive; PostScript; output; startGroup; Cclosed; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.65848 0.95808 moveto
0.48519 0 lineto
0.36547 0.85094 lineto
0.73247 0.43217 lineto
0.25838 0.25882 lineto
stroke
0.65848 0.95808 moveto
0.25838 0.25882 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.21772)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.50307 0.00781 moveto
0.35076 0.82373 lineto
0.7384 0.46839 lineto
0.2635 0.22742 lineto
0.64427 0.97266 lineto
stroke
0.50307 0.00781 moveto
0.64427 0.97266 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.48285)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.33682 0.79485 moveto
0.7431 0.50478 lineto
0.26984 0.19741 lineto
0.62931 0.98482 lineto
0.52094 0.01814 lineto
stroke
0.33682 0.79485 moveto
0.52094 0.01814 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.8057)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.74655 0.54114 moveto
0.27736 0.16896 lineto
0.61369 0.99449 lineto
0.53869 0.03094 lineto
0.32371 0.76447 lineto
stroke
0.74655 0.54114 moveto
0.32371 0.76447 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(4)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.19884)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.28602 0.14221 moveto
0.59749 1.00163 lineto
0.55625 0.04615 lineto
0.31151 0.73273 lineto
0.74874 0.5773 lineto
stroke
0.28602 0.14221 moveto
0.74874 0.5773 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(5)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.67758)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.58078 1.00619 moveto
0.57351 0.06368 lineto
0.30027 0.69979 lineto
0.74966 0.61305 lineto
0.29578 0.11729 lineto
stroke
0.58078 1.00619 moveto
0.29578 0.11729 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(6)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.26056)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.59041 0.08346 moveto
0.29006 0.66583 lineto
0.74929 0.64823 lineto
0.30658 0.09433 lineto
0.56366 1.00815 lineto
stroke
0.59041 0.08346 moveto
0.56366 1.00815 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(7)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.97046)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.28092 0.63102 moveto
0.74765 0.68264 lineto
0.31838 0.07346 lineto
0.54622 1.00751 lineto
0.60683 0.10537 lineto
stroke
0.28092 0.63102 moveto
0.60683 0.10537 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(8)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(9)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.83492)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.74473 0.71612 moveto
0.33111 0.05477 lineto
0.52854 1.00427 lineto
0.62271 0.1293 lineto
0.27291 0.59553 lineto
stroke
0.74473 0.71612 moveto
0.27291 0.59553 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(9)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.88759)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.34471 0.03837 moveto
0.51071 0.99844 lineto
0.63796 0.15514 lineto
0.26606 0.55956 lineto
0.74056 0.74849 lineto
stroke
0.34471 0.03837 moveto
0.74056 0.74849 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(11)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(7.16946)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.49283 0.99005 moveto
0.6525 0.18275 lineto
0.26042 0.52328 lineto
0.73515 0.77959 lineto
0.3591 0.02434 lineto
stroke
0.49283 0.99005 moveto
0.3591 0.02434 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(11)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(12)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.73042)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.66626 0.21198 moveto
0.256 0.48688 lineto
0.72854 0.80925 lineto
0.37422 0.01274 lineto
0.47498 0.97915 lineto
stroke
0.66626 0.21198 moveto
0.47498 0.97915 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(12)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(13)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(10.6312)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.25283 0.45055 moveto
0.72076 0.83733 lineto
0.38998 0.00365 lineto
0.45727 0.96579 lineto
0.67917 0.24269 lineto
stroke
0.25283 0.45055 moveto
0.67917 0.24269 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(13)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(14)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(12.9459)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.71184 0.86367 moveto
0.4063 -0.0029 lineto
0.43977 0.95004 lineto
0.69116 0.27472 lineto
0.25093 0.41447 lineto
stroke
0.71184 0.86367 moveto
0.25093 0.41447 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(14)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(15)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(15.7645)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.42311 -0.00687 moveto
0.42258 0.93198 lineto
0.70216 0.30791 lineto
0.25031 0.37883 lineto
0.70184 0.88815 lineto
stroke
0.42311 -0.00687 moveto
0.70184 0.88815 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(15)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(16)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(19.1968)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.40579 0.91171 moveto
0.71213 0.34208 lineto
0.25097 0.34381 lineto
0.6908 0.91064 lineto
0.44031 -0.00824 lineto
stroke
0.40579 0.91171 moveto
0.44031 -0.00824 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(16)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(17)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(23.3764)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.72102 0.37706 moveto
0.25291 0.30959 lineto
0.67878 0.93102 lineto
0.45781 -0.007 lineto
0.38948 0.88932 lineto
stroke
0.72102 0.37706 moveto
0.38948 0.88932 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; endGroup; endGroup; pictureLeft = 99; pictureTop = 2; pictureWidth = 251; pictureHeight = 251; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(17)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(18)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(5)] 1 1 1.7 1.7 Mshowa
0 setgray
[(28.466)] 1 0 1.7 -1.7 Mshowa
0.004 setlinewidth
0.25838 0.25882 moveto
0.25418 0.29466 lineto
0.25151 0.33177 lineto
0.25036 0.36992 lineto
0.25075 0.40887 lineto
0.25268 0.44838 lineto
0.25614 0.4882 lineto
0.2611 0.52811 lineto
0.26753 0.56783 lineto
0.27539 0.60714 lineto
0.28464 0.64579 lineto
0.29522 0.68354 lineto
0.30706 0.72016 lineto
0.32009 0.75542 lineto
0.33422 0.78911 lineto
0.34938 0.82102 lineto
0.36547 0.85094 lineto
0.38239 0.8787 lineto
0.40004 0.90413 lineto
0.4183 0.92706 lineto
0.43706 0.94737 lineto
0.45621 0.96491 lineto
0.47563 0.97959 lineto
0.4952 0.99131 lineto
0.51481 1 lineto
0.53432 1.00561 lineto
0.55361 1.0081 lineto
0.57258 1.00746 lineto
0.5911 1.00369 lineto
0.60906 0.99682 lineto
0.62635 0.98688 lineto
0.64285 0.97394 lineto
0.65848 0.95808 lineto
0.67313 0.93939 lineto
0.68671 0.918 lineto
0.69914 0.89402 lineto
0.71035 0.86762 lineto
0.72025 0.83895 lineto
0.7288 0.8082 lineto
0.73594 0.77554 lineto
0.74162 0.74118 lineto
0.74582 0.70534 lineto
0.74849 0.66823 lineto
0.74964 0.63008 lineto
0.74925 0.59113 lineto
0.74732 0.55162 lineto
0.74386 0.5118 lineto
0.7389 0.47189 lineto
0.73247 0.43217 lineto
0.72461 0.39286 lineto
Mistroke
0.71536 0.35421 lineto
0.70478 0.31646 lineto
0.69294 0.27984 lineto
0.67991 0.24458 lineto
0.66578 0.21089 lineto
0.65062 0.17898 lineto
0.63453 0.14906 lineto
0.61761 0.1213 lineto
0.59996 0.09587 lineto
0.5817 0.07294 lineto
0.56294 0.05263 lineto
0.54379 0.03509 lineto
0.52437 0.02041 lineto
0.5048 0.00869 lineto
0.48519 0 lineto
0.46568 -0.00561 lineto
0.44639 -0.0081 lineto
0.42742 -0.00746 lineto
0.4089 -0.00369 lineto
0.39094 0.00318 lineto
0.37365 0.01312 lineto
0.35715 0.02606 lineto
0.34152 0.04192 lineto
0.32687 0.06061 lineto
0.31329 0.082 lineto
0.30086 0.10598 lineto
0.28965 0.13238 lineto
0.27975 0.16105 lineto
0.2712 0.1918 lineto
0.26406 0.22446 lineto
0.25838 0.25882 lineto
Mfstroke
0 setgray
[(Const. scaling factor)] 0.5 1 0 1.5 Mshowa
gsave
0.25612 0.27635 moveto
0.66585 0.94919 lineto
0.47554 -0.00316 lineto
0.37374 0.86494 lineto
0.72876 0.41268 lineto
stroke
0.25612 0.27635 moveto
0.72876 0.41268 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = subsubsection; inactive; startGroup; Cclosed; ]
Movement of particles.
:[font = input; startGroup; ]
MidPointPolygonMovie[RandomStellarPolygon[20],
                     Blowing->Resized,
                     TotalFrameNumber->40,
                     Style->Vertices,
                     FractionPoint->.1,
                     VertexSize->14]
:[font = postscript; inactive; PostScript; output; startGroup; Cclosed; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.40731 0.3572 Mdot
0.51786 0.41748 Mdot
0.46214 0.78216 Mdot
0.61466 0.48679 Mdot
0.6679 0.34388 Mdot
0.38702 0.24801 Mdot
0.34335 0.8613 Mdot
0.67994 0.43993 Mdot
0.42353 0.49459 Mdot
0.47964 0.55379 Mdot
0.18029 0.39759 Mdot
1 0.4215 Mdot
0.60135 0.68393 Mdot
0.35194 0.28447 Mdot
0.26739 0.69356 Mdot
0.40236 0.585 Mdot
0.47669 0.19659 Mdot
0.98476 0.80997 Mdot
0.49762 0.19405 Mdot
0.25425 0.74822 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.15221)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.50784 0.39798 Mdot
0.4628 0.78308 Mdot
0.61454 0.51881 Mdot
0.68732 0.33659 Mdot
0.40219 0.2207 Mdot
0.32454 0.84563 Mdot
0.66855 0.47934 Mdot
0.44143 0.48747 Mdot
0.47008 0.55515 Mdot
0.16612 0.4 Mdot
0.98166 0.4068 Mdot
0.66271 0.68169 Mdot
0.35814 0.29769 Mdot
0.24172 0.67589 Mdot
0.37195 0.61045 Mdot
0.46458 0.19516 Mdot
1 0.78647 Mdot
0.55338 0.21845 Mdot
0.24489 0.72215 Mdot
0.37557 0.38052 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(2)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.29039)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.46338 0.7739 Mdot
0.61129 0.55066 Mdot
0.70164 0.3374 Mdot
0.42239 0.20018 Mdot
0.31219 0.8171 Mdot
0.65023 0.51788 Mdot
0.45984 0.48505 Mdot
0.46328 0.55419 Mdot
0.16012 0.40538 Mdot
0.94809 0.39486 Mdot
0.71794 0.67269 Mdot
0.37524 0.31643 Mdot
0.22379 0.65463 Mdot
0.34201 0.63102 Mdot
0.44995 0.20511 Mdot
1 0.75461 Mdot
0.6098 0.2483 Mdot
0.24884 0.69239 Mdot
0.34601 0.40445 Mdot
0.49397 0.38379 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.44989)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.60842 0.58201 Mdot
0.71641 0.34126 Mdot
0.44418 0.17854 Mdot
0.30136 0.78697 Mdot
0.63082 0.55371 Mdot
0.47627 0.48689 Mdot
0.45835 0.55312 Mdot
0.15217 0.41041 Mdot
0.91494 0.38304 Mdot
0.77074 0.66282 Mdot
0.39832 0.33377 Mdot
0.20666 0.63574 Mdot
0.3092 0.64987 Mdot
0.43164 0.21651 Mdot
1 0.72434 Mdot
0.66722 0.27408 Mdot
0.25835 0.66627 Mdot
0.31606 0.42499 Mdot
0.4766 0.37174 Mdot
0.46229 0.76393 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(4)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.63584)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.73198 0.34806 Mdot
0.46773 0.15567 Mdot
0.292 0.75513 Mdot
0.61043 0.58692 Mdot
0.49067 0.49275 Mdot
0.45504 0.55246 Mdot
0.14211 0.41502 Mdot
0.88209 0.37113 Mdot
0.82173 0.65213 Mdot
0.4273 0.34957 Mdot
0.19066 0.61908 Mdot
0.27316 0.66749 Mdot
0.40906 0.22905 Mdot
1 0.69581 Mdot
0.72621 0.2959 Mdot
0.27349 0.64334 Mdot
0.28595 0.44259 Mdot
0.45548 0.3613 Mdot
0.45907 0.75353 Mdot
0.60584 0.61305 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(5)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.85509)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.49337 0.13134 Mdot
0.28405 0.72134 Mdot
0.58912 0.61764 Mdot
0.503 0.50246 Mdot
0.45305 0.55272 Mdot
0.12962 0.41921 Mdot
0.84939 0.35883 Mdot
0.8717 0.64066 Mdot
0.46228 0.36372 Mdot
0.17604 0.60448 Mdot
0.2334 0.68445 Mdot
0.38146 0.24245 Mdot
1 0.66912 Mdot
0.78758 0.3139 Mdot
0.29447 0.62315 Mdot
0.25585 0.45766 Mdot
0.43029 0.35193 Mdot
0.45318 0.74303 Mdot
0.60338 0.64413 Mdot
0.74877 0.35775 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(6)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.11698)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.27745 0.68526 Mdot
0.56689 0.64609 Mdot
0.51325 0.51595 Mdot
0.45212 0.55442 Mdot
0.11425 0.42304 Mdot
0.81657 0.3458 Mdot
0.92163 0.62835 Mdot
0.50368 0.37609 Mdot
0.16297 0.59175 Mdot
0.18922 0.70137 Mdot
0.34783 0.25654 Mdot
1 0.64431 Mdot
0.85242 0.32816 Mdot
0.32173 0.60525 Mdot
0.22579 0.47057 Mdot
0.40054 0.3431 Mdot
0.44396 0.73271 Mdot
0.60084 0.67577 Mdot
0.7673 0.37035 Mdot
0.52158 0.10513 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(7)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.43453)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.54363 0.6725 Mdot
0.5214 0.53331 Mdot
0.45197 0.55816 Mdot
0.09524 0.42661 Mdot
0.78329 0.33155 Mdot
0.97279 0.61511 Mdot
0.5523 0.38651 Mdot
0.1516 0.58071 Mdot
0.13958 0.71897 Mdot
0.30676 0.27117 Mdot
1 0.62136 Mdot
0.92225 0.33874 Mdot
0.35602 0.58917 Mdot
0.19569 0.48165 Mdot
0.36553 0.33422 Mdot
0.43056 0.72281 Mdot
0.59792 0.70868 Mdot
0.78825 0.38603 Mdot
0.55308 0.0764 Mdot
0.27214 0.64634 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(8)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(9)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.68215)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(9)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.52603 0.55203 Mdot
0.45473 0.56134 Mdot
0.09337 0.43364 Mdot
0.7363 0.32489 Mdot
1 0.59558 Mdot
0.60394 0.40015 Mdot
0.1603 0.56753 Mdot
0.10424 0.72601 Mdot
0.26869 0.29723 Mdot
0.97448 0.59512 Mdot
0.97376 0.35348 Mdot
0.40376 0.57065 Mdot
0.18241 0.49163 Mdot
0.33314 0.3336 Mdot
0.41633 0.70266 Mdot
0.58944 0.73146 Mdot
0.7966 0.40998 Mdot
0.58438 0.06742 Mdot
0.27992 0.59843 Mdot
0.51816 0.68717 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(9)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.83025)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.45976 0.56375 Mdot
0.10905 0.44345 Mdot
0.68151 0.3267 Mdot
0.99978 0.57229 Mdot
0.65147 0.41526 Mdot
0.18836 0.55359 Mdot
0.08831 0.72176 Mdot
0.23856 0.33128 Mdot
0.9262 0.56894 Mdot
1 0.37089 Mdot
0.45859 0.55164 Mdot
0.18823 0.4995 Mdot
0.30802 0.34109 Mdot
0.40293 0.67491 Mdot
0.57612 0.7412 Mdot
0.79112 0.43893 Mdot
0.61144 0.07969 Mdot
0.29989 0.54783 Mdot
0.49402 0.68814 Mdot
0.52664 0.56916 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(11)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.87265)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(11)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.13879 0.45481 Mdot
0.62612 0.33595 Mdot
0.97497 0.54845 Mdot
0.6891 0.42993 Mdot
0.2307 0.54036 Mdot
0.0923 0.70801 Mdot
0.21939 0.36838 Mdot
0.86279 0.54585 Mdot
1 0.38905 Mdot
0.51292 0.53406 Mdot
0.211 0.50479 Mdot
0.29299 0.35479 Mdot
0.39185 0.64364 Mdot
0.55968 0.73809 Mdot
0.77366 0.4687 Mdot
0.63134 0.10985 Mdot
0.32852 0.50103 Mdot
0.47423 0.67672 Mdot
0.52373 0.58228 Mdot
0.46594 0.56525 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(11)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(12)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(2.9537)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(12)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.57957 0.34354 Mdot
0.9525 0.52797 Mdot
0.72382 0.44014 Mdot
0.27023 0.53014 Mdot
0.09502 0.69665 Mdot
0.19841 0.39959 Mdot
0.80688 0.5289 Mdot
1 0.40205 Mdot
0.56337 0.52011 Mdot
0.23389 0.50793 Mdot
0.27871 0.36611 Mdot
0.37863 0.618 Mdot
0.54411 0.7351 Mdot
0.75938 0.49551 Mdot
0.64968 0.13574 Mdot
0.35482 0.46084 Mdot
0.45852 0.66364 Mdot
0.51931 0.59431 Mdot
0.47092 0.56884 Mdot
0.16224 0.46489 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(12)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(13)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.07237)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(13)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.93189 0.50991 Mdot
0.7566 0.44687 Mdot
0.30818 0.52199 Mdot
0.09698 0.68723 Mdot
0.17554 0.42646 Mdot
0.75591 0.51661 Mdot
1 0.41131 Mdot
0.61133 0.50864 Mdot
0.25747 0.50952 Mdot
0.26516 0.37548 Mdot
0.36336 0.59654 Mdot
0.52866 0.73236 Mdot
0.74741 0.52025 Mdot
0.66711 0.15853 Mdot
0.37965 0.42545 Mdot
0.44607 0.64912 Mdot
0.51376 0.60531 Mdot
0.47479 0.57426 Mdot
0.18077 0.4743 Mdot
0.53936 0.34988 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(13)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(14)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.23006)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(14)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.7882 0.45077 Mdot
0.34548 0.51522 Mdot
0.0985 0.67946 Mdot
0.15063 0.4501 Mdot
0.70803 0.50798 Mdot
1 0.41782 Mdot
0.65791 0.49885 Mdot
0.28222 0.50991 Mdot
0.2523 0.38319 Mdot
0.34602 0.57825 Mdot
0.51276 0.73001 Mdot
0.73711 0.54359 Mdot
0.68412 0.17903 Mdot
0.4037 0.39356 Mdot
0.43632 0.63326 Mdot
0.50735 0.61532 Mdot
0.47759 0.58133 Mdot
0.1953 0.48349 Mdot
0.50368 0.35525 Mdot
0.91279 0.49359 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(14)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(15)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.43037)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(15)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.38292 0.50932 Mdot
0.09983 0.67315 Mdot
0.12342 0.47136 Mdot
0.66174 0.50233 Mdot
1 0.4223 Mdot
0.70403 0.49018 Mdot
0.30862 0.50935 Mdot
0.24012 0.3894 Mdot
0.32652 0.56239 Mdot
0.49584 0.72815 Mdot
0.72798 0.56609 Mdot
0.70117 0.19785 Mdot
0.42751 0.36418 Mdot
0.4289 0.61606 Mdot
0.50026 0.62437 Mdot
0.47936 0.58999 Mdot
0.20638 0.49285 Mdot
0.47116 0.3599 Mdot
0.89494 0.4785 Mdot
0.8193 0.45227 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(15)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(16)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.67928)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(16)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.10115 0.66814 Mdot
0.09357 0.49093 Mdot
0.61573 0.49918 Mdot
1 0.42525 Mdot
0.75058 0.48218 Mdot
0.33714 0.50798 Mdot
0.22861 0.39424 Mdot
0.30467 0.54836 Mdot
0.47738 0.72693 Mdot
0.71963 0.58827 Mdot
0.71864 0.21542 Mdot
0.4516 0.33648 Mdot
0.42359 0.59747 Mdot
0.49263 0.63251 Mdot
0.48011 0.6002 Mdot
0.21436 0.50275 Mdot
0.44067 0.36399 Mdot
0.87814 0.46422 Mdot
0.85059 0.45162 Mdot
0.42123 0.50388 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(16)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(17)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(3.98559)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(17)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.06055 0.50937 Mdot
0.56881 0.49822 Mdot
1 0.42703 Mdot
0.79846 0.47453 Mdot
0.36837 0.50585 Mdot
0.21777 0.39776 Mdot
0.28016 0.53569 Mdot
0.45679 0.72648 Mdot
0.71167 0.61064 Mdot
0.73695 0.23211 Mdot
0.4765 0.30976 Mdot
0.42027 0.57731 Mdot
0.48453 0.63974 Mdot
0.47981 0.61204 Mdot
0.21936 0.51354 Mdot
0.41121 0.3677 Mdot
0.86223 0.45039 Mdot
0.88276 0.44895 Mdot
0.46118 0.49854 Mdot
0.10262 0.66435 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(17)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(18)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.36174)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(18)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.51968 0.49927 Mdot
1 0.42794 Mdot
0.84868 0.46693 Mdot
0.40301 0.50297 Mdot
0.20761 0.39994 Mdot
0.25259 0.52396 Mdot
0.43338 0.72697 Mdot
0.70375 0.63376 Mdot
0.75655 0.24826 Mdot
0.50278 0.2833 Mdot
0.4189 0.55533 Mdot
0.47604 0.6461 Mdot
0.47842 0.62565 Mdot
0.22138 0.5256 Mdot
0.38184 0.37117 Mdot
0.84706 0.43665 Mdot
0.91664 0.44429 Mdot
0.50365 0.49297 Mdot
0.10436 0.66171 Mdot
0.02368 0.52721 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(18)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(19)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.6575)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(19)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.98261 0.43067 Mdot
0.88848 0.46053 Mdot
0.44402 0.49932 Mdot
0.20865 0.40415 Mdot
0.23101 0.51235 Mdot
0.40956 0.72069 Mdot
0.6887 0.65278 Mdot
0.76831 0.27235 Mdot
0.53007 0.26487 Mdot
0.42235 0.53003 Mdot
0.46832 0.64631 Mdot
0.4767 0.63635 Mdot
0.22994 0.53802 Mdot
0.35669 0.37893 Mdot
0.82092 0.42537 Mdot
0.93746 0.4397 Mdot
0.548 0.4873 Mdot
0.12017 0.65466 Mdot
0 0.54342 Mdot
0.46805 0.5022 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(19)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(20)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.77219)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(20)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.9077 0.45649 Mdot
0.48819 0.49533 Mdot
0.22559 0.41154 Mdot
0.22209 0.50156 Mdot
0.38903 0.70477 Mdot
0.66474 0.6635 Mdot
0.76676 0.30573 Mdot
0.55522 0.25984 Mdot
0.43148 0.5036 Mdot
0.46283 0.638 Mdot
0.47527 0.64073 Mdot
0.24857 0.54903 Mdot
0.34018 0.39225 Mdot
0.78125 0.41877 Mdot
0.93629 0.43675 Mdot
0.58908 0.48211 Mdot
0.15465 0.64132 Mdot
0 0.55589 Mdot
0.4193 0.50648 Mdot
0.94178 0.43629 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(20)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(21)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(4.9245)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(21)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.5311 0.49118 Mdot
0.24393 0.41737 Mdot
0.21359 0.49232 Mdot
0.36827 0.69034 Mdot
0.64155 0.67298 Mdot
0.76474 0.33644 Mdot
0.57881 0.25691 Mdot
0.44206 0.47856 Mdot
0.4584 0.62854 Mdot
0.47319 0.64494 Mdot
0.26394 0.56006 Mdot
0.32562 0.40499 Mdot
0.74472 0.41344 Mdot
0.93422 0.43287 Mdot
0.62776 0.47686 Mdot
0.18846 0.6294 Mdot
0 0.56649 Mdot
0.37346 0.51179 Mdot
0.90196 0.4415 Mdot
0.92422 0.45302 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(21)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(22)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.11739)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(22)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.26375 0.4218 Mdot
0.20552 0.48423 Mdot
0.34703 0.67722 Mdot
0.6187 0.68156 Mdot
0.76231 0.36501 Mdot
0.60122 0.25566 Mdot
0.454 0.45469 Mdot
0.45508 0.61799 Mdot
0.47061 0.64892 Mdot
0.27644 0.57123 Mdot
0.31238 0.41738 Mdot
0.71075 0.40917 Mdot
0.93153 0.42822 Mdot
0.66461 0.47138 Mdot
0.22191 0.61862 Mdot
0 0.57563 Mdot
0.32969 0.51793 Mdot
0.86278 0.44651 Mdot
0.93853 0.44998 Mdot
0.57317 0.48686 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(22)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(23)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.35505)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(23)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.19794 0.47697 Mdot
0.32512 0.66525 Mdot
0.59578 0.68954 Mdot
0.75947 0.39187 Mdot
0.62278 0.25575 Mdot
0.46727 0.43176 Mdot
0.45288 0.60638 Mdot
0.46762 0.65259 Mdot
0.28637 0.58267 Mdot
0.29991 0.42964 Mdot
0.67885 0.40581 Mdot
0.92847 0.4229 Mdot
0.70018 0.46554 Mdot
0.25532 0.60872 Mdot
0 0.58364 Mdot
0.28728 0.5248 Mdot
0.82385 0.4515 Mdot
0.95097 0.4473 Mdot
0.6148 0.4824 Mdot
0.28515 0.42498 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(23)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(24)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.64321)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(24)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.30231 0.6543 Mdot
0.57241 0.69718 Mdot
0.75618 0.41742 Mdot
0.64379 0.25695 Mdot
0.4819 0.40954 Mdot
0.45186 0.5937 Mdot
0.46432 0.65594 Mdot
0.29398 0.59448 Mdot
0.28771 0.44198 Mdot
0.64854 0.40325 Mdot
0.92522 0.41695 Mdot
0.73501 0.45919 Mdot
0.28903 0.59948 Mdot
0 0.59078 Mdot
0.24556 0.53234 Mdot
0.78473 0.45662 Mdot
0.96184 0.4449 Mdot
0.6564 0.47775 Mdot
0.30833 0.42699 Mdot
0.19087 0.47025 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(24)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(25)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.98944)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(25)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.54819 0.70472 Mdot
0.75239 0.44204 Mdot
0.66454 0.25907 Mdot
0.49797 0.38779 Mdot
0.45209 0.57991 Mdot
0.46081 0.6589 Mdot
0.29942 0.6068 Mdot
0.27535 0.45461 Mdot
0.61936 0.40143 Mdot
0.92194 0.4104 Mdot
0.76962 0.4522 Mdot
0.32342 0.59069 Mdot
0 0.59728 Mdot
0.20389 0.54053 Mdot
0.74498 0.46199 Mdot
0.97138 0.44277 Mdot
0.69842 0.4729 Mdot
0.33351 0.4279 Mdot
0.18438 0.46383 Mdot
0.27835 0.64424 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(25)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(26)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(6.40365)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(26)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.74801 0.46612 Mdot
0.68531 0.26197 Mdot
0.51564 0.36627 Mdot
0.45369 0.56489 Mdot
0.45717 0.66144 Mdot
0.3028 0.61976 Mdot
0.26239 0.46774 Mdot
0.59083 0.4003 Mdot
0.91877 0.40324 Mdot
0.80455 0.44443 Mdot
0.35891 0.58216 Mdot
0 0.6033 Mdot
0.16161 0.5494 Mdot
0.70407 0.46776 Mdot
0.97977 0.44087 Mdot
0.74132 0.4678 Mdot
0.36101 0.42772 Mdot
0.17849 0.45749 Mdot
0.25297 0.63492 Mdot
0.52267 0.71242 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(26)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(27)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(6.89887)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(27)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.7064 0.26556 Mdot
0.53513 0.34469 Mdot
0.45678 0.54851 Mdot
0.45348 0.66352 Mdot
0.30418 0.63351 Mdot
0.24837 0.48162 Mdot
0.56247 0.39985 Mdot
0.91583 0.39544 Mdot
0.84041 0.43569 Mdot
0.39601 0.57367 Mdot
0 0.60901 Mdot
0.11803 0.55902 Mdot
0.66141 0.47406 Mdot
0.98717 0.43919 Mdot
0.78567 0.46241 Mdot
0.39124 0.42645 Mdot
0.17329 0.451 Mdot
0.22585 0.62624 Mdot
0.49537 0.72049 Mdot
0.74292 0.49003 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(27)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(28)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(7.49228)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(28)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.55675 0.32274 Mdot
0.46157 0.53055 Mdot
0.44984 0.6651 Mdot
0.30355 0.64825 Mdot
0.23279 0.49654 Mdot
0.53373 0.40012 Mdot
0.91322 0.38693 Mdot
0.87788 0.42579 Mdot
0.43533 0.56503 Mdot
0 0.61455 Mdot
0.07236 0.56953 Mdot
0.61628 0.48106 Mdot
0.9937 0.43775 Mdot
0.83213 0.45666 Mdot
0.42472 0.42403 Mdot
0.16886 0.44412 Mdot
0.19656 0.61807 Mdot
0.4657 0.72922 Mdot
0.73693 0.5142 Mdot
0.72812 0.26977 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(28)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(29)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.20682)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(29)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.46833 0.5107 Mdot
0.44634 0.66611 Mdot
0.30084 0.66424 Mdot
0.21505 0.51283 Mdot
0.50399 0.40116 Mdot
0.91106 0.37759 Mdot
0.91779 0.41445 Mdot
0.47764 0.55598 Mdot
0 0.62005 Mdot
0.02365 0.58109 Mdot
0.56779 0.48894 Mdot
0.99944 0.43655 Mdot
0.8815 0.45045 Mdot
0.46217 0.42036 Mdot
0.1653 0.43659 Mdot
0.16459 0.61028 Mdot
0.43295 0.73891 Mdot
0.72981 0.53911 Mdot
0.75084 0.27459 Mdot
0.58093 0.30003 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(29)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(30)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.57171)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(30)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.44625 0.65726 Mdot
0.30718 0.67174 Mdot
0.21134 0.52921 Mdot
0.47399 0.40842 Mdot
0.88682 0.37461 Mdot
0.93566 0.4068 Mdot
0.52262 0.54368 Mdot
0.02766 0.6187 Mdot
0 0.58877 Mdot
0.51397 0.49808 Mdot
0.97656 0.4392 Mdot
0.91078 0.4468 Mdot
0.50428 0.41996 Mdot
0.18143 0.43207 Mdot
0.14975 0.59704 Mdot
0.40194 0.7361 Mdot
0.70902 0.56172 Mdot
0.75979 0.29219 Mdot
0.60228 0.28849 Mdot
0.47868 0.48917 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(30)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(31)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.61939)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(31)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.32009 0.67124 Mdot
0.21937 0.5437 Mdot
0.44743 0.42006 Mdot
0.84746 0.37731 Mdot
0.93317 0.40305 Mdot
0.56428 0.53016 Mdot
0.0748 0.61181 Mdot
0 0.59227 Mdot
0.46237 0.50718 Mdot
0.93269 0.44479 Mdot
0.91968 0.44574 Mdot
0.54518 0.42221 Mdot
0.21212 0.43048 Mdot
0.15098 0.58099 Mdot
0.37603 0.72343 Mdot
0.67931 0.5796 Mdot
0.75613 0.31814 Mdot
0.61868 0.28768 Mdot
0.49099 0.46893 Mdot
0.44921 0.64123 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(31)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(32)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.75029)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(32)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.22534 0.55732 Mdot
0.42348 0.4314 Mdot
0.81213 0.37979 Mdot
0.93105 0.39896 Mdot
0.6027 0.51772 Mdot
0.11803 0.60522 Mdot
0 0.59565 Mdot
0.41486 0.51593 Mdot
0.89152 0.45028 Mdot
0.92738 0.44482 Mdot
0.58389 0.42342 Mdot
0.24156 0.42858 Mdot
0.15189 0.56694 Mdot
0.3513 0.71236 Mdot
0.65124 0.59541 Mdot
0.75222 0.34192 Mdot
0.63444 0.28755 Mdot
0.50382 0.45006 Mdot
0.45268 0.62589 Mdot
0.33047 0.67079 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(32)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(33)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(8.96186)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(33)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.40134 0.44264 Mdot
0.77987 0.38217 Mdot
0.92929 0.39455 Mdot
0.63881 0.50598 Mdot
0.15844 0.5988 Mdot
0 0.59895 Mdot
0.37031 0.52448 Mdot
0.85217 0.4558 Mdot
0.93404 0.44404 Mdot
0.62109 0.42376 Mdot
0.27037 0.42633 Mdot
0.15266 0.55439 Mdot
0.32728 0.7026 Mdot
0.62418 0.60969 Mdot
0.74798 0.36406 Mdot
0.64975 0.28798 Mdot
0.51729 0.43221 Mdot
0.45677 0.61092 Mdot
0.33889 0.67032 Mdot
0.22946 0.57032 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(33)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(34)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(9.25513)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(34)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.74993 0.38456 Mdot
0.92791 0.38982 Mdot
0.67336 0.49467 Mdot
0.19687 0.59245 Mdot
0 0.60217 Mdot
0.32782 0.53297 Mdot
0.81393 0.46145 Mdot
0.93979 0.44342 Mdot
0.65737 0.42336 Mdot
0.29908 0.42365 Mdot
0.15345 0.54294 Mdot
0.3036 0.69392 Mdot
0.59758 0.62288 Mdot
0.74331 0.38498 Mdot
0.6648 0.2889 Mdot
0.53153 0.4151 Mdot
0.46161 0.5961 Mdot
0.34579 0.66976 Mdot
0.23191 0.58295 Mdot
0.38036 0.45395 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(34)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(35)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(9.63448)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(35)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.92692 0.38476 Mdot
0.70696 0.48354 Mdot
0.23405 0.58606 Mdot
0 0.60535 Mdot
0.28664 0.54153 Mdot
0.77619 0.46731 Mdot
0.94471 0.44298 Mdot
0.69322 0.42231 Mdot
0.32814 0.42049 Mdot
0.1544 0.53228 Mdot
0.27992 0.68616 Mdot
0.57098 0.63531 Mdot
0.73811 0.40503 Mdot
0.67973 0.29025 Mdot
0.5467 0.39848 Mdot
0.46732 0.58119 Mdot
0.35152 0.66905 Mdot
0.23278 0.59539 Mdot
0.36 0.46549 Mdot
0.72171 0.38705 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(35)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(36)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(10.1076)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(36)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.7402 0.47237 Mdot
0.2706 0.57953 Mdot
0 0.6085 Mdot
0.24609 0.55026 Mdot
0.7384 0.4735 Mdot
0.94887 0.44274 Mdot
0.7291 0.42066 Mdot
0.358 0.41678 Mdot
0.15566 0.52214 Mdot
0.25594 0.67915 Mdot
0.54393 0.64729 Mdot
0.73227 0.42452 Mdot
0.69468 0.29199 Mdot
0.56295 0.38214 Mdot
0.47404 0.56601 Mdot
0.35638 0.66813 Mdot
0.23211 0.6078 Mdot
0.33978 0.47742 Mdot
0.69465 0.38973 Mdot
0.92636 0.37934 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(36)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(37)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(10.6859)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(37)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.30712 0.57275 Mdot
0 0.61164 Mdot
0.20554 0.55929 Mdot
0.69999 0.48009 Mdot
0.9523 0.44271 Mdot
0.76544 0.41846 Mdot
0.38911 0.41243 Mdot
0.15735 0.51227 Mdot
0.23138 0.67281 Mdot
0.516 0.65908 Mdot
0.72565 0.44376 Mdot
0.70979 0.2941 Mdot
0.58048 0.36586 Mdot
0.48195 0.55035 Mdot
0.3606 0.66696 Mdot
0.22992 0.62035 Mdot
0.31923 0.48991 Mdot
0.66827 0.39269 Mdot
0.92626 0.37354 Mdot
0.77362 0.46095 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(37)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(38)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(11.3853)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(38)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0 0.6148 Mdot
0.16437 0.56875 Mdot
0.6604 0.48723 Mdot
0.95502 0.44294 Mdot
0.80272 0.4157 Mdot
0.42195 0.40734 Mdot
0.15962 0.50243 Mdot
0.20591 0.66701 Mdot
0.48672 0.67096 Mdot
0.71808 0.46302 Mdot
0.72521 0.29657 Mdot
0.59952 0.34944 Mdot
0.49127 0.53399 Mdot
0.36441 0.66546 Mdot
0.22617 0.63319 Mdot
0.29788 0.50315 Mdot
0.64209 0.39603 Mdot
0.92666 0.3673 Mdot
0.80779 0.44908 Mdot
0.3442 0.5656 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(38)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(39)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(12.227)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(39)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.12191 0.57878 Mdot
0.61899 0.49504 Mdot
0.95702 0.44348 Mdot
0.84146 0.4124 Mdot
0.45707 0.40139 Mdot
0.16263 0.4924 Mdot
0.1792 0.66168 Mdot
0.45558 0.68317 Mdot
0.70936 0.48262 Mdot
0.74109 0.29941 Mdot
0.62038 0.33263 Mdot
0.50225 0.51668 Mdot
0.36801 0.66357 Mdot
0.22077 0.6465 Mdot
0.27524 0.51735 Mdot
0.61563 0.39984 Mdot
0.92765 0.36057 Mdot
0.84331 0.43653 Mdot
0.38247 0.55794 Mdot
0 0.61801 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; endGroup; endGroup; pictureLeft = 81; pictureTop = 2; pictureWidth = 263; pictureHeight = 263; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(39)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(40)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(20)] 1 1 1.7 1.7 Mshowa
0 setgray
[(13.2397)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(40)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.07 setlinewidth
0.57502 0.5037 Mdot
0.95827 0.44438 Mdot
0.88225 0.40851 Mdot
0.49514 0.39441 Mdot
0.16656 0.48192 Mdot
0.15083 0.65674 Mdot
0.42197 0.69602 Mdot
0.69922 0.50289 Mdot
0.75763 0.30263 Mdot
0.64342 0.31517 Mdot
0.51523 0.49813 Mdot
0.37161 0.66122 Mdot
0.21359 0.66048 Mdot
0.25073 0.53277 Mdot
0.58835 0.40427 Mdot
0.92928 0.35328 Mdot
0.88088 0.42305 Mdot
0.42264 0.54959 Mdot
0 0.62128 Mdot
0.07739 0.58955 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = subsubsection; inactive; startGroup; Cclosed; ]
 Indeed,  midpoint polygons converge...
:[font = text; inactive; ]
Let use the function Picture which was defined in the subsection  "More advanced examples" in the section "Example". Animate the pictures "in one direction".
:[font = input; ]
polygon=2 Table[{.8 Cos[i],Sin[i]},{i,2Pi/9,2Pi,2Pi/9}]//N;
Do[Picture[N[ScalingFactor[polygon,1/6]^i polygon],100+i,1/6],
  {i,0,5}
  ]
:[font = postscript; inactive; PostScript; output; startGroup; Cclosed; pictureWidth = 431; pictureHeight = 431; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.11284 1.14279 moveto
0.63892 1.48481 lineto
0.1 1.36603 lineto
-0.25175 0.84202 lineto
-0.25175 0.15798 lineto
0.1 -0.36603 lineto
0.63892 -0.48481 lineto
1.11284 -0.14279 lineto
1.3 0.5 lineto
1.11284 1.14279 lineto
0.7179 1.4278 lineto
0.18982 1.38582 lineto
-0.19313 0.92935 lineto
-0.25175 0.27199 lineto
0.04137 -0.27869 lineto
0.5491 -0.46501 lineto
1.03385 -0.19979 lineto
1.26881 0.39287 lineto
1.14403 1.03566 lineto
0.7179 1.4278 lineto
0.27783 1.39282 lineto
-0.1293 1.00543 lineto
-0.24198 0.38155 lineto
-0.00748 -0.18691 lineto
0.46448 -0.43396 lineto
0.95306 -0.24399 lineto
1.22965 0.29409 lineto
1.16483 0.92853 lineto
0.78893 1.36245 lineto
0.27783 1.39282 lineto
-0.06145 1.07 lineto
-0.2232 0.48553 lineto
-0.04656 -0.09217 lineto
0.38582 -0.39278 lineto
0.87163 -0.27565 lineto
1.18355 0.20441 lineto
1.17563 0.82279 lineto
0.85158 1.29013 lineto
0.36302 1.38776 lineto
-0.06145 1.07 lineto
-0.19624 0.58294 lineto
-0.076 0.00411 lineto
0.31375 -0.34268 lineto
0.79066 -0.29518 lineto
1.13156 0.1244 lineto
1.17695 0.71972 lineto
0.90558 1.21224 lineto
0.44444 1.37149 lineto
0.0093 1.12296 lineto
-0.19624 0.58294 lineto
Mistroke
-0.09604 0.10059 lineto
0.24879 -0.28488 lineto
0.71118 -0.30309 lineto
1.07474 0.05447 lineto
1.16938 0.6205 lineto
0.95081 1.13015 lineto
0.5213 1.34494 lineto
0.08182 1.16438 lineto
-0.16199 0.67294 lineto
-0.09604 0.10059 lineto
0.19132 -0.22064 lineto
0.63411 -0.30006 lineto
1.01415 -0.00512 lineto
1.15361 0.52616 lineto
0.98724 1.04521 lineto
0.59288 1.30915 lineto
0.15507 1.19447 lineto
-0.12135 0.75485 lineto
-0.10703 0.19598 lineto
0.19132 -0.22064 lineto
0.56031 -0.28682 lineto
0.95081 -0.05428 lineto
1.13037 0.43762 lineto
1.01497 0.9587 lineto
0.65861 1.26516 lineto
0.22804 1.21358 lineto
-0.07528 0.82812 lineto
-0.10942 0.28912 lineto
0.1416 -0.1512 lineto
0.56031 -0.28682 lineto
0.88573 -0.09304 lineto
1.10044 0.35563 lineto
1.0342 0.87185 lineto
0.718 1.21408 lineto
0.2998 1.22218 lineto
-0.02473 0.89236 lineto
-0.10373 0.37896 lineto
0.09976 -0.07781 lineto
0.49053 -0.26422 lineto
0.88573 -0.09304 lineto
1.06466 0.28086 lineto
1.04524 0.78582 lineto
0.7707 1.15704 lineto
0.3695 1.22083 lineto
0.02936 0.94733 lineto
-0.09056 0.46452 lineto
0.06584 -0.00169 lineto
0.4254 -0.23315 lineto
0.81986 -0.12157 lineto
1.06466 0.28086 lineto
Mistroke
1.04848 0.70166 lineto
0.81646 1.09517 lineto
0.43637 1.2102 lineto
0.08605 0.99292 lineto
-0.07058 0.54499 lineto
0.03978 0.07602 lineto
0.36547 -0.19457 lineto
0.75412 -0.14016 lineto
1.02386 0.21379 lineto
1.04848 0.70166 lineto
0.85513 1.02959 lineto
0.49972 1.19103 lineto
0.14444 1.02913 lineto
-0.04447 0.61965 lineto
0.02138 0.15418 lineto
0.31119 -0.14947 lineto
0.68934 -0.14923 lineto
0.9789 0.15479 lineto
1.04437 0.62035 lineto
0.85513 1.02959 lineto
0.55895 1.16412 lineto
0.20365 1.05611 lineto
-0.01299 0.68789 lineto
0.01041 0.23176 lineto
0.26289 -0.09887 lineto
0.62632 -0.14927 lineto
0.93064 0.10412 lineto
1.03346 0.54275 lineto
0.88667 0.96138 lineto
0.55895 1.16412 lineto
0.26287 1.07411 lineto
0.02312 0.74926 lineto
0.00651 0.30778 lineto
0.22081 -0.04376 lineto
0.56575 -0.14087 lineto
0.87992 0.06189 lineto
1.01632 0.46965 lineto
0.91114 0.89161 lineto
0.61357 1.13033 lineto
0.26287 1.07411 lineto
0.06308 0.80341 lineto
0.00928 0.38136 lineto
0.18509 0.01483 lineto
0.50826 -0.12469 lineto
0.82756 0.0281 lineto
0.99359 0.40169 lineto
0.92867 0.82128 lineto
0.66317 1.09054 lineto
0.32132 1.08348 lineto
0.06308 0.80341 lineto
Mistroke
0.01824 0.4517 lineto
0.15579 0.07592 lineto
0.4544 -0.10143 lineto
0.77434 0.00263 lineto
0.96592 0.33942 lineto
0.93949 0.75135 lineto
0.70742 1.04567 lineto
0.37829 1.08466 lineto
0.10612 0.85008 lineto
0.01824 0.4517 lineto
0.13287 0.13855 lineto
0.40463 -0.07188 lineto
0.72102 -0.01471 lineto
0.93399 0.28329 lineto
0.94389 0.6827 lineto
0.74609 0.99661 lineto
0.43315 1.07816 lineto
0.15148 0.88918 lineto
0.03289 0.5181 lineto
0.13287 0.13855 lineto
0.35933 -0.03681 lineto
0.66829 -0.02424 lineto
0.89849 0.23362 lineto
0.94224 0.61613 lineto
0.77906 0.94429 lineto
0.4853 1.06457 lineto
0.19842 0.92068 lineto
0.05265 0.57995 lineto
0.1162 0.20181 lineto
0.35933 -0.03681 lineto
0.61679 -0.02633 lineto
0.86013 0.19065 lineto
0.93495 0.55238 lineto
0.80626 0.8896 lineto
0.53426 1.04452 lineto
0.24624 0.94466 lineto
0.07695 0.63673 lineto
0.10561 0.26483 lineto
0.31881 0.00296 lineto
0.61679 -0.02633 lineto
0.81957 0.15448 lineto
0.92248 0.49209 lineto
0.82771 0.8334 lineto
0.5796 1.0187 lineto
0.29424 0.9613 lineto
0.10516 0.68805 lineto
0.10083 0.32681 lineto
0.28328 0.04661 lineto
0.56713 -0.02145 lineto
0.81957 0.15448 lineto
Mistroke
0.90533 0.43582 lineto
0.8435 0.77651 lineto
0.62095 0.98782 lineto
0.3418 0.97087 lineto
0.13668 0.7336 lineto
0.10156 0.38702 lineto
0.25287 0.09331 lineto
0.51982 -0.01011 lineto
0.7775 0.12516 lineto
0.90533 0.43582 lineto
0.85381 0.71973 lineto
0.65804 0.9526 lineto
0.38832 0.97369 lineto
0.17086 0.77314 lineto
0.10741 0.44478 lineto
0.22765 0.14226 lineto
0.47533 0.00713 lineto
0.73455 0.10262 lineto
0.88402 0.38404 lineto
0.85381 0.71973 lineto
0.69067 0.91379 lineto
0.43328 0.97018 lineto
0.20711 0.80657 lineto
0.11798 0.49951 lineto
0.20761 0.19268 lineto
0.43405 0.02965 lineto
0.69135 0.0867 lineto
0.85911 0.33714 lineto
0.85884 0.66378 lineto
0.69067 0.91379 lineto
0.47618 0.96078 lineto
0.2448 0.83384 lineto
0.13284 0.55069 lineto
0.19267 0.24382 lineto
0.39631 0.05682 lineto
0.64846 0.07719 lineto
0.83115 0.2954 lineto
0.85889 0.60934 lineto
0.7187 0.87212 lineto
0.47618 0.96078 lineto
0.28336 0.85499 lineto
0.1515 0.59788 lineto
0.1827 0.29496 lineto
0.36237 0.08799 lineto
0.60644 0.0738 lineto
0.8007 0.25903 lineto
0.85426 0.55702 lineto
0.74206 0.82832 lineto
0.5166 0.946 lineto
0.28336 0.85499 lineto
Mistroke
0.17348 0.64073 lineto
0.1775 0.34545 lineto
0.33243 0.12248 lineto
0.56576 0.07616 lineto
0.76833 0.22816 lineto
0.84534 0.50735 lineto
0.76076 0.78311 lineto
0.55417 0.92639 lineto
0.32224 0.87016 lineto
0.17348 0.64073 lineto
0.17683 0.39466 lineto
0.30661 0.15965 lineto
0.52687 0.08388 lineto
0.73456 0.20283 lineto
0.8325 0.46082 lineto
0.77486 0.73715 lineto
0.5886 0.90251 lineto
0.36089 0.87953 lineto
0.19827 0.67897 lineto
0.17683 0.39466 lineto
0.28498 0.19881 lineto
0.49016 0.09651 lineto
0.69995 0.183 lineto
0.81618 0.41782 lineto
0.78447 0.69109 lineto
0.61965 0.87495 lineto
0.39884 0.88336 lineto
0.22537 0.7124 lineto
0.1804 0.44205 lineto
0.28498 0.19881 lineto
0.45596 0.11356 lineto
0.66498 0.16859 lineto
0.79681 0.37869 lineto
0.78975 0.64555 lineto
0.64712 0.84431 lineto
0.43565 0.88196 lineto
0.25429 0.74089 lineto
0.1879 0.48711 lineto
0.26755 0.23935 lineto
0.45596 0.11356 lineto
0.63015 0.15942 lineto
0.77484 0.34367 lineto
0.79093 0.60107 lineto
0.67089 0.81118 lineto
0.47089 0.87569 lineto
0.28451 0.7644 lineto
0.19896 0.5294 lineto
0.25427 0.28065 lineto
0.42456 0.13453 lineto
0.63015 0.15942 lineto
Mistroke
0.75072 0.31296 lineto
0.78825 0.55817 lineto
0.6909 0.77616 lineto
0.50422 0.86493 lineto
0.31558 0.78295 lineto
0.21322 0.56857 lineto
0.24505 0.3221 lineto
0.39618 0.15888 lineto
0.59588 0.15527 lineto
0.75072 0.31296 lineto
0.78199 0.5173 lineto
0.70712 0.73983 lineto
0.53534 0.85014 lineto
0.34702 0.79661 lineto
0.23028 0.6043 lineto
0.23975 0.36318 lineto
0.37099 0.18608 lineto
0.5626 0.15587 lineto
0.72492 0.28668 lineto
0.78199 0.5173 lineto
0.7196 0.70274 lineto
0.56397 0.83175 lineto
0.3784 0.80553 lineto
0.24974 0.63635 lineto
0.23817 0.40337 lineto
0.34912 0.2156 lineto
0.53066 0.16091 lineto
0.69786 0.26488 lineto
0.77248 0.47887 lineto
0.7196 0.70274 lineto
0.58991 0.81025 lineto
0.40933 0.8099 lineto
0.27118 0.66455 lineto
0.2401 0.4422 lineto
0.33063 0.24689 lineto
0.50041 0.17002 lineto
0.67 0.24755 lineto
0.76004 0.4432 lineto
0.72841 0.66543 lineto
0.58991 0.81025 lineto
0.43943 0.80996 lineto
0.29421 0.68877 lineto
0.24528 0.47926 lineto
0.31554 0.27945 lineto
0.47211 0.18283 lineto
0.64173 0.23463 lineto
0.74504 0.41059 lineto
0.73368 0.62839 lineto
0.61299 0.78612 lineto
0.43943 0.80996 lineto
Mistroke
0.31841 0.70897 lineto
0.25343 0.51418 lineto
0.30383 0.31275 lineto
0.44601 0.19894 lineto
0.61346 0.226 lineto
0.72782 0.38126 lineto
0.73558 0.59209 lineto
0.63311 0.75983 lineto
0.46835 0.80599 lineto
0.31841 0.70897 lineto
0.26426 0.54664 lineto
0.29543 0.34632 lineto
0.42232 0.2179 lineto
0.58555 0.22149 lineto
0.70876 0.35539 lineto
0.73428 0.55695 lineto
0.65018 0.73187 lineto
0.49581 0.79829 lineto
0.3434 0.72514 lineto
0.26426 0.54664 lineto
0.29023 0.37971 lineto
0.40117 0.23931 lineto
0.55835 0.22089 lineto
0.68822 0.33307 lineto
0.73003 0.52336 lineto
0.6642 0.70272 lineto
0.52154 0.78722 lineto
0.3688 0.73733 lineto
0.27745 0.57639 lineto
0.29023 0.37971 lineto
0.38268 0.26271 lineto
0.53215 0.22396 lineto
0.66658 0.31437 lineto
0.72306 0.49164 lineto
0.67517 0.67283 lineto
0.54532 0.77314 lineto
0.39426 0.74565 lineto
0.29268 0.60322 lineto
0.2881 0.41249 lineto
0.38268 0.26271 lineto
0.50724 0.23042 lineto
0.64417 0.2993 lineto
0.71365 0.4621 lineto
0.68315 0.64263 lineto
0.56696 0.75642 lineto
0.41943 0.75023 lineto
0.30961 0.62696 lineto
0.28887 0.44428 lineto
0.36692 0.28767 lineto
0.50724 0.23042 lineto
Mistroke
0.62135 0.28782 lineto
0.70207 0.43497 lineto
0.68824 0.61254 lineto
0.58633 0.73746 lineto
0.44402 0.75126 lineto
0.32791 0.6475 lineto
0.29232 0.47472 lineto
0.35391 0.31377 lineto
0.48385 0.23996 lineto
0.62135 0.28782 lineto
0.68862 0.41044 lineto
0.69054 0.58294 lineto
0.60331 0.71664 lineto
0.46774 0.74896 lineto
0.34726 0.66479 lineto
0.29825 0.50352 lineto
0.34364 0.3406 lineto
0.4622 0.25226 lineto
0.59843 0.27985 lineto
0.68862 0.41044 lineto
0.69022 0.55419 lineto
0.61785 0.69435 lineto
0.49033 0.74357 lineto
0.36734 0.67882 lineto
0.30642 0.5304 lineto
0.33608 0.36775 lineto
0.44244 0.26698 lineto
0.57573 0.27525 lineto
0.67359 0.38868 lineto
0.69022 0.55419 lineto
0.62991 0.67099 lineto
0.51159 0.73537 lineto
0.38784 0.68961 lineto
0.31658 0.55514 lineto
0.33114 0.39486 lineto
0.42471 0.28378 lineto
0.55351 0.27387 lineto
0.65728 0.36977 lineto
0.68745 0.52661 lineto
0.62991 0.67099 lineto
0.53131 0.72464 lineto
0.40847 0.69724 lineto
0.32845 0.57755 lineto
0.32871 0.42157 lineto
0.40911 0.30229 lineto
0.53205 0.27552 lineto
0.63998 0.35379 lineto
0.68242 0.50047 lineto
0.6395 0.64693 lineto
0.53131 0.72464 lineto
Mistroke
0.42894 0.70181 lineto
0.34179 0.5975 lineto
0.32867 0.44757 lineto
0.39571 0.32217 lineto
0.51156 0.27998 lineto
0.62199 0.34074 lineto
0.67535 0.47602 lineto
0.64665 0.62252 lineto
0.54934 0.71169 lineto
0.42894 0.70181 lineto
0.35631 0.61488 lineto
0.33085 0.47256 lineto
0.38454 0.34307 lineto
0.49225 0.28701 lineto
0.60359 0.33062 lineto
0.66645 0.45348 lineto
0.65144 0.5981 lineto
0.56556 0.69683 lineto
0.44901 0.70345 lineto
0.35631 0.61488 lineto
0.3351 0.49628 lineto
0.37559 0.36465 lineto
0.4743 0.29636 lineto
0.58503 0.32335 lineto
0.65598 0.433 lineto
0.65394 0.574 lineto
0.57987 0.68037 lineto
0.46843 0.70235 lineto
0.37176 0.62964 lineto
0.3351 0.49628 lineto
0.36884 0.38659 lineto
0.45785 0.30774 lineto
0.56658 0.31885 lineto
0.64415 0.41472 lineto
0.65428 0.5505 lineto
0.59222 0.66264 lineto
0.487 0.69869 lineto
0.38787 0.64176 lineto
0.34121 0.5185 lineto
0.36884 0.38659 lineto
0.44301 0.32088 lineto
0.54845 0.317 lineto
0.63122 0.39875 lineto
0.65259 0.52787 lineto
0.60256 0.64395 lineto
0.50454 0.69268 lineto
0.4044 0.65125 lineto
0.34899 0.53905 lineto
0.36424 0.40857 lineto
0.44301 0.32088 lineto
Mistroke
0.53088 0.31765 lineto
0.61743 0.38512 lineto
0.64903 0.50635 lineto
0.6109 0.62461 lineto
0.52088 0.68456 lineto
0.42109 0.65815 lineto
0.35822 0.55775 lineto
0.3617 0.43032 lineto
0.42988 0.3355 lineto
0.53088 0.31765 lineto
0.603 0.37388 lineto
0.64376 0.48614 lineto
0.61725 0.6049 lineto
0.53588 0.67457 lineto
0.43772 0.66256 lineto
0.3687 0.57448 lineto
0.36112 0.45156 lineto
0.41852 0.3513 lineto
0.51405 0.32062 lineto
0.603 0.37388 lineto
0.63697 0.46743 lineto
0.62167 0.5851 lineto
0.54944 0.66296 lineto
0.45408 0.66456 lineto
0.3802 0.58916 lineto
0.36238 0.47205 lineto
0.40895 0.36801 lineto
0.49813 0.32573 lineto
0.58818 0.365 lineto
0.63697 0.46743 lineto
0.62422 0.56549 lineto
0.56148 0.64998 lineto
0.46997 0.66429 lineto
0.39251 0.60173 lineto
0.36535 0.49156 lineto
0.40119 0.38535 lineto
0.48326 0.33278 lineto
0.57317 0.35846 lineto
0.62884 0.45036 lineto
0.62422 0.56549 lineto
0.57194 0.6359 lineto
0.48522 0.66191 lineto
0.40542 0.61215 lineto
0.36988 0.50993 lineto
0.39522 0.40305 lineto
0.46959 0.34154 lineto
0.55818 0.35418 lineto
0.61956 0.43504 lineto
0.62499 0.5463 lineto
0.57194 0.6359 lineto
Mistroke
0.49968 0.65757 lineto
0.41872 0.62045 lineto
0.3758 0.52696 lineto
0.39099 0.42086 lineto
0.45719 0.35179 lineto
0.54342 0.35207 lineto
0.60933 0.42157 lineto
0.62409 0.52776 lineto
0.58078 0.62097 lineto
0.49968 0.65757 lineto
0.43222 0.62663 lineto
0.38296 0.54254 lineto
0.38846 0.43855 lineto
0.44616 0.36331 lineto
0.52905 0.35202 lineto
0.59834 0.40998 lineto
0.62163 0.51006 lineto
0.588 0.60543 lineto
0.51319 0.65147 lineto
0.43222 0.62663 lineto
0.39117 0.55656 lineto
0.38754 0.45588 lineto
0.43654 0.37585 lineto
0.51523 0.3539 lineto
0.5868 0.40032 lineto
0.61775 0.49338 lineto
0.5936 0.58954 lineto
0.52566 0.6438 lineto
0.44571 0.63077 lineto
0.39117 0.55656 lineto
0.38815 0.47266 lineto
0.42838 0.38918 lineto
0.50212 0.35756 lineto
0.57487 0.39259 lineto
0.61259 0.47787 lineto
0.59763 0.57351 lineto
0.53698 0.63475 lineto
0.45904 0.63294 lineto
0.40026 0.56893 lineto
0.38815 0.47266 lineto
0.42167 0.4031 lineto
0.48983 0.36283 lineto
0.56274 0.38675 lineto
0.6063 0.46366 lineto
0.60012 0.55757 lineto
0.54709 0.62455 lineto
0.47203 0.63325 lineto
0.41005 0.5796 lineto
0.39017 0.4887 lineto
0.42167 0.4031 lineto
Mistroke
0.47847 0.36954 lineto
0.55059 0.38276 lineto
0.59904 0.45084 lineto
0.60115 0.54192 lineto
0.55593 0.61338 lineto
0.48454 0.6318 lineto
0.42038 0.58854 lineto
0.39348 0.50385 lineto
0.41642 0.41737 lineto
0.47847 0.36954 lineto
0.53857 0.38056 lineto
0.59097 0.43949 lineto
0.6008 0.52674 lineto
0.56347 0.60147 lineto
0.49644 0.62873 lineto
0.43108 0.59575 lineto
0.39796 0.51797 lineto
0.4126 0.43178 lineto
0.46813 0.37751 lineto
0.53857 0.38056 lineto
0.58223 0.42967 lineto
0.59916 0.5122 lineto
0.56969 0.58902 lineto
0.50761 0.62418 lineto
0.44197 0.60124 lineto
0.40348 0.53093 lineto
0.41016 0.44614 lineto
0.45887 0.38656 lineto
0.52683 0.38005 lineto
0.58223 0.42967 lineto
0.59634 0.49844 lineto
0.5746 0.57621 lineto
0.51796 0.61832 lineto
0.45291 0.60507 lineto
0.4099 0.54265 lineto
0.40905 0.46028 lineto
0.45075 0.39649 lineto
0.5155 0.38114 lineto
0.573 0.4214 lineto
0.59634 0.49844 lineto
0.57822 0.56325 lineto
0.5274 0.61131 lineto
0.46375 0.60728 lineto
0.41707 0.55305 lineto
0.40919 0.474 lineto
0.4438 0.40712 lineto
0.50471 0.38369 lineto
0.56342 0.41469 lineto
0.59245 0.4856 lineto
0.57822 0.56325 lineto
Mistroke
0.53587 0.6033 lineto
0.47436 0.60795 lineto
0.42485 0.56209 lineto
0.4105 0.48718 lineto
0.43803 0.41827 lineto
0.49456 0.3876 lineto
0.55363 0.40952 lineto
0.58761 0.47378 lineto
0.58059 0.55031 lineto
0.53587 0.6033 lineto
0.48461 0.60717 lineto
0.4331 0.56973 lineto
0.41289 0.49966 lineto
0.43344 0.42975 lineto
0.48514 0.39271 lineto
0.54379 0.40587 lineto
0.58195 0.46307 lineto
0.58176 0.53756 lineto
0.54332 0.59447 lineto
0.48461 0.60717 lineto
0.44168 0.57597 lineto
0.41626 0.51134 lineto
0.43002 0.4414 lineto
0.47652 0.39888 lineto
0.53401 0.40368 lineto
0.57559 0.45354 lineto
0.58179 0.52514 lineto
0.54973 0.58498 lineto
0.49439 0.60506 lineto
0.44168 0.57597 lineto
0.4205 0.52211 lineto
0.42773 0.45306 lineto
0.46877 0.40597 lineto
0.52443 0.40288 lineto
0.56866 0.44523 lineto
0.58076 0.51321 lineto
0.55507 0.57501 lineto
0.50362 0.60171 lineto
0.45047 0.58082 lineto
0.4205 0.52211 lineto
0.42652 0.46457 lineto
0.46193 0.41382 lineto
0.51515 0.40339 lineto
0.56129 0.43817 lineto
0.57874 0.50188 lineto
0.55935 0.56471 lineto
0.51219 0.59726 lineto
0.45933 0.5843 lineto
0.42549 0.5319 lineto
0.42652 0.46457 lineto
Mistroke
0.45603 0.42228 lineto
0.50628 0.40513 lineto
0.5536 0.43237 lineto
0.57583 0.49126 lineto
0.56259 0.55424 lineto
0.52005 0.59183 lineto
0.46814 0.58646 lineto
0.43113 0.54063 lineto
0.42635 0.47579 lineto
0.45603 0.42228 lineto
0.49791 0.40799 lineto
0.54571 0.42783 lineto
0.57213 0.48145 lineto
0.56479 0.54374 lineto
0.52714 0.58557 lineto
0.47679 0.58736 lineto
0.4373 0.54827 lineto
0.42715 0.4866 lineto
0.45108 0.4312 lineto
0.49791 0.40799 lineto
0.53774 0.42453 lineto
0.56772 0.47251 lineto
0.56602 0.53336 lineto
0.53342 0.5786 lineto
0.48518 0.58706 lineto
0.44388 0.55478 lineto
0.42884 0.49688 lineto
0.44709 0.44043 lineto
0.4901 0.41186 lineto
0.53774 0.42453 lineto
0.56273 0.46451 lineto
0.5663 0.52322 lineto
0.53885 0.57106 lineto
0.49322 0.58565 lineto
0.45076 0.56016 lineto
0.43135 0.50653 lineto
0.44405 0.44984 lineto
0.48293 0.41662 lineto
0.5298 0.42242 lineto
0.56273 0.46451 lineto
0.56571 0.51343 lineto
0.54343 0.56308 lineto
0.50083 0.58322 lineto
0.45784 0.56441 lineto
0.43458 0.51547 lineto
0.44193 0.45929 lineto
0.47645 0.42216 lineto
0.52199 0.42145 lineto
0.55724 0.4575 lineto
0.56571 0.51343 lineto
Mistroke
0.54714 0.55481 lineto
0.50793 0.57986 lineto
0.465 0.56755 lineto
0.43846 0.52362 lineto
0.44071 0.46865 lineto
0.4707 0.42834 lineto
0.5144 0.42157 lineto
0.55137 0.45149 lineto
0.56429 0.50411 lineto
0.54714 0.55481 lineto
0.51446 0.57569 lineto
0.47216 0.5696 lineto
0.44288 0.53094 lineto
0.44033 0.47781 lineto
0.4657 0.43506 lineto
0.50712 0.4227 lineto
0.54521 0.4465 lineto
0.56214 0.49534 lineto
0.55 0.54636 lineto
0.51446 0.57569 lineto
0.47921 0.57061 lineto
0.44776 0.53739 lineto
0.44076 0.48667 lineto
0.46147 0.44219 lineto
0.50022 0.42476 lineto
0.53886 0.44253 lineto
0.55932 0.4872 lineto
0.55202 0.53786 lineto
0.52038 0.5708 lineto
0.47921 0.57061 lineto
0.453 0.54292 lineto
0.44193 0.49512 lineto
0.45802 0.4496 lineto
0.49376 0.42766 lineto
0.53242 0.43957 lineto
0.55591 0.47976 lineto
0.55324 0.52941 lineto
0.52566 0.56531 lineto
0.48607 0.57064 lineto
0.453 0.54292 lineto
0.44377 0.50309 lineto
0.45534 0.45719 lineto
0.4878 0.43132 lineto
0.52597 0.43759 lineto
0.55199 0.47306 lineto
0.55368 0.52114 lineto
0.53025 0.55932 lineto
0.49267 0.56975 lineto
0.45851 0.54754 lineto
0.44377 0.50309 lineto
Mistroke
0.45341 0.46484 lineto
0.48239 0.43563 lineto
0.51961 0.43654 lineto
0.54766 0.46715 lineto
0.5534 0.51312 lineto
0.53416 0.55296 lineto
0.49893 0.56802 lineto
0.46421 0.55125 lineto
0.44623 0.5105 lineto
0.45341 0.46484 lineto
0.47756 0.4405 lineto
0.51341 0.43639 lineto
0.54298 0.46205 lineto
0.55244 0.50546 lineto
0.53737 0.54632 lineto
0.5048 0.56551 lineto
0.46999 0.55404 lineto
0.44923 0.51729 lineto
0.45221 0.47245 lineto
0.47756 0.4405 lineto
0.50743 0.43707 lineto
0.53805 0.45777 lineto
0.55087 0.49823 lineto
0.53988 0.53951 lineto
0.51023 0.56231 lineto
0.4758 0.55595 lineto
0.45269 0.52341 lineto
0.45172 0.47992 lineto
0.47334 0.44582 lineto
0.50743 0.43707 lineto
0.53295 0.45432 lineto
0.54873 0.49148 lineto
0.54171 0.53263 lineto
0.51517 0.55851 lineto
0.48154 0.55701 lineto
0.45654 0.52884 lineto
0.45188 0.48717 lineto
0.46973 0.45151 lineto
0.50175 0.43853 lineto
0.53295 0.45432 lineto
0.5461 0.48529 lineto
0.54288 0.52577 lineto
0.5196 0.5542 lineto
0.48714 0.55726 lineto
0.4607 0.53353 lineto
0.45265 0.49411 lineto
0.46676 0.45745 lineto
0.49642 0.44069 lineto
0.52775 0.45169 lineto
0.5461 0.48529 lineto
Mistroke
0.54342 0.51902 lineto
0.52348 0.54946 lineto
0.49255 0.55675 lineto
0.46511 0.53749 lineto
0.454 0.50068 lineto
0.46441 0.46356 lineto
0.49147 0.44349 lineto
0.52253 0.44986 lineto
0.54304 0.47969 lineto
0.54342 0.51902 lineto
0.5268 0.54439 lineto
0.4977 0.55554 lineto
0.46968 0.5407 lineto
0.45585 0.50682 lineto
0.46267 0.46975 lineto
0.48696 0.44683 lineto
0.51735 0.4488 lineto
0.53962 0.47472 lineto
0.54335 0.51247 lineto
0.5268 0.54439 lineto
0.50255 0.55368 lineto
0.47435 0.54317 lineto
0.45815 0.51246 lineto
0.46153 0.47593 lineto
0.48291 0.45065 lineto
0.51229 0.44847 lineto
0.53591 0.4704 lineto
0.54273 0.50618 lineto
0.52956 0.53907 lineto
0.50255 0.55368 lineto
0.47905 0.54492 lineto
0.46085 0.51758 lineto
0.46097 0.48202 lineto
0.47935 0.45486 lineto
0.50739 0.44883 lineto
0.53197 0.46674 lineto
0.5416 0.50021 lineto
0.53175 0.53359 lineto
0.50705 0.55124 lineto
0.47905 0.54492 lineto
0.46389 0.52214 lineto
0.46095 0.48794 lineto
0.47629 0.45939 lineto
0.50272 0.44984 lineto
0.52788 0.46376 lineto
0.53999 0.49464 lineto
0.53339 0.52802 lineto
0.51117 0.5483 lineto
0.48372 0.54598 lineto
0.46389 0.52214 lineto
Mistroke
0.46144 0.49364 lineto
0.47373 0.46415 lineto
0.49831 0.45143 lineto
0.52368 0.46144 lineto
0.53797 0.48949 lineto
0.53449 0.52246 lineto
0.51488 0.54492 lineto
0.4883 0.54636 lineto
0.46719 0.52611 lineto
0.46144 0.49364 lineto
0.47168 0.46906 lineto
0.49422 0.45355 lineto
0.51946 0.45977 lineto
0.53559 0.48481 lineto
0.53507 0.51696 lineto
0.51815 0.54118 lineto
0.49273 0.54612 lineto
0.47071 0.52949 lineto
0.4624 0.49905 lineto
0.47168 0.46906 lineto
0.49046 0.45614 lineto
0.51525 0.45873 lineto
0.5329 0.48064 lineto
0.53516 0.51161 lineto
0.52097 0.53714 lineto
0.49696 0.5453 lineto
0.47438 0.53226 lineto
0.46378 0.50413 lineto
0.47014 0.47406 lineto
0.49046 0.45614 lineto
0.51112 0.4583 lineto
0.52996 0.47699 lineto
0.53478 0.50644 lineto
0.52333 0.53288 lineto
0.50096 0.54394 lineto
0.47814 0.53443 lineto
0.46555 0.50882 lineto
0.46908 0.47907 lineto
0.48707 0.45912 lineto
0.51112 0.4583 lineto
0.52682 0.47387 lineto
0.53398 0.50153 lineto
0.52524 0.52848 lineto
0.50469 0.5421 lineto
0.48195 0.53602 lineto
0.46765 0.51308 lineto
0.46849 0.48403 lineto
0.48407 0.46245 lineto
0.50711 0.45844 lineto
0.52682 0.47387 lineto
Mistroke
0.53279 0.49692 lineto
0.5267 0.52399 lineto
0.50812 0.53983 lineto
0.48574 0.53703 lineto
0.47003 0.51691 lineto
0.46835 0.48887 lineto
0.48148 0.46605 lineto
0.50327 0.45911 lineto
0.52353 0.4713 lineto
0.53279 0.49692 lineto
0.52771 0.51948 lineto
0.51121 0.53719 lineto
0.48947 0.5375 lineto
0.47265 0.52026 lineto
0.46863 0.49355 lineto
0.47929 0.46985 lineto
0.49964 0.46026 lineto
0.52016 0.46927 lineto
0.53124 0.49265 lineto
0.52771 0.51948 lineto
0.51396 0.53424 lineto
0.49309 0.53744 lineto
0.47545 0.52313 lineto
0.4693 0.498 lineto
0.47751 0.4738 lineto
0.49625 0.46186 lineto
0.51674 0.46777 lineto
0.5294 0.48876 lineto
0.5283 0.51501 lineto
0.51396 0.53424 lineto
0.49657 0.53691 lineto
0.47839 0.52552 lineto
0.47033 0.50219 lineto
0.47614 0.47783 lineto
0.49312 0.46385 lineto
0.51332 0.46678 lineto
0.52729 0.48526 lineto
0.52848 0.51063 lineto
0.51635 0.53103 lineto
0.49657 0.53691 lineto
0.48142 0.52742 lineto
0.47167 0.50608 lineto
0.47517 0.48189 lineto
0.49029 0.46618 lineto
0.50996 0.46629 lineto
0.52496 0.48218 lineto
0.52828 0.5064 lineto
0.51837 0.52763 lineto
0.49987 0.53593 lineto
0.48142 0.52742 lineto
Mistroke
0.4733 0.50963 lineto
0.47459 0.48592 lineto
0.48777 0.4688 lineto
0.50668 0.46627 lineto
0.52246 0.47953 lineto
0.52773 0.50237 lineto
0.52003 0.52409 lineto
0.50295 0.53455 lineto
0.4845 0.52884 lineto
0.4733 0.50963 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureWidth = 431; pictureHeight = 431; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.13378 1.16475 moveto
0.64367 1.51846 lineto
0.08633 1.39562 lineto
-0.27744 0.85371 lineto
-0.27744 0.14629 lineto
0.08633 -0.39562 lineto
0.64367 -0.51846 lineto
1.13378 -0.16475 lineto
1.32733 0.5 lineto
1.13378 1.16475 lineto
0.72535 1.45951 lineto
0.17922 1.41609 lineto
-0.21681 0.94402 lineto
-0.27744 0.2642 lineto
0.0257 -0.3053 lineto
0.55078 -0.49798 lineto
1.05209 -0.2237 lineto
1.29507 0.38921 lineto
1.16604 1.05396 lineto
0.72535 1.45951 lineto
0.27024 1.42333 lineto
-0.15081 1.0227 lineto
-0.26734 0.3775 lineto
-0.02482 -0.21038 lineto
0.46326 -0.46587 lineto
0.96854 -0.26942 lineto
1.25458 0.28706 lineto
1.18754 0.94317 lineto
0.7988 1.39191 lineto
0.27024 1.42333 lineto
-0.08063 1.08947 lineto
-0.24791 0.48503 lineto
-0.06524 -0.1124 lineto
0.38192 -0.42329 lineto
0.88433 -0.30216 lineto
1.2069 0.19431 lineto
1.19871 0.83382 lineto
0.86359 1.31712 lineto
0.35834 1.41809 lineto
-0.08063 1.08947 lineto
-0.22003 0.58577 lineto
-0.09569 -0.01283 lineto
0.30739 -0.37147 lineto
0.80059 -0.32235 lineto
1.15314 0.11157 lineto
1.20008 0.72723 lineto
0.91944 1.23657 lineto
0.44254 1.40126 lineto
-0.00747 1.14424 lineto
-0.22003 0.58577 lineto
Mistroke
-0.11641 0.08694 lineto
0.24021 -0.3117 lineto
0.71839 -0.33053 lineto
1.09438 0.03925 lineto
1.19226 0.62462 lineto
0.96622 1.15168 lineto
0.52203 1.37381 lineto
0.06753 1.18708 lineto
-0.18461 0.67885 lineto
-0.11641 0.08694 lineto
0.18077 -0.24526 lineto
0.63869 -0.3274 lineto
1.03172 -0.02238 lineto
1.17594 0.52706 lineto
1.00389 1.06384 lineto
0.59606 1.33679 lineto
0.14328 1.2182 lineto
-0.14258 0.76356 lineto
-0.12778 0.18559 lineto
0.18077 -0.24526 lineto
0.56237 -0.31371 lineto
0.96621 -0.07322 lineto
1.15191 0.43548 lineto
1.03256 0.97438 lineto
0.66403 1.2913 lineto
0.21874 1.23797 lineto
-0.09494 0.83933 lineto
-0.13024 0.28192 lineto
0.12935 -0.17345 lineto
0.56237 -0.31371 lineto
0.89891 -0.1133 lineto
1.12096 0.3507 lineto
1.05246 0.88456 lineto
0.72545 1.23848 lineto
0.29296 1.24686 lineto
-0.04266 0.90577 lineto
-0.12436 0.37482 lineto
0.08608 -0.09756 lineto
0.4902 -0.29033 lineto
0.89891 -0.1133 lineto
1.08395 0.27337 lineto
1.06387 0.79558 lineto
0.77995 1.17949 lineto
0.36504 1.24546 lineto
0.01328 0.96262 lineto
-0.11074 0.46331 lineto
0.05101 -0.01883 lineto
0.42285 -0.2582 lineto
0.83079 -0.1428 lineto
1.08395 0.27337 lineto
Mistroke
1.06722 0.70855 lineto
0.82727 1.11551 lineto
0.43419 1.23447 lineto
0.0719 1.00976 lineto
-0.09007 0.54653 lineto
0.02405 0.06153 lineto
0.36088 -0.21831 lineto
0.7628 -0.16204 lineto
1.04176 0.20401 lineto
1.06722 0.70855 lineto
0.86726 1.04768 lineto
0.49971 1.21464 lineto
0.13229 1.04721 lineto
-0.06308 0.62373 lineto
0.00503 0.14236 lineto
0.30474 -0.17167 lineto
0.69581 -0.17142 lineto
0.99526 0.143 lineto
1.06297 0.62446 lineto
0.86726 1.04768 lineto
0.56097 1.18681 lineto
0.19352 1.07511 lineto
-0.03052 0.69431 lineto
-0.00632 0.22259 lineto
0.25479 -0.11933 lineto
0.63063 -0.17146 lineto
0.94535 0.0906 lineto
1.05169 0.54421 lineto
0.89988 0.97714 lineto
0.56097 1.18681 lineto
0.25476 1.09373 lineto
0.00682 0.75778 lineto
-0.01035 0.30121 lineto
0.21127 -0.06234 lineto
0.56799 -0.16277 lineto
0.8929 0.04692 lineto
1.03397 0.46861 lineto
0.92518 0.90499 lineto
0.61745 1.15187 lineto
0.25476 1.09373 lineto
0.04815 0.81377 lineto
-0.00749 0.37731 lineto
0.17433 -0.00175 lineto
0.50854 -0.14603 lineto
0.83875 0.01197 lineto
1.01046 0.39833 lineto
0.94331 0.83226 lineto
0.66874 1.11072 lineto
0.31521 1.10342 lineto
0.04815 0.81377 lineto
Mistroke
0.00178 0.45005 lineto
0.14403 0.06143 lineto
0.45284 -0.12198 lineto
0.78371 -0.01436 lineto
0.98184 0.33394 lineto
0.9545 0.75994 lineto
0.7145 1.06431 lineto
0.37413 1.10464 lineto
0.09266 0.86205 lineto
0.00178 0.45005 lineto
0.12032 0.1262 lineto
0.40137 -0.09142 lineto
0.72857 -0.0323 lineto
0.94882 0.27589 lineto
0.95906 0.68894 lineto
0.7545 1.01358 lineto
0.43086 1.09792 lineto
0.13957 0.90248 lineto
0.01693 0.51872 lineto
0.12032 0.1262 lineto
0.35453 -0.05515 lineto
0.67404 -0.04215 lineto
0.91211 0.22452 lineto
0.95735 0.6201 lineto
0.7886 0.95947 lineto
0.4848 1.08386 lineto
0.18812 0.93505 lineto
0.03737 0.58268 lineto
0.10309 0.19162 lineto
0.35453 -0.05515 lineto
0.62078 -0.04432 lineto
0.87243 0.18008 lineto
0.94981 0.55417 lineto
0.81672 0.90291 lineto
0.53543 1.06313 lineto
0.23757 0.95985 lineto
0.06249 0.64141 lineto
0.09214 0.25679 lineto
0.31262 -0.01402 lineto
0.62078 -0.04432 lineto
0.83049 0.14268 lineto
0.93692 0.49182 lineto
0.8389 0.84479 lineto
0.58232 1.03643 lineto
0.28721 0.97707 lineto
0.09167 0.69448 lineto
0.0872 0.3209 lineto
0.27587 0.03112 lineto
0.56942 -0.03927 lineto
0.83049 0.14268 lineto
Mistroke
0.91918 0.43363 lineto
0.85524 0.78596 lineto
0.62508 1.00449 lineto
0.33639 0.98696 lineto
0.12426 0.74158 lineto
0.08794 0.38316 lineto
0.24443 0.07941 lineto
0.5205 -0.02754 lineto
0.78698 0.11235 lineto
0.91918 0.43363 lineto
0.8659 0.72724 lineto
0.66344 0.96807 lineto
0.38451 0.98988 lineto
0.15962 0.78247 lineto
0.09399 0.4429 lineto
0.21835 0.13004 lineto
0.47449 -0.00971 lineto
0.74257 0.08904 lineto
0.89714 0.38008 lineto
0.8659 0.72724 lineto
0.69718 0.92793 lineto
0.431 0.98624 lineto
0.1971 0.81704 lineto
0.10493 0.49949 lineto
0.19762 0.18218 lineto
0.4318 0.01358 lineto
0.69789 0.07258 lineto
0.87138 0.33158 lineto
0.8711 0.66938 lineto
0.69718 0.92793 lineto
0.47536 0.97652 lineto
0.23608 0.84524 lineto
0.12029 0.55242 lineto
0.18217 0.23507 lineto
0.39277 0.04168 lineto
0.65354 0.06275 lineto
0.84247 0.28841 lineto
0.87115 0.61308 lineto
0.72617 0.88484 lineto
0.47536 0.97652 lineto
0.27596 0.86712 lineto
0.13959 0.60122 lineto
0.17186 0.28796 lineto
0.35767 0.07391 lineto
0.61008 0.05924 lineto
0.81098 0.2508 lineto
0.86637 0.55897 lineto
0.75033 0.83954 lineto
0.51716 0.96124 lineto
0.27596 0.86712 lineto
Mistroke
0.16232 0.64554 lineto
0.16648 0.34017 lineto
0.3267 0.10959 lineto
0.56801 0.06168 lineto
0.77749 0.21887 lineto
0.85714 0.50761 lineto
0.76967 0.79278 lineto
0.55602 0.94096 lineto
0.31616 0.88281 lineto
0.16232 0.64554 lineto
0.16579 0.39106 lineto
0.3 0.14802 lineto
0.52779 0.06967 lineto
0.74258 0.19267 lineto
0.84386 0.45948 lineto
0.78425 0.74525 lineto
0.59163 0.91626 lineto
0.35614 0.8925 lineto
0.18796 0.68508 lineto
0.16579 0.39106 lineto
0.27763 0.18852 lineto
0.48982 0.08272 lineto
0.70678 0.17217 lineto
0.82698 0.41501 lineto
0.79419 0.69762 lineto
0.62374 0.88776 lineto
0.39539 0.89646 lineto
0.21599 0.71965 lineto
0.16948 0.44007 lineto
0.27763 0.18852 lineto
0.45446 0.10036 lineto
0.67062 0.15726 lineto
0.80695 0.37454 lineto
0.79965 0.65052 lineto
0.65214 0.85607 lineto
0.43345 0.89501 lineto
0.24589 0.74912 lineto
0.17723 0.48666 lineto
0.2596 0.23045 lineto
0.45446 0.10036 lineto
0.63459 0.14778 lineto
0.78423 0.33833 lineto
0.80087 0.60452 lineto
0.67673 0.82181 lineto
0.4699 0.88852 lineto
0.27715 0.77344 lineto
0.18868 0.53041 lineto
0.24588 0.27315 lineto
0.42198 0.12204 lineto
0.63459 0.14778 lineto
Mistroke
0.75929 0.30657 lineto
0.79809 0.56016 lineto
0.69742 0.7856 lineto
0.50437 0.8774 lineto
0.30927 0.79262 lineto
0.20342 0.57091 lineto
0.23634 0.31603 lineto
0.39263 0.14722 lineto
0.59916 0.14349 lineto
0.75929 0.30657 lineto
0.79163 0.51789 lineto
0.7142 0.74803 lineto
0.53654 0.8621 lineto
0.34179 0.80675 lineto
0.22106 0.60786 lineto
0.23086 0.35851 lineto
0.36658 0.17536 lineto
0.56474 0.14411 lineto
0.7326 0.27939 lineto
0.79163 0.51789 lineto
0.7271 0.70967 lineto
0.56615 0.84309 lineto
0.37425 0.81597 lineto
0.24119 0.64101 lineto
0.22922 0.40007 lineto
0.34396 0.20588 lineto
0.53171 0.14932 lineto
0.70462 0.25684 lineto
0.78179 0.47814 lineto
0.7271 0.70967 lineto
0.59298 0.82085 lineto
0.40623 0.82049 lineto
0.26336 0.67017 lineto
0.23122 0.44022 lineto
0.32484 0.23825 lineto
0.50042 0.15875 lineto
0.67581 0.23892 lineto
0.76893 0.44126 lineto
0.73622 0.67108 lineto
0.59298 0.82085 lineto
0.43736 0.82055 lineto
0.28717 0.69522 lineto
0.23658 0.47855 lineto
0.30924 0.27191 lineto
0.47116 0.172 lineto
0.64657 0.22556 lineto
0.75341 0.40754 lineto
0.74167 0.63278 lineto
0.61685 0.79589 lineto
0.43736 0.82055 lineto
Mistroke
0.3122 0.71611 lineto
0.24501 0.51466 lineto
0.29713 0.30635 lineto
0.44417 0.18865 lineto
0.61734 0.21663 lineto
0.7356 0.37721 lineto
0.74363 0.59524 lineto
0.63765 0.76871 lineto
0.46727 0.81644 lineto
0.3122 0.71611 lineto
0.25621 0.54824 lineto
0.28844 0.34107 lineto
0.41966 0.20827 lineto
0.58848 0.21197 lineto
0.71589 0.35045 lineto
0.74229 0.5589 lineto
0.65532 0.73979 lineto
0.49567 0.80849 lineto
0.33805 0.73283 lineto
0.25621 0.54824 lineto
0.28307 0.3756 lineto
0.39779 0.2304 lineto
0.56034 0.21135 lineto
0.69466 0.32737 lineto
0.73789 0.52416 lineto
0.66981 0.70965 lineto
0.52228 0.79704 lineto
0.36432 0.74544 lineto
0.26985 0.579 lineto
0.28307 0.3756 lineto
0.37867 0.2546 lineto
0.53325 0.21453 lineto
0.67227 0.30803 lineto
0.73068 0.49136 lineto
0.68116 0.67873 lineto
0.54687 0.78247 lineto
0.39065 0.75404 lineto
0.28559 0.60674 lineto
0.28086 0.4095 lineto
0.37867 0.2546 lineto
0.50749 0.2212 lineto
0.6491 0.29245 lineto
0.72095 0.4608 lineto
0.68941 0.6475 lineto
0.56925 0.76518 lineto
0.41668 0.75878 lineto
0.3031 0.63129 lineto
0.28165 0.44237 lineto
0.36237 0.28042 lineto
0.50749 0.2212 lineto
Mistroke
0.6255 0.28057 lineto
0.70897 0.43274 lineto
0.69467 0.61639 lineto
0.58927 0.74557 lineto
0.44211 0.75985 lineto
0.32203 0.65254 lineto
0.28523 0.47386 lineto
0.34892 0.30741 lineto
0.4833 0.23107 lineto
0.6255 0.28057 lineto
0.69506 0.40738 lineto
0.69705 0.58578 lineto
0.60684 0.72404 lineto
0.46664 0.75747 lineto
0.34204 0.67043 lineto
0.29136 0.50364 lineto
0.3383 0.33515 lineto
0.4609 0.2438 lineto
0.6018 0.27232 lineto
0.69506 0.40738 lineto
0.69672 0.55605 lineto
0.62188 0.701 lineto
0.49 0.7519 lineto
0.36281 0.68493 lineto
0.29981 0.53144 lineto
0.33048 0.36323 lineto
0.44047 0.25902 lineto
0.57832 0.26757 lineto
0.67952 0.38487 lineto
0.69672 0.55605 lineto
0.63435 0.67684 lineto
0.51198 0.74341 lineto
0.38401 0.69609 lineto
0.31031 0.55702 lineto
0.32537 0.39127 lineto
0.42214 0.27639 lineto
0.55534 0.26614 lineto
0.66265 0.36532 lineto
0.69385 0.52752 lineto
0.63435 0.67684 lineto
0.53238 0.73232 lineto
0.40534 0.70398 lineto
0.32259 0.5802 lineto
0.32286 0.41889 lineto
0.40601 0.29554 lineto
0.53314 0.26785 lineto
0.64477 0.34879 lineto
0.68865 0.50048 lineto
0.64427 0.65195 lineto
0.53238 0.73232 lineto
Mistroke
0.42651 0.7087 lineto
0.33638 0.60083 lineto
0.32281 0.44578 lineto
0.39215 0.31609 lineto
0.51195 0.27247 lineto
0.62616 0.3353 lineto
0.68134 0.4752 lineto
0.65166 0.62671 lineto
0.55103 0.71892 lineto
0.42651 0.7087 lineto
0.3514 0.61881 lineto
0.32507 0.47162 lineto
0.38059 0.33771 lineto
0.49199 0.27974 lineto
0.60713 0.32483 lineto
0.67214 0.45189 lineto
0.65661 0.60146 lineto
0.5678 0.70355 lineto
0.44726 0.71041 lineto
0.3514 0.61881 lineto
0.32946 0.49615 lineto
0.37134 0.36003 lineto
0.47342 0.2894 lineto
0.58794 0.31731 lineto
0.66131 0.43071 lineto
0.6592 0.57653 lineto
0.5826 0.68654 lineto
0.46735 0.70926 lineto
0.36738 0.63407 lineto
0.32946 0.49615 lineto
0.36436 0.38271 lineto
0.45641 0.30117 lineto
0.56885 0.31266 lineto
0.64908 0.41181 lineto
0.65955 0.55222 lineto
0.59537 0.6682 lineto
0.48656 0.70548 lineto
0.38404 0.64661 lineto
0.33578 0.51914 lineto
0.36436 0.38271 lineto
0.44107 0.31476 lineto
0.55011 0.31075 lineto
0.63571 0.39529 lineto
0.6578 0.52882 lineto
0.60606 0.64887 lineto
0.5047 0.69926 lineto
0.40113 0.65642 lineto
0.34383 0.54038 lineto
0.3596 0.40545 lineto
0.44107 0.31476 lineto
Mistroke
0.53194 0.31142 lineto
0.62144 0.3812 lineto
0.65412 0.50657 lineto
0.61469 0.62886 lineto
0.52159 0.69087 lineto
0.41839 0.66356 lineto
0.35338 0.55972 lineto
0.35697 0.42794 lineto
0.42749 0.32988 lineto
0.53194 0.31142 lineto
0.60652 0.36957 lineto
0.64867 0.48567 lineto
0.62126 0.60848 lineto
0.53711 0.68053 lineto
0.43559 0.66811 lineto
0.36421 0.57703 lineto
0.35637 0.4499 lineto
0.41574 0.34622 lineto
0.51453 0.31449 lineto
0.60652 0.36957 lineto
0.64165 0.46632 lineto
0.62583 0.58801 lineto
0.55113 0.66852 lineto
0.45251 0.67018 lineto
0.37611 0.59221 lineto
0.35768 0.47109 lineto
0.40584 0.3635 lineto
0.49806 0.31978 lineto
0.59119 0.36039 lineto
0.64165 0.46632 lineto
0.62847 0.56773 lineto
0.56358 0.6551 lineto
0.46895 0.6699 lineto
0.38884 0.6052 lineto
0.36075 0.49128 lineto
0.39781 0.38143 lineto
0.48269 0.32707 lineto
0.57567 0.35362 lineto
0.63324 0.44866 lineto
0.62847 0.56773 lineto
0.5744 0.64054 lineto
0.48472 0.66744 lineto
0.40219 0.61599 lineto
0.36543 0.51026 lineto
0.39164 0.39974 lineto
0.46855 0.33613 lineto
0.56017 0.34919 lineto
0.62364 0.43282 lineto
0.62926 0.54789 lineto
0.5744 0.64054 lineto
Mistroke
0.49967 0.66295 lineto
0.41595 0.62456 lineto
0.37156 0.52788 lineto
0.38727 0.41816 lineto
0.45573 0.34673 lineto
0.5449 0.34702 lineto
0.61307 0.41889 lineto
0.62833 0.52871 lineto
0.58354 0.6251 lineto
0.49967 0.66295 lineto
0.4299 0.63096 lineto
0.37896 0.544 lineto
0.38465 0.43645 lineto
0.44432 0.35863 lineto
0.53004 0.34697 lineto
0.60171 0.40691 lineto
0.62578 0.5104 lineto
0.591 0.60903 lineto
0.51364 0.65665 lineto
0.4299 0.63096 lineto
0.38745 0.55849 lineto
0.3837 0.45437 lineto
0.43437 0.3716 lineto
0.51575 0.34891 lineto
0.58976 0.39692 lineto
0.62177 0.49316 lineto
0.5968 0.5926 lineto
0.52654 0.64871 lineto
0.44386 0.63524 lineto
0.38745 0.55849 lineto
0.38433 0.47173 lineto
0.42593 0.3854 lineto
0.50219 0.35269 lineto
0.57743 0.38892 lineto
0.61643 0.47712 lineto
0.60096 0.57602 lineto
0.53825 0.63936 lineto
0.45764 0.63749 lineto
0.39685 0.57128 lineto
0.38433 0.47173 lineto
0.41899 0.39979 lineto
0.48948 0.35815 lineto
0.56489 0.38288 lineto
0.60993 0.46242 lineto
0.60354 0.55954 lineto
0.5487 0.6288 lineto
0.47107 0.6378 lineto
0.40698 0.58232 lineto
0.38641 0.48832 lineto
0.41899 0.39979 lineto
Mistroke
0.47773 0.36509 lineto
0.55232 0.37876 lineto
0.60243 0.44916 lineto
0.60461 0.54335 lineto
0.55784 0.61726 lineto
0.48401 0.6363 lineto
0.41766 0.59156 lineto
0.38984 0.50398 lineto
0.41356 0.41454 lineto
0.47773 0.36509 lineto
0.53989 0.37648 lineto
0.59407 0.43743 lineto
0.60424 0.52765 lineto
0.56563 0.60494 lineto
0.49632 0.63313 lineto
0.42872 0.59902 lineto
0.39448 0.51858 lineto
0.40961 0.42945 lineto
0.46704 0.37333 lineto
0.53989 0.37648 lineto
0.58504 0.42727 lineto
0.60255 0.51261 lineto
0.57207 0.59206 lineto
0.50787 0.62843 lineto
0.43999 0.6047 lineto
0.40019 0.53199 lineto
0.40709 0.4443 lineto
0.45747 0.38268 lineto
0.52775 0.37595 lineto
0.58504 0.42727 lineto
0.59963 0.49839 lineto
0.57715 0.57882 lineto
0.51857 0.62237 lineto
0.4513 0.60866 lineto
0.40682 0.54411 lineto
0.40594 0.45892 lineto
0.44907 0.39295 lineto
0.51603 0.37707 lineto
0.57549 0.41872 lineto
0.59963 0.49839 lineto
0.5809 0.56541 lineto
0.52833 0.61511 lineto
0.46251 0.61094 lineto
0.41423 0.55487 lineto
0.40608 0.47312 lineto
0.44188 0.40395 lineto
0.50487 0.37972 lineto
0.56558 0.41178 lineto
0.59561 0.48511 lineto
0.5809 0.56541 lineto
Mistroke
0.53709 0.60683 lineto
0.47348 0.61164 lineto
0.42228 0.56421 lineto
0.40744 0.48674 lineto
0.43591 0.41547 lineto
0.49437 0.38376 lineto
0.55546 0.40643 lineto
0.5906 0.47289 lineto
0.58335 0.55203 lineto
0.53709 0.60683 lineto
0.48408 0.61084 lineto
0.43081 0.57212 lineto
0.40992 0.49965 lineto
0.43117 0.42735 lineto
0.48463 0.38904 lineto
0.54528 0.40265 lineto
0.58475 0.46181 lineto
0.58456 0.53884 lineto
0.5448 0.59769 lineto
0.48408 0.61084 lineto
0.43969 0.57857 lineto
0.4134 0.51173 lineto
0.42763 0.4394 lineto
0.47572 0.39543 lineto
0.53517 0.40039 lineto
0.57817 0.45195 lineto
0.58459 0.526 lineto
0.55143 0.58788 lineto
0.4942 0.60864 lineto
0.43969 0.57857 lineto
0.41778 0.52287 lineto
0.42526 0.45146 lineto
0.4677 0.40276 lineto
0.52527 0.39956 lineto
0.571 0.44336 lineto
0.58352 0.51366 lineto
0.55695 0.57757 lineto
0.50374 0.60518 lineto
0.44878 0.58358 lineto
0.41778 0.52287 lineto
0.42401 0.46336 lineto
0.46063 0.41087 lineto
0.51567 0.40009 lineto
0.56338 0.43606 lineto
0.58143 0.50194 lineto
0.56138 0.56692 lineto
0.51261 0.60058 lineto
0.45794 0.58718 lineto
0.42295 0.53299 lineto
0.42401 0.46336 lineto
Mistroke
0.45453 0.41962 lineto
0.5065 0.40189 lineto
0.55543 0.43006 lineto
0.57842 0.49096 lineto
0.56472 0.55609 lineto
0.52074 0.59497 lineto
0.46705 0.58942 lineto
0.42878 0.54202 lineto
0.42383 0.47496 lineto
0.45453 0.41962 lineto
0.49784 0.40484 lineto
0.54727 0.42537 lineto
0.57459 0.48081 lineto
0.56701 0.54524 lineto
0.52807 0.58849 lineto
0.476 0.59034 lineto
0.43516 0.54992 lineto
0.42466 0.48614 lineto
0.44941 0.42885 lineto
0.49784 0.40484 lineto
0.53903 0.42195 lineto
0.57004 0.47157 lineto
0.56827 0.5345 lineto
0.53456 0.58128 lineto
0.48468 0.59003 lineto
0.44196 0.55666 lineto
0.42641 0.49677 lineto
0.44529 0.43839 lineto
0.48977 0.40885 lineto
0.53903 0.42195 lineto
0.56487 0.4633 lineto
0.56857 0.52401 lineto
0.54018 0.57348 lineto
0.49299 0.58857 lineto
0.44908 0.56222 lineto
0.429 0.50675 lineto
0.44214 0.44812 lineto
0.48235 0.41377 lineto
0.53082 0.41976 lineto
0.56487 0.4633 lineto
0.56795 0.51389 lineto
0.54491 0.56524 lineto
0.50085 0.58606 lineto
0.4564 0.56661 lineto
0.43235 0.516 lineto
0.43995 0.4579 lineto
0.47565 0.4195 lineto
0.52274 0.41877 lineto
0.5592 0.45605 lineto
0.56795 0.51389 lineto
Mistroke
0.54875 0.55668 lineto
0.5082 0.58259 lineto
0.46381 0.56985 lineto
0.43636 0.52443 lineto
0.43868 0.46758 lineto
0.4697 0.4259 lineto
0.5149 0.41889 lineto
0.55312 0.44983 lineto
0.56649 0.50425 lineto
0.54875 0.55668 lineto
0.51496 0.57827 lineto
0.47121 0.57198 lineto
0.44093 0.532 lineto
0.43829 0.47705 lineto
0.46453 0.43284 lineto
0.50736 0.42005 lineto
0.54675 0.44467 lineto
0.56426 0.49518 lineto
0.55171 0.54794 lineto
0.51496 0.57827 lineto
0.4785 0.57303 lineto
0.44598 0.53866 lineto
0.43873 0.48621 lineto
0.46016 0.44021 lineto
0.50022 0.42219 lineto
0.54019 0.44057 lineto
0.56134 0.48676 lineto
0.5538 0.53915 lineto
0.52108 0.57322 lineto
0.4785 0.57303 lineto
0.4514 0.54439 lineto
0.43994 0.49495 lineto
0.45659 0.44788 lineto
0.49355 0.42519 lineto
0.53353 0.43751 lineto
0.55782 0.47906 lineto
0.55506 0.53042 lineto
0.52653 0.56754 lineto
0.4856 0.57306 lineto
0.4514 0.54439 lineto
0.44185 0.50319 lineto
0.45381 0.45572 lineto
0.48739 0.42897 lineto
0.52686 0.43545 lineto
0.55377 0.47214 lineto
0.55552 0.52186 lineto
0.53129 0.56135 lineto
0.49242 0.57214 lineto
0.4571 0.54917 lineto
0.44185 0.50319 lineto
Mistroke
0.45182 0.46364 lineto
0.48179 0.43343 lineto
0.52028 0.43437 lineto
0.54928 0.46602 lineto
0.55523 0.51357 lineto
0.53533 0.55477 lineto
0.4989 0.57034 lineto
0.46298 0.553 lineto
0.44439 0.51086 lineto
0.45182 0.46364 lineto
0.4768 0.43846 lineto
0.51387 0.43422 lineto
0.54445 0.46075 lineto
0.55424 0.50565 lineto
0.53864 0.5479 lineto
0.50497 0.56774 lineto
0.46897 0.55589 lineto
0.44749 0.51788 lineto
0.45058 0.47151 lineto
0.4768 0.43846 lineto
0.50769 0.43492 lineto
0.53935 0.45633 lineto
0.5526 0.49816 lineto
0.54124 0.54086 lineto
0.51058 0.56444 lineto
0.47497 0.55786 lineto
0.45107 0.52421 lineto
0.45007 0.47923 lineto
0.47243 0.44397 lineto
0.50769 0.43492 lineto
0.53408 0.45276 lineto
0.5504 0.49119 lineto
0.54314 0.53374 lineto
0.51569 0.56051 lineto
0.4809 0.55896 lineto
0.45505 0.52982 lineto
0.45023 0.48673 lineto
0.4687 0.44985 lineto
0.50181 0.43643 lineto
0.53408 0.45276 lineto
0.54768 0.48479 lineto
0.54435 0.52665 lineto
0.52026 0.55605 lineto
0.4867 0.55922 lineto
0.45936 0.53468 lineto
0.45104 0.49391 lineto
0.46562 0.456 lineto
0.49629 0.43867 lineto
0.5287 0.45004 lineto
0.54768 0.48479 lineto
Mistroke
0.5449 0.51968 lineto
0.52428 0.55115 lineto
0.4923 0.55869 lineto
0.46392 0.53877 lineto
0.45242 0.50071 lineto
0.46319 0.46232 lineto
0.49118 0.44156 lineto
0.5233 0.44814 lineto
0.54451 0.479 lineto
0.5449 0.51968 lineto
0.52772 0.5459 lineto
0.49763 0.55743 lineto
0.46865 0.54209 lineto
0.45434 0.50705 lineto
0.4614 0.46871 lineto
0.48652 0.44502 lineto
0.51794 0.44705 lineto
0.54098 0.47385 lineto
0.54484 0.5129 lineto
0.52772 0.5459 lineto
0.50264 0.55551 lineto
0.47348 0.54465 lineto
0.45672 0.51289 lineto
0.46022 0.4751 lineto
0.48233 0.44897 lineto
0.51271 0.44671 lineto
0.53714 0.46939 lineto
0.54419 0.50639 lineto
0.53057 0.5404 lineto
0.50264 0.55551 lineto
0.47834 0.54646 lineto
0.45952 0.51818 lineto
0.45964 0.4814 lineto
0.47864 0.45332 lineto
0.50764 0.44708 lineto
0.53307 0.46561 lineto
0.54302 0.50022 lineto
0.53284 0.53473 lineto
0.5073 0.55299 lineto
0.47834 0.54646 lineto
0.46265 0.5229 lineto
0.45962 0.48753 lineto
0.47548 0.458 lineto
0.50281 0.44812 lineto
0.52883 0.46252 lineto
0.54136 0.49445 lineto
0.53454 0.52898 lineto
0.51155 0.54995 lineto
0.48316 0.54755 lineto
0.46265 0.5229 lineto
Mistroke
0.46012 0.49343 lineto
0.47283 0.46292 lineto
0.49826 0.44977 lineto
0.52449 0.46012 lineto
0.53927 0.48913 lineto
0.53567 0.52323 lineto
0.51538 0.54645 lineto
0.4879 0.54795 lineto
0.46607 0.527 lineto
0.46012 0.49343 lineto
0.47072 0.46801 lineto
0.49402 0.45196 lineto
0.52012 0.45839 lineto
0.53681 0.48429 lineto
0.53627 0.51754 lineto
0.51877 0.54258 lineto
0.49248 0.5477 lineto
0.46971 0.53049 lineto
0.46111 0.49902 lineto
0.47072 0.46801 lineto
0.49013 0.45464 lineto
0.51577 0.45732 lineto
0.53403 0.47998 lineto
0.53636 0.512 lineto
0.52168 0.53841 lineto
0.49686 0.54685 lineto
0.4735 0.53336 lineto
0.46255 0.50427 lineto
0.46912 0.47318 lineto
0.49013 0.45464 lineto
0.5115 0.45687 lineto
0.53098 0.4762 lineto
0.53597 0.50666 lineto
0.52413 0.53401 lineto
0.501 0.54544 lineto
0.4774 0.53561 lineto
0.46437 0.50912 lineto
0.46802 0.47836 lineto
0.48663 0.45773 lineto
0.5115 0.45687 lineto
0.52774 0.47298 lineto
0.53514 0.50159 lineto
0.5261 0.52945 lineto
0.50485 0.54353 lineto
0.48133 0.53725 lineto
0.46654 0.51353 lineto
0.46741 0.48348 lineto
0.48353 0.46117 lineto
0.50735 0.45702 lineto
0.52774 0.47298 lineto
Mistroke
0.53391 0.49682 lineto
0.52761 0.52481 lineto
0.50839 0.54119 lineto
0.48525 0.5383 lineto
0.46901 0.51748 lineto
0.46727 0.48849 lineto
0.48084 0.46489 lineto
0.50338 0.45771 lineto
0.52434 0.47032 lineto
0.53391 0.49682 lineto
0.52866 0.52014 lineto
0.5116 0.53846 lineto
0.48911 0.53878 lineto
0.47172 0.52095 lineto
0.46756 0.49332 lineto
0.47858 0.46882 lineto
0.49963 0.4589 lineto
0.52085 0.46822 lineto
0.53231 0.4924 lineto
0.52866 0.52014 lineto
0.51444 0.5354 lineto
0.49286 0.53872 lineto
0.47461 0.52392 lineto
0.46825 0.49793 lineto
0.47674 0.4729 lineto
0.49612 0.46056 lineto
0.51731 0.46667 lineto
0.5304 0.48837 lineto
0.52927 0.51552 lineto
0.51444 0.5354 lineto
0.49645 0.53817 lineto
0.47765 0.52639 lineto
0.46931 0.50226 lineto
0.47533 0.47707 lineto
0.49289 0.46261 lineto
0.51378 0.46565 lineto
0.52822 0.48475 lineto
0.52946 0.51099 lineto
0.51691 0.53209 lineto
0.49645 0.53817 lineto
0.48079 0.52835 lineto
0.4707 0.50628 lineto
0.47433 0.48127 lineto
0.48996 0.46502 lineto
0.5103 0.46514 lineto
0.52581 0.48157 lineto
0.52925 0.50662 lineto
0.519 0.52857 lineto
0.49986 0.53716 lineto
0.48079 0.52835 lineto
Mistroke
0.47238 0.50996 lineto
0.47372 0.48544 lineto
0.48736 0.46773 lineto
0.50691 0.46512 lineto
0.52323 0.47883 lineto
0.52868 0.50245 lineto
0.52071 0.52492 lineto
0.50305 0.53573 lineto
0.48397 0.52982 lineto
0.47238 0.50996 lineto
0.4735 0.48953 lineto
0.48508 0.47068 lineto
0.50365 0.46556 lineto
0.52051 0.47655 lineto
0.52777 0.49851 lineto
0.52204 0.52117 lineto
0.506 0.53393 lineto
0.48715 0.53081 lineto
0.47431 0.51327 lineto
0.4735 0.48953 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureWidth = 431; pictureHeight = 431; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.15543 1.18746 moveto
0.64857 1.55326 lineto
0.0722 1.42622 lineto
-0.304 0.86579 lineto
-0.304 0.13421 lineto
0.0722 -0.42622 lineto
0.64857 -0.55326 lineto
1.15543 -0.18746 lineto
1.3556 0.5 lineto
1.15543 1.18746 lineto
0.73305 1.49229 lineto
0.16826 1.44739 lineto
-0.2413 0.9592 lineto
-0.304 0.25614 lineto
0.0095 -0.33281 lineto
0.55251 -0.53208 lineto
1.07095 -0.24843 lineto
1.32224 0.38542 lineto
1.18879 1.07289 lineto
0.73305 1.49229 lineto
0.26239 1.45487 lineto
-0.17304 1.04056 lineto
-0.29355 0.37331 lineto
-0.04275 -0.23466 lineto
0.46201 -0.49887 lineto
0.98455 -0.29571 lineto
1.28036 0.27978 lineto
1.21103 0.95831 lineto
0.80901 1.42239 lineto
0.26239 1.45487 lineto
-0.10047 1.10961 lineto
-0.27347 0.48452 lineto
-0.08455 -0.13333 lineto
0.37788 -0.45484 lineto
0.89746 -0.32957 lineto
1.23106 0.18387 lineto
1.22259 0.84522 lineto
0.87601 1.34504 lineto
0.35349 1.44946 lineto
-0.10047 1.10961 lineto
-0.24464 0.5887 lineto
-0.11604 -0.03035 lineto
0.30081 -0.40125 lineto
0.81086 -0.35044 lineto
1.17546 0.09829 lineto
1.224 0.735 lineto
0.93377 1.26174 lineto
0.44058 1.43206 lineto
-0.02481 1.16626 lineto
-0.24464 0.5887 lineto
Mistroke
-0.13747 0.07282 lineto
0.23133 -0.33943 lineto
0.72585 -0.35891 lineto
1.11469 0.0235 lineto
1.21591 0.62888 lineto
0.98215 1.17395 lineto
0.52278 1.40367 lineto
0.05276 1.21056 lineto
-0.208 0.68496 lineto
-0.13747 0.07282 lineto
0.16987 -0.27072 lineto
0.64343 -0.35567 lineto
1.04989 -0.04023 lineto
1.19904 0.52798 lineto
1.02111 1.0831 lineto
0.59934 1.36538 lineto
0.13109 1.24274 lineto
-0.16454 0.77256 lineto
-0.14923 0.17485 lineto
0.16987 -0.27072 lineto
0.56451 -0.34151 lineto
0.98214 -0.0928 lineto
1.17418 0.43328 lineto
1.05076 0.99058 lineto
0.66964 1.31834 lineto
0.20913 1.26318 lineto
-0.11527 0.85093 lineto
-0.15178 0.27447 lineto
0.11668 -0.19646 lineto
0.56451 -0.34151 lineto
0.91254 -0.13425 lineto
1.14217 0.3456 lineto
1.07133 0.8977 lineto
0.73316 1.26371 lineto
0.28588 1.27237 lineto
-0.0612 0.91963 lineto
-0.14569 0.37054 lineto
0.07194 -0.11797 lineto
0.48987 -0.31733 lineto
0.91254 -0.13425 lineto
1.1039 0.26562 lineto
1.08314 0.80568 lineto
0.78952 1.20271 lineto
0.36043 1.27093 lineto
-0.00335 0.97842 lineto
-0.13161 0.46206 lineto
0.03567 -0.03655 lineto
0.42021 -0.28411 lineto
0.84209 -0.16477 lineto
1.1039 0.26562 lineto
Mistroke
1.0866 0.71567 lineto
0.83846 1.13654 lineto
0.43194 1.25956 lineto
0.05728 1.02718 lineto
-0.11023 0.54812 lineto
0.00779 0.04655 lineto
0.35612 -0.24285 lineto
0.77178 -0.18466 lineto
1.06027 0.19389 lineto
1.0866 0.71567 lineto
0.87981 1.06639 lineto
0.4997 1.23906 lineto
0.11972 1.06591 lineto
-0.08232 0.62796 lineto
-0.01188 0.13014 lineto
0.29807 -0.19462 lineto
0.7025 -0.19436 lineto
1.01219 0.1308 lineto
1.08221 0.62871 lineto
0.87981 1.06639 lineto
0.56305 1.21028 lineto
0.18305 1.09476 lineto
-0.04864 0.70095 lineto
-0.02362 0.21311 lineto
0.24641 -0.14049 lineto
0.6351 -0.1944 lineto
0.96057 0.07661 lineto
1.07054 0.54572 lineto
0.91355 0.99345 lineto
0.56305 1.21028 lineto
0.24638 1.11402 lineto
-0.01003 0.76659 lineto
-0.02779 0.29442 lineto
0.2014 -0.08156 lineto
0.57032 -0.18541 lineto
0.90633 0.03144 lineto
1.05221 0.46754 lineto
0.93971 0.91883 lineto
0.62147 1.17414 lineto
0.24638 1.11402 lineto
0.03271 0.82449 lineto
-0.02483 0.37311 lineto
0.1632 -0.01889 lineto
0.50883 -0.16811 lineto
0.85032 -0.0047 lineto
1.0279 0.39486 lineto
0.95846 0.84361 lineto
0.67451 1.13159 lineto
0.3089 1.12404 lineto
0.03271 0.82449 lineto
Mistroke
-0.01524 0.44834 lineto
0.13187 0.04644 lineto
0.45123 -0.14324 lineto
0.79341 -0.03194 lineto
0.9983 0.32826 lineto
0.97003 0.76882 lineto
0.72183 1.08359 lineto
0.36983 1.1253 lineto
0.07874 0.87442 lineto
-0.01524 0.44834 lineto
0.10735 0.11342 lineto
0.398 -0.11162 lineto
0.73638 -0.05049 lineto
0.96415 0.26823 lineto
0.97475 0.69539 lineto
0.7632 1.03113 lineto
0.4285 1.11835 lineto
0.12725 0.91623 lineto
0.00042 0.51936 lineto
0.10735 0.11342 lineto
0.34956 -0.07412 lineto
0.67998 -0.06068 lineto
0.92619 0.21511 lineto
0.97298 0.6242 lineto
0.79846 0.97517 lineto
0.48428 1.10381 lineto
0.17746 0.94992 lineto
0.02156 0.5855 lineto
0.08953 0.18108 lineto
0.34956 -0.07412 lineto
0.62491 -0.06292 lineto
0.88516 0.16915 lineto
0.96518 0.55602 lineto
0.82754 0.91668 lineto
0.53664 1.08237 lineto
0.2286 0.97557 lineto
0.04754 0.64624 lineto
0.0782 0.24848 lineto
0.30622 -0.03158 lineto
0.62491 -0.06292 lineto
0.84178 0.13047 lineto
0.95184 0.49154 lineto
0.85048 0.85657 lineto
0.58513 1.05476 lineto
0.27994 0.99337 lineto
0.07772 0.70113 lineto
0.07309 0.31478 lineto
0.26822 0.01509 lineto
0.5718 -0.05769 lineto
0.84178 0.13047 lineto
Mistroke
0.9335 0.43136 lineto
0.86738 0.79573 lineto
0.62935 1.02172 lineto
0.3308 1.0036 lineto
0.11142 0.74983 lineto
0.07386 0.37917 lineto
0.23569 0.06504 lineto
0.5212 -0.04556 lineto
0.79678 0.09911 lineto
0.9335 0.43136 lineto
0.8784 0.735 lineto
0.66902 0.98406 lineto
0.38056 1.00662 lineto
0.14799 0.79213 lineto
0.08012 0.44095 lineto
0.20872 0.1174 lineto
0.47362 -0.02713 lineto
0.75085 0.075 lineto
0.91071 0.37599 lineto
0.8784 0.735 lineto
0.70392 0.94255 lineto
0.42864 1.00286 lineto
0.18675 0.82788 lineto
0.09143 0.49948 lineto
0.18729 0.17132 lineto
0.42947 -0.00304 lineto
0.70465 0.05798 lineto
0.88407 0.32582 lineto
0.88378 0.67517 lineto
0.70392 0.94255 lineto
0.47452 0.99281 lineto
0.22706 0.85704 lineto
0.10732 0.55421 lineto
0.17131 0.22601 lineto
0.3891 0.02602 lineto
0.65878 0.04781 lineto
0.85417 0.28118 lineto
0.88383 0.61694 lineto
0.7339 0.89799 lineto
0.47452 0.99281 lineto
0.26831 0.87967 lineto
0.12728 0.60468 lineto
0.16065 0.28071 lineto
0.35281 0.05935 lineto
0.61384 0.04418 lineto
0.8216 0.24228 lineto
0.87889 0.56098 lineto
0.75889 0.85114 lineto
0.51775 0.977 lineto
0.26831 0.87967 lineto
Mistroke
0.15078 0.65051 lineto
0.15509 0.33471 lineto
0.32078 0.09625 lineto
0.57033 0.0467 lineto
0.78698 0.20927 lineto
0.86934 0.50786 lineto
0.77889 0.80278 lineto
0.55794 0.95603 lineto
0.30988 0.89589 lineto
0.15078 0.65051 lineto
0.15437 0.38734 lineto
0.29316 0.13599 lineto
0.52874 0.05496 lineto
0.75087 0.18217 lineto
0.85561 0.4581 lineto
0.79396 0.75363 lineto
0.59476 0.93049 lineto
0.35122 0.90591 lineto
0.1773 0.69141 lineto
0.15437 0.38734 lineto
0.27003 0.17788 lineto
0.48948 0.06847 lineto
0.71385 0.16097 lineto
0.83816 0.41211 lineto
0.80424 0.70438 lineto
0.62796 0.90101 lineto
0.39181 0.91001 lineto
0.20629 0.72716 lineto
0.15819 0.43802 lineto
0.27003 0.17788 lineto
0.4529 0.0867 lineto
0.67645 0.14555 lineto
0.81744 0.37025 lineto
0.80989 0.65566 lineto
0.65734 0.86824 lineto
0.43117 0.90851 lineto
0.23721 0.75763 lineto
0.16621 0.48621 lineto
0.25139 0.22124 lineto
0.4529 0.0867 lineto
0.63919 0.13574 lineto
0.79394 0.3328 lineto
0.81115 0.6081 lineto
0.68277 0.83281 lineto
0.46887 0.9018 lineto
0.26953 0.78278 lineto
0.17804 0.53145 lineto
0.23719 0.2654 lineto
0.41932 0.10912 lineto
0.63919 0.13574 lineto
Mistroke
0.76815 0.29996 lineto
0.80828 0.56221 lineto
0.70416 0.79536 lineto
0.50452 0.8903 lineto
0.30276 0.80262 lineto
0.19329 0.57334 lineto
0.22733 0.30974 lineto
0.38896 0.13517 lineto
0.60255 0.13131 lineto
0.76815 0.29996 lineto
0.80159 0.51851 lineto
0.72152 0.7565 lineto
0.53779 0.87448 lineto
0.33638 0.81723 lineto
0.21153 0.61155 lineto
0.22166 0.35367 lineto
0.36203 0.16427 lineto
0.56695 0.13195 lineto
0.74055 0.27185 lineto
0.80159 0.51851 lineto
0.73486 0.71683 lineto
0.56841 0.85481 lineto
0.36995 0.82677 lineto
0.23234 0.64583 lineto
0.21997 0.39665 lineto
0.33863 0.19583 lineto
0.5328 0.13734 lineto
0.71162 0.24854 lineto
0.79142 0.4774 lineto
0.73486 0.71683 lineto
0.59615 0.83182 lineto
0.40303 0.83144 lineto
0.25528 0.67599 lineto
0.22203 0.43818 lineto
0.31885 0.2293 lineto
0.50044 0.14709 lineto
0.68181 0.23 lineto
0.77812 0.43925 lineto
0.74429 0.67693 lineto
0.59615 0.83182 lineto
0.43522 0.83151 lineto
0.2799 0.7019 lineto
0.22757 0.47782 lineto
0.30272 0.26412 lineto
0.47017 0.16079 lineto
0.65158 0.21618 lineto
0.76207 0.40438 lineto
0.74993 0.63732 lineto
0.62084 0.806 lineto
0.43522 0.83151 lineto
Mistroke
0.30579 0.7235 lineto
0.2363 0.51516 lineto
0.29019 0.29973 lineto
0.44226 0.17801 lineto
0.62135 0.20695 lineto
0.74365 0.37301 lineto
0.75195 0.59849 lineto
0.64236 0.77789 lineto
0.46615 0.82726 lineto
0.30579 0.7235 lineto
0.24788 0.54988 lineto
0.28121 0.33564 lineto
0.41692 0.1983 lineto
0.5915 0.20213 lineto
0.72327 0.34533 lineto
0.75057 0.56091 lineto
0.66062 0.74799 lineto
0.49552 0.81903 lineto
0.33252 0.74079 lineto
0.24788 0.54988 lineto
0.27566 0.37135 lineto
0.3943 0.22119 lineto
0.5624 0.20149 lineto
0.70131 0.32147 lineto
0.74602 0.52498 lineto
0.67561 0.71681 lineto
0.52304 0.80719 lineto
0.35968 0.75383 lineto
0.26198 0.5817 lineto
0.27566 0.37135 lineto
0.37453 0.24621 lineto
0.53439 0.20477 lineto
0.67816 0.30147 lineto
0.73857 0.49106 lineto
0.68735 0.68484 lineto
0.54847 0.79212 lineto
0.38691 0.76272 lineto
0.27827 0.61039 lineto
0.27338 0.4064 lineto
0.37453 0.24621 lineto
0.50774 0.21168 lineto
0.65419 0.28535 lineto
0.7285 0.45946 lineto
0.69588 0.65254 lineto
0.57161 0.77424 lineto
0.41384 0.76762 lineto
0.29637 0.63578 lineto
0.27419 0.4404 lineto
0.35767 0.27291 lineto
0.50774 0.21168 lineto
Mistroke
0.62979 0.27308 lineto
0.71611 0.43045 lineto
0.70132 0.62036 lineto
0.59233 0.75396 lineto
0.44013 0.76873 lineto
0.31595 0.65775 lineto
0.27789 0.47297 lineto
0.34376 0.30083 lineto
0.48273 0.22188 lineto
0.62979 0.27308 lineto
0.70173 0.40422 lineto
0.70378 0.58871 lineto
0.61049 0.73169 lineto
0.4655 0.76627 lineto
0.33665 0.67625 lineto
0.28423 0.50376 lineto
0.33278 0.32952 lineto
0.45957 0.23504 lineto
0.60528 0.26454 lineto
0.70173 0.40422 lineto
0.70344 0.55796 lineto
0.62604 0.70786 lineto
0.48966 0.7605 lineto
0.35812 0.69125 lineto
0.29297 0.53251 lineto
0.32469 0.35856 lineto
0.43844 0.25079 lineto
0.58099 0.25963 lineto
0.68565 0.38094 lineto
0.70344 0.55796 lineto
0.63894 0.68288 lineto
0.51239 0.75173 lineto
0.38005 0.70279 lineto
0.30383 0.55897 lineto
0.3194 0.38755 lineto
0.41948 0.26875 lineto
0.55723 0.25815 lineto
0.66821 0.36072 lineto
0.70048 0.52846 lineto
0.63894 0.68288 lineto
0.53348 0.74025 lineto
0.4021 0.71095 lineto
0.31653 0.58294 lineto
0.3168 0.41612 lineto
0.4028 0.28855 lineto
0.53427 0.25992 lineto
0.64971 0.34363 lineto
0.6951 0.5005 lineto
0.6492 0.65714 lineto
0.53348 0.74025 lineto
Mistroke
0.424 0.71583 lineto
0.33079 0.60427 lineto
0.31676 0.44392 lineto
0.38847 0.30981 lineto
0.51236 0.26469 lineto
0.63047 0.32967 lineto
0.68753 0.47436 lineto
0.65685 0.63104 lineto
0.55277 0.7264 lineto
0.424 0.71583 lineto
0.34633 0.62287 lineto
0.3191 0.47065 lineto
0.37651 0.33216 lineto
0.49171 0.27221 lineto
0.61079 0.31884 lineto
0.67802 0.45024 lineto
0.66196 0.60492 lineto
0.57012 0.71051 lineto
0.44546 0.7176 lineto
0.34633 0.62287 lineto
0.32364 0.49602 lineto
0.36695 0.35524 lineto
0.47251 0.2822 lineto
0.59094 0.31107 lineto
0.66682 0.42834 lineto
0.66464 0.57914 lineto
0.58542 0.69291 lineto
0.46624 0.71641 lineto
0.36285 0.63866 lineto
0.32364 0.49602 lineto
0.35973 0.37871 lineto
0.45492 0.29438 lineto
0.5712 0.30626 lineto
0.65417 0.4088 lineto
0.665 0.55401 lineto
0.59863 0.67395 lineto
0.4861 0.7125 lineto
0.38008 0.65161 lineto
0.33017 0.51979 lineto
0.35973 0.37871 lineto
0.43905 0.30843 lineto
0.55182 0.30428 lineto
0.64034 0.39171 lineto
0.6632 0.52981 lineto
0.60969 0.65396 lineto
0.50486 0.70607 lineto
0.39775 0.66176 lineto
0.33849 0.54176 lineto
0.3548 0.40222 lineto
0.43905 0.30843 lineto
Mistroke
0.53303 0.30497 lineto
0.62559 0.37714 lineto
0.65939 0.50679 lineto
0.61861 0.63327 lineto
0.52233 0.69739 lineto
0.4156 0.66915 lineto
0.34837 0.56176 lineto
0.35208 0.42548 lineto
0.42501 0.32406 lineto
0.53303 0.30497 lineto
0.61016 0.36511 lineto
0.65375 0.48518 lineto
0.6254 0.61219 lineto
0.53837 0.6867 lineto
0.43339 0.67385 lineto
0.35957 0.57966 lineto
0.35146 0.44819 lineto
0.41286 0.34097 lineto
0.51502 0.30815 lineto
0.61016 0.36511 lineto
0.64649 0.46517 lineto
0.63013 0.59102 lineto
0.55288 0.67428 lineto
0.45089 0.67599 lineto
0.37188 0.59536 lineto
0.35281 0.4701 lineto
0.40262 0.35884 lineto
0.498 0.31362 lineto
0.59431 0.35562 lineto
0.64649 0.46517 lineto
0.63286 0.57004 lineto
0.56575 0.6604 lineto
0.46789 0.67571 lineto
0.38504 0.6088 lineto
0.35599 0.49098 lineto
0.39432 0.37738 lineto
0.4821 0.32116 lineto
0.57825 0.34862 lineto
0.63779 0.44691 lineto
0.63286 0.57004 lineto
0.57694 0.64534 lineto
0.4842 0.67316 lineto
0.39885 0.61995 lineto
0.36083 0.51061 lineto
0.38793 0.39631 lineto
0.46747 0.33053 lineto
0.56223 0.34404 lineto
0.62787 0.43053 lineto
0.63368 0.54952 lineto
0.57694 0.64534 lineto
Mistroke
0.49965 0.66852 lineto
0.41308 0.62882 lineto
0.36717 0.52884 lineto
0.38342 0.41536 lineto
0.45421 0.34149 lineto
0.54644 0.34179 lineto
0.61693 0.41611 lineto
0.63271 0.52969 lineto
0.58639 0.62937 lineto
0.49965 0.66852 lineto
0.42751 0.63544 lineto
0.37482 0.5455 lineto
0.38071 0.43428 lineto
0.44242 0.3538 lineto
0.53107 0.34174 lineto
0.60518 0.40373 lineto
0.63008 0.51076 lineto
0.59411 0.61276 lineto
0.51411 0.662 lineto
0.42751 0.63544 lineto
0.3836 0.56049 lineto
0.37973 0.45281 lineto
0.43213 0.36722 lineto
0.51629 0.34375 lineto
0.59283 0.39339 lineto
0.62593 0.49292 lineto
0.60011 0.59576 lineto
0.52744 0.65379 lineto
0.44194 0.63986 lineto
0.3836 0.56049 lineto
0.38037 0.47076 lineto
0.4234 0.38148 lineto
0.50226 0.34766 lineto
0.58007 0.38512 lineto
0.62041 0.47633 lineto
0.60441 0.57862 lineto
0.53955 0.64412 lineto
0.45619 0.64218 lineto
0.39332 0.57372 lineto
0.38037 0.47076 lineto
0.41623 0.39636 lineto
0.48912 0.3533 lineto
0.5671 0.37888 lineto
0.61369 0.46113 lineto
0.60708 0.56157 lineto
0.55036 0.6332 lineto
0.47008 0.64251 lineto
0.4038 0.58513 lineto
0.38253 0.48792 lineto
0.41623 0.39636 lineto
Mistroke
0.47697 0.36048 lineto
0.55411 0.37461 lineto
0.60592 0.44742 lineto
0.60818 0.54483 lineto
0.55982 0.62126 lineto
0.48346 0.64096 lineto
0.41485 0.59469 lineto
0.38608 0.50412 lineto
0.41061 0.41162 lineto
0.47697 0.36048 lineto
0.54125 0.37226 lineto
0.59729 0.43529 lineto
0.6078 0.5286 lineto
0.56788 0.60853 lineto
0.49619 0.63767 lineto
0.42628 0.6024 lineto
0.39087 0.51922 lineto
0.40652 0.42704 lineto
0.46591 0.369 lineto
0.54125 0.37226 lineto
0.58795 0.42478 lineto
0.60605 0.51305 lineto
0.57453 0.5952 lineto
0.50814 0.63282 lineto
0.43794 0.60828 lineto
0.39677 0.53308 lineto
0.40391 0.4424 lineto
0.45601 0.37867 lineto
0.52869 0.37171 lineto
0.58795 0.42478 lineto
0.60303 0.49834 lineto
0.57979 0.58151 lineto
0.5192 0.62655 lineto
0.44964 0.61237 lineto
0.40363 0.54561 lineto
0.40272 0.45751 lineto
0.44733 0.38929 lineto
0.51658 0.37287 lineto
0.57807 0.41594 lineto
0.60303 0.49834 lineto
0.58366 0.56765 lineto
0.5293 0.61904 lineto
0.46123 0.61473 lineto
0.4113 0.55674 lineto
0.40288 0.4722 lineto
0.4399 0.40066 lineto
0.50504 0.37561 lineto
0.56782 0.40876 lineto
0.59887 0.4846 lineto
0.58366 0.56765 lineto
Mistroke
0.53836 0.61048 lineto
0.47258 0.61545 lineto
0.41962 0.56641 lineto
0.40428 0.48629 lineto
0.43373 0.41259 lineto
0.49418 0.37979 lineto
0.55736 0.40324 lineto
0.5937 0.47196 lineto
0.5862 0.55381 lineto
0.53836 0.61048 lineto
0.48354 0.61462 lineto
0.42845 0.57458 lineto
0.40684 0.49964 lineto
0.42882 0.42487 lineto
0.48411 0.38525 lineto
0.54683 0.39933 lineto
0.58764 0.46051 lineto
0.58745 0.54017 lineto
0.54633 0.60103 lineto
0.48354 0.61462 lineto
0.43763 0.58125 lineto
0.41044 0.51213 lineto
0.42515 0.43733 lineto
0.47489 0.39186 lineto
0.53638 0.39698 lineto
0.58084 0.45031 lineto
0.58748 0.52689 lineto
0.55319 0.59089 lineto
0.49401 0.61236 lineto
0.43763 0.58125 lineto
0.41497 0.52365 lineto
0.4227 0.4498 lineto
0.4666 0.39944 lineto
0.52613 0.39613 lineto
0.57343 0.44142 lineto
0.58637 0.51413 lineto
0.5589 0.58022 lineto
0.50387 0.60878 lineto
0.44703 0.58644 lineto
0.41497 0.52365 lineto
0.42141 0.46211 lineto
0.45928 0.40783 lineto
0.51621 0.39668 lineto
0.56555 0.43387 lineto
0.58422 0.50201 lineto
0.56348 0.56921 lineto
0.51304 0.60402 lineto
0.4565 0.59016 lineto
0.42031 0.53412 lineto
0.42141 0.46211 lineto
Mistroke
0.45297 0.41688 lineto
0.50672 0.39854 lineto
0.55732 0.42767 lineto
0.5811 0.49065 lineto
0.56694 0.55801 lineto
0.52145 0.59822 lineto
0.46592 0.59247 lineto
0.42634 0.54346 lineto
0.42123 0.47411 lineto
0.45297 0.41688 lineto
0.49776 0.40159 lineto
0.54889 0.42282 lineto
0.57714 0.48016 lineto
0.5693 0.54678 lineto
0.52903 0.59151 lineto
0.47518 0.59343 lineto
0.43294 0.55163 lineto
0.42208 0.48567 lineto
0.44768 0.42641 lineto
0.49776 0.40159 lineto
0.54037 0.41928 lineto
0.57243 0.4706 lineto
0.5706 0.53568 lineto
0.53574 0.58406 lineto
0.48415 0.59311 lineto
0.43998 0.55859 lineto
0.42389 0.49666 lineto
0.44342 0.43629 lineto
0.48942 0.40573 lineto
0.54037 0.41928 lineto
0.56709 0.46205 lineto
0.57091 0.52483 lineto
0.54155 0.576 lineto
0.49275 0.5916 lineto
0.44734 0.56435 lineto
0.42657 0.50698 lineto
0.44016 0.44635 lineto
0.48175 0.41082 lineto
0.53188 0.41702 lineto
0.56709 0.46205 lineto
0.57027 0.51437 lineto
0.54644 0.56747 lineto
0.50088 0.589 lineto
0.45491 0.56889 lineto
0.43003 0.51654 lineto
0.4379 0.45646 lineto
0.47482 0.41674 lineto
0.52352 0.41599 lineto
0.56122 0.45454 lineto
0.57027 0.51437 lineto
Mistroke
0.55041 0.55862 lineto
0.50848 0.58541 lineto
0.46257 0.57224 lineto
0.43418 0.52527 lineto
0.43659 0.46647 lineto
0.46866 0.42336 lineto
0.5154 0.41612 lineto
0.55494 0.44812 lineto
0.56876 0.5044 lineto
0.55041 0.55862 lineto
0.51547 0.58095 lineto
0.47022 0.57444 lineto
0.43891 0.5331 lineto
0.43619 0.47627 lineto
0.46332 0.43055 lineto
0.50761 0.41732 lineto
0.54835 0.44278 lineto
0.56646 0.49502 lineto
0.55347 0.54958 lineto
0.51547 0.58095 lineto
0.47776 0.57552 lineto
0.44413 0.53999 lineto
0.43664 0.48574 lineto
0.4588 0.43817 lineto
0.50023 0.41953 lineto
0.54156 0.43854 lineto
0.56344 0.48631 lineto
0.55564 0.54049 lineto
0.5218 0.57572 lineto
0.47776 0.57552 lineto
0.44974 0.54591 lineto
0.43789 0.49478 lineto
0.4551 0.4461 lineto
0.49333 0.42263 lineto
0.53467 0.43537 lineto
0.55979 0.47835 lineto
0.55694 0.53146 lineto
0.52744 0.56985 lineto
0.4851 0.57555 lineto
0.44974 0.54591 lineto
0.43986 0.5033 lineto
0.45223 0.45421 lineto
0.48696 0.42654 lineto
0.52778 0.43325 lineto
0.55561 0.47119 lineto
0.55741 0.52261 lineto
0.53236 0.56345 lineto
0.49216 0.5746 lineto
0.45563 0.55085 lineto
0.43986 0.5033 lineto
Mistroke
0.45017 0.46239 lineto
0.48117 0.43116 lineto
0.52098 0.43213 lineto
0.55097 0.46486 lineto
0.55711 0.51404 lineto
0.53653 0.55664 lineto
0.49886 0.57274 lineto
0.46172 0.55481 lineto
0.44249 0.51123 lineto
0.45017 0.46239 lineto
0.476 0.43636 lineto
0.51434 0.43197 lineto
0.54597 0.45941 lineto
0.55609 0.50584 lineto
0.53996 0.54954 lineto
0.50514 0.57006 lineto
0.46791 0.5578 lineto
0.4457 0.51849 lineto
0.44889 0.47053 lineto
0.476 0.43636 lineto
0.50795 0.4327 lineto
0.5407 0.45483 lineto
0.5544 0.4981 lineto
0.54265 0.54226 lineto
0.51094 0.56664 lineto
0.47411 0.55984 lineto
0.4494 0.52504 lineto
0.44836 0.47853 lineto
0.47148 0.44206 lineto
0.50795 0.4327 lineto
0.53524 0.45115 lineto
0.55212 0.49089 lineto
0.54461 0.5349 lineto
0.51623 0.56258 lineto
0.48025 0.56097 lineto
0.45352 0.53084 lineto
0.44853 0.48628 lineto
0.46763 0.44814 lineto
0.50187 0.43426 lineto
0.53524 0.45115 lineto
0.54931 0.48427 lineto
0.54586 0.52756 lineto
0.52096 0.55796 lineto
0.48625 0.56124 lineto
0.45797 0.53586 lineto
0.44936 0.49371 lineto
0.46445 0.45449 lineto
0.49617 0.43657 lineto
0.52968 0.44833 lineto
0.54931 0.48427 lineto
Mistroke
0.54643 0.52035 lineto
0.52511 0.5529 lineto
0.49203 0.56069 lineto
0.46269 0.54009 lineto
0.4508 0.50073 lineto
0.46193 0.46103 lineto
0.49088 0.43956 lineto
0.52409 0.44637 lineto
0.54603 0.47828 lineto
0.54643 0.52035 lineto
0.52866 0.54747 lineto
0.49755 0.55939 lineto
0.46758 0.54353 lineto
0.45278 0.50729 lineto
0.46008 0.46765 lineto
0.48606 0.44314 lineto
0.51856 0.44524 lineto
0.54238 0.47296 lineto
0.54637 0.51334 lineto
0.52866 0.54747 lineto
0.50273 0.55741 lineto
0.47257 0.54617 lineto
0.45525 0.51333 lineto
0.45886 0.47425 lineto
0.48173 0.44722 lineto
0.51314 0.44489 lineto
0.53841 0.46834 lineto
0.5457 0.50661 lineto
0.53161 0.54178 lineto
0.50273 0.55741 lineto
0.4776 0.54804 lineto
0.45813 0.5188 lineto
0.45826 0.48077 lineto
0.47791 0.45173 lineto
0.50791 0.44528 lineto
0.5342 0.46443 lineto
0.54449 0.50023 lineto
0.53396 0.53592 lineto
0.50755 0.5548 lineto
0.4776 0.54804 lineto
0.46138 0.52368 lineto
0.45824 0.48711 lineto
0.47464 0.45657 lineto
0.50291 0.44635 lineto
0.52981 0.46124 lineto
0.54277 0.49426 lineto
0.53572 0.52997 lineto
0.51195 0.55166 lineto
0.48259 0.54917 lineto
0.46138 0.52368 lineto
Mistroke
0.45876 0.4932 lineto
0.47191 0.46166 lineto
0.4982 0.44805 lineto
0.52533 0.45876 lineto
0.54061 0.48876 lineto
0.53689 0.52402 lineto
0.51591 0.54804 lineto
0.48748 0.54959 lineto
0.46491 0.52793 lineto
0.45876 0.4932 lineto
0.46971 0.46691 lineto
0.49381 0.45032 lineto
0.52081 0.45697 lineto
0.53807 0.48376 lineto
0.53751 0.51814 lineto
0.51941 0.54404 lineto
0.49222 0.54933 lineto
0.46867 0.53154 lineto
0.45979 0.49899 lineto
0.46971 0.46691 lineto
0.4898 0.45309 lineto
0.51631 0.45586 lineto
0.53519 0.47929 lineto
0.5376 0.51241 lineto
0.52242 0.53972 lineto
0.49675 0.54845 lineto
0.4726 0.5345 lineto
0.46127 0.50441 lineto
0.46806 0.47226 lineto
0.4898 0.45309 lineto
0.51189 0.4554 lineto
0.53204 0.47539 lineto
0.5372 0.50689 lineto
0.52495 0.53517 lineto
0.50103 0.54699 lineto
0.47662 0.53683 lineto
0.46316 0.50943 lineto
0.46693 0.47762 lineto
0.48617 0.45628 lineto
0.51189 0.4554 lineto
0.52868 0.47206 lineto
0.53634 0.50164 lineto
0.527 0.53046 lineto
0.50502 0.54502 lineto
0.48069 0.53852 lineto
0.4654 0.51399 lineto
0.4663 0.48292 lineto
0.48297 0.45984 lineto
0.5076 0.45555 lineto
0.52868 0.47206 lineto
Mistroke
0.53507 0.49671 lineto
0.52855 0.52565 lineto
0.50868 0.54259 lineto
0.48475 0.5396 lineto
0.46795 0.51808 lineto
0.46615 0.4881 lineto
0.48019 0.46369 lineto
0.5035 0.45626 lineto
0.52517 0.46931 lineto
0.53507 0.49671 lineto
0.52964 0.52083 lineto
0.51199 0.53977 lineto
0.48874 0.5401 lineto
0.47075 0.52167 lineto
0.46645 0.4931 lineto
0.47785 0.46775 lineto
0.49961 0.4575 lineto
0.52156 0.46713 lineto
0.53342 0.49214 lineto
0.52964 0.52083 lineto
0.51493 0.53661 lineto
0.49261 0.54005 lineto
0.47375 0.52474 lineto
0.46717 0.49786 lineto
0.47595 0.47198 lineto
0.49599 0.45921 lineto
0.5179 0.46553 lineto
0.53144 0.48797 lineto
0.53027 0.51605 lineto
0.51493 0.53661 lineto
0.49633 0.53947 lineto
0.47689 0.52729 lineto
0.46826 0.50234 lineto
0.47449 0.47629 lineto
0.49265 0.46134 lineto
0.51425 0.46447 lineto
0.52918 0.48423 lineto
0.53046 0.51137 lineto
0.51749 0.53319 lineto
0.49633 0.53947 lineto
0.48013 0.52932 lineto
0.4697 0.5065 lineto
0.47345 0.48063 lineto
0.48962 0.46383 lineto
0.51065 0.46395 lineto
0.52669 0.48094 lineto
0.53025 0.50685 lineto
0.51965 0.52955 lineto
0.49986 0.53843 lineto
0.48013 0.52932 lineto
Mistroke
0.47144 0.5103 lineto
0.47282 0.48494 lineto
0.48692 0.46663 lineto
0.50714 0.46393 lineto
0.52402 0.47811 lineto
0.52966 0.50253 lineto
0.52142 0.52577 lineto
0.50316 0.53695 lineto
0.48342 0.53084 lineto
0.47144 0.5103 lineto
0.47259 0.48917 lineto
0.48457 0.46968 lineto
0.50377 0.46438 lineto
0.52121 0.47575 lineto
0.52872 0.49846 lineto
0.52279 0.52189 lineto
0.5062 0.53508 lineto
0.48671 0.53186 lineto
0.47344 0.51372 lineto
0.47259 0.48917 lineto
0.48258 0.47293 lineto
0.50057 0.46526 lineto
0.5183 0.47385 lineto
0.52747 0.49467 lineto
0.52378 0.51799 lineto
0.50897 0.53289 lineto
0.48996 0.5324 lineto
0.47565 0.51675 lineto
0.47273 0.49326 lineto
0.48258 0.47293 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureWidth = 431; pictureHeight = 431; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.17783 1.21095 moveto
0.65365 1.58924 lineto
0.05758 1.45787 lineto
-0.33148 0.87829 lineto
-0.33148 0.12171 lineto
0.05758 -0.45787 lineto
0.65365 -0.58924 lineto
1.17783 -0.21095 lineto
1.38484 0.5 lineto
1.17783 1.21095 lineto
0.74101 1.5262 lineto
0.15693 1.47976 lineto
-0.26663 0.97489 lineto
-0.33148 0.24781 lineto
-0.00726 -0.36127 lineto
0.55431 -0.56735 lineto
1.09046 -0.274 lineto
1.35034 0.38151 lineto
1.21233 1.09246 lineto
0.74101 1.5262 lineto
0.25427 1.4875 lineto
-0.19604 1.05903 lineto
-0.32067 0.36899 lineto
-0.0613 -0.25976 lineto
0.46071 -0.533 lineto
1.0011 -0.32289 lineto
1.30702 0.27226 lineto
1.23533 0.97397 lineto
0.81957 1.45391 lineto
0.25427 1.4875 lineto
-0.12099 1.13044 lineto
-0.2999 0.48399 lineto
-0.10453 -0.15497 lineto
0.37371 -0.48746 lineto
0.91104 -0.35791 lineto
1.25604 0.17306 lineto
1.24728 0.85702 lineto
0.88886 1.37392 lineto
0.34849 1.4819 lineto
-0.12099 1.13044 lineto
-0.27008 0.59174 lineto
-0.13709 -0.04847 lineto
0.294 -0.43205 lineto
0.82148 -0.3795 lineto
1.19854 0.08457 lineto
1.24874 0.74302 lineto
0.9486 1.28777 lineto
0.43855 1.4639 lineto
-0.04274 1.18902 lineto
-0.27008 0.59174 lineto
Mistroke
-0.15925 0.05823 lineto
0.22215 -0.36812 lineto
0.73357 -0.38826 lineto
1.1357 0.00722 lineto
1.24037 0.63328 lineto
0.99862 1.19698 lineto
0.52356 1.43455 lineto
0.03747 1.23483 lineto
-0.23219 0.69128 lineto
-0.15925 0.05823 lineto
0.15859 -0.29706 lineto
0.64833 -0.3849 lineto
1.06867 -0.05869 lineto
1.22293 0.52894 lineto
1.03891 1.10303 lineto
0.60274 1.39495 lineto
0.11849 1.26812 lineto
-0.18725 0.78187 lineto
-0.17141 0.16374 lineto
0.15859 -0.29706 lineto
0.56671 -0.37026 lineto
0.99862 -0.11306 lineto
1.19722 0.431 lineto
1.06958 1.00735 lineto
0.67543 1.3463 lineto
0.1992 1.28926 lineto
-0.13629 0.86292 lineto
-0.17405 0.26676 lineto
0.10359 -0.22026 lineto
0.56671 -0.37026 lineto
0.92663 -0.15593 lineto
1.16412 0.34032 lineto
1.09085 0.91129 lineto
0.74112 1.28981 lineto
0.27857 1.29877 lineto
-0.08038 0.93397 lineto
-0.16776 0.36612 lineto
0.05731 -0.13909 lineto
0.48952 -0.34526 lineto
0.92663 -0.15593 lineto
1.12454 0.25762 lineto
1.10306 0.81613 lineto
0.79941 1.22672 lineto
0.35566 1.29727 lineto
-0.02055 0.99477 lineto
-0.15319 0.46076 lineto
0.0198 -0.05489 lineto
0.41749 -0.3109 lineto
0.85378 -0.18748 lineto
1.12454 0.25762 lineto
Mistroke
1.10664 0.72304 lineto
0.85002 1.15829 lineto
0.42962 1.28551 lineto
0.04215 1.04519 lineto
-0.13109 0.54976 lineto
-0.00903 0.03105 lineto
0.35121 -0.26823 lineto
0.78107 -0.20805 lineto
1.07941 0.18343 lineto
1.10664 0.72304 lineto
0.89279 1.08575 lineto
0.49969 1.26431 lineto
0.10673 1.08524 lineto
-0.10221 0.63233 lineto
-0.02937 0.11751 lineto
0.29117 -0.21835 lineto
0.70942 -0.21808 lineto
1.02969 0.11819 lineto
1.1021 0.63311 lineto
0.89279 1.08575 lineto
0.5652 1.23455 lineto
0.17222 1.11509 lineto
-0.06739 0.70782 lineto
-0.04151 0.20331 lineto
0.23774 -0.16237 lineto
0.63971 -0.21813 lineto
0.97631 0.06214 lineto
1.09003 0.54729 lineto
0.92768 1.01031 lineto
0.5652 1.23455 lineto
0.23772 1.135 lineto
-0.02745 0.7757 lineto
-0.04583 0.28739 lineto
0.1912 -0.10143 lineto
0.57272 -0.20883 lineto
0.92021 0.01543 lineto
1.07108 0.46643 lineto
0.95474 0.93314 lineto
0.62562 1.19718 lineto
0.23772 1.135 lineto
0.01674 0.83558 lineto
-0.04276 0.36878 lineto
0.1517 -0.03662 lineto
0.50913 -0.19093 lineto
0.86229 -0.02195 lineto
1.04594 0.39126 lineto
0.97413 0.85535 lineto
0.68047 1.15317 lineto
0.30237 1.14536 lineto
0.01674 0.83558 lineto
Mistroke
-0.03285 0.44658 lineto
0.11929 0.03094 lineto
0.44956 -0.16521 lineto
0.80343 -0.05011 lineto
1.01533 0.32239 lineto
0.98609 0.778 lineto
0.72941 1.10353 lineto
0.36538 1.14666 lineto
0.06435 0.88721 lineto
-0.03285 0.44658 lineto
0.09393 0.10022 lineto
0.39451 -0.13252 lineto
0.74446 -0.0693 lineto
0.98001 0.26031 lineto
0.99097 0.70207 lineto
0.77219 1.04928 lineto
0.42606 1.13947 lineto
0.11452 0.93045 lineto
-0.01665 0.52002 lineto
0.09393 0.10022 lineto
0.34442 -0.09373 lineto
0.68613 -0.07983 lineto
0.94075 0.20538 lineto
0.98914 0.62844 lineto
0.80865 0.99141 lineto
0.48375 1.12444 lineto
0.16644 0.96529 lineto
0.00521 0.58842 lineto
0.0755 0.17018 lineto
0.34442 -0.09373 lineto
0.62918 -0.08215 lineto
0.89832 0.15784 lineto
0.98108 0.55793 lineto
0.83874 0.93092 lineto
0.5379 1.10227 lineto
0.21933 0.99181 lineto
0.03208 0.65123 lineto
0.06379 0.23989 lineto
0.2996 -0.04975 lineto
0.62918 -0.08215 lineto
0.85346 0.11784 lineto
0.96728 0.49125 lineto
0.86246 0.86875 lineto
0.58804 1.07371 lineto
0.27242 1.01022 lineto
0.06329 0.708 lineto
0.0585 0.30845 lineto
0.2603 -0.00147 lineto
0.57425 -0.07675 lineto
0.85346 0.11784 lineto
Mistroke
0.94831 0.42902 lineto
0.87993 0.80583 lineto
0.63377 1.03955 lineto
0.32502 1.0208 lineto
0.09815 0.75837 lineto
0.0593 0.37504 lineto
0.22666 0.05018 lineto
0.52192 -0.0642 lineto
0.80692 0.08541 lineto
0.94831 0.42902 lineto
0.89133 0.74303 lineto
0.6748 1.0006 lineto
0.37648 1.02393 lineto
0.13596 0.80211 lineto
0.06578 0.43893 lineto
0.19877 0.10432 lineto
0.47271 -0.04514 lineto
0.75942 0.06047 lineto
0.92475 0.37175 lineto
0.89133 0.74303 lineto
0.71089 0.95767 lineto
0.4262 1.02004 lineto
0.17605 0.83908 lineto
0.07747 0.49946 lineto
0.1766 0.16009 lineto
0.42706 -0.02023 lineto
0.71164 0.04287 lineto
0.89719 0.31987 lineto
0.8969 0.68115 lineto
0.71089 0.95767 lineto
0.47365 1.00965 lineto
0.21774 0.86924 lineto
0.0939 0.55606 lineto
0.16008 0.21665 lineto
0.38531 0.00982 lineto
0.66421 0.03236 lineto
0.86627 0.2737 lineto
0.89695 0.62094 lineto
0.74189 0.91158 lineto
0.47365 1.00965 lineto
0.26039 0.89264 lineto
0.11454 0.60826 lineto
0.14905 0.27322 lineto
0.34778 0.0443 lineto
0.61773 0.0286 lineto
0.83259 0.23348 lineto
0.89183 0.56306 lineto
0.76773 0.86314 lineto
0.51836 0.9933 lineto
0.26039 0.89264 lineto
Mistroke
0.13885 0.65565 lineto
0.1433 0.32906 lineto
0.31466 0.08245 lineto
0.57273 0.03122 lineto
0.79678 0.19933 lineto
0.88196 0.50813 lineto
0.78842 0.81313 lineto
0.55992 0.97161 lineto
0.30338 0.90942 lineto
0.13885 0.65565 lineto
0.14256 0.38349 lineto
0.2861 0.12355 lineto
0.52972 0.03975 lineto
0.75944 0.17131 lineto
0.86776 0.45667 lineto
0.80401 0.7623 lineto
0.598 0.9452 lineto
0.34614 0.91978 lineto
0.16627 0.69795 lineto
0.14256 0.38349 lineto
0.26217 0.16687 lineto
0.48912 0.05372 lineto
0.72115 0.14939 lineto
0.84971 0.40911 lineto
0.81463 0.71136 lineto
0.63234 0.91471 lineto
0.38812 0.92402 lineto
0.19625 0.73492 lineto
0.14651 0.4359 lineto
0.26217 0.16687 lineto
0.45129 0.07258 lineto
0.68248 0.13344 lineto
0.82828 0.36582 lineto
0.82048 0.66098 lineto
0.66272 0.88082 lineto
0.42882 0.92247 lineto
0.22823 0.76644 lineto
0.1548 0.48574 lineto
0.2429 0.21171 lineto
0.45129 0.07258 lineto
0.64395 0.1233 lineto
0.80398 0.32709 lineto
0.82178 0.61179 lineto
0.68901 0.84418 lineto
0.4678 0.91553 lineto
0.26166 0.79244 lineto
0.16704 0.53252 lineto
0.22821 0.25738 lineto
0.41656 0.09577 lineto
0.64395 0.1233 lineto
Mistroke
0.77731 0.29313 lineto
0.81881 0.56434 lineto
0.71114 0.80545 lineto
0.50467 0.90363 lineto
0.29602 0.81296 lineto
0.18281 0.57584 lineto
0.21802 0.30324 lineto
0.38517 0.1227 lineto
0.60605 0.11871 lineto
0.77731 0.29313 lineto
0.8119 0.51914 lineto
0.72909 0.76526 lineto
0.53908 0.88727 lineto
0.33079 0.82807 lineto
0.20168 0.61536 lineto
0.21215 0.34867 lineto
0.35731 0.15279 lineto
0.56924 0.11938 lineto
0.74877 0.26406 lineto
0.8119 0.51914 lineto
0.74289 0.72424 lineto
0.57075 0.86694 lineto
0.36551 0.83794 lineto
0.2232 0.65081 lineto
0.2104 0.39312 lineto
0.33312 0.18544 lineto
0.53392 0.12495 lineto
0.71885 0.23994 lineto
0.80137 0.47662 lineto
0.74289 0.72424 lineto
0.59944 0.84315 lineto
0.39971 0.84277 lineto
0.24691 0.682 lineto
0.21254 0.43607 lineto
0.31267 0.22005 lineto
0.50045 0.13503 lineto
0.68802 0.22078 lineto
0.78762 0.43718 lineto
0.75264 0.68297 lineto
0.59944 0.84315 lineto
0.433 0.84283 lineto
0.27238 0.70879 lineto
0.21827 0.47706 lineto
0.29598 0.25606 lineto
0.46915 0.1492 lineto
0.65676 0.20649 lineto
0.77102 0.40111 lineto
0.75847 0.64201 lineto
0.62497 0.81646 lineto
0.433 0.84283 lineto
Mistroke
0.29915 0.73113 lineto
0.22729 0.51568 lineto
0.28303 0.29289 lineto
0.44029 0.16701 lineto
0.62549 0.19694 lineto
0.75198 0.36867 lineto
0.76056 0.60186 lineto
0.64722 0.78738 lineto
0.465 0.83844 lineto
0.29915 0.73113 lineto
0.23926 0.55159 lineto
0.27374 0.33002 lineto
0.41408 0.18799 lineto
0.59463 0.19195 lineto
0.7309 0.34005 lineto
0.75913 0.56299 lineto
0.66611 0.75646 lineto
0.49537 0.82993 lineto
0.32679 0.74902 lineto
0.23926 0.55159 lineto
0.26799 0.36695 lineto
0.39069 0.21166 lineto
0.56454 0.19129 lineto
0.70819 0.31537 lineto
0.75442 0.52584 lineto
0.68161 0.72422 lineto
0.52383 0.81768 lineto
0.35489 0.7625 lineto
0.25385 0.58449 lineto
0.26799 0.36695 lineto
0.37024 0.23754 lineto
0.53556 0.19468 lineto
0.68424 0.29469 lineto
0.74672 0.49076 lineto
0.69375 0.69115 lineto
0.55012 0.80211 lineto
0.38304 0.7717 lineto
0.27069 0.61416 lineto
0.26563 0.40321 lineto
0.37024 0.23754 lineto
0.50801 0.20183 lineto
0.65946 0.27802 lineto
0.7363 0.45808 lineto
0.70258 0.65775 lineto
0.57406 0.78361 lineto
0.41089 0.77677 lineto
0.28942 0.64042 lineto
0.26648 0.43837 lineto
0.3528 0.26515 lineto
0.50801 0.20183 lineto
Mistroke
0.63422 0.26532 lineto
0.7235 0.42807 lineto
0.7082 0.62448 lineto
0.59548 0.76264 lineto
0.43809 0.77791 lineto
0.30966 0.66314 lineto
0.2703 0.47204 lineto
0.33842 0.29402 lineto
0.48214 0.21238 lineto
0.63422 0.26532 lineto
0.70862 0.40094 lineto
0.71075 0.59174 lineto
0.61427 0.73961 lineto
0.46432 0.77536 lineto
0.33107 0.68227 lineto
0.27686 0.50389 lineto
0.32706 0.32369 lineto
0.45819 0.22599 lineto
0.60887 0.2565 lineto
0.70862 0.40094 lineto
0.71039 0.55994 lineto
0.63035 0.71497 lineto
0.48931 0.7694 lineto
0.35327 0.69779 lineto
0.28589 0.53362 lineto
0.3187 0.35373 lineto
0.43633 0.24227 lineto
0.58376 0.25141 lineto
0.69199 0.37687 lineto
0.71039 0.55994 lineto
0.64369 0.68913 lineto
0.51282 0.76033 lineto
0.37595 0.70972 lineto
0.29712 0.56098 lineto
0.31323 0.38371 lineto
0.41673 0.26085 lineto
0.55919 0.24989 lineto
0.67395 0.35596 lineto
0.70733 0.52943 lineto
0.64369 0.68913 lineto
0.53463 0.74846 lineto
0.39876 0.71816 lineto
0.31026 0.58577 lineto
0.31055 0.41325 lineto
0.39948 0.28132 lineto
0.53544 0.25172 lineto
0.65483 0.33828 lineto
0.70176 0.50052 lineto
0.65429 0.66251 lineto
0.53463 0.74846 lineto
Mistroke
0.4214 0.72321 lineto
0.32501 0.60784 lineto
0.3105 0.44201 lineto
0.38465 0.30331 lineto
0.51278 0.25665 lineto
0.63493 0.32385 lineto
0.69394 0.47348 lineto
0.66221 0.63551 lineto
0.55457 0.73414 lineto
0.4214 0.72321 lineto
0.34108 0.62707 lineto
0.31292 0.46965 lineto
0.3723 0.32643 lineto
0.49143 0.26443 lineto
0.61457 0.31265 lineto
0.68411 0.44854 lineto
0.6675 0.60851 lineto
0.57251 0.7177 lineto
0.4436 0.72503 lineto
0.34108 0.62707 lineto
0.31761 0.49588 lineto
0.3624 0.3503 lineto
0.47157 0.27476 lineto
0.59405 0.30462 lineto
0.67252 0.42589 lineto
0.67026 0.58185 lineto
0.58834 0.6995 lineto
0.46508 0.72381 lineto
0.35816 0.64339 lineto
0.31761 0.49588 lineto
0.35493 0.37456 lineto
0.45338 0.28735 lineto
0.57364 0.29964 lineto
0.65944 0.40568 lineto
0.67064 0.55585 lineto
0.602 0.67989 lineto
0.48563 0.71976 lineto
0.37598 0.6568 lineto
0.32437 0.52047 lineto
0.35493 0.37456 lineto
0.43697 0.30189 lineto
0.55359 0.29759 lineto
0.64514 0.38801 lineto
0.66877 0.53083 lineto
0.61344 0.65922 lineto
0.50502 0.71311 lineto
0.39426 0.66729 lineto
0.33297 0.54319 lineto
0.34984 0.39888 lineto
0.43697 0.30189 lineto
Mistroke
0.53416 0.29831 lineto
0.62988 0.37294 lineto
0.66483 0.50702 lineto
0.62266 0.63782 lineto
0.52309 0.70413 lineto
0.41272 0.67493 lineto
0.34319 0.56387 lineto
0.34703 0.42293 lineto
0.42245 0.31805 lineto
0.53416 0.29831 lineto
0.61393 0.3605 lineto
0.65901 0.48467 lineto
0.62969 0.61602 lineto
0.53969 0.69308 lineto
0.43111 0.67979 lineto
0.35477 0.58238 lineto
0.34639 0.44642 lineto
0.40988 0.33553 lineto
0.51554 0.3016 lineto
0.61393 0.3605 lineto
0.65149 0.46398 lineto
0.63457 0.59413 lineto
0.55469 0.68024 lineto
0.44921 0.68201 lineto
0.3675 0.59862 lineto
0.34779 0.46908 lineto
0.3993 0.35401 lineto
0.49793 0.30725 lineto
0.59753 0.35068 lineto
0.65149 0.46398 lineto
0.63739 0.57244 lineto
0.568 0.66589 lineto
0.46679 0.68171 lineto
0.38112 0.61251 lineto
0.35107 0.49067 lineto
0.39071 0.37319 lineto
0.48149 0.31505 lineto
0.58093 0.34344 lineto
0.6425 0.4451 lineto
0.63739 0.57244 lineto
0.57957 0.65031 lineto
0.48366 0.67907 lineto
0.39539 0.62405 lineto
0.35608 0.51098 lineto
0.3841 0.39277 lineto
0.46636 0.32474 lineto
0.56436 0.33871 lineto
0.63224 0.42815 lineto
0.63825 0.55121 lineto
0.57957 0.65031 lineto
Mistroke
0.49964 0.67428 lineto
0.41011 0.63322 lineto
0.36263 0.52982 lineto
0.37943 0.41247 lineto
0.45265 0.33608 lineto
0.54802 0.33638 lineto
0.62092 0.41325 lineto
0.63724 0.5307 lineto
0.58935 0.63379 lineto
0.49964 0.67428 lineto
0.42503 0.64006 lineto
0.37054 0.54706 lineto
0.37663 0.43203 lineto
0.44045 0.34881 lineto
0.53213 0.33633 lineto
0.60877 0.40044 lineto
0.63452 0.51113 lineto
0.59733 0.61661 lineto
0.51459 0.66753 lineto
0.42503 0.64006 lineto
0.37962 0.56256 lineto
0.37562 0.4512 lineto
0.42981 0.36268 lineto
0.51685 0.33841 lineto
0.596 0.38975 lineto
0.63023 0.49268 lineto
0.60353 0.59903 lineto
0.52838 0.65905 lineto
0.43996 0.64464 lineto
0.37962 0.56256 lineto
0.37629 0.46976 lineto
0.42078 0.37743 lineto
0.50234 0.34246 lineto
0.58281 0.3812 lineto
0.62453 0.47553 lineto
0.60798 0.58131 lineto
0.54091 0.64904 lineto
0.45469 0.64704 lineto
0.38968 0.57624 lineto
0.37629 0.46976 lineto
0.41336 0.39282 lineto
0.48875 0.34829 lineto
0.5694 0.37474 lineto
0.61757 0.4598 lineto
0.61074 0.56368 lineto
0.55209 0.63775 lineto
0.46906 0.64738 lineto
0.40052 0.58804 lineto
0.37852 0.48751 lineto
0.41336 0.39282 lineto
Mistroke
0.47618 0.35571 lineto
0.55596 0.37033 lineto
0.60954 0.44563 lineto
0.61188 0.54636 lineto
0.56186 0.62541 lineto
0.4829 0.64577 lineto
0.41194 0.59793 lineto
0.38218 0.50426 lineto
0.40756 0.4086 lineto
0.47618 0.35571 lineto
0.54266 0.36789 lineto
0.60061 0.43308 lineto
0.61149 0.52957 lineto
0.5702 0.61223 lineto
0.49606 0.64238 lineto
0.42377 0.6059 lineto
0.38714 0.51987 lineto
0.40333 0.42455 lineto
0.46475 0.36452 lineto
0.54266 0.36789 lineto
0.59095 0.42221 lineto
0.60968 0.51349 lineto
0.57708 0.59846 lineto
0.50842 0.63735 lineto
0.43582 0.61198 lineto
0.39325 0.53421 lineto
0.40063 0.44043 lineto
0.45451 0.37453 lineto
0.52967 0.36733 lineto
0.59095 0.42221 lineto
0.60656 0.49828 lineto
0.58251 0.5843 lineto
0.51986 0.63087 lineto
0.44792 0.61621 lineto
0.40034 0.54717 lineto
0.3994 0.45606 lineto
0.44553 0.38551 lineto
0.51715 0.36853 lineto
0.58074 0.41307 lineto
0.60656 0.49828 lineto
0.58652 0.56996 lineto
0.5303 0.62311 lineto
0.45991 0.61865 lineto
0.40827 0.55868 lineto
0.39956 0.47125 lineto
0.43784 0.39727 lineto
0.50521 0.37136 lineto
0.57014 0.40564 lineto
0.60225 0.48408 lineto
0.58652 0.56996 lineto
Mistroke
0.53967 0.61425 lineto
0.47164 0.6194 lineto
0.41688 0.56867 lineto
0.40101 0.48582 lineto
0.43146 0.4096 lineto
0.49398 0.37568 lineto
0.55932 0.39993 lineto
0.5969 0.471 lineto
0.58914 0.55565 lineto
0.53967 0.61425 lineto
0.48298 0.61854 lineto
0.426 0.57713 lineto
0.40365 0.49963 lineto
0.42639 0.4223 lineto
0.48356 0.38133 lineto
0.54843 0.39589 lineto
0.59064 0.45916 lineto
0.59043 0.54154 lineto
0.54792 0.60448 lineto
0.48298 0.61854 lineto
0.4355 0.58403 lineto
0.40738 0.51255 lineto
0.4226 0.43519 lineto
0.47403 0.38816 lineto
0.53762 0.39346 lineto
0.5836 0.44861 lineto
0.59047 0.52781 lineto
0.555 0.59399 lineto
0.4938 0.6162 lineto
0.4355 0.58403 lineto
0.41207 0.52446 lineto
0.42006 0.44808 lineto
0.46546 0.396 lineto
0.52702 0.39258 lineto
0.57594 0.43942 lineto
0.58932 0.51461 lineto
0.56091 0.58296 lineto
0.504 0.6125 lineto
0.44522 0.58939 lineto
0.41207 0.52446 lineto
0.41873 0.46081 lineto
0.45789 0.40468 lineto
0.51676 0.39315 lineto
0.56779 0.43161 lineto
0.58709 0.50208 lineto
0.56565 0.57157 lineto
0.51349 0.60757 lineto
0.45501 0.59324 lineto
0.41759 0.53528 lineto
0.41873 0.46081 lineto
Mistroke
0.45137 0.41404 lineto
0.50695 0.39507 lineto
0.55928 0.4252 lineto
0.58388 0.49033 lineto
0.56922 0.55999 lineto
0.52218 0.60157 lineto
0.46476 0.59563 lineto
0.42383 0.54494 lineto
0.41854 0.47322 lineto
0.45137 0.41404 lineto
0.49769 0.39823 lineto
0.55056 0.42018 lineto
0.57978 0.47948 lineto
0.57166 0.54838 lineto
0.53002 0.59464 lineto
0.47433 0.59662 lineto
0.43065 0.55339 lineto
0.41942 0.48518 lineto
0.44589 0.4239 lineto
0.49769 0.39823 lineto
0.54175 0.41652 lineto
0.57491 0.4696 lineto
0.57302 0.5369 lineto
0.53696 0.58693 lineto
0.48361 0.59629 lineto
0.43793 0.56059 lineto
0.42129 0.49655 lineto
0.44148 0.43411 lineto
0.48905 0.40251 lineto
0.54175 0.41652 lineto
0.56938 0.46075 lineto
0.57333 0.52568 lineto
0.54297 0.57859 lineto
0.4925 0.59473 lineto
0.44554 0.56654 lineto
0.42406 0.50722 lineto
0.43812 0.44452 lineto
0.48113 0.40778 lineto
0.53297 0.41419 lineto
0.56938 0.46075 lineto
0.57267 0.51486 lineto
0.54803 0.56977 lineto
0.50091 0.59204 lineto
0.45337 0.57124 lineto
0.42764 0.51711 lineto
0.43578 0.45497 lineto
0.47396 0.4139 lineto
0.52433 0.41312 lineto
0.56331 0.45299 lineto
0.57267 0.51486 lineto
Mistroke
0.55214 0.56062 lineto
0.50877 0.58833 lineto
0.46129 0.57471 lineto
0.43193 0.52613 lineto
0.43442 0.46533 lineto
0.46759 0.42075 lineto
0.51593 0.41325 lineto
0.55681 0.44634 lineto
0.57111 0.50455 lineto
0.55214 0.56062 lineto
0.516 0.58371 lineto
0.46921 0.57698 lineto
0.43683 0.53423 lineto
0.43401 0.47546 lineto
0.46206 0.42818 lineto
0.50787 0.4145 lineto
0.55 0.44083 lineto
0.56873 0.49485 lineto
0.5553 0.55128 lineto
0.516 0.58371 lineto
0.477 0.5781 lineto
0.44222 0.54135 lineto
0.43448 0.48525 lineto
0.45739 0.43606 lineto
0.50024 0.41678 lineto
0.54298 0.43644 lineto
0.56561 0.48584 lineto
0.55754 0.54187 lineto
0.52255 0.57831 lineto
0.477 0.5781 lineto
0.44802 0.54748 lineto
0.43577 0.4946 lineto
0.45357 0.44426 lineto
0.4931 0.41999 lineto
0.53586 0.43316 lineto
0.56184 0.47761 lineto
0.55888 0.53253 lineto
0.52838 0.57223 lineto
0.48459 0.57814 lineto
0.44802 0.54748 lineto
0.43781 0.50342 lineto
0.4506 0.45265 lineto
0.48651 0.42403 lineto
0.52873 0.43097 lineto
0.55751 0.4702 lineto
0.55938 0.52338 lineto
0.53346 0.56562 lineto
0.49189 0.57715 lineto
0.45412 0.55259 lineto
0.43781 0.50342 lineto
Mistroke
0.44847 0.46111 lineto
0.48052 0.4288 lineto
0.52169 0.42981 lineto
0.55271 0.46366 lineto
0.55906 0.51452 lineto
0.53778 0.55858 lineto
0.49882 0.57523 lineto
0.46041 0.55668 lineto
0.44053 0.51161 lineto
0.44847 0.46111 lineto
0.47518 0.43419 lineto
0.51483 0.42964 lineto
0.54754 0.45802 lineto
0.558 0.50604 lineto
0.54133 0.55123 lineto
0.50531 0.57245 lineto
0.46681 0.55977 lineto
0.44384 0.51912 lineto
0.44715 0.46953 lineto
0.47518 0.43419 lineto
0.50822 0.4304 lineto
0.54209 0.45329 lineto
0.55626 0.49804 lineto
0.54411 0.5437 lineto
0.51132 0.56892 lineto
0.47323 0.56189 lineto
0.44767 0.5259 lineto
0.4466 0.47779 lineto
0.47051 0.44008 lineto
0.50822 0.4304 lineto
0.53644 0.44948 lineto
0.5539 0.49058 lineto
0.54613 0.53609 lineto
0.51678 0.56471 lineto
0.47958 0.56306 lineto
0.45193 0.5319 lineto
0.44677 0.48581 lineto
0.46652 0.44636 lineto
0.50194 0.43201 lineto
0.53644 0.44948 lineto
0.55099 0.48373 lineto
0.54743 0.52851 lineto
0.52167 0.55994 lineto
0.48578 0.56333 lineto
0.45654 0.53709 lineto
0.44763 0.49349 lineto
0.46323 0.45294 lineto
0.49604 0.43441 lineto
0.53069 0.44657 lineto
0.55099 0.48373 lineto
Mistroke
0.54802 0.52104 lineto
0.52597 0.5547 lineto
0.49176 0.56277 lineto
0.46141 0.54146 lineto
0.44912 0.50076 lineto
0.46063 0.4597 lineto
0.49057 0.43749 lineto
0.52492 0.44454 lineto
0.54761 0.47754 lineto
0.54802 0.52104 lineto
0.52964 0.54909 lineto
0.49746 0.56142 lineto
0.46647 0.54501 lineto
0.45117 0.50754 lineto
0.45871 0.46654 lineto
0.48558 0.44119 lineto
0.51919 0.44337 lineto
0.54383 0.47204 lineto
0.54795 0.51379 lineto
0.52964 0.54909 lineto
0.50282 0.55937 lineto
0.47163 0.54775 lineto
0.45372 0.51379 lineto
0.45746 0.47337 lineto
0.4811 0.44542 lineto
0.51359 0.443 lineto
0.53972 0.46726 lineto
0.54726 0.50683 lineto
0.53269 0.54321 lineto
0.50282 0.55937 lineto
0.47683 0.54969 lineto
0.4567 0.51945 lineto
0.45683 0.48011 lineto
0.47716 0.45008 lineto
0.50818 0.44341 lineto
0.53536 0.46322 lineto
0.54601 0.50024 lineto
0.53512 0.53715 lineto
0.5078 0.55668 lineto
0.47683 0.54969 lineto
0.46006 0.52449 lineto
0.45681 0.48667 lineto
0.47377 0.45508 lineto
0.50301 0.44452 lineto
0.53083 0.45991 lineto
0.54423 0.49407 lineto
0.53694 0.531 lineto
0.51236 0.55342 lineto
0.48199 0.55085 lineto
0.46006 0.52449 lineto
Mistroke
0.45735 0.49297 lineto
0.47095 0.46035 lineto
0.49813 0.44628 lineto
0.5262 0.45735 lineto
0.542 0.48837 lineto
0.53815 0.52484 lineto
0.51645 0.54968 lineto
0.48705 0.55128 lineto
0.46371 0.52888 lineto
0.45735 0.49297 lineto
0.46868 0.46578 lineto
0.4936 0.44862 lineto
0.52152 0.4555 lineto
0.53937 0.4832 lineto
0.53879 0.51876 lineto
0.52007 0.54554 lineto
0.49195 0.55101 lineto
0.4676 0.53261 lineto
0.45841 0.49895 lineto
0.46868 0.46578 lineto
0.48945 0.45148 lineto
0.51687 0.45436 lineto
0.53639 0.47859 lineto
0.53889 0.51284 lineto
0.52319 0.54108 lineto
0.49664 0.5501 lineto
0.47166 0.53568 lineto
0.45994 0.50456 lineto
0.46697 0.47131 lineto
0.48945 0.45148 lineto
0.5123 0.45388 lineto
0.53314 0.47455 lineto
0.53847 0.50713 lineto
0.52581 0.53637 lineto
0.50107 0.5486 lineto
0.47583 0.53808 lineto
0.4619 0.50975 lineto
0.4658 0.47685 lineto
0.4857 0.45479 lineto
0.5123 0.45388 lineto
0.52966 0.4711 lineto
0.53758 0.5017 lineto
0.52792 0.5315 lineto
0.50519 0.54656 lineto
0.48003 0.53984 lineto
0.46422 0.51447 lineto
0.46515 0.48234 lineto
0.48238 0.45847 lineto
0.50786 0.45403 lineto
0.52966 0.4711 lineto
Mistroke
0.53626 0.4966 lineto
0.52953 0.52653 lineto
0.50898 0.54405 lineto
0.48422 0.54096 lineto
0.46685 0.5187 lineto
0.46499 0.48769 lineto
0.47951 0.46244 lineto
0.50362 0.45477 lineto
0.52603 0.46826 lineto
0.53626 0.4966 lineto
0.53065 0.52154 lineto
0.5124 0.54113 lineto
0.48835 0.54147 lineto
0.46975 0.52241 lineto
0.4653 0.49286 lineto
0.47709 0.46665 lineto
0.4996 0.45605 lineto
0.52229 0.46601 lineto
0.53456 0.49188 lineto
0.53065 0.52154 lineto
0.51544 0.53787 lineto
0.49236 0.54142 lineto
0.47285 0.52559 lineto
0.46604 0.49779 lineto
0.47513 0.47102 lineto
0.49585 0.45782 lineto
0.51851 0.46435 lineto
0.53251 0.48756 lineto
0.5313 0.5166 lineto
0.51544 0.53787 lineto
0.49621 0.54082 lineto
0.4761 0.52822 lineto
0.46718 0.50242 lineto
0.47361 0.47548 lineto
0.49239 0.46002 lineto
0.51473 0.46326 lineto
0.53018 0.48369 lineto
0.5315 0.51176 lineto
0.51809 0.53432 lineto
0.49621 0.54082 lineto
0.47945 0.53032 lineto
0.46867 0.50672 lineto
0.47254 0.47997 lineto
0.48926 0.46259 lineto
0.51101 0.46272 lineto
0.52761 0.48029 lineto
0.53128 0.50708 lineto
0.52032 0.53056 lineto
0.49985 0.53974 lineto
0.47945 0.53032 lineto
Mistroke
0.47046 0.51065 lineto
0.47189 0.48443 lineto
0.48648 0.46549 lineto
0.50739 0.4627 lineto
0.52484 0.47736 lineto
0.53067 0.50262 lineto
0.52215 0.52665 lineto
0.50326 0.53821 lineto
0.48285 0.53189 lineto
0.47046 0.51065 lineto
0.47166 0.4888 lineto
0.48405 0.46865 lineto
0.5039 0.46316 lineto
0.52193 0.47492 lineto
0.5297 0.49841 lineto
0.52357 0.52264 lineto
0.50641 0.53628 lineto
0.48625 0.53295 lineto
0.47253 0.51419 lineto
0.47166 0.4888 lineto
0.48198 0.47201 lineto
0.50059 0.46408 lineto
0.51893 0.47296 lineto
0.5284 0.49449 lineto
0.52459 0.5186 lineto
0.50927 0.53401 lineto
0.48961 0.5335 lineto
0.47482 0.51732 lineto
0.4718 0.49303 lineto
0.48198 0.47201 lineto
0.49749 0.4654 lineto
0.51587 0.47148 lineto
0.52682 0.4909 lineto
0.52523 0.51458 lineto
0.51183 0.53144 lineto
0.49289 0.53359 lineto
0.47728 0.52002 lineto
0.4723 0.49708 lineto
0.48029 0.47551 lineto
0.49749 0.4654 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureWidth = 431; pictureHeight = 431; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.20099 1.23525 moveto
0.6589 1.62646 lineto
0.04246 1.49059 lineto
-0.35989 0.89122 lineto
-0.35989 0.10878 lineto
0.04246 -0.49059 lineto
0.6589 -0.62646 lineto
1.20099 -0.23525 lineto
1.41507 0.5 lineto
1.20099 1.23525 lineto
0.74925 1.56126 lineto
0.1452 1.51324 lineto
-0.29283 0.99111 lineto
-0.35989 0.23919 lineto
-0.02459 -0.3907 lineto
0.55616 -0.60382 lineto
1.11064 -0.30045 lineto
1.37939 0.37746 lineto
1.23667 1.11271 lineto
0.74925 1.56126 lineto
0.24588 1.52124 lineto
-0.21982 1.07813 lineto
-0.34871 0.36451 lineto
-0.08048 -0.28572 lineto
0.45937 -0.5683 lineto
1.01823 -0.35101 lineto
1.3346 0.26447 lineto
1.26045 0.99016 lineto
0.83048 1.4865 lineto
0.24588 1.52124 lineto
-0.14221 1.15199 lineto
-0.32723 0.48345 lineto
-0.12518 -0.17735 lineto
0.36939 -0.5212 lineto
0.92508 -0.38723 lineto
1.28187 0.16189 lineto
1.27281 0.86922 lineto
0.90215 1.40378 lineto
0.34331 1.51545 lineto
-0.14221 1.15199 lineto
-0.29639 0.59487 lineto
-0.15886 -0.06721 lineto
0.28696 -0.46389 lineto
0.83247 -0.40955 lineto
1.22241 0.07037 lineto
1.27432 0.75133 lineto
0.96392 1.31468 lineto
0.43645 1.49684 lineto
-0.06129 1.21256 lineto
-0.29639 0.59487 lineto
Mistroke
-0.18178 0.04313 lineto
0.21266 -0.39778 lineto
0.74155 -0.41861 lineto
1.15742 -0.00961 lineto
1.26567 0.63784 lineto
1.01566 1.22079 lineto
0.52436 1.46648 lineto
0.02167 1.25994 lineto
-0.25721 0.69782 lineto
-0.18178 0.04313 lineto
0.14692 -0.32429 lineto
0.6534 -0.41514 lineto
1.08811 -0.07778 lineto
1.24763 0.52993 lineto
1.05733 1.12363 lineto
0.60625 1.42553 lineto
0.10545 1.29437 lineto
-0.21073 0.79151 lineto
-0.19435 0.15225 lineto
0.14692 -0.32429 lineto
0.56899 -0.4 lineto
1.01565 -0.13401 lineto
1.22104 0.42864 lineto
1.08904 1.02468 lineto
0.68143 1.37522 lineto
0.18892 1.31623 lineto
-0.15803 0.87532 lineto
-0.19708 0.25879 lineto
0.09004 -0.24487 lineto
0.56899 -0.4 lineto
0.94121 -0.17834 lineto
1.18681 0.33487 lineto
1.11104 0.92534 lineto
0.74936 1.31679 lineto
0.271 1.32606 lineto
-0.10021 0.9488 lineto
-0.19057 0.36155 lineto
0.04219 -0.16093 lineto
0.48916 -0.37414 lineto
0.94121 -0.17834 lineto
1.14588 0.24933 lineto
1.12367 0.82693 lineto
0.80964 1.25155 lineto
0.35073 1.32451 lineto
-0.03834 1.01168 lineto
-0.17551 0.45942 lineto
0.0034 -0.07385 lineto
0.41467 -0.33861 lineto
0.86587 -0.21097 lineto
1.14588 0.24933 lineto
Mistroke
1.12737 0.73066 lineto
0.86198 1.18078 lineto
0.42721 1.31235 lineto
0.02651 1.06382 lineto
-0.15265 0.55146 lineto
-0.02642 0.01503 lineto
0.34612 -0.29448 lineto
0.79067 -0.23225 lineto
1.09921 0.17262 lineto
1.12737 0.73066 lineto
0.90621 1.10576 lineto
0.49968 1.29042 lineto
0.09329 1.10524 lineto
-0.12279 0.63686 lineto
-0.04746 0.10444 lineto
0.28403 -0.2429 lineto
0.71658 -0.24262 lineto
1.04778 0.10514 lineto
1.12268 0.63766 lineto
0.90621 1.10576 lineto
0.56743 1.25965 lineto
0.16102 1.1361 lineto
-0.08678 0.71492 lineto
-0.06002 0.19317 lineto
0.22878 -0.18501 lineto
0.64449 -0.24266 lineto
0.99258 0.04718 lineto
1.11019 0.5489 lineto
0.94229 1.02774 lineto
0.56743 1.25965 lineto
0.22876 1.15669 lineto
-0.04548 0.78512 lineto
-0.06448 0.28013 lineto
0.18065 -0.12198 lineto
0.5752 -0.23305 lineto
0.93457 -0.00113 lineto
1.09059 0.46528 lineto
0.97027 0.94794 lineto
0.62991 1.221 lineto
0.22876 1.15669 lineto
0.00023 0.84705 lineto
-0.06131 0.36429 lineto
0.1398 -0.05496 lineto
0.50944 -0.21454 lineto
0.87467 -0.03978 lineto
1.06459 0.38755 lineto
0.99033 0.86749 lineto
0.68664 1.17549 lineto
0.29562 1.16741 lineto
0.00023 0.84705 lineto
Mistroke
-0.05105 0.44475 lineto
0.10628 0.01492 lineto
0.44784 -0.18794 lineto
0.8138 -0.06891 lineto
1.03294 0.31633 lineto
1.0027 0.7875 lineto
0.73725 1.12416 lineto
0.36079 1.16876 lineto
0.04946 0.90044 lineto
-0.05105 0.44475 lineto
0.08006 0.08656 lineto
0.39091 -0.15413 lineto
0.75281 -0.08875 lineto
0.99641 0.25212 lineto
1.00774 0.70897 lineto
0.78149 1.06805 lineto
0.42353 1.16132 lineto
0.10135 0.94516 lineto
-0.0343 0.5207 lineto
0.08006 0.08656 lineto
0.3391 -0.11402 lineto
0.69249 -0.09965 lineto
0.95581 0.19531 lineto
1.00585 0.63283 lineto
0.8192 1.0082 lineto
0.48319 1.14578 lineto
0.15504 0.98119 lineto
-0.01169 0.59144 lineto
0.061 0.15891 lineto
0.3391 -0.11402 lineto
0.63359 -0.10204 lineto
0.91193 0.14615 lineto
0.99751 0.55991 lineto
0.85031 0.94564 lineto
0.53919 1.12285 lineto
0.20974 1.00862 lineto
0.0161 0.6564 lineto
0.04888 0.231 lineto
0.29275 -0.06853 lineto
0.63359 -0.10204 lineto
0.86554 0.10478 lineto
0.98325 0.49095 lineto
0.87484 0.88135 lineto
0.59104 1.09331 lineto
0.26464 1.02766 lineto
0.04837 0.7151 lineto
0.04342 0.3019 lineto
0.25211 -0.01861 lineto
0.57679 -0.09646 lineto
0.86554 0.10478 lineto
Mistroke
0.96363 0.42659 lineto
0.89291 0.81628 lineto
0.63834 1.05799 lineto
0.31904 1.0386 lineto
0.08442 0.7672 lineto
0.04424 0.37077 lineto
0.21732 0.03481 lineto
0.52267 -0.08348 lineto
0.81741 0.07124 lineto
0.96363 0.42659 lineto
0.9047 0.75134 lineto
0.68077 1.0177 lineto
0.37226 1.04183 lineto
0.12352 0.81243 lineto
0.05094 0.43684 lineto
0.18848 0.0908 lineto
0.47178 -0.06377 lineto
0.76829 0.04546 lineto
0.93926 0.36737 lineto
0.9047 0.75134 lineto
0.71809 0.97331 lineto
0.42368 1.03781 lineto
0.16498 0.85066 lineto
0.06304 0.49944 lineto
0.16555 0.14848 lineto
0.42456 -0.038 lineto
0.71887 0.02725 lineto
0.91077 0.31371 lineto
0.91046 0.68734 lineto
0.71809 0.97331 lineto
0.47275 1.02706 lineto
0.20809 0.88186 lineto
0.08003 0.55798 lineto
0.14847 0.20697 lineto
0.3814 -0.00692 lineto
0.66982 0.01638 lineto
0.87878 0.26597 lineto
0.91051 0.62507 lineto
0.75015 0.92565 lineto
0.47275 1.02706 lineto
0.2522 0.90606 lineto
0.10137 0.61196 lineto
0.13706 0.26547 lineto
0.34257 0.02872 lineto
0.62175 0.01249 lineto
0.84396 0.22437 lineto
0.90522 0.56522 lineto
0.77688 0.87555 lineto
0.51898 1.01016 lineto
0.2522 0.90606 lineto
Mistroke
0.12651 0.66097 lineto
0.13111 0.32322 lineto
0.30832 0.06818 lineto
0.57522 0.0152 lineto
0.80692 0.18906 lineto
0.89501 0.50841 lineto
0.79827 0.82383 lineto
0.56197 0.98772 lineto
0.29667 0.92341 lineto
0.12651 0.66097 lineto
0.13035 0.37951 lineto
0.27879 0.11069 lineto
0.53074 0.02403 lineto
0.7683 0.16008 lineto
0.88033 0.45519 lineto
0.81439 0.77126 lineto
0.60135 0.96041 lineto
0.34088 0.93413 lineto
0.15487 0.70471 lineto
0.13035 0.37951 lineto
0.25405 0.15549 lineto
0.48875 0.03847 lineto
0.72871 0.13741 lineto
0.86166 0.406 lineto
0.82538 0.71858 lineto
0.63686 0.92888 lineto
0.38429 0.93851 lineto
0.18587 0.74295 lineto
0.13443 0.43371 lineto
0.25405 0.15549 lineto
0.44963 0.05798 lineto
0.68872 0.12092 lineto
0.8395 0.36124 lineto
0.83143 0.66648 lineto
0.66828 0.89383 lineto
0.42639 0.9369 lineto
0.21894 0.77554 lineto
0.14301 0.48525 lineto
0.23411 0.20186 lineto
0.44963 0.05798 lineto
0.64887 0.11043 lineto
0.81437 0.32118 lineto
0.83277 0.61561 lineto
0.69547 0.85594 lineto
0.4667 0.92972 lineto
0.25352 0.80243 lineto
0.15566 0.53363 lineto
0.21893 0.24909 lineto
0.41371 0.08196 lineto
0.64887 0.11043 lineto
Mistroke
0.78679 0.28606 lineto
0.82971 0.56654 lineto
0.71835 0.81589 lineto
0.50483 0.91743 lineto
0.28905 0.82365 lineto
0.17197 0.57843 lineto
0.20838 0.29652 lineto
0.38125 0.10981 lineto
0.60967 0.10568 lineto
0.78679 0.28606 lineto
0.82255 0.51979 lineto
0.73691 0.77433 lineto
0.54042 0.9005 lineto
0.32501 0.83928 lineto
0.19148 0.6193 lineto
0.20231 0.3435 lineto
0.35244 0.14093 lineto
0.5716 0.10637 lineto
0.75727 0.25599 lineto
0.82255 0.51979 lineto
0.75119 0.73191 lineto
0.57317 0.87947 lineto
0.36091 0.84948 lineto
0.21374 0.65596 lineto
0.20051 0.38947 lineto
0.32742 0.17469 lineto
0.53508 0.11213 lineto
0.72632 0.23106 lineto
0.81167 0.47583 lineto
0.75119 0.73191 lineto
0.60284 0.85488 lineto
0.39629 0.85448 lineto
0.23827 0.68822 lineto
0.20271 0.43388 lineto
0.30626 0.21049 lineto
0.50047 0.12256 lineto
0.69445 0.21124 lineto
0.79745 0.43503 lineto
0.76127 0.68923 lineto
0.60284 0.85488 lineto
0.43071 0.85455 lineto
0.2646 0.71593 lineto
0.20864 0.47627 lineto
0.28901 0.24772 lineto
0.4681 0.13721 lineto
0.66212 0.19646 lineto
0.78028 0.39773 lineto
0.7673 0.64686 lineto
0.62924 0.82727 lineto
0.43071 0.85455 lineto
Mistroke
0.29229 0.73903 lineto
0.21797 0.51622 lineto
0.27561 0.28581 lineto
0.43825 0.15563 lineto
0.62978 0.18658 lineto
0.76059 0.36419 lineto
0.76946 0.60534 lineto
0.65225 0.7972 lineto
0.4638 0.85 lineto
0.29229 0.73903 lineto
0.23035 0.55335 lineto
0.266 0.32421 lineto
0.41114 0.17733 lineto
0.59786 0.18142 lineto
0.73879 0.33459 lineto
0.76798 0.56515 lineto
0.67179 0.76522 lineto
0.49521 0.8412 lineto
0.32087 0.75753 lineto
0.23035 0.55335 lineto
0.26006 0.3624 lineto
0.38695 0.20181 lineto
0.56674 0.18074 lineto
0.7153 0.30906 lineto
0.76312 0.52672 lineto
0.68782 0.73188 lineto
0.52464 0.82854 lineto
0.34993 0.77147 lineto
0.24544 0.58738 lineto
0.26006 0.3624 lineto
0.3658 0.22857 lineto
0.53678 0.18425 lineto
0.69054 0.28767 lineto
0.75515 0.49044 lineto
0.70037 0.69768 lineto
0.55184 0.81243 lineto
0.37905 0.78098 lineto
0.26286 0.61806 lineto
0.25763 0.3999 lineto
0.3658 0.22857 lineto
0.50828 0.19164 lineto
0.66491 0.27044 lineto
0.74438 0.45665 lineto
0.7095 0.66314 lineto
0.57659 0.7933 lineto
0.40785 0.78622 lineto
0.28222 0.64522 lineto
0.2585 0.43626 lineto
0.34777 0.25713 lineto
0.50828 0.19164 lineto
Mistroke
0.63881 0.2573 lineto
0.73113 0.42561 lineto
0.71531 0.62873 lineto
0.59874 0.77161 lineto
0.43597 0.7874 lineto
0.30316 0.66872 lineto
0.26245 0.47109 lineto
0.3329 0.28698 lineto
0.48153 0.20255 lineto
0.63881 0.2573 lineto
0.71575 0.39756 lineto
0.71795 0.59488 lineto
0.61817 0.7478 lineto
0.4631 0.78477 lineto
0.32529 0.6885 lineto
0.26924 0.50402 lineto
0.32115 0.31767 lineto
0.45676 0.21663 lineto
0.61259 0.24818 lineto
0.71575 0.39756 lineto
0.71758 0.56199 lineto
0.6348 0.72231 lineto
0.48894 0.77861 lineto
0.34826 0.70454 lineto
0.27858 0.53477 lineto
0.3125 0.34873 lineto
0.43416 0.23347 lineto
0.58662 0.24292 lineto
0.69855 0.37266 lineto
0.71758 0.56199 lineto
0.6486 0.69559 lineto
0.51325 0.76923 lineto
0.37171 0.71689 lineto
0.29019 0.56307 lineto
0.30685 0.37973 lineto
0.41388 0.25268 lineto
0.56121 0.24134 lineto
0.6799 0.35104 lineto
0.71441 0.53044 lineto
0.6486 0.69559 lineto
0.53581 0.75695 lineto
0.3953 0.72561 lineto
0.30378 0.5887 lineto
0.30407 0.41029 lineto
0.39604 0.27385 lineto
0.53666 0.24323 lineto
0.66012 0.33276 lineto
0.70866 0.50054 lineto
0.65957 0.66806 lineto
0.53581 0.75695 lineto
Mistroke
0.41872 0.73084 lineto
0.31903 0.61152 lineto
0.30402 0.44003 lineto
0.38071 0.29659 lineto
0.51322 0.24834 lineto
0.63954 0.31784 lineto
0.70057 0.47257 lineto
0.66775 0.64014 lineto
0.55644 0.74214 lineto
0.41872 0.73084 lineto
0.33565 0.63141 lineto
0.30652 0.46861 lineto
0.36793 0.3205 lineto
0.49114 0.25638 lineto
0.61849 0.30625 lineto
0.6904 0.44678 lineto
0.67322 0.61221 lineto
0.57499 0.72514 lineto
0.44167 0.73272 lineto
0.33565 0.63141 lineto
0.31138 0.49574 lineto
0.3577 0.34518 lineto
0.4706 0.26707 lineto
0.59726 0.29794 lineto
0.67841 0.42336 lineto
0.67608 0.58464 lineto
0.59136 0.70632 lineto
0.46389 0.73146 lineto
0.35332 0.64829 lineto
0.31138 0.49574 lineto
0.34998 0.37028 lineto
0.45178 0.28008 lineto
0.57615 0.29279 lineto
0.66489 0.40246 lineto
0.67647 0.55776 lineto
0.60548 0.68604 lineto
0.48514 0.72727 lineto
0.37175 0.66215 lineto
0.31837 0.52117 lineto
0.34998 0.37028 lineto
0.43482 0.29512 lineto
0.55542 0.29068 lineto
0.6501 0.38418 lineto
0.67454 0.53188 lineto
0.61731 0.66466 lineto
0.50519 0.7204 lineto
0.39064 0.67301 lineto
0.32726 0.54466 lineto
0.34471 0.39542 lineto
0.43482 0.29512 lineto
Mistroke
0.53532 0.29142 lineto
0.63432 0.3686 lineto
0.67047 0.50726 lineto
0.62685 0.64253 lineto
0.52388 0.71111 lineto
0.40974 0.6809 lineto
0.33783 0.56605 lineto
0.3418 0.4203 lineto
0.4198 0.31183 lineto
0.53532 0.29142 lineto
0.61782 0.35573 lineto
0.66444 0.48415 lineto
0.63412 0.61999 lineto
0.54104 0.69968 lineto
0.42876 0.68594 lineto
0.34981 0.5852 lineto
0.34114 0.44459 lineto
0.4068 0.32991 lineto
0.51607 0.29482 lineto
0.61782 0.35573 lineto
0.65667 0.46275 lineto
0.63917 0.59735 lineto
0.55655 0.68639 lineto
0.44747 0.68823 lineto
0.36297 0.60199 lineto
0.34258 0.46802 lineto
0.39586 0.34902 lineto
0.49786 0.30067 lineto
0.60086 0.34558 lineto
0.65667 0.46275 lineto
0.64209 0.57491 lineto
0.57032 0.67155 lineto
0.46565 0.68792 lineto
0.37705 0.61636 lineto
0.34598 0.49035 lineto
0.38698 0.36886 lineto
0.48086 0.30873 lineto
0.58369 0.3381 lineto
0.64737 0.44322 lineto
0.64209 0.57491 lineto
0.58228 0.65545 lineto
0.4831 0.68519 lineto
0.39182 0.62829 lineto
0.35116 0.51135 lineto
0.38014 0.38911 lineto
0.46521 0.31875 lineto
0.56655 0.3332 lineto
0.63676 0.4257 lineto
0.64297 0.55296 lineto
0.58228 0.65545 lineto
Mistroke
0.49963 0.68024 lineto
0.40703 0.63777 lineto
0.35794 0.53084 lineto
0.37531 0.40948 lineto
0.45103 0.33048 lineto
0.54966 0.33079 lineto
0.62506 0.41028 lineto
0.64193 0.53175 lineto
0.5924 0.63837 lineto
0.49963 0.68024 lineto
0.42247 0.64485 lineto
0.36612 0.54866 lineto
0.37242 0.42971 lineto
0.43841 0.34364 lineto
0.53322 0.33074 lineto
0.61249 0.39703 lineto
0.63912 0.51151 lineto
0.60065 0.6206 lineto
0.51509 0.67326 lineto
0.42247 0.64485 lineto
0.37551 0.56469 lineto
0.37137 0.44953 lineto
0.42741 0.35799 lineto
0.51742 0.33289 lineto
0.59928 0.38599 lineto
0.63468 0.49243 lineto
0.60707 0.60242 lineto
0.52935 0.66448 lineto
0.4379 0.64958 lineto
0.37551 0.56469 lineto
0.37206 0.46873 lineto
0.41807 0.37325 lineto
0.50242 0.33707 lineto
0.58564 0.37714 lineto
0.62878 0.47469 lineto
0.61167 0.58408 lineto
0.5423 0.65414 lineto
0.45315 0.65207 lineto
0.38591 0.57884 lineto
0.37206 0.46873 lineto
0.4104 0.38916 lineto
0.48836 0.3431 lineto
0.57177 0.37046 lineto
0.62159 0.45843 lineto
0.61452 0.56585 lineto
0.55386 0.64246 lineto
0.468 0.65241 lineto
0.39712 0.59105 lineto
0.37437 0.48708 lineto
0.4104 0.38916 lineto
Mistroke
0.47537 0.35078 lineto
0.55787 0.3659 lineto
0.61329 0.44377 lineto
0.6157 0.54795 lineto
0.56397 0.62969 lineto
0.48231 0.65075 lineto
0.40893 0.60127 lineto
0.37816 0.50441 lineto
0.4044 0.40548 lineto
0.47537 0.35078 lineto
0.54412 0.36338 lineto
0.60405 0.43079 lineto
0.6153 0.53059 lineto
0.5726 0.61607 lineto
0.49592 0.64724 lineto
0.42116 0.60952 lineto
0.38329 0.52055 lineto
0.40002 0.42197 lineto
0.46354 0.35989 lineto
0.54412 0.36338 lineto
0.59406 0.41955 lineto
0.61342 0.51395 lineto
0.57971 0.60182 lineto
0.5087 0.64205 lineto
0.43362 0.61581 lineto
0.3896 0.53538 lineto
0.39724 0.4384 lineto
0.45296 0.37024 lineto
0.53069 0.3628 lineto
0.59406 0.41955 lineto
0.6102 0.49822 lineto
0.58533 0.58718 lineto
0.52054 0.63534 lineto
0.44614 0.62018 lineto
0.39694 0.54878 lineto
0.39596 0.45456 lineto
0.44367 0.3816 lineto
0.51773 0.36404 lineto
0.5835 0.4101 lineto
0.6102 0.49822 lineto
0.58947 0.57235 lineto
0.53134 0.62732 lineto
0.45854 0.62271 lineto
0.40514 0.56068 lineto
0.39612 0.47027 lineto
0.43572 0.39376 lineto
0.50539 0.36697 lineto
0.57254 0.40242 lineto
0.60575 0.48353 lineto
0.58947 0.57235 lineto
Mistroke
0.54103 0.61815 lineto
0.47067 0.62348 lineto
0.41404 0.57102 lineto
0.39763 0.48534 lineto
0.42912 0.40651 lineto
0.49378 0.37143 lineto
0.56135 0.39651 lineto
0.60021 0.47001 lineto
0.59219 0.55755 lineto
0.54103 0.61815 lineto
0.4824 0.62259 lineto
0.42348 0.57976 lineto
0.40036 0.49962 lineto
0.42387 0.41965 lineto
0.483 0.37728 lineto
0.55009 0.39233 lineto
0.59373 0.45776 lineto
0.59352 0.54296 lineto
0.54955 0.60805 lineto
0.4824 0.62259 lineto
0.4333 0.5869 lineto
0.40421 0.51297 lineto
0.41995 0.43298 lineto
0.47315 0.38434 lineto
0.5389 0.38982 lineto
0.58646 0.44686 lineto
0.59356 0.52876 lineto
0.55688 0.5972 lineto
0.49359 0.62017 lineto
0.4333 0.5869 lineto
0.40906 0.5253 lineto
0.41733 0.44631 lineto
0.46428 0.39245 lineto
0.52794 0.38891 lineto
0.57853 0.43735 lineto
0.59238 0.51511 lineto
0.56299 0.5858 lineto
0.50414 0.61634 lineto
0.44334 0.59245 lineto
0.40906 0.5253 lineto
0.41595 0.45947 lineto
0.45645 0.40142 lineto
0.51733 0.3895 lineto
0.5701 0.42928 lineto
0.59007 0.50215 lineto
0.56789 0.57402 lineto
0.51395 0.61125 lineto
0.45348 0.59643 lineto
0.41477 0.53649 lineto
0.41595 0.45947 lineto
Mistroke
0.4497 0.4111 lineto
0.50719 0.39149 lineto
0.56131 0.42265 lineto
0.58674 0.49 lineto
0.57159 0.56204 lineto
0.52294 0.60504 lineto
0.46355 0.5989 lineto
0.42123 0.54648 lineto
0.41576 0.47231 lineto
0.4497 0.4111 lineto
0.49761 0.39475 lineto
0.55229 0.41745 lineto
0.5825 0.47878 lineto
0.57411 0.55003 lineto
0.53105 0.59788 lineto
0.47345 0.59992 lineto
0.42828 0.55521 lineto
0.41667 0.48467 lineto
0.44405 0.4213 lineto
0.49761 0.39475 lineto
0.54317 0.41367 lineto
0.57747 0.46856 lineto
0.57551 0.53816 lineto
0.53822 0.5899 lineto
0.48305 0.59958 lineto
0.43581 0.56267 lineto
0.4186 0.49643 lineto
0.43948 0.43186 lineto
0.48868 0.39918 lineto
0.54317 0.41367 lineto
0.57175 0.45941 lineto
0.57584 0.52656 lineto
0.54444 0.58128 lineto
0.49225 0.59797 lineto
0.44368 0.56882 lineto
0.42147 0.50747 lineto
0.436 0.44262 lineto
0.48048 0.40463 lineto
0.53409 0.41126 lineto
0.57175 0.45941 lineto
0.57516 0.51537 lineto
0.54967 0.57216 lineto
0.50095 0.59519 lineto
0.45178 0.57368 lineto
0.42517 0.51769 lineto
0.43358 0.45343 lineto
0.47307 0.41096 lineto
0.52516 0.41015 lineto
0.56547 0.45138 lineto
0.57516 0.51537 lineto
Mistroke
0.55392 0.56269 lineto
0.50907 0.59135 lineto
0.45997 0.57726 lineto
0.42961 0.52702 lineto
0.43218 0.46414 lineto
0.46649 0.41804 lineto
0.51647 0.41028 lineto
0.55875 0.44451 lineto
0.57354 0.5047 lineto
0.55392 0.56269 lineto
0.51654 0.58657 lineto
0.46815 0.57961 lineto
0.43467 0.5354 lineto
0.43175 0.47462 lineto
0.46077 0.42572 lineto
0.50814 0.41158 lineto
0.55171 0.43881 lineto
0.57108 0.49467 lineto
0.55719 0.55303 lineto
0.51654 0.58657 lineto
0.47622 0.58077 lineto
0.44025 0.54276 lineto
0.43224 0.48475 lineto
0.45593 0.43387 lineto
0.50025 0.41393 lineto
0.54445 0.43427 lineto
0.56785 0.48536 lineto
0.5595 0.5433 lineto
0.52332 0.58098 lineto
0.47622 0.58077 lineto
0.44624 0.5491 lineto
0.43357 0.49442 lineto
0.45198 0.44235 lineto
0.49286 0.41726 lineto
0.53708 0.43088 lineto
0.56395 0.47684 lineto
0.5609 0.53364 lineto
0.52935 0.5747 lineto
0.48407 0.5808 lineto
0.44624 0.5491 lineto
0.43568 0.50353 lineto
0.44891 0.45103 lineto
0.48605 0.42144 lineto
0.52971 0.42861 lineto
0.55947 0.46918 lineto
0.5614 0.52418 lineto
0.53461 0.56786 lineto
0.49161 0.57979 lineto
0.45255 0.55438 lineto
0.43568 0.50353 lineto
Mistroke
0.44671 0.45978 lineto
0.47986 0.42637 lineto
0.52243 0.42741 lineto
0.55451 0.46242 lineto
0.56108 0.51501 lineto
0.53907 0.56058 lineto
0.49878 0.5778 lineto
0.45906 0.55862 lineto
0.43849 0.51201 lineto
0.44671 0.45978 lineto
0.47433 0.43194 lineto
0.51534 0.42724 lineto
0.54916 0.45659 lineto
0.55999 0.50625 lineto
0.54274 0.55298 lineto
0.5055 0.57493 lineto
0.46568 0.56181 lineto
0.44192 0.51978 lineto
0.44534 0.46848 lineto
0.47433 0.43194 lineto
0.5085 0.42802 lineto
0.54353 0.4517 lineto
0.55818 0.49797 lineto
0.54561 0.54519 lineto
0.5117 0.57127 lineto
0.47231 0.564 lineto
0.44588 0.52678 lineto
0.44477 0.47703 lineto
0.4695 0.43803 lineto
0.5085 0.42802 lineto
0.53769 0.44775 lineto
0.55574 0.49026 lineto
0.54771 0.53732 lineto
0.51735 0.56693 lineto
0.47888 0.56521 lineto
0.45029 0.53299 lineto
0.44496 0.48532 lineto
0.46538 0.44453 lineto
0.502 0.42969 lineto
0.53769 0.44775 lineto
0.55273 0.48317 lineto
0.54905 0.52948 lineto
0.52241 0.56199 lineto
0.48529 0.5655 lineto
0.45505 0.53836 lineto
0.44584 0.49327 lineto
0.46198 0.45133 lineto
0.4959 0.43216 lineto
0.53174 0.44474 lineto
0.55273 0.48317 lineto
Mistroke
0.54966 0.52176 lineto
0.52685 0.55657 lineto
0.49148 0.56491 lineto
0.46009 0.54288 lineto
0.44738 0.50078 lineto
0.45929 0.45832 lineto
0.49025 0.43536 lineto
0.52577 0.44264 lineto
0.54923 0.47677 lineto
0.54966 0.52176 lineto
0.53065 0.55077 lineto
0.49737 0.56352 lineto
0.46532 0.54655 lineto
0.4495 0.5078 lineto
0.4573 0.4654 lineto
0.48509 0.43919 lineto
0.51985 0.44143 lineto
0.54532 0.47108 lineto
0.54959 0.51426 lineto
0.53065 0.55077 lineto
0.50292 0.5614 lineto
0.47067 0.54938 lineto
0.45214 0.51426 lineto
0.456 0.47246 lineto
0.48046 0.44355 lineto
0.51405 0.44106 lineto
0.54108 0.46614 lineto
0.54888 0.50707 lineto
0.53381 0.54469 lineto
0.50292 0.5614 lineto
0.47604 0.55138 lineto
0.45522 0.52011 lineto
0.45536 0.47943 lineto
0.47638 0.44837 lineto
0.50845 0.44147 lineto
0.53657 0.46196 lineto
0.54758 0.50024 lineto
0.53632 0.53842 lineto
0.50807 0.55861 lineto
0.47604 0.55138 lineto
0.45869 0.52532 lineto
0.45533 0.48621 lineto
0.47288 0.45355 lineto
0.50311 0.44262 lineto
0.53189 0.45854 lineto
0.54574 0.49386 lineto
0.5382 0.53205 lineto
0.51278 0.55525 lineto
0.48138 0.55259 lineto
0.45869 0.52532 lineto
Mistroke
0.45589 0.49273 lineto
0.46995 0.45899 lineto
0.49807 0.44444 lineto
0.52709 0.45589 lineto
0.54344 0.48798 lineto
0.53946 0.52569 lineto
0.51701 0.55138 lineto
0.48661 0.55303 lineto
0.46247 0.52987 lineto
0.45589 0.49273 lineto
0.46761 0.46461 lineto
0.49338 0.44687 lineto
0.52225 0.45398 lineto
0.54071 0.48263 lineto
0.54012 0.5194 lineto
0.52076 0.5471 lineto
0.49168 0.55276 lineto
0.4665 0.53373 lineto
0.45699 0.49892 lineto
0.46761 0.46461 lineto
0.48909 0.44983 lineto
0.51744 0.4528 lineto
0.53763 0.47785 lineto
0.54022 0.51327 lineto
0.52398 0.54248 lineto
0.49653 0.55181 lineto
0.47069 0.5369 lineto
0.45858 0.50472 lineto
0.46584 0.47033 lineto
0.48909 0.44983 lineto
0.51272 0.4523 lineto
0.53427 0.47368 lineto
0.53979 0.50737 lineto
0.52669 0.53762 lineto
0.5011 0.55026 lineto
0.475 0.53939 lineto
0.4606 0.51008 lineto
0.46463 0.47606 lineto
0.48521 0.45324 lineto
0.51272 0.4523 lineto
0.53068 0.47012 lineto
0.53887 0.50176 lineto
0.52887 0.53257 lineto
0.50537 0.54815 lineto
0.47935 0.5412 lineto
0.463 0.51497 lineto
0.46396 0.48173 lineto
0.48178 0.45705 lineto
0.50813 0.45246 lineto
0.53068 0.47012 lineto
Mistroke
0.5375 0.49648 lineto
0.53054 0.52744 lineto
0.50928 0.54556 lineto
0.48369 0.54236 lineto
0.46572 0.51934 lineto
0.4638 0.48727 lineto
0.47881 0.46116 lineto
0.50374 0.45322 lineto
0.52692 0.46717 lineto
0.5375 0.49648 lineto
0.5317 0.52228 lineto
0.51283 0.54254 lineto
0.48795 0.54289 lineto
0.46872 0.52317 lineto
0.46412 0.49262 lineto
0.47631 0.46551 lineto
0.49959 0.45455 lineto
0.52306 0.46485 lineto
0.53574 0.4916 lineto
0.5317 0.52228 lineto
0.51597 0.53916 lineto
0.4921 0.54283 lineto
0.47192 0.52646 lineto
0.46488 0.49771 lineto
0.47428 0.47003 lineto
0.49571 0.45637 lineto
0.51914 0.46313 lineto
0.53362 0.48714 lineto
0.53237 0.51717 lineto
0.51597 0.53916 lineto
0.49608 0.54222 lineto
0.47528 0.52919 lineto
0.46606 0.5025 lineto
0.47271 0.47464 lineto
0.49214 0.45865 lineto
0.51524 0.462 lineto
0.53121 0.48314 lineto
0.53258 0.51216 lineto
0.5187 0.53549 lineto
0.49608 0.54222 lineto
0.47875 0.53136 lineto
0.46759 0.50695 lineto
0.4716 0.47929 lineto
0.4889 0.46132 lineto
0.51139 0.46145 lineto
0.52855 0.47962 lineto
0.53235 0.50732 lineto
0.52102 0.5316 lineto
0.49985 0.5411 lineto
0.47875 0.53136 lineto
Mistroke
0.46945 0.51102 lineto
0.47093 0.4839 lineto
0.48602 0.46431 lineto
0.50764 0.46142 lineto
0.52569 0.47659 lineto
0.53172 0.50271 lineto
0.52291 0.52756 lineto
0.50338 0.53952 lineto
0.48227 0.53298 lineto
0.46945 0.51102 lineto
0.47069 0.48842 lineto
0.4835 0.46758 lineto
0.50404 0.46191 lineto
0.52268 0.47406 lineto
0.53071 0.49835 lineto
0.52438 0.52342 lineto
0.50663 0.53752 lineto
0.48578 0.53407 lineto
0.47159 0.51468 lineto
0.47069 0.48842 lineto
0.48137 0.47105 lineto
0.50061 0.46285 lineto
0.51957 0.47203 lineto
0.52937 0.4943 lineto
0.52543 0.51924 lineto
0.50959 0.53517 lineto
0.48926 0.53465 lineto
0.47396 0.51791 lineto
0.47084 0.49279 lineto
0.48137 0.47105 lineto
0.49741 0.46422 lineto
0.51641 0.4705 lineto
0.52774 0.49059 lineto
0.52609 0.51508 lineto
0.51223 0.53252 lineto
0.49265 0.53473 lineto
0.47651 0.5207 lineto
0.47136 0.49698 lineto
0.47961 0.47467 lineto
0.49741 0.46422 lineto
0.51325 0.46946 lineto
0.52585 0.48724 lineto
0.52636 0.511 lineto
0.51454 0.52961 lineto
0.49591 0.53436 lineto
0.4792 0.52304 lineto
0.47222 0.50093 lineto
0.47824 0.47839 lineto
0.49444 0.46596 lineto
0.51325 0.46946 lineto
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; endGroup; pictureWidth = 431; pictureHeight = 431; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
1.22494 1.26037 moveto
0.66433 1.66495 lineto
0.02683 1.52444 lineto
-0.38927 0.90458 lineto
-0.38927 0.09542 lineto
0.02683 -0.52444 lineto
0.66433 -0.66495 lineto
1.22494 -0.26037 lineto
1.44634 0.5 lineto
1.22494 1.26037 lineto
0.75776 1.59752 lineto
0.13308 1.54786 lineto
-0.31992 1.00789 lineto
-0.38927 0.23028 lineto
-0.04252 -0.42113 lineto
0.55808 -0.64153 lineto
1.1315 -0.3278 lineto
1.40944 0.37327 lineto
1.26184 1.13364 lineto
0.75776 1.59752 lineto
0.23719 1.55614 lineto
-0.24442 1.09789 lineto
-0.37771 0.35988 lineto
-0.10031 -0.31256 lineto
0.45798 -0.6048 lineto
1.03593 -0.38009 lineto
1.36312 0.25643 lineto
1.28644 1.00691 lineto
0.84178 1.52021 lineto
0.23719 1.55614 lineto
-0.16415 1.17426 lineto
-0.35549 0.48288 lineto
-0.14654 -0.20049 lineto
0.36493 -0.55609 lineto
0.93961 -0.41754 lineto
1.30859 0.15034 lineto
1.29922 0.88183 lineto
0.91589 1.43466 lineto
0.33796 1.55015 lineto
-0.16415 1.17426 lineto
-0.3236 0.59811 lineto
-0.18137 -0.08659 lineto
0.27969 -0.49683 lineto
0.84383 -0.44063 lineto
1.24709 0.05569 lineto
1.30078 0.75992 lineto
0.97978 1.34252 lineto
0.43428 1.5309 lineto
-0.08046 1.23691 lineto
-0.3236 0.59811 lineto
Mistroke
-0.20507 0.02752 lineto
0.20284 -0.42845 lineto
0.7498 -0.45 lineto
1.17988 -0.02703 lineto
1.29183 0.64255 lineto
1.03328 1.24542 lineto
0.5252 1.4995 lineto
0.00533 1.28591 lineto
-0.28308 0.70458 lineto
-0.20507 0.02752 lineto
0.13486 -0.35246 lineto
0.65864 -0.44641 lineto
1.1082 -0.09752 lineto
1.27317 0.53095 lineto
1.07637 1.14494 lineto
0.60988 1.45716 lineto
0.09197 1.32151 lineto
-0.23501 0.80147 lineto
-0.21808 0.14037 lineto
0.13486 -0.35246 lineto
0.57135 -0.43075 lineto
1.03327 -0.15567 lineto
1.24568 0.42621 lineto
1.10917 1.04261 lineto
0.68762 1.40512 lineto
0.17829 1.34412 lineto
-0.18052 0.88814 lineto
-0.2209 0.25055 lineto
0.07604 -0.27032 lineto
0.57135 -0.43075 lineto
0.95629 -0.20152 lineto
1.21028 0.32923 lineto
1.13192 0.93988 lineto
0.75788 1.3447 lineto
0.26318 1.35428 lineto
-0.12071 0.96414 lineto
-0.21417 0.35681 lineto
0.02655 -0.18351 lineto
0.48879 -0.40401 lineto
0.95629 -0.20152 lineto
1.16794 0.24077 lineto
1.14498 0.8381 lineto
0.82022 1.27723 lineto
0.34563 1.35269 lineto
-0.05673 1.02916 lineto
-0.19859 0.45803 lineto
-0.01357 -0.09346 lineto
0.41175 -0.36726 lineto
0.87837 -0.23527 lineto
1.16794 0.24077 lineto
Mistroke
1.14881 0.73855 lineto
0.87435 1.20404 lineto
0.42473 1.34011 lineto
0.01033 1.08308 lineto
-0.17495 0.55322 lineto
-0.04441 -0.00154 lineto
0.34087 -0.32163 lineto
0.8006 -0.25726 lineto
1.11968 0.16143 lineto
1.14881 0.73855 lineto
0.92009 1.12646 lineto
0.49966 1.31743 lineto
0.07939 1.12592 lineto
-0.14407 0.64153 lineto
-0.06617 0.09092 lineto
0.27665 -0.26828 lineto
0.72398 -0.26799 lineto
1.0665 0.09165 lineto
1.14395 0.64236 lineto
0.92009 1.12646 lineto
0.56974 1.2856 lineto
0.14944 1.15784 lineto
-0.10683 0.72226 lineto
-0.07915 0.18269 lineto
0.21952 -0.20841 lineto
0.64942 -0.26804 lineto
1.00941 0.03171 lineto
1.13104 0.55057 lineto
0.9574 1.04578 lineto
0.56974 1.2856 lineto
0.21949 1.17913 lineto
-0.06411 0.79486 lineto
-0.08376 0.27262 lineto
0.16974 -0.14323 lineto
0.57777 -0.2581 lineto
0.94942 -0.01825 lineto
1.11077 0.4641 lineto
0.98634 0.96324 lineto
0.63435 1.24563 lineto
0.21949 1.17913 lineto
-0.01685 0.8589 lineto
-0.08049 0.35966 lineto
0.12749 -0.07392 lineto
0.50977 -0.23896 lineto
0.88748 -0.05823 lineto
1.08388 0.38371 lineto
1.00708 0.88005 lineto
0.69301 1.19857 lineto
0.28863 1.19022 lineto
-0.01685 0.8589 lineto
Mistroke
-0.06988 0.44287 lineto
0.09283 -0.00166 lineto
0.44605 -0.21145 lineto
0.82452 -0.08835 lineto
1.05115 0.31005 lineto
1.01988 0.79733 lineto
0.74536 1.14548 lineto
0.35603 1.19161 lineto
0.03407 0.91412 lineto
-0.06988 0.44287 lineto
0.06571 0.07243 lineto
0.38718 -0.17649 lineto
0.76145 -0.10886 lineto
1.01338 0.24365 lineto
1.02509 0.71611 lineto
0.79111 1.08746 lineto
0.42092 1.18392 lineto
0.08773 0.96037 lineto
-0.05256 0.52141 lineto
0.06571 0.07243 lineto
0.3336 -0.135 lineto
0.69907 -0.12013 lineto
0.97139 0.1849 lineto
1.02314 0.63737 lineto
0.83011 1.02557 lineto
0.48262 1.16784 lineto
0.14326 0.99763 lineto
-0.02918 0.59457 lineto
0.046 0.14726 lineto
0.3336 -0.135 lineto
0.63816 -0.12261 lineto
0.926 0.13406 lineto
1.01451 0.56196 lineto
0.86228 0.96087 lineto
0.54053 1.14413 lineto
0.19982 1.026 lineto
-0.00044 0.66175 lineto
0.03347 0.22181 lineto
0.28567 -0.08796 lineto
0.63816 -0.12261 lineto
0.87803 0.09128 lineto
0.99976 0.49064 lineto
0.88765 0.89438 lineto
0.59416 1.11359 lineto
0.2566 1.04569 lineto
0.03294 0.72245 lineto
0.02782 0.29513 lineto
0.24364 -0.03633 lineto
0.57941 -0.11684 lineto
0.87803 0.09128 lineto
Mistroke
0.97947 0.42408 lineto
0.90634 0.82709 lineto
0.64307 1.07705 lineto
0.31286 1.057 lineto
0.07022 0.77633 lineto
0.02867 0.36635 lineto
0.20767 0.01892 lineto
0.52345 -0.10342 lineto
0.82826 0.05659 lineto
0.97947 0.42408 lineto
0.91853 0.75992 lineto
0.68695 1.03539 lineto
0.3679 1.06034 lineto
0.11066 0.82311 lineto
0.0356 0.43468 lineto
0.17783 0.07682 lineto
0.47082 -0.08303 lineto
0.77746 0.02993 lineto
0.95427 0.36283 lineto
0.91853 0.75992 lineto
0.72555 0.98948 lineto
0.42107 1.05619 lineto
0.15353 0.86265 lineto
0.04811 0.49942 lineto
0.15413 0.13647 lineto
0.42199 -0.05639 lineto
0.72635 0.0111 lineto
0.9248 0.30735 lineto
0.92448 0.69374 lineto
0.72555 0.98948 lineto
0.47182 1.04507 lineto
0.19812 0.8949 lineto
0.06568 0.55996 lineto
0.13646 0.19696 lineto
0.37734 -0.02425 lineto
0.67562 -0.00015 lineto
0.89173 0.25797 lineto
0.92454 0.62934 lineto
0.7587 0.94019 lineto
0.47182 1.04507 lineto
0.24374 0.91993 lineto
0.08775 0.61578 lineto
0.12466 0.25746 lineto
0.3372 0.01262 lineto
0.62591 -0.00416 lineto
0.85571 0.21495 lineto
0.91907 0.56745 lineto
0.78634 0.88838 lineto
0.51963 1.02759 lineto
0.24374 0.91993 lineto
Mistroke
0.11375 0.66647 lineto
0.11851 0.31718 lineto
0.30177 0.05343 lineto
0.57779 -0.00137 lineto
0.81741 0.17843 lineto
0.90851 0.5087 lineto
0.80846 0.83489 lineto
0.56408 1.00439 lineto
0.28972 0.93787 lineto
0.11375 0.66647 lineto
0.11771 0.37539 lineto
0.27123 0.09739 lineto
0.53179 0.00777 lineto
0.77747 0.14847 lineto
0.89332 0.45365 lineto
0.82514 0.78053 lineto
0.60481 0.97614 lineto
0.33545 0.94896 lineto
0.14308 0.71171 lineto
0.11771 0.37539 lineto
0.24564 0.14372 lineto
0.48836 0.0227 lineto
0.73652 0.12502 lineto
0.87402 0.40279 lineto
0.8365 0.72605 lineto
0.64153 0.94354 lineto
0.38034 0.95349 lineto
0.17514 0.75125 lineto
0.12194 0.43145 lineto
0.24564 0.14372 lineto
0.44791 0.04287 lineto
0.69516 0.10796 lineto
0.8511 0.35649 lineto
0.84275 0.67217 lineto
0.67403 0.90729 lineto
0.42387 0.95183 lineto
0.20934 0.78496 lineto
0.13081 0.48475 lineto
0.22503 0.19167 lineto
0.44791 0.04287 lineto
0.65395 0.09712 lineto
0.82511 0.31507 lineto
0.84414 0.61956 lineto
0.70215 0.8681 lineto
0.46557 0.94441 lineto
0.24509 0.81277 lineto
0.1439 0.53478 lineto
0.20932 0.24052 lineto
0.41076 0.06767 lineto
0.65395 0.09712 lineto
Mistroke
0.79659 0.27875 lineto
0.84097 0.56881 lineto
0.72581 0.82668 lineto
0.505 0.93169 lineto
0.28184 0.83471 lineto
0.16076 0.58111 lineto
0.19842 0.28956 lineto
0.37719 0.09648 lineto
0.61342 0.09221 lineto
0.79659 0.27875 lineto
0.83357 0.52047 lineto
0.74501 0.7837 lineto
0.5418 0.91419 lineto
0.31903 0.85087 lineto
0.18094 0.62338 lineto
0.19214 0.33816 lineto
0.34739 0.12866 lineto
0.57405 0.09292 lineto
0.76606 0.24766 lineto
0.83357 0.52047 lineto
0.75977 0.73983 lineto
0.57567 0.89244 lineto
0.35616 0.86142 lineto
0.20396 0.66129 lineto
0.19028 0.38569 lineto
0.32152 0.16358 lineto
0.53627 0.09888 lineto
0.73406 0.22187 lineto
0.82232 0.475 lineto
0.75977 0.73983 lineto
0.60635 0.867 lineto
0.39274 0.86659 lineto
0.22932 0.69465 lineto
0.19256 0.43163 lineto
0.29964 0.2006 lineto
0.50048 0.10966 lineto
0.70109 0.20137 lineto
0.80761 0.43281 lineto
0.77019 0.69569 lineto
0.60635 0.867 lineto
0.42835 0.86666 lineto
0.25656 0.72331 lineto
0.19868 0.47546 lineto
0.2818 0.2391 lineto
0.46701 0.12482 lineto
0.66766 0.18608 lineto
0.78986 0.39424 lineto
0.77643 0.65188 lineto
0.63366 0.83845 lineto
0.42835 0.86666 lineto
Mistroke
0.28519 0.7472 lineto
0.20833 0.51677 lineto
0.26794 0.27849 lineto
0.43614 0.14386 lineto
0.63422 0.17587 lineto
0.76949 0.35955 lineto
0.77867 0.60894 lineto
0.65745 0.80736 lineto
0.46256 0.86196 lineto
0.28519 0.7472 lineto
0.22114 0.55517 lineto
0.25801 0.31821 lineto
0.40811 0.1663 lineto
0.6012 0.17054 lineto
0.74695 0.32893 lineto
0.77714 0.56737 lineto
0.67766 0.77429 lineto
0.49505 0.85286 lineto
0.31475 0.76633 lineto
0.22114 0.55517 lineto
0.25186 0.3577 lineto
0.38309 0.19162 lineto
0.56902 0.16983 lineto
0.72266 0.30253 lineto
0.77211 0.52763 lineto
0.69424 0.7398 lineto
0.52548 0.83976 lineto
0.3448 0.78075 lineto
0.23674 0.59037 lineto
0.25186 0.3577 lineto
0.36122 0.2193 lineto
0.53803 0.17346 lineto
0.69705 0.28042 lineto
0.76386 0.49012 lineto
0.70721 0.70444 lineto
0.55361 0.8231 lineto
0.37492 0.79058 lineto
0.25475 0.6221 lineto
0.24934 0.39648 lineto
0.36122 0.2193 lineto
0.50856 0.1811 lineto
0.67055 0.26259 lineto
0.75273 0.45517 lineto
0.71666 0.66872 lineto
0.57921 0.80333 lineto
0.4047 0.796 lineto
0.27478 0.65018 lineto
0.25025 0.43408 lineto
0.34257 0.24883 lineto
0.50856 0.1811 lineto
Mistroke
0.64355 0.24901 lineto
0.73903 0.42307 lineto
0.72267 0.63313 lineto
0.60212 0.78089 lineto
0.43378 0.79722 lineto
0.29643 0.67448 lineto
0.25433 0.4701 lineto
0.32719 0.27971 lineto
0.4809 0.19239 lineto
0.64355 0.24901 lineto
0.72312 0.39406 lineto
0.7254 0.59812 lineto
0.62221 0.75626 lineto
0.46184 0.7945 lineto
0.31932 0.69494 lineto
0.26135 0.50416 lineto
0.31504 0.31144 lineto
0.45528 0.20694 lineto
0.61644 0.23957 lineto
0.72312 0.39406 lineto
0.72502 0.56411 lineto
0.63941 0.72991 lineto
0.48857 0.78813 lineto
0.34308 0.71153 lineto
0.27101 0.53596 lineto
0.30609 0.34356 lineto
0.43191 0.22436 lineto
0.58958 0.23414 lineto
0.70534 0.36831 lineto
0.72502 0.56411 lineto
0.65367 0.70227 lineto
0.51371 0.77843 lineto
0.36733 0.7243 lineto
0.28302 0.56522 lineto
0.30025 0.37563 lineto
0.41094 0.24423 lineto
0.5633 0.23251 lineto
0.68605 0.34595 lineto
0.72174 0.53148 lineto
0.65367 0.70227 lineto
0.53703 0.76573 lineto
0.39172 0.73332 lineto
0.29707 0.59173 lineto
0.29738 0.40722 lineto
0.39249 0.26613 lineto
0.53791 0.23446 lineto
0.66559 0.32704 lineto
0.71579 0.50055 lineto
0.66502 0.67381 lineto
0.53703 0.76573 lineto
Mistroke
0.41594 0.73872 lineto
0.31285 0.61533 lineto
0.29733 0.43798 lineto
0.37664 0.28964 lineto
0.51367 0.23974 lineto
0.64431 0.31161 lineto
0.70742 0.47164 lineto
0.67348 0.64493 lineto
0.55837 0.75041 lineto
0.41594 0.73872 lineto
0.33003 0.6359 lineto
0.29991 0.46754 lineto
0.36342 0.31436 lineto
0.49083 0.24805 lineto
0.62254 0.29963 lineto
0.6969 0.44496 lineto
0.67914 0.61605 lineto
0.57755 0.73283 lineto
0.43968 0.74067 lineto
0.33003 0.6359 lineto
0.30493 0.4956 lineto
0.35284 0.33989 lineto
0.4696 0.25911 lineto
0.60058 0.29104 lineto
0.68451 0.42074 lineto
0.6821 0.58753 lineto
0.59448 0.71337 lineto
0.46266 0.73936 lineto
0.34831 0.65336 lineto
0.30493 0.4956 lineto
0.34485 0.36584 lineto
0.45014 0.27257 lineto
0.57875 0.28571 lineto
0.67052 0.39913 lineto
0.6825 0.55974 lineto
0.60908 0.6924 lineto
0.48463 0.73503 lineto
0.36736 0.66769 lineto
0.31216 0.52189 lineto
0.34485 0.36584 lineto
0.43259 0.28812 lineto
0.55732 0.28352 lineto
0.65523 0.38022 lineto
0.6805 0.53297 lineto
0.62132 0.67029 lineto
0.50537 0.72793 lineto
0.38691 0.67892 lineto
0.32136 0.54619 lineto
0.3394 0.39185 lineto
0.43259 0.28812 lineto
Mistroke
0.53653 0.28429 lineto
0.63891 0.36411 lineto
0.67629 0.50751 lineto
0.63118 0.6474 lineto
0.5247 0.71832 lineto
0.40665 0.68708 lineto
0.33229 0.56831 lineto
0.3364 0.41757 lineto
0.41706 0.30541 lineto
0.53653 0.28429 lineto
0.62185 0.3508 lineto
0.67006 0.48361 lineto
0.6387 0.62408 lineto
0.54244 0.7065 lineto
0.42633 0.69229 lineto
0.34468 0.58811 lineto
0.33571 0.4427 lineto
0.40361 0.3241 lineto
0.51662 0.28781 lineto
0.62185 0.3508 lineto
0.66202 0.46148 lineto
0.64393 0.60067 lineto
0.55849 0.69276 lineto
0.44568 0.69466 lineto
0.35829 0.60547 lineto
0.33721 0.46693 lineto
0.3923 0.34387 lineto
0.49778 0.29386 lineto
0.60431 0.3403 lineto
0.66202 0.46148 lineto
0.64694 0.57747 lineto
0.57273 0.67741 lineto
0.46448 0.69434 lineto
0.37285 0.62034 lineto
0.34072 0.49002 lineto
0.38312 0.36438 lineto
0.4802 0.30219 lineto
0.58655 0.33256 lineto
0.6524 0.44128 lineto
0.64694 0.57747 lineto
0.5851 0.66076 lineto
0.48252 0.69152 lineto
0.38812 0.63267 lineto
0.34608 0.51174 lineto
0.37605 0.38532 lineto
0.46402 0.31256 lineto
0.56883 0.3275 lineto
0.64143 0.42316 lineto
0.64785 0.55477 lineto
0.5851 0.66076 lineto
Mistroke
0.49962 0.68639 lineto
0.40386 0.64248 lineto
0.35308 0.5319 lineto
0.37105 0.40639 lineto
0.44936 0.32468 lineto
0.55136 0.32501 lineto
0.62933 0.40722 lineto
0.64678 0.53284 lineto
0.59556 0.64309 lineto
0.49962 0.68639 lineto
0.41982 0.6498 lineto
0.36155 0.55033 lineto
0.36806 0.42731 lineto
0.43631 0.3383 lineto
0.53436 0.32496 lineto
0.61633 0.39352 lineto
0.64387 0.5119 lineto
0.60409 0.62472 lineto
0.51561 0.67918 lineto
0.41982 0.6498 lineto
0.37126 0.5669 lineto
0.36697 0.44781 lineto
0.42493 0.35313 lineto
0.51802 0.32718 lineto
0.60267 0.38209 lineto
0.63928 0.49217 lineto
0.61072 0.60592 lineto
0.53035 0.6701 lineto
0.43578 0.65469 lineto
0.37126 0.5669 lineto
0.36769 0.46766 lineto
0.41527 0.36891 lineto
0.5025 0.33151 lineto
0.58856 0.37294 lineto
0.63318 0.47382 lineto
0.61548 0.58696 lineto
0.54375 0.6594 lineto
0.45154 0.65726 lineto
0.38201 0.58154 lineto
0.36769 0.46766 lineto
0.40734 0.38537 lineto
0.48797 0.33774 lineto
0.57422 0.36603 lineto
0.62575 0.45701 lineto
0.61843 0.5681 lineto
0.55571 0.64733 lineto
0.46691 0.65762 lineto
0.3936 0.59416 lineto
0.37007 0.48664 lineto
0.40734 0.38537 lineto
Mistroke
0.47453 0.34568 lineto
0.55984 0.36132 lineto
0.61716 0.44185 lineto
0.61965 0.54959 lineto
0.56616 0.63412 lineto
0.48171 0.6559 lineto
0.40582 0.60473 lineto
0.374 0.50456 lineto
0.40113 0.40225 lineto
0.47453 0.34568 lineto
0.54562 0.35871 lineto
0.60761 0.42843 lineto
0.61924 0.53163 lineto
0.57508 0.62003 lineto
0.49579 0.65227 lineto
0.41847 0.61326 lineto
0.3793 0.52125 lineto
0.39661 0.4193 lineto
0.4623 0.35511 lineto
0.54562 0.35871 lineto
0.59728 0.41681 lineto
0.6173 0.51443 lineto
0.58244 0.6053 lineto
0.509 0.6469 lineto
0.43135 0.61976 lineto
0.38583 0.53659 lineto
0.39372 0.43629 lineto
0.45135 0.36581 lineto
0.53174 0.35811 lineto
0.59728 0.41681 lineto
0.61396 0.49816 lineto
0.58825 0.59016 lineto
0.52124 0.63997 lineto
0.4443 0.62429 lineto
0.39342 0.55045 lineto
0.39241 0.45301 lineto
0.44174 0.37755 lineto
0.51834 0.35939 lineto
0.58635 0.40702 lineto
0.61396 0.49816 lineto
0.59253 0.57482 lineto
0.53241 0.63167 lineto
0.45712 0.6269 lineto
0.4019 0.56276 lineto
0.39258 0.46925 lineto
0.43352 0.39013 lineto
0.50557 0.36242 lineto
0.57502 0.39909 lineto
0.60936 0.48297 lineto
0.59253 0.57482 lineto
Mistroke
0.54243 0.62219 lineto
0.46967 0.62769 lineto
0.4111 0.57345 lineto
0.39413 0.48483 lineto
0.4267 0.40332 lineto
0.49356 0.36704 lineto
0.56344 0.39297 lineto
0.60364 0.46899 lineto
0.59534 0.55951 lineto
0.54243 0.62219 lineto
0.48179 0.62678 lineto
0.42086 0.58249 lineto
0.39696 0.4996 lineto
0.42127 0.4169 lineto
0.48242 0.37308 lineto
0.5518 0.38865 lineto
0.59694 0.45632 lineto
0.59672 0.54443 lineto
0.55125 0.61175 lineto
0.48179 0.62678 lineto
0.43102 0.58987 lineto
0.40094 0.51342 lineto
0.41722 0.43069 lineto
0.47223 0.38039 lineto
0.54023 0.38606 lineto
0.58941 0.44504 lineto
0.59676 0.52974 lineto
0.55883 0.60053 lineto
0.49337 0.62427 lineto
0.43102 0.58987 lineto
0.40595 0.52616 lineto
0.4145 0.44447 lineto
0.46306 0.38877 lineto
0.5289 0.38511 lineto
0.58122 0.43521 lineto
0.59553 0.51563 lineto
0.56515 0.58873 lineto
0.50428 0.62031 lineto
0.44141 0.5956 lineto
0.40595 0.52616 lineto
0.41308 0.45809 lineto
0.45497 0.39805 lineto
0.51793 0.38572 lineto
0.5725 0.42686 lineto
0.59315 0.50222 lineto
0.57021 0.57654 lineto
0.51442 0.61505 lineto
0.45189 0.59972 lineto
0.41186 0.53773 lineto
0.41308 0.45809 lineto
Mistroke
0.44799 0.40806 lineto
0.50743 0.38778 lineto
0.5634 0.42 lineto
0.5897 0.48966 lineto
0.57403 0.56416 lineto
0.52372 0.60863 lineto
0.46231 0.60228 lineto
0.41853 0.54807 lineto
0.41288 0.47136 lineto
0.44799 0.40806 lineto
0.49752 0.39116 lineto
0.55407 0.41463 lineto
0.58532 0.47805 lineto
0.57665 0.55174 lineto
0.53211 0.60122 lineto
0.47254 0.60334 lineto
0.42583 0.5571 lineto
0.41382 0.48415 lineto
0.44213 0.41861 lineto
0.49752 0.39116 lineto
0.54465 0.41072 lineto
0.58011 0.46748 lineto
0.57809 0.53946 lineto
0.53953 0.59297 lineto
0.48247 0.60298 lineto
0.43362 0.56481 lineto
0.41582 0.49631 lineto
0.43741 0.42953 lineto
0.48829 0.39573 lineto
0.54465 0.41072 lineto
0.5742 0.45802 lineto
0.57843 0.52746 lineto
0.54596 0.58405 lineto
0.49198 0.60132 lineto
0.44176 0.57117 lineto
0.41879 0.50772 lineto
0.43382 0.44066 lineto
0.47981 0.40137 lineto
0.53526 0.40822 lineto
0.5742 0.45802 lineto
0.57772 0.51589 lineto
0.55137 0.57462 lineto
0.50098 0.59844 lineto
0.45013 0.57619 lineto
0.42262 0.5183 lineto
0.43131 0.45184 lineto
0.47215 0.40792 lineto
0.52602 0.40708 lineto
0.56771 0.44972 lineto
0.57772 0.51589 lineto
Mistroke
0.55576 0.56483 lineto
0.50938 0.59447 lineto
0.4586 0.5799 lineto
0.4272 0.52795 lineto
0.42986 0.46292 lineto
0.46534 0.41524 lineto
0.51704 0.40722 lineto
0.56076 0.44262 lineto
0.57606 0.50486 lineto
0.55576 0.56483 lineto
0.51711 0.58953 lineto
0.46707 0.58233 lineto
0.43243 0.53661 lineto
0.42942 0.47375 lineto
0.45943 0.42318 lineto
0.50842 0.40856 lineto
0.55347 0.43672 lineto
0.57351 0.49449 lineto
0.55914 0.55484 lineto
0.51711 0.58953 lineto
0.47541 0.58353 lineto
0.43821 0.54423 lineto
0.42992 0.48423 lineto
0.45443 0.43161 lineto
0.50026 0.41099 lineto
0.54597 0.43202 lineto
0.57017 0.48486 lineto
0.56154 0.54478 lineto
0.52411 0.58375 lineto
0.47541 0.58353 lineto
0.44441 0.55078 lineto
0.4313 0.49423 lineto
0.45034 0.44038 lineto
0.49262 0.41443 lineto
0.53835 0.42852 lineto
0.56613 0.47605 lineto
0.56298 0.53479 lineto
0.53035 0.57725 lineto
0.48352 0.58357 lineto
0.44441 0.55078 lineto
0.43349 0.50365 lineto
0.44717 0.44936 lineto
0.48557 0.41876 lineto
0.53073 0.42617 lineto
0.5615 0.46813 lineto
0.5635 0.525 lineto
0.53579 0.57018 lineto
0.49133 0.58251 lineto
0.45093 0.55624 lineto
0.43349 0.50365 lineto
Mistroke
0.44489 0.45841 lineto
0.47917 0.42386 lineto
0.5232 0.42493 lineto
0.55637 0.46114 lineto
0.56317 0.51552 lineto
0.54041 0.56265 lineto
0.49874 0.58046 lineto
0.45766 0.56062 lineto
0.43639 0.51242 lineto
0.44489 0.45841 lineto
0.47346 0.42961 lineto
0.51586 0.42475 lineto
0.55084 0.4551 lineto
0.56204 0.50646 lineto
0.5442 0.55479 lineto
0.50568 0.57749 lineto
0.46451 0.56393 lineto
0.43994 0.52045 lineto
0.44347 0.46741 lineto
0.47346 0.42961 lineto
0.50879 0.42556 lineto
0.54501 0.45005 lineto
0.56017 0.4979 lineto
0.54717 0.54674 lineto
0.5121 0.57371 lineto
0.47137 0.56619 lineto
0.44403 0.5277 lineto
0.44288 0.47625 lineto
0.46846 0.43591 lineto
0.50879 0.42556 lineto
0.53898 0.44597 lineto
0.55765 0.48992 lineto
0.54934 0.5386 lineto
0.51795 0.56921 lineto
0.47816 0.56744 lineto
0.44859 0.53411 lineto
0.44307 0.48482 lineto
0.4642 0.44264 lineto
0.50207 0.42729 lineto
0.53898 0.44597 lineto
0.55453 0.4826 lineto
0.55072 0.53049 lineto
0.52318 0.56411 lineto
0.48479 0.56774 lineto
0.45352 0.53967 lineto
0.44399 0.49304 lineto
0.46068 0.44967 lineto
0.49576 0.42985 lineto
0.53283 0.44285 lineto
0.55453 0.4826 lineto
Mistroke
0.55136 0.52251 lineto
0.52777 0.55851 lineto
0.49119 0.56713 lineto
0.45873 0.54435 lineto
0.44558 0.50081 lineto
0.4579 0.45689 lineto
0.48991 0.43315 lineto
0.52665 0.44068 lineto
0.55092 0.47597 lineto
0.55136 0.52251 lineto
0.5317 0.55251 lineto
0.49728 0.56569 lineto
0.46414 0.54814 lineto
0.44777 0.50807 lineto
0.45584 0.46421 lineto
0.48458 0.43711 lineto
0.52053 0.43943 lineto
0.54687 0.47009 lineto
0.55129 0.51475 lineto
0.5317 0.55251 lineto
0.50302 0.5635 lineto
0.46966 0.55107 lineto
0.4505 0.51474 lineto
0.4545 0.47152 lineto
0.47979 0.44163 lineto
0.51453 0.43904 lineto
0.54248 0.46498 lineto
0.55055 0.50731 lineto
0.53497 0.54621 lineto
0.50302 0.5635 lineto
0.47522 0.55314 lineto
0.45369 0.5208 lineto
0.45383 0.47873 lineto
0.47557 0.44661 lineto
0.50874 0.43947 lineto
0.53782 0.46066 lineto
0.5492 0.50025 lineto
0.53756 0.53973 lineto
0.50835 0.56062 lineto
0.47522 0.55314 lineto
0.45728 0.52619 lineto
0.45381 0.48574 lineto
0.47195 0.45196 lineto
0.50321 0.44066 lineto
0.53298 0.45713 lineto
0.54731 0.49365 lineto
0.5395 0.53315 lineto
0.51321 0.55713 lineto
0.48074 0.55439 lineto
0.45728 0.52619 lineto
Mistroke
0.45439 0.49248 lineto
0.46893 0.45759 lineto
0.498 0.44254 lineto
0.52802 0.45438 lineto
0.54492 0.48757 lineto
0.5408 0.52657 lineto
0.5176 0.55314 lineto
0.48615 0.55484 lineto
0.46119 0.53089 lineto
0.45439 0.49248 lineto
0.4665 0.46341 lineto
0.49316 0.44505 lineto
0.52301 0.45241 lineto
0.5421 0.48204 lineto
0.54149 0.52007 lineto
0.52146 0.54871 lineto
0.4914 0.55456 lineto
0.46535 0.53488 lineto
0.45552 0.49888 lineto
0.4665 0.46341 lineto
0.48872 0.44811 lineto
0.51804 0.45118 lineto
0.53892 0.4771 lineto
0.54159 0.51373 lineto
0.5248 0.54393 lineto
0.49641 0.55358 lineto
0.46969 0.53816 lineto
0.45716 0.50488 lineto
0.46467 0.46932 lineto
0.48872 0.44811 lineto
0.51315 0.45067 lineto
0.53544 0.47278 lineto
0.54115 0.50762 lineto
0.5276 0.5389 lineto
0.50114 0.55198 lineto
0.47415 0.54073 lineto
0.45925 0.51043 lineto
0.46342 0.47525 lineto
0.48471 0.45165 lineto
0.51315 0.45067 lineto
0.53173 0.46909 lineto
0.5402 0.50182 lineto
0.52986 0.53369 lineto
0.50555 0.5498 lineto
0.47864 0.54261 lineto
0.46173 0.51548 lineto
0.46273 0.48111 lineto
0.48116 0.45558 lineto
0.50841 0.45083 lineto
0.53173 0.46909 lineto
Mistroke
0.53878 0.49636 lineto
0.53158 0.52838 lineto
0.5096 0.54711 lineto
0.48313 0.5438 lineto
0.46455 0.52 lineto
0.46256 0.48684 lineto
0.47809 0.45983 lineto
0.50387 0.45162 lineto
0.52784 0.46605 lineto
0.53878 0.49636 lineto
0.53278 0.52304 lineto
0.51326 0.54399 lineto
0.48754 0.54436 lineto
0.46765 0.52397 lineto
0.46289 0.49236 lineto
0.4755 0.46433 lineto
0.49957 0.45299 lineto
0.52384 0.46365 lineto
0.53696 0.49131 lineto
0.53278 0.52304 lineto
0.51652 0.5405 lineto
0.49183 0.54429 lineto
0.47096 0.52736 lineto
0.46368 0.49763 lineto
0.4734 0.46901 lineto
0.49556 0.45488 lineto
0.5198 0.46187 lineto
0.53477 0.4867 lineto
0.53348 0.51775 lineto
0.51652 0.5405 lineto
0.49594 0.54366 lineto
0.47444 0.53019 lineto
0.4649 0.50259 lineto
0.47178 0.47378 lineto
0.49187 0.45724 lineto
0.51576 0.46071 lineto
0.53228 0.48256 lineto
0.53369 0.51258 lineto
0.51934 0.53671 lineto
0.49594 0.54366 lineto
0.47802 0.53243 lineto
0.46649 0.50719 lineto
0.47063 0.47858 lineto
0.48852 0.45999 lineto
0.51178 0.46013 lineto
0.52952 0.47892 lineto
0.53346 0.50757 lineto
0.52174 0.53268 lineto
0.49984 0.5425 lineto
0.47802 0.53243 lineto
Mistroke
0.46841 0.51139 lineto
0.46994 0.48335 lineto
0.48554 0.46309 lineto
0.5079 0.46011 lineto
0.52657 0.47579 lineto
0.5328 0.5028 lineto
0.52369 0.5285 lineto
0.50349 0.54087 lineto
0.48166 0.53411 lineto
0.46841 0.51139 lineto
0.46969 0.48802 lineto
0.48294 0.46647 lineto
0.50417 0.4606 lineto
0.52346 0.47317 lineto
0.53176 0.4983 lineto
0.52521 0.52422 lineto
0.50686 0.5388 lineto
0.4853 0.53524 lineto
0.47062 0.51518 lineto
0.46969 0.48802 lineto
0.48073 0.47006 lineto
0.50063 0.46158 lineto
0.52024 0.47108 lineto
0.53038 0.49411 lineto
0.5263 0.5199 lineto
0.50992 0.53637 lineto
0.48889 0.53583 lineto
0.47307 0.51852 lineto
0.46984 0.49255 lineto
0.48073 0.47006 lineto
0.49732 0.46299 lineto
0.51697 0.4695 lineto
0.52869 0.49027 lineto
0.52698 0.5156 lineto
0.51265 0.53363 lineto
0.4924 0.53592 lineto
0.4757 0.52141 lineto
0.47038 0.49688 lineto
0.47891 0.47381 lineto
0.49732 0.46299 lineto
0.5137 0.46841 lineto
0.52674 0.48681 lineto
0.52727 0.51138 lineto
0.51504 0.53062 lineto
0.49577 0.53554 lineto
0.47849 0.52383 lineto
0.47127 0.50097 lineto
0.47749 0.47765 lineto
0.49425 0.4648 lineto
0.5137 0.46841 lineto
Mistroke
0.52456 0.48374 lineto
0.52718 0.50728 lineto
0.51707 0.52741 lineto
0.49898 0.53472 lineto
0.48137 0.52578 lineto
0.47247 0.50478 lineto
0.47645 0.48154 lineto
0.49146 0.46694 lineto
0.51046 0.46781 lineto
0.52456 0.48374 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = subsubsection; inactive; startGroup; Cclosed; ]
"Unraveling of a knot".
:[font = input; ]
MidPointPolygonMovie[{...................},
                      TotalFrameNumber->30,
                      IterationStep->#,
                      Blowing->ConstantPerimeter
                    ]
:[font = postscript; inactive; PostScript; output; startGroup; Cclosed; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(0)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.0902563)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(1)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.53682 0.54168 moveto
0.49317 0.56122 lineto
0.47653 0.55914 lineto
0.45782 0.55706 lineto
0.44119 0.54874 lineto
0.43287 0.54251 lineto
0.43454 0.53419 lineto
0.44285 0.52587 lineto
0.45117 0.51964 lineto
0.46364 0.5134 lineto
0.51146 0.50924 lineto
0.53017 0.5134 lineto
0.54181 0.52837 lineto
0.54015 0.53461 lineto
0.53495 0.53606 lineto
0.5204 0.53606 lineto
0.48922 0.52567 lineto
0.44971 0.50696 lineto
0.43516 0.47161 lineto
0.43308 0.45914 lineto
0.43724 0.44874 lineto
0.44057 0.44209 lineto
0.45013 0.43585 lineto
0.45179 0.43752 lineto
0.45595 0.44791 lineto
0.46427 0.47078 lineto
0.4705 0.48533 lineto
0.48506 0.51028 lineto
0.50169 0.52899 lineto
0.52248 0.53939 lineto
0.5362 0.54147 lineto
0.53745 0.53897 lineto
0.53578 0.53731 lineto
0.51915 0.51652 lineto
0.50044 0.49573 lineto
0.48589 0.46662 lineto
0.48173 0.45415 lineto
0.48007 0.4396 lineto
0.47965 0.43876 lineto
0.47799 0.4371 lineto
0.47591 0.43876 lineto
0.47508 0.43918 lineto
0.46884 0.4475 lineto
0.46635 0.45124 lineto
0.46052 0.46163 lineto
0.46136 0.46413 lineto
0.473 0.47244 lineto
0.50626 0.47452 lineto
0.54161 0.47037 lineto
0.54992 0.4687 lineto
Mistroke
0.55865 0.46496 lineto
0.55907 0.46413 lineto
0.55907 0.46288 lineto
0.55907 0.45955 lineto
0.55824 0.45706 lineto
0.55782 0.45581 lineto
0.55699 0.45852 lineto
0.55283 0.46891 lineto
0.54867 0.47931 lineto
0.54867 0.48928 lineto
0.5362 0.52671 lineto
0.52581 0.54542 lineto
0.51125 0.56122 lineto
0.50709 0.56122 lineto
0.50543 0.56122 lineto
0.50668 0.56122 lineto
0.50793 0.5608 lineto
0.51541 0.55498 lineto
0.52373 0.54874 lineto
0.52747 0.54625 lineto
0.53121 0.54375 lineto
0.53308 0.54188 lineto
Mfstroke
0.53682 0.54168 moveto
0.53308 0.54188 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(1)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.0924969)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(2)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.51537 0.55272 moveto
0.48447 0.56167 lineto
0.46636 0.55954 lineto
0.44825 0.55422 lineto
0.43547 0.54676 lineto
0.43206 0.5393 lineto
0.43717 0.53078 lineto
0.4457 0.52332 lineto
0.45635 0.51693 lineto
0.48724 0.5116 lineto
0.52133 0.5116 lineto
0.53689 0.5214 lineto
0.542 0.53227 lineto
0.53848 0.53621 lineto
0.52836 0.53696 lineto
0.50493 0.53163 lineto
0.46871 0.51672 lineto
0.44101 0.48902 lineto
0.43249 0.46452 lineto
0.43355 0.4528 lineto
0.43739 0.44406 lineto
0.44399 0.43746 lineto
0.44974 0.43511 lineto
0.45273 0.44129 lineto
0.45912 0.45834 lineto
0.46658 0.47751 lineto
0.47723 0.49775 lineto
0.49321 0.52013 lineto
0.51238 0.53504 lineto
0.53007 0.54143 lineto
0.53774 0.54122 lineto
0.53753 0.53909 lineto
0.52815 0.52758 lineto
0.51004 0.50628 lineto
0.493 0.48071 lineto
0.48341 0.4594 lineto
0.48042 0.44555 lineto
0.47936 0.43767 lineto
0.47829 0.43639 lineto
0.47638 0.43639 lineto
0.47489 0.43746 lineto
0.47126 0.44193 lineto
0.46679 0.44811 lineto
0.46253 0.45535 lineto
0.45997 0.46196 lineto
0.46636 0.4675 lineto
0.48937 0.47283 lineto
0.52453 0.47176 lineto
0.5469 0.46878 lineto
0.55564 0.46601 lineto
Mistroke
0.56032 0.46366 lineto
0.56054 0.4626 lineto
0.56054 0.46026 lineto
0.56011 0.45727 lineto
0.55947 0.45535 lineto
0.55883 0.4561 lineto
0.55627 0.46281 lineto
0.55201 0.47346 lineto
0.54988 0.4839 lineto
0.54349 0.50819 lineto
0.53177 0.53696 lineto
0.51899 0.55464 lineto
0.5094 0.56274 lineto
0.50642 0.56274 lineto
0.50621 0.56274 lineto
0.50748 0.56252 lineto
0.51196 0.55933 lineto
0.52005 0.55315 lineto
0.52623 0.54868 lineto
0.53007 0.54612 lineto
0.53294 0.54388 lineto
0.53582 0.54282 lineto
Mfstroke
0.51537 0.55272 moveto
0.53582 0.54282 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(3)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.0963675)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(3)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.48715 0.56137 moveto
0.46496 0.5612 lineto
0.44747 0.55593 lineto
0.43521 0.54871 lineto
0.43144 0.54067 lineto
0.43543 0.53234 lineto
0.44398 0.52457 lineto
0.45979 0.51792 lineto
0.48754 0.51348 lineto
0.5174 0.51464 lineto
0.53571 0.52258 lineto
0.54151 0.53182 lineto
0.53837 0.53689 lineto
0.52608 0.53692 lineto
0.5018 0.53046 lineto
0.46962 0.51409 lineto
0.44353 0.48939 lineto
0.43216 0.46636 lineto
0.43149 0.4516 lineto
0.43549 0.44228 lineto
0.44143 0.43595 lineto
0.44692 0.43462 lineto
0.45164 0.44167 lineto
0.45769 0.45715 lineto
0.46601 0.47685 lineto
0.47766 0.49821 lineto
0.49376 0.51903 lineto
0.51251 0.53429 lineto
0.52872 0.54145 lineto
0.53726 0.54244 lineto
0.53671 0.53828 lineto
0.52705 0.52618 lineto
0.51074 0.50543 lineto
0.49464 0.48101 lineto
0.48443 0.45965 lineto
0.48011 0.44483 lineto
0.4785 0.43678 lineto
0.47716 0.43406 lineto
0.4755 0.43401 lineto
0.47328 0.43573 lineto
0.46984 0.43995 lineto
0.46545 0.44622 lineto
0.4614 0.45332 lineto
0.46063 0.46009 lineto
0.46928 0.46608 lineto
0.49209 0.47002 lineto
0.52223 0.47008 lineto
0.54531 0.46753 lineto
0.55691 0.4647 lineto
0.56168 0.46248 lineto
Mistroke
0.56301 0.4607 lineto
0.56296 0.45843 lineto
0.56257 0.45576 lineto
0.56196 0.45418 lineto
0.56079 0.45582 lineto
0.55819 0.46228 lineto
0.55475 0.4723 lineto
0.55086 0.48684 lineto
0.54392 0.5097 lineto
0.53282 0.53562 lineto
0.52062 0.55443 lineto
0.51152 0.56325 lineto
0.50741 0.56536 lineto
0.50685 0.56531 lineto
0.50863 0.56436 lineto
0.5134 0.56103 lineto
0.52039 0.55582 lineto
0.52672 0.55121 lineto
0.53108 0.54813 lineto
0.53432 0.54602 lineto
0.53124 0.54747 lineto
0.51329 0.55468 lineto
Mfstroke
0.48715 0.56137 moveto
0.51329 0.55468 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(6)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.101991)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(4)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.45497 0.56105 moveto
0.43973 0.55501 lineto
0.43158 0.54715 lineto
0.43118 0.53867 lineto
0.43775 0.53034 lineto
0.45162 0.52293 lineto
0.47399 0.51765 lineto
0.50137 0.51652 lineto
0.52492 0.52076 lineto
0.53803 0.52841 lineto
0.53988 0.53514 lineto
0.53131 0.53754 lineto
0.51212 0.53349 lineto
0.48464 0.52116 lineto
0.45679 0.50096 lineto
0.43758 0.4779 lineto
0.42988 0.4584 lineto
0.43048 0.44496 lineto
0.43506 0.43662 lineto
0.44075 0.43328 lineto
0.44639 0.43676 lineto
0.45249 0.44813 lineto
0.46036 0.46585 lineto
0.47122 0.48695 lineto
0.48582 0.50832 lineto
0.50333 0.52641 lineto
0.52047 0.53819 lineto
0.5327 0.54289 lineto
0.53674 0.54099 lineto
0.53166 0.53192 lineto
0.51915 0.5151 lineto
0.50366 0.49274 lineto
0.49049 0.46987 lineto
0.48237 0.45121 lineto
0.47849 0.43895 lineto
0.47653 0.43271 lineto
0.47483 0.43077 lineto
0.47266 0.43163 lineto
0.46961 0.43481 lineto
0.46568 0.44014 lineto
0.46177 0.4469 lineto
0.46042 0.45403 lineto
0.46603 0.46056 lineto
0.4824 0.4654 lineto
0.50761 0.46745 lineto
0.53329 0.4666 lineto
0.55167 0.46418 lineto
0.5614 0.4616 lineto
0.56535 0.45934 lineto
0.56643 0.45709 lineto
Mistroke
0.56635 0.45468 lineto
0.5658 0.45291 lineto
0.56469 0.45344 lineto
0.56266 0.45777 lineto
0.55959 0.46645 lineto
0.55542 0.48008 lineto
0.5492 0.49967 lineto
0.53992 0.52345 lineto
0.52854 0.54539 lineto
0.51807 0.56007 lineto
0.51114 0.56689 lineto
0.50833 0.56874 lineto
0.5089 0.56819 lineto
0.51235 0.56579 lineto
0.51809 0.56167 lineto
0.52458 0.55692 lineto
0.53018 0.5529 lineto
0.53362 0.55042 lineto
0.53189 0.55071 lineto
0.52052 0.55475 lineto
0.49967 0.56043 lineto
0.4758 0.56328 lineto
Mfstroke
0.45497 0.56105 moveto
0.4758 0.56328 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(10)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.109645)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(5)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.43052 0.55033 moveto
0.42984 0.54165 lineto
0.43706 0.53314 lineto
0.45224 0.52585 lineto
0.47437 0.52115 lineto
0.49956 0.52043 lineto
0.52157 0.52399 lineto
0.53494 0.53011 lineto
0.5372 0.53553 lineto
0.52812 0.53691 lineto
0.50895 0.5317 lineto
0.48336 0.51883 lineto
0.45778 0.49959 lineto
0.43868 0.47789 lineto
0.42901 0.4583 lineto
0.4275 0.44363 lineto
0.4309 0.43468 lineto
0.43639 0.43189 lineto
0.44267 0.43608 lineto
0.44987 0.44755 lineto
0.45896 0.4651 lineto
0.47096 0.48609 lineto
0.48616 0.50721 lineto
0.5033 0.52515 lineto
0.51945 0.53733 lineto
0.53091 0.54249 lineto
0.53477 0.54021 lineto
0.53022 0.53034 lineto
0.51904 0.51344 lineto
0.50501 0.4919 lineto
0.49225 0.4697 lineto
0.48322 0.45082 lineto
0.47795 0.43752 lineto
0.47497 0.42999 lineto
0.47271 0.42715 lineto
0.47016 0.42777 lineto
0.46692 0.43104 lineto
0.46323 0.4364 lineto
0.4604 0.44312 lineto
0.46115 0.45025 lineto
0.46888 0.45669 lineto
0.4854 0.46137 lineto
0.50848 0.46354 lineto
0.5323 0.46325 lineto
0.55118 0.46134 lineto
0.5629 0.45884 lineto
0.56863 0.4563 lineto
0.57072 0.45385 lineto
0.57103 0.45168 lineto
0.57042 0.4506 lineto
Mistroke
0.56907 0.45192 lineto
0.56681 0.45694 lineto
0.56341 0.46662 lineto
0.55847 0.4816 lineto
0.55138 0.50161 lineto
0.54193 0.52426 lineto
0.53115 0.54522 lineto
0.52119 0.56059 lineto
0.5141 0.56922 lineto
0.51079 0.57247 lineto
0.51111 0.57228 lineto
0.51444 0.56987 lineto
0.51984 0.56598 lineto
0.52597 0.56155 lineto
0.53117 0.55773 lineto
0.53327 0.55568 lineto
0.52941 0.55632 lineto
0.51739 0.55958 lineto
0.498 0.56359 lineto
0.47538 0.56553 lineto
0.45453 0.56363 lineto
0.43897 0.55811 lineto
Mfstroke
0.43052 0.55033 moveto
0.43897 0.55811 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(15)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.119529)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(6)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.44359 0.5332 moveto
0.46255 0.52737 lineto
0.4857 0.52481 lineto
0.50842 0.52595 lineto
0.5256 0.52994 lineto
0.53333 0.53451 lineto
0.5299 0.53667 lineto
0.51589 0.53364 lineto
0.49416 0.52389 lineto
0.46957 0.50774 lineto
0.44763 0.48759 lineto
0.43246 0.46701 lineto
0.4253 0.44936 lineto
0.42479 0.43691 lineto
0.42855 0.43084 lineto
0.43462 0.43185 lineto
0.44222 0.44011 lineto
0.45159 0.45491 lineto
0.46339 0.47434 lineto
0.47792 0.49554 lineto
0.49443 0.51527 lineto
0.51085 0.53065 lineto
0.5242 0.53961 lineto
0.5316 0.54102 lineto
0.53148 0.53456 lineto
0.52435 0.5208 lineto
0.51263 0.50152 lineto
0.49973 0.47974 lineto
0.48854 0.45897 lineto
0.48043 0.44211 lineto
0.47518 0.43058 lineto
0.47164 0.42436 lineto
0.46864 0.42261 lineto
0.46545 0.42433 lineto
0.46212 0.42867 lineto
0.45965 0.4348 lineto
0.46009 0.4418 lineto
0.46597 0.44862 lineto
0.479 0.45421 lineto
0.49853 0.45777 lineto
0.5212 0.45902 lineto
0.54244 0.45829 lineto
0.55875 0.45629 lineto
0.56909 0.45375 lineto
0.57443 0.45115 lineto
0.57647 0.44892 lineto
0.57661 0.4477 lineto
0.57557 0.44852 lineto
0.5735 0.45258 lineto
0.57024 0.46101 lineto
Mistroke
0.56544 0.47449 lineto
0.5587 0.4928 lineto
0.54994 0.51431 lineto
0.53973 0.53599 lineto
0.52949 0.55449 lineto
0.52098 0.56756 lineto
0.51554 0.57482 lineto
0.51372 0.57732 lineto
0.51529 0.57646 lineto
0.51943 0.57351 lineto
0.52489 0.56954 lineto
0.53001 0.56565 lineto
0.53265 0.56299 lineto
0.53044 0.5624 lineto
0.52149 0.564 lineto
0.50564 0.56678 lineto
0.48507 0.56888 lineto
0.46361 0.56848 lineto
0.44523 0.56479 lineto
0.43286 0.55824 lineto
0.42813 0.54993 lineto
0.43173 0.54116 lineto
Mfstroke
0.44359 0.5332 moveto
0.43173 0.54116 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(21)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.131809)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(7)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.50494 0.5307 moveto
0.52085 0.53335 lineto
0.528 0.53611 lineto
0.52469 0.5364 lineto
0.51153 0.53191 lineto
0.49132 0.52146 lineto
0.46836 0.50546 lineto
0.44728 0.48592 lineto
0.43163 0.46583 lineto
0.42291 0.44824 lineto
0.42067 0.43559 lineto
0.42335 0.42948 lineto
0.42937 0.43066 lineto
0.43783 0.43913 lineto
0.44856 0.45392 lineto
0.46168 0.47309 lineto
0.47703 0.49394 lineto
0.4936 0.5134 lineto
0.50945 0.52868 lineto
0.52203 0.5376 lineto
0.52904 0.53891 lineto
0.5293 0.53232 lineto
0.52325 0.51861 lineto
0.51285 0.4997 lineto
0.50082 0.47837 lineto
0.48959 0.4577 lineto
0.4806 0.44029 lineto
0.47403 0.42767 lineto
0.46926 0.42025 lineto
0.46542 0.41755 lineto
0.46198 0.41873 lineto
0.45915 0.42281 lineto
0.458 0.4288 lineto
0.46032 0.43567 lineto
0.46792 0.44238 lineto
0.48169 0.44793 lineto
0.50074 0.45164 lineto
0.5224 0.45325 lineto
0.5432 0.45296 lineto
0.56025 0.45131 lineto
0.57221 0.44894 lineto
0.5793 0.44648 lineto
0.58262 0.44458 lineto
0.58339 0.44405 lineto
0.58241 0.44589 lineto
0.58003 0.45123 lineto
0.57617 0.46099 lineto
0.57062 0.47558 lineto
0.56319 0.49444 lineto
0.55403 0.51586 lineto
Mistroke
0.54385 0.53727 lineto
0.53387 0.55596 lineto
0.52552 0.56998 lineto
0.51997 0.57865 lineto
0.51781 0.58247 lineto
0.51889 0.58255 lineto
0.52243 0.58022 lineto
0.52707 0.57675 lineto
0.531 0.57335 lineto
0.5321 0.57102 lineto
0.52834 0.5704 lineto
0.51845 0.57139 lineto
0.50264 0.57309 lineto
0.48284 0.57409 lineto
0.46222 0.57303 lineto
0.44432 0.56922 lineto
0.43208 0.56281 lineto
0.42747 0.55468 lineto
0.43132 0.54606 lineto
0.44332 0.53833 lineto
0.46184 0.53274 lineto
0.48378 0.53016 lineto
Mfstroke
0.50494 0.5307 moveto
0.48378 0.53016 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(28)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.146448)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(8)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.51345 0.53375 moveto
0.49768 0.52518 lineto
0.47716 0.51143 lineto
0.45587 0.49362 lineto
0.43748 0.47396 lineto
0.42447 0.45522 lineto
0.41774 0.44008 lineto
0.41685 0.43064 lineto
0.42073 0.4282 lineto
0.42829 0.43314 lineto
0.43883 0.44487 lineto
0.45195 0.46186 lineto
0.46721 0.48179 lineto
0.48374 0.50185 lineto
0.5 0.51914 lineto
0.51394 0.5312 lineto
0.52351 0.53625 lineto
0.52728 0.53354 lineto
0.52498 0.52336 lineto
0.51761 0.50712 lineto
0.50712 0.48707 lineto
0.49571 0.46596 lineto
0.48517 0.44646 lineto
0.47645 0.43061 lineto
0.46964 0.41952 lineto
0.46438 0.41342 lineto
0.46025 0.41186 lineto
0.4573 0.41397 lineto
0.45619 0.41872 lineto
0.45817 0.42501 lineto
0.46463 0.43174 lineto
0.47642 0.43789 lineto
0.49327 0.44266 lineto
0.51356 0.44558 lineto
0.53473 0.44658 lineto
0.5541 0.44596 lineto
0.56968 0.44425 lineto
0.58067 0.44212 lineto
0.58729 0.44032 lineto
0.59035 0.43972 lineto
0.59071 0.44129 lineto
0.58898 0.44607 lineto
0.58544 0.45494 lineto
0.5801 0.46834 lineto
0.57292 0.48599 lineto
0.56408 0.50669 lineto
0.55411 0.52844 lineto
0.54393 0.54892 lineto
0.53475 0.56604 lineto
0.52771 0.5785 lineto
Mistroke
0.52361 0.58602 lineto
0.52264 0.58913 lineto
0.52433 0.58893 lineto
0.52758 0.58673 lineto
0.53077 0.5838 lineto
0.53194 0.58125 lineto
0.52923 0.57979 lineto
0.5213 0.5796 lineto
0.50789 0.58022 lineto
0.49009 0.58068 lineto
0.47025 0.57988 lineto
0.45141 0.57695 lineto
0.43666 0.57166 lineto
0.42844 0.5644 lineto
0.42822 0.55613 lineto
0.43618 0.54809 lineto
0.45119 0.54151 lineto
0.47075 0.53731 lineto
0.49129 0.53578 lineto
0.50877 0.53635 lineto
0.51955 0.53757 lineto
0.52127 0.5374 lineto
Mfstroke
0.51345 0.53375 moveto
0.52127 0.5374 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(36)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(9)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.163142)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(9)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.43573 0.47199 moveto
0.42233 0.4539 lineto
0.4146 0.43927 lineto
0.41266 0.43015 lineto
0.41592 0.42783 lineto
0.42354 0.4327 lineto
0.43471 0.44412 lineto
0.44869 0.46059 lineto
0.46463 0.47983 lineto
0.4814 0.49914 lineto
0.49742 0.51578 lineto
0.51092 0.52736 lineto
0.52019 0.53217 lineto
0.52413 0.52949 lineto
0.52255 0.51962 lineto
0.51625 0.50388 lineto
0.50675 0.48438 lineto
0.49587 0.46363 lineto
0.48518 0.44406 lineto
0.47571 0.42765 lineto
0.46789 0.41562 lineto
0.46175 0.40843 lineto
0.45727 0.40582 lineto
0.4547 0.40707 lineto
0.45468 0.41117 lineto
0.45817 0.41699 lineto
0.46609 0.4234 lineto
0.47885 0.42941 lineto
0.49597 0.43422 lineto
0.51604 0.43739 lineto
0.53695 0.43879 lineto
0.5565 0.43865 lineto
0.57292 0.43747 lineto
0.58524 0.43594 lineto
0.59331 0.43489 lineto
0.59755 0.43528 lineto
0.59859 0.4381 lineto
0.59701 0.4443 lineto
0.59316 0.45456 lineto
0.58727 0.4691 lineto
0.57952 0.48748 lineto
0.57028 0.50849 lineto
0.56015 0.53036 lineto
0.55003 0.55106 lineto
0.54096 0.56877 lineto
0.5339 0.58228 lineto
0.52952 0.59114 lineto
0.52793 0.5957 lineto
0.52863 0.59683 lineto
0.53053 0.59573 lineto
Mistroke
0.53207 0.59361 lineto
0.53148 0.59151 lineto
0.52718 0.59005 lineto
0.51816 0.58938 lineto
0.50439 0.58913 lineto
0.48697 0.58857 lineto
0.46799 0.58685 lineto
0.45018 0.58335 lineto
0.43631 0.57786 lineto
0.42867 0.57073 lineto
0.4286 0.56278 lineto
0.43621 0.55507 lineto
0.45027 0.54863 lineto
0.46833 0.54419 lineto
0.48706 0.54185 lineto
0.50282 0.54099 lineto
0.51244 0.54029 lineto
0.51389 0.53805 lineto
0.50677 0.53259 lineto
0.49243 0.52282 lineto
0.47358 0.50865 lineto
0.45361 0.49106 lineto
Mfstroke
0.43573 0.47199 moveto
0.45361 0.49106 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(45)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.18161)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.41505 0.42963 moveto
0.42463 0.43756 lineto
0.43767 0.45107 lineto
0.45317 0.46832 lineto
0.46988 0.48691 lineto
0.48637 0.50422 lineto
0.50103 0.51777 lineto
0.5123 0.52561 lineto
0.51901 0.52657 lineto
0.52062 0.52043 lineto
0.51739 0.50796 lineto
0.51027 0.49074 lineto
0.50065 0.47092 lineto
0.49001 0.45079 lineto
0.47963 0.43248 lineto
0.47037 0.4176 lineto
0.46273 0.40707 lineto
0.45704 0.40115 lineto
0.45362 0.3995 lineto
0.45298 0.40135 lineto
0.4558 0.40567 lineto
0.46273 0.41134 lineto
0.47412 0.4173 lineto
0.48974 0.42265 lineto
0.50864 0.42678 lineto
0.52927 0.42936 lineto
0.54976 0.43044 lineto
0.56833 0.43034 lineto
0.58366 0.42966 lineto
0.59505 0.4292 lineto
0.60236 0.42988 lineto
0.60589 0.43269 lineto
0.60609 0.43853 lineto
0.60342 0.44812 lineto
0.59828 0.46174 lineto
0.59105 0.47917 lineto
0.58216 0.49954 lineto
0.57219 0.52145 lineto
0.56193 0.54317 lineto
0.55227 0.56297 lineto
0.54411 0.57946 lineto
0.53811 0.59181 lineto
0.53456 0.59987 lineto
0.53321 0.60408 lineto
0.53326 0.60534 lineto
0.53346 0.60471 lineto
0.53228 0.60323 lineto
0.52828 0.60165 lineto
0.52039 0.60037 lineto
0.5083 0.59933 lineto
Mistroke
0.49262 0.59811 lineto
0.47485 0.59613 lineto
0.45721 0.59283 lineto
0.44219 0.58791 lineto
0.43209 0.58148 lineto
0.42852 0.57403 lineto
0.4321 0.56637 lineto
0.44221 0.55935 lineto
0.45706 0.55368 lineto
0.47393 0.5496 lineto
0.48962 0.54681 lineto
0.50109 0.54441 lineto
0.50602 0.54108 lineto
0.50333 0.53544 lineto
0.49344 0.52641 lineto
0.47806 0.51357 lineto
0.45982 0.49741 lineto
0.44167 0.47927 lineto
0.4262 0.46114 lineto
0.41525 0.44529 lineto
0.40977 0.43383 lineto
0.40985 0.42835 lineto
Mfstroke
0.41505 0.42963 moveto
0.40985 0.42835 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(55)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(11)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.20123)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(11)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.48241 0.49981 moveto
0.4967 0.5123 lineto
0.50773 0.51948 lineto
0.51451 0.52026 lineto
0.5166 0.51441 lineto
0.51417 0.50261 lineto
0.50799 0.48625 lineto
0.49919 0.46724 lineto
0.48904 0.44766 lineto
0.47875 0.42949 lineto
0.46929 0.41428 lineto
0.4614 0.40302 lineto
0.45564 0.39609 lineto
0.45255 0.39331 lineto
0.45266 0.39405 lineto
0.45651 0.39738 lineto
0.4645 0.40227 lineto
0.47672 0.4077 lineto
0.49279 0.41281 lineto
0.51177 0.41696 lineto
0.53229 0.41985 lineto
0.55276 0.42148 lineto
0.57162 0.42215 lineto
0.58761 0.42245 lineto
0.59995 0.42317 lineto
0.6083 0.4252 lineto
0.61274 0.42947 lineto
0.61355 0.4368 lineto
0.61116 0.44775 lineto
0.60604 0.46247 lineto
0.59868 0.48064 lineto
0.58966 0.50141 lineto
0.57965 0.5235 lineto
0.56944 0.54539 lineto
0.55984 0.56556 lineto
0.55161 0.58275 lineto
0.54527 0.59618 lineto
0.54098 0.60563 lineto
0.53844 0.61136 lineto
0.53689 0.61408 lineto
0.53522 0.61467 lineto
0.53213 0.614 lineto
0.52644 0.61276 lineto
0.51738 0.61131 lineto
0.50481 0.6097 lineto
0.48939 0.60768 lineto
0.47249 0.60485 lineto
0.45608 0.60087 lineto
0.44231 0.59557 lineto
0.43313 0.58906 lineto
Mistroke
0.42989 0.58177 lineto
0.43303 0.57431 lineto
0.44192 0.56734 lineto
0.45492 0.56132 lineto
0.46958 0.55636 lineto
0.48314 0.55214 lineto
0.49296 0.54788 lineto
0.49708 0.54252 lineto
0.49458 0.53501 lineto
0.48573 0.52457 lineto
0.47194 0.511 lineto
0.4554 0.49481 lineto
0.4386 0.47723 lineto
0.4239 0.46 lineto
0.41312 0.44511 lineto
0.40735 0.43443 lineto
0.40698 0.42937 lineto
0.41181 0.43061 lineto
0.42119 0.43802 lineto
0.4342 0.4506 lineto
0.44966 0.46661 lineto
0.46623 0.48382 lineto
Mfstroke
0.48241 0.49981 moveto
0.46623 0.48382 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(66)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(12)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.222041)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(12)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.50801 0.48911 moveto
0.50126 0.47215 lineto
0.49239 0.45346 lineto
0.48256 0.43492 lineto
0.47286 0.41818 lineto
0.46424 0.40452 lineto
0.45752 0.39467 lineto
0.45338 0.38885 lineto
0.45243 0.38676 lineto
0.45516 0.38776 lineto
0.46193 0.39097 lineto
0.47281 0.39544 lineto
0.48752 0.40028 lineto
0.50537 0.40476 lineto
0.52527 0.40843 lineto
0.54588 0.41113 lineto
0.56578 0.41297 lineto
0.58365 0.4144 lineto
0.59849 0.41607 lineto
0.60966 0.41876 lineto
0.61688 0.42335 lineto
0.62021 0.4306 lineto
0.61992 0.44111 lineto
0.61645 0.45512 lineto
0.61032 0.47247 lineto
0.60215 0.49258 lineto
0.59263 0.51444 lineto
0.58252 0.53677 lineto
0.57259 0.55821 lineto
0.56353 0.57751 lineto
0.55589 0.59373 lineto
0.5499 0.60634 lineto
0.54544 0.61528 lineto
0.54199 0.6209 lineto
0.53871 0.62381 lineto
0.53456 0.62474 lineto
0.52854 0.62436 lineto
0.5199 0.62317 lineto
0.50835 0.6214 lineto
0.49424 0.61906 lineto
0.47854 0.61598 lineto
0.46274 0.61194 lineto
0.44866 0.60682 lineto
0.43804 0.60065 lineto
0.43227 0.59366 lineto
0.43205 0.58628 lineto
0.43722 0.57897 lineto
0.4467 0.57211 lineto
0.45867 0.56588 lineto
0.47085 0.56011 lineto
Mistroke
0.48087 0.55431 lineto
0.48674 0.54773 lineto
0.48722 0.53955 lineto
0.48198 0.52911 lineto
0.47171 0.51612 lineto
0.4579 0.50084 lineto
0.44258 0.4841 lineto
0.42789 0.46726 lineto
0.41577 0.45197 lineto
0.40769 0.43993 lineto
0.40452 0.43257 lineto
0.40649 0.43079 lineto
0.41331 0.43481 lineto
0.42426 0.44407 lineto
0.43827 0.45729 lineto
0.45405 0.47262 lineto
0.47015 0.48792 lineto
0.4851 0.501 lineto
0.49757 0.50999 lineto
0.50649 0.51352 lineto
0.51121 0.51099 lineto
0.51159 0.50255 lineto
Mfstroke
0.50801 0.48911 moveto
0.51159 0.50255 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(78)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(13)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.244138)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(13)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.45745 0.39034 moveto
0.45388 0.38358 lineto
0.4536 0.38035 lineto
0.45708 0.38015 lineto
0.46457 0.38225 lineto
0.47602 0.38581 lineto
0.49108 0.39002 lineto
0.50904 0.39424 lineto
0.52888 0.39801 lineto
0.54938 0.40117 lineto
0.56926 0.40385 lineto
0.58733 0.40642 lineto
0.6026 0.40947 lineto
0.61438 0.41372 lineto
0.62233 0.41992 lineto
0.62637 0.42873 lineto
0.62671 0.44062 lineto
0.62375 0.45574 lineto
0.61801 0.47388 lineto
0.61014 0.49447 lineto
0.60088 0.51657 lineto
0.59095 0.53907 lineto
0.58108 0.56077 lineto
0.5719 0.58055 lineto
0.56382 0.59755 lineto
0.55701 0.61126 lineto
0.55132 0.62154 lineto
0.54627 0.62858 lineto
0.54117 0.63282 lineto
0.53517 0.63483 lineto
0.52752 0.63516 lineto
0.51769 0.63425 lineto
0.50557 0.63238 lineto
0.49155 0.62964 lineto
0.47653 0.62602 lineto
0.46181 0.62145 lineto
0.44889 0.61591 lineto
0.43921 0.60948 lineto
0.43384 0.60238 lineto
0.4333 0.5949 lineto
0.43736 0.58737 lineto
0.44506 0.58001 lineto
0.45483 0.57289 lineto
0.46475 0.56581 lineto
0.47283 0.55837 lineto
0.47743 0.55 lineto
0.47748 0.54013 lineto
0.47268 0.52833 lineto
0.46357 0.51451 lineto
0.45136 0.49901 lineto
Mistroke
0.43772 0.48264 lineto
0.42451 0.46659 lineto
0.41347 0.45229 lineto
0.40599 0.44116 lineto
0.40296 0.43439 lineto
0.40474 0.43271 lineto
0.41115 0.43626 lineto
0.42153 0.44448 lineto
0.4349 0.45622 lineto
0.44999 0.46982 lineto
0.46542 0.48335 lineto
0.4798 0.49487 lineto
0.49189 0.5027 lineto
0.50071 0.50563 lineto
0.50567 0.50307 lineto
0.50662 0.49512 lineto
0.50384 0.48254 lineto
0.498 0.4666 lineto
0.49001 0.44888 lineto
0.48092 0.43104 lineto
0.47181 0.4146 lineto
0.46369 0.40078 lineto
Mfstroke
0.45745 0.39034 moveto
0.46369 0.40078 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(91)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(14)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.26712)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(14)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.50374 0.38185 moveto
0.5227 0.38576 lineto
0.54286 0.38951 lineto
0.56305 0.39308 lineto
0.58213 0.39667 lineto
0.59905 0.40073 lineto
0.613 0.40582 lineto
0.62342 0.41259 lineto
0.63005 0.42162 lineto
0.63288 0.43337 lineto
0.63216 0.44807 lineto
0.62833 0.46564 lineto
0.62197 0.48567 lineto
0.61374 0.50747 lineto
0.60438 0.53012 lineto
0.59457 0.55255 lineto
0.58493 0.57374 lineto
0.57591 0.5928 lineto
0.56776 0.60906 lineto
0.56045 0.62217 lineto
0.5537 0.63206 lineto
0.54704 0.63893 lineto
0.53983 0.64316 lineto
0.53147 0.64518 lineto
0.52151 0.64542 lineto
0.50977 0.64423 lineto
0.49647 0.64183 lineto
0.48224 0.63835 lineto
0.46805 0.63387 lineto
0.45507 0.62843 lineto
0.44453 0.62212 lineto
0.43742 0.61508 lineto
0.43435 0.60753 lineto
0.43536 0.59968 lineto
0.4399 0.59171 lineto
0.44686 0.58366 lineto
0.45475 0.57545 lineto
0.46193 0.56681 lineto
0.46686 0.55737 lineto
0.46839 0.54673 lineto
0.46595 0.53458 lineto
0.4596 0.52083 lineto
0.45006 0.50571 lineto
0.43854 0.4898 lineto
0.42655 0.47403 lineto
0.41566 0.45954 lineto
0.4073 0.44755 lineto
0.40255 0.43916 lineto
0.40204 0.43514 lineto
0.40593 0.43581 lineto
Mistroke
0.41387 0.44094 lineto
0.42513 0.44972 lineto
0.43866 0.46087 lineto
0.45321 0.47279 lineto
0.4675 0.48376 lineto
0.48027 0.49216 lineto
0.4905 0.49667 lineto
0.49746 0.49649 lineto
0.50077 0.49136 lineto
0.50046 0.48163 lineto
0.49693 0.46816 lineto
0.49086 0.45218 lineto
0.48317 0.43515 lineto
0.47485 0.41849 lineto
0.46696 0.40348 lineto
0.46045 0.39107 lineto
0.45622 0.38184 lineto
0.45497 0.37595 lineto
0.45725 0.37318 lineto
0.46338 0.37306 lineto
0.47338 0.37493 lineto
0.48703 0.37808 lineto
Mfstroke
0.50374 0.38185 moveto
0.48703 0.37808 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(105)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(15)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.29073)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(15)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.62748 0.40899 moveto
0.63465 0.41956 lineto
0.63814 0.43269 lineto
0.63812 0.44851 lineto
0.63498 0.4669 lineto
0.62926 0.48747 lineto
0.62159 0.50958 lineto
0.61264 0.5324 lineto
0.60303 0.55501 lineto
0.59333 0.57651 lineto
0.58392 0.59607 lineto
0.57501 0.61309 lineto
0.56659 0.62719 lineto
0.55844 0.63822 lineto
0.55018 0.64628 lineto
0.54137 0.6516 lineto
0.53158 0.65453 lineto
0.52054 0.6554 lineto
0.5082 0.65455 lineto
0.49483 0.65223 lineto
0.48101 0.64864 lineto
0.46756 0.64392 lineto
0.45545 0.63819 lineto
0.44562 0.6316 lineto
0.43884 0.62428 lineto
0.43552 0.6164 lineto
0.43564 0.6081 lineto
0.43869 0.59948 lineto
0.44374 0.59053 lineto
0.44955 0.58116 lineto
0.45479 0.57117 lineto
0.45821 0.56029 lineto
0.45889 0.54828 lineto
0.45635 0.53501 lineto
0.45062 0.52053 lineto
0.44228 0.50515 lineto
0.43231 0.48945 lineto
0.42196 0.47426 lineto
0.41257 0.46055 lineto
0.40538 0.44934 lineto
0.40135 0.44148 lineto
0.40109 0.4376 lineto
0.40478 0.43787 lineto
0.41214 0.44203 lineto
0.42256 0.44936 lineto
0.43511 0.45872 lineto
0.44865 0.46871 lineto
0.46202 0.47785 lineto
0.47409 0.48473 lineto
0.48392 0.4882 lineto
Mistroke
0.49082 0.48755 lineto
0.49445 0.48253 lineto
0.49477 0.4734 lineto
0.49213 0.46085 lineto
0.48711 0.44595 lineto
0.48054 0.42991 lineto
0.47336 0.41401 lineto
0.46654 0.39939 lineto
0.46106 0.38694 lineto
0.45778 0.37725 lineto
0.45739 0.37056 lineto
0.46041 0.36677 lineto
0.46713 0.36555 lineto
0.47754 0.36638 lineto
0.49136 0.3687 lineto
0.50806 0.37195 lineto
0.52684 0.37571 lineto
0.54672 0.37973 lineto
0.56666 0.38397 lineto
0.58557 0.38861 lineto
0.6025 0.39401 lineto
0.61666 0.40063 lineto
Mfstroke
0.62748 0.40899 moveto
0.61666 0.40063 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(120)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(16)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.314516)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(16)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.61578 0.5461 moveto
0.60616 0.56845 lineto
0.59635 0.5894 lineto
0.58662 0.60828 lineto
0.57707 0.62461 lineto
0.56764 0.6381 lineto
0.5581 0.64866 lineto
0.54819 0.65635 lineto
0.5376 0.66138 lineto
0.52614 0.66402 lineto
0.51375 0.66455 lineto
0.5006 0.66327 lineto
0.48711 0.66042 lineto
0.47387 0.65621 lineto
0.46164 0.65083 lineto
0.45118 0.64443 lineto
0.44314 0.63718 lineto
0.43796 0.62921 lineto
0.43574 0.62064 lineto
0.43621 0.61154 lineto
0.43875 0.60194 lineto
0.44246 0.59178 lineto
0.44627 0.58095 lineto
0.44913 0.56929 lineto
0.45016 0.55667 lineto
0.44878 0.54301 lineto
0.44482 0.52839 lineto
0.43852 0.51307 lineto
0.43051 0.49751 lineto
0.42172 0.48237 lineto
0.41325 0.46842 lineto
0.40618 0.45652 lineto
0.40149 0.44742 lineto
0.39986 0.4417 lineto
0.40166 0.43964 lineto
0.40689 0.44114 lineto
0.41516 0.44573 lineto
0.4258 0.45256 lineto
0.4379 0.46053 lineto
0.45044 0.46838 lineto
0.46239 0.47485 lineto
0.47279 0.47883 lineto
0.48092 0.4795 lineto
0.48627 0.47643 lineto
0.48866 0.46957 lineto
0.4882 0.45933 lineto
0.48529 0.44644 lineto
0.48057 0.43186 lineto
0.47485 0.41668 lineto
0.46902 0.40196 lineto
Mistroke
0.46401 0.38865 lineto
0.46068 0.37745 lineto
0.45979 0.36879 lineto
0.46191 0.36281 lineto
0.46742 0.35942 lineto
0.47642 0.35832 lineto
0.48878 0.35909 lineto
0.50409 0.36128 lineto
0.52171 0.36449 lineto
0.54082 0.36845 lineto
0.56047 0.37303 lineto
0.57968 0.37828 lineto
0.5975 0.3844 lineto
0.61309 0.39172 lineto
0.6258 0.40064 lineto
0.63518 0.41155 lineto
0.64104 0.42474 lineto
0.6434 0.44037 lineto
0.6425 0.45839 lineto
0.63873 0.47855 lineto
0.63263 0.50035 lineto
0.62478 0.52312 lineto
Mfstroke
0.61578 0.5461 moveto
0.62478 0.52312 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(136)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(17)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.338053)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(17)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.53881 0.66837 moveto
0.52648 0.67177 lineto
0.51355 0.67291 lineto
0.50024 0.67206 lineto
0.48692 0.66946 lineto
0.4741 0.66534 lineto
0.46238 0.65991 lineto
0.45234 0.65336 lineto
0.44446 0.64585 lineto
0.43904 0.63751 lineto
0.4361 0.62844 lineto
0.4354 0.61869 lineto
0.43641 0.60827 lineto
0.43839 0.59715 lineto
0.44051 0.58527 lineto
0.44192 0.57254 lineto
0.44195 0.55893 lineto
0.44013 0.54449 lineto
0.43634 0.52936 lineto
0.43077 0.51386 lineto
0.42392 0.49844 lineto
0.41655 0.4837 lineto
0.40955 0.47031 lineto
0.4038 0.45895 lineto
0.40012 0.45022 lineto
0.39908 0.44455 lineto
0.40102 0.4421 lineto
0.40592 0.44274 lineto
0.4135 0.44602 lineto
0.42317 0.4512 lineto
0.43417 0.45732 lineto
0.44562 0.46332 lineto
0.45661 0.46812 lineto
0.46631 0.4708 lineto
0.47406 0.47065 lineto
0.47942 0.46727 lineto
0.4822 0.46063 lineto
0.48248 0.45101 lineto
0.48061 0.43902 lineto
0.47713 0.42545 lineto
0.47278 0.41122 lineto
0.46836 0.39725 lineto
0.46472 0.38437 lineto
0.46266 0.37324 lineto
0.46287 0.3643 lineto
0.46588 0.35775 lineto
0.47202 0.3536 lineto
0.4814 0.35167 lineto
0.49386 0.35168 lineto
0.50903 0.3533 lineto
Mistroke
0.52632 0.35622 lineto
0.54497 0.36024 lineto
0.56411 0.36524 lineto
0.58286 0.37126 lineto
0.60032 0.37844 lineto
0.61574 0.38703 lineto
0.62849 0.39732 lineto
0.63814 0.40958 lineto
0.64445 0.424 lineto
0.64742 0.44066 lineto
0.64723 0.45947 lineto
0.64421 0.48016 lineto
0.63881 0.50227 lineto
0.63154 0.52521 lineto
0.62292 0.54828 lineto
0.61343 0.57076 lineto
0.60343 0.59195 lineto
0.5932 0.61125 lineto
0.58285 0.62818 lineto
0.57236 0.64243 lineto
0.56163 0.65386 lineto
0.5505 0.66246 lineto
Mfstroke
0.53881 0.66837 moveto
0.5505 0.66246 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(153)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(18)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.361101)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(18)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.44258 0.6496 moveto
0.43788 0.64046 lineto
0.43517 0.63047 lineto
0.43413 0.61969 lineto
0.43424 0.60812 lineto
0.43485 0.59574 lineto
0.43531 0.58255 lineto
0.43501 0.56856 lineto
0.4335 0.55385 lineto
0.43057 0.53857 lineto
0.42624 0.52301 lineto
0.4208 0.50756 lineto
0.41476 0.49269 lineto
0.40878 0.47897 lineto
0.40359 0.46696 lineto
0.39989 0.45718 lineto
0.39824 0.45001 lineto
0.39903 0.44566 lineto
0.4024 0.44409 lineto
0.40823 0.445 lineto
0.41615 0.44786 lineto
0.42558 0.45192 lineto
0.43583 0.45633 lineto
0.44612 0.46016 lineto
0.45571 0.46256 lineto
0.46394 0.46284 lineto
0.47031 0.46052 lineto
0.47455 0.45539 lineto
0.47659 0.44754 lineto
0.47662 0.43733 lineto
0.47502 0.42533 lineto
0.47235 0.41227 lineto
0.46932 0.39892 lineto
0.46665 0.38606 lineto
0.46509 0.37436 lineto
0.46532 0.36433 lineto
0.46789 0.35633 lineto
0.47321 0.35052 lineto
0.48144 0.34689 lineto
0.49258 0.34533 lineto
0.50636 0.34564 lineto
0.52235 0.34759 lineto
0.53993 0.35099 lineto
0.55835 0.35574 lineto
0.57681 0.36178 lineto
0.5945 0.36918 lineto
0.61066 0.37808 lineto
0.62463 0.38866 lineto
0.63591 0.40111 lineto
0.64416 0.41557 lineto
Mistroke
0.64925 0.4321 lineto
0.65121 0.45065 lineto
0.65025 0.471 lineto
0.64668 0.49281 lineto
0.64092 0.51559 lineto
0.63341 0.53876 lineto
0.62458 0.56167 lineto
0.61481 0.5837 lineto
0.6044 0.60423 lineto
0.59356 0.62277 lineto
0.58237 0.63893 lineto
0.57084 0.65245 lineto
0.55893 0.66322 lineto
0.54659 0.67125 lineto
0.5338 0.67664 lineto
0.52061 0.67956 lineto
0.5072 0.68023 lineto
0.49385 0.67888 lineto
0.48094 0.67575 lineto
0.46894 0.67107 lineto
0.4583 0.66504 lineto
0.44942 0.65783 lineto
Mfstroke
0.44258 0.6496 moveto
0.44942 0.65783 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(171)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(19)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.383398)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(19)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.42351 0.54052 moveto
0.41952 0.52489 lineto
0.41482 0.50957 lineto
0.40979 0.49499 lineto
0.40497 0.48163 lineto
0.40092 0.46995 lineto
0.39819 0.46036 lineto
0.39725 0.45312 lineto
0.39838 0.44837 lineto
0.4017 0.44603 lineto
0.4071 0.44581 lineto
0.41429 0.44723 lineto
0.42279 0.44967 lineto
0.43201 0.45239 lineto
0.44132 0.45463 lineto
0.45009 0.45567 lineto
0.45775 0.45494 lineto
0.46389 0.45202 lineto
0.46826 0.44674 lineto
0.47081 0.43915 lineto
0.47168 0.42953 lineto
0.47121 0.41833 lineto
0.46989 0.40615 lineto
0.4683 0.39364 lineto
0.46709 0.38147 lineto
0.46693 0.37022 lineto
0.4684 0.36039 lineto
0.47199 0.35232 lineto
0.47804 0.34623 lineto
0.48672 0.3422 lineto
0.49799 0.34018 lineto
0.51163 0.34009 lineto
0.52724 0.34179 lineto
0.54426 0.34517 lineto
0.56203 0.35013 lineto
0.57983 0.35666 lineto
0.59692 0.36478 lineto
0.6126 0.37457 lineto
0.62629 0.38615 lineto
0.6375 0.39962 lineto
0.64591 0.41504 lineto
0.65136 0.4324 lineto
0.65385 0.45159 lineto
0.6535 0.47239 lineto
0.65058 0.49446 lineto
0.64542 0.51735 lineto
0.63839 0.54054 lineto
0.62985 0.56345 lineto
0.62016 0.5855 lineto
0.60958 0.60617 lineto
Mistroke
0.59833 0.62496 lineto
0.58654 0.64152 lineto
0.57429 0.65557 lineto
0.56161 0.66697 lineto
0.54856 0.67568 lineto
0.53518 0.68176 lineto
0.5216 0.68532 lineto
0.508 0.68655 lineto
0.49467 0.68565 lineto
0.48192 0.68284 lineto
0.47013 0.67835 lineto
0.45965 0.67235 lineto
0.45076 0.66505 lineto
0.44365 0.65657 lineto
0.43836 0.64705 lineto
0.43475 0.63656 lineto
0.43255 0.62516 lineto
0.43133 0.61289 lineto
0.4306 0.59978 lineto
0.42984 0.58588 lineto
0.42861 0.57127 lineto
0.42655 0.55608 lineto
Mfstroke
0.42351 0.54052 moveto
0.42655 0.55608 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(190)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(20)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.404722)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(20)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.40327 0.447 moveto
0.40909 0.44642 lineto
0.41624 0.44698 lineto
0.42428 0.4481 lineto
0.43269 0.44913 lineto
0.44096 0.44947 lineto
0.44858 0.44857 lineto
0.45515 0.446 lineto
0.46037 0.44153 lineto
0.46412 0.43507 lineto
0.46645 0.42676 lineto
0.46754 0.41689 lineto
0.46777 0.40588 lineto
0.46759 0.39427 lineto
0.46753 0.38262 lineto
0.46817 0.37146 lineto
0.47004 0.36128 lineto
0.47361 0.35251 lineto
0.47925 0.34541 lineto
0.48716 0.34019 lineto
0.4974 0.33693 lineto
0.50986 0.33563 lineto
0.52424 0.33625 lineto
0.54011 0.33874 lineto
0.55694 0.34304 lineto
0.5741 0.3491 lineto
0.59093 0.35693 lineto
0.60679 0.36655 lineto
0.62109 0.37801 lineto
0.63332 0.39136 lineto
0.64311 0.4066 lineto
0.65021 0.42372 lineto
0.65451 0.4426 lineto
0.65603 0.46305 lineto
0.65492 0.48478 lineto
0.6514 0.50742 lineto
0.64576 0.53052 lineto
0.63832 0.55358 lineto
0.62939 0.57607 lineto
0.61925 0.59748 lineto
0.60815 0.61735 lineto
0.59628 0.63527 lineto
0.58379 0.65094 lineto
0.5708 0.66413 lineto
0.5574 0.67472 lineto
0.54371 0.68269 lineto
0.52987 0.68809 lineto
0.51606 0.69103 lineto
0.50251 0.69167 lineto
0.48949 0.6902 lineto
Mistroke
0.47729 0.68682 lineto
0.46619 0.68171 lineto
0.45644 0.67507 lineto
0.4482 0.66705 lineto
0.44153 0.65779 lineto
0.43638 0.64741 lineto
0.43257 0.636 lineto
0.4298 0.62363 lineto
0.42772 0.61037 lineto
0.42593 0.59631 lineto
0.42407 0.58156 lineto
0.42182 0.56627 lineto
0.419 0.55064 lineto
0.41557 0.53496 lineto
0.41165 0.51953 lineto
0.40748 0.50475 lineto
0.40342 0.49101 lineto
0.39991 0.4787 lineto
0.39738 0.46818 lineto
0.39623 0.45969 lineto
0.39675 0.45337 lineto
0.3991 0.4492 lineto
Mfstroke
0.40327 0.447 moveto
0.3991 0.4492 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(210)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(21)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.424946)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(21)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.46196 0.41938 moveto
0.46395 0.41002 lineto
0.46529 0.3997 lineto
0.46638 0.38884 lineto
0.46766 0.37791 lineto
0.46962 0.36739 lineto
0.4727 0.35772 lineto
0.4773 0.34926 lineto
0.48373 0.34233 lineto
0.49215 0.33713 lineto
0.50261 0.33379 lineto
0.515 0.3324 lineto
0.52905 0.33296 lineto
0.5444 0.33547 lineto
0.56056 0.33991 lineto
0.57697 0.34627 lineto
0.59307 0.35453 lineto
0.60828 0.3647 lineto
0.62205 0.37678 lineto
0.63394 0.39078 lineto
0.64358 0.40664 lineto
0.65074 0.42429 lineto
0.65527 0.44359 lineto
0.65716 0.46433 lineto
0.65651 0.4862 lineto
0.65349 0.50886 lineto
0.64831 0.53188 lineto
0.64126 0.5548 lineto
0.63258 0.57716 lineto
0.62256 0.59848 lineto
0.61142 0.61835 lineto
0.59938 0.63637 lineto
0.58662 0.65226 lineto
0.5733 0.66578 lineto
0.55958 0.67679 lineto
0.54561 0.68525 lineto
0.53156 0.69117 lineto
0.51764 0.69463 lineto
0.50407 0.69574 lineto
0.49109 0.69468 lineto
0.47893 0.69161 lineto
0.46782 0.6867 lineto
0.45795 0.68014 lineto
0.44941 0.67208 lineto
0.44226 0.66267 lineto
0.43642 0.65203 lineto
0.43175 0.64028 lineto
0.42802 0.62751 lineto
0.42494 0.61386 lineto
0.42222 0.59942 lineto
Mistroke
0.41958 0.58437 lineto
0.41681 0.56887 lineto
0.41377 0.55316 lineto
0.41043 0.53752 lineto
0.40688 0.52225 lineto
0.40333 0.50769 lineto
0.40005 0.49418 lineto
0.39736 0.48206 lineto
0.3956 0.47158 lineto
0.39505 0.46295 lineto
0.39594 0.45623 lineto
0.39838 0.45138 lineto
0.40235 0.44823 lineto
0.40771 0.44646 lineto
0.41419 0.44566 lineto
0.42143 0.44534 lineto
0.42903 0.44496 lineto
0.43655 0.44403 lineto
0.44359 0.44209 lineto
0.44981 0.4388 lineto
0.455 0.43393 lineto
0.45903 0.42743 lineto
Mfstroke
0.46196 0.41938 moveto
0.45903 0.42743 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(231)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(22)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.444079)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(22)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.51352 0.33056 moveto
0.52657 0.33019 lineto
0.54089 0.3318 lineto
0.5561 0.33541 lineto
0.57175 0.34103 lineto
0.58733 0.34865 lineto
0.60233 0.35826 lineto
0.61626 0.36985 lineto
0.62866 0.38337 lineto
0.63914 0.39878 lineto
0.64743 0.41597 lineto
0.65333 0.43479 lineto
0.65674 0.45505 lineto
0.65767 0.47649 lineto
0.65621 0.49878 lineto
0.6525 0.52156 lineto
0.64674 0.54442 lineto
0.63917 0.56692 lineto
0.63003 0.58864 lineto
0.61955 0.60916 lineto
0.60797 0.62811 lineto
0.59548 0.64516 lineto
0.5823 0.66005 lineto
0.5686 0.67261 lineto
0.55459 0.6827 lineto
0.54045 0.6903 lineto
0.52637 0.69543 lineto
0.51258 0.69814 lineto
0.49928 0.69856 lineto
0.48669 0.69683 lineto
0.475 0.69309 lineto
0.46437 0.68752 lineto
0.45491 0.68027 lineto
0.44667 0.6715 lineto
0.43963 0.66135 lineto
0.4337 0.64996 lineto
0.42872 0.63746 lineto
0.4245 0.62399 lineto
0.42082 0.6097 lineto
0.41747 0.59475 lineto
0.41425 0.57934 lineto
0.41104 0.56368 lineto
0.40778 0.54803 lineto
0.40452 0.53268 lineto
0.40135 0.51792 lineto
0.39846 0.50405 lineto
0.39609 0.49135 lineto
0.39446 0.48007 lineto
0.39383 0.47037 lineto
0.39437 0.46236 lineto
Mistroke
0.39621 0.45602 lineto
0.39936 0.45124 lineto
0.40374 0.4478 lineto
0.4092 0.44537 lineto
0.41547 0.44358 lineto
0.42224 0.44199 lineto
0.42917 0.44018 lineto
0.43592 0.43773 lineto
0.44219 0.43433 lineto
0.44777 0.42973 lineto
0.45251 0.42381 lineto
0.4564 0.41658 lineto
0.45952 0.40816 lineto
0.46207 0.39879 lineto
0.46434 0.38879 lineto
0.46667 0.37853 lineto
0.46946 0.36843 lineto
0.4731 0.35888 lineto
0.47794 0.35025 lineto
0.48426 0.34288 lineto
0.49227 0.33701 lineto
0.50203 0.33286 lineto
Mfstroke
0.51352 0.33056 moveto
0.50203 0.33286 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(253)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(23)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.462284)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(23)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.65283 0.43603 moveto
0.65635 0.45638 lineto
0.65751 0.47781 lineto
0.65636 0.5 lineto
0.653 0.5226 lineto
0.64761 0.54522 lineto
0.64038 0.56748 lineto
0.63151 0.58897 lineto
0.62124 0.60931 lineto
0.60978 0.62815 lineto
0.59737 0.64518 lineto
0.58421 0.66016 lineto
0.57051 0.67289 lineto
0.55648 0.68326 lineto
0.54233 0.69119 lineto
0.52826 0.69669 lineto
0.51449 0.6998 lineto
0.50121 0.70059 lineto
0.4886 0.6992 lineto
0.47684 0.69575 lineto
0.46605 0.69039 lineto
0.45632 0.68328 lineto
0.44769 0.67457 lineto
0.44013 0.66441 lineto
0.43357 0.65295 lineto
0.4279 0.64036 lineto
0.42296 0.62678 lineto
0.4186 0.6124 lineto
0.41466 0.5974 lineto
0.411 0.58199 lineto
0.40754 0.56641 lineto
0.40423 0.55089 lineto
0.40111 0.53571 lineto
0.39826 0.52113 lineto
0.39581 0.50742 lineto
0.39394 0.49482 lineto
0.39282 0.48351 lineto
0.39261 0.47363 lineto
0.39344 0.46525 lineto
0.39539 0.45833 lineto
0.39846 0.45276 lineto
0.40258 0.44834 lineto
0.40761 0.44481 lineto
0.41334 0.44184 lineto
0.41953 0.43907 lineto
0.42589 0.43615 lineto
0.43217 0.43275 lineto
0.43813 0.4286 lineto
0.44361 0.4235 lineto
0.44849 0.41734 lineto
Mistroke
0.45277 0.41013 lineto
0.45653 0.40196 lineto
0.45992 0.39303 lineto
0.46319 0.3836 lineto
0.46661 0.37399 lineto
0.47052 0.36453 lineto
0.47521 0.35559 lineto
0.48098 0.34749 lineto
0.48805 0.34055 lineto
0.49658 0.33503 lineto
0.50662 0.33112 lineto
0.51814 0.32901 lineto
0.53097 0.3288 lineto
0.54486 0.33057 lineto
0.55949 0.33436 lineto
0.57445 0.34021 lineto
0.58931 0.34811 lineto
0.6036 0.35804 lineto
0.61689 0.36997 lineto
0.62876 0.38384 lineto
0.63888 0.39957 lineto
0.64697 0.41702 lineto
Mfstroke
0.65283 0.43603 moveto
0.64697 0.41702 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(276)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(24)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.479843)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(24)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.57905 0.66648 moveto
0.56526 0.6782 lineto
0.55122 0.68758 lineto
0.53715 0.69457 lineto
0.52327 0.69919 lineto
0.50975 0.70147 lineto
0.49678 0.70149 lineto
0.48452 0.69935 lineto
0.4731 0.69519 lineto
0.46261 0.68915 lineto
0.4531 0.68137 lineto
0.44458 0.67202 lineto
0.43702 0.66125 lineto
0.43035 0.64923 lineto
0.42446 0.63614 lineto
0.41924 0.62216 lineto
0.41458 0.60749 lineto
0.41036 0.59233 lineto
0.40652 0.57692 lineto
0.403 0.56148 lineto
0.3998 0.54627 lineto
0.39697 0.53154 lineto
0.39459 0.51751 lineto
0.39276 0.50441 lineto
0.39162 0.49242 lineto
0.39128 0.48166 lineto
0.39184 0.47221 lineto
0.39336 0.46407 lineto
0.39587 0.45717 lineto
0.39932 0.45137 lineto
0.40362 0.44647 lineto
0.40862 0.44221 lineto
0.41414 0.43832 lineto
0.41998 0.43448 lineto
0.42591 0.43042 lineto
0.43176 0.4259 lineto
0.43735 0.42071 lineto
0.44259 0.41473 lineto
0.44744 0.40791 lineto
0.45192 0.4003 lineto
0.45615 0.39202 lineto
0.46027 0.38324 lineto
0.46452 0.37422 lineto
0.46913 0.36525 lineto
0.47435 0.35662 lineto
0.48043 0.34864 lineto
0.48758 0.34161 lineto
0.49593 0.3358 lineto
0.50557 0.33144 lineto
0.51648 0.32873 lineto
Mistroke
0.52858 0.32782 lineto
0.54167 0.32883 lineto
0.5555 0.33183 lineto
0.56974 0.33688 lineto
0.58403 0.344 lineto
0.59796 0.35317 lineto
0.61114 0.36436 lineto
0.62319 0.37753 lineto
0.63375 0.39256 lineto
0.64255 0.40934 lineto
0.64936 0.42771 lineto
0.65402 0.44745 lineto
0.65646 0.46832 lineto
0.65665 0.49004 lineto
0.65465 0.51228 lineto
0.65057 0.53468 lineto
0.64456 0.5569 lineto
0.6368 0.57854 lineto
0.62748 0.59925 lineto
0.61683 0.61869 lineto
0.60506 0.63654 lineto
0.59239 0.65255 lineto
Mfstroke
0.57905 0.66648 moveto
0.59239 0.65255 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(300)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(25)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.497071)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(25)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.4374 0.66319 moveto
0.43023 0.6513 lineto
0.42382 0.63832 lineto
0.41811 0.62445 lineto
0.413 0.6099 lineto
0.40843 0.59489 lineto
0.40433 0.57964 lineto
0.40069 0.56439 lineto
0.39749 0.54936 lineto
0.39477 0.53478 lineto
0.39259 0.52087 lineto
0.39102 0.5078 lineto
0.39014 0.49574 lineto
0.39003 0.48479 lineto
0.39077 0.47499 lineto
0.39237 0.46635 lineto
0.39484 0.4588 lineto
0.39815 0.45222 lineto
0.40219 0.44642 lineto
0.40687 0.44121 lineto
0.41202 0.43635 lineto
0.41749 0.43158 lineto
0.42311 0.42668 lineto
0.42874 0.42145 lineto
0.43426 0.41573 lineto
0.43959 0.40941 lineto
0.4447 0.40246 lineto
0.44964 0.3949 lineto
0.45447 0.38685 lineto
0.45933 0.37846 lineto
0.46441 0.36992 lineto
0.46988 0.3615 lineto
0.47595 0.35345 lineto
0.4828 0.34606 lineto
0.4906 0.33957 lineto
0.49944 0.33426 lineto
0.50938 0.33035 lineto
0.52039 0.32802 lineto
0.53239 0.32745 lineto
0.5452 0.32875 lineto
0.55859 0.33203 lineto
0.57227 0.33732 lineto
0.58593 0.34467 lineto
0.59921 0.35407 lineto
0.61175 0.36547 lineto
0.62323 0.3788 lineto
0.63332 0.39397 lineto
0.64177 0.41084 lineto
0.64835 0.42922 lineto
0.65291 0.44891 lineto
Mistroke
0.65537 0.46966 lineto
0.6557 0.49119 lineto
0.65392 0.51318 lineto
0.65011 0.5353 lineto
0.6444 0.55721 lineto
0.63695 0.57855 lineto
0.62794 0.59899 lineto
0.61756 0.6182 lineto
0.60605 0.6359 lineto
0.59361 0.65183 lineto
0.58046 0.66577 lineto
0.56683 0.67757 lineto
0.55294 0.68712 lineto
0.53899 0.69434 lineto
0.52519 0.69923 lineto
0.51171 0.7018 lineto
0.49875 0.70212 lineto
0.48642 0.70028 lineto
0.47486 0.69639 lineto
0.46415 0.69059 lineto
0.45433 0.68301 lineto
0.44542 0.67382 lineto
Mfstroke
0.4374 0.66319 moveto
0.44542 0.67382 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(325)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(26)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.514258)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(26)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.3887 0.49322 moveto
0.38914 0.48255 lineto
0.39037 0.4729 lineto
0.3924 0.46426 lineto
0.39521 0.45652 lineto
0.39872 0.44958 lineto
0.40286 0.44325 lineto
0.40752 0.43736 lineto
0.41257 0.43171 lineto
0.41788 0.42611 lineto
0.42334 0.42036 lineto
0.42885 0.41433 lineto
0.43433 0.40791 lineto
0.43975 0.40104 lineto
0.44511 0.39372 lineto
0.45046 0.38602 lineto
0.4559 0.37803 lineto
0.46154 0.36992 lineto
0.46754 0.36189 lineto
0.47403 0.35415 lineto
0.48118 0.34695 lineto
0.48911 0.34054 lineto
0.49791 0.33515 lineto
0.50765 0.33101 lineto
0.5183 0.32832 lineto
0.52981 0.32727 lineto
0.54206 0.32798 lineto
0.55486 0.33058 lineto
0.56798 0.33515 lineto
0.58115 0.34172 lineto
0.59406 0.35031 lineto
0.60642 0.3609 lineto
0.61789 0.37342 lineto
0.6282 0.38778 lineto
0.63708 0.40387 lineto
0.6443 0.4215 lineto
0.6497 0.44049 lineto
0.65314 0.4606 lineto
0.65456 0.48157 lineto
0.65395 0.50312 lineto
0.65134 0.52492 lineto
0.64682 0.54666 lineto
0.64051 0.56801 lineto
0.63256 0.58864 lineto
0.62315 0.60823 lineto
0.61248 0.62651 lineto
0.60075 0.6432 lineto
0.58819 0.65809 lineto
0.57501 0.67098 lineto
0.56142 0.68174 lineto
Mistroke
0.54764 0.69028 lineto
0.53387 0.69654 lineto
0.52029 0.7005 lineto
0.50708 0.70221 lineto
0.49439 0.70172 lineto
0.48233 0.69912 lineto
0.47101 0.69452 lineto
0.46049 0.68806 lineto
0.45081 0.67989 lineto
0.44198 0.67017 lineto
0.43397 0.65908 lineto
0.42674 0.6468 lineto
0.42026 0.63353 lineto
0.41446 0.61949 lineto
0.40928 0.60487 lineto
0.40469 0.58991 lineto
0.40065 0.57483 lineto
0.39715 0.55984 lineto
0.3942 0.54517 lineto
0.39183 0.53101 lineto
0.39009 0.51754 lineto
0.38903 0.5049 lineto
Mfstroke
0.3887 0.49322 moveto
0.38903 0.5049 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(351)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(27)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.531642)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(27)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.43772 0.39646 moveto
0.44341 0.38907 lineto
0.44922 0.38145 lineto
0.4552 0.37368 lineto
0.46146 0.36591 lineto
0.4681 0.3583 lineto
0.47525 0.35106 lineto
0.48301 0.34439 lineto
0.49147 0.33852 lineto
0.5007 0.33367 lineto
0.51072 0.33005 lineto
0.52152 0.32784 lineto
0.53301 0.32722 lineto
0.5451 0.32833 lineto
0.5576 0.33128 lineto
0.57031 0.33615 lineto
0.58298 0.34298 lineto
0.59536 0.35178 lineto
0.60715 0.36253 lineto
0.61809 0.37516 lineto
0.62792 0.38958 lineto
0.63638 0.40566 lineto
0.64329 0.42323 lineto
0.64846 0.4421 lineto
0.65179 0.46203 lineto
0.6532 0.48277 lineto
0.65267 0.50403 lineto
0.65022 0.52553 lineto
0.64592 0.54694 lineto
0.63988 0.56796 lineto
0.63223 0.58827 lineto
0.62314 0.6076 lineto
0.61278 0.62564 lineto
0.60136 0.64217 lineto
0.58908 0.65695 lineto
0.57616 0.66982 lineto
0.5628 0.68062 lineto
0.54921 0.68926 lineto
0.53558 0.69568 lineto
0.5221 0.69985 lineto
0.50893 0.7018 lineto
0.49621 0.70157 lineto
0.48406 0.69925 lineto
0.47258 0.69492 lineto
0.46184 0.68874 lineto
0.45187 0.68083 lineto
0.4427 0.67137 lineto
0.43432 0.66052 lineto
0.42672 0.64849 lineto
0.41986 0.63546 lineto
Mistroke
0.41372 0.62165 lineto
0.40824 0.60726 lineto
0.40341 0.59252 lineto
0.3992 0.57764 lineto
0.39561 0.56284 lineto
0.39264 0.5483 lineto
0.39031 0.53422 lineto
0.38865 0.52076 lineto
0.38769 0.50804 lineto
0.38745 0.49616 lineto
0.38795 0.48518 lineto
0.38921 0.4751 lineto
0.39122 0.46591 lineto
0.39393 0.45753 lineto
0.3973 0.44985 lineto
0.40125 0.44275 lineto
0.4057 0.43606 lineto
0.41054 0.42963 lineto
0.41569 0.42329 lineto
0.42104 0.41691 lineto
0.42653 0.41036 lineto
0.43209 0.40356 lineto
Mfstroke
0.43772 0.39646 moveto
0.43209 0.40356 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(378)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(28)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.549409)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(28)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.55394 0.33027 moveto
0.56625 0.3345 lineto
0.57856 0.34063 lineto
0.59065 0.34868 lineto
0.60227 0.35864 lineto
0.61316 0.37045 lineto
0.6231 0.38406 lineto
0.63184 0.39932 lineto
0.63919 0.41611 lineto
0.64497 0.43423 lineto
0.64905 0.45348 lineto
0.65134 0.47362 lineto
0.65179 0.49438 lineto
0.65038 0.51549 lineto
0.64716 0.53665 lineto
0.64219 0.55757 lineto
0.63559 0.57795 lineto
0.62749 0.59751 lineto
0.61806 0.61596 lineto
0.60746 0.63307 lineto
0.59589 0.6486 lineto
0.58355 0.66235 lineto
0.57064 0.67418 lineto
0.55737 0.68395 lineto
0.54392 0.69159 lineto
0.53048 0.69704 lineto
0.51721 0.7003 lineto
0.50426 0.70139 lineto
0.49176 0.70036 lineto
0.47983 0.6973 lineto
0.46853 0.69231 lineto
0.45795 0.68553 lineto
0.4481 0.67712 lineto
0.43902 0.66723 lineto
0.43071 0.65605 lineto
0.42315 0.64377 lineto
0.41634 0.63059 lineto
0.41025 0.61673 lineto
0.40485 0.60238 lineto
0.40015 0.58777 lineto
0.39611 0.57309 lineto
0.39275 0.55855 lineto
0.39007 0.54431 lineto
0.38808 0.53054 lineto
0.3868 0.51736 lineto
0.38623 0.50489 lineto
0.38639 0.49319 lineto
0.38728 0.48228 lineto
0.38889 0.47218 lineto
0.39118 0.46283 lineto
Mistroke
0.39413 0.45417 lineto
0.39767 0.4461 lineto
0.40173 0.4385 lineto
0.40624 0.43123 lineto
0.41112 0.42418 lineto
0.4163 0.41721 lineto
0.42172 0.41023 lineto
0.42732 0.40314 lineto
0.43309 0.39591 lineto
0.43902 0.38852 lineto
0.44513 0.38099 lineto
0.45147 0.37341 lineto
0.45809 0.36586 lineto
0.46509 0.35849 lineto
0.47254 0.35146 lineto
0.48053 0.34496 lineto
0.48912 0.33918 lineto
0.49838 0.33433 lineto
0.50831 0.33059 lineto
0.5189 0.32816 lineto
0.53011 0.3272 lineto
0.54183 0.32786 lineto
Mfstroke
0.55394 0.33027 moveto
0.54183 0.32786 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(406)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(29)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.567706)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(29)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.64595 0.537 moveto
0.64118 0.55759 lineto
0.63483 0.57764 lineto
0.62701 0.5969 lineto
0.61787 0.61509 lineto
0.60758 0.63197 lineto
0.59631 0.64734 lineto
0.58427 0.66099 lineto
0.57163 0.67277 lineto
0.55858 0.68257 lineto
0.54532 0.69028 lineto
0.53202 0.69586 lineto
0.51883 0.6993 lineto
0.50591 0.70061 lineto
0.49338 0.69983 lineto
0.48135 0.69704 lineto
0.46991 0.69235 lineto
0.45913 0.68588 lineto
0.44904 0.67777 lineto
0.4397 0.66819 lineto
0.4311 0.65732 lineto
0.42325 0.64535 lineto
0.41616 0.63246 lineto
0.40981 0.61887 lineto
0.40419 0.60479 lineto
0.3993 0.5904 lineto
0.39512 0.57591 lineto
0.39166 0.56149 lineto
0.38892 0.54732 lineto
0.3869 0.53355 lineto
0.3856 0.52028 lineto
0.38502 0.50763 lineto
0.38518 0.49565 lineto
0.38604 0.48438 lineto
0.3876 0.47382 lineto
0.38983 0.46393 lineto
0.39268 0.45466 lineto
0.39612 0.44594 lineto
0.40007 0.43767 lineto
0.40448 0.42975 lineto
0.4093 0.42206 lineto
0.41445 0.41453 lineto
0.41991 0.40706 lineto
0.42562 0.39959 lineto
0.43157 0.39208 lineto
0.43777 0.38455 lineto
0.44423 0.37701 lineto
0.45097 0.36952 lineto
0.45807 0.36219 lineto
0.46555 0.35513 lineto
Mistroke
0.4735 0.34849 lineto
0.48196 0.34244 lineto
0.49098 0.33714 lineto
0.50058 0.3328 lineto
0.51077 0.32957 lineto
0.52151 0.32764 lineto
0.53275 0.32716 lineto
0.54439 0.32826 lineto
0.55631 0.33106 lineto
0.56833 0.33564 lineto
0.58028 0.34206 lineto
0.59194 0.35034 lineto
0.6031 0.36046 lineto
0.61353 0.37239 lineto
0.62302 0.38603 lineto
0.63136 0.40128 lineto
0.63837 0.41798 lineto
0.64388 0.43596 lineto
0.64777 0.45501 lineto
0.64996 0.4749 lineto
0.65038 0.49538 lineto
0.64904 0.51617 lineto
Mfstroke
0.64595 0.537 moveto
0.64904 0.51617 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; endGroup; endGroup; pictureTop = 13; pictureWidth = 413; pictureHeight = 438; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(435)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(30)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(72)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.586657)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(30)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.004 setlinewidth
0.4888 0.69813 moveto
0.47696 0.69466 lineto
0.46569 0.68936 lineto
0.45506 0.68237 lineto
0.44512 0.67383 lineto
0.4359 0.66391 lineto
0.42743 0.65279 lineto
0.41971 0.64064 lineto
0.41274 0.62768 lineto
0.40654 0.61409 lineto
0.40109 0.60007 lineto
0.39639 0.5858 lineto
0.39244 0.57147 lineto
0.38923 0.55725 lineto
0.38677 0.54328 lineto
0.38505 0.52968 lineto
0.38407 0.51657 lineto
0.38382 0.50402 lineto
0.38429 0.49207 lineto
0.38545 0.48075 lineto
0.38729 0.47005 lineto
0.38976 0.45994 lineto
0.39283 0.45037 lineto
0.39646 0.44128 lineto
0.40058 0.43258 lineto
0.40516 0.42419 lineto
0.41015 0.41605 lineto
0.4155 0.40807 lineto
0.42119 0.4002 lineto
0.42718 0.39241 lineto
0.43349 0.3847 lineto
0.44011 0.37707 lineto
0.44706 0.36958 lineto
0.45437 0.36229 lineto
0.46208 0.35531 lineto
0.47022 0.34876 lineto
0.47884 0.34279 lineto
0.48796 0.33753 lineto
0.4976 0.33317 lineto
0.50776 0.32985 lineto
0.5184 0.32775 lineto
0.52947 0.327 lineto
0.5409 0.32775 lineto
0.55256 0.3301 lineto
0.56433 0.33415 lineto
0.57604 0.33996 lineto
0.58751 0.34757 lineto
0.59855 0.35697 lineto
0.60896 0.36813 lineto
0.61853 0.38099 lineto
Mistroke
0.62708 0.39545 lineto
0.63442 0.41139 lineto
0.6404 0.42863 lineto
0.64489 0.44699 lineto
0.64779 0.46626 lineto
0.64902 0.4862 lineto
0.64857 0.50657 lineto
0.64642 0.52709 lineto
0.64262 0.5475 lineto
0.63724 0.56753 lineto
0.63038 0.5869 lineto
0.62215 0.60537 lineto
0.61271 0.62269 lineto
0.60221 0.63864 lineto
0.59082 0.65302 lineto
0.57873 0.66567 lineto
0.56611 0.67644 lineto
0.55315 0.68524 lineto
0.54002 0.69198 lineto
0.52687 0.69663 lineto
0.51387 0.69918 lineto
0.50114 0.69966 lineto
Mfstroke
0.4888 0.69813 moveto
0.50114 0.69966 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = subsubsection; inactive; startGroup; ]
Other, more complicated examples.
:[font = text; inactive; ]
Now, other examples of more complicated constructions which require a lot of memory.  You can just copy the code and execute it. Below each code there is one or two frames generated by the code.
:[font = input; ]

(**************************************************************)
    MidPointPolygonMovie[RandomStellarPolygon[70],
                           Blowing->Resized,
                           TotalFrameNumber->150,
                           Style->Vertices,
                           FractionPoint->.1
                        ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 129; pictureTop = 2; pictureWidth = 190; pictureHeight = 190; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(109)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(110)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(70)] 1 1 1.7 1.7 Mshowa
0 setgray
[(          8)(3.92564 10)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(110)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.60533 0.82432 Mdot
0.38215 0 Mdot
0.52894 0.82706 Mdot
0.5977 0.57329 Mdot
0.3386 0.08001 Mdot
0.60275 0.97309 Mdot
0.54552 0.29725 Mdot
0.32325 0.30546 Mdot
0.68775 0.94093 Mdot
0.44119 0.12439 Mdot
0.37494 0.56285 Mdot
0.73142 0.76453 Mdot
0.32314 0.12075 Mdot
0.49176 0.72082 Mdot
0.69654 0.57217 Mdot
0.24673 0.22421 Mdot
0.6344 0.75 Mdot
0.57849 0.46399 Mdot
0.26559 0.31309 Mdot
0.72103 0.74575 Mdot
0.45324 0.39438 Mdot
0.33614 0.38948 Mdot
0.75925 0.72497 Mdot
0.32963 0.35249 Mdot
0.46116 0.44501 Mdot
0.71736 0.71458 Mdot
0.26345 0.30219 Mdot
0.58356 0.51354 Mdot
0.62924 0.69241 Mdot
0.25414 0.2479 Mdot
0.68007 0.60995 Mdot
0.52187 0.62921 Mdot
0.28545 0.22177 Mdot
0.75824 0.71323 Mdot
0.38064 0.52603 Mdot
0.39399 0.23918 Mdot
0.76135 0.80754 Mdot
0.25891 0.37984 Mdot
0.56347 0.33103 Mdot
0.64568 0.84448 Mdot
0.25543 0.2302 Mdot
0.6746 0.49359 Mdot
0.50346 0.7822 Mdot
0.34066 0.14874 Mdot
0.68924 0.65857 Mdot
0.41303 0.65522 Mdot
0.4404 0.14374 Mdot
0.63962 0.7919 Mdot
0.398 0.49333 Mdot
0.4883 0.21146 Mdot
0.60556 0.87288 Mdot
0.39396 0.31869 Mdot
0.51715 0.35506 Mdot
0.58665 0.8626 Mdot
0.37836 0.19158 Mdot
0.56076 0.52285 Mdot
0.5469 0.7786 Mdot
0.38334 0.13349 Mdot
0.59559 0.6712 Mdot
0.49663 0.66198 Mdot
0.41515 0.12087 Mdot
0.59907 0.80848 Mdot
0.46987 0.5073 Mdot
0.4363 0.16242 Mdot
0.60416 0.93235 Mdot
0.44337 0.29064 Mdot
0.4589 0.32032 Mdot
0.60839 0.95522 Mdot
0.41302 0.08728 Mdot
0.49001 0.5741 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; ]
(**************************************************************)
(* the shape of the curve below is taken form the book 
     "Mathematica in action" written by Stan Wagon.           *)

MidPointPolygonMovie[Table[(2+Sin[8 t]/2)
                           {Cos[t+Sin[16 t]/2],
                            Sin[t+Sin[16 t]/2]
                           },{t,Pi/70,2 Pi,Pi/70}
                          ]//N,
                           Blowing->Resized,
                           TotalFrameNumber->50,
                           IterationStep->2,
                           Style->Spokes,
                           FirstFrameIteration->2
                     ]
:[font = postscript; inactive; PostScript; output; pictureLeft = 129; pictureTop = 2; pictureWidth = 190; pictureHeight = 190; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(20)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(140)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.450126)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(10)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.80226 0.70798 Mdot
0.78907 0.70899 Mdot
0.79154 0.69717 Mdot
0.80138 0.68739 Mdot
0.80782 0.69424 Mdot
0.80274 0.72526 Mdot
0.78485 0.77735 Mdot
0.76109 0.83812 Mdot
0.74356 0.8914 Mdot
0.74269 0.92428 Mdot
0.76004 0.93234 Mdot
0.78564 0.9207 Mdot
0.80226 0.90051 Mdot
0.79429 0.88282 Mdot
0.75631 0.87318 Mdot
0.69626 0.87023 Mdot
0.63182 0.86878 Mdot
0.582 0.86442 Mdot
0.55839 0.85655 Mdot
0.56005 0.84831 Mdot
0.57438 0.84452 Mdot
0.58316 0.84909 Mdot
0.57094 0.86321 Mdot
0.53243 0.88496 Mdot
0.47549 0.91058 Mdot
0.41805 0.93658 Mdot
0.37963 0.96074 Mdot
0.37142 0.98137 Mdot
0.39001 0.9958 Mdot
0.4189 1 Mdot
0.43718 0.98991 Mdot
0.43065 0.96371 Mdot
0.39883 0.92373 Mdot
0.35409 0.87687 Mdot
0.31402 0.83319 Mdot
0.29202 0.80226 Mdot
0.29101 0.78907 Mdot
0.30283 0.79154 Mdot
0.31261 0.80138 Mdot
0.30576 0.80782 Mdot
0.27474 0.80274 Mdot
0.22265 0.78485 Mdot
0.16188 0.76109 Mdot
0.1086 0.74356 Mdot
0.07572 0.74269 Mdot
0.06766 0.76004 Mdot
0.0793 0.78564 Mdot
0.09949 0.80226 Mdot
0.11718 0.79429 Mdot
0.12682 0.75631 Mdot
0.12977 0.69626 Mdot
0.13122 0.63182 Mdot
0.13558 0.582 Mdot
0.14345 0.55839 Mdot
0.15169 0.56005 Mdot
0.15548 0.57438 Mdot
0.15091 0.58316 Mdot
0.13679 0.57094 Mdot
0.11504 0.53243 Mdot
0.08942 0.47549 Mdot
0.06342 0.41805 Mdot
0.03926 0.37963 Mdot
0.01863 0.37142 Mdot
0.0042 0.39001 Mdot
0 0.4189 Mdot
0.01009 0.43718 Mdot
0.03629 0.43065 Mdot
0.07627 0.39883 Mdot
0.12313 0.35409 Mdot
0.16681 0.31402 Mdot
0.19774 0.29202 Mdot
0.21093 0.29101 Mdot
0.20846 0.30283 Mdot
0.19862 0.31261 Mdot
0.19218 0.30576 Mdot
0.19726 0.27474 Mdot
0.21515 0.22265 Mdot
0.23891 0.16188 Mdot
0.25644 0.1086 Mdot
0.25731 0.07572 Mdot
0.23996 0.06766 Mdot
0.21436 0.0793 Mdot
0.19774 0.09949 Mdot
0.20571 0.11718 Mdot
0.24369 0.12682 Mdot
0.30374 0.12977 Mdot
0.36818 0.13122 Mdot
0.418 0.13558 Mdot
0.44161 0.14345 Mdot
0.43995 0.15169 Mdot
0.42562 0.15548 Mdot
0.41684 0.15091 Mdot
0.42906 0.13679 Mdot
0.46757 0.11504 Mdot
0.52451 0.08942 Mdot
0.58195 0.06342 Mdot
0.62037 0.03926 Mdot
0.62858 0.01863 Mdot
0.60999 0.0042 Mdot
0.5811 0 Mdot
0.56282 0.01009 Mdot
0.56935 0.03629 Mdot
0.60117 0.07627 Mdot
0.64591 0.12313 Mdot
0.68598 0.16681 Mdot
0.70798 0.19774 Mdot
0.70899 0.21093 Mdot
0.69717 0.20846 Mdot
0.68739 0.19862 Mdot
0.69424 0.19218 Mdot
0.72526 0.19726 Mdot
0.77735 0.21515 Mdot
0.83812 0.23891 Mdot
0.8914 0.25644 Mdot
0.92428 0.25731 Mdot
0.93234 0.23996 Mdot
0.9207 0.21436 Mdot
0.90051 0.19774 Mdot
0.88282 0.20571 Mdot
0.87318 0.24369 Mdot
0.87023 0.30374 Mdot
0.86878 0.36818 Mdot
0.86442 0.418 Mdot
0.85655 0.44161 Mdot
0.84831 0.43995 Mdot
0.84452 0.42562 Mdot
0.84909 0.41684 Mdot
0.86321 0.42906 Mdot
0.88496 0.46757 Mdot
0.91058 0.52451 Mdot
0.93658 0.58195 Mdot
0.96074 0.62037 Mdot
0.98137 0.62858 Mdot
0.9958 0.60999 Mdot
1 0.5811 Mdot
0.98991 0.56282 Mdot
0.96371 0.56935 Mdot
0.92373 0.60117 Mdot
0.87687 0.64591 Mdot
0.83319 0.68598 Mdot
0.004 setlinewidth
0.80226 0.70798 moveto
0.78907 0.70899 lineto
0.79154 0.69717 lineto
0.80138 0.68739 lineto
0.80782 0.69424 lineto
0.80274 0.72526 lineto
0.78485 0.77735 lineto
0.76109 0.83812 lineto
0.74356 0.8914 lineto
0.74269 0.92428 lineto
0.76004 0.93234 lineto
0.78564 0.9207 lineto
0.80226 0.90051 lineto
0.79429 0.88282 lineto
0.75631 0.87318 lineto
0.69626 0.87023 lineto
0.63182 0.86878 lineto
0.582 0.86442 lineto
0.55839 0.85655 lineto
0.56005 0.84831 lineto
0.57438 0.84452 lineto
0.58316 0.84909 lineto
0.57094 0.86321 lineto
0.53243 0.88496 lineto
0.47549 0.91058 lineto
0.41805 0.93658 lineto
0.37963 0.96074 lineto
0.37142 0.98137 lineto
0.39001 0.9958 lineto
0.4189 1 lineto
0.43718 0.98991 lineto
0.43065 0.96371 lineto
0.39883 0.92373 lineto
0.35409 0.87687 lineto
0.31402 0.83319 lineto
0.29202 0.80226 lineto
0.29101 0.78907 lineto
0.30283 0.79154 lineto
0.31261 0.80138 lineto
0.30576 0.80782 lineto
0.27474 0.80274 lineto
0.22265 0.78485 lineto
0.16188 0.76109 lineto
0.1086 0.74356 lineto
0.07572 0.74269 lineto
0.06766 0.76004 lineto
0.0793 0.78564 lineto
0.09949 0.80226 lineto
0.11718 0.79429 lineto
0.12682 0.75631 lineto
Mistroke
0.12977 0.69626 lineto
0.13122 0.63182 lineto
0.13558 0.582 lineto
0.14345 0.55839 lineto
0.15169 0.56005 lineto
0.15548 0.57438 lineto
0.15091 0.58316 lineto
0.13679 0.57094 lineto
0.11504 0.53243 lineto
0.08942 0.47549 lineto
0.06342 0.41805 lineto
0.03926 0.37963 lineto
0.01863 0.37142 lineto
0.0042 0.39001 lineto
0 0.4189 lineto
0.01009 0.43718 lineto
0.03629 0.43065 lineto
0.07627 0.39883 lineto
0.12313 0.35409 lineto
0.16681 0.31402 lineto
0.19774 0.29202 lineto
0.21093 0.29101 lineto
0.20846 0.30283 lineto
0.19862 0.31261 lineto
0.19218 0.30576 lineto
0.19726 0.27474 lineto
0.21515 0.22265 lineto
0.23891 0.16188 lineto
0.25644 0.1086 lineto
0.25731 0.07572 lineto
0.23996 0.06766 lineto
0.21436 0.0793 lineto
0.19774 0.09949 lineto
0.20571 0.11718 lineto
0.24369 0.12682 lineto
0.30374 0.12977 lineto
0.36818 0.13122 lineto
0.418 0.13558 lineto
0.44161 0.14345 lineto
0.43995 0.15169 lineto
0.42562 0.15548 lineto
0.41684 0.15091 lineto
0.42906 0.13679 lineto
0.46757 0.11504 lineto
0.52451 0.08942 lineto
0.58195 0.06342 lineto
0.62037 0.03926 lineto
0.62858 0.01863 lineto
0.60999 0.0042 lineto
0.5811 0 lineto
Mistroke
0.56282 0.01009 lineto
0.56935 0.03629 lineto
0.60117 0.07627 lineto
0.64591 0.12313 lineto
0.68598 0.16681 lineto
0.70798 0.19774 lineto
0.70899 0.21093 lineto
0.69717 0.20846 lineto
0.68739 0.19862 lineto
0.69424 0.19218 lineto
0.72526 0.19726 lineto
0.77735 0.21515 lineto
0.83812 0.23891 lineto
0.8914 0.25644 lineto
0.92428 0.25731 lineto
0.93234 0.23996 lineto
0.9207 0.21436 lineto
0.90051 0.19774 lineto
0.88282 0.20571 lineto
0.87318 0.24369 lineto
0.87023 0.30374 lineto
0.86878 0.36818 lineto
0.86442 0.418 lineto
0.85655 0.44161 lineto
0.84831 0.43995 lineto
0.84452 0.42562 lineto
0.84909 0.41684 lineto
0.86321 0.42906 lineto
0.88496 0.46757 lineto
0.91058 0.52451 lineto
0.93658 0.58195 lineto
0.96074 0.62037 lineto
0.98137 0.62858 lineto
0.9958 0.60999 lineto
1 0.5811 lineto
0.98991 0.56282 lineto
0.96371 0.56935 lineto
0.92373 0.60117 lineto
0.87687 0.64591 lineto
0.83319 0.68598 lineto
Mfstroke
0.80226 0.70798 moveto
0.83319 0.68598 lineto
stroke
0.5 0.5 moveto
0.80226 0.70798 lineto
stroke
0.5 0.5 moveto
0.78907 0.70899 lineto
stroke
0.5 0.5 moveto
0.79154 0.69717 lineto
stroke
0.5 0.5 moveto
0.80138 0.68739 lineto
stroke
0.5 0.5 moveto
0.80782 0.69424 lineto
stroke
0.5 0.5 moveto
0.80274 0.72526 lineto
stroke
0.5 0.5 moveto
0.78485 0.77735 lineto
stroke
0.5 0.5 moveto
0.76109 0.83812 lineto
stroke
0.5 0.5 moveto
0.74356 0.8914 lineto
stroke
0.5 0.5 moveto
0.74269 0.92428 lineto
stroke
0.5 0.5 moveto
0.76004 0.93234 lineto
stroke
0.5 0.5 moveto
0.78564 0.9207 lineto
stroke
0.5 0.5 moveto
0.80226 0.90051 lineto
stroke
0.5 0.5 moveto
0.79429 0.88282 lineto
stroke
0.5 0.5 moveto
0.75631 0.87318 lineto
stroke
0.5 0.5 moveto
0.69626 0.87023 lineto
stroke
0.5 0.5 moveto
0.63182 0.86878 lineto
stroke
0.5 0.5 moveto
0.582 0.86442 lineto
stroke
0.5 0.5 moveto
0.55839 0.85655 lineto
stroke
0.5 0.5 moveto
0.56005 0.84831 lineto
stroke
0.5 0.5 moveto
0.57438 0.84452 lineto
stroke
0.5 0.5 moveto
0.58316 0.84909 lineto
stroke
0.5 0.5 moveto
0.57094 0.86321 lineto
stroke
0.5 0.5 moveto
0.53243 0.88496 lineto
stroke
0.5 0.5 moveto
0.47549 0.91058 lineto
stroke
0.5 0.5 moveto
0.41805 0.93658 lineto
stroke
0.5 0.5 moveto
0.37963 0.96074 lineto
stroke
0.5 0.5 moveto
0.37142 0.98137 lineto
stroke
0.5 0.5 moveto
0.39001 0.9958 lineto
stroke
0.5 0.5 moveto
0.4189 1 lineto
stroke
0.5 0.5 moveto
0.43718 0.98991 lineto
stroke
0.5 0.5 moveto
0.43065 0.96371 lineto
stroke
0.5 0.5 moveto
0.39883 0.92373 lineto
stroke
0.5 0.5 moveto
0.35409 0.87687 lineto
stroke
0.5 0.5 moveto
0.31402 0.83319 lineto
stroke
0.5 0.5 moveto
0.29202 0.80226 lineto
stroke
0.5 0.5 moveto
0.29101 0.78907 lineto
stroke
0.5 0.5 moveto
0.30283 0.79154 lineto
stroke
0.5 0.5 moveto
0.31261 0.80138 lineto
stroke
0.5 0.5 moveto
0.30576 0.80782 lineto
stroke
0.5 0.5 moveto
0.27474 0.80274 lineto
stroke
0.5 0.5 moveto
0.22265 0.78485 lineto
stroke
0.5 0.5 moveto
0.16188 0.76109 lineto
stroke
0.5 0.5 moveto
0.1086 0.74356 lineto
stroke
0.5 0.5 moveto
0.07572 0.74269 lineto
stroke
0.5 0.5 moveto
0.06766 0.76004 lineto
stroke
0.5 0.5 moveto
0.0793 0.78564 lineto
stroke
0.5 0.5 moveto
0.09949 0.80226 lineto
stroke
0.5 0.5 moveto
0.11718 0.79429 lineto
stroke
0.5 0.5 moveto
0.12682 0.75631 lineto
stroke
0.5 0.5 moveto
0.12977 0.69626 lineto
stroke
0.5 0.5 moveto
0.13122 0.63182 lineto
stroke
0.5 0.5 moveto
0.13558 0.582 lineto
stroke
0.5 0.5 moveto
0.14345 0.55839 lineto
stroke
0.5 0.5 moveto
0.15169 0.56005 lineto
stroke
0.5 0.5 moveto
0.15548 0.57438 lineto
stroke
0.5 0.5 moveto
0.15091 0.58316 lineto
stroke
0.5 0.5 moveto
0.13679 0.57094 lineto
stroke
0.5 0.5 moveto
0.11504 0.53243 lineto
stroke
0.5 0.5 moveto
0.08942 0.47549 lineto
stroke
0.5 0.5 moveto
0.06342 0.41805 lineto
stroke
0.5 0.5 moveto
0.03926 0.37963 lineto
stroke
0.5 0.5 moveto
0.01863 0.37142 lineto
stroke
0.5 0.5 moveto
0.0042 0.39001 lineto
stroke
0.5 0.5 moveto
0 0.4189 lineto
stroke
0.5 0.5 moveto
0.01009 0.43718 lineto
stroke
0.5 0.5 moveto
0.03629 0.43065 lineto
stroke
0.5 0.5 moveto
0.07627 0.39883 lineto
stroke
0.5 0.5 moveto
0.12313 0.35409 lineto
stroke
0.5 0.5 moveto
0.16681 0.31402 lineto
stroke
0.5 0.5 moveto
0.19774 0.29202 lineto
stroke
0.5 0.5 moveto
0.21093 0.29101 lineto
stroke
0.5 0.5 moveto
0.20846 0.30283 lineto
stroke
0.5 0.5 moveto
0.19862 0.31261 lineto
stroke
0.5 0.5 moveto
0.19218 0.30576 lineto
stroke
0.5 0.5 moveto
0.19726 0.27474 lineto
stroke
0.5 0.5 moveto
0.21515 0.22265 lineto
stroke
0.5 0.5 moveto
0.23891 0.16188 lineto
stroke
0.5 0.5 moveto
0.25644 0.1086 lineto
stroke
0.5 0.5 moveto
0.25731 0.07572 lineto
stroke
0.5 0.5 moveto
0.23996 0.06766 lineto
stroke
0.5 0.5 moveto
0.21436 0.0793 lineto
stroke
0.5 0.5 moveto
0.19774 0.09949 lineto
stroke
0.5 0.5 moveto
0.20571 0.11718 lineto
stroke
0.5 0.5 moveto
0.24369 0.12682 lineto
stroke
0.5 0.5 moveto
0.30374 0.12977 lineto
stroke
0.5 0.5 moveto
0.36818 0.13122 lineto
stroke
0.5 0.5 moveto
0.418 0.13558 lineto
stroke
0.5 0.5 moveto
0.44161 0.14345 lineto
stroke
0.5 0.5 moveto
0.43995 0.15169 lineto
stroke
0.5 0.5 moveto
0.42562 0.15548 lineto
stroke
0.5 0.5 moveto
0.41684 0.15091 lineto
stroke
0.5 0.5 moveto
0.42906 0.13679 lineto
stroke
0.5 0.5 moveto
0.46757 0.11504 lineto
stroke
0.5 0.5 moveto
0.52451 0.08942 lineto
stroke
0.5 0.5 moveto
0.58195 0.06342 lineto
stroke
0.5 0.5 moveto
0.62037 0.03926 lineto
stroke
0.5 0.5 moveto
0.62858 0.01863 lineto
stroke
0.5 0.5 moveto
0.60999 0.0042 lineto
stroke
0.5 0.5 moveto
0.5811 0 lineto
stroke
0.5 0.5 moveto
0.56282 0.01009 lineto
stroke
0.5 0.5 moveto
0.56935 0.03629 lineto
stroke
0.5 0.5 moveto
0.60117 0.07627 lineto
stroke
0.5 0.5 moveto
0.64591 0.12313 lineto
stroke
0.5 0.5 moveto
0.68598 0.16681 lineto
stroke
0.5 0.5 moveto
0.70798 0.19774 lineto
stroke
0.5 0.5 moveto
0.70899 0.21093 lineto
stroke
0.5 0.5 moveto
0.69717 0.20846 lineto
stroke
0.5 0.5 moveto
0.68739 0.19862 lineto
stroke
0.5 0.5 moveto
0.69424 0.19218 lineto
stroke
0.5 0.5 moveto
0.72526 0.19726 lineto
stroke
0.5 0.5 moveto
0.77735 0.21515 lineto
stroke
0.5 0.5 moveto
0.83812 0.23891 lineto
stroke
0.5 0.5 moveto
0.8914 0.25644 lineto
stroke
0.5 0.5 moveto
0.92428 0.25731 lineto
stroke
0.5 0.5 moveto
0.93234 0.23996 lineto
stroke
0.5 0.5 moveto
0.9207 0.21436 lineto
stroke
0.5 0.5 moveto
0.90051 0.19774 lineto
stroke
0.5 0.5 moveto
0.88282 0.20571 lineto
stroke
0.5 0.5 moveto
0.87318 0.24369 lineto
stroke
0.5 0.5 moveto
0.87023 0.30374 lineto
stroke
0.5 0.5 moveto
0.86878 0.36818 lineto
stroke
0.5 0.5 moveto
0.86442 0.418 lineto
stroke
0.5 0.5 moveto
0.85655 0.44161 lineto
stroke
0.5 0.5 moveto
0.84831 0.43995 lineto
stroke
0.5 0.5 moveto
0.84452 0.42562 lineto
stroke
0.5 0.5 moveto
0.84909 0.41684 lineto
stroke
0.5 0.5 moveto
0.86321 0.42906 lineto
stroke
0.5 0.5 moveto
0.88496 0.46757 lineto
stroke
0.5 0.5 moveto
0.91058 0.52451 lineto
stroke
0.5 0.5 moveto
0.93658 0.58195 lineto
stroke
0.5 0.5 moveto
0.96074 0.62037 lineto
stroke
0.5 0.5 moveto
0.98137 0.62858 lineto
stroke
0.5 0.5 moveto
0.9958 0.60999 lineto
stroke
0.5 0.5 moveto
1 0.5811 lineto
stroke
0.5 0.5 moveto
0.98991 0.56282 lineto
stroke
0.5 0.5 moveto
0.96371 0.56935 lineto
stroke
0.5 0.5 moveto
0.92373 0.60117 lineto
stroke
0.5 0.5 moveto
0.87687 0.64591 lineto
stroke
0.5 0.5 moveto
0.83319 0.68598 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; pictureLeft = 129; pictureTop = 2; pictureWidth = 190; pictureHeight = 190; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(80)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(40)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(140)] 1 1 1.7 1.7 Mshowa
0 setgray
[(0.512595)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(40)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.37802 0.98758 Mdot
0.36409 0.97396 Mdot
0.34948 0.95668 Mdot
0.33391 0.93718 Mdot
0.3173 0.91699 Mdot
0.29963 0.89748 Mdot
0.28079 0.87963 Mdot
0.26059 0.86402 Mdot
0.23884 0.85077 Mdot
0.21551 0.8397 Mdot
0.19092 0.83045 Mdot
0.16586 0.82257 Mdot
0.1415 0.81553 Mdot
0.11922 0.8087 Mdot
0.1003 0.80132 Mdot
0.08567 0.79248 Mdot
0.07573 0.78127 Mdot
0.07025 0.76697 Mdot
0.06853 0.7492 Mdot
0.06951 0.7281 Mdot
0.07199 0.70431 Mdot
0.07478 0.67877 Mdot
0.07681 0.65251 Mdot
0.07719 0.62633 Mdot
0.07527 0.6007 Mdot
0.07066 0.57568 Mdot
0.06328 0.55115 Mdot
0.05344 0.52702 Mdot
0.04181 0.50336 Mdot
0.02944 0.48055 Mdot
0.01767 0.45909 Mdot
0.00795 0.43947 Mdot
0.00168 0.4219 Mdot
0 0.40619 Mdot
0.00356 0.39182 Mdot
0.01242 0.37802 Mdot
0.02604 0.36409 Mdot
0.04332 0.34948 Mdot
0.06282 0.33391 Mdot
0.08301 0.3173 Mdot
0.10252 0.29963 Mdot
0.12037 0.28079 Mdot
0.13598 0.26059 Mdot
0.14923 0.23884 Mdot
0.1603 0.21551 Mdot
0.16955 0.19092 Mdot
0.17743 0.16586 Mdot
0.18447 0.1415 Mdot
0.1913 0.11922 Mdot
0.19868 0.1003 Mdot
0.20752 0.08567 Mdot
0.21873 0.07573 Mdot
0.23303 0.07025 Mdot
0.2508 0.06853 Mdot
0.2719 0.06951 Mdot
0.29569 0.07199 Mdot
0.32123 0.07478 Mdot
0.34749 0.07681 Mdot
0.37367 0.07719 Mdot
0.3993 0.07527 Mdot
0.42432 0.07066 Mdot
0.44885 0.06328 Mdot
0.47298 0.05344 Mdot
0.49664 0.04181 Mdot
0.51945 0.02944 Mdot
0.54091 0.01767 Mdot
0.56053 0.00795 Mdot
0.5781 0.00168 Mdot
0.59381 0 Mdot
0.60818 0.00356 Mdot
0.62198 0.01242 Mdot
0.63591 0.02604 Mdot
0.65052 0.04332 Mdot
0.66609 0.06282 Mdot
0.6827 0.08301 Mdot
0.70037 0.10252 Mdot
0.71921 0.12037 Mdot
0.73941 0.13598 Mdot
0.76116 0.14923 Mdot
0.78449 0.1603 Mdot
0.80908 0.16955 Mdot
0.83414 0.17743 Mdot
0.8585 0.18447 Mdot
0.88078 0.1913 Mdot
0.8997 0.19868 Mdot
0.91433 0.20752 Mdot
0.92427 0.21873 Mdot
0.92975 0.23303 Mdot
0.93147 0.2508 Mdot
0.93049 0.2719 Mdot
0.92801 0.29569 Mdot
0.92522 0.32123 Mdot
0.92319 0.34749 Mdot
0.92281 0.37367 Mdot
0.92473 0.3993 Mdot
0.92934 0.42432 Mdot
0.93672 0.44885 Mdot
0.94656 0.47298 Mdot
0.95819 0.49664 Mdot
0.97056 0.51945 Mdot
0.98233 0.54091 Mdot
0.99205 0.56053 Mdot
0.99832 0.5781 Mdot
1 0.59381 Mdot
0.99644 0.60818 Mdot
0.98758 0.62198 Mdot
0.97396 0.63591 Mdot
0.95668 0.65052 Mdot
0.93718 0.66609 Mdot
0.91699 0.6827 Mdot
0.89748 0.70037 Mdot
0.87963 0.71921 Mdot
0.86402 0.73941 Mdot
0.85077 0.76116 Mdot
0.8397 0.78449 Mdot
0.83045 0.80908 Mdot
0.82257 0.83414 Mdot
0.81553 0.8585 Mdot
0.8087 0.88078 Mdot
0.80132 0.8997 Mdot
0.79248 0.91433 Mdot
0.78127 0.92427 Mdot
0.76697 0.92975 Mdot
0.7492 0.93147 Mdot
0.7281 0.93049 Mdot
0.70431 0.92801 Mdot
0.67877 0.92522 Mdot
0.65251 0.92319 Mdot
0.62633 0.92281 Mdot
0.6007 0.92473 Mdot
0.57568 0.92934 Mdot
0.55115 0.93672 Mdot
0.52702 0.94656 Mdot
0.50336 0.95819 Mdot
0.48055 0.97056 Mdot
0.45909 0.98233 Mdot
0.43947 0.99205 Mdot
0.4219 0.99832 Mdot
0.40619 1 Mdot
0.39182 0.99644 Mdot
0.004 setlinewidth
0.37802 0.98758 moveto
0.36409 0.97396 lineto
0.34948 0.95668 lineto
0.33391 0.93718 lineto
0.3173 0.91699 lineto
0.29963 0.89748 lineto
0.28079 0.87963 lineto
0.26059 0.86402 lineto
0.23884 0.85077 lineto
0.21551 0.8397 lineto
0.19092 0.83045 lineto
0.16586 0.82257 lineto
0.1415 0.81553 lineto
0.11922 0.8087 lineto
0.1003 0.80132 lineto
0.08567 0.79248 lineto
0.07573 0.78127 lineto
0.07025 0.76697 lineto
0.06853 0.7492 lineto
0.06951 0.7281 lineto
0.07199 0.70431 lineto
0.07478 0.67877 lineto
0.07681 0.65251 lineto
0.07719 0.62633 lineto
0.07527 0.6007 lineto
0.07066 0.57568 lineto
0.06328 0.55115 lineto
0.05344 0.52702 lineto
0.04181 0.50336 lineto
0.02944 0.48055 lineto
0.01767 0.45909 lineto
0.00795 0.43947 lineto
0.00168 0.4219 lineto
0 0.40619 lineto
0.00356 0.39182 lineto
0.01242 0.37802 lineto
0.02604 0.36409 lineto
0.04332 0.34948 lineto
0.06282 0.33391 lineto
0.08301 0.3173 lineto
0.10252 0.29963 lineto
0.12037 0.28079 lineto
0.13598 0.26059 lineto
0.14923 0.23884 lineto
0.1603 0.21551 lineto
0.16955 0.19092 lineto
0.17743 0.16586 lineto
0.18447 0.1415 lineto
0.1913 0.11922 lineto
0.19868 0.1003 lineto
Mistroke
0.20752 0.08567 lineto
0.21873 0.07573 lineto
0.23303 0.07025 lineto
0.2508 0.06853 lineto
0.2719 0.06951 lineto
0.29569 0.07199 lineto
0.32123 0.07478 lineto
0.34749 0.07681 lineto
0.37367 0.07719 lineto
0.3993 0.07527 lineto
0.42432 0.07066 lineto
0.44885 0.06328 lineto
0.47298 0.05344 lineto
0.49664 0.04181 lineto
0.51945 0.02944 lineto
0.54091 0.01767 lineto
0.56053 0.00795 lineto
0.5781 0.00168 lineto
0.59381 0 lineto
0.60818 0.00356 lineto
0.62198 0.01242 lineto
0.63591 0.02604 lineto
0.65052 0.04332 lineto
0.66609 0.06282 lineto
0.6827 0.08301 lineto
0.70037 0.10252 lineto
0.71921 0.12037 lineto
0.73941 0.13598 lineto
0.76116 0.14923 lineto
0.78449 0.1603 lineto
0.80908 0.16955 lineto
0.83414 0.17743 lineto
0.8585 0.18447 lineto
0.88078 0.1913 lineto
0.8997 0.19868 lineto
0.91433 0.20752 lineto
0.92427 0.21873 lineto
0.92975 0.23303 lineto
0.93147 0.2508 lineto
0.93049 0.2719 lineto
0.92801 0.29569 lineto
0.92522 0.32123 lineto
0.92319 0.34749 lineto
0.92281 0.37367 lineto
0.92473 0.3993 lineto
0.92934 0.42432 lineto
0.93672 0.44885 lineto
0.94656 0.47298 lineto
0.95819 0.49664 lineto
0.97056 0.51945 lineto
Mistroke
0.98233 0.54091 lineto
0.99205 0.56053 lineto
0.99832 0.5781 lineto
1 0.59381 lineto
0.99644 0.60818 lineto
0.98758 0.62198 lineto
0.97396 0.63591 lineto
0.95668 0.65052 lineto
0.93718 0.66609 lineto
0.91699 0.6827 lineto
0.89748 0.70037 lineto
0.87963 0.71921 lineto
0.86402 0.73941 lineto
0.85077 0.76116 lineto
0.8397 0.78449 lineto
0.83045 0.80908 lineto
0.82257 0.83414 lineto
0.81553 0.8585 lineto
0.8087 0.88078 lineto
0.80132 0.8997 lineto
0.79248 0.91433 lineto
0.78127 0.92427 lineto
0.76697 0.92975 lineto
0.7492 0.93147 lineto
0.7281 0.93049 lineto
0.70431 0.92801 lineto
0.67877 0.92522 lineto
0.65251 0.92319 lineto
0.62633 0.92281 lineto
0.6007 0.92473 lineto
0.57568 0.92934 lineto
0.55115 0.93672 lineto
0.52702 0.94656 lineto
0.50336 0.95819 lineto
0.48055 0.97056 lineto
0.45909 0.98233 lineto
0.43947 0.99205 lineto
0.4219 0.99832 lineto
0.40619 1 lineto
0.39182 0.99644 lineto
Mfstroke
0.37802 0.98758 moveto
0.39182 0.99644 lineto
stroke
0.5 0.5 moveto
0.37802 0.98758 lineto
stroke
0.5 0.5 moveto
0.36409 0.97396 lineto
stroke
0.5 0.5 moveto
0.34948 0.95668 lineto
stroke
0.5 0.5 moveto
0.33391 0.93718 lineto
stroke
0.5 0.5 moveto
0.3173 0.91699 lineto
stroke
0.5 0.5 moveto
0.29963 0.89748 lineto
stroke
0.5 0.5 moveto
0.28079 0.87963 lineto
stroke
0.5 0.5 moveto
0.26059 0.86402 lineto
stroke
0.5 0.5 moveto
0.23884 0.85077 lineto
stroke
0.5 0.5 moveto
0.21551 0.8397 lineto
stroke
0.5 0.5 moveto
0.19092 0.83045 lineto
stroke
0.5 0.5 moveto
0.16586 0.82257 lineto
stroke
0.5 0.5 moveto
0.1415 0.81553 lineto
stroke
0.5 0.5 moveto
0.11922 0.8087 lineto
stroke
0.5 0.5 moveto
0.1003 0.80132 lineto
stroke
0.5 0.5 moveto
0.08567 0.79248 lineto
stroke
0.5 0.5 moveto
0.07573 0.78127 lineto
stroke
0.5 0.5 moveto
0.07025 0.76697 lineto
stroke
0.5 0.5 moveto
0.06853 0.7492 lineto
stroke
0.5 0.5 moveto
0.06951 0.7281 lineto
stroke
0.5 0.5 moveto
0.07199 0.70431 lineto
stroke
0.5 0.5 moveto
0.07478 0.67877 lineto
stroke
0.5 0.5 moveto
0.07681 0.65251 lineto
stroke
0.5 0.5 moveto
0.07719 0.62633 lineto
stroke
0.5 0.5 moveto
0.07527 0.6007 lineto
stroke
0.5 0.5 moveto
0.07066 0.57568 lineto
stroke
0.5 0.5 moveto
0.06328 0.55115 lineto
stroke
0.5 0.5 moveto
0.05344 0.52702 lineto
stroke
0.5 0.5 moveto
0.04181 0.50336 lineto
stroke
0.5 0.5 moveto
0.02944 0.48055 lineto
stroke
0.5 0.5 moveto
0.01767 0.45909 lineto
stroke
0.5 0.5 moveto
0.00795 0.43947 lineto
stroke
0.5 0.5 moveto
0.00168 0.4219 lineto
stroke
0.5 0.5 moveto
0 0.40619 lineto
stroke
0.5 0.5 moveto
0.00356 0.39182 lineto
stroke
0.5 0.5 moveto
0.01242 0.37802 lineto
stroke
0.5 0.5 moveto
0.02604 0.36409 lineto
stroke
0.5 0.5 moveto
0.04332 0.34948 lineto
stroke
0.5 0.5 moveto
0.06282 0.33391 lineto
stroke
0.5 0.5 moveto
0.08301 0.3173 lineto
stroke
0.5 0.5 moveto
0.10252 0.29963 lineto
stroke
0.5 0.5 moveto
0.12037 0.28079 lineto
stroke
0.5 0.5 moveto
0.13598 0.26059 lineto
stroke
0.5 0.5 moveto
0.14923 0.23884 lineto
stroke
0.5 0.5 moveto
0.1603 0.21551 lineto
stroke
0.5 0.5 moveto
0.16955 0.19092 lineto
stroke
0.5 0.5 moveto
0.17743 0.16586 lineto
stroke
0.5 0.5 moveto
0.18447 0.1415 lineto
stroke
0.5 0.5 moveto
0.1913 0.11922 lineto
stroke
0.5 0.5 moveto
0.19868 0.1003 lineto
stroke
0.5 0.5 moveto
0.20752 0.08567 lineto
stroke
0.5 0.5 moveto
0.21873 0.07573 lineto
stroke
0.5 0.5 moveto
0.23303 0.07025 lineto
stroke
0.5 0.5 moveto
0.2508 0.06853 lineto
stroke
0.5 0.5 moveto
0.2719 0.06951 lineto
stroke
0.5 0.5 moveto
0.29569 0.07199 lineto
stroke
0.5 0.5 moveto
0.32123 0.07478 lineto
stroke
0.5 0.5 moveto
0.34749 0.07681 lineto
stroke
0.5 0.5 moveto
0.37367 0.07719 lineto
stroke
0.5 0.5 moveto
0.3993 0.07527 lineto
stroke
0.5 0.5 moveto
0.42432 0.07066 lineto
stroke
0.5 0.5 moveto
0.44885 0.06328 lineto
stroke
0.5 0.5 moveto
0.47298 0.05344 lineto
stroke
0.5 0.5 moveto
0.49664 0.04181 lineto
stroke
0.5 0.5 moveto
0.51945 0.02944 lineto
stroke
0.5 0.5 moveto
0.54091 0.01767 lineto
stroke
0.5 0.5 moveto
0.56053 0.00795 lineto
stroke
0.5 0.5 moveto
0.5781 0.00168 lineto
stroke
0.5 0.5 moveto
0.59381 0 lineto
stroke
0.5 0.5 moveto
0.60818 0.00356 lineto
stroke
0.5 0.5 moveto
0.62198 0.01242 lineto
stroke
0.5 0.5 moveto
0.63591 0.02604 lineto
stroke
0.5 0.5 moveto
0.65052 0.04332 lineto
stroke
0.5 0.5 moveto
0.66609 0.06282 lineto
stroke
0.5 0.5 moveto
0.6827 0.08301 lineto
stroke
0.5 0.5 moveto
0.70037 0.10252 lineto
stroke
0.5 0.5 moveto
0.71921 0.12037 lineto
stroke
0.5 0.5 moveto
0.73941 0.13598 lineto
stroke
0.5 0.5 moveto
0.76116 0.14923 lineto
stroke
0.5 0.5 moveto
0.78449 0.1603 lineto
stroke
0.5 0.5 moveto
0.80908 0.16955 lineto
stroke
0.5 0.5 moveto
0.83414 0.17743 lineto
stroke
0.5 0.5 moveto
0.8585 0.18447 lineto
stroke
0.5 0.5 moveto
0.88078 0.1913 lineto
stroke
0.5 0.5 moveto
0.8997 0.19868 lineto
stroke
0.5 0.5 moveto
0.91433 0.20752 lineto
stroke
0.5 0.5 moveto
0.92427 0.21873 lineto
stroke
0.5 0.5 moveto
0.92975 0.23303 lineto
stroke
0.5 0.5 moveto
0.93147 0.2508 lineto
stroke
0.5 0.5 moveto
0.93049 0.2719 lineto
stroke
0.5 0.5 moveto
0.92801 0.29569 lineto
stroke
0.5 0.5 moveto
0.92522 0.32123 lineto
stroke
0.5 0.5 moveto
0.92319 0.34749 lineto
stroke
0.5 0.5 moveto
0.92281 0.37367 lineto
stroke
0.5 0.5 moveto
0.92473 0.3993 lineto
stroke
0.5 0.5 moveto
0.92934 0.42432 lineto
stroke
0.5 0.5 moveto
0.93672 0.44885 lineto
stroke
0.5 0.5 moveto
0.94656 0.47298 lineto
stroke
0.5 0.5 moveto
0.95819 0.49664 lineto
stroke
0.5 0.5 moveto
0.97056 0.51945 lineto
stroke
0.5 0.5 moveto
0.98233 0.54091 lineto
stroke
0.5 0.5 moveto
0.99205 0.56053 lineto
stroke
0.5 0.5 moveto
0.99832 0.5781 lineto
stroke
0.5 0.5 moveto
1 0.59381 lineto
stroke
0.5 0.5 moveto
0.99644 0.60818 lineto
stroke
0.5 0.5 moveto
0.98758 0.62198 lineto
stroke
0.5 0.5 moveto
0.97396 0.63591 lineto
stroke
0.5 0.5 moveto
0.95668 0.65052 lineto
stroke
0.5 0.5 moveto
0.93718 0.66609 lineto
stroke
0.5 0.5 moveto
0.91699 0.6827 lineto
stroke
0.5 0.5 moveto
0.89748 0.70037 lineto
stroke
0.5 0.5 moveto
0.87963 0.71921 lineto
stroke
0.5 0.5 moveto
0.86402 0.73941 lineto
stroke
0.5 0.5 moveto
0.85077 0.76116 lineto
stroke
0.5 0.5 moveto
0.8397 0.78449 lineto
stroke
0.5 0.5 moveto
0.83045 0.80908 lineto
stroke
0.5 0.5 moveto
0.82257 0.83414 lineto
stroke
0.5 0.5 moveto
0.81553 0.8585 lineto
stroke
0.5 0.5 moveto
0.8087 0.88078 lineto
stroke
0.5 0.5 moveto
0.80132 0.8997 lineto
stroke
0.5 0.5 moveto
0.79248 0.91433 lineto
stroke
0.5 0.5 moveto
0.78127 0.92427 lineto
stroke
0.5 0.5 moveto
0.76697 0.92975 lineto
stroke
0.5 0.5 moveto
0.7492 0.93147 lineto
stroke
0.5 0.5 moveto
0.7281 0.93049 lineto
stroke
0.5 0.5 moveto
0.70431 0.92801 lineto
stroke
0.5 0.5 moveto
0.67877 0.92522 lineto
stroke
0.5 0.5 moveto
0.65251 0.92319 lineto
stroke
0.5 0.5 moveto
0.62633 0.92281 lineto
stroke
0.5 0.5 moveto
0.6007 0.92473 lineto
stroke
0.5 0.5 moveto
0.57568 0.92934 lineto
stroke
0.5 0.5 moveto
0.55115 0.93672 lineto
stroke
0.5 0.5 moveto
0.52702 0.94656 lineto
stroke
0.5 0.5 moveto
0.50336 0.95819 lineto
stroke
0.5 0.5 moveto
0.48055 0.97056 lineto
stroke
0.5 0.5 moveto
0.45909 0.98233 lineto
stroke
0.5 0.5 moveto
0.43947 0.99205 lineto
stroke
0.5 0.5 moveto
0.4219 0.99832 lineto
stroke
0.5 0.5 moveto
0.40619 1 lineto
stroke
0.5 0.5 moveto
0.39182 0.99644 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; ]
(***************************************************************)
      MidPointPolygonMovie[Table[{Random[],Random[]},{125}],
                           Blowing->Resized,
                           TotalFrameNumber->100,
                           Style->Vertices,
                           FractionPoint->.1,
                           VertexSize->15]
:[font = postscript; inactive; PostScript; output; pictureLeft = 129; pictureTop = 2; pictureWidth = 190; pictureHeight = 190; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(99)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(100)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(125)] 1 1 1.7 1.7 Mshowa
0 setgray
[(5.3909)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(100)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.075 setlinewidth
0.91189 0.73168 Mdot
0.88241 0.73897 Mdot
0.80625 0.75694 Mdot
0.70711 0.78162 Mdot
0.61326 0.80234 Mdot
0.54208 0.80463 Mdot
0.49288 0.77688 Mdot
0.45163 0.71683 Mdot
0.40267 0.63384 Mdot
0.33846 0.54568 Mdot
0.26237 0.47172 Mdot
0.18529 0.42585 Mdot
0.11984 0.41247 Mdot
0.07539 0.42645 Mdot
0.05533 0.45606 Mdot
0.0572 0.48714 Mdot
0.07544 0.5073 Mdot
0.10495 0.50915 Mdot
0.14264 0.49134 Mdot
0.18566 0.45677 Mdot
0.22816 0.40949 Mdot
0.26053 0.3526 Mdot
0.2733 0.2885 Mdot
0.26369 0.22084 Mdot
0.24024 0.15651 Mdot
0.22165 0.10626 Mdot
0.23 0.08297 Mdot
0.28135 0.0973 Mdot
0.37827 0.1518 Mdot
0.50725 0.23729 Mdot
0.64275 0.33507 Mdot
0.75619 0.425 Mdot
0.8263 0.49453 Mdot
0.84592 0.54295 Mdot
0.82223 0.57834 Mdot
0.77123 0.61056 Mdot
0.71027 0.64578 Mdot
0.65259 0.68607 Mdot
0.60534 0.73221 Mdot
0.5703 0.78547 Mdot
0.54532 0.84586 Mdot
0.52546 0.90894 Mdot
0.50442 0.96461 Mdot
0.47665 0.99925 Mdot
0.44005 1 Mdot
0.39774 0.95873 Mdot
0.35757 0.8744 Mdot
0.32928 0.75317 Mdot
0.32075 0.60655 Mdot
0.33526 0.44902 Mdot
0.37082 0.29631 Mdot
0.42104 0.1645 Mdot
0.47657 0.06815 Mdot
0.52674 0.01625 Mdot
0.56166 0.00757 Mdot
0.57434 0.02929 Mdot
0.56183 0.06161 Mdot
0.52516 0.08699 Mdot
0.46915 0.09885 Mdot
0.40254 0.10391 Mdot
0.33768 0.11657 Mdot
0.28816 0.14877 Mdot
0.26465 0.20201 Mdot
0.27102 0.26621 Mdot
0.30367 0.32521 Mdot
0.35461 0.36462 Mdot
0.41608 0.37723 Mdot
0.48276 0.36397 Mdot
0.55081 0.33149 Mdot
0.61587 0.28871 Mdot
0.67288 0.24436 Mdot
0.71779 0.20623 Mdot
0.74884 0.18067 Mdot
0.76574 0.17103 Mdot
0.76791 0.17506 Mdot
0.75387 0.18444 Mdot
0.72312 0.1889 Mdot
0.67875 0.18281 Mdot
0.62796 0.16903 Mdot
0.57923 0.15643 Mdot
0.53825 0.15353 Mdot
0.50637 0.16367 Mdot
0.4827 0.18505 Mdot
0.4676 0.21478 Mdot
0.46368 0.25338 Mdot
0.47342 0.30625 Mdot
0.49529 0.38078 Mdot
0.5219 0.48082 Mdot
0.54234 0.6021 Mdot
0.54793 0.7317 Mdot
0.53845 0.85154 Mdot
0.52399 0.94363 Mdot
0.52018 0.99475 Mdot
0.53937 0.99985 Mdot
0.58368 0.964 Mdot
0.64435 0.90186 Mdot
0.70684 0.83312 Mdot
0.75704 0.77506 Mdot
0.7849 0.73601 Mdot
0.78519 0.71349 Mdot
0.75776 0.69814 Mdot
0.70828 0.68046 Mdot
0.64804 0.65611 Mdot
0.59086 0.62705 Mdot
0.54735 0.59867 Mdot
0.51973 0.57586 Mdot
0.50065 0.56077 Mdot
0.47714 0.55303 Mdot
0.43783 0.5512 Mdot
0.37992 0.55432 Mdot
0.31257 0.56273 Mdot
0.2549 0.57767 Mdot
0.22868 0.5998 Mdot
0.24836 0.62761 Mdot
0.31328 0.65774 Mdot
0.40662 0.68685 Mdot
0.50263 0.71321 Mdot
0.57853 0.73627 Mdot
0.62475 0.75487 Mdot
0.64828 0.76668 Mdot
0.66762 0.76974 Mdot
0.70178 0.76448 Mdot
0.75873 0.75399 Mdot
0.8291 0.74251 Mdot
0.88908 0.73392 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; ]
(****************************************************************)
:[font = postscript; inactive; PostScript; output; startGroup; Cclosed; pictureLeft = 40; pictureWidth = 366; pictureHeight = 476; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(605)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(25)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(150)] 1 1 1.7 1.7 Mshowa
0 setgray
[(1.52345)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(25)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Resized)] 0.5 1 0 1.7 Mshowa
gsave
0.025 setlinewidth
0.57284 0.97809 Mdot
0.54914 0.97749 Mdot
0.52364 0.97567 Mdot
0.4965 0.97259 Mdot
0.46791 0.96824 Mdot
0.4381 0.96259 Mdot
0.40732 0.95564 Mdot
0.37584 0.94741 Mdot
0.34394 0.93792 Mdot
0.31192 0.92722 Mdot
0.28008 0.91535 Mdot
0.24874 0.90239 Mdot
0.21819 0.88843 Mdot
0.18875 0.87356 Mdot
0.16069 0.8579 Mdot
0.13429 0.84156 Mdot
0.1098 0.82468 Mdot
0.08747 0.80738 Mdot
0.06749 0.78982 Mdot
0.05005 0.77211 Mdot
0.03531 0.75439 Mdot
0.02338 0.73679 Mdot
0.01436 0.71941 Mdot
0.0083 0.70236 Mdot
0.00524 0.68572 Mdot
0.00517 0.66956 Mdot
0.00805 0.65391 Mdot
0.0138 0.63882 Mdot
0.02232 0.62427 Mdot
0.03349 0.61026 Mdot
0.04713 0.59675 Mdot
0.06307 0.58369 Mdot
0.08108 0.57101 Mdot
0.10094 0.55864 Mdot
0.12238 0.54648 Mdot
0.14515 0.53445 Mdot
0.16895 0.52244 Mdot
0.1935 0.51038 Mdot
0.2185 0.49816 Mdot
0.24365 0.48571 Mdot
0.26864 0.47296 Mdot
0.2932 0.45986 Mdot
0.31704 0.44637 Mdot
0.3399 0.43246 Mdot
0.36152 0.41812 Mdot
0.38168 0.40336 Mdot
0.40018 0.3882 Mdot
0.41685 0.37268 Mdot
0.43153 0.35684 Mdot
0.44412 0.34075 Mdot
0.45454 0.32447 Mdot
0.46274 0.30806 Mdot
0.4687 0.2916 Mdot
0.47246 0.27516 Mdot
0.47406 0.25881 Mdot
0.47361 0.24262 Mdot
0.47122 0.22665 Mdot
0.46705 0.21096 Mdot
0.46128 0.19559 Mdot
0.45412 0.18059 Mdot
0.4458 0.16599 Mdot
0.43656 0.15182 Mdot
0.42668 0.13811 Mdot
0.41644 0.12487 Mdot
0.40611 0.11213 Mdot
0.39599 0.09991 Mdot
0.38638 0.08822 Mdot
0.37756 0.07707 Mdot
0.3698 0.06651 Mdot
0.36338 0.05655 Mdot
0.35855 0.04722 Mdot
0.35551 0.03858 Mdot
0.35448 0.03065 Mdot
0.35562 0.02349 Mdot
0.35906 0.01716 Mdot
0.3649 0.01172 Mdot
0.37319 0.00722 Mdot
0.38395 0.00374 Mdot
0.39716 0.00133 Mdot
0.41273 6e-05 Mdot
0.43057 0 Mdot
0.45052 0.00119 Mdot
0.47239 0.00368 Mdot
0.49596 0.00752 Mdot
0.52097 0.01272 Mdot
0.54715 0.01932 Mdot
0.5742 0.02732 Mdot
0.60182 0.03671 Mdot
0.62967 0.04748 Mdot
0.65744 0.0596 Mdot
0.68481 0.07302 Mdot
0.71147 0.0877 Mdot
0.73714 0.10357 Mdot
0.76155 0.12056 Mdot
0.78445 0.13858 Mdot
0.80562 0.15754 Mdot
0.82488 0.17735 Mdot
0.84209 0.1979 Mdot
0.85712 0.21909 Mdot
0.8699 0.24081 Mdot
0.88038 0.26297 Mdot
0.88856 0.28544 Mdot
0.89445 0.30813 Mdot
0.89812 0.33093 Mdot
0.89964 0.35377 Mdot
0.89912 0.37653 Mdot
0.89669 0.39916 Mdot
0.8925 0.42156 Mdot
0.88673 0.44367 Mdot
0.87953 0.46545 Mdot
0.87111 0.48683 Mdot
0.86166 0.50778 Mdot
0.85138 0.52827 Mdot
0.84047 0.54828 Mdot
0.82911 0.56778 Mdot
0.81752 0.58678 Mdot
0.80588 0.60527 Mdot
0.79435 0.62326 Mdot
0.78312 0.64075 Mdot
0.77233 0.65777 Mdot
0.76212 0.67432 Mdot
0.75262 0.69043 Mdot
0.74391 0.70611 Mdot
0.73609 0.7214 Mdot
0.72922 0.7363 Mdot
0.72331 0.75084 Mdot
0.71839 0.76504 Mdot
0.71444 0.77891 Mdot
0.71141 0.79247 Mdot
0.70924 0.80571 Mdot
0.70783 0.81866 Mdot
0.70707 0.8313 Mdot
0.7068 0.84363 Mdot
0.70688 0.85565 Mdot
0.70712 0.86733 Mdot
0.70732 0.87867 Mdot
0.70728 0.88962 Mdot
0.70677 0.90017 Mdot
0.70558 0.91028 Mdot
0.70349 0.9199 Mdot
0.70029 0.92899 Mdot
0.69577 0.93749 Mdot
0.68975 0.94536 Mdot
0.68205 0.95254 Mdot
0.67252 0.95896 Mdot
0.66106 0.96456 Mdot
0.64758 0.96928 Mdot
0.63201 0.97306 Mdot
0.61435 0.97582 Mdot
0.5946 0.97752 Mdot
0.004 setlinewidth
0.57284 0.97809 moveto
0.54914 0.97749 lineto
0.52364 0.97567 lineto
0.4965 0.97259 lineto
0.46791 0.96824 lineto
0.4381 0.96259 lineto
0.40732 0.95564 lineto
0.37584 0.94741 lineto
0.34394 0.93792 lineto
0.31192 0.92722 lineto
0.28008 0.91535 lineto
0.24874 0.90239 lineto
0.21819 0.88843 lineto
0.18875 0.87356 lineto
0.16069 0.8579 lineto
0.13429 0.84156 lineto
0.1098 0.82468 lineto
0.08747 0.80738 lineto
0.06749 0.78982 lineto
0.05005 0.77211 lineto
0.03531 0.75439 lineto
0.02338 0.73679 lineto
0.01436 0.71941 lineto
0.0083 0.70236 lineto
0.00524 0.68572 lineto
0.00517 0.66956 lineto
0.00805 0.65391 lineto
0.0138 0.63882 lineto
0.02232 0.62427 lineto
0.03349 0.61026 lineto
0.04713 0.59675 lineto
0.06307 0.58369 lineto
0.08108 0.57101 lineto
0.10094 0.55864 lineto
0.12238 0.54648 lineto
0.14515 0.53445 lineto
0.16895 0.52244 lineto
0.1935 0.51038 lineto
0.2185 0.49816 lineto
0.24365 0.48571 lineto
0.26864 0.47296 lineto
0.2932 0.45986 lineto
0.31704 0.44637 lineto
0.3399 0.43246 lineto
0.36152 0.41812 lineto
0.38168 0.40336 lineto
0.40018 0.3882 lineto
0.41685 0.37268 lineto
0.43153 0.35684 lineto
0.44412 0.34075 lineto
Mistroke
0.45454 0.32447 lineto
0.46274 0.30806 lineto
0.4687 0.2916 lineto
0.47246 0.27516 lineto
0.47406 0.25881 lineto
0.47361 0.24262 lineto
0.47122 0.22665 lineto
0.46705 0.21096 lineto
0.46128 0.19559 lineto
0.45412 0.18059 lineto
0.4458 0.16599 lineto
0.43656 0.15182 lineto
0.42668 0.13811 lineto
0.41644 0.12487 lineto
0.40611 0.11213 lineto
0.39599 0.09991 lineto
0.38638 0.08822 lineto
0.37756 0.07707 lineto
0.3698 0.06651 lineto
0.36338 0.05655 lineto
0.35855 0.04722 lineto
0.35551 0.03858 lineto
0.35448 0.03065 lineto
0.35562 0.02349 lineto
0.35906 0.01716 lineto
0.3649 0.01172 lineto
0.37319 0.00722 lineto
0.38395 0.00374 lineto
0.39716 0.00133 lineto
0.41273 6e-05 lineto
0.43057 0 lineto
0.45052 0.00119 lineto
0.47239 0.00368 lineto
0.49596 0.00752 lineto
0.52097 0.01272 lineto
0.54715 0.01932 lineto
0.5742 0.02732 lineto
0.60182 0.03671 lineto
0.62967 0.04748 lineto
0.65744 0.0596 lineto
0.68481 0.07302 lineto
0.71147 0.0877 lineto
0.73714 0.10357 lineto
0.76155 0.12056 lineto
0.78445 0.13858 lineto
0.80562 0.15754 lineto
0.82488 0.17735 lineto
0.84209 0.1979 lineto
0.85712 0.21909 lineto
0.8699 0.24081 lineto
Mistroke
0.88038 0.26297 lineto
0.88856 0.28544 lineto
0.89445 0.30813 lineto
0.89812 0.33093 lineto
0.89964 0.35377 lineto
0.89912 0.37653 lineto
0.89669 0.39916 lineto
0.8925 0.42156 lineto
0.88673 0.44367 lineto
0.87953 0.46545 lineto
0.87111 0.48683 lineto
0.86166 0.50778 lineto
0.85138 0.52827 lineto
0.84047 0.54828 lineto
0.82911 0.56778 lineto
0.81752 0.58678 lineto
0.80588 0.60527 lineto
0.79435 0.62326 lineto
0.78312 0.64075 lineto
0.77233 0.65777 lineto
0.76212 0.67432 lineto
0.75262 0.69043 lineto
0.74391 0.70611 lineto
0.73609 0.7214 lineto
0.72922 0.7363 lineto
0.72331 0.75084 lineto
0.71839 0.76504 lineto
0.71444 0.77891 lineto
0.71141 0.79247 lineto
0.70924 0.80571 lineto
0.70783 0.81866 lineto
0.70707 0.8313 lineto
0.7068 0.84363 lineto
0.70688 0.85565 lineto
0.70712 0.86733 lineto
0.70732 0.87867 lineto
0.70728 0.88962 lineto
0.70677 0.90017 lineto
0.70558 0.91028 lineto
0.70349 0.9199 lineto
0.70029 0.92899 lineto
0.69577 0.93749 lineto
0.68975 0.94536 lineto
0.68205 0.95254 lineto
0.67252 0.95896 lineto
0.66106 0.96456 lineto
0.64758 0.96928 lineto
0.63201 0.97306 lineto
0.61435 0.97582 lineto
0.5946 0.97752 lineto
Mistroke
Mfstroke
0.57284 0.97809 moveto
0.5946 0.97752 lineto
stroke
0.5 0.5 moveto
0.57284 0.97809 lineto
stroke
0.5 0.5 moveto
0.54914 0.97749 lineto
stroke
0.5 0.5 moveto
0.52364 0.97567 lineto
stroke
0.5 0.5 moveto
0.4965 0.97259 lineto
stroke
0.5 0.5 moveto
0.46791 0.96824 lineto
stroke
0.5 0.5 moveto
0.4381 0.96259 lineto
stroke
0.5 0.5 moveto
0.40732 0.95564 lineto
stroke
0.5 0.5 moveto
0.37584 0.94741 lineto
stroke
0.5 0.5 moveto
0.34394 0.93792 lineto
stroke
0.5 0.5 moveto
0.31192 0.92722 lineto
stroke
0.5 0.5 moveto
0.28008 0.91535 lineto
stroke
0.5 0.5 moveto
0.24874 0.90239 lineto
stroke
0.5 0.5 moveto
0.21819 0.88843 lineto
stroke
0.5 0.5 moveto
0.18875 0.87356 lineto
stroke
0.5 0.5 moveto
0.16069 0.8579 lineto
stroke
0.5 0.5 moveto
0.13429 0.84156 lineto
stroke
0.5 0.5 moveto
0.1098 0.82468 lineto
stroke
0.5 0.5 moveto
0.08747 0.80738 lineto
stroke
0.5 0.5 moveto
0.06749 0.78982 lineto
stroke
0.5 0.5 moveto
0.05005 0.77211 lineto
stroke
0.5 0.5 moveto
0.03531 0.75439 lineto
stroke
0.5 0.5 moveto
0.02338 0.73679 lineto
stroke
0.5 0.5 moveto
0.01436 0.71941 lineto
stroke
0.5 0.5 moveto
0.0083 0.70236 lineto
stroke
0.5 0.5 moveto
0.00524 0.68572 lineto
stroke
0.5 0.5 moveto
0.00517 0.66956 lineto
stroke
0.5 0.5 moveto
0.00805 0.65391 lineto
stroke
0.5 0.5 moveto
0.0138 0.63882 lineto
stroke
0.5 0.5 moveto
0.02232 0.62427 lineto
stroke
0.5 0.5 moveto
0.03349 0.61026 lineto
stroke
0.5 0.5 moveto
0.04713 0.59675 lineto
stroke
0.5 0.5 moveto
0.06307 0.58369 lineto
stroke
0.5 0.5 moveto
0.08108 0.57101 lineto
stroke
0.5 0.5 moveto
0.10094 0.55864 lineto
stroke
0.5 0.5 moveto
0.12238 0.54648 lineto
stroke
0.5 0.5 moveto
0.14515 0.53445 lineto
stroke
0.5 0.5 moveto
0.16895 0.52244 lineto
stroke
0.5 0.5 moveto
0.1935 0.51038 lineto
stroke
0.5 0.5 moveto
0.2185 0.49816 lineto
stroke
0.5 0.5 moveto
0.24365 0.48571 lineto
stroke
0.5 0.5 moveto
0.26864 0.47296 lineto
stroke
0.5 0.5 moveto
0.2932 0.45986 lineto
stroke
0.5 0.5 moveto
0.31704 0.44637 lineto
stroke
0.5 0.5 moveto
0.3399 0.43246 lineto
stroke
0.5 0.5 moveto
0.36152 0.41812 lineto
stroke
0.5 0.5 moveto
0.38168 0.40336 lineto
stroke
0.5 0.5 moveto
0.40018 0.3882 lineto
stroke
0.5 0.5 moveto
0.41685 0.37268 lineto
stroke
0.5 0.5 moveto
0.43153 0.35684 lineto
stroke
0.5 0.5 moveto
0.44412 0.34075 lineto
stroke
0.5 0.5 moveto
0.45454 0.32447 lineto
stroke
0.5 0.5 moveto
0.46274 0.30806 lineto
stroke
0.5 0.5 moveto
0.4687 0.2916 lineto
stroke
0.5 0.5 moveto
0.47246 0.27516 lineto
stroke
0.5 0.5 moveto
0.47406 0.25881 lineto
stroke
0.5 0.5 moveto
0.47361 0.24262 lineto
stroke
0.5 0.5 moveto
0.47122 0.22665 lineto
stroke
0.5 0.5 moveto
0.46705 0.21096 lineto
stroke
0.5 0.5 moveto
0.46128 0.19559 lineto
stroke
0.5 0.5 moveto
0.45412 0.18059 lineto
stroke
0.5 0.5 moveto
0.4458 0.16599 lineto
stroke
0.5 0.5 moveto
0.43656 0.15182 lineto
stroke
0.5 0.5 moveto
0.42668 0.13811 lineto
stroke
0.5 0.5 moveto
0.41644 0.12487 lineto
stroke
0.5 0.5 moveto
0.40611 0.11213 lineto
stroke
0.5 0.5 moveto
0.39599 0.09991 lineto
stroke
0.5 0.5 moveto
0.38638 0.08822 lineto
stroke
0.5 0.5 moveto
0.37756 0.07707 lineto
stroke
0.5 0.5 moveto
0.3698 0.06651 lineto
stroke
0.5 0.5 moveto
0.36338 0.05655 lineto
stroke
0.5 0.5 moveto
0.35855 0.04722 lineto
stroke
0.5 0.5 moveto
0.35551 0.03858 lineto
stroke
0.5 0.5 moveto
0.35448 0.03065 lineto
stroke
0.5 0.5 moveto
0.35562 0.02349 lineto
stroke
0.5 0.5 moveto
0.35906 0.01716 lineto
stroke
0.5 0.5 moveto
0.3649 0.01172 lineto
stroke
0.5 0.5 moveto
0.37319 0.00722 lineto
stroke
0.5 0.5 moveto
0.38395 0.00374 lineto
stroke
0.5 0.5 moveto
0.39716 0.00133 lineto
stroke
0.5 0.5 moveto
0.41273 6e-05 lineto
stroke
0.5 0.5 moveto
0.43057 0 lineto
stroke
0.5 0.5 moveto
0.45052 0.00119 lineto
stroke
0.5 0.5 moveto
0.47239 0.00368 lineto
stroke
0.5 0.5 moveto
0.49596 0.00752 lineto
stroke
0.5 0.5 moveto
0.52097 0.01272 lineto
stroke
0.5 0.5 moveto
0.54715 0.01932 lineto
stroke
0.5 0.5 moveto
0.5742 0.02732 lineto
stroke
0.5 0.5 moveto
0.60182 0.03671 lineto
stroke
0.5 0.5 moveto
0.62967 0.04748 lineto
stroke
0.5 0.5 moveto
0.65744 0.0596 lineto
stroke
0.5 0.5 moveto
0.68481 0.07302 lineto
stroke
0.5 0.5 moveto
0.71147 0.0877 lineto
stroke
0.5 0.5 moveto
0.73714 0.10357 lineto
stroke
0.5 0.5 moveto
0.76155 0.12056 lineto
stroke
0.5 0.5 moveto
0.78445 0.13858 lineto
stroke
0.5 0.5 moveto
0.80562 0.15754 lineto
stroke
0.5 0.5 moveto
0.82488 0.17735 lineto
stroke
0.5 0.5 moveto
0.84209 0.1979 lineto
stroke
0.5 0.5 moveto
0.85712 0.21909 lineto
stroke
0.5 0.5 moveto
0.8699 0.24081 lineto
stroke
0.5 0.5 moveto
0.88038 0.26297 lineto
stroke
0.5 0.5 moveto
0.88856 0.28544 lineto
stroke
0.5 0.5 moveto
0.89445 0.30813 lineto
stroke
0.5 0.5 moveto
0.89812 0.33093 lineto
stroke
0.5 0.5 moveto
0.89964 0.35377 lineto
stroke
0.5 0.5 moveto
0.89912 0.37653 lineto
stroke
0.5 0.5 moveto
0.89669 0.39916 lineto
stroke
0.5 0.5 moveto
0.8925 0.42156 lineto
stroke
0.5 0.5 moveto
0.88673 0.44367 lineto
stroke
0.5 0.5 moveto
0.87953 0.46545 lineto
stroke
0.5 0.5 moveto
0.87111 0.48683 lineto
stroke
0.5 0.5 moveto
0.86166 0.50778 lineto
stroke
0.5 0.5 moveto
0.85138 0.52827 lineto
stroke
0.5 0.5 moveto
0.84047 0.54828 lineto
stroke
0.5 0.5 moveto
0.82911 0.56778 lineto
stroke
0.5 0.5 moveto
0.81752 0.58678 lineto
stroke
0.5 0.5 moveto
0.80588 0.60527 lineto
stroke
0.5 0.5 moveto
0.79435 0.62326 lineto
stroke
0.5 0.5 moveto
0.78312 0.64075 lineto
stroke
0.5 0.5 moveto
0.77233 0.65777 lineto
stroke
0.5 0.5 moveto
0.76212 0.67432 lineto
stroke
0.5 0.5 moveto
0.75262 0.69043 lineto
stroke
0.5 0.5 moveto
0.74391 0.70611 lineto
stroke
0.5 0.5 moveto
0.73609 0.7214 lineto
stroke
0.5 0.5 moveto
0.72922 0.7363 lineto
stroke
0.5 0.5 moveto
0.72331 0.75084 lineto
stroke
0.5 0.5 moveto
0.71839 0.76504 lineto
stroke
0.5 0.5 moveto
0.71444 0.77891 lineto
stroke
0.5 0.5 moveto
0.71141 0.79247 lineto
stroke
0.5 0.5 moveto
0.70924 0.80571 lineto
stroke
0.5 0.5 moveto
0.70783 0.81866 lineto
stroke
0.5 0.5 moveto
0.70707 0.8313 lineto
stroke
0.5 0.5 moveto
0.7068 0.84363 lineto
stroke
0.5 0.5 moveto
0.70688 0.85565 lineto
stroke
0.5 0.5 moveto
0.70712 0.86733 lineto
stroke
0.5 0.5 moveto
0.70732 0.87867 lineto
stroke
0.5 0.5 moveto
0.70728 0.88962 lineto
stroke
0.5 0.5 moveto
0.70677 0.90017 lineto
stroke
0.5 0.5 moveto
0.70558 0.91028 lineto
stroke
0.5 0.5 moveto
0.70349 0.9199 lineto
stroke
0.5 0.5 moveto
0.70029 0.92899 lineto
stroke
0.5 0.5 moveto
0.69577 0.93749 lineto
stroke
0.5 0.5 moveto
0.68975 0.94536 lineto
stroke
0.5 0.5 moveto
0.68205 0.95254 lineto
stroke
0.5 0.5 moveto
0.67252 0.95896 lineto
stroke
0.5 0.5 moveto
0.66106 0.96456 lineto
stroke
0.5 0.5 moveto
0.64758 0.96928 lineto
stroke
0.5 0.5 moveto
0.63201 0.97306 lineto
stroke
0.5 0.5 moveto
0.61435 0.97582 lineto
stroke
0.5 0.5 moveto
0.5946 0.97752 lineto
stroke
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; endGroup; ]

MidPointPolygonMovie[{{0.799523, 0.851441}, {0.768373, 0.861824}, {0.742415, 0.861824}, 
{0.700881, 0.861824}, {0.586663, 0.861824}, {0.54513, 0.861824}, 
{0.462062, 0.861824}, {0.420529, 0.861824}, {0.275161, 0.841057}, 
{0.21286, 0.841057}, {-0.067492, 0.841057}, {-0.098643, 0.841057}, 
{-0.337461, 0.841057}, {-0.451679, 0.841057}, {-0.524363, 0.82029}, 
{-0.586663, 0.82029}, {-0.612622, 0.809907}, {-0.680114, 0.78914}, 
{-0.726839, 0.742415}, {-0.742415, 0.711264}, {-0.752798, 0.659347}, 
{-0.773565, 0.586663}, {-0.794332, 0.513979}, {-0.815099, 0.420529}, 
{-0.846249, 0.264777}, {-0.887782, 0.140176}, {-0.887782, 0.109026}, 
{-0.918933, -0.046725}, {-0.9397, -0.119409}, {-0.9397, -0.160943}, 
{-0.9397, -0.197285}, {-0.918933, -0.171326}, {-0.908549, -0.15056}, 
{-0.856632, -0.088259}, {-0.721648, 0.057109}, {-0.669731, 0.119409}, 
{-0.628197, 0.160943}, {-0.482829, 0.295928}, {-0.410145, 0.337461}, 
{-0.378995, 0.347845}, {-0.285544, 0.368611}, {-0.233627, 0.378995}, 
{-0.202477, 0.378995}, {-0.15056, 0.368611}, {-0.005192, 0.327078}, 
{0.15056, 0.24401}, {0.233627, 0.21286}, {0.327078, 0.15056}, 
{0.410145, 0.067492}, {0.513979, -0.067492}, {0.524363, -0.088259}, 
{0.550321, -0.155751}, {0.550321, -0.176518}, {0.539938, -0.218052}, 
{0.529554, -0.238819}, {0.498404, -0.269969}, {0.451679, -0.316694}, 
{0.441295, -0.337461}, {0.342653, -0.404953}, {0.332269, -0.42572}, 
{0.290736, -0.446487}, {0.249202, -0.467254}, {0.21286, -0.482829}, 
{0.186902, -0.482829}, {0.145368, -0.472446}, {0.124601, -0.472446}, 
{0.072684, -0.462062}, {0.020767, -0.451679}, {-0.010383, -0.451679}, 
{-0.103834, -0.430912}, {-0.176518, -0.410145}, {-0.207668, -0.410145}, 
{-0.249202, -0.410145}, {-0.280352, -0.420529}, {-0.316694, -0.436104}, 
{-0.337461, -0.446487}, {-0.384187, -0.493213}, {-0.446487, -0.54513}, 
{-0.488021, -0.586663}, {-0.571088, -0.669731}, {-0.602238, -0.752798}, 
{-0.612622, -0.773565}, {-0.602238, -0.794332}, {-0.591855, -0.82029}, 
{-0.519171, -0.846249}, {-0.45687, -0.867016}, {-0.436104, -0.867016}, 
{-0.311503, -0.835865}, {0.207668, -0.742415}, {0.290736, -0.742415}, 
{0.539938, -0.680114}, {0.602238, -0.659347}, {0.726839, -0.617814}, 
{0.809907, -0.586663}, {0.872207, -0.565896}, {0.986425, -0.493213}, 
{1.017575, -0.477637}, {1.03315, -0.451679}, {1.03315, -0.42572}, 
{1.022767, -0.399762}, {1.012383, -0.36342}, {1.012383, -0.337461}, 
{1.002, -0.316694}, {0.991617, -0.290736}, {0.960466, -0.207668}, 
{0.924124, -0.119409}, {0.913741, -0.098643}, {0.887782, -0.03115}, 
{0.877399, -0.010383}, {0.804715, 0.103834}, {0.794332, 0.124601}, 
{0.742415, 0.186902}, {0.716456, 0.223244}, {0.690498, 0.238819}, 
{0.654155, 0.259585}, {0.633389, 0.259585}, {0.60743, 0.264777}, 
{0.57628, 0.275161}, {0.54513, 0.275161}, {0.524363, 0.285544}, 
{0.472446, 0.295928}, {0.430912, 0.295928}, {0.404953, 0.311503}, 
{0.368611, 0.327078}, {0.347845, 0.337461}, {0.306311, 0.358228}, 
{0.259585, 0.399762}, {0.207668, 0.446487}, {0.176518, 0.467254}, 
{0.15056, 0.488021}, {0.140176, 0.508788}, {0.145368, 0.529554}, 
{0.166135, 0.550321}, {0.192093, 0.560705}, {0.21286, 0.571088}, 
{0.24401, 0.57628}, {0.264777, 0.57628}, {0.295928, 0.586663}, 
{0.337461, 0.586663}, {0.358228, 0.597047}, {0.430912, 0.617814}, 
{0.508788, 0.643772}, {0.539938, 0.654155}, {0.623005, 0.685306}, 
{0.643772, 0.695689}, {0.768373, 0.726839}, {0.794332, 0.742415}, 
{0.82029, 0.773565}, {0.841057, 0.804715}, {0.851441, 0.830674}},
        Blowing->Resized,
        TotalFrameNumber->70,
        Style->Spokes,
        IterationStep->2#,
        FirstFrameIteration->5]
:[font = input; ]
(***************************************************************)
MidPointPolygonMovie[Table[{Random[],Random[]},{15}],
                     Blowing->ConstantPerimeter,
                     TotalFrameNumber->60,
                     Style->Vertices,
                     FractionPoint->.15,
                     VertexSize->18]
:[font = postscript; inactive; PostScript; output; pictureLeft = 129; pictureTop = 2; pictureWidth = 190; pictureHeight = 190; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
0.002 setlinewidth
0 0 moveto
0 1 lineto
1 1 lineto
1 0 lineto
0 0 lineto
stroke
grestore
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
gsave
0 setgray
[(49)] 0 0 -1.7 -1.7 Mshowa
0 setgray
[(50)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(15)] 1 1 1.7 1.7 Mshowa
0 setgray
[(7.18399)] 1 0 1.7 -1.7 Mshowa
0 setgray
[(50)] 0 1 -1.7 1.7 Mshowa
0 setgray
[(Constant perimeter)] 0.5 1 0 1.7 Mshowa
gsave
0.09 setlinewidth
0.31535 0.49702 Mdot
0.30473 0.47653 Mdot
0.36457 0.44947 Mdot
0.48226 0.41516 Mdot
0.61189 0.38732 Mdot
0.70068 0.38327 Mdot
0.71815 0.40975 Mdot
0.66993 0.46044 Mdot
0.59035 0.5227 Mdot
0.52022 0.58113 Mdot
0.48302 0.61852 Mdot
0.4732 0.6229 Mdot
0.46403 0.59694 Mdot
0.4304 0.5572 Mdot
0.37122 0.52164 Mdot
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = input; ]
(****************************************************************)

:[font = postscript; inactive; PostScript; output; pictureLeft = 134; pictureTop = 2; pictureWidth = 196; pictureHeight = 196; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
0.81623 0.77004 moveto
0.66345 0.7274 lineto
0.42894 0.65279 lineto
0.1127 0.51066 lineto
0.06296 0.30102 lineto
0.26549 0.13757 lineto
0.69898 0.07006 lineto
0.84466 0.30102 lineto
0.66345 0.50355 lineto
0.37919 0.57817 lineto
0.22285 0.77004 lineto
0.37209 0.91217 lineto
0.67766 0.95836 lineto
0.83755 0.89796 lineto
0.81623 0.77004 lineto
0.694 0.73593 lineto
0.47584 0.66771 lineto
0.17595 0.53909 lineto
0.07291 0.34295 lineto
0.22498 0.17026 lineto
0.61228 0.08357 lineto
0.81552 0.25483 lineto
0.69969 0.46305 lineto
0.43604 0.56325 lineto
0.25412 0.73167 lineto
0.34224 0.88374 lineto
0.61654 0.94912 lineto
0.80557 0.91004 lineto
0.8205 0.79563 lineto
0.694 0.73593 lineto
0.51947 0.68136 lineto
0.23593 0.56481 lineto
0.09351 0.38218 lineto
0.19457 0.2048 lineto
0.53482 0.10091 lineto
0.77487 0.22058 lineto
0.72286 0.4214 lineto
0.48877 0.54321 lineto
0.2905 0.69798 lineto
0.32461 0.85333 lineto
0.56168 0.93605 lineto
0.76777 0.91786 lineto
0.81751 0.81851 lineto
0.7193 0.74787 lineto
0.51947 0.68136 lineto
0.29264 0.58812 lineto
0.122 0.4187 lineto
0.17436 0.24028 lineto
0.46677 0.12168 lineto
0.72686 0.19664 lineto
Mistroke
0.73326 0.38124 lineto
0.53559 0.51885 lineto
0.33016 0.66703 lineto
0.31779 0.82226 lineto
0.51427 0.9195 lineto
0.72655 0.92149 lineto
0.80756 0.83838 lineto
0.73895 0.762 lineto
0.55944 0.69466 lineto
0.29264 0.58812 lineto
0.15612 0.45259 lineto
0.16389 0.27596 lineto
0.40829 0.1454 lineto
0.67485 0.18165 lineto
0.73198 0.34432 lineto
0.57512 0.49132 lineto
0.37124 0.63739 lineto
0.32027 0.79121 lineto
0.47497 0.90006 lineto
0.68409 0.9211 lineto
0.79136 0.855 lineto
0.75267 0.77727 lineto
0.59534 0.70813 lineto
0.346 0.60943 lineto
0.15612 0.45259 lineto
0.16233 0.31129 lineto
0.35941 0.17151 lineto
0.62153 0.1744 lineto
0.72055 0.31179 lineto
0.60649 0.46192 lineto
0.41202 0.60818 lineto
0.33046 0.76045 lineto
0.44403 0.87829 lineto
0.64227 0.91689 lineto
0.76991 0.86822 lineto
0.76041 0.79282 lineto
0.62681 0.72196 lineto
0.39586 0.62917 lineto
0.1941 0.48395 lineto
0.16233 0.31129 lineto
0.31999 0.19947 lineto
0.56911 0.17382 lineto
0.70075 0.28431 lineto
0.62931 0.4319 lineto
0.45091 0.57893 lineto
0.34677 0.73 lineto
0.42132 0.85472 lineto
0.60262 0.90917 lineto
0.74438 0.87795 lineto
0.76231 0.8079 lineto
Mistroke
0.65353 0.73613 lineto
0.44205 0.64772 lineto
0.23445 0.513 lineto
0.16869 0.34582 lineto
0.31999 0.19947 lineto
0.51929 0.17895 lineto
0.67442 0.26221 lineto
0.6436 0.40238 lineto
0.48659 0.54952 lineto
0.3676 0.69978 lineto
0.40641 0.82977 lineto
0.56636 0.89828 lineto
0.71603 0.8842 lineto
0.75872 0.82191 lineto
0.67528 0.75048 lineto
0.48435 0.66541 lineto
0.27597 0.53994 lineto
0.18184 0.37926 lineto
0.28973 0.22874 lineto
0.51929 0.17895 lineto
0.64339 0.24556 lineto
0.64976 0.37435 lineto
0.51799 0.52009 lineto
0.3914 0.66973 lineto
0.39865 0.80378 lineto
0.53437 0.88458 lineto
0.6861 0.88701 lineto
0.75018 0.83437 lineto
0.69197 0.76477 lineto
0.52253 0.68242 lineto
0.31765 0.56504 lineto
0.20067 0.41139 lineto
0.26815 0.25884 lineto
0.47337 0.18891 lineto
0.64339 0.24556 lineto
0.64849 0.34859 lineto
0.54435 0.49094 lineto
0.41672 0.6398 lineto
0.3972 0.77697 lineto
0.50723 0.86842 lineto
0.65575 0.88653 lineto
0.73737 0.8449 lineto
0.70361 0.77869 lineto
0.55642 0.69889 lineto
0.35862 0.58851 lineto
0.22406 0.44212 lineto
0.25466 0.28935 lineto
0.43233 0.2029 lineto
0.60939 0.23423 lineto
0.64849 0.34859 lineto
Mistroke
0.56517 0.46247 lineto
0.44224 0.61003 lineto
0.4011 0.74953 lineto
0.48522 0.85013 lineto
0.62605 0.8829 lineto
0.72104 0.85322 lineto
0.71036 0.79193 lineto
0.58586 0.71485 lineto
0.39818 0.61059 lineto
0.25097 0.4714 lineto
0.24854 0.31991 lineto
0.3968 0.22019 lineto
0.57398 0.22796 lineto
0.64067 0.32572 lineto
0.56517 0.46247 lineto
0.46683 0.58052 lineto
0.40933 0.72163 lineto
0.4684 0.83001 lineto
0.59788 0.87635 lineto
0.70204 0.85916 lineto
0.7125 0.80419 lineto
0.61076 0.73027 lineto
0.43572 0.63144 lineto
0.28042 0.49924 lineto
0.24902 0.3502 lineto
0.36714 0.24013 lineto
0.53854 0.22641 lineto
0.62733 0.30617 lineto
0.58027 0.43512 lineto
0.46683 0.58052 lineto
0.42083 0.69341 lineto
0.45658 0.80833 lineto
0.57198 0.86708 lineto
0.68121 0.8626 lineto
0.71041 0.81518 lineto
0.63111 0.74505 lineto
0.47073 0.65121 lineto
0.31148 0.52568 lineto
0.2553 0.38001 lineto
0.34352 0.26215 lineto
0.50426 0.22915 lineto
0.60957 0.29021 lineto
0.58968 0.40933 lineto
0.48952 0.55144 lineto
0.42083 0.69341 lineto
0.44943 0.78535 lineto
0.5489 0.85533 lineto
0.65937 0.86349 lineto
0.70457 0.82467 lineto
0.64697 0.75908 lineto
Mistroke
0.5028 0.66997 lineto
0.34333 0.55078 lineto
0.26654 0.40914 lineto
0.32588 0.28572 lineto
0.47211 0.23575 lineto
0.58851 0.278 lineto
0.59366 0.38551 lineto
0.50955 0.52302 lineto
0.43457 0.66502 lineto
0.44943 0.78535 lineto
0.52901 0.84133 lineto
0.63727 0.86186 lineto
0.69553 0.83243 lineto
0.65849 0.77219 lineto
0.53164 0.68779 lineto
0.37522 0.57462 lineto
0.2819 0.43747 lineto
0.31401 0.3104 lineto
0.44287 0.24575 lineto
0.56523 0.26955 lineto
0.59263 0.36401 lineto
0.52637 0.49552 lineto
0.44956 0.63662 lineto
0.44646 0.76128 lineto
0.52901 0.84133 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = postscript; inactive; PostScript; output; startGroup; Cclosed; pictureLeft = 134; pictureTop = 2; pictureWidth = 196; pictureHeight = 196; thinLines; preserveAspect; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
0 setgray
0.004 setlinewidth
0.81623 0.77004 moveto
0.66345 0.7274 lineto
0.42894 0.65279 lineto
0.1127 0.51066 lineto
0.06296 0.30102 lineto
0.26549 0.13757 lineto
0.69898 0.07006 lineto
0.84466 0.30102 lineto
0.66345 0.50355 lineto
0.37919 0.57817 lineto
0.22285 0.77004 lineto
0.37209 0.91217 lineto
0.67766 0.95836 lineto
0.83755 0.89796 lineto
0.81623 0.77004 lineto
0.79441 0.76395 lineto
0.62995 0.71674 lineto
0.38376 0.63248 lineto
0.1056 0.48071 lineto
0.09189 0.27767 lineto
0.32742 0.12793 lineto
0.71979 0.10306 lineto
0.81877 0.32995 lineto
0.62284 0.51421 lineto
0.35686 0.60558 lineto
0.24417 0.79035 lineto
0.41574 0.91877 lineto
0.7005 0.94973 lineto
0.83451 0.87968 lineto
0.79441 0.76395 lineto
0.77091 0.75721 lineto
0.59478 0.70471 lineto
0.34402 0.6108 lineto
0.10364 0.45171 lineto
0.12554 0.25628 lineto
0.38347 0.12438 lineto
0.73393 0.13547 lineto
0.79078 0.35628 lineto
0.58484 0.52727 lineto
0.34076 0.63198 lineto
0.26868 0.80869 lineto
0.45642 0.92319 lineto
0.71965 0.93973 lineto
0.82878 0.86315 lineto
0.77091 0.75721 lineto
0.74575 0.74971 lineto
0.55895 0.69129 lineto
0.30968 0.58807 lineto
0.10677 0.42379 lineto
0.16238 0.23744 lineto
Mistroke
0.43354 0.12596 lineto
0.74205 0.16702 lineto
0.76136 0.3807 lineto
0.54997 0.54222 lineto
0.33046 0.65722 lineto
0.2955 0.82505 lineto
0.49402 0.92555 lineto
0.73524 0.92879 lineto
0.82051 0.84802 lineto
0.74575 0.74971 lineto
0.71907 0.74136 lineto
0.52334 0.67655 lineto
0.28069 0.5646 lineto
0.11471 0.39717 lineto
0.20112 0.22151 lineto
0.47761 0.13183 lineto
0.74481 0.19754 lineto
0.73116 0.40378 lineto
0.51861 0.55865 lineto
0.32547 0.6812 lineto
0.32386 0.83941 lineto
0.52848 0.92602 lineto
0.74742 0.91725 lineto
0.80983 0.83397 lineto
0.71907 0.74136 lineto
0.6911 0.7321 lineto
0.48868 0.66056 lineto
0.25698 0.54068 lineto
0.12706 0.37207 lineto
0.24062 0.2087 lineto
0.51578 0.14121 lineto
0.74286 0.227 lineto
0.7008 0.4259 lineto
0.49102 0.57616 lineto
0.32524 0.7038 lineto
0.35309 0.85178 lineto
0.55976 0.92476 lineto
0.75633 0.90535 lineto
0.79687 0.82074 lineto
0.6911 0.7321 lineto
0.66219 0.72188 lineto
0.45558 0.64343 lineto
0.23842 0.5166 lineto
0.14328 0.34873 lineto
0.27993 0.19906 lineto
0.54822 0.15347 lineto
0.73685 0.25542 lineto
0.67083 0.44737 lineto
0.46734 0.59439 lineto
0.32922 0.72494 lineto
Mistroke
0.38262 0.86221 lineto
0.58784 0.92199 lineto
0.76212 0.89326 lineto
0.78176 0.80808 lineto
0.66219 0.72188 lineto
0.63267 0.71067 lineto
0.42456 0.62531 lineto
0.22483 0.49262 lineto
0.1628 0.32735 lineto
0.31826 0.19255 lineto
0.57517 0.16803 lineto
0.72742 0.28284 lineto
0.64176 0.46837 lineto
0.44761 0.61304 lineto
0.33685 0.74455 lineto
0.41193 0.87075 lineto
0.61274 0.91789 lineto
0.76493 0.88109 lineto
0.76468 0.79577 lineto
0.63267 0.71067 lineto
0.60294 0.69848 lineto
0.39602 0.60636 lineto
0.21597 0.46901 lineto
0.18501 0.30809 lineto
0.35496 0.18904 lineto
0.59692 0.18444 lineto
0.71518 0.30934 lineto
0.61402 0.48904 lineto
0.43178 0.63183 lineto
0.34757 0.76258 lineto
0.44062 0.87748 lineto
0.63448 0.91263 lineto
0.76489 0.86891 lineto
0.74582 0.78361 lineto
0.60294 0.69848 lineto
0.57338 0.68532 lineto
0.3703 0.58673 lineto
0.21155 0.44602 lineto
0.20929 0.29109 lineto
0.38952 0.18839 lineto
0.61381 0.20228 lineto
0.70073 0.33502 lineto
0.58799 0.50944 lineto
0.41975 0.65051 lineto
0.36086 0.77899 lineto
0.46831 0.8825 lineto
0.65311 0.90638 lineto
0.76217 0.85672 lineto
0.72541 0.77145 lineto
0.57338 0.68532 lineto
Mistroke
0.54437 0.67124 lineto
0.34762 0.56663 lineto
0.21122 0.42389 lineto
0.23503 0.27642 lineto
0.42156 0.19037 lineto
0.62623 0.22124 lineto
0.68463 0.35993 lineto
0.56396 0.52959 lineto
0.41134 0.66886 lineto
0.37621 0.79378 lineto
0.49471 0.88591 lineto
0.66869 0.89929 lineto
0.75692 0.84454 lineto
0.70369 0.75914 lineto
0.54437 0.67124 lineto
0.51626 0.65629 lineto
0.32814 0.54624 lineto
0.21462 0.40282 lineto
0.26168 0.26412 lineto
0.4508 0.19478 lineto
0.63457 0.24105 lineto
0.66739 0.38417 lineto
0.54215 0.54949 lineto
0.40632 0.68671 lineto
0.39314 0.80694 lineto
0.51957 0.88782 lineto
0.68129 0.89147 lineto
0.74931 0.83234 lineto
0.68093 0.74659 lineto
0.51626 0.65629 lineto
0.48939 0.64057 lineto
0.31192 0.52575 lineto
0.22135 0.38301 lineto
0.2887 0.25422 lineto
0.47706 0.20139 lineto
0.63926 0.2615 lineto
0.6495 0.40779 lineto
0.52275 0.56909 lineto
0.40444 0.70388 lineto
0.4112 0.8185 lineto
0.54267 0.88835 lineto
0.69101 0.88302 lineto
0.73954 0.82009 lineto
0.65741 0.73369 lineto
0.48939 0.64057 lineto
0.46404 0.62417 lineto
0.29898 0.50536 lineto
0.23097 0.36461 lineto
0.31561 0.24667 lineto
0.50023 0.20998 lineto
Mistroke
0.64072 0.2824 lineto
0.63139 0.43083 lineto
0.50585 0.58835 lineto
0.40541 0.72026 lineto
0.42998 0.82847 lineto
0.56386 0.88758 lineto
0.69794 0.87403 lineto
0.72781 0.80775 lineto
0.6334 0.72038 lineto
0.46404 0.62417 lineto
0.44046 0.6072 lineto
0.28927 0.48525 lineto
0.24306 0.34776 lineto
0.34198 0.24143 lineto
0.5203 0.22032 lineto
0.63939 0.3036 lineto
0.61346 0.45333 lineto
0.4915 0.60719 lineto
0.40892 0.73572 lineto
0.44911 0.83692 lineto
0.58302 0.88565 lineto
0.70221 0.86456 lineto
0.71432 0.79527 lineto
0.60921 0.70664 lineto
0.44046 0.6072 lineto
0.41886 0.58977 lineto
0.28266 0.46561 lineto
0.25719 0.33257 lineto
0.36746 0.23841 lineto
0.53731 0.23222 lineto
0.63568 0.32499 lineto
0.59603 0.47531 lineto
0.4797 0.62555 lineto
0.41466 0.75017 lineto
0.46824 0.84388 lineto
0.60004 0.88264 lineto
0.70394 0.85466 lineto
0.69931 0.7826 lineto
0.5851 0.69243 lineto
0.41886 0.58977 lineto
0.3994 0.57204 lineto
0.27903 0.4466 lineto
0.27294 0.31912 lineto
0.39172 0.23753 lineto
0.55136 0.24547 lineto
0.63002 0.34647 lineto
0.57941 0.49677 lineto
0.47041 0.64335 lineto
0.42231 0.76356 lineto
0.48707 0.84942 lineto
Mistroke
0.61489 0.87864 lineto
0.70328 0.84437 lineto
0.68299 0.76972 lineto
0.56135 0.67777 lineto
0.3994 0.57204 lineto
0.38221 0.55412 lineto
0.27816 0.42839 lineto
0.28991 0.30746 lineto
0.41453 0.23866 lineto
0.5626 0.2599 lineto
0.62279 0.36794 lineto
0.56384 0.51771 lineto
0.46354 0.66053 lineto
0.43156 0.77583 lineto
0.50533 0.85359 lineto
0.62751 0.87374 lineto
0.70038 0.8337 lineto
0.66561 0.75659 lineto
0.53822 0.66266 lineto
0.38221 0.55412 lineto
0.36734 0.53616 lineto
0.27984 0.41112 lineto
0.30771 0.29763 lineto
0.43568 0.2417 lineto
0.5712 0.27534 lineto
0.61437 0.38934 lineto
0.54951 0.53812 lineto
0.45897 0.677 lineto
0.4421 0.78694 lineto
0.52278 0.85647 lineto
0.63792 0.86802 lineto
0.69541 0.82269 lineto
0.64741 0.74317 lineto
0.51593 0.64716 lineto
0.36734 0.53616 lineto
0.35484 0.51829 lineto
0.28382 0.3949 lineto
0.32599 0.28964 lineto
0.45504 0.2465 lineto
0.57737 0.29162 lineto
0.6051 0.41059 lineto
0.53658 0.55796 lineto
0.45656 0.6927 lineto
0.45363 0.79687 lineto
0.53923 0.85812 lineto
0.64614 0.86155 lineto
0.68856 0.81133 lineto
0.62863 0.72945 lineto
0.4947 0.6313 lineto
0.35484 0.51829 lineto
Mistroke
0.34469 0.50067 lineto
0.28984 0.37987 lineto
0.34443 0.28348 lineto
0.47252 0.25295 lineto
0.58133 0.30862 lineto
0.59532 0.43164 lineto
0.52515 0.57721 lineto
0.45614 0.70758 lineto
0.46586 0.80562 lineto
0.5545 0.85861 lineto
0.6522 0.85437 lineto
0.68 0.79963 lineto
0.6095 0.71543 lineto
0.47472 0.61516 lineto
0.34469 0.50067 lineto
0.33686 0.48341 lineto
0.29764 0.3661 lineto
0.36273 0.27912 lineto
0.48806 0.2609 lineto
0.58333 0.32619 lineto
0.58529 0.45244 lineto
0.51529 0.59583 lineto
0.45753 0.72159 lineto
0.47852 0.81319 lineto
0.56846 0.858 lineto
0.65617 0.84655 lineto
0.66992 0.7876 lineto
0.59024 0.70111 lineto
0.45615 0.5988 lineto
0.33686 0.48341 lineto
0.33126 0.46665 lineto
0.30694 0.35367 lineto
0.38063 0.27652 lineto
0.50167 0.27023 lineto
0.58361 0.34423 lineto
0.57529 0.47292 lineto
0.50704 0.6138 lineto
0.46053 0.73467 lineto
0.49137 0.81959 lineto
0.58099 0.85637 lineto
0.65813 0.83813 lineto
0.65854 0.77525 lineto
0.57109 0.68649 lineto
0.43911 0.58232 lineto
0.33126 0.46665 lineto
0.32778 0.45051 lineto
0.31747 0.34265 lineto
0.39792 0.27562 lineto
0.51338 0.2808 lineto
0.58242 0.36261 lineto
Mistroke
0.56554 0.49305 lineto
0.50039 0.63106 lineto
0.46493 0.74681 lineto
0.50417 0.82485 lineto
0.59201 0.85376 lineto
0.65819 0.82915 lineto
0.64605 0.76257 lineto
0.55223 0.67161 lineto
0.4237 0.56579 lineto
0.32778 0.45051 lineto
0.32631 0.4351 lineto
0.32896 0.33307 lineto
0.41442 0.27636 lineto
0.52324 0.29249 lineto
0.58001 0.38125 lineto
0.55623 0.51276 lineto
0.49533 0.6476 lineto
0.47054 0.75795 lineto
0.51672 0.82898 lineto
0.60146 0.85025 lineto
0.65646 0.81964 lineto
0.63265 0.74957 lineto
0.53387 0.65649 lineto
0.41 0.54932 lineto
0.32631 0.4351 lineto
0.32669 0.42053 lineto
0.34117 0.32497 lineto
0.42996 0.27866 lineto
0.53135 0.30517 lineto
0.57661 0.40003 lineto
0.54753 0.53203 lineto
0.49179 0.66336 lineto
0.47714 0.7681 lineto
0.52883 0.83202 lineto
0.60932 0.84587 lineto
0.65306 0.80963 lineto
0.61854 0.73628 lineto
0.51617 0.64118 lineto
0.39804 0.53301 lineto
0.32669 0.42053 lineto
0.32876 0.40688 lineto
0.35385 0.31836 lineto
0.44445 0.28245 lineto
0.53781 0.31872 lineto
0.57246 0.41889 lineto
0.53957 0.55079 lineto
0.48969 0.67833 lineto
0.48452 0.77723 lineto
0.54033 0.83399 lineto
0.61557 0.8407 lineto
Mistroke
0.64812 0.79915 lineto
0.60391 0.72269 lineto
0.4993 0.62573 lineto
0.38785 0.51694 lineto
0.32876 0.40688 lineto
0.33234 0.39423 lineto
0.3668 0.31323 lineto
0.45778 0.28763 lineto
0.54276 0.33303 lineto
0.56776 0.43773 lineto
0.53244 0.56901 lineto
0.48896 0.69246 lineto
0.49249 0.78534 lineto
0.55108 0.83495 lineto
0.62022 0.83476 lineto
0.64181 0.78823 lineto
0.58897 0.70884 lineto
0.48338 0.61019 lineto
0.37941 0.50121 lineto
0.33234 0.39423 lineto
0.33726 0.38266 lineto
0.37979 0.30957 lineto
0.46992 0.29412 lineto
0.54633 0.34799 lineto
0.56271 0.45649 lineto
0.52623 0.58664 lineto
0.48946 0.70572 lineto
0.50086 0.79243 lineto
0.56095 0.83492 lineto
0.6233 0.82811 lineto
0.63426 0.77688 lineto
0.57388 0.69475 lineto
0.46852 0.59462 lineto
0.37268 0.48593 lineto
0.33726 0.38266 lineto
0.34334 0.37222 lineto
0.39267 0.30736 lineto
0.48084 0.30181 lineto
0.54867 0.36349 lineto
0.5575 0.47508 lineto
0.52098 0.60366 lineto
0.49109 0.71811 lineto
0.50945 0.7985 lineto
0.56986 0.83395 lineto
0.62487 0.82079 lineto
0.62563 0.76515 lineto
0.55883 0.68044 lineto
0.45483 0.57909 lineto
0.36762 0.47118 lineto
0.34334 0.37222 lineto
Mistroke
0.35039 0.36295 lineto
0.40527 0.30657 lineto
0.49053 0.31062 lineto
0.54994 0.37943 lineto
0.55229 0.49345 lineto
0.51671 0.62001 lineto
0.49371 0.72959 lineto
0.51808 0.80356 lineto
0.57772 0.83207 lineto
0.62498 0.81285 lineto
0.61609 0.75305 lineto
0.54397 0.66596 lineto
0.44237 0.56368 lineto
0.36415 0.45704 lineto
0.35039 0.36295 lineto
0.35823 0.3549 lineto
0.41745 0.30715 lineto
0.49902 0.32045 lineto
0.55027 0.39572 lineto
0.5472 0.51153 lineto
0.51342 0.63566 lineto
0.49719 0.74016 lineto
0.5266 0.80764 lineto
0.58447 0.82933 lineto
0.62371 0.8043 lineto
0.60579 0.74061 lineto
0.52946 0.65135 lineto
0.4312 0.54844 lineto
0.36219 0.4436 lineto
0.35823 0.3549 lineto
0.36669 0.34808 lineto
0.4291 0.30905 lineto
0.50634 0.3312 lineto
0.54983 0.41226 lineto
0.54238 0.52926 lineto
0.5111 0.65059 lineto
0.50139 0.7498 lineto
0.53486 0.81073 lineto
0.59008 0.82575 lineto
0.62115 0.7952 lineto
0.59488 0.72786 lineto
0.51542 0.63665 lineto
0.42134 0.53346 lineto
0.36162 0.43093 lineto
0.36669 0.34808 lineto
0.3756 0.3425 lineto
0.44013 0.31221 lineto
0.51255 0.34278 lineto
0.54877 0.42898 lineto
0.53791 0.54659 lineto
Mistroke
0.50972 0.66476 lineto
0.50618 0.75851 lineto
0.54275 0.81288 lineto
0.59451 0.82139 lineto
0.6174 0.78558 lineto
0.58353 0.71483 lineto
0.50198 0.62191 lineto
0.41281 0.51882 lineto
0.36234 0.41909 lineto
0.3756 0.3425 lineto
0.38482 0.33817 lineto
0.45048 0.31658 lineto
0.51773 0.3551 lineto
0.54722 0.44578 lineto
0.53388 0.56348 lineto
0.50921 0.67816 lineto
0.5114 0.76627 lineto
0.55015 0.81409 lineto
0.59778 0.81627 lineto
0.61256 0.77547 lineto
0.57188 0.70155 lineto
0.48924 0.60718 lineto
0.4056 0.50457 lineto
0.36424 0.40815 lineto
0.38482 0.33817 lineto
0.3942 0.33509 lineto
0.46009 0.32208 lineto
0.52194 0.36805 lineto
0.54531 0.46259 lineto
0.53036 0.57986 lineto
0.50952 0.69074 lineto
0.51694 0.77311 lineto
0.55695 0.81441 lineto
0.59989 0.81044 lineto
0.60675 0.76491 lineto
0.56008 0.68807 lineto
0.47729 0.59252 lineto
0.39969 0.4908 lineto
0.36718 0.39815 lineto
0.3942 0.33509 lineto
0.40361 0.33323 lineto
0.46892 0.32865 lineto
0.52528 0.38156 lineto
0.54318 0.47934 lineto
0.52738 0.5957 lineto
0.51058 0.70251 lineto
0.52265 0.77901 lineto
0.56309 0.81384 lineto
0.60087 0.80394 lineto
0.60008 0.75394 lineto
Mistroke
0.54825 0.67442 lineto
0.46621 0.57799 lineto
0.39505 0.47756 lineto
0.37104 0.38914 lineto
0.40361 0.33323 lineto
0.41294 0.33258 lineto
0.47697 0.33621 lineto
0.52783 0.39553 lineto
0.54092 0.49597 lineto
0.52498 0.61096 lineto
0.51231 0.71344 lineto
0.52843 0.78398 lineto
0.56848 0.81243 lineto
0.60076 0.7968 lineto
0.59268 0.74258 lineto
0.53653 0.66065 lineto
0.45604 0.56364 lineto
0.39162 0.46493 lineto
0.37569 0.38116 lineto
0.41294 0.33258 lineto
0.42209 0.3331 lineto
0.48424 0.34468 lineto
0.5297 0.40988 lineto
0.53864 0.51239 lineto
0.52317 0.6256 lineto
0.51461 0.72352 lineto
0.53415 0.78805 lineto
0.5731 0.81019 lineto
0.59961 0.78905 lineto
0.58466 0.73087 lineto
0.52503 0.64679 lineto
0.44684 0.54954 lineto
0.38934 0.45296 lineto
0.38101 0.37422 lineto
0.42209 0.3331 lineto
0.43097 0.33475 lineto
0.49073 0.354 lineto
0.53098 0.42452 lineto
0.53643 0.52857 lineto
0.52195 0.63959 lineto
0.5174 0.73273 lineto
0.53971 0.79121 lineto
0.57688 0.80717 lineto
0.59747 0.78074 lineto
0.57614 0.71886 lineto
0.51386 0.6329 lineto
0.43862 0.53574 lineto
0.38815 0.44171 lineto
0.38688 0.36834 lineto
0.43097 0.33475 lineto
Mistroke
0.43951 0.3375 lineto
0.49648 0.36407 lineto
0.53176 0.43938 lineto
0.53436 0.54443 lineto
0.5213 0.65289 lineto
0.52059 0.74109 lineto
0.54502 0.79349 lineto
0.57982 0.8034 lineto
0.59442 0.7719 lineto
0.56724 0.70658 lineto
0.50311 0.61902 lineto
0.43141 0.52231 lineto
0.38797 0.43123 lineto
0.39318 0.36354 lineto
0.43951 0.3375 lineto
0.44765 0.3413 lineto
0.50152 0.37483 lineto
0.53213 0.45439 lineto
0.5325 0.55992 lineto
0.5212 0.66549 lineto
0.52408 0.74857 lineto
0.55 0.7949 lineto
0.58191 0.7989 lineto
0.59054 0.76257 lineto
0.55808 0.69407 lineto
0.49287 0.6052 lineto
0.42521 0.5093 lineto
0.38872 0.42156 lineto
0.3998 0.35982 lineto
0.44765 0.3413 lineto
0.45534 0.34609 lineto
0.5059 0.3862 lineto
0.53218 0.46947 lineto
0.53088 0.575 lineto
0.52161 0.67736 lineto
0.52778 0.75519 lineto
0.55455 0.79548 lineto
0.58314 0.79371 lineto
0.5859 0.75278 lineto
0.54876 0.68138 lineto
0.4832 0.5915 lineto
0.41999 0.49677 lineto
0.3903 0.41274 lineto
0.40663 0.35718 lineto
0.45534 0.34609 lineto
0.46256 0.35182 lineto
0.50965 0.39809 lineto
0.532 0.48454 lineto
0.52956 0.58963 lineto
0.52249 0.68848 lineto
Mistroke
0.53161 0.76095 lineto
0.55864 0.79522 lineto
0.58354 0.78786 lineto
0.5806 0.74258 lineto
0.5394 0.66854 lineto
0.47417 0.57797 lineto
0.41575 0.48476 lineto
0.39263 0.4048 lineto
0.41359 0.35559 lineto
0.46256 0.35182 lineto
0.46929 0.35843 lineto
0.51284 0.41044 lineto
0.53165 0.49955 lineto
0.52855 0.60375 lineto
0.52379 0.69883 lineto
0.53547 0.76584 lineto
0.5622 0.79417 lineto
0.58312 0.78139 lineto
0.57471 0.732 lineto
0.53008 0.6556 lineto
0.46583 0.56465 lineto
0.41245 0.47334 lineto
0.39563 0.39777 lineto
0.42059 0.35505 lineto
0.46929 0.35843 lineto
0.47551 0.36586 lineto
0.51553 0.42317 lineto
0.53121 0.51444 lineto
0.52787 0.61733 lineto
0.52546 0.7084 lineto
0.53929 0.76989 lineto
0.56518 0.79235 lineto
0.58192 0.77434 lineto
0.56834 0.72109 lineto
0.5209 0.64261 lineto
0.4582 0.55161 lineto
0.41005 0.46254 lineto
0.39919 0.39167 lineto
0.42755 0.35553 lineto
0.47551 0.36586 lineto
0.48123 0.37405 lineto
0.51777 0.43621 lineto
0.53073 0.52914 lineto
0.52753 0.63034 lineto
0.52744 0.71719 lineto
0.54299 0.7731 lineto
0.56757 0.78977 lineto
0.57998 0.76673 lineto
0.56156 0.70988 lineto
0.51195 0.62961 lineto
Mistroke
0.45132 0.53889 lineto
0.4085 0.45242 lineto
0.40324 0.38651 lineto
0.4344 0.35701 lineto
0.48123 0.37405 lineto
0.48645 0.38293 lineto
0.51962 0.44949 lineto
0.53027 0.5436 lineto
0.52751 0.64275 lineto
0.52966 0.72518 lineto
0.5465 0.77548 lineto
0.56935 0.78648 lineto
0.57734 0.75861 lineto
0.55447 0.69841 lineto
0.50328 0.61665 lineto
0.44521 0.52653 lineto
0.40775 0.443 lineto
0.40769 0.38229 lineto
0.44109 0.35944 lineto
0.48645 0.38293 lineto
0.49119 0.39243 lineto
0.52114 0.46293 lineto
0.52988 0.55776 lineto
0.52782 0.65452 lineto
0.53206 0.73236 lineto
0.54976 0.77705 lineto
0.57049 0.7825 lineto
0.57408 0.75001 lineto
0.54716 0.68673 lineto
0.49499 0.60377 lineto
0.43985 0.5146 lineto
0.40774 0.43433 lineto
0.41246 0.37903 lineto
0.44757 0.3628 lineto
0.49119 0.39243 lineto
0.49547 0.40251 lineto
0.52239 0.47648 lineto
0.52958 0.57158 lineto
0.52843 0.66564 lineto
0.53459 0.73875 lineto
0.55272 0.77783 lineto
0.571 0.77786 lineto
0.57023 0.74097 lineto
0.53971 0.67488 lineto
0.48711 0.59103 lineto
0.43527 0.50313 lineto
0.40841 0.42643 lineto
0.41748 0.37671 lineto
0.4538 0.36703 lineto
0.49547 0.40251 lineto
Mistroke
0.49931 0.41307 lineto
0.52342 0.49006 lineto
0.52942 0.58502 lineto
0.52931 0.67609 lineto
0.53718 0.74433 lineto
0.55533 0.77783 lineto
0.57089 0.77259 lineto
0.56587 0.73153 lineto
0.53219 0.6629 lineto
0.47971 0.57848 lineto
0.43143 0.49218 lineto
0.40971 0.41933 lineto
0.42267 0.37533 lineto
0.45975 0.3721 lineto
0.49931 0.41307 lineto
0.50276 0.42407 lineto
0.52428 0.50363 lineto
0.5294 0.59803 lineto
0.53043 0.68584 lineto
0.53978 0.74912 lineto
0.55756 0.77708 lineto
0.57017 0.76672 lineto
0.56106 0.72172 lineto
0.52469 0.65084 lineto
0.47281 0.56615 lineto
0.42833 0.48177 lineto
0.41156 0.41304 lineto
0.42797 0.37487 lineto
0.4654 0.37795 lineto
0.50276 0.42407 lineto
0.50583 0.43544 lineto
0.52501 0.51711 lineto
0.52955 0.61057 lineto
0.53177 0.69488 lineto
0.54232 0.75311 lineto
0.55936 0.7756 lineto
0.56887 0.76029 lineto
0.55586 0.7116 lineto
0.51728 0.63874 lineto
0.46645 0.55409 lineto
0.42593 0.47195 lineto
0.4139 0.40759 lineto
0.43331 0.37531 lineto
0.47074 0.38454 lineto
0.50583 0.43544 lineto
0.50857 0.44711 lineto
0.52566 0.53047 lineto
0.52987 0.62262 lineto
0.53327 0.70319 lineto
0.54475 0.75632 lineto
Mistroke
0.56072 0.77342 lineto
0.56701 0.75334 lineto
0.55035 0.70119 lineto
0.51002 0.62665 lineto
0.46067 0.54236 lineto
0.42421 0.46276 lineto
0.41668 0.40298 lineto
0.43866 0.37663 lineto
0.47575 0.39181 lineto
0.50857 0.44711 lineto
0.51101 0.45901 lineto
0.52626 0.54363 lineto
0.53035 0.63413 lineto
0.53491 0.71078 lineto
0.54703 0.75877 lineto
0.56162 0.77055 lineto
0.56463 0.74589 lineto
0.54459 0.69054 lineto
0.50297 0.61461 lineto
0.45546 0.53099 lineto
0.42314 0.45422 lineto
0.41982 0.39921 lineto
0.44396 0.3788 lineto
0.48044 0.39971 lineto
0.51101 0.45901 lineto
0.51319 0.4711 lineto
0.52684 0.55656 lineto
0.531 0.64508 lineto
0.53664 0.71764 lineto
0.54912 0.76045 lineto
0.56205 0.76703 lineto
0.56177 0.73798 lineto
0.53865 0.67969 lineto
0.49618 0.60266 lineto
0.45084 0.52002 lineto
0.42266 0.44636 lineto
0.42327 0.3963 lineto
0.44917 0.38178 lineto
0.48481 0.40818 lineto
0.51319 0.4711 lineto
0.51514 0.48331 lineto
0.52744 0.5692 lineto
0.53181 0.65544 lineto
0.53843 0.72376 lineto
0.55096 0.76139 lineto
0.56201 0.76288 lineto
0.55847 0.72965 lineto
0.53258 0.66869 lineto
0.48971 0.59086 lineto
0.44681 0.5095 lineto
Mistroke
0.42275 0.43921 lineto
0.42697 0.39422 lineto
0.45426 0.38556 lineto
0.48886 0.41717 lineto
0.51514 0.48331 lineto
0.5169 0.49558 lineto
0.52806 0.58152 lineto
0.53275 0.6652 lineto
0.54022 0.72913 lineto
0.55254 0.7616 lineto
0.5615 0.75813 lineto
0.55477 0.72094 lineto
0.52645 0.65757 lineto
0.48358 0.57923 lineto
0.44338 0.49946 lineto
0.42335 0.43278 lineto
0.43087 0.39298 lineto
0.45921 0.39007 lineto
0.49262 0.42662 lineto
0.5169 0.49558 lineto
0.51849 0.50786 lineto
0.52873 0.59348 lineto
0.53382 0.67434 lineto
0.54198 0.73377 lineto
0.55382 0.76111 lineto
0.56054 0.75282 lineto
0.55072 0.71189 lineto
0.52033 0.64638 lineto
0.47783 0.56784 lineto
0.44052 0.48993 lineto
0.42442 0.4271 lineto
0.43491 0.39257 lineto
0.46398 0.39529 lineto
0.49609 0.43647 lineto
0.51849 0.50786 lineto
0.51995 0.52009 lineto
0.52946 0.60503 lineto
0.53499 0.68283 lineto
0.54367 0.73768 lineto
0.55478 0.75992 lineto
0.55914 0.74697 lineto
0.54638 0.70253 lineto
0.51426 0.63516 lineto
0.4725 0.55671 lineto
0.43822 0.48095 lineto
0.42592 0.42216 lineto
0.43907 0.39296 lineto
0.46857 0.40118 lineto
0.49929 0.44667 lineto
0.51995 0.52009 lineto
Mistroke
0.52131 0.53222 lineto
0.53025 0.61614 lineto
0.53623 0.69066 lineto
0.54526 0.74085 lineto
0.5554 0.75807 lineto
0.55732 0.74062 lineto
0.54179 0.69291 lineto
0.50829 0.62395 lineto
0.46761 0.54589 lineto
0.43646 0.47256 lineto
0.4278 0.41799 lineto
0.44328 0.39413 lineto
0.47295 0.40767 lineto
0.50224 0.45716 lineto
0.52131 0.53222 lineto
Mfstroke
% End of Graphics
MathPictureEnd
:[font = input; endGroup; endGroup; endGroup; endGroup; ]
Do[
Picture[{{0.632468, 0.540085}, {0.326894, 0.454809}, {-0.142128, 0.305575}, 
{-0.774596, 0.021319}, {-0.874085, -0.397957}, {-0.469021, -0.724851}, 
{0.397957, -0.859872}, {0.689319, -0.397957}, {0.326894, 0.007107}, 
{-0.241617, 0.156341}, {-0.554298, 0.540085}, {-0.25583, 0.824341}, 
{0.355319, 0.916724}, {0.675106, 0.795915}},j,j/70],{j,0,70}]
:[font = section; inactive; startGroup; Cclosed; ]
The code.

:[font = subsubsection; inactive; endGroup; ]

BeginPackage["The Midpoint Polygon Transformation`"]


(*Summer Research Program in Geometry Center,Minneapolis,1991*)
            (*  Funded by National Science Foundation*)
                      (*written by Arek Goetz*)

                  
MidPointPolygonMovie::usage=
"MidPointPolygonMovie[{{x1,y1},...,{xn,yn}},options] shows
frames of 'midpoint polygon' descendants of the polygon 
{{x1,y1},...,{xn,yn}}. In each corner of the frames there are
numbers which have the following meaning: 
upperleft - the frame number,    
upperright -the number of vertices of the polygon,    
lowerleft - iteration number,     
lowerright -absolute scaling factor.

MidPointPolygonMovie has the following options:

FirstFrameIteration -> 0,  
TotalFrameNumber  -> 2,
FractionPoint  -> 1/2,  
Blowing  -> Real,
IterationStep -> 1, 
Style ->Boundary,
ShowEllipse -> False,
VertexSize -> 5.";


FirstFrameIteration::usage="FirstFrameIteration,
is the index of the descandant shown in the first frame. 0
is the default value and means that the original
polygon is drawn in the first frame.";

TotalFrameNumber::usage="TotalFrameNumber is the number of
all frames.";
                    
FractionPoint::usage="FractionPoint defines the transformation
of a polygon by the formula:

T[{{x1,y1},...,{xn,yn}}] = {{fr x1+(1-fr)x2, fr
y1+(1-fr)y2},...,{fr xn+(1-fr)xn, fr yn+(1-fr)yn}}.
The default value is 1/2 which means that the vertices of
the transformed figure are the midpoints of the original
polygon.";
      
        
Blowing::usage="Blowing can be one of the words: Real,
Resized or ConstantPerimeter. They determine the scale of
the consecutive frames. 'Real' means that the scaling 
factor is always 1, 'Resized' causes the resizing of each
picture in such a way that the polygons tauch the edge of
frames at least at one point and are entirely showns in
the pictures. 'ConstantPerimeter' preserves the constant
perimeter in all frames.";

IterationStep::usage="IterationStep is a pure function
(1,#, #^2, 3# etc.) which determine how many more iterations should
be calculated between cosequetive frames. This function takes as an
argument the frame number. The function must give only natural numbers.
The default value is 1 which means that the consecutive frames will
show the consecutive iterations.";

Style::usage="Style determines the style of pictures.

Style -> Vertices - only vertices will be shown,
Style -> Boundary - the boundary of the polygons will be shown,
Style -> Filled   - the filled polygon will be shown,
Style -> VerticeOnBoundary - the vertices and the sides of polygons will be shown,
Style -> Spokes   - the vertices, the sides and the spokes will be shown.
A spoke is a line segment whose ends are the origin
and a vertex.";
                    
ShowEllipse::usage="ShowEllipse (True or False) calculates and
draws the 'midpoint ellipse'. The ellipse will appear in all frames.
The scaling factor is constant in this case and is also shown in all frames. This 
is to illustrate the main theorem.";

VertexSize::usage="VertexSize (a number 0...100) determines
the size of the vertices in all frames.";

SelfIntersecting::usage=
"The function SelfIntersecting[pol] returns True iff the
polygon pol is a selfintersecting one. A selfintrsecting polygon
is a polygon which has a pair of nonconsecutive sides that
have a common point."



RandomStellarPolygon::usage=
"RandomStellarPolygon[n,option] returns a random polygon whose 
descendants will eventually  become the affine images of
regular stellar n-gons. The centroids of these
polygons are at the origin. Basis[RandomStellarPolygon[n]]=
{0,0,...,ai,a(i+1),...,a(n-i-1),0,...,0}, where 1<=i<=n and the
coefficients ai,...,a(n-i-1) are chosen rangomly. The random
polygon is finally normalized so that
it touches the square {{1,1},{-1,1},{-1,-1},{-1,1}} at least
at one point and is entirely cotained in this square.
There is one option :  Precision ->16 which determines the precision
of calculations."
 
Basis::usage=
"The function Basis[pol] returns all complex coefficients
in the form of a list of the polygon pol written in the
following eigenvector basis:
 
v[j]={Cos[1j 2Pi/n]+I Sin[1j 2Pi/n],...,Cos[nj 2Pi/n]+I
Sin[nj 2Pi/n]},
                
where 1<=j<=n and n is the number of vertices of the polygon
pol. The vectors v[j], (1<=j<=n) are the all n regular, different
n-gons lying on the unit circle.";    

        
Perimeter::usage=
"Perimeter[pol] returns the perimeter of the polygon pol.";


MidPointPolygon::usage=
"MidPointPolygon[{{x1,y1},...,{xn,yn}}, fr] is a linear
transformation that returns the following polygon:
       
{{fr x1+(1-fr)x2, fr y1+(1-fr)y2},...,{fr xn+(1-fr)xn, fr
yn+(1-fr)yn}}.

If fr=1/2 the MidPointPolygon[pol] is a transformation which
returns the polygon whose vertices are the midpoints of the
sides of the polygon pol." 




Ellipse::usage=
"The function Ellipse[{{x1,y1},...,{xn,yn}}] returns the
complex coeficients a and b, and the lengths: c,d of the
semiexis in the form {a,b,c,d} such that the equation:
  
  z[]= a Cos[] + b Sin[]                 (0<=<2Pi)
 
 is the parametric equation of the 'midpoint ellipse'.";


ScalingFactor::usage=
"The function  ScalingFactor[{{x1,y1},...,{xn,yn}},fr]
 returns the scaling factor by which the consecutive,
 transformed polygons should be enlarged in order that
 the vertices lie on the 'midpoint ellipse'.";


Filled::usage = "Option for Style";
Boundary::usage = "Option for Style";
Spokes::usage = "Option for Style";
VerticesOnBoundary::usage = "Option for Style";
Vertices::usage = "Option for Style";

Resized::usage = "Option for Blowing";
Real::usage = "Option for Blowing";
ConstantPerimeter::usage = "Option for Blowing";




Begin["`private`"]
 messageSentence="`` is not a list of vertices of a polygon.";
 sentenceReal="`` is not a real number.";
                             (*max[obj] returns the radius of the minimal disk
                              centered  at the origin containing the object.*)
 max[obj_]:=Max[Abs[Flatten[obj]]];
 RealQ[s_]:=NumberQ[s] && Im[s]==0;

                (*checkFunction[f,n] checks if the image of the function f is 
                 a subset of natural numbers for the natural arguments to the
                  number n.*)  
 checkFunction[f_,n_]:=
  Block[{i,fun}, 
         fun=True;
         i=1;
         While[fun && i<=n,
                   If[IntegerQ[f[i]] && f[i]>0,i++,fun=False]
              ];
         Return[fun]
       ]; 
                 (*The function check[x] returns True iff x is a list of at least 
                   three points.*)
check[pol_]:=
 Block[{a,i},
       a=True;
       If[MatrixQ[pol],Do[
                          If[Not[VectorQ[pol[[i]]]
                                  && Length[pol[[i]]]==2
                                  && RealQ[pol[[i,1]]]
                                  && RealQ[pol[[i,2]]]
                               ],
                             a=False
                            ],
                          {i,1,Length[pol]}
                         ],  
                        a=False
          ];
        If[Length[pol]<3,a=False];
        Return[a]
      ];
      
     

Options[MidPointPolygonMovie]:= 
{
 FirstFrameIteration -> 0,
 TotalFrameNumber ->    2,
 FractionPoint          -> 1/2,
 Blowing                    -> Real,
 IterationStep          -> 1,
 Style                         -> Boundary,
 ShowEllipse            -> False,
 VertexSize              -> 5
};
  
MidPointPolygonMovie::notmat=messageSentence;
MidPointPolygonMovie::FFIoption="`` is not a nonnegative number.";
MidPointPolygonMovie::TFNoption="`` is not a positive number.";
MidPointPolygonMovie::FPoption="`` is not a real number between 0 and 1.";
MidPointPolygonMovie::Boption="`` is not one of the following words:
Real, Resized nor ConstantPerimeter.";
MidPointPolygonMovie::ISoption="`` is not an expression which can
be treated as a pure function like: 1, #, #^2, 3# etc. ,which takes only natural values.";
MidPointPolygonMovie::Soption="`` should be one of the words:
Vertices,Boundary,Filled,VerticesOnBoundary or Spokes.";
MidPointPolygonMovie::SEoption="`` should be True or False.";
MidPointPolygonMovie::VSoption="`` is not a nonegative real
number less than 100.";
MidPointPolygonMovie::polresize="Cannot resize the descendants of 
the polygon ``. 
The follwing pictures will be the real images.";




MidPointPolygonMovie[polygon_,options___]:=
Block[
 {
  firstFrameIteration,
  totalFrameNumber,
  fractionPoint,
  blowing,
  iterationStep,
  style,
  showEllipse,
  pointsize,
  number,
  k,
  nest,
  obj,
  pol,
  scale,
  end,
  i,
  qq,
  a,
  b,
  o,
  el
 },
     
     
      
 {firstFrameIteration,
  totalFrameNumber, 
  fractionPoint,
  blowing,
  iterationStep,
  style,
  showEllipse,
  pointsize
 } 
  
    = 
           
 {FirstFrameIteration,
  TotalFrameNumber,
  FractionPoint,
  Blowing,
  IterationStep&,
  Style,
  ShowEllipse,
  VertexSize
 } /. {options} /. Options[MidPointPolygonMovie]; 
       
end=False;     
Which[
      Not[check[polygon]],
           Message[MidPointPolygonMovie::notmat,polygon];
           end=True,
           
      Not[IntegerQ[firstFrameIteration] && firstFrameIteration >=0],
           Message[MidPointPolygonMovie::FFIoption,firstFrameIteration];
           end=True,

      Not[IntegerQ[totalFrameNumber] && totalFrameNumber >=1],
           Message[MidPointPolygonMovie::TFNoption,totalFrameNamber];
           end=True,
     
      Not[RealQ[fractionPoint] && Abs[fractionPoint]<1],
           Message[MidPointPolygonMovie::FPoption,FractionPoint];
           end=True,
          
      Not[MemberQ[{Real,Resized,ConstantPerimeter},blowing]],
          Message[MidPointPolygonMovie::Boption,blowing];
          end=True,
          
      Not[checkFunction[iterationStep,totalFrameNumber]],
          Message[MidPointPolygonMovie::ISoption,IterationStep];
          end=True,
          
      Not[MemberQ[{Vertices,Boundary,Filled,VerticesOnBoundary,Spokes},
                                   style
                                 ]
             ],
          Message[MidPointPolygonMovie::Soption,style];
          end=True,
          
      Not[MemberQ[{True,False},showEllipse]],
          Message[MidPointPolygonMovie::SEoption,showEllipse];
          end=True,
          
          
      Not[0 <= pointsize <= 100],
          Message[MidPointPolygonMovie::VSoption,pointsize];
          end=True
     ];
     
     
If[Not[end],
 
   number=Length[polygon];       (*number of vertices.*)
                                                        
   massCenter[obj_]:=Sum[ obj[[i]],{i,1,number}]/number;
                            (*The function    massCenter[{{x1,y1},...,{xn,yn}}]   
                            gives the position of  the center of mass of the given
                            points.*)
                            
   massCenteredObject[obj_]:=obj-
                             Table[massCenter[obj],{Length[obj]}];
             (*The function  massCenteredObject[{{x1,y1},...,{xn,yn}}] 
             changes the coordinates in such a way that the center of
             mass is at the origin  (translation).
                  Example:
                   massCenteredObject[{{1,1},{1,-1}}]={{0,1},{0,-1}} *)
  
  
  pol=massCenteredObject[polygon];
  blow=1;
  nest=firstFrameIteration;
  spokeFunction[qq_]:=Line[{{0,0},qq}];
 
  If[max[pol]==0 && (blowing == Resized || blowing == ConstantPerimeter),
       blowing=Real;
       Message[MidPointPolygonMovie::polresize,polygon]
    ]; 
   


    
    
  If [showEllipse, el=Ellipse[pol];
                   scale=ScalingFactor[pol,fractionPoint];
                   blowing="";
                   If[scale==Infinity,blowing=Real;
                                      showEllipse=False;
                                      scale=1; 
                      Message[MidPointPolygonMovie::polresize,polygon]
                      ];
                   blow=scale^firstFrameIteration//N;
                   pol=pol blow;           
                   a=el[[1]];
                   b=el[[2]];
                   ellipsePoints=Table[{Re[a Cos[Pi/40 o]+
                                           b Sin[Pi/40 o]
                                          ],
                                        Im[a Cos[Pi/40 o]+
                                           b Sin[Pi/40 o]
                                          ]
                                        },{o,0,80}
                                      ]//N
     ];
 
    midPointPolygon[obj_]:=
      Transpose[{fractionPoint Transpose[obj][[1]]+
                 (1-fractionPoint) RotateLeft[Transpose[obj][[1]]],
                 fractionPoint Transpose[obj][[2]]+
                 (1-fractionPoint) RotateLeft[Transpose[obj][[2]]]
               }];
            

 
   pol=Nest[midPointPolygon,pol,firstFrameIteration];

   If [ blowing==Resized, blow=blow /max[pol];
                          pol=pol/max[pol]
      ];

   If [blowing==ConstantPerimeter, blow=2/Perimeter[pol];
                                   pol=blow pol
      ];      
      
   If[showEllipse,Print["Each picture is resized by the the scaling factor:",
                                            scale 
                                       ]
      ];
      
                                      
   Do[ 
        If [blowing==Resized, blow=blow /max[pol];
                              pol=pol/max[pol]
           ];
        
        If [blowing==ConstantPerimeter, blow=blow 2/Perimeter[pol];
                     pol=pol 2/Perimeter[pol]
           ];
         
           
        Show[Graphics[{ 
                       Text[nest,{-1,-1},{-1.7,-1.7}],
                       Text[k,{-1,1},{-1.7,1.7}],                
                       Text[number,{1,1},{1.7,1.7}],
                       Text[blow//N,{1,-1},{1.7,-1.7}],
                         
                       If[showEllipse,Line[ellipsePoints],Text[k,{-1,1},{-1.7,1.7}]],
                                       
                       Which[blowing==Real,Text["Real",{0,1},{0,1.7}],
                             blowing==Resized,Text["Resized",{0,1},{0,1.7}],
                             showEllipse,     Text["Const. scaling factor",
                                                   {0,1},{0,1.5}
                                                                 ],
                             blowing==ConstantPerimeter,Text["Constant perimeter",
                                                             {0,1},{0,1.7}
                                                            ]
                            ],                                                              
                    
                    
                        
                    
                       Which[  style==Vertices,Flatten[{
                                                                                  PointSize[pointsize/200],
                                                                                  Map[Point,pol]
                                                                                }],
                                     style==Boundary,Flatten[{
                                                                                    Line [pol],
                                                                                    Line[{First[pol],Last[pol]}]
                                                                                  }],
                                     style==Filled,Polygon[pol],
                            
                                     style==VerticesOnBoundary,
                                                   Flatten[{
                                                                  PointSize[pointsize/200],
                                                                  Map[Point,pol],
                                                                  Line [pol],
                                                                  Line[{First[pol],Last[pol]}]
                                                                }],
                                      style==Spokes,Flatten[{
                                                                                 PointSize[pointsize/200],
                                                                                 Map[Point,pol],
                                                                                 Line [pol],
                                                                                 Line[{First[pol],Last[pol]}],
                                                                                 Map[spokeFunction,pol]
                                                                                }]                           
                                  ]                                     
                          },                                            
                      AspectRatio->Automatic,
                      PlotRange ->{{-1,1},{-1,1}},
                      Framed -> True                  
                     ]
           ]; 
             
      If [showEllipse, pol=scale^iterationStep[k] pol; 
                       blow=scale^iterationStep[k] blow//N
         ];    
       nest=nest+iterationStep[k];
       If[k<totalFrameNumber,
            pol=Nest[midPointPolygon,pol,iterationStep[k]]
         ],
      {k,totalFrameNumber}
     ] (* end of 'Do'*)
    ] (* end of 'If'*)
  ] (*end of 'Block' in MidPointPolygonMovie*)
  
 
      
(*The function intersecting[{a1,a2},{b1,b2},{c1,c2},{d1,d2}] returns
  True iff the line segments:
  {{a1,a2},{b1,b2}} and {{c1,c2},{d1,d2}} are disjoint.*)  
      
intersecting[{a1_,a2_},{b1_,b2_},{c1_,c2_},{d1_,d2_}]:=
 Block[
       {alfa,beta,mat,al,be},
       mat=(a1-b1)(d2-c2)-(d1-c1)(a2-b2);
       al=100;
       be=100;
       alfa=(d1-b1)(d2-c2)-(d1-c1)(d2-b2);
       beta=(a1-b1)(d2-b2)-(d1-b1)(a2-b2);
       If [mat != 0, al=alfa/mat; be=beta/mat];
       If [mat == 0 && alfa==0 && beta==0 &&
           (Sqrt[(a1-b1)^2+(a2-b2)^2]+
            Sqrt[(c1-d1)^2+(c2-d2)^2]
           )^2 >= (c2+d2-a2-b2)^2+
                  (c1+d1-a1-b1)^2 
                      ,al=0; be=0];
       Return[0 <= al <= 1 && 0 <= be <= 1]
      ];
      
      
norm[obj_]:=Sqrt[obj.obj];

      

SelfIntersecting::notmat=messageSentence;
SelfIntersecting[p_]:=
Block[
      {num,point,i,j,k,pol},
      If[check[p],
         num=Length[p];
         pol=Join[p,p];
         point=False;
         i=1;
         j=2;
         While[Not[point] && j<=num/2,
               While[Not[point] && i<=num, 
                     point=intersecting[pol[[i]],pol[[i+1]],
                                        pol[[i+j]],pol[[i+j+1]]
                                       ];
                     i++
                    ];i=1;j++
              ];
         Return[point],
         Message[SelfIntersecting::notmat,p]
        ]
     ];  
      
 


RandomStellarPolygon::range="`` cannot be the number of the vertices
of a RandomStellarPolygon.";
RandomStellarPolygon::Poption="`` is not a natural number.";
Options[RandomStellarPolygon]:={Precision -> 16};
RandomStellarPolygon[n_,option___ ]:=
 Block[{k1,k2,k,i,j,g,m,precision},
 precision=Precision /. {option}/. Options[RandomStellarPolygon];
      If[IntegerQ[precision] && precision > 0,      
        If[ IntegerQ[n] && n>=4,
             k1=Random[Integer,{1,(n-1.1)/2}];
             k2=Random[Integer,{1,(n-1.1)/2}];
             k=Min[k1,k2];
             pol1=RotateRight[Join[Table[I Random[Real,{-1,1},precision]+
                                           Random[Real,{-1,1},precision],
                                         {n-2k-1}
                                        ],Table[0,{1+2k}]
                                  ],k
                             ];
             pol1=N[pol1.Table[Table[Cos[2 i j Pi/n]+ I Sin[2 i j Pi/n],
                                     {i,n}
                                    ],
                               {j,n}
                              ],precision
                   ];
             pol1=Table[{Re[pol1[[g]]],Im[pol1[[g]]]},{g,n}];
           
             Return[pol1/max[pol1]],
      
             Message[RandomStellarPolygon::range,n]
             ],Message[RandomStellarPolygon::Poption,option]
           ]
              ];
     
     
           
Basis::notmat=messageSentence;       
Basis[pol_]:=
 Block[{num,w},
       If[check[pol],
           num=Length[pol];
           Return[N[1/num Table[Table[E^(-2 Pi/num i j I),{i,num}],{j,num}].
                                   Table[pol[[w,1]]+ I pol[[w,2]],{w,num}],
                              Precision[pol[[1,1]]]
                             ]
                        ],
           Message[Basis::notmat,pol]
         ]
      ];   
      






Perimeter::notmat=messageSentence;
Perimeter[obj_]:=
 Block[{i},
       If[check[obj],
             Return[Sum[norm[obj[[i+1]]-obj[[i]]],{i,1,Length[obj]-1}]+
                        norm[obj[[Length[obj]]]-obj[[1]]]//N
                         ], Message[Perimeter::notmat,obj]
           ]
              ];
                          


MidPointPolygon::notmat=messageSentence;
MidPointPolygon::type=sentenceReal;
        
MidPointPolygon[obj_,fractionPoint_]:=
      (
       If[check[obj] && RealQ[fractionPoint],
           Return[Transpose[{fractionPoint Transpose[obj][[1]]+
                            (1-fractionPoint) RotateLeft[Transpose[obj][[1]]],
                            fractionPoint Transpose[obj][[2]]+
                            (1-fractionPoint) RotateLeft[Transpose[obj][[2]]]
                           }]
                 ]
         ];
       If[Not[check[obj]],Message[MidPointPolygon::notmat,obj]];
       If[Not[RealQ[fractionPoint]],
           Message[MidPointPolygon::type,fractionPoint]
         ]
      );
      
      
 
 
Ellipse::notmat=messageSentence;
Ellipse::type=sentenceReal;
Ellipse[pol_]:=
 Block[{num,base,q},
      If[check[pol], 
          num=Length[pol];
          base=Basis[pol];
          q=1;While[q<num/2 && 
                    Chop[base[[q]]]==0 &&
                    Chop[base[[num-q]]]==0,
                    q++
                   ];
          Return[ Chop[{(base[[q]]+base[[num-q]]), 
                        I(base[[q]]-base[[num-q]]),
                        Abs[base[[q]]]+Abs[base[[num-q]]],
                        Abs[Abs[base[[q]]]-Abs[base[[num-q]]]]
                      }]
                ],
          Message[Ellipse::notmat,pol]
         ]
        ];



      
ScalingFactor::notmat=messageSentence;
ScalingFactor::type=sentenceReal;
ScalingFactor::nexist="ScalingFactor[``] does not exist since `
` is of the form {{A1,A2},{B1,B2},...,{A1,A2},{B1,B2}}."
ScalingFactor[pol_,frac_]:=
 Block[{num,base,q},
        If[check[pol] && RealQ[frac],
            num=Length[pol];
            base=Basis[pol];
            q=1;While[q<num/2 && 
                      Chop[base[[q]]]==0 &&
                      Chop[base[[num-q]]]==0,
                      q++
                     ];
             If[q<num/2,If[ frac !=.5, Return[1/Abs[frac+(1-frac) 
                                             E^(I q 2 Pi/num)]],
                                       Return[1/Cos[q Pi/num ]]
                          ],
                         Return[Infinity];
                         Message[ScalingFactor::nexist,pol,pol]
               ]
          ];
         If[Not[check[pol]],Message[ScalingFactor::notmat,pol]];
         If[Not[RealQ[frac]],Message[ScalingFactor::type,frac]]
      ];


 



End[]

EndPackage[]





^*)