/*
### draw a data point in phase, parameter, and combined (aux) space ###
-----------------------------------------------------------------------
NOTE:	periodicity of the phase and parameter space is handled here
	r_index:	0: only points inside phase space box are drawn
			1: only points inside parameter space box are drawn
			2: only points inside aux window box are drawn
	data format should be consistent with the region where points
	are drawn
-----------------------------------------------------------------------
Input:	
	r_index: 0: data in data0 format
		1: data in data1 format
		2: data in data2 format
	pwt:	destination pixwin to draw (either pwt or aux_pwt[aux_win_i])
	v:	r_index=0: variable+func(VAR_DIM_MAX+FUNC_DIM_MAX)
		r_index=1: parameter(PARAM_DIM_MAX)
		r_index=2: all (variable + function + parameter)
	s_type: <0 (dots: fast operations), s_type >=0 (symbols)
	s_size: if s_type<0 s_size = dot_size, if s_type >=0 symbol_size
	p_type: 0=PIX_SRC, 1=PIX_XOR
*/

#include <suntool/sunview.h>

#include "../include/main_kaos_def.h"

pen_down(r_index,pwt,v, color,s_type,s_size,p_type)
double v[];
int r_index,color,s_type,s_size,p_type;
Pixwin *pwt;
{
	int xp,yp,flag,colornew;
	double t_x,t_y,fmod();
	extern int aux_win_i,**aux_cur_index;
	extern int aux_ycanvas,aux_l_margin,aux_b_margin,aux_xwidth,aux_ywidth;
	extern double **aux_x_min,**aux_x_max;
	extern int full_dim,model,pixel_depth,var_dim,enable_period;
	extern int lock_count,lock_interval,var_cur_index[],param_cur_index[];
	extern int mdim1_crit,mdim1_step,mdim1,mdim0_crit,mdim0_step,mdim0;
	extern int n_stored_data1,n_stored_data0,n_displayed_data1,n_displayed_data0;
	extern int ycanvas,l_margin,b_margin,xwidth,ywidth;
	extern int p_ycanvas,p_l_margin,p_b_margin,p_xwidth,p_ywidth;
	extern double *period_len;
	extern double *all_min,*all_max;
	extern char string[];

	/* In case of monochrome monitor */
	/* color is set to the foreground color */
	
	flag = 0;
	if(r_index == 1){
		if(enable_period == 1 && period_len[var_cur_index[0]] != 0){
			t_x = fmod(v[var_cur_index[0]],period_len[var_cur_index[0]]);
			if(t_x<0)
				t_x += period_len[var_cur_index[0]];
		}
		else
			t_x = v[var_cur_index[0]];
		if(enable_period==1 && period_len[var_cur_index[1]] != 0){
			t_y = fmod(v[var_cur_index[1]],period_len[var_cur_index[1]]);
			if(t_y<0)
				t_y += period_len[var_cur_index[1]];
		}
		else
			t_y = v[var_cur_index[1]];
 		if((t_x > all_min[var_cur_index[0]]) && (t_x < all_max[var_cur_index[0]])
			&& (t_y > all_min[var_cur_index[1]]) && (t_y < all_max[var_cur_index[1]])){
			xp = l_margin + (t_x - all_min[var_cur_index[0]]) / (all_max[var_cur_index[0]] - all_min[var_cur_index[0]]) * xwidth;
			yp = ycanvas - (b_margin + (t_y - all_min[var_cur_index[1]]) / (all_max[var_cur_index[1]] - all_min[var_cur_index[1]]) * ywidth);
			flag = 1;
		}
	}
	else if(r_index == 0){
		if(enable_period == 1 && period_len[full_dim+param_cur_index[0]] != 0){
			t_x = fmod(v[param_cur_index[0]],period_len[full_dim+param_cur_index[0]]);
			if(t_x<0)
				t_x += period_len[full_dim+param_cur_index[0]];
		}
		else
			t_x = v[param_cur_index[0]];
		if(enable_period==1 && period_len[full_dim+param_cur_index[1]] != 0){
			t_y = fmod(v[param_cur_index[1]],period_len[full_dim+param_cur_index[1]]);
			if(t_y<0)
				t_y += period_len[full_dim+param_cur_index[1]];
		}
		else
			t_y = v[param_cur_index[1]];
 		if((t_x > all_min[full_dim+param_cur_index[0]]) && (t_x < all_max[full_dim+param_cur_index[0]])
			&& (t_y > all_min[full_dim+param_cur_index[1]]) && (t_y < all_max[full_dim+param_cur_index[1]])){
			xp = p_l_margin + (t_x - all_min[full_dim+param_cur_index[0]]) / (all_max[full_dim+param_cur_index[0]] - all_min[full_dim+param_cur_index[0]]) * p_xwidth;
			yp = p_ycanvas - (p_b_margin + (t_y - all_min[full_dim+param_cur_index[1]]) / (all_max[full_dim+param_cur_index[1]] - all_min[full_dim+param_cur_index[1]]) * p_ywidth);
			flag = 1;
		}
	}

	/* Draw a point or a symbol on the auxiliary windows. */
	else if(r_index ==2){
		if(enable_period ==1 && period_len[aux_cur_index[aux_win_i][0]] != 0){
			t_x = fmod(v[aux_cur_index[aux_win_i][0]],period_len[aux_cur_index[aux_win_i][0]]);
			if(t_x<0)
				t_x += period_len[aux_cur_index[aux_win_i][0]];
		}
		else
			t_x = v[aux_cur_index[aux_win_i][0]];
		if(enable_period == 1 && period_len[aux_cur_index[aux_win_i][1]] != 0){
			t_y = fmod(v[aux_cur_index[aux_win_i][1]],period_len[aux_cur_index[aux_win_i][1]]);
			if(t_y<0)
				t_y += period_len[aux_cur_index[aux_win_i][1]];
		}
		else
			t_y = v[aux_cur_index[aux_win_i][1]];

 		if(t_x> aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i]
			&& t_x < aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i]
			&& t_y > aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i]
			&& t_y < aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i]){
			xp = aux_l_margin + (t_x-aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i]) 
			/ (aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i]) * aux_xwidth;
			yp = aux_ycanvas - (aux_b_margin + (t_y - aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i]) 
			/ (aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i]) * aux_ywidth);
			flag = 1;
		}
	}
	if(flag){
		if(s_type < 0){
			if(pixel_depth ==1)
	                	colornew = 1;
			else
	                	colornew = color;
	                if(s_size==0){
				if(p_type ==0){
	                        	pw_put(pwt,xp,yp,colornew);
				}
				else {
	                        	pw_put(pwt,xp,yp,colornew);
				}
	                }
	                else {
				if(p_type == 0){
	                        	pw_rop(pwt,xp-s_size/2,yp+s_size/2,s_size,s_size,PIX_SRC | PIX_COLOR(colornew),(Pixrect *)0,0,0);
				}
				else {
	                        	pw_rop(pwt,xp-s_size/2,yp+s_size/2,s_size,s_size, (PIX_SRC ^ PIX_DST) | PIX_COLOR(colornew),(Pixrect *)0,0,0);
				}		
	                }
	        }
	        else {
	                if(pixel_depth ==1)
	                        colornew = Black;
			else
				colornew = color;
	                if(p_type==0){
	                        switch(s_type){
	                                case DOT:
	                                        pw_rop(pwt,xp-s_size,yp-s_size,s_size*2,s_size*2,PIX_SRC | PIX_COLOR(colornew),(Pixrect *)0,0,0);
	                                        break;
	                                case CROSS:
	                                        cross(pwt,xp,yp,s_size,colornew,0);                        
	                                        break;
	                                case SQUARE:
	                                        box(pwt,xp-s_size,yp+s_size,s_size*2,s_size*2,colornew,0);
	                                        break;
	                                case TRIANGLE:
	                                        triangle(pwt,xp,yp,s_size,colornew,0);
	                                        break;
	                                case XCROSS:
	                                        xcross(pwt,xp,yp,s_size,colornew,0);
	                                        break;
	                                case INVTRI:
	                                        inv_triangle(pwt,xp,yp,s_size,colornew,0);
	                                        break;
	
	                                case DIAMOND:
	                                        diamond(pwt,xp,yp,s_size,colornew,0);
	                                        break;
	                                case STAR:
	                                        star(pwt,xp,yp,s_size,colornew,0);
	                                        break;
	                                case CIRCLE:
	                                        circle(pwt,xp,yp,s_size,colornew,0);
	                                        break;
	                                default:
	                                        if(s_type > 32 && s_type < 127){
	                                                sprintf(string,"%c",s_type);
	                                                pw_text(pwt,xp-2,yp+2,PIX_SRC | PIX_COLOR(colornew),0,string);
	                                        }
	                        }
	                }
	                else if(p_type ==1){
	                        switch(s_type){
	                                case DOT:
	                                        pw_rop(pwt,xp-s_size,yp-s_size,s_size*2,s_size*2, (PIX_SRC ^ PIX_DST) | PIX_COLOR(colornew),(Pixrect *)0,0,0);
	                                        break;
	                                case CROSS:
	                                        cross(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                case SQUARE:
	                                        box(pwt,xp-s_size,yp+s_size,s_size*2,s_size*2,colornew,1);
	                                        break;
	                                case TRIANGLE:
	                                        triangle(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                case XCROSS:
	                                        xcross(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                case INVTRI:
	                                        inv_triangle(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                case DIAMOND:
	                                        diamond(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                case STAR:
	                                        star(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                case CIRCLE:
	                                        circle(pwt,xp,yp,s_size,colornew,1);
	                                        break;
	                                default:
	                                        if(s_type > 32 && s_type < 127){
	                                                sprintf(string,"%c",s_type);
	                                                pw_text(pwt,xp-2,yp+2,(PIX_SRC ^ PIX_DST) | PIX_COLOR(colornew),0,string);
	                                        }
	                        }
	                }
	        }
	}
	lock_count++;

	/* lock and unlock operations only for lock_interval > 0 */
	/* lick_interval=0: switch for turning it off */
	if (lock_count >= lock_interval) {
		unlock();
		lock();
		lock_count = 0;
	}
}
