/*
### create parameter space window ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <stdio.h>

void create_param_windows()
{
	int px,py;
	void param_handle_event(),param_resize_proc(),param_repaint_proc();
	extern short param_window_show;
	extern int slide_mode,region_index,pixel_depth,colormap_option,invert_background;
	extern int p_xwindow,p_ywindow,p_xwidth,p_ywidth;
	extern int p_xcanvas,p_ycanvas,p_l_margin,p_b_margin,my_colormap_size;
	extern Frame frame,param_frame;
	extern Canvas param_canvas;
	extern Cursor param_cursor;
	extern Pixwin *param_pw;

	if(param_window_show){
		window_set(param_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		param_window_show = 1;

	/* Create and set frame*/
	if(slide_mode){
		px=0;
		py=0;
		param_frame = window_create(frame,FRAME,
			FRAME_NO_CONFIRM,	FALSE,
			FRAME_SHOW_LABEL, FALSE,
			WIN_SHOW, TRUE,
			WIN_X,	px,
			WIN_Y,	py,
			WIN_WIDTH,	p_xwindow,
			WIN_HEIGHT,	p_ywindow,
			0);
	}
	else {
		px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH);
		if(px > 1152 - p_xwindow)
			px = 1152-p_xwindow;
		py = 0;
		param_frame = window_create(frame,FRAME,
			FRAME_NO_CONFIRM,	FALSE,
			FRAME_LABEL, "parameter space",
			FRAME_SHOW_LABEL, TRUE,
			WIN_SHOW, TRUE,
			WIN_X,	px,
			WIN_Y,	py,
			WIN_WIDTH,	p_xwindow,
			WIN_HEIGHT,	p_ywindow,
			0);
	}
	if(param_frame == NULL) {
		system_mess_proc(0,"No more windows. Clean up some windows to make room.");	
		param_window_show = 0;
		return;
	}
	
	p_xcanvas = p_xwindow-10;
	p_ycanvas = p_ywindow-30;
	p_xwidth = p_xcanvas - p_l_margin * 2;
	p_ywidth = p_ycanvas - p_b_margin * 2;
	/* Create and set canvas*/
	param_canvas = window_create(param_frame, CANVAS,
		CANVAS_RETAINED,	FALSE, 0);
	if(param_canvas == NULL) {
		system_mess_proc(0,"No more windows. Clean up some windows to make room.");	
		(void) destroy_param_windows();
		return;
	}
	param_cursor = cursor_create(CURSOR_SHOW_CROSSHAIRS,TRUE,
				CURSOR_CROSSHAIR_COLOR, my_colormap_size-1,	
				CURSOR_CROSSHAIR_LENGTH,10,0);
	window_set(param_canvas,
		CANVAS_RETAINED,	TRUE,
	        CANVAS_AUTO_SHRINK,     TRUE,
	        CANVAS_AUTO_EXPAND,     TRUE,
	        CANVAS_WIDTH,           p_xcanvas,
	        CANVAS_HEIGHT,          p_ycanvas,
		WIN_CONSUME_KBD_EVENTS,	WIN_ASCII_EVENTS,WIN_TOP_KEYS,WIN_RIGHT_KEYS,0,
		WIN_CONSUME_PICK_EVENTS,     WIN_MOUSE_BUTTONS,	LOC_DRAG,0,
		WIN_EVENT_PROC,             param_handle_event,
		WIN_CURSOR,	param_cursor,
		CANVAS_RESIZE_PROC,	param_resize_proc,
		/*
		CANVAS_REPAINT_PROC,	param_repaint_proc,
		*/
		0);
	/* set colormap */
	param_pw = (Pixwin *) canvas_pixwin(param_canvas);
		
	/* load colormap */
	if(pixel_depth ==1){
		colormap_option = 0;
		invert_background = 0;
	}
	else {
		colormap_option = 3;
	}
	load_colormap(0);
	redisplay_data(0);
}

void param_resize_proc(canvas)
Canvas canvas;
{
	extern Frame param_frame;
	extern int p_xcanvas,p_ycanvas,p_xwindow,p_ywindow,p_xwidth,p_ywidth;
	extern int p_l_margin,p_b_margin;

	p_xwindow= (int) window_get(param_frame,WIN_WIDTH);
	p_ywindow= (int) window_get(param_frame,WIN_HEIGHT);
	p_xcanvas = p_xwindow-10;
	p_ycanvas = p_ywindow-30;
	p_xwidth = p_xcanvas - p_l_margin * 2;
	p_ywidth = p_ycanvas - p_b_margin * 2;
}

void param_repaint_proc(canvas,event,arg)
Canvas canvas;
Event *event;
caddr_t arg;
{
	int resize;
	if(!(resize=(int)window_get(canvas,WIN_RESIZE))){
		redisplay_data(0);
	}
	else{
		/*
		default_repaint();
		*/
	}
}
