/*
### Draw a data point in phase space, parameter space, combined space boxes ###
--------------------------------------------------------------------------------
Input:	
	r_index: region index
		0: draw on parameter space
		1: draw on phase space and aux windows
		2: draw on aux windows
	v=variable+func(VAR_DIM_MAX+FUNC_DIM_MAX) or parameter(PARAM_DIM_MAX)
	s_type: <0 (dots: fast operations), s_type >=0 (symbols)
	s_size: if s_type<0 s_size = dot_size, if s_type >=0 symbol_size
	p_type: 0=PIX_SRC, 1=PIX_XOR
--------------------------------------------------------------------------------
NOTE:	periodicity of the phase space is handled here
-------------------------------------------------------------------------------
*/

#define COLORMAP_FORCE_CURRENT 7

#include <suntool/sunview.h>

all_pen_down(r_index,v, color,s_type,s_size,p_type)
double v[];
int r_index,color,s_type,s_size,p_type;
{
	int i;
	extern Pixwin *pw,*param_pw, **aux_pw;
	extern short param_window_show;
	extern int colormap_option,cur_color,batch_on,aux_win_i,*aux_on,aux_max,**aux_cur_index,*aux_win_mode;

	if(batch_on)
		return;
	/* Forced current colormap */
	if(colormap_option== COLORMAP_FORCE_CURRENT)
		color = cur_color;
	if(r_index==0 && param_window_show==1){
		pen_down(0,param_pw,v,color,s_type,s_size,p_type);
	}
	else if(r_index == 1){
		pen_down(1,pw,v,color,s_type,s_size,p_type);
	}
	/* auxiliary window plotting turned off if r_index = 0 */
	if(r_index==1 || r_index == 2){
		for(i=0;i<aux_max;i++){
			if(aux_on[i]) {
				if(aux_win_mode[i]==0){
					aux_win_i = i;
					pen_down(2,aux_pw[i],v,color,s_type,s_size,p_type);
				}
			}
		}
	}	
}
