/*
### create a print window ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>

void create_print_windows()
{
	void print_quit_proc(),print_print_proc(),print_option_proc(),print_region_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,print_frame;
	extern Panel print_panel;
	extern Pixfont *boldfont;
	extern Panel_item print_quit_item,print_print_item,print_option_item,print_region_item;
	extern Panel_item print_lpr_item,print_graph_item;
	extern short print_panel_show;
	extern int panel_colormap_on;
	extern int print_option,print_region;
	extern int region_index,var_dim,param_dim,func_dim;
	extern char string[],lstring[],print_frame_label[],**var_label,**func_label,lpr_label[],graph_label[];
	
	/* Turn on the flag */	
	if(print_panel_show){
		window_set(print_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		print_panel_show = 1;

	print_region = region_index;

	px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH);
	py = (int) 750;
	
	/* Create aux frame */
	print_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    print_frame_label,
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_FONT, boldfont,
		0);
	if(print_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		print_panel_show = 0;
		return;
	}
	/* Create Panel */
	print_panel = window_create(print_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(print_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_print_windows();
		return;
	}
	/* Create panel items */
	print_quit_item= panel_create_item(print_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(print_panel, "Quit", 4, boldfont),
		PANEL_NOTIFY_PROC, print_quit_proc,
		0);
	print_print_item= panel_create_item(print_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(print_panel, "Print", 4, boldfont),
		PANEL_NOTIFY_PROC, print_print_proc,
		0);
	print_option_item= panel_create_item(print_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Format: ",
		PANEL_CHOICE_STRINGS, "Raster Image","PostScript Image",0,
		PANEL_VALUE, print_option,
		PANEL_NOTIFY_PROC, print_option_proc,
		0);

	if(print_option==0){
	print_region_item= panel_create_item(print_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Region:",
		PANEL_CHOICE_STRINGS, "Parameter Space","Phase Space","Aux Space Frame","Full Screen","Phase Space Frame",0,
		PANEL_VALUE, print_region,
		PANEL_NOTIFY_PROC, print_region_proc,
		0);
	}
	else {
	print_region_item= panel_create_item(print_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Region:",
		PANEL_CHOICE_STRINGS, "Parameter Space","Phase Space","Aux Space",0,
		PANEL_VALUE, print_region,
		PANEL_NOTIFY_PROC, print_region_proc,
		0);
	}
	print_graph_item = panel_create_item(print_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, graph_label,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_LABEL_STRING,"Graph filter:",
		0);
	print_lpr_item = panel_create_item(print_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, lpr_label,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_LABEL_STRING,"Lpr filter:",
		0);

	window_fit(print_panel);
	window_fit(print_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(print_panel,WIN_PIXWIN),"print_panel_cms");
}
