int simpletorusmap_init()
{
	title_label = "Simple Torus Map";
	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	
	var_dim = 2;
	param_dim = 4;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = 1;
	period_len[1] = 1;
	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "wx";
	param_label[1] = "wy";
	param_label[2] = "a";
	param_label[3] = "e";
	func_label[0] = "rhox";
	func_label[1] = "rhoy";

	param[0] = 0.1;
	param[1] = 1.;
	param[2] = 0.2;
	param[3] = 0.1;
	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= -1.5; param_max[0]= 1.5;
	param_min[1]= -1.5; param_max[1]= 1.5;
	param_min[2]= 0; param_max[2]= 2;
	param_min[3]= 0; param_max[3]= 2;
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;
	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;

	f_p = simpletorusmap_f;
	func_p = simpletorusmap_func;
}
/* Kim-Ostlund strongly coupled torus map */
int simpletorusmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	/* forward map */
	if(index ==1) {
		f[0] = x[0] + p[3]*(p[0] + cos(2*pi*x[0]) + p[2]*cos(2*pi*x[1]));
		f[1] = x[1] + p[3]*(p[1] + sin(2*pi*x[0]) + p[2]*sin(2*pi*x[1]));
	}
	/* inverse map not defined */
}
int simpletorusmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = v[0]-x[0];
	f[1] = v[1]-x[1];
}
