int siegelmap_init()
{
	title_label = "Siegel Map";

	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;
	
	var_dim = 2;
	param_dim = 2;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "rho";
	param_label[1] = "p";
	func_label[0] = "|Rho|^2";
	func_label[1] = "Undefined";

	param[0] = 0.618;
	param[1] = 1.;
	var_i[0] = 1.;
	var_i[1] = 0.;

	param_min[0]= 0; param_max[0]= 1;
	param_min[1]= 0; param_max[1]= 10;
	var_min[0]= -2; var_max[0]= 2;
	var_min[1]= -2; var_max[1]= 2;
	func_min[0]= 0; func_max[0]= 4;

	f_p = siegelmap_f;
	func_p = siegelmap_func;
}
/* Siegel map */
int siegelmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double xp,yp,xt,yt,theta,rr,alpha,sigma,cx,cy,cossigma,sinsigma;
	if(index ==1) {
		xt = x[0];
		yt= x[1];
		alpha = p[1];
		sigma = p[0];
		sinsigma = sin(twopi*sigma);
		cossigma = cos(twopi*sigma);
		xp = 1-xt;
		yp = -yt;
		if(xp==0){
			if(yp>0)
				theta = twopi/4;
			else
				theta = -twopi/4;
		}
		else {
			theta = atan(yp/xp);
			if(xp>0 && yp>=0)
				theta = theta; 
			else if(xp>0 && yp<0)
				theta = theta;
			else if(xp<0 && yp>0)
				theta = twopi/2 + theta;
			else if(xp<0 && yp<0)
				theta = -(twopi/2 - theta);
		}
		rr = xp*xp + yp*yp;
		rr = exp((alpha+1)/2 * log(rr));
		cx = 1 - rr * cos((alpha+1) * theta);
		cy = -rr * sin((alpha+1) * theta);
		cx = cx / (alpha+1);
		cy = cy / (alpha+1);
		f[0] = cossigma * cx - sinsigma * cy; 
		f[1] = sinsigma * cx + cossigma * cy; 
	}
	/* inverse map not defined */
}
int siegelmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = 0;
	for(i=0;i<dim;i++)
		f[0] += (v[i]-x[i])*(v[i]-x[i]);
	
}
