/*
### Initialize all default parameters of a dynamical system to be installed ###

*/

void default_model_init()
{
	int i;
	extern int var_dim,param_dim,full_dim,func_dim;
	extern int mapping_on,inverse_on,fderiv_on,enable_polar,enable_period;
	extern double *param,*param_min,*param_max,*func,*func_min,*func_max;
	extern double *var_i,*var_polar_i,*var_min,*var_max,*var_polar_min,*var_polar_max;
	extern double *period_len,pi,*xoffset,*int_yscal;
	extern char *title_label,**var_label,**var_polar_label,**param_label,**func_label;

	/*periodicity of phase space variables (DIM=var_dim)*/
	for(i=0;i<full_dim+param_dim;i++) period_len[i] =0;
	/* primary phase space variable label (DIM=var_dim)*/
	for(i=0;i<var_dim;i++) var_label[i] = "~";
	/* secondary phase space variable label (DIM=var_dim) */
	for(i=0;i<var_dim;i++) var_polar_label[i] = "~";
	/* parameter variable label (DIM=param_dim)*/
	for(i=0;i<param_dim;i++) param_label[i] = "~";
	/* function variable label (DIM=func_dim)*/
	for(i=0;i<func_dim;i++) func_label[i] = "~";
	/* starting parameter values (DIM=param_dim)*/
	for(i=0;i<param_dim;i++) param[i] = 0;
	/* starting primary phase space variable values (DIM=var_dim)*/
	for(i=0;i<var_dim;i++) var_i[i] = 0;
	/* starting seconsary phase space variable values (DIM=var_dim)*/
	for(i=0;i<var_dim;i++) var_polar_i[i] = 0;
	/* starting bounds of parameter window box */
	for(i=0;i<param_dim;i++) {
		param_min[i] = -5;
		param_max[i] = 5;
	}
	/* starting bounds of primary phase space window box */
	for(i=0;i<var_dim;i++) {
		var_min[i] = -5;
		var_max[i] = 5;
	}
	/* starting bounds of secondary phase space window box */
	for(i=0;i<var_dim;i++) {
		var_polar_min[i] = -5;
		var_polar_max[i] = 5;
	}

	/* offset for a periodic orbit */
	for(i=0;i<var_dim;i++)
		xoffset[i]=0;

	/* rescaling factor for QC integrators */
	for(i=0;i<var_dim;i++)
		int_yscal[i]=1.;
}
