/*
### pipe the output to a graph  filter ###
*/

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>

int graph_logx=0,graph_logy=1;
int graph_childpid,graph_fromchild,graph_tochild;
FILE *fp_graph_fromchild,*fp_graph_tochild;
int graph_owner=0; /* should be set from calling routines */

void graph_proc(str)
char str[];
{
	void graph_pipe_create(),graph_register_functions();
	extern int graph_owner;
	extern FILE *fp_graph_fromchild,*fp_graph_tochild;
	
	graph_pipe_create(str,&graph_childpid,&graph_fromchild,&graph_tochild);
	graph_register_functions(graph_owner);
}

void graph_register_functions(owner)
int owner;
{
	static Notify_value graph_pipe_reader(),graph_dead_child();
	Panel_item item;
	extern Panel_item fft_go_item,dims_go_item;

	if(owner==0){
		item = fft_go_item;
	}
	else if (owner==1){
	}
	else if (owner==2){
		item = dims_go_item;
	}
        (void) notify_set_input_func(item,graph_pipe_reader,graph_fromchild);
        (void) notify_set_wait3_func(item,graph_dead_child,graph_childpid);
}

/*
### Read the input pending on the pipe ###
*/ 

static Notify_value graph_pipe_reader(item,fd)
Panel_item item;
int fd;
{
	extern FILE *fp_graph_fromchild;

	return(NOTIFY_DONE);
}

/*
### Close the pipe and let the notifier know if the child process died ###
*/

static Notify_value graph_dead_child(item,pid,status,rusage)
Panel_item item;
int     pid;
union wait *status;
struct rusage *rusage;
{
	extern int graph_fromchild;
        (void) notify_set_input_func(item,NOTIFY_FUNC_NULL,graph_fromchild);
        close(graph_fromchild);
        return(NOTIFY_DONE);
}

/*
### create pipes ###
*/
void graph_pipe_create(s,pid,from,to)
char s[];
int *pid,*from,*to;
{
	int pipeto[2],pipefrom[2];
	int c,numfds;
	FILE *popen();
	
	/* Create a pipe */
        if(pipe(pipeto) < 0){
                perror("new process");
		system_mess_proc(1,"Error: Pipe failed! Check the file name!");
		return;
	}
	if(pipe(pipefrom) < 0) {
                perror("new process");
		system_mess_proc(1,"Error: Pipe failed! Check the file name!");
		return;
	}

	/* Fork a child */
        switch (*pid = fork()){
                case -1:
                        perror("new process");
                        exit(1);
                case 0:
                        /* use dup2 to set the child's stdin and stdout to
                        the pipe */
                        dup2(pipeto[0],0);
                        dup2(pipefrom[1],1);

                        /* close all other fds (except stderr) since child
                        process doesn't know about or need them */
                        numfds = getdtablesize();
                        for (c = 3; c < numfds; c++)
                                close(c);
                        (void) execl("/bin/csh","csh","-c",s,0);
                        perror("new process: child");
                        exit(1);
                default:
                        close(pipeto[0]);
                        close(pipefrom[1]);
                        *to = pipeto[1];
                        fp_graph_tochild = fdopen(*to, "w");
                        *from = pipefrom[0];
                        fp_graph_fromchild = fdopen(*from, "r");

                        /* The pipe should be unbuffered or "new process" 
                        will not get any data until 1024 characters have
                        been sent */
                        setbuf(fp_graph_tochild,NULL);
                        setbuf(fp_graph_fromchild,NULL);
                        break;
        }
}
