/*
----------------------------------------------------------------------
     TRANLATION OF TRKMANQ.F INTO C 
     Compute only one set of manifolds and create a copy by iteration
----------------------------------------------------------------------
     compute manifolds of ANY given set of hyperbolic fixed points
     with eigenvalues and eigenvectors
     m[us]f : finer divisions of manifolds
     iskip : number of skips between each data
----------------------------------------------------------------------
NOTE: In case of a negative eigenvalue use rnew = r * 2 
----------------------------------------------------------------------
*/
#include "../include/x11r2_kaos_def.h"

#define DELFRAC 0.1
void trkman_map(sevec,seval,xe,r,ms,mu,msf,muf,iskip,delman,n)
int r,ms,mu,msf,muf,iskip,n;
double **sevec,**seval,*xe,delman;
{
	int i,ic,jc,mc,kc,mf,man_index,icnt,color_index,color,ndid,rnew,negative_ev_on;
	double fabs(),delx,xerr,factor0,factor,**x,**xp,*x1,*x2,exp(),log(),*dvector(),**dmatrix();
	extern int stop,dot_size,fp_display_option,fi_maxsq;
	extern double fi_eps,fi_epsf,fi_epsm;
	extern char string[];

	x1 = dvector(0,n-1);
	x2 = dvector(0,n-1);
	mf = (muf > msf ? muf : msf);
	x = dmatrix(0,mf-1,0,n-1);
	xp = dmatrix(0,mf-1,0,n-1);

	for(ic=0;ic<n;ic++){	
		/* if complex eigenvalue exit*/
		if(seval[ic][1]!=0)
			man_index = -1;
		else {
			if(fabs(seval[ic][0])>1){
				man_index = 0;
				color = Blue;
			}
			else {
				man_index = 1;
				color = Red;
			}
			if(seval[ic][0]<0){
				negative_ev_on=1;
				rnew = r * 2;
			}
			else {
				negative_ev_on=0;
				rnew = r;
			}	
		}
		if(man_index==0) {
			if(negative_ev_on){
				factor0=exp(log(seval[ic][0])*2./muf);
			}
			else{
				factor0=exp(log(seval[ic][0])/muf);
			}
		}
		else if(man_index==1){
			if(negative_ev_on){
				factor0=exp(log(seval[ic][0])*2./msf);
			}
			else{
				factor0=exp(log(seval[ic][0])/msf);
			}
		}

		sprintf(string,"Computing a manifold for ev[%d]...",ic);
		printf("%s\n",string);
		if(man_index==0){
			printf("(Ev=%g %g)\n",seval[ic][0],seval[ic][1]);
			printf("(Evec %d =%g %g)\n",ic,sevec[ic][0],sevec[ic][1]);
			for(jc=0;jc<2;jc++){
				factor = 1.;
				for(mc=0;mc<muf;mc++){
					if(jc==0){
						printf("Unstable manfold for ev[%d]...\n",ic);
						for(i=0;i<n;i++) x[mc][i] = xe[i]+delman*sevec[ic][i]*factor;
					}
					else {
						printf("Unstable manfold for ev[%d]...\n",ic);
						for(i=0;i<n;i++) x[mc][i] = xe[i]-delman*sevec[ic][i]*factor;
					}
					factor *= factor0;
				}
				icnt=0;
				for(kc=0;kc<mu;kc++){
					for(mc=0;mc<muf;mc++){
						fmap_user(x[mc],rnew,n);
						for(i=0;i<n;i++)x1[i]=x[mc][i];
						if((icnt % iskip)==0){
							(void) draw_record_pwf(x1,color,-1,dot_size,0,1);
		  					if(fp_display_option==1)
		  						(void) draw_record_other_pwf(x1,rnew,color,-1,dot_size,0,1);
						}
						icnt++;
						if(stop){
							goto done;
						}
					}
				}
			}
		}
		else if(man_index==1) {
			printf("(Ev=%g %g)\n",seval[ic][0],seval[ic][1]);
			printf("(Evec %d =%g %g)\n",ic,sevec[ic][0],sevec[ic][1]);
			for(jc=0;jc<2;jc++){
				icnt=0;
				factor=1;
				for(mc=0;mc<msf;mc++){
					for(i=0;i<n;i++) xp[mc][i]=xe[i];
					if(jc==0){
						printf("Stable manfold for ev[%d]...\n",ic);
						for(i=0;i<n;i++) x[mc][i] = xp[mc][i]+delman*sevec[ic][i]/factor;
					}
					else {
						printf("Stable manfold for ev[%d]...\n",ic);
						for(i=0;i<n;i++) x[mc][i] = xp[mc][i]-delman*sevec[ic][i]/factor;
					}
					factor *= factor0;
				}
				for(kc=0;kc<ms;kc++){
					for(mc=0;mc<msf;mc++){
						/* install adjustable delc congtroller */
						/* currently it is divided by the same eigenvalue */
						for(i=0;i<n;i++){
							delx=(x[mc][i]-xp[mc][i])/seval[ic][0];
							x2[i]=x[mc][i]+delx;
							x1[i]=x1[i]- DELFRAC*delx;
						}
						(void) fmapi_user(x1,x2,x[mc],fi_maxsq,n,rnew,fi_eps,fi_epsf,&xerr,&ndid);
						if(stop){
							goto done;
						}
						for(i=0;i<n;i++){
							xp[mc][i]=x[mc][i];
							x[mc][i]=x1[i];
						}

						if((icnt%iskip)==0){
							(void) draw_record_pwf(x1,color,-1,dot_size,0,1);
		  					if(fp_display_option=1)
		  						(void) draw_record_other_pwf(x1,rnew,color,-1,dot_size,0,1);
						}
						icnt++;
					}
				}
			}
		}
	}

done:
	(void) free_dvector(x1,0,n-1);
	(void) free_dvector(x2,0,n-1);
	(void) free_dmatrix(x,0,mf-1,0,n-1);
	(void) free_dmatrix(xp,0,mf-1,0,n-1);
}
