/*
### Compute the fractal dimension (Only phase space) ###
Box algorithm (Swan Kim) implemented by Patrick Worfolk
Requires dims_fn.c and a sorting algorithm, eg. dims_qcksort.c
Note:  We do not really need to store the computed
values in arrays for the current usage, but for future
data manipulation it may be useful.
*/

#include <stdio.h>
#define TRUE 1
#define FALSE 0

void dims_compute(ftp)
FILE *ftp;
{
	int it,dims_len,dims_count(),*dims_n_count, *ivector(),abs(),
		last_was_zero;
	double **data_dims,*dims_n_size,*dims_n_info,*dvector(),**dmatrix();
	FILE *fopen(),*ffp;
	char s[80];
	extern int var_dim,n_stored_data1,dims_scale_max,graph_owner,dims_type_option;
	extern double dims_scale_factor,**data1_x,*all_max,*all_min;

	graph_owner = 2;

	/* set the length of data for dimensional analysis */
	dims_len = n_stored_data1;


	/* ERROR CHECKING: VARIABLES IN BOUNDS */
	/* Fatal errors: */
	if (dims_len<1) {
		system_mess_proc(1,
		  "(Box algorithm) There is no data.");
		return; }
	if (var_dim<1) {
		system_mess_proc(1,
			"(Box algorithm) Phase space dim error.");
		return; }
	if (dims_scale_max<1) {
		system_mess_proc(1,
			"Need a positive number of scales.");
		return;
		}
	/* Non fatal errors: */
	if (dims_scale_factor<=1) {
		dims_scale_factor=2;
		system_mess_proc(1,
		   "Scaling factor must be > 1.  Defaulted to 2.");
		}
	dims_check_max_scales(&dims_scale_factor,&dims_scale_max);

	/* Memory allocation */
	dims_n_count = ivector(1,dims_scale_max);
	dims_n_size = dvector(1,dims_scale_max);
	dims_n_info = dvector(1,dims_scale_max);
	if (!(data_dims = dmatrix(0,dims_len-1,0,var_dim-1))) {
		system_mess_proc(1,"(Box algorithm) Insufficient memory.");
		free_ivector(dims_n_count,1,dims_scale_max);
		free_dvector(dims_n_size,1,dims_scale_max);
		free_dvector(dims_n_info,1,dims_scale_max);
		return;
		}

	/* Open the file for data storage for analyze routine */
	sprintf(s,"kaos.dims.tmpdat");
	ffp = fopen(s,"w");

	/* Initialize */
	last_was_zero=FALSE;

	/* Compute bin sizes  */ 
	dims_n_size[1] = (all_max[0]-all_min[0])/dims_scale_factor;
	for (it=2; it<=dims_scale_max; it++) {
		dims_n_size[it]=dims_n_size[it-1]/dims_scale_factor;
		} 

	/* Normalize the data */
	dims_normalize(data1_x,data_dims,dims_len,var_dim,all_max,all_min);
	/* Start loop of scaling, sorting, and counting */
	for (it=1; it <= dims_scale_max; it++) { 
		dims_rescale(data_dims,dims_len,var_dim,dims_scale_factor);
		dims_sort(data_dims,dims_len,var_dim);
		dims_count(data_dims,dims_len,var_dim,dims_n_count+it,
		dims_n_info+it);

		/* Test to see if we want fractal or infomation dimension */
		if (dims_type_option==0) {
			fprintf(ftp,"%le %d\n",
			  dims_n_size[it],dims_n_count[it]);
			fprintf(ffp,"%le %d\n",
			  dims_n_size[it],dims_n_count[it]);
			if (it>2 && 
		   	    0.99*dims_len < dims_n_count[it] &&
		   	    0.99*dims_len < dims_n_count[it-1])
				dims_scale_max=it;
		}
		else if (dims_type_option==2) {
			if (dims_n_info[it]>0) {
				fprintf(ftp,"%le %le\n",
					dims_n_size[it],dims_n_info[it]);
				fprintf(ffp,"%le %le\n",
					dims_n_size[it],dims_n_info[it]);
			}
			else {
				if (last_was_zero) { /* dropout */
					dims_scale_max=it-2;
				}
				else last_was_zero=TRUE;
			}
		}

	}
	fclose(ffp);


	/* REMOVE THIS LINE BEFORE INCLUDING IN KAOS */
	/*
	analyze(dims_n_size,dims_n_count,dims_n_info,dims_scale_max,var_dim);
	*/


	free_dvector(dims_n_size,1,dims_scale_max);
	free_dvector(dims_n_info,1,dims_scale_max);
	free_ivector(dims_n_count,1,dims_scale_max);
	free_dmatrix(data_dims,0,dims_len-1,0,var_dim-1);
}
