/*
### 4th orderRunge-Kutta integrator one-stepper ###

Note: 	slightly modified version of 4-th order Runge-Kutta integrator "rk4"
	in "Numerical Recipes"
	c convention of [0,n-1] is used
*/

void
rk4(y,dydx,n,x,h,yout)
double y[],dydx[],x,h,yout[];
int n;
{
	int i;
	double xh,hh,h6,*dym,*dyt,*yt,*dvector();
	void free_dvector();
	extern int var_dim,model;
	extern double *param;
	extern int (*f_p)();

	dym = dvector(0,n-1);
	dyt = dvector(0,n-1);
	yt = dvector(0,n-1);
	hh = h * 0.5;
	h6 = h / 6.0;
	xh = x + hh;
	for(i=0;i<n;i++) yt[i] = y[i] + hh * dydx[i];
	(int) f_p(dyt,0,yt,param,xh,var_dim);
	for(i=0;i<n;i++) yt[i] = y[i] + hh * dyt[i];
	(int) f_p(dym,0,yt,param,xh,var_dim);
	for(i=0;i<n;i++){
		yt[i] = y[i] + h * dym[i];
		dym[i] += dyt[i];
	}
	(int) f_p(dyt,0,yt,param,x+h,var_dim);
	for(i=0;i<n;i++){
		yout[i] = y[i] + h6 * (dydx[i] + dyt[i] + 2.0 * dym[i]);
	}
	free_dvector(yt,0,n-1);
	free_dvector(dyt,0,n-1);
	free_dvector(dym,0,n-1);
}
