/*
### non-linear interpolation by iteration of Poincare section ###

Note: 	vx, vx2:oin primary coordinates
	vseci1,vseci2: in section coordinates
*/

nl_interpol(tso,vx2,vseci1,vseci2,vx,time,tsi,dim)
double vx2[],vseci1[],vseci2[],*tso,tsi,time;
int dim;
{
	int i,it,it_max;
	double ts,ts1,ts2,nl_interpol_f(),eps,err,fabs(),*vsec1,*vsec2,*vsec,*dvector();
	void free_dvector();
	extern int stop,nok,nbad,full_dim,polar_section,section_index;
	extern int (*f_p)();
	extern double section_constant,*t_vf,*t_v;

	vsec = dvector(0,full_dim-1);
	vsec1 = dvector(0,full_dim-1);
	vsec2 = dvector(0,full_dim-1);
	eps = 1.e-14;
	it_max = 10;

	ts1 = 0;
	ts2 = tsi;
	for(i=0;i<full_dim;i++) vsec1[i]=vseci1[i];
	for(i=0;i<full_dim;i++) vsec2[i]=vseci2[i];

	ts = ts1 + (ts2-ts1) * (section_constant-vsec1[section_index])/(vsec2[section_index]-vsec1[section_index]);

	for(it = 0;it <it_max;it++){
		int_onestep(t_v,t_vf,vx,&time,ts,dim);
		to_window_variables(vsec,t_v,polar_section);
		if((vsec[section_index]-section_constant)*(vsec1[section_index]-section_constant)) {
			ts1 = ts;
			for(i=0;i<full_dim;i++) vsec1[i]=vsec[i];
		}
		else {
			ts2 = ts;
			for(i=0;i<full_dim;i++) vsec2[i]=vsec[i];
		}
		if(stop)
			goto done;
		if(fabs(ts-ts1)<eps)
			goto done;
		ts = ts1 + (ts2-ts1) * (section_constant-vsec1[section_index])/(vsec2[section_index]-vsec1[section_index]);
	}

done:
	*tso = ts;
	err = fabs(ts-ts1);
	from_window_variables(vx2,vsec,polar_section);
	if(it>=10)
		nbad++;
	else
		nok++;

	free_dvector(vsec,0,full_dim-1);
	free_dvector(vsec1,0,full_dim-1);
	free_dvector(vsec2,0,full_dim-1);
}
