/*------------------------------------------------------------------------------
### loading AUTO86 output into physical memory (data2) and display ###
--------------------------------------------------------------------------------
Note:	-Display is on combined space box (auxiliary window)
	-The ouput of AUTO86 to the standard ouput is modified and looks like,

 %ACkey x x x x param[auto_icp[0]] vaxis (param[i],i=1,auto_n1-1) (auto_option=1)
 %ACkey x x x x param[auto_icp[0]] vaxis (var[i],i=0,auto_n2-1) (auto_option=2)
 %ACkey x x x x param[auto_icp[0]] vaxis (var[i],i=0,auto_n2-1) (param[i],i=1,auto_n1-1) (auto_option=3)

	-All initilizations for auto pipe process are handled by auto_p_go_proc.c
	Mapping: (kaos) auto_icp[i] = icp[i]-1 (AUTO86) because of difference
	in indexing scheme between C and Fortran
------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <suntool/sunview.h>

auto_load_data(fp)
FILE *fp;
{
	int i,lock_interval_old,color_index,color,s_type,s_size,aux_win_i,t_mode;
	char s_key[10], s_key2[3];
	extern int stop,lock_interval,symbol_size,dot_size,var_dim,full_dim,param_dim,big_length;
	extern char lstring[];
	extern double *t_va;
	/* AUTO86 declerations */
	extern int auto_option,auto_ibr,auto_ntot,auto_itp,auto_lab,auto_icp[],auto_n1,auto_n2;
	extern Pixwin **aux_pw;

	/* Temporarily set lock_interval to 0 (no locking) during piping */
	lock_interval_old = lock_interval;
	lock_interval = 0;	

	stop = 0;
	while ((fgets(lstring,big_length, fp)) != NULL) {
		sscanf(lstring,"%s",s_key);
		if(strcmp(s_key,"%%AS") == 0){
			system_mess_proc(0,"Reading AUTO86 header...");
			auto_load_param(fp);

			fscanf(fp,"%s",s_key);
			if(strcmp(s_key,"%%AE") !=0){
				system_mess_proc(1,"Header NOT in the right format!");
				return;
			}
			else {
				/* Successful reading of a header */
				system_mess_proc(0,"Successfully read AUTO86 header! Continue...");
				break;
			}
		}
	}
	/* read data in three different formats */
	auto_option = (int) get_auto_option();

	t_mode = (int) get_available_aux_window(&aux_win_i);
	/* this subroutine should always come after aux_win_i is
	chosen by get_availabel_aux_window() */
	/* this subroutine should always come after parameters
	are set by auto_translate_param() */ 
	switch(t_mode){
		case 0:
			auto_translate_param(aux_win_i);
			aux_refresh(aux_win_i);
			break;
		case 1:
			/* translation of paramters done by
			create_aux_windows */
			(void) create_aux_windows(aux_win_i);
			break;
		case 2:
			/* translation of paramters done by
			create_aux_windows */
			(void) destroy_aux_windows(aux_win_i);
			(void) create_aux_windows(aux_win_i);
			break;
		default:
			auto_translate_param(aux_win_i);
			aux_refresh(aux_win_i);
			break;
	}	

	system_mess_proc(0,"Start reading AUTO86 data...");
	/* read the data */
	while (fscanf(fp,"%s",s_key) != EOF) {
		if (strncmp(s_key, "%AC", 3) == 0) {
			/* determine colors from keys */
			/*
			i = 0;
			while ((s_key2[i] = s_key[i + 3]) != '\0')
				i++;
			color_index = (int) atoi(s_key2);
			*/
			/* Determine colors from AUTO86 parameters */
			auto_get_color_symbol(&color,&s_type);
			for(i=0;i<full_dim+param_dim;i++) t_va[i] = 0;

			fscanf(fp,"%d %d %d %d  %lg %lg",&auto_ibr,&auto_ntot,&auto_itp,&auto_lab,&t_va[full_dim+auto_icp[0]],&t_va[full_dim-1]);
			if(auto_option==1){
				for(i=1;i<auto_n1;i++) fscanf(fp,"%lg",&t_va[full_dim+auto_icp[i]]);
			}
			else if(auto_option==2){
				for(i=0;i<auto_n2;i++) fscanf(fp,"%lg",&t_va[i]);
			}
			else if(auto_option==3){
				for(i=0;i<auto_n2;i++) fscanf(fp,"%lg",&t_va[i]);
				for(i=1;i<auto_n1;i++) fscanf(fp,"%lg",&t_va[full_dim+auto_icp[i]]);
			}

			/* Piped data from AUTO86 are drawn always since one
			of aux_win_mode[aux_win_i] is always turned on
			when reading the AUTO86 data */
			s_size = (s_type>=0) ? symbol_size : dot_size;

			pen_down(2,aux_pw[aux_win_i],t_va,color,s_type,s_size,0);


			/* Piped data from AUTO86 are recorded always since 
			region_index is always set to 2 
			when reading the AUTO86 data */
			encode_color_symbol(&color_index,color,s_type);
			record_data(t_va,color_index);
		}
		if (stop) {
			break;
		}
	}
	all_refresh();

	lock_interval = lock_interval_old;
	system_mess_proc(0,"Done!");
}
