#include	"pdefs.h"
#include	"stdio.h"
#include	"math.h"
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/cursorfont.h>
#include	<X11/Intrinsic.h>

extern		Display		*dpy;				/* display device */
extern		Window		domainwin, rangewin, drawwin;	/* windows invoked */
extern		GC		gc;				/* graphics context */
extern		int		width, height;			/* dimensions of the circleinfo and plotinfo arrays */
extern		int		numcircles;			/* the number of circles in the circle domain */
extern		int		fixradi, fixradj;		/* circleinfo indices of a circle of fixed radius */
extern		int		nulli, nullj;			/* circleinfo indices of the nullcircle */
extern		double		fillrad;			/* filling radius */
extern		circleinfo	*DCirc, *RCirc;			/* info of domain and range packings */
extern		int		*mycolor;			/* array of color pixel indices assigned to circles */
extern		double		umin, umax, vmin, vmax;		/* bounding rectangle of range */
extern		double		maxkappa;			/* Maximum |curvature| */
extern		int		hw;				/* (width-1)*(height-1)+1 */

extern		Bool		nullok();		/* Checks whether nullpoint is acceptable */
extern		Bool		inside();		/* Checks whether a certain point is interior in the packing */
extern		int		packingmode;		/* If 1, circles are drawn tangent; if 2, circles intersect at prescribed angles */
	
extern		double		*curvature;		/* vector of curvature values */
extern		int		N;			/* number of circles with variable radii */
extern		int		*circindex;		/* record indices of nonzero entries in matrix of partial derivatives */
extern		int		*innerindex;		/* record indices of interior entries */
extern		XPoint		mypoint[500];		/* points on mouse-drawn radius assignment curve */
extern		int		normpoints;		/* the number of points in mypoint[] */
extern		int		xmin, xmax, ymin, ymax;		/* the bounding rectangle of mypoint[] */
extern		int		LRATIO;			/* sizeof(real)/sizeof(int); used in ndrv() */

typedef	struct	prowcol	{
	int	i, j;			/* indices of nonzero entries in circle matrix */
	} prowcol;

typedef	struct	rowpartial	{
	int	i, j;			/* indices of nonzero entries in the partial matrix */
	double	dr;			/* nonzero partial */
	} rowpartial;

/* the following variables are used in the smpak subroutine NDRV */
extern		int		*R, *C, *IC;	/* orderings on the Partial matrix; default to : i'th entry = i */
extern		int		*IA;		/* delimit rows in JA and A; size = N+1 */
extern		int		*JA;		/* column indices of nonzero entries in Partial */
extern		double		*A;		/* nonzero entries in Partial */
extern		int		*ISP;		/* integer working storage; dimension = LRATIO*NSP */
extern		double		*RSP;		/* work storage; ISP and RSP should be equivalenced (?) */
extern		int		IAindex, IAsum, JAindex;

extern	edgeinfo	*myedge;					/* angle information on edges for prescribed angle intersections */
double			getxangle();					/* return angle assigned to a certain edge */
extern	int		normbdry;					/* Maximum number of edges at border vertices */
