#include "extern.h"

/* All these functions either allocate or deallocate memory */

initedge()	{
/* Allocate memory for myedge array which stores intersection angles */
	myedge = (edgeinfo *) XtCalloc(normbdry, sizeof(edgeinfo));
} /*initedge*/
				
endedge()	{
/* Deallocate memory for array myedge */
	XtFree((char*) myedge);
} /*endedge*/

initNDRVargs()	{
/* Allocate memory for the arrays needed by the sparse linear system solver ndrv */
	int	i, NSP = 400*N;

	curvature = (double *) XtCalloc (N+1, sizeof (double));
	R = (int*) XtCalloc(N+1, sizeof(int));
	C = (int*) XtCalloc(N+1, sizeof(int));
	IC = (int*) XtCalloc(N+1, sizeof(int));
	for (i=1; i<=N; ++i)	
		R[i] = C[i] = IC[i] = i;
	IA = (int*) XtCalloc(N+1+1, sizeof(int));
	JA = (int*) XtCalloc(7*N+1, sizeof(int));
	A = (double*) XtCalloc(7*N+1, sizeof(double));
	ISP = (int*) XtCalloc(LRATIO*NSP+1, sizeof(int));
	RSP = (double*) XtCalloc(NSP+1, sizeof(double));
} /* initNDRVargs */

endNDRVargs()	{
/* Deallocate ndrv() arrays */
	XtFree ((char *) curvature);
	XtFree((char*) R);
	XtFree((char*) C);
	XtFree((char*) IC);
	XtFree((char*) IA);
	XtFree((char*) JA);
	XtFree((char*) A);
	XtFree((char*) ISP);
	XtFree((char*) RSP); 
} /*endNDRVargs */
			
initcircs()	{
/* Allocate memory for arrays recording the circles' positions, radii, etc.*/
	DCirc = (circleinfo *) XtCalloc(width*height, sizeof(circleinfo));
	RCirc = (circleinfo *) XtCalloc(width*height, sizeof(circleinfo));
} /*initcircs*/
				
endcircs()	{
/* Deallocate memory for arrays */
	XtFree((char*) DCirc);
	XtFree((char*) RCirc);
	XtFree((char*) mycolor);
	XtFree((char*) circindex);
	XtFree((char*) innerindex);
} /*endcircs*/
