/****
   util.c:  Utility routines for "interpolate"  
   Written by Toby Orloff
   orloff@poincare.geom.umn.edu
   July 10, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */

#include <stdio.h>
#include "types.h"
#include "globals.h"

PrintFileValueList(fp,fvl,num)

FILE *fp;
FileValueList *fvl;
int num;
{
  int total,files;
  FileValueList *fvl_ptr;
  ValueList *val_ptr;

  fvl_ptr = fvl;

  files = 0;
  while(fvl_ptr != NULL) {
    fprintf(fp,"File %d:\n",files);
    fprintf(fp,"  type: %d\n",fvl->type);
    fprintf(fp,"  time: %.4lf\n",fvl_ptr->time);
    fprintf(fp,"  values:\n");

    val_ptr = fvl_ptr->value.next;

    total = 0;
    while(total < num) {
       fprintf(fp,"    %.4lf\n",val_ptr->value);
       total++;
       val_ptr = val_ptr->next;
      } 
    fprintf(fp,"\n\n");

    files++;
    fvl_ptr = fvl_ptr->next;
   }
}


is_a_float(strng)

char *strng;

{
  char *ch;
  int passes,is_an_int;
  double val;

  /* Check if convertible to floating point number */

  passes = 1;
  is_an_int = 1;   /* Until otherwise determined */

  val = strtod(strng,&ch);
  if(*ch != '\0')  {   /* Not correct format */
     passes = 0;
    }

  if(integer) {  /* Regard integers as floating point data */
     is_an_int = 0;
    }

  else {

     /* Check to see if its an integer */

     ch = strng;

     while(*ch != '\0' && passes) {

        switch(*ch) {

           case '.':
           case 'e':
           case 'E':
             is_an_int = 0;
             ch++;
             break;

           default:
             ch++;
          }

       }
    }

  if(passes == 1 && is_an_int == 0) return(1);
  else return(0);
}


