/****
   types.h:  The type definitions for "interpolate"  
   Written by Toby Orloff
   orloff@poincare.geom.umn.edu
   July 10, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */

#define LINEAR 0
#define CARDINAL 1

#define ASCII   0
#define BINARY  1

#define CHARACTER 0
#define SHORT     1
#define INTEGER   2
#define LONG      3
#define FLOAT     4
#define DOUBLE    5

#define MSB    0   /* Most significant bit first */
#define LSB    1   /* Least significant bit first */

struct value_list_struct {     /* The basic value list */
  
  double value;

  struct value_list_struct *next;

 };

typedef struct value_list_struct ValueList;

struct file_value_list_struct {   /* The list of files and values */

  int type;  /* Type of data in list */
  double time;    /* Parameter value for this list of values */
  long offset;   /* Current location in file */
  char name[80];  /* filename */
  ValueList value;
  struct file_value_list_struct *next;

};

typedef struct file_value_list_struct FileValueList;


typedef struct {

  int type;         /* Type of interpolation */
  int num;          /* Number of values oneach input list */
  int position;     /* The number of values into the input file of */
                    /* the first element on the input list.  */

  long flags;       /* flags to speed up interpolation */

 } InterpolationAttributes;

