/* $Id: bothpipe.c,v 2.4 90/07/11 13:11:03 mbp Exp Locker: mbp $
 *
 * bothpipe.c: utility functions needed by both elbowd and mathpipe
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

#include <stdio.h>
#include "bothpipe.h"

/*-----------------------------------------------------------------------
 * Function:	resolve_host
 * Description:	Resolve the specified host name into an internet address
 * Args IN:	name: either a character string name, or an address in
 *		  the form a.b.c.d where the pieces are octal,
 *		  decimal, or hex numbers.
 * Returns:	Pointer to a Sockaddr, or NULL if name is unknown
 * Notes:	The structure pointed to is statically allocated and
 * 		  must be copied
 *
 *		I stole this function from mazewar by Christopher A. Kent.
 */
Sockaddr *
  resolve_host(name)
register char *name;
{
  register struct hostent *fhost;
  struct in_addr fadd;
  static Sockaddr sa;
  
  if ((fhost = gethostbyname(name)) != NULL) {
    sa.sin_family = fhost->h_addrtype;
    sa.sin_port = 0;
    bcopy(fhost->h_addr, &sa.sin_addr, fhost->h_length);
  } else {
    fadd.s_addr = inet_addr(name);
    if (fadd.s_addr != -1) {
      sa.sin_family = AF_INET;
      sa.sin_port = 0;
      sa.sin_addr.s_addr = fadd.s_addr;
    } else
      return(NULL);
  }
  return(&sa);
}


/*-----------------------------------------------------------------------
 * Function:	fgetline
 * Description:	read a line from a file
 * Args  IN:	s: buffer in which to write chars
 *		n: size of buffer s
 *		fd: file descriptor to read from
 *      OUT:	s: the chars which were read
 * Returns:	s, if any chars have been read, NULL otherwise
 * Notes:	This is designed to be similar to fgets(3), with the
 *		following exceptions:
 *		1. fd is a file descriptor rather than a file pointer
 *		2. The final newline is translated to the '\0' char
 */
char *
  fgetline(s, n, fd)
char *s;
int fd;
{
  char *r;

  r = s;
  while ((--n) && (read(fd, s, 1) == 1)) {
    if (*s == '\n')
      break;
    else {
      ++s;
    }
  }
  if (s == r) return(NULL);
  if (*s == '\n') *s = '\0';
  return(r);
}

/*-----------------------------------------------------------------------
 * Function:	extract_last_component
 * Description:	extract the last component from a path
 * Args  IN:	path: the pathname
 *      OUT:	name: the last '/'-separated component of path
 * Notes:	If path contains no '/', name is set to all of path.
 *		If path ends in a '/', name is set to the empty string.
 */
extract_last_component(name, path)
     char *name, *path;
{
  int i, len;
  
  len = strlen(path);
  i = len - 1;
  while ((i > 0) && (path[i] != '/')) --i;
  if ((i >= 0) && (i < len-1)) {
    if (path[i] == '/')
      strcpy(name, path+i+1);
    else
      strcpy(name, path+i);
  }
  else
    *name = '\0';
}

pquit(msg)
     char *msg;
{
  perror(msg);
  exit(-1);
}

quit(msg)
     char *msg;
{
  fprintf(stderr,"%s\n", msg);
  exit(-1);
}
