/* $Id: strtokq.c,v 1.2 90/07/11 13:10:47 mbp Exp Locker: mbp $
 *
 * strtokq.c: special version of strtok which is capable of parsing
 *	strings containing quoted substrings
 */

/* Author:	Mark B. Phillips
 *		August 17, 1989
 */

/* SYNOPSIS:
 *
 * char *strtokq();
 *
 * char *strtokq(string, seps, quotes)
 * char *string, *seps, *quotes;
 *
 * see below for more info
 */

#include <stdio.h>
#include <string.h>

#define CHAR_IN_STRING(c,s) (strchr(s,c) != NULL)

/*-----------------------------------------------------------------------
 * Function:	strtokq
 * Description:	parse string into tokens maybe containing quoted substrings
 * Args  IN:	string: the string to be parsed, or NULL
 *		seps: string of separator chars
 *		quotes: string of quote chars
 * Returns:	pointer to returned token
 * Notes:	This is just like strtok(3), except that substrings of
 *		string delimited by chars of quotes are not broken up.
 *		The quote chars, however, are removed.
 *		
 *		NOTE: This procedure overwrites the contents of string.
 *		It can be called repetitively to parse multiple tokens
 *		in the same string by setting string=NULL on calls after
 *		the first, (just as with strtok(3)) but the contents of
 *		the original string s will be altered.
 */
char *
  strtokq(string, seps, quotes)
char *string, *seps, *quotes;
{
  static char *s;
  static char c;
  static char *end;
  int qcnt, qmode;

  if (string != NULL)
    s = string;
  else {
    s = end;
    *s = c;
  }

  /* If string is empty, return now */
  if (*s == '\0') return((char*)NULL);

  /* Find beginning of string */
  while (CHAR_IN_STRING(*s, seps)) ++s;
  /* Now *s is 1st char of string */

  /* Find end of string, including things between quote chars as
   * substrings, regardless of whether they contain separator chars.
   * The quote chars themselves are removed. */
  end = s;
  qcnt = 0;	/* qcnt = # of quote chars seen so far in this string */
  qmode = 0;	/* qmode = whether we're in a quoted substring */
  while (qmode || !CHAR_IN_STRING(*end, seps)) {
    if (CHAR_IN_STRING(*end, quotes)) {
      ++qcnt;
      qmode = !qmode;
      }
    else
      *(end-qcnt) = *end;
    ++end;
  }

  /* Now *(end-qcnt) is 1st char following string, and *end is 1st
   * char of next string */

  /* Put null char after string, remembering what was there for next call */
  c = *end;
  *(end-qcnt) = '\0';

  return(s);
}

#ifdef STRTOK_STANDALONE
main()
{
  char buf[80];
  char seps[10];
  char quotes[10];
  char *c;
  
  while (1) {
    printf("Enter buf: "); gets(buf);
    printf("Enter seps: "); gets(seps);
    printf("Enter quotes: "); gets(quotes);
    
    c = strtokq(buf, seps, quotes);
    printf("strtokq -> \"%s\"\n", c);
    do {
      c = strtokq((char*)NULL, seps, quotes);
      if (c != NULL)  printf("strtokq -> \"%s\"\n", c);
    } while (c != NULL);
    printf("Done.\n\n");
  }
}
#endif
