/* $Id$
 *
 * internal.h
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <pixrect/pixrect_hs.h>

typedef int (*PFI)();		/* Pointer to function returning int */

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define	ROUND(x)		((int)((x)+.5))

#define SELECT_IN_CANVAS	1
#define SELECT_IN_BOTH		2

/*
 * The canvas and mini_canvas are each square, having side lengths
 * wCanvasLength and wMCanvasLength (in pixels).  We define separate
 * macros for the width and height and use the macros instead of the
 * actual length variables wherever possible, however, to facilitate a
 * possible future change to allow non-square canvases.
 */
#define canvas_width		wCanvasLength
#define canvas_height		wCanvasLength
#define mini_canvas_width	wMCanvasLength
#define mini_canvas_height	wMCanvasLength

/* Macros to convert user canvas coords
 *	[(wVPX,wVPY) to (wVPX+wVPS,wVPY+wVPS)]
 * to pixel canvas coords
 *	[(0,canvas_height) to (canvas_width, 0)]
 */
#define CANVAS_DIMEN(d)		ROUND(d*wCXF)
#define CANVAS_X_COORD(x)	ROUND((x-wVPX)*wCXF)
#define CANVAS_Y_COORD(y)	ROUND((y-wVPY)*wCYF+canvas_height)
/* ... and the other way: */
#define SAVNAC_DIMEN(d)		(d/wCXF))
#define SAVNAC_X_COORD(x)	(x/wCXF + wVPX)
#define SAVNAC_Y_COORD(y)	((y-canvas_height)/wCYF+wVPY)

/*
 * And the analogous things for the mini_canvas:
 */
#define MINI_CANVAS_DIMEN(d)	ROUND(d*wMCXF)
#define MINI_CANVAS_X_COORD(x)	ROUND((x-wMCVPX)*wMCXF)
#define MINI_CANVAS_Y_COORD(y)	ROUND((y-wMCVPY)*wMCYF+mini_canvas_height)
#define MINI_SAVNAC_DIMEN(d)	(d/wMCXF))
#define MINI_SAVNAC_X_COORD(x)	(x/wMCXF + wMCVPX)
#define MINI_SAVNAC_Y_COORD(y)	((y-mini_canvas_height)/wMCYF+wMCVPY)

/*
 * External private symbols from window.c:
 */
#define BATCH		0
#define CONTINUOUS	1
extern Pixfont	        *wFont1, *wFont2;
extern Frame		wFrame;
extern Pixwin		*wCanvas_pw, *wMCanvas_pw;
extern int		wCanvasLength, wMCanvasLength;
extern int		wDrawingMode;

/*
 * External private symbols from graphics.c:
 */
extern double		wVPX,wVPY,wVPS, wCXF, wCYF;
extern double		wMCVPX, wMCVPY, wMCVPS, wMCXF, wMCYF;
extern int
  wMCPoint(),
  wMCSegment(),
  wMCErase(),
  wMCArc(),
  wSetCanvasViewport(),
  wSetMiniCanvasViewport(),
  wComputeCanvasFactors(),
  wComputeMiniCanvasFactors(),
  wBatch();

/*
 * External private symbols from zoom.c:
 */
extern Panel_item	wCreateZoomFactorSlider();
extern int		wZoom();

/*
 * External private symbolis from recenter.c:
 */
extern int		wRecenter(), wSetRecenterPixrects();

/*
 * External private symbolis from print.c:
 */
extern int		wPrint();


/*
 * External private symbolis from reset.c:
 */
extern int		wReset();

/*
 * External private symbolis from help.c:
 */
extern int		wHelp();

/*
 * External private symbolis from util.c:
 */
extern int		wSmallestSquare();
