/*
 * gdb_example.c: example GDB entity specification file
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

#include <stdio.h>
#include <math.h>
#include "gdb.h"		/* standard GDB include file */
#include "gdb_example.h"	/* file containing defs of our entities */

#define SQR(x) ((x)*(x))

/*-----------------------------------------------------------------------
 * Function:     gdb_entity_data_size(type)
 * Description:  Computes the size of an entity data object of the given type
 * Arguments:    type: flag of type to compute size of
 * Returns:      the size
 */
gdb_entity_data_size(type)
gdb_Entity_type type;
{
  switch (type) {
  case POINT: return( sizeof(Point) );
  case SEGMENT: return( sizeof(Segment) );
  }
  return(0);
}

/*-----------------------------------------------------------------------
 * Function:     gdb_entity_data_copy(a,b,type)
 * Description:  Copies one entity to another
 * Arguments:    a,b: destination and source (a <- b)
 *               type: type flags of entities a and b
 * Returns:      Nothing
 */
gdb_entity_data_copy(a,b,type)
     char *a,*b;
     gdb_Entity_type type;
{
  int i;

  switch (type) {
  case POINT:
    for (i=0; i<2; ++i) ((Point*)a)[i] = ((Point*)b)[i];
  case SEGMENT:
    for (i=0; i<2; ++i) ((Segment*)a)->p1[i] = ((Segment*)b)->p1[i];
    for (i=0; i<2; ++i) ((Segment*)a)->p2[i] = ((Segment*)b)->p2[i];
    break;
  default:
    break;
  }
}

/*-----------------------------------------------------------------------
 * Function:     gdb_entity_data_dist
 * Description:  Computes the distance between two entities
 * Arguments:    a,b: the two entities
 *               type_a, type_b: type flags of entities a and b
 * Returns:      Distance from a to b
double gdb_entity_data_dist(a,type_a,b,type_b)
     char *a,*b;
     gdb_Entity_type type_a, type_b;
{
  double d;

  switch (type_a) {
  case POINT:
    switch (type_a) {
    case POINT:
      return( point_point_distance( (Point*)a, (Point*)b ) );
    case SEGMENT:
      return( point_segment_distance( (Point*)a, (Segment*)b ) );
    }
    break;
  case SEGMENT:
    switch (type_a) {
    case POINT:
      return( point_segment_distance( (Point*)b, (Segment*)a ) );
    case SEGMENT:
      return( segment_segment_distance( (Segment*)a, (Segment*)b ) );
      break;
    }
    break;
  }
  return(GDB_INFINITY);
}

static double point_point_distance( a, b )
Point a, b;
{
  return( sqrt( SQR(a[0]-b[0]) + SQR(a[1]-b[1]) ) );
}

static double point_segment_distance( a, b )
Point a;
Segment *b;
{
  /* this function should return the distance from point a
   * to segment b. */
}

static double segment_segment_distance( a, b )
Segment *a,*b;
{
  /* this function should return the distance from segment
   * a to segment b */
}

      
  
