/*
 * glg.c: a GL gadgets package
 *
 * By Mark Phillips, June 4 1990
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>
#include "gl.h"
#include "device.h"
#include "glg.h"
#include "internal.h"

static GlGadget **Gadgets = NULL;

int GlgXorg, GlgYorg, GlgXsize, GlgYsize;
double GlgXMIN, GlgXMAX, GlgYMIN, GlgYMAX;

/*-----------------------------------------------------------------------
 * Function:	GlgInit
 * Description:	Initialize glg
 * Args  IN:	gadgets: NULL terminated list of all gadgets
 *		drawfunc: function to redraw window
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 22:50:20 1990
 */
GlgInit(gadgets, drawfunc)
GlGadget **gadgets;
int (*drawfunc)();
{
  Gadgets = gadgets;

  GlgSliderInit(drawfunc);
  GlgMessageInit(drawfunc);
  GlgTextInit(drawfunc);
  GlgButtonInit(drawfunc);
}

/*-----------------------------------------------------------------------
 * Function:	GlgDrawAll
 * Description:	Draw all the gadgets
 * Args:	(none)
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 12:40:42 1990
 * Notes:	
 */
int
  GlgDrawAll()
{
  register GlGadget **gp;
  
  if (Gadgets != NULL)
    for(gp = Gadgets; *gp != NULL; gp++)
      if ((*gp)->draw != NULL)
	((*gp)->draw)((*gp)->data);
  
}

/*-----------------------------------------------------------------------
 * Function:	GlgProcessEvent
 * Description:	Let the gadgets process an event
 * Args  IN:	event: the event
 * Returns:	the handle (pointer) of the first gadget which acts
 *		  on the event
 * Author:	mbp
 * Date:	Mon Jun  4 13:07:42 1990
 */
GlGadget *
  GlgProcessEvent(event)
GlgEvent event;
{
  register GlGadget **gp;

  if (Gadgets != NULL)
    for(gp = Gadgets; *gp != NULL; gp++)
      if ((*gp)->processevent != NULL)
	if (((*gp)->processevent)((*gp)->data, event))
	  return(*gp);
  return(NULL);
}

/*-----------------------------------------------------------------------
 * Function:	GlgSetViewport
 * Description:	Set the viewport coords for the gadget window
 * Args  IN:	xorg, yorg: new viewport origin
 *		xsize, ysize: new sizes
 * Returns:	nothing
 * Author:	mbp
 * Date:	Sun Jun  3 15:45:50 1990
 * Notes:	xorg and yorg should come from getorigin(),
 *		and xsize and ysize should come from getsize().
 */
int
  GlgSetViewport(xorg, yorg, xsize, ysize)
int xorg, yorg, xsize, ysize;
{
  GlgXorg = xorg;
  GlgYorg = yorg;
  GlgXsize = xsize;
  GlgYsize = ysize;
}

/*-----------------------------------------------------------------------
 * Function:	GlgSetWindow
 * Description:	set the window coordinate system for the gadget window
 * Args  IN:	XMIN, XMAX, YMIN, YMAX: the new coordinate system.
 * Returns:	nothing
 * Author:	mbp
 * Date:	Sun Jun  3 15:47:42 1990
 * Notes:	The gadget window viewing matrix should be specified
 *		with ortho2.  The values passed to this procedure
 *		should be the same as the ones used in the ortho2 call.
 */
int
  GlgSetWindow(XMIN, XMAX, YMIN, YMAX)
double XMIN, XMAX, YMIN, YMAX;
{
  GlgXMIN = XMIN;
  GlgXMAX = XMAX;
  GlgYMIN = YMIN;
  GlgYMAX = YMAX;
}

int
  GlgGetMouseXY(x,y)
double *x,*y;
{
  *x = GlgXMIN + GLGWXLEN(getvaluator(MOUSEX) - GlgXorg);
  *y = GlgYMIN + GLGWYLEN(getvaluator(MOUSEY) - GlgYorg);
}

/*-----------------------------------------------------------------------
 * Function:	GlgWriteString
 * Description:	write a string in the window
 * Args  IN:	str: the string to write
 *		x,y: the position (world coords) to write the string in
 *		hpos, vpos: 0, 1, 2 for left/bottom, center,
 *		  top/right adjust 
 *		doback: whether to clear out background before writing
 *		  string
 *		bgnd: background color
 *		txtcol: text color
 * Returns:	nothing
 * Author:	slevy
 * Date:	Sun Jun  3 16:06:35 1990
 */
int
  GlgWriteString(str, x, y, hpos, vpos, doback, bgnd, txtcol)
char *str;
double x, y;
int hpos, vpos;
int doback;
Colorindex bgnd, txtcol;
{
  double dx, dy;
  
  dy = GLGWXLEN(getheight());
  dx = GLGWXLEN(strwidth(str));
  x -= dx*.5*hpos;
  y -= dy*.5*vpos;
  if (doback) {
    color(bgnd);
    rectf(x, y, x+dx, y+dy);
  }
  color(txtcol);
  cmov2(x, y);
  charstr(str);
}

int
  GlgReadEvent(event)
GlgEvent *event;
{
  event->dev = qread(&(event->val));
  GlgGetMouseXY(&(event->x), &(event->y));
}
