Needs["Demo`"]

Print[""]
Print["This is a Mathematica demonstration package.  It will display"]
Print["explanatory text, such as this paragraph, and regular Mathematica"]
Print["input and output, such as the following trivial example:"]

Demo["2 + 2"]

Print[""]
Print["It will pause at various times to give you a chance to read what it"]
Print["has displayed."]

Pause[]

Print[""]
Print["Geometry, according to Felix Klein, is the study of the properties of"]
Print["a space which are invariant under a group of transformations.  A"]
Print["useful method of developing intuition and testing out conjectures in a"]
Print["geometry is to visualize objects in the space and to see how they"]
Print["transform under the action of the group.  This is often helpful in"]
Print["developing a feel for what the invariants of the geometry might be."]
Print[""]
Print["Fast interactive graphics combined with Mathematica allows us to do"]
Print["this with new and exotic geometries in a way never before possible."]
Print[""]
Print["Heisenberg is an interactive environment for exploring 'Heisenberg"]
Print["geometry'.  The space of this geometry is 3-space (the boundary of the"]
Print["complex hyperbolic plane, minus one point), and the group of"]
Print["transformations is PU(2,1) (the projective unitary group of index"]
Print["(2,1)).  It is called Heisenberg geometry because the analog of the"]
Print["group of translations in this geometry is the Heisenberg group."]

Pause[]

Print[""]
Print["Heisenberg consists of two parts: a Mathematica package which allows"]
Print["you to define objects in 'Heisenberg space' and to act on them by"]
Print["elements of PU(2,1), and a graphics program for displaying the"]
Print["objects."]
Print[""]
Print["This demonstration will lead you through a few basic examples of how"]
Print["to use Heisenberg."]
Print[""]
Print["Before continuing, you must execute the 'startheis' shell script on"]
Print["the graphics machine as described in the INSTRUCTIONS file.  If you"]
Print["have not done this yet, do so now."]

Pause["Hit <return> after you have executed 'startheis' ..."]

Print[""]
Print["Loading various packages; please be patient ..."]

Needs["Heisenberg`"]

Print["Done."]

HConnect[]

Print[""]
Print["The connection should now be established, and the Heisenberg graphics"]
Print["window should appear on the screen.  If did not, and does not appear"]
Print["within a few seconds, you should abort Mathematica (with control-C;"]
Print["get all the way out of Mathematica) and try everything from the"]
Print["beginning."]
Print[""]
Print["The graphics window probably fills up most of the screen; you may want"]
Print["to resize and/or reposition the Mathematica window so that you can see"]
Print["as much as possible of both windows.  You should not try to resize the"]
Print["graphics window, but you may reposition it if you like."]

Pause[]

Print[""]
Print["Heisenberg space is 3-dimensional.  To give the picture some appearance"]
Print["of depth, we can draw a 'grid' which consists of the x-y plane and the"]
Print["vertical ('v') axis."]
Print[""]

Demo["HDraw[Grid]"]

Print[""]
Print["You can use the control panel on the right-hand side of the graphics"]
Print["window to look at the picture from different viewpoints.  To do this,"]
Print["point at the control buttons with the mouse and click the left mouse"]
Print["button.  Go ahead and try it now."]
Print[""]
Print["You can interact with the graphics window in this way at any time,"]
Print["even while things are being drawn.  If you want more information about"]
Print["how to use the view control panel, click the '?' button in the upper"]
Print["right corner."]

Pause[]

Print[""]
Print["We begin by defining x to be the a point in Heisenberg space with"]
Print["coordinates (1+I, 2) (points in Heisenberg space are defined by a pair"]
Print["of numbers, the first complex and the second real).  Points are stored"]
Print["with head 'Hpoint'."]

Demo["x = Hpoint[ 1 + I, 2 ]"]

Print[""]
Print["The HDraw command then draws x."]

Demo["HDraw[x]"]

Print[""]
Print["You should now see the point x in the graphics window.  Use the view"]
Print["control buttons to turn the picture around and view it from different"]
Print["angles."]

Pause[]

Print[""]
Print["Suppose we want to see how x changes under the action of a"]
Print["translation.  We can define a transformation t (a matrix in SU(2,1))"]
Print["which is translation by Hpoint[I,0], and then create and draw a new"]
Print["point x2 which is the image of x under t."]

Demo["t = HTranslation[ Hpoint[I, 0] ]"]
Demo["x2 = HApply[ t, x ]"]
Demo["HDraw[x2]"]

Print[""]
Print["You should now see a second point in the graphics window."]

Pause[]

Print[""]
Print["To erase an object, we simply refer to it by the name with which it"]
Print["was drawn:"]

Demo["HErase[x2]"]

Print[""]
Print["The second point has now disappeared."]

Pause[]

Print[""]
Print["Now let's look at a more interesting transformation: a commutator"]
Print["of translations."]

Demo["t1 = HTranslation[ Hpoint[1, 0] ]"]
Demo["t2 = HTranslation[ Hpoint[I, 0] ]"]
Demo["t = t1 . t2 . Inverse[t1] . Inverse[t2]"]
Demo["x3 = HApply[ t, x ]"]
Demo["HDraw[x3]"]

Print[""]
Print["The fact that x3 is not the same as x2 illustrates the noncummutativity"]
Print["of the Heisenberg group, which is a very strange aspect of Heisenberg"]
Print["geometry."]

Pause[]

Demo["HErase[x]"]
Demo["HErase[x3]"]

Print[""]
Print["There are two types of curves which have particular significance in"]
Print["Heisenberg geometry.  They correspond to the only two types of totally"]
Print["geodesic subspaces in the complex hyperbolic plane.  The first type,"]
Print["called a 'chain', corresponds to the boundary of a complex geodesic."]
Print["Chains are the objects in Heisenberg space which most closely resemble"]
Print["geodesics (there are no true geodesics, since Heisenberg geometry is not"]
Print["a metric geometry)."]
Print[""]
Print["A chain is represented in Heisenberg with the head 'Chain'; it is"]
Print["determined by a point (the 'center') and a real number (the 'radius')."]
Print["Chains appear as ellipses which project to circles in the x-y plane."]
Print["Here we define and draw a chain c:"]

Demo["c = Chain[ Hpoint[1,1], 1 ]"]
Demo["HDraw[c]"]

Pause[]

Print[""]
Print["The second type of natural curve in Heisenberg space is called an"]
Print["R-circle; it corresponds to the boundary of a totally real subspace."]
Print["An R-circle is represented in Heisenberg with the head 'Rcircle'; it"]
Print["is determined by a point (the 'center') and a complex number (the"]
Print["'complex radius').  R-circles appear as curves which project to"]
Print["lemniscates in the x-y plane."]
Print[""]
Print["Here we define an R-circle r with the same center and radius as our"]
Print["chain above:"]

Demo["r = Rcircle[ Hpoint[1,1], 1 ]"]
Demo["HDraw[r]"]

Pause[]

Print[""]
Print["Another object of fundamental importance in Heisenberg geometry is the"]
Print["'spinal sphere'.  This is the boundary of an equidistant hypersurface"]
Print["in the complex hyperbolic plane (the collection of points equidistant"]
Print["from two given points).  Spinal spheres have many beautiful"]
Print["properties, one of which is that they may be decomposed as either a"]
Print["union of chains or a union of R-circles."]
Print[""]
Print["Here we define and draw a spinal surface s which contains the chain"]
Print["and R-circle which we have already drawn:"]

Demo["s = Spinal[ Hpoint[1, 3/2], Hpoint[1, 1/2] ]"]
Demo["HDraw[s]"]

Print[""]
Print["This spinal surface was drawn with chains, and you can see that"]
Print["the chain c and rcircle r lie on it."]

Pause[]

Print[""]
Print["This is the end of this demo.  You may now interact with Mathematica"]
Print["as usual.  The objects which were defined in the examples above are"]
Print["still defined; you may reference them and/or create and draw others as"]
Print["you wish.  See the file INSTRUCTIONS for more general instructions on"]
Print["using Heisenberg."]
Print[""]
Print["Send comments or questions to"]
Print[""]
Print["                        Mark Phillips"]
Print["                        mbp@lakisis.umd.edu"]
Print[""]
Print["                        Department of Mathematics"]
Print["                        University of Maryland"]
Print["                        College Park, Maryland  20742"]
Print["                        (301) 454-7071"]
