(* $Id: ExternalGraphics.m,v 2.0 89/10/03 21:38:33 mbp Exp $
 *
 *TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH ' *TPL'
 *TPL	
 *TPL	This file is a template to be used in creating the actual .m
 *TPL	file.  The Makefile creates the .m file from this one by
 *TPL	replacing the following strings in this file with actual
 *TPL	values:
 *TPL		MATHPIPEPATH
 *
 * ExternalGraphics.m: meta-language for describing interface to
 *	external graphics program.
 *
 *TPLWARNING
 *)

(***************************************************************************
 *                          Copyright (C) 1990 by                          *
 *        Mark B. Phillips, William M. Goldman, and Robert R. Miner        *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both that *
 *      copyright notice and this permission notice appear in supporting   *
 *      documentation, and that the names of Mark B.  Phillips, William M. *
 *      Goldman, Robert R.  Miner, or the University of Maryland not be    *
 *      used in advertising or publicity pertaining to distribution of the *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the authors Mark B. Phillips,  *
 *      William M. Goldman, and Robert R. Miner in any publication which   *
 *      uses part or all of any image produced by this software.           *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************)

BeginPackage["ExternalGraphics`", "GraphicsNames`", "MathPipe`"]

gSetErrorFlag::usage = "gSetErrorFlag[s] sets the error string to s."

gDeclareDrawOptions::usage = "usage message not yet written"

gDeclarePrimitive::usage = "gDeclarePrimitive[form, command] declares
a new graphics primitive.  form is a pattern which gives the format of
the primitive, and command should be an expression for converting a
pattern which matches form to a draw command (a string) for the
external graphics program."

gN::usage = "gN[x] gives a string representation of the numeric value
of x in a form which can be interpreted by the external graphics
program.  gN can be used in constructing the 'command' argument to
gDeclarePrimitive."

gSetEraseCommand::usage = "gSetEraseCommand[s] sets the erase prefix to
the string s."

gSetHideCommand::usage = "gSetHideCommand[s] sets the hide prefix to
the string s."

gSetUnhideCommand::usage = "gSetUnhideCommand[s] sets the unhide prefix to
the string s."

gSetClearCommand::usage = "gSetClearCommand[s] sets the clear command
to the string s."

gConnect::usage = "gConnect[gPath->path] establishes a connection with
the external graphics program whose pathname is path.  gConnect[] uses
an internally stored pathname."

gPath::usage = "gPath is an option to gConnect that gives the pathname
of the external graphics program."

gTest::usage = "gTest[] is like gConnect except that no connection is
established, and later commands that would be sent to the graphics
program are instead printed out.  It is for debugging."

gDisconnect::usage = "gDisconnect[] terminates a connection with the
external graphics program."

gDraw::usage = "gDraw[x] draws the graphics primitive x.  x may be
either a graphics primitive or a variable whose value is a primitive;
if it is a variable, that variable's name is associated with the new
graphics object. gDraw[x = p] is also allowed; it is eqivalent to x =
p; gDraw[x]."

gErase::usage = "gErase has not been defined for this package";

gHide::usage = "ghide has not been defined for this package";

gUnhide::usage = "gUnhide has not been defined for this package";

gClear::usage = "gClear has not been defined for this package."

(*----------------------------------------------------------------------*)

Begin["`Private`"]

gGeneral::exerror = "Error in external graphics program."

ErrorFlag = "-1"

gSetErrorFlag[s_String] := ErrorFlag = s

gConnected = False

Options[gConnect] ^= {gPath->"MATHPIPEPATH"}

gConnect[opts___] :=
  ( StartPipe[ RunningMathPipePath = (gPath /. {opts} /. Options[gConnect]) ];
    gConnected = True; Null ) /; Not[gConnected]

gConnect::already = "Already connected."

gConnect[] :=
  Message[gConnect::already] /; gConnected

gDisconnect[] :=
  ( MathPipe["q"]; EndPipe[RunningMathPipePath]; 
    RunningMathPipePath =. ; gConnected = False ; Null ) /; gConnected

gDisconnect[] :=
  Message[gDisconnect::notnow] /; Not[gConnected]

gTest[] := StartPipeTest[]

SetAttributes[gDeclareDrawOptions, HoldAll]

gDeclareDrawOptions::arg = "argument is not a list of option settings"

gDeclareDrawOptions[plist_List] :=
  Block[{},
    (* Check form of plist *)
    If[!DrawOptionSettingListQ[plist],
	Message[gDeclareDrawOptions::arg]; Return[Null]];

    (* Set the parameter commands *)
    Map[SetParameterCommandFunction, plist];

    (* Set options to gDraw *)
    Options[gDraw] ^= Map[#[[1]]&, plist];

    Return[Null]
    ]

DrawOptionSettingListQ[plist_List] :=
  TrueQ[Apply[And, Map[DrawOptionSettingQ, plist]]]

DrawOptionSettingQ[s_List] := (Length[s] === 2) && (Head[s[[1]]]===Rule)

SetParameterCommandFunction[{option_->value_, function_}] :=
  DrawParameterCommandFunction[option] := function
    
SetAttributes[gDeclarePrimitive, HoldRest]

gDeclarePrimitive[form_, command_] := (
  DrawCommand[form] := command;
  PrimitiveQ[form] = True;
  Null )

SetAttributes[gDraw, {HoldAll,Listable}]

gDraw::badobj = "Unknown object type --- don't know how to draw it"

SetAttributes[NotRuleQ, HoldAll]
NotRuleQ[x_] := Not[TrueQ[Head[x] == Rule]]

gDraw[HoldForm[x_], opts___Rule] := gDraw[x, opts]

gDraw[Literal[Set[lhs_, rhs_]], opts___Rule] :=
   (Set[lhs, rhs]; gDraw[lhs, opts])

gDraw[x_?PrimitiveQ, opts___Rule] := (gDrawAndReturnName[x,opts]; Null)

gDraw[x_?NotRuleQ, y__?NotRuleQ, opts___Rule] :=
  (gDraw[{x,y}, opts]; Null)

gDraw[x_?NotRuleQ, opts___Rule] :=
  Block[{name},
    ( If[!PrimitiveQ[Release[x]], (Message[gDraw::badobj]; Return[Null])];
      name = gDrawAndReturnName[x, opts];
      If[name=!=ErrorFlag, SetGraphicsName[x, name]];
      Return[Null]; )
  ]

gDrawAndReturnName[x_, opts___Rule] :=
  Block[{name},
    ( Map[ MaybeSetParameter[#, #/.{opts}/.Options[gDraw]]&, 
           Map[#[[1]]&, Options[gDraw]] ];
      name = MathPipe[DrawCommand[x]];
      If[name===ErrorFlag, (Message[gGeneral::exerror]; Return[Null])];
      Return[name]; )
  ]

MaybeSetParameter::usage = "MaybeSetParameter[p,v] sends the value v
of parameter p to the Heisenberg graphics server, if v is different
from the last value of p which was sent."
MaybeSetParameter[p_, v_] :=
  If[ LastValueSent[p] === v, v, LastValueSent[p] = SetParameter[p,v] ]

(* SetParameter *)
SetParameter::usage = "SetParameter[p,v] sends the value v of parameter
p to the Heisenberg graphics server.  It returns the value v if the
setting was successful, or Null if not."
SetParameter::badparam = "Bad parameter specification."
SetParameter[param_, value_] :=
  Block[{cmd},
     If[!ValueQ[DrawParameterCommandFunction[param][value]],
	 Message[Parameter::badparam]; Return[Null]];
     If[MathPipe[DrawParameterCommandFunction[param][value]] === Error,
	 Message[HGeneral::exerror]; Return[Null] ];
     Return[value];
  ]

SetAttributes[PrimitiveQ, HoldAll]

PrimitiveQ[_] = False

SetAttributes[DrawCommand, HoldAll]

DrawCommand[_] := Null

(* ErasePrefix is the prefix string used to construct an erase command *)
ErasePrefix = Null

(* HidePrefix is the prefix string used to construct a hide command *)
HidePrefix = Null

(* UnhidePrefix is the prefix string used to construct an unhide command *)
UnhidePrefix = Null

SetAttributes[gErase, {HoldAll, Listable}];

gSetEraseCommand[s_String] := (
  ErasePrefix = s;			      
  gErase::usage = "gErase[x, ...] erases objects which have been drawn
with gDraw.  The arguments must be symbolic expressions whose values
are the drawn objects.]";
  gErase::nosuchobj = "No such object --- can't erase it";
  gErase[x_,y__] := (gErase[{x,y}]; Null);
  gErase[HoldForm[x_]] := gErase[x];
  gErase[x_] :=
    Block[{},
      ( If[!GraphicsNamedQ[x], (Message[gErase::nosuchobj]; Return[Null])];
        If[MathPipe[StringJoin[ErasePrefix, " ", GraphicsName[x]]]===ErrorFlag,
  	    (Message[gGeneral::exerror]; Return[Null])];
        UnsetGraphicsName[x];
        Return[Null]; )
    ];
  s )

SetAttributes[gHide, {HoldAll, Listable}];

gSetHideCommand[s_String] := (
  HidePrefix = s;			      
  gHide::usage = "gHide[x, ...] temporarily hides objects which have been
drawn with gDraw.  The arguments must be symbolic expressions whose values
are the drawn objects.]";
  gHide::nosuchobj = "No such object --- can't Hide it";
  gHide[x_,y__] := (gHide[{x,y}]; Null);
  gHide[HoldForm[x_]] := gHide[x];
  gHide[x_] :=
    Block[{},
      ( If[!GraphicsNamedQ[x], (Message[gHide::nosuchobj]; Return[Null])];
        If[MathPipe[StringJoin[HidePrefix, " ", GraphicsName[x]]]===ErrorFlag,
  	    (Message[gGeneral::exerror]; Return[Null])];
        Return[Null]; )
    ];
  s )

SetAttributes[gUnhide, {HoldAll, Listable}];

gSetUnhideCommand[s_String] := (
  UnhidePrefix = s;			      
  gUnhide::usage = "gUnhide[x, ...] unhides objects which have been
made temporarily hidden with gHide.]";
  gUnhide::nosuchobj = "No such object --- can't Unhide it";
  gUnhide[x_,y__] := (gUnhide[{x,y}]; Null);
  gUnhide[HoldForm[x_]] := gUnhide[x];
  gUnhide[x_] :=
    Block[{},
      ( If[!GraphicsNamedQ[x], (Message[gUnhide::nosuchobj]; Return[Null])];
        If[MathPipe[StringJoin[UnhidePrefix, " ", GraphicsName[x]]]===ErrorFlag,
  	    (Message[gGeneral::exerror]; Return[Null])];
        Return[Null]; )
    ];
  s )

ClearCommand::usage = "ClearCommand is the string to send to the graphics
program to cause it to clear the canvas."

gSetClearCommand[s_String] := (
  ClearCommand = s;
  gClear::usage = "gClear[] clears the graphics canvas.";
  gClear[] := (
    If[MathPipe[ClearCommand]===ErrorFlag, Message[gGeneral::exerror]];
    ClearGraphicsNames[];
    Null );
  s )

gN::notnumber = "argument `x` does not evaluate to a number."

gN[x_] :=
  Block[{val=N[x]},
    ( If[!NumberQ[val], Message[gN::notnumber, x]; Return[""]];
      Return[ToString[CForm[val]]] )
    ]

End[]

EndPackage[]

Null
