
/*
  $Header: /usr2/meuer/Geom_utilities/Matrix_util/RCS/matrix.h,v 1.4 91/02/19 16:56:19 meuer Exp Locker: meuer $

  Header file for all the matrix manipulation routines.


  Mark Meuer
  #1267045

  */

#ifndef	_MATRIX.H_
#define	_MATRIX.H_

/* We need some of the definitions in stdio.h */
#include	<stdio.h>
#include	<math.h>

/* MACROS */
/* Return the maximun of two nUmbers */
#define	MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define	MIN(a,b)	(((a) < (b)) ? (a) : (b))

/* Constants */
#define	DEBUG_STRING_LENGTH	300
#define	DEBUG_FILE	"matrix.debug"
#define	DELIMITERS	" 	,"
#define	ERROR_STRING_LENGTH	200
#ifndef	FALSE
#define	FALSE		0
#endif
#define	LINE_LENGTH	(8 * ARG_LENGTH)	/* Max length of a line read in */
#define	MATRIX_SIZE	4
#define	MAX_ARGS	12
#define	MAX_COMMANDS	50
#define	NORMAL_MULTIPLE	255
#define	PI		3.1415927
#define	POINT_SIZE	4
#define	SCREEN_POINT_SIZE 3
#define	VECTOR_SIZE	3
#ifndef	TRUE
#define	TRUE		1
#endif

/* Values used when describing rendering and projection types */
#define	PERSPECTIVE	1
#define	ORTHOGONAL	0
#define	WIRE_FRAME	0
#define	GORAUD		1
#define	PHONG		2


/*
 * Matricies and points and stuff like that
 */

typedef double PointElement;
typedef PointElement Point[POINT_SIZE];
typedef PointElement Matrix[MATRIX_SIZE][MATRIX_SIZE];
typedef double Angle;
typedef Point Vector;
typedef unsigned short int Color;

typedef int     ScreenPointElement;
typedef ScreenPointElement ScreenPoint[SCREEN_POINT_SIZE];


/* FUNCTION PROTOTYPES */
/*
  These macros are a hack to get rid of prototype arguments for compilers (like the SUN's)
  that won't allow them.
*/
#ifdef	sun
#define	ARGSLIST(x)	()
#else
#define	ARGSLIST(x)	x
#endif


void	add_vectors ARGSLIST( (Vector result, Vector vect1, Vector vect2) );
Angle	angle_from_y ARGSLIST( (Vector vector) );
void	angles_from_z ARGSLIST( (Vector vector, Angle *user_theta, Angle *user_phi) );
void	copy_matrix ARGSLIST( (Matrix destination, Matrix source) );
void	copy_vector ARGSLIST( (Vector destination, Vector source) );
void	cross_product ARGSLIST( (Vector result, Vector a, Vector b) );
void	debug ARGSLIST( (char *message) );
FILE	*debug_stream ARGSLIST( (void) );
void	debug_vector ARGSLIST( (char message[], Vector vector) );
void	debug_matrix ARGSLIST( (char message[], Matrix matrix) );
void	debug_point ARGSLIST( (char message[], Point point) );
void	debug_screen_point ARGSLIST( (char message[], ScreenPoint point) );
PointElement	dot_product ARGSLIST( (Vector vect1, Vector vect2) );
void	fatal_error ARGSLIST( (char *message) );
void	general_rotation_matrix ARGSLIST( (Matrix result_matrix, Vector user_vector, Point vector_point, Angle user_angle) );
void	identity_matrix ARGSLIST( (Matrix matrix) );
void	matrix_multiply ARGSLIST( (Matrix first_matrix, Matrix second_matrix, Matrix result_matrix) );
void	matrix_print ARGSLIST( (FILE *stream, Matrix matrix) );
void	mult_vector_by_scaler ARGSLIST( (Vector result, Vector vector, PointElement scaler) );
void	nonfatal_error ARGSLIST( (char *message) );     
void	normalize_vector ARGSLIST( (Vector vector) );
FILE	*open_file ARGSLIST( (char name[], char permissions[]) );
void	print_vector ARGSLIST( (FILE *stream, char label[], Vector) );
void	scale_matrix ARGSLIST( (Matrix new_matrix, PointElement sx, PointElement sy, PointElement sz) );
void	shear_matrix ARGSLIST( (Matrix shear_matrix, Point prp, Point center) );
void	translate_and_scale_matrix ARGSLIST( (Matrix new_matrix, PointElement tx, PointElement ty, PointElement tz, PointElement sx, PointElement sy, PointElement sz) );
void	transform_point ARGSLIST( (Matrix xform_matrix, Point in_point, Point out_point) );
void	transform_vector ARGSLIST( (Matrix xform_matrix, Vector in_vector, Vector out_vector) );
void	translation_matrix ARGSLIST( (Matrix trans_matrix, PointElement x, PointElement y, PointElement z) );
void	transpose_matrix ARGSLIST( (Matrix result, Matrix source) );
PointElement	vector_norm ARGSLIST( (Vector vector) );
void	x_rotation_matrix ARGSLIST( (Matrix x_matrix, Angle theta) );
void	y_rotation_matrix ARGSLIST( (Matrix y_matrix, Angle theta) );
void	z_rotation_matrix ARGSLIST( (Matrix z_matrix, Angle theta) );
     
     
#endif	/* _MATRIX.H_ */
