/******************************************************************
*
*  file: alice.c
*
*  purpose: Do tests of smoothed curvature for Alice Underwood
*
*/

#include "include.h"

double xalice[MAXCOORD];  /* center of test bump */
double valice[MAXCOORD] = { 0.0, 0.0, 1.0 };  /* vector of test bump */
double radius;            /* characteristic scale of bump */

double calc_bump(pt)
REAL *pt;  /* coordinates */
{
  double xx[MAXCOORD];
  int i;
  double value;
  double r;

  for ( i = 0 ; i < web.sdim ; i++ )
    xx[i] = pt[i] - xalice[i];

  /* function is fourth-order bump */
  r = dot(xx,xx,web.sdim)/radius/radius;
  value = 1/(1+r)/(1+r);

  return value;
}

void alice()
{
  edge_id f_id;
  double sum=0.0;
  char p[90];

  sprintf(p,"Enter center of test function (%f %f %f): ",
     xalice[0],xalice[1],xalice[2]);
  prompt(p,msg);
  sscanf(msg,"%lf %lf %lf %lf %lf%",
    xalice,xalice+1,xalice+2,xalice+3,xalice+4);

  sprintf(p,"Enter vector of test function (%f %f %f): ",
     valice[0],valice[1],valice[2]);
  prompt(p,msg);
  sscanf(msg,"%lf %lf %lf %lf %lf%",
    valice,valice+1,valice+2,valice+3,valice+4);

  sprintf(p,"Enter characteristic size of test function (%f): ",radius);
  prompt(p,msg);
  sscanf(msg,"%lf", &radius);

  /* integrate over every edge */
  FOR_ALL_FACETS(f_id)
    {
      REAL midpt[MAXCOORD];
      double norm[FACET_EDGES][MAXCOORD];
      double *x[FACET_EDGES+1];
      edge_id e_id[FACET_EDGES];
      double a,b,s0s0,s0s1,s1s1,surd;
      int  i,j,m;
      facetedge_id fe_id;
      double side[FACET_EDGES][MAXCOORD];
      double len[FACET_EDGES];

      /* get sides */
      generate_facet_fe_init();
      for ( i = 0 ; i < FACET_EDGES ; i++ )
        { 
          generate_facet_fe(f_id,&fe_id);
          e_id[i] = get_fe_edge(fe_id);
          get_edge_side(e_id[i],side[i]);
          x[i] = get_coord(get_edge_headv(e_id[i]));
        }
      x[FACET_EDGES] = x[0]; /* easy wrap */

      s0s0 = dot(side[0],side[0],web.sdim);
      s0s1 = dot(side[1],side[0],web.sdim);
      s1s1 = dot(side[1],side[1],web.sdim);
      len[0] = sqrt(s0s0);
      len[1] = sqrt(s1s1);
      len[2] = sqrt(s0s0 + s1s1 + 2*s0s1);
      surd = sqrt(s0s0*s1s1 - s0s1*s0s1);
      a = s0s0/surd; b = s0s1/surd;
      for ( i = 0 ; i < web.sdim ; i++ )
	{ norm[0][i] = -a*side[1][i] + b*side[0][i];
	  norm[2][i] =  a*side[1][i] - b*side[0][i];
	}
      a = s1s1/surd; b = s0s1/surd;
      for ( i = 0 ; i < web.sdim ; i++ )
	{ norm[1][i] =  a*side[0][i] - b*side[1][i];
	  norm[2][i] += -a*side[0][i] + b*side[1][i];
	}
      /* along each edge */
      for ( j = 0 ; j < FACET_EDGES ; j++ )
        { 
	  if ( get_eattr(e_id[j]) & (FIXED|CONSTRAINT|BOUNDARY) ) 
	    continue;
          for ( m = 0 ; m < web.gauss1D_order ; m++ )
           {
             for ( i = 0 ; i < web.sdim ; i++ )
               midpt[i] = gauss1Dpt[m]*x[j][i] + (1 - gauss1Dpt[m])*x[j+1][i];
	     sum += gauss1Dwt[m]*dot(valice,norm[j],web.sdim)
		     *calc_bump(midpt)*len[j];
           }
	}
    }

  fprintf(outfd,"Variation: %f\n",sum/radius/radius);
}


