/* isom.d/src file foxreg.c */
#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
#define ORDRELSOP "ordrels"
#define tmalloc(D,T,N) {D = (T *) malloc(sizeof(T)*(N)); \
  if (D==0) { fprintf(stderr,"Out of space.\n"); exit(2);}}
#define tfree(D) {if (D) free( (char *) D); D=0;}
#define MAXSHORT  65536
unsigned short npt,nperms,rank,nrels,rellen,relpow,soldim,
    **perm,**perminv,**permparprod,*permprod,**ptr,*vec,
     prime=0,**add,**mult,*pinv,**sol,*primepow;
int *reln,nelim,nptprod,veclen,*vecpos,**iptr,*ivec,opdeg;
/* 1000 is maximal order of an orbit */
unsigned short orbit[1001];
char *hadpt,opsol=0,elim,intstore;
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens;
extern int gen_array_size;
word rel;
word baseword;
list rels;
int num_rels = 0;
int paired_gens = 0;
int * pairnumber = 0;


char *malloc();
FILE *fopen(),*ip,*op;
char inf1[100],inf2[100],outf1[100],outf2[100];
int triv_rep = 0;

main(argc,argv) int argc; char *argv[];
{ int arg,i;
  char err;

  err=0;  arg=1;
  if (argc<=arg) {err=1; goto error;}
  while (argv[arg][0]=='-')
  { if (argv[arg][1]=='s')
    opsol=1; 
  else if (argv[arg][1]=='p')
  {char * cp; int p=0; arg++; if (arg>=argc)
              { err=1; goto error; }
  cp = argv[arg];
    while (*cp!='\0')
    { if (isdigit(*cp)==0) { err=1; goto error; }
    p=10*p+(*cp-'0');
    cp++;
    }
  prime = (unsigned short)p;}
  else {err=1; goto error;}
    arg++;
    if (argc<=arg) {err=1; goto error;}
  }
  strcpy(inf1,argv[arg]); strcat(inf1,".");
  strcpy(inf2,inf1); strcpy(outf1,inf1); strcpy(outf2,inf1);
  strcat(outf1,"foxreg");
  arg++; if (argc<=arg) strcat(inf1,"ip"); 
       else if (strcmp(argv[arg],"-t")==0) triv_rep = 1;
         else strcat(inf1,argv[arg]);
  strcat(inf2,ORDRELSOP);
  if (opsol)
  {arg++; if (argc<=arg) strcat(outf2,"op"); else strcat(outf2,argv[arg]);}




  fox();
error:
  if (err)
  { fprintf(stderr,"Usage:    foxreg [-p prime] [-s] gpname [inf1] [outf2]\n");
    exit(2);
  }
  else exit(0);
}

fox()
{ unsigned short  h,i,j,k,l,m,n,o,r,*p,solct,im,ngens,vp;
  int x,y,rk;
  char *label;
  gen gg,hh;

/* Chunk of old "powrels" stuff follows */
  if ((ip=fopen(inf2,"r"))==0)
  { fprintf(stderr,"Cannot open %s.\n",inf2); exit(2); }
  word_init(&rel);
  word_init(&baseword);
  list_init(&rels,WORD,ORDERED);
  label = vzalloc2(char,9);

  while (read_next_string(label,8,ip)){
    if (strcmp(label,"Format  ")==0)
                format_check("2.2",ip);
    else if (strcmp(label,"words   ")==0 || strcmp(label,"gens    ")==0)
      /* The order of the generators in the group is being specified */
      read_gen_name_array(ip);
    else if (strcmp(label,"inverses")==0){
        read_inverse_array(ip);
    }
    else if (strcmp(label,"rels    ")==0){
      if (inv_of==0)
        default_inverse_array();
      while (getc(ip)!='\{')
        ;
          while (read_next_rel(&rel,ip)){
        if (word_length(&rel)>2 || (word_length(&rel)==2 &&
        word_get_last(&rel,&gg)&&word_get_first(&rel,&hh)&&gg!=hh))
            word_creduce(&rel,&rel);
                else if (gg==hh){ /* gg is an involution */
/* if the inverse table doesn't already record g as an involution, we need
to change it. The lower numbered of the two generators gg and inv(gg) should
appear as the inverse of both in the inverse table. The higher numbered
generator then becomes redundant, but we won't delete it, because that would
mean rewriting all our relators. */
                        if (gg<inv_of[gg]) {
                                inv_of[gg] = gg;
                        }
                        else if (gg>inv_of[gg])
                                inv_of[inv_of[gg]] = inv_of[gg];
                }
        if (word_length(&rel)!=0){
          list_insert(&rels,&rel);
          num_rels++;
        }
        word_reset(&rel);
      }
      while (getc(ip)!='\}')
        ;
    }
  }
  fclose(ip);

  for (i=1;i<=num_gens;i++){
    if (inv(i)==i){
      word_put_last(&rel,i);
      word_put_last(&rel,i);
      if (list_insert(&rels,(dp)&rel))
        num_rels++;
      word_reset(&rel);
    }
  }
  Free_dp((dp)label); label = 0;
  pairnumber=vzalloc2(int,num_gens+1);
  for (i=1;i<=num_gens;i++){
    if (inv(i)<=i){
      paired_gens++;
      pairnumber[i]=pairnumber[inv(i)]=paired_gens;
    }
  }

  if ((ip=fopen(inf1,"r"))==0)
/* If input permutation file does not exist, we use trivial
  permutation representation. */
  { triv_rep =1;
    npt=1; nperms=paired_gens;
  }
  else
  { fscanf(ip,"%hd%hd%hd%hd",&npt,&nperms,&j,&k); seeknln();
    if (j!=0) seeknln(); if (k!=0) seeknln();
    if (paired_gens!=nperms)
    { fprintf(stderr,"Number of generators in input files do not agree.\n");
      exit(2);
    }
  }
  veclen=nptprod=nperms*npt;
  tmalloc(perm,unsigned short *,nperms+1);
  tmalloc(perminv,unsigned short *,nperms+1);
  tmalloc(permprod,unsigned short,npt+1);
  tmalloc(vecpos,int,nptprod+1);
  tmalloc(hadpt,char,npt+1);
  for (i=1;i<=nperms;i++)
  { tmalloc(perm[i],unsigned short,npt+1);
    if (ip)
    {for (j=1;j<=npt;j++) fscanf(ip,"%hd",perm[i]+j); seeknln();}
    else perm[i][1]=1;
    if (order(perm[i])<=2) perminv[i]=perm[i];
    else
    { tmalloc(perminv[i],unsigned short,npt+1);
      for (j=1;j<=npt;j++) perminv[i][perm[i][j]]=j;
    }
  }
  fclose(ip);

/* Set up prime addition and multiplication table */
  primetable();

  intstore= nptprod>=MAXSHORT;
  if (intstore)
  { tmalloc(iptr,int *,nptprod+1);
    for (x=1;x<=nptprod;x++) iptr[x]=0;
  }
  else
  { tmalloc(ptr,unsigned short *,nptprod+1);
    for (x=1;x<=nptprod;x++) ptr[x]=0;
  }
  rank=0;
  for (i=1;i<=npt;i++)
  { if (intstore)
    { tmalloc(ivec,int,nptprod+1); for (x=0;x<=nptprod;x++) ivec[x]=0;}
    else
    { tmalloc(vec,unsigned short,nptprod+1); for (x=0;x<=nptprod;x++) vec[x]=0;}
    if (intstore)
    { for (j=1;j<=nperms;j++) if (perm[j][i]!=i)
      { x=(j-1)*npt+i; tt(x); ivec[x]=1; x=(j-1)*npt+perm[j][i];
        tt(x); ivec[x]= prime-1;
      }
    }
    else for (j=1;j<=nperms;j++) if (perm[j][i]!=i)
    { x=(j-1)*npt+i; tt(x); vec[x]=1; x=(j-1)*npt+perm[j][i];
      tt(x); vec[x]= prime-1;
    }
    reducevec();
  }
  fflush(stdout);
  veclen=0;
  if (intstore)
  { for (x=1;x<=nptprod;x++) if (iptr[x])
    { vecpos[x]= 0; tfree(iptr[x]); iptr[x]=0;}
    else vecpos[x]= ++veclen;
  }
  else for (x=1;x<=nptprod;x++) if (ptr[x])
  { vecpos[x]= 0; tfree(ptr[x]); ptr[x]=0;}
  else vecpos[x]= ++veclen;
  if (intstore && veclen<MAXSHORT)
  { tfree(iptr);
    tmalloc(ptr,unsigned short *,nptprod+1);
    intstore=0;
  }


  rank=0;
  elim=1; nelim=0;


/* Read next relation and check its validity */
  while (list_delget_first(&rels, (dp)&rel)){
    int length = word_length(&rel);
    int baselength =0;
    int exponent;
    word power;
        if (length==0)
                continue;
    word_init(&power);
    baselength = 0;
    while (baselength <= length){
     word_traverser wt;
      int count = 0;
      word_traverser_init(&wt,&rel);
      while (word_next(&wt,&gg)){
        count++;
        if (count<=baselength)
          continue;
        word_put_last(&baseword,gg);
        baselength++;
        if (baselength>length/2 ||length%baselength==0)
          break;
      }
      word_traverser_clear(&wt);
      if (baselength > length/2){
        baselength = length;
        exponent = 1;
        break;
      }
      else {
        exponent = length/baselength;
        for (i=1;i<=exponent;i++)
          word_append(&power,&baseword);
        if (word_sgn(&rel,&power)==0)
          break;
      }
      word_reset(&power);
    }  
    word_clear(&power);
    if (baselength == length)
      word_cpy(&rel,&baseword);
    rellen=baselength; relpow=exponent;

    tmalloc(reln,int,rellen+1);
    i=0;
    while (word_delget_first(&baseword,&gg)){
        reln[++i]= (gg<=inv(gg)) ? pairnumber[gg] : -pairnumber[gg];
    }     
    word_reset(&baseword);

    for (n=1;n<=npt;n++)
    { m=n;
      for (i=1;i<=rellen;i++) 
             m= reln[i]>0 ? perm[reln[i]][m] : perminv[-reln[i]][m];
      permprod[n]=m;
    }
    if (relpow % order(permprod) != 0)
    { fprintf(stderr,"Relation number %d is not satisfied.\n",r); exit(2);}

/* Now compute the products of the permutations that will be needed to
   compute the Fox derivatives
*/
    tmalloc(permparprod,unsigned short *,rellen+1);
    for (i=1;i<=rellen;i++)
    { tmalloc(permparprod[i],unsigned short,npt+1);
      k= reln[i]>0 ? i+1 : i;
      for (n=1;n<=npt;n++)
      { m=n;
        for (j=rellen;j>=k;j--)
             m= reln[j]>0 ? perminv[reln[j]][m] : perm[-reln[j]][m];
        permparprod[i][n]=m;
      }
    }

/* Now start compute the equations associated with this relation. There is
   one equation for each orbit of permprod.
*/
    for (i=1;i<=npt;i++) hadpt[i]=0;
    for (i=1;i<=npt;i++) if (hadpt[i]==0)
/* i is representative of a new orbit */
    { if (intstore)
      { tmalloc(ivec,int,nptprod+1); for (x=0;x<=nptprod;x++) ivec[x]=0;}
      else
      {tmalloc(vec,unsigned short,nptprod+1);for (x=0;x<=nptprod;x++) vec[x]=0;}
      l=1; j=i; orbit[l]=j;
      while ((k=permprod[j])!=i) {j=k; orbit[++l]=j; hadpt[j]=1;}
      if ((relpow/l)%prime == 0)
      { if (intstore) tfree(ivec) else tfree(vec); continue;}
/* Compute the relation coming from this orbit */
      for (j=1;j<=l;j++) for (k=1;k<=rellen;k++)
      { o=orbit[j]; rk=reln[k];
        if (rk>0)
        { x=npt*(rk-1)+permparprod[k][o];
          y=vecpos[x];
          if (y!=0)
          if (intstore) ivec[y]=add[ivec[y]][1]; else vec[y]=add[vec[y]][1];
        }
        else
        { x=npt*(-rk-1)+permparprod[k][o];
          y=vecpos[x];
          if (y!=0)
          if (intstore) ivec[y]=add[ivec[y]][prime-1];
          else vec[y]=add[vec[y]][prime-1];
        }
      }
      reducevec();
    }
    fflush(stdout);
    for (i=1;i<=rellen;i++) tfree(permparprod[i]);
    tfree(reln); tfree(permparprod);
  } /* End of this relation */
  word_clear(&baseword);
  word_clear(&rel);
  list_clear(&rels);
  Free_dp((dp)pairnumber); pairnumber = 0;
  for (i=0;i<gen_array_size;++i)
    word_clear(user_gen_name+i);
  Free_dp((dp)user_gen_name);
  user_gen_name=0;
  Free_dp((dp)inv_of);
  inv_of=0;
  assert(store_ptrs==0);
    
  soldim=veclen-rank;
  op=fopen(outf1,"w");
  fprintf(op,"Format 2.2\n");
  fprintf(op,"elabinvariants { ");
  for (i=1;i<=soldim;i++)
  fprintf(op,"%d ",(int)prime);
  fprintf(op,"}\n");
  fclose(op);
  opdeg=npt;
  for (i=1;i<=soldim;i++)
  { opdeg *= prime; if (opdeg>=MAXSHORT) break;}
    
  if (opsol==1 && soldim>0 && opdeg<MAXSHORT)
  { 
    tmalloc(primepow,unsigned short,soldim+1);
    primepow[0]=1;
    for (i=1;i<=soldim;i++) primepow[i]=prime*primepow[i-1];
    tmalloc(sol,unsigned short *,soldim+1);
    tmalloc(vec,unsigned short,veclen+1);
    for (i=1;i<=soldim;i++) tmalloc(sol[i],unsigned short,veclen+1);
    for (solct=1;solct<=soldim;solct++)
    { k=0;
      for (x=1;x<=veclen;x++) sol[solct][x]=0;
      for (x=veclen;x>0;x--) if (ptr[x]==0)
      { k++; if (k==solct) {sol[solct][x]=1; break;}}
      y=x-1;
      
      for (x=y;x>0;x--)
      if (ptr[x]==0) sol[solct][x]=0;
      else
      { n=0;
        if (ptr[x][0]==0)
        for (y=veclen;y>x;y--) n=add[n][mult[ptr[x][y]][sol[solct][y]]];
        else
        { for (y=1;y<=veclen;y++) vec[y]=0;
          l=ptr[x][1]; for (k=2;k<=l;k+=2) vec[ptr[x][k]]=ptr[x][k+1];
          for (y=veclen;y>x;y--) n=add[n][mult[vec[y]][sol[solct][y]]];
        }
        if (n!=0) sol[solct][x]=prime-n;
      }
    }

    op=fopen(outf2,"w");
    fprintf(op," %3d %3d %3d %3d\n",opdeg,nperms,0,0);
    for (n=1;n<=nperms;n++)
    { for (k=1;k<=npt;k++)
      { vp=vecpos[npt*(n-1)+perm[n][k]];
        for (l=1;l<=primepow[soldim];l++)
        { im=l;
          if (vp!=0) for (i=1;i<=soldim;i++)
          { m=sol[i][vp]; im=imcalc(im,i,m);}
          im += (perm[n][k]-1)*primepow[soldim];
          fprintf(op," %3d",im);
        }
      }
      fprintf(op,"\n");
    }
  } /*opsol==1 */
  fclose(op);
}
      
imcalc(pt,pow,n) unsigned short pt,pow,n;
{ int i,j;
  for (i=1;i<=n;i++)
  { j = pt % primepow[pow];
    pt = (j==0 || j > primepow[pow]-primepow[pow-1]) ?
          pt - primepow[pow-1]*(prime-1) : pt+primepow[pow-1];
  }
  return(pt);
}

reducevec()
{ unsigned short m,im,*p;
  int x,y,z,l,*ip;
  if (intstore)
  { for (x=1;x<=veclen;x++) if ((m=ivec[x]) != 0)
    { if ((ip=iptr[x])==0) 
      { l=0; im=pinv[m];
        for (y=x;y<=veclen;y++) if (ivec[y])
        { ivec[y]=mult[ivec[y]][im];
          l+=2;
        }
        if (elim)
        if (l==2)
        { for (y=1;y<=nptprod;y++) if (vecpos[y]==x) {vecpos[y]=0; break;}
          for (z=y+1;z<=nptprod;z++) if (vecpos[z]) vecpos[z]--;
          veclen--;
          nelim++;
          tfree(ivec);
          return;
        }
        else elim=0;
        
        if (l<veclen)
        { tmalloc(iptr[x],int,l+2); ip=iptr[x];
          ip[0]=1; ip[1]=l; l=1;
          for (y=x;y<=veclen;y++) if (ivec[y]) {ip[++l]=y; ip[++l]=ivec[y];}
          tfree(ivec);
        }
        else   iptr[x]=ivec;
        rank++;
        return;
      }
      else if (ip[0]==0)
      { for (y=x;y<=veclen;y++)
        if (ip[y]) ivec[y]=add[ivec[y]][prime-mult[m][ip[y]]];
      }
      else
      { l=ip[1];
        if (ip[2]!=x)
        { fprintf(stderr,"Error: pointer %d to false string.\n",x); exit(3);}
        if (l==2) ivec[x]=0;
        else for (y=2;y<=l;y+=2)
              ivec[ip[y]]=add[ivec[ip[y]]][prime-mult[m][ip[y+1]]];
      }
    }
  }
  else
  for (x=1;x<=veclen;x++) if ((m=vec[x]) != 0)
  { if ((p=ptr[x])==0) 
    { l=0; im=pinv[m];
      for (y=x;y<=veclen;y++) if (vec[y])
      { vec[y]=mult[vec[y]][im];
        l+=2;
      }
      if (elim)
      if (l==2)
      { for (y=1;y<=nptprod;y++) if (vecpos[y]==x) {vecpos[y]=0; break;}
        for (z=y+1;z<=nptprod;z++) if (vecpos[z]) vecpos[z]--;
        veclen--;
        nelim++;
        tfree(vec);
        return;
      }
      else elim=0;
      if (l<veclen)
      { tmalloc(ptr[x],unsigned short,l+2); p=ptr[x];
        p[0]=1; p[1]=l; l=1;
        for (y=x;y<=veclen;y++) if (vec[y]) {p[++l]=y; p[++l]=vec[y];}
        tfree(vec);
      }
      else   ptr[x]=vec;
      rank++;
      return;
    }
    else if (p[0]==0)
    { for (y=x;y<=veclen;y++)
      if (p[y]) vec[y]=add[vec[y]][prime-mult[m][p[y]]];
    }
    else
    { l=p[1];
      if (p[2]!=x)
      { fprintf(stderr,"Error: pointer %d to false string.\n",x); exit(3);}
      if (l==2) vec[x]=0;
      else for (y=2;y<=l;y+=2) vec[p[y]]=add[vec[p[y]]][prime-mult[m][p[y+1]]];
    }
  }
  if (intstore) tfree(ivec) else tfree(vec);
  return;
}

primetable()
{ unsigned short i,j;
if (prime==0){ printf("#Input prime:  "); scanf("%hd",&prime);}
  tmalloc(add,unsigned short *,prime); tmalloc(mult,unsigned short *,prime);
  tmalloc(pinv,unsigned short,prime);
  for (i=0;i<prime;i++)
  { tmalloc(add[i],unsigned short,prime);tmalloc(mult[i],unsigned short,prime);}
  pinv[0]=0;
  for (i=0;i<prime;i++) for (j=i;j<prime;j++)
  { add[i][j]=add[j][i]= (i+j)%prime;
    mult[i][j]=mult[j][i]= (i*j)%prime;
    if (mult[i][j]==1) {pinv[i]=j; pinv[j]=i;}
  }
}

order(per) unsigned short *per;
{ unsigned short h,i,j,k,l,order;
  order=1;
  for (i=1;i<=npt;i++) hadpt[i]=0;
  for (i=1;i<=npt;i++) if (hadpt[i]==0)
  { l=1; j=i;
    while ((k=per[j])!=i) {l++; j=k; hadpt[j]=1;}
    h=hcf(order,l);
    order *= (l/h);
  }
  return(order);
}

hcf(a,b) unsigned short a,b;
{  unsigned short c;
   if (b>a) {c=b; b=a; a=c;}
   while (b!=0) {c=a%b; a=b; b=c;}
   return(a);
}

seeknln()
{ char c; while ((c=getc(ip))!='\n'); }

tt(x)
{ if (x>nptprod) {fprintf(stderr,"x=%d\n",x); exit(3);}}
