/* automata.d/src file picture.c */
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "defs.h"
#include "list.h"
#include "input.h"
#include "word.h"
#include "lg.h"
#include "graphics.h"
#include "screengraphics.h"

# define PICTUREOP ".picture"
# define DPICTUREOP ".d.picture"
FILE * rfile=stdin;
FILE * wfile=0;
FILE * keyboard=0;
char windowname[100];
char filename[100];
boolean xwindows=FALSE;

extern word * user_gen_name;
extern int num_gens;
extern int gen_array_size;
int blackscreen=0; /* 0 for whitescreen, 1 for black */

boolean two_var=FALSE;
vindex * vertices=0;;
int * xcoor=0;
int * ycoor=0;
int * cat=0;
double * mu=0;
double * default_lambdas=0;
double ** lambdas=0;
extern int whiteindex;
extern int blackindex;
int rmax = 20000;
int depth=1200;
int boxx1, boxx2, boxy1, boxy2;
int border;
int lprad = 1000;
int ptrad=150;
int charht=400;
int bandwidth=5000;
int pointcolour=GREEN;
int edgecolour=GREEN;
int labelcolour=MAGENTA;
boolean mouse=FALSE;
static void
lg_picture PARMS((lg*, boolean, FILE *,FILE*));
static void 
graph_plan PARMS((lg* lgp));
static void 
graph_plot PARMS((lg* lgp,FILE * file));
static boolean read_redrawing_info PARMS
			((lg * lgp,FILE * file));
static void 
redraw_with_mouse PARMS((lg * lgp));
static int 
nearest_pt PARMS((int N,int x,int y));
static void
find_nearest_label PARMS((int N,int d, int * ip, gen * gp, int x, int y));
static boolean
find_nearest_loop PARMS((int N,int d, int * ip, int x, int y));
static double
nearest_lambda PARMS((int i,gen g,int x,int y));

main(argc,argv)
	int argc;
	char * argv[];
{
	lg * fsa;
	int i;
	char * label;
	boolean del_eos=FALSE;
	boolean interactive=FALSE;
	
	i=1;
    while (i<argc && argv[i][0]=='-'){
		if (strcmp(argv[i],"-i")==0)
			interactive=TRUE;
		else if (strcmp(argv[i],"-d")==0)
			del_eos=TRUE;
		else if (strcmp(argv[i],"-b")==0)
			blackscreen=1;
		else {
			fprintf(stderr,"Usage: picture [-i] [-d] [-b] [filename]\n");
			exit(2);
		}
		i++;
	}
	if (i<argc-1){
		fprintf(stderr,"Usage: picture [-i] [-d] [-b] [filename]\n");
		exit(2);
	}
	else if (i==argc-1){
/* the input and output files are being specified as filename and 
filename.picture or filename.d.picture */
		strcpy(filename,argv[argc -1]);
		strcpy(windowname,filename);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		if (del_eos)
			strcat(filename,DPICTUREOP);
		else
			strcat(filename,PICTUREOP);
		wfile=fopen(filename,"w");
	}

	if (wfile==0)
		wfile=fopen("psfile","w");
	setbuf(wfile,(char*)0);
	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);
	label=vzalloc2(char,9);

	while (read_next_string(label,8,rfile)==TRUE){
		if (strcmp(label,"Format  ")==0)
			format_check("2.2",rfile);
		else if (strcmp(label,"fsa     ")==0)
			fsa=lg_read(GENERIC,BASIC_FSA,rfile);
	}
	if (del_eos){
		if (num_gens==fsa->degree || num_gens*num_gens==fsa->degree)
			fprintf(stderr,"\t# fsa was already no-eos.\n");
		else {
			lg * fsa2=fsa_eosdelete(fsa);
			lg_clear(fsa);
			Free_dp((dp)fsa); fsa=0;
			fsa=fsa2;
		}
	}
	if (interactive) {
		keyboard = fopen("/dev/tty","w");
		fprintf(keyboard,"In interactive mode.\n");
		fprintf(keyboard,"Programme expects parameters input\n");
		fprintf(keyboard,"Terminate parameter set with a closing \}.\n");
		fprintf(keyboard,"parameters {\n");
		rfile=fopen("/dev/tty","r");
	}
	lg_picture(fsa,interactive,rfile,wfile);
	lg_clear(fsa);
	Free_dp((dp)fsa); fsa=0;
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)label); label=0;
	assert(store_ptrs==0);
	exit(0);
}

static void
lg_picture(lgp,interactive,rfile,wfile)
	lg * lgp;
	boolean interactive;
	FILE * rfile;
	FILE * wfile;
{
	int N;
	int i;

	int reply;
	boolean redraw=FALSE;
	boolean save = FALSE;
	assert(lgp != NULL); 
	if (num_gens+1<lgp->degree)
		two_var=TRUE;

	border = rmax/5;
	screengraphics_screen_init
		(blackscreen,-rmax,-depth-border,rmax,rmax);
	N = get_num_verts(lgp);
	vertices = vzalloc2(vindex,N+1);
	xcoor = vzalloc2(int, N + 1);
	ycoor = vzalloc2(int, N + 1);
	cat = vzalloc2(int, N + 1);
	lambdas = vzalloc2(double *,N+1);
	mu = vzalloc2(double,N+1);
	default_lambdas=vzalloc2(double,(lgp->degree)+1);
	graph_plan(lgp);
	do {
		graph_plot(lgp,(FILE *)0);
		if (interactive){
			mouse=FALSE;
			redraw=((screengraphics_screen_reconfigured()==1)||
								read_redrawing_info(lgp,rfile));
			while (mouse==TRUE){
				redraw_with_mouse(lgp);
				redraw=read_redrawing_info(lgp,rfile);
			}
			if (redraw){
				border = rmax/5;
				screengraphics_screen_reset
					(-rmax,-depth-border,rmax,rmax);
			}
		} 
		else if (screengraphics_screen_reconfigured()==1){
			redraw = TRUE;
			border = rmax/5;
			screengraphics_screen_reset(-rmax,-depth-border,rmax,rmax);
		}
		else
			sleep(30);
	} while (redraw == TRUE);
	screengraphics_screen_clear();
	ps_graphics_init(wfile);
	graph_plot(lgp,wfile);
	ps_graphics_clear(wfile);
	fclose(wfile);
	for (i=0;i<=N;i++){
		if (lambdas[i]!=default_lambdas){
			Free_dp((dp)lambdas[i]);
			lambdas[i]=0;
		}
	}
	Free_dp((dp)default_lambdas); default_lambdas=0;
	Free_dp((dp)lambdas);
	lambdas=0;
	Free_dp((dp)mu);
	mu=0;
	Free_dp((dp)xcoor);
	xcoor=0;
	Free_dp((dp)ycoor);
	ycoor=0;
	Free_dp((dp)cat);
	cat=0;
	Free_dp((dp)vertices); vertices=0;
}

static void
graph_plan(lgp)
	lg * lgp;
{
	boolean offscreen=FALSE;
	int i;
	gen g;
	default_lambdas[0]=0.125;
	for (g=1;g<=(lgp->degree);g++)
	default_lambdas[g]=0.15+(double)((KAPPA-0.2)*g)/(double)(lgp->degree);
	for (i=0;i<=get_num_verts(lgp);i++)
		lambdas[i]=default_lambdas;
	do {
		list tobeconnected;
		vindex u;
		int count; 
		double increment=M_PI/(double)(lgp->degree); 
		int rad1 = 0;
		int rad2 = bandwidth;
		double theta = 0.5*increment;
		int k=0;
		lg_erase_indices(lgp);
		list_init(&tobeconnected,VINDEX,FIFO);
		xcoor[0]=0;
		ycoor[0]= -depth; 
		cat[0]=NONACCEPTSTATE;
		vertices[0]=0;
		xcoor[1]=0; 
		ycoor[1]=0;
		u = basept(lgp);
		vertices[1]=u;
		cat[1]=get_category(u);
		count = 1;
		set_index(u,count++);
		list_insert(&tobeconnected,(dp)&u);
		offscreen=FALSE;
		while (list_delget_first(&tobeconnected,(dp)&u)
						&& offscreen==FALSE) {
			int i;
			gen g;
			i = get_index(u);
			if (abs((xcoor[i])*(xcoor[i]) + (ycoor[i])*(ycoor[i]) 
                             -  rad1*rad1) > bandwidth*bandwidth/2) {
			/* we've moved into the next layer and need to reset */
				increment=M_PI/(double)(k*(lgp->degree));
				rad1 = rad2;
				rad2=rad1+bandwidth;
				theta=0.5*increment;
				k=0;
			}
			for(g=1;g<=lgp->degree;g++) {
				vindex t = get(u,g);
				if (t != UNDEFINED) {
					int j;
					if ((j=get_index(t))==0) {
			/* t hasn't been met yet and needs to be plotted */
						j = count++;
						if (rad2>rmax){
							offscreen=TRUE;
							break;
						/* out of the for loop */
						}
						xcoor[j] = rad2*cos(theta);
						ycoor[j] = rad2*sin(theta);
						cat[j]=get_category(t);
						set_index(t,j);
						vertices[j]=t;
						k++;
					list_insert(&tobeconnected,(dp)&t);
					}
				}
			theta = theta + increment; 
			} 
		}
		list_clear(&tobeconnected);
		if (offscreen){
			bandwidth=bandwidth/2;
			fprintf(stdout,"\t# Graph is too big to fit onto screen. Bandwidth has\n");
			fprintf(stdout,"\t# been reduced to %d.\n",bandwidth);
		}
	} while (offscreen);
}		

static void
graph_plot(lgp,file)
	lg * lgp;
	FILE * file;
{
	vindex u;
	int count; 
	list tobeconnected;
	lg_erase_indices(lgp);
	count = 1;
	u = basept(lgp);
	set_index(u,count++);
	list_init(&tobeconnected,VINDEX,FIFO);
	if (file==0){
		screengraphics_rectangle(-rmax,-depth,rmax,rmax,RED);
		if (mouse){
			screengraphics_rectangle(boxx1,boxy1,boxx2,boxy2,RED);
			screengraphics_text((boxx1+boxx2)/2,(boxy1+boxy2)/2,
					"MOUSE EXIT", 1.0,0.0,0.0,1.0,border/5,RED);
		}
	}
/* We draw these now, even though they has to be redrawn later (because they may
have been obscured by the edge of the rectangles pasted around the outside
of the screen) so that they don't keep flashing */
	if (file){
		ps_plot(xcoor[1],ycoor[1],cat[1],1,lambdas[1][0],file);
	ps_join(xcoor[0],ycoor[0],cat[0],xcoor[1],ycoor[1],cat[1],0,0.0,file);
	}
	else {
		screen_plot(xcoor[1],ycoor[1],cat[1],1,lambdas[1][0]);
	screen_join(xcoor[0],ycoor[0],cat[0],xcoor[1],ycoor[1],cat[1],0,0.0);
	}
	list_insert(&tobeconnected,(dp)&u);
	while (list_delget_first(&tobeconnected,(dp)&u)) {
		int i;
		gen g;
		i = get_index(u);
		for(g=1;g<=lgp->degree;g++) {
			vindex t = get(u,g);
			if (t != UNDEFINED) {
				int j;
				j = get_index(t);
				if (j==i){
					if (file)
			ps_loop(xcoor[i],ycoor[i],cat[i],g,lambdas[i][g],mu[i],file);
					else
			screen_loop(xcoor[i],ycoor[i],cat[i],g,lambdas[i][g],mu[i]);
				}
				else {
					if (j==0) {
		/* t hasn't been met yet and needs to be plotted */
						j = count++;
						if (file)
			ps_plot(xcoor[j],ycoor[j],cat[j],j,lambdas[j][0],file);
						else
			screen_plot(xcoor[j],ycoor[j],cat[j],j,lambdas[j][0]);
						set_index(t,j);
					list_insert(&tobeconnected,(dp)&t);
					}
					if (file)
				ps_join(xcoor[i],ycoor[i],cat[i],xcoor[j],
					ycoor[j],cat[j],g,lambdas[i][g],file);
					else
				screen_join(xcoor[i],ycoor[i],cat[i],xcoor[j],
											ycoor[j],cat[j],g,lambdas[i][g]);
				}
			}
		}
	}
	list_clear(&tobeconnected);
/* now frame the active part of the screen, and block out anything that's
outside it */
	if (file==0){
		screengraphics_clear_outside_rectangle(-rmax,-depth,rmax,rmax);
		screengraphics_rectangle(-rmax,-depth,rmax,rmax,RED);
		if (mouse){
			screengraphics_rectangle(boxx1,boxy1,boxx2,boxy2,RED);
			screengraphics_text((boxx1+boxx2)/2,(boxy1+boxy2)/2,
					"MOUSE EXIT", 1.0,0.0,0.0,1.0,border/5,RED);
		}
	}
}		

static boolean
read_redrawing_info(lgp,file)
	lg * lgp;
	FILE * file;
{
	boolean redraw=FALSE;
	char * string;
	boolean reading=TRUE;
	mouse=FALSE;
	string = vzalloc2(char,11);
	while ((reading) && (read_next_string(string,10,file))){
		redraw=TRUE;
		reading=FALSE;
		if (strcmp(string,"help      ")==0){
			fprintf(stdout,"\t#Possible keywords:-\n");
			fprintf(stdout,"\t# pointcolour\n");
			fprintf(stdout,"\t# edgecolour\n");
			fprintf(stdout,"\t# labelcolour\n");
			fprintf(stdout,"\t# screenradius\n");
			fprintf(stdout,"\t# screendepth\n");
			fprintf(stdout,"\t# bandwidth\n");
			fprintf(stdout,"\t# loopradius\n");
			fprintf(stdout,"\t# pointradius\n");
			if (xwindows==FALSE)
			fprintf(stdout,"\t# charheight\n");
			fprintf(stdout,"\t# mouse - to allow repositioning of points and labels\n");
			fprintf(stdout,"\t\t# with the mouse\n");
			fprintf(stdout,"\t# write - to write to a named psfile\n");
			fprintf(stdout,"\t# refresh - to refresh the screen\n");
			fprintf(stdout,"\t# Typing \} causes exit from interactive mode.\n");
			reading=TRUE;
		}
		else if (strcmp(string,"pointcolou")==0 ||
				strcmp(string,"pointcolor")==0){
			fprintf(stdout,"\t# Changing point colour. Choose from\n");
			fprintf(stdout,"\t# black, red, yellow, green, cyan, blue,\
 magenta, white.\n");
			fprintf(stdout,"\t# If one of these is not available today on your\n");
			fprintf(stdout,"\t# machine, black or white will be used in its place.\n");
			read_next_string(string,10,file);
			if (strcmp(string,"black     ")==0)
				pointcolour=BLACK;
			else if (strcmp(string,"red       ")==0)
				pointcolour=RED;
			else if (strcmp(string,"yellow    ")==0)
				pointcolour=YELLOW;
			else if (strcmp(string,"green     ")==0)
				pointcolour=GREEN;
			else if (strcmp(string,"cyan      ")==0)
				pointcolour=CYAN;
			else if (strcmp(string,"blue      ")==0)
				pointcolour=BLUE;
			else if (strcmp(string,"magenta   ")==0)
				pointcolour=MAGENTA;
			else if (strcmp(string,"white     ")==0)
				pointcolour=WHITE;
			else {
				fprintf(stdout,"\t# Colour currently unavailable. Sorry\n");	
				reading=TRUE;
			}
		}
		else if (strcmp(string,"edgecolour")==0 ||
				strcmp(string,"edgecolor ")==0){
			fprintf(stdout,"\t Changing edge colour. Choose from\n");
			fprintf(stdout,"\t black, red, yellow, green, cyan, blue,\
 magenta, white.\n");
			fprintf(stdout,"\t# If one of these is not available today on your\n");
			fprintf(stdout,"\t# machine, black will be used in its place.\n");
			read_next_string(string,10,file);
			if (strcmp(string,"black     ")==0)
				edgecolour=BLACK;
			else if (strcmp(string,"red       ")==0)
				edgecolour=RED;
			else if (strcmp(string,"yellow    ")==0)
				edgecolour=YELLOW;
			else if (strcmp(string,"green     ")==0)
				edgecolour=GREEN;
			else if (strcmp(string,"cyan      ")==0)
				edgecolour=CYAN;
			else if (strcmp(string,"blue      ")==0)
				edgecolour=BLUE;
			else if (strcmp(string,"magenta   ")==0)
				edgecolour=MAGENTA;
			else if (strcmp(string,"white     ")==0)
				edgecolour=WHITE;
			else {
				fprintf(stdout,"\t# Colour currently unavailable. Sorry\n");	
				reading=TRUE;
			}
		}
		else if (strcmp(string,"labelcolou")==0 ||
				strcmp(string,"labelcolor")==0){
			fprintf(stdout,"\t Changing label colour. Choose from\n");
			fprintf(stdout,"\t black, red, yellow, green, cyan, blue,\
 magenta, white.\n");
			fprintf(stdout,"\t# If one of these is not available today on your\n");
			fprintf(stdout,"\t# machine, black will be used in its place.\n");
			read_next_string(string,10,file);
			if (strcmp(string,"black     ")==0)
				labelcolour=BLACK;
			else if (strcmp(string,"red       ")==0)
				labelcolour=RED;
			else if (strcmp(string,"yellow    ")==0)
				labelcolour=YELLOW;
			else if (strcmp(string,"green     ")==0)
				labelcolour=GREEN;
			else if (strcmp(string,"cyan      ")==0)
				labelcolour=CYAN;
			else if (strcmp(string,"blue      ")==0)
				labelcolour=BLUE;
			else if (strcmp(string,"magenta   ")==0)
				labelcolour=MAGENTA;
			else if (strcmp(string,"white     ")==0)
				labelcolour=WHITE;
			else {
				fprintf(stdout,"\t# Colour currently unavailable. Sorry\n");	
				reading=TRUE;
			}
		}
		else if (strcmp(string,"screenradi")==0){
			fprintf(stdout," \t# screen radius changed from %d\n",rmax);
			read_next_int(&rmax,file);
			fprintf(stdout,"\t# to %d\n",rmax);
			if (rmax<=0 ||rmax>=32768) 
				fprintf(stdout,"\t# Out of range. Try again.\n");
		}
		else if (strcmp(string,"screendept")==0){
			fprintf(stdout," \t# screen depth changed from %d\n",depth);
			read_next_int(&depth,file);
			fprintf(stdout,"\t# to %d\n",depth);
			if (depth>=32768) 
				fprintf(stdout,"\t# Out of range. Try again.\n");
		}
		else if (strcmp(string,"bandwidth ")==0){
			int l;
			fprintf(stdout,"\t# WARNING.\n");
		fprintf(stdout,"\t# If you change the bandwidth the picture will\n");
	fprintf(stdout,"\t# revert to the default layout with only the global\n");
	fprintf(stdout,"\t# parameter changes in force. Any changes you have\n");
			fprintf(stdout,"\t# made with the mouse will be lost.\n");
			fprintf(stdout,"\t# Are you sure you want to do this (y/n)?\n");
			read_next_letter(&l,file);
			if (l=='y'){
			fprintf(stdout," \t# band width changed from %d\n",bandwidth);
				read_next_int(&bandwidth,file);
				fprintf(stdout,"\t# to %d\n",bandwidth);
				if (bandwidth<=0 || bandwidth>=32768)
					fprintf(stdout,"\t# Out of range. Try again.\n");
				else
					graph_plan(lgp);
			}
		}
		else if (strcmp(string,"loopradius")==0){
			fprintf(stdout," \t# loop radius changed from %d\n",lprad);
			read_next_int(&lprad,file);
			fprintf(stdout,"\t# to %d\n",lprad);
			if (lprad<=0 || lprad>=32768)
				fprintf(stdout,"\t# Out of range. Try again.\n");
		}
		else if (strcmp(string,"pointradiu")==0){
			fprintf(stdout," \t# point radius changed from %d\n",ptrad);
			read_next_int(&ptrad,file);
			fprintf(stdout,"\t# to %d\n",ptrad);
			if (ptrad<0 || ptrad>=32768)
				fprintf(stdout,"\t# Out of range. Try again.\n");
		}
		else if (strcmp(string,"charheight")==0){
			if (xwindows)
		fprintf(stdout," \t# Can't change character height in xwindows.\n");
			else {
		fprintf(stdout," \t# character height changed from %d\n",charht);
				read_next_int(&charht,file);
				fprintf(stdout,"\t# to %d\n",charht);
				if (charht<=0 || charht>=32768)
					fprintf(stdout,"\t# Out of range. Try again.\n");
			}
		}
		else if (strcmp(string,"mouse     ")==0) 
			mouse=TRUE;
		else if (strcmp(string,"write     ")==0) {
			FILE * psfile;
			char * fname;
			int i=0;
			int m=0;
			fprintf(stdout,"\t# specify name for psfile (at most 10 characters)\n");
			read_next_string(string,10,file);
			while (string[m]!=' '&&string[m]!='\0')
				m++;
			fname = vzalloc2(char,m+1);
			while (i<m)
				fname[i]=string[i++];
			fname[m]='\0';
			psfile=fopen(fname,"w");
			setbuf(psfile,(char*)0);
			ps_graphics_init(psfile);
			graph_plot(lgp,psfile);
			ps_graphics_clear(psfile);
			fclose(psfile);
		}	
		else if (strcmp(string,"refresh   ")==0) 
			(void)screengraphics_screen_reconfigured();
		else {
			fprintf(stdout,"\t# Inadmissible keyword. Try again.\n");
			reading=TRUE;
		}
	}
	Free_dp((dp)string); string=0;
	return redraw;
}
	
static void
redraw_with_mouse(lgp)
	lg * lgp;
{
	int x=0;
	int y=0;
	int b=0;
	int i; 
	screengraphics_mouse_init();
	boxx1 = 0; boxx2=rmax/2; 
	boxy1 = -depth-border; boxy2 = -depth-(border/5);
	screengraphics_rectangle(boxx1,boxy1,boxx2,boxy2,RED);
	screengraphics_text((boxx1+boxx2)/2,(boxy1+boxy2)/2,
					"MOUSE EXIT", 1.0,0.0,0.0,1.0,border/5,RED);
	fprintf(stdout,"\t# In mouse mode.\n");
fprintf(stdout,"\t# Clicks on left button locate and then reposition points.\n");
fprintf(stdout,"\t# Clicks on middle button locate and then reposition labels.\n");
	fprintf(stdout,"\t# Clicks on right button locate and then reposition the\n");fprintf(stdout,"\t# centres of loops (but loopradii are unchanged),\n");
fprintf(stdout,"\t# Click in the box below the page rectangle to exit from mouse mode.\n");
	do {
		screengraphics_mouse_locate(&x,&y,&b);
		if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
			break; 
		if (b==1){
			fprintf(stdout,"\t# Moving a point.\n");
			i=nearest_pt(get_num_verts(lgp),x,y);
			do {
				screengraphics_mouse_locate(&x,&y,&b);
				if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
					break; 
				if (b!=1)
				fprintf(stdout,"\t# Wrong mouse button. Try again.\n");
			} while (b!=1);
			if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
				break; 
			xcoor[i]=x;
			ycoor[i]=y;
		}
		else if (b==2){
			gen g;
			double lambda;
			fprintf(stdout,"\t# Moving a label.\n");
			find_nearest_label(get_num_verts(lgp),lgp->degree,&i,&g,x,y);
			do {
				screengraphics_mouse_locate(&x,&y,&b);
				if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
					break; 
				if (b!=2)
				fprintf(stdout,"\t# Wrong mouse button. Try again.\n");
			} while (b!=2);
			if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
				break; 
			lambda=nearest_lambda(i,g,x,y);
			if (lambdas[i]==default_lambdas){
				gen h;
				lambdas[i]=vzalloc2(double,(lgp->degree)+1);
					for (h=0;h<=lgp->degree;h++)
					lambdas[i][h]=default_lambdas[h];
			}
			lambdas[i][g]=lambda;
		}
		else if (b==3){
			gen g;
			fprintf(stdout,"\t# Moving a loop.\n");
			if (find_nearest_loop(get_num_verts(lgp),lgp->degree,&i,x,y)){
				do {
					screengraphics_mouse_locate(&x,&y,&b);
					if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
					break; 
					if (b!=3)
					fprintf(stdout,"\t# Wrong mouse button. Try again.\n");
				} while (b!=3);
				if (x>boxx1 && x< boxx2 && y > boxy1 && y<boxy2)
					break; 
				mu[i]=nearest_mu(xcoor[i],ycoor[i],x,y);
			}
			else 
				fprintf(stdout,"\t# No loops to move. Try again.\n");
		}
		screengraphics_screen_reset(-rmax,-depth-border,rmax,rmax);
		graph_plot(lgp,(FILE *)0);
	} while (0!=1);
	fprintf(stdout,"\t# Exiting mouse mode. To reenter type \"mouse\".\n");
	screengraphics_clear_outside_rectangle(-rmax,-depth,rmax,rmax);
	screengraphics_rectangle(-rmax,-depth,rmax,rmax,RED);
	screengraphics_mouse_clear();
}

static int
nearest_pt(N,x,y)
	int N;
	int x;
	int y;
{
	int i=0;
	int j=0;
	double best,current;
	double a,b;
	a=(double)(x-xcoor[0])/(double)(rmax);
	b=(double)(y-ycoor[0])/(double)(rmax); 
	best = a*a+b*b;
	while (j<=N){
		a=(double)(x-xcoor[j])/(double)(rmax);
		b=(double)(y-ycoor[j])/(double)(rmax); 
		current=a*a+b*b;
		if (current<best){
			best=current;
			i=j;
		}
		j++;
	}
	return i;
}

static void
find_nearest_label(N,d,ip,gp,x,y)
	int N;
	int d;
	int * ip;
	gen * gp;
	int x,y;
{
	double best,current;
	int xx,yy;
	double a,b;
	int j=1;
	int k;
	gen h;
	*ip=1;
	*gp=0;
	pt_label_posn(xcoor[1],ycoor[1],cat[1],lambdas[1][0],&xx,&yy);
	a=(double)(x-xx)/(double)(rmax);
	b=(double)(y-yy)/(double)(rmax);
	best=a*a+b*b;
	for (j=1;j<=N;j++){
		pt_label_posn(xcoor[j],ycoor[j],cat[j],lambdas[j][0],&xx,&yy);
		a=(double)(x-xx)/(double)(rmax);
		b=(double)(y-yy)/(double)(rmax);
		current=a*a+b*b;
		if (current<best){
			*ip=j;
			*gp=0;
			best=current;
		}
		for (h=1;h<=d;h++){
			vindex v=get(vertices[j],h);
			if (v!=UNDEFINED){
				k=get_index(v);
				if (k==j)
		loop_label_posn(xcoor[j],ycoor[j],lambdas[j][h],mu[j],&xx,&yy);
				else 
				line_label_posn(xcoor[j],ycoor[j],xcoor[k],
					ycoor[k], lambdas[j][h],&xx,&yy);
				a=(double)(x-xx)/(double)(rmax);
				b=(double)(y-yy)/(double)(rmax);
				current=a*a+b*b;
				if (current<best){
					*ip=j;
					*gp=h;
					best=current;
				}
			}
		}
	}
}
			
static boolean
find_nearest_loop(N,d,ip,x,y)
	int N;
	int d;
	int * ip;
	int x,y;
{
	boolean ans=FALSE;
	double best,current;
	int xx,yy;
	double a,b;
	int j=1;
	int k;
	gen h;
	*ip=1;
	for (j=1;j<=N;j++){
		for (h=1;h<=d;h++){
			if (get(vertices[j],h)==vertices[j]){
				loop_centre_posn(xcoor[j],ycoor[j],mu[j],&xx,&yy);
				a=(double)(x-xx)/(double)(rmax);
				b=(double)(y-yy)/(double)(rmax);
				current=a*a+b*b;
				if (ans==FALSE || current<best){
					*ip=j;
					best=current;
				}
				ans = TRUE;
				break; /* there's at most one loop around each point,
possible with many labels on it */
			}
		}
	}
	return ans;
}
			
	
static double
nearest_lambda(i,g,x,y)
	int i;
	gen g;
	int x;
	int y;
{
	double lambda=0;
	if (g==0)
		lambda=pt_lambda(xcoor[i],ycoor[i],x,y);
	else {	
		vindex v=get(vertices[i],g);
		if (v!=UNDEFINED){
			int j=get_index(v);
			if (j!=i)
				lambda=line_lambda(xcoor[i],ycoor[i],
						xcoor[j],ycoor[j],x,y);
			else
			lambda=loop_lambda(xcoor[i],ycoor[i],mu[i],x,y);
		}
	}
	return lambda;
}

