/* automata.d/src file axioms.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "lg.h"
#include "input.h"
# define PROCRELSOP ".procrels"
# define WAOP ".wa"
# define MULTOP ".mult"
FILE * rfile=stdin;
FILE * wfile=stdout;

char gpname[100];
char filename[100];
char prefix[100];
char generator[100];



lg * WA=0;
lg ** M=0;
list  rels;
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens;
extern int gen_array_size;
static lg * word_mult PARMS ((word * wp));
static boolean check_axioms PARMS((VOID));

main(argc,argv)
	int argc;
	char * argv[];
{
	int exit_code=0;
	int i;

	word rel;
	char * label;
	int readfile=0;
	boolean first_fc = TRUE;

	if (argc>2){
		fprintf(stderr,"Usage: wa [gpname]\n");
		exit(2);
	}
	else if (argc==2){
		strcpy(gpname,argv[1]);
		strcpy(filename,gpname);
		strcat(filename,WAOP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		readfile=1;
	}


	setbuf(stdout, (char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);


	label=vzalloc2(char,9);
/* there may be long keywords also in the input file
that we need to skip over */
	while (read_next_string(label,8,rfile) || readfile==1){
		if (strcmp(label,"Format  ")==0){
			if (first_fc){
				format_echocheck("2.2",rfile,wfile);
				first_fc = FALSE;
			}
			else
				format_check("2.2",rfile);
		}
		else if (strcmp(label,"fsa     ")==0){
			if (WA==0)
				WA=lg_read(GENERIC,BASIC_FSA,rfile);
/* |num_gens| is set now */
			else if (rfile==stdin) {
				if (M==0){
					M = vzalloc2(lg*,num_gens+1);
					i=0;
				}
				if (i<=num_gens)
					M[i++]=lg_read(GENERIC,BASIC_FSA,rfile);
			}
		}
		else if (strcmp(label,"inverses")==0){
			if (inv_of==0)
				read_inverse_array(rfile);
		}
		else if (strcmp(label,"rels    ")==0){
			if (inv_of==0)
				default_inverse_array();
			while (getc(rfile)!='\{')
				;
			list_init(&rels,WORD,ORDERED);
			word_init(&rel);
			while (read_next_rel(&rel,rfile)){
				list_insert(&rels,&rel);
				word_reset(&rel);
			}
			word_clear(&rel);
			while (getc(rfile)!='\}')
				;
		}
		else if (readfile==1){
			strcpy(filename,gpname);
			strcat(filename,PROCRELSOP);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
			readfile=2;
		}
	}
	Free_dp((dp)label); label=0;
	if (rfile!=stdin){
		strcpy(prefix,gpname);
		strcat(prefix,MULTOP);
	}

	if (check_axioms()==TRUE)
		fprintf(wfile,"\t# Automata pass axiom checks.\n");
	else{
		fprintf(wfile,"\t# Automata fail axiom checks.\n");
		exit_code=1;
	}

	list_clear(&rels);

	if (rfile==stdin){
		for (i=0;i<=num_gens;++i){
			lg_clear(M[i]);
			Free_dp((dp)M[i]); M[i]=0;
		}
		Free_dp((dp)M); M=0;
	}

	lg_clear(WA);
	Free_dp((dp)WA); WA=0;
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)inv_of); inv_of=0;
	exit(exit_code);
}

static boolean
check_axioms()
{
	boolean ans=TRUE;
	char * label;
	lg * M0, * M1, * M2;
	label = vzalloc2(char,9);
	{
		lg * false=fsa_false(num_gens+1);
		ans = (lg_eq(WA,false)==FALSE);
		if (ans==FALSE)
			fprintf(wfile,"\t# The language of WA is empty.\n");
		else
			fprintf(wfile,"\t# The language of WA is non-empty.\n");
		lg_clear(false);
		Free_dp((dp)false); false=0;
	}
	if (ans){
		lg * diag=fsa_diag(WA);
		if (rfile==stdin)
			M0=M[0];
		else {
			genstring(generator,0);
			strcpy(filename,prefix);
			strcat(filename,generator);
			fclose(rfile);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
			while (read_next_string(label,8,rfile)){
				if (strcmp(label,"Format  ")==0)
					format_check("2.2",rfile);
				else if (strcmp(label,"fsa     ")==0)
					M0=lg_read(GENERIC,BASIC_FSA,rfile);
			}
		}
		ans = lg_eq(diag,M0);
		if (ans==FALSE){
			fprintf(wfile,"\t# M(0) is not the diagonal of WA.\n");
			fprintf(wfile,"\t# M(0)\n");
			lg_print(wfile,M[0]);
			fprintf(wfile,"\t# DIAG\n");
			lg_print(wfile,diag);
		}
		else
			fprintf(wfile,"\t# M(0) = the diagonal of WA.\n");
		lg_clear(diag);
		Free_dp((dp)diag); diag=0;
		if (rfile!=stdin){
			lg_clear(M0);
			Free_dp((dp)M0); M0=0;
		}
	}
	if (ans){
		gen g;
		for (g=1;g<=num_gens;g++){
			if (g<=inv(g)) {
				lg * swap;
				if (rfile==stdin){
					M1 = M[g];
					M2 = M[inv(g)];
				}
				else {
					genstring(generator,inv(g));
					strcpy(filename,prefix);
					strcat(filename,generator);
					fclose(rfile);
					if ((rfile=fopen(filename,"r"))==0)
  						{ fprintf(stderr,"Cannot open %s.\n",filename); 
						exit(2);}
					while (read_next_string(label,8,rfile)){
						if (strcmp(label,"Format  ")==0)
							format_check("2.2",rfile);
						else if (strcmp(label,"fsa     ")==0)
							M2=lg_read(GENERIC,BASIC_FSA,rfile);
					}
				}
				swap=fsa_swapxy(M2);
				if (rfile!=stdin){
					lg_clear(M2);
					Free_dp((dp)M2); M2=0;
					genstring(generator,g);
					strcpy(filename,prefix);
					strcat(filename,generator);
					fclose(rfile);
					if ((rfile=fopen(filename,"r"))==0)
  						{ fprintf(stderr,"Cannot open %s.\n",filename); 
						exit(2);}
					while (read_next_string(label,8,rfile)){
						if (strcmp(label,"Format  ")==0)
							format_check("2.2",rfile);
						else if (strcmp(label,"fsa     ")==0)
							M1=lg_read(GENERIC,BASIC_FSA,rfile);
					}
				}
				ans=lg_eq(M1,swap);
				fprintf(wfile,"\t# M(");
				gen_print(wfile,g);
				if (ans==FALSE)
					fprintf(wfile,") is not transpose to M(");
				else
					fprintf(wfile,") is transpose to M(");
				gen_print(wfile,inv(g));
				fprintf(wfile,").\n");
				lg_clear(swap);
				Free_dp((dp)swap); swap=0;
				if (rfile!=stdin){
					lg_clear(M1);
					Free_dp((dp)M1); M1=0;
				}
				if (ans==FALSE)
					break;
			}
		}
	}
	if (ans) {
		gen g;
		for (g=1;g<=num_gens;g++){
			lg * MgG;
			if (rfile==stdin){
				M1 = M[g];
				M2 = M[inv(g)];
			}
			else {
				genstring(generator,g);
				strcpy(filename,prefix);
				strcat(filename,generator);
				fclose(rfile);
				if ((rfile=fopen(filename,"r"))==0)
  					{ fprintf(stderr,"Cannot open %s.\n",filename); 
					exit(2);}
				while (read_next_string(label,8,rfile)){
					if (strcmp(label,"Format  ")==0)
						format_check("2.2",rfile);
					else if (strcmp(label,"fsa     ")==0)
						M1=lg_read(GENERIC,BASIC_FSA,rfile);
				}
				genstring(generator,inv(g));
				strcpy(filename,prefix);
				strcat(filename,generator);
				fclose(rfile);
				if ((rfile=fopen(filename,"r"))==0)
  					{ fprintf(stderr,"Cannot open %s.\n",filename); 
					exit(2);}
				while (read_next_string(label,8,rfile)){
					if (strcmp(label,"Format  ")==0)
						format_check("2.2",rfile);
					else if (strcmp(label,"fsa     ")==0)
						M2=lg_read(GENERIC,BASIC_FSA,rfile);
				}
			}
			MgG = fsa_exists_x2y1(M1,M2);
			if (rfile==stdin)
				M0=M[0];
			else {
				lg_clear(M1);
				lg_clear(M2);
				Free_dp((dp)M1); M1=0;
				Free_dp((dp)M2); M2=0;
				genstring(generator,0);
				strcpy(filename,prefix);
				strcat(filename,generator);
				fclose(rfile);
				if ((rfile=fopen(filename,"r"))==0)
  					{ fprintf(stderr,"Cannot open %s.\n",filename); 
					exit(2);}
				while (read_next_string(label,8,rfile)){
					if (strcmp(label,"Format  ")==0)
						format_check("2.2",rfile);
					else if (strcmp(label,"fsa     ")==0)
						M0=lg_read(GENERIC,BASIC_FSA,rfile);
				}
			}
			ans = lg_eq(MgG,M0);
			if (rfile!=stdin){
				lg_clear(M0);
				Free_dp((dp)M0); M0=0;
			}
			fprintf(wfile,"\t# M(");
			gen_print(wfile,g);
			fprintf(wfile,"*");
			gen_print(wfile,inv(g));
			if (ans==FALSE){
				fprintf(wfile,") is not M(0).\n");
				fprintf(wfile,"\t# M(");
				gen_print(wfile,g);
				fprintf(wfile,"*");
				gen_print(wfile,inv(g));
				fprintf(wfile,")\n");
				lg_print(wfile,MgG);
			}	
			else
				fprintf(wfile,") = M(0).\n");
			lg_clear(MgG);
			Free_dp((dp)MgG); MgG=0;	
			if (ans==FALSE)
				break;
		}
	}
	if (ans) {
		list_traverser trels;
		word rel;
		word w1;
		word w2;
		word_init(&rel);
		word_init(&w1);
		word_init(&w2);
		list_traverser_init(&trels,&rels);
		while (list_next(&trels,(dp)&rel)){
			lg * Mw1;
			lg * Mw2;
			(void)word_halve(&rel,&w1,&w2);
			word_inv(&w2,&w2);
			Mw1=word_mult(&w1);
			Mw2=word_mult(&w2);
			ans = lg_eq(Mw1,Mw2);
			fprintf(wfile,"\t# M(");
			word_print(wfile,&w1);
			if (ans==FALSE){
				fprintf(wfile,") is not M(");
				word_print(wfile,&w2);
				fprintf(wfile,").\n");
				fprintf(wfile,"\t# M(");
				word_print(wfile,&w1);
				fprintf(wfile,").");
				lg_print(wfile,Mw1);
				fprintf(wfile,"\t# M(");
				word_print(wfile,&w2);
				fprintf(wfile,").");
				lg_print(wfile,Mw2);
			}
			else{	
				fprintf(wfile,") is  M(");
				word_print(wfile,&w2);
				fprintf(wfile,"), so  M(");
				word_print(wfile,&rel);
				fprintf(wfile,") = M(0).\n");
			}
			if (rfile!=stdin||word_length(&w1)>2){
				lg_clear(Mw1);
				Free_dp((dp)Mw1); Mw1=0;
			}
			if (rfile!=stdin||word_length(&w2)>2){
				lg_clear(Mw2);
				Free_dp((dp)Mw2); Mw2=0;
			}
			if (ans==FALSE)
				break;
			else
				word_reset(&rel);
		}
		list_traverser_clear(&trels);
		word_clear(&w1);
		word_clear(&w2);
		word_clear(&rel);
	}
	Free_dp((dp)label); label = 0;
	return ans;
}

static lg*
word_mult(wp)
	word * wp;
{
	lg * Mw;
	int l=word_length(wp);
	gen g;
	char * label;
	label = vzalloc2(char,9);
	if (l<=1){
		if (l==0)
			g=0;
		else if (l==1){
			word_get_last(wp,&g);
		}
		if (rfile==stdin)
			Mw=M[g];
		else {
			genstring(generator,g);
			strcpy(filename,prefix);
			strcat(filename,generator);
			fclose(rfile);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); 
						exit(2);}
			while (read_next_string(label,8,rfile)){
				if (strcmp(label,"Format  ")==0)
					format_check("2.2",rfile);
				else if (strcmp(label,"fsa     ")==0)
					Mw=lg_read(GENERIC,BASIC_FSA,rfile);
			}
		}
	}
	else {
		word w1;
		word w2;
		lg * Mw1=0;
		lg * Mw2=0;
		word_init(&w1);
		word_init(&w2);
		(void)word_halve(wp,&w1,&w2);
		Mw1=word_mult(&w1);
		Mw2=word_mult(&w2);
		Mw=fsa_exists_x2y1(Mw1,Mw2);
		if (word_length(&w1)>1){
			lg_clear(Mw1);
			Free_dp((dp)Mw1); Mw1=0;
		}
		word_clear(&w1);
		if (word_length(&w2)>1){
			lg_clear(Mw2);
			Free_dp((dp)Mw2); Mw2=0;
		}
		word_clear(&w2);
		Mw1=0; Mw2=0;
	}
	Free_dp((dp)label); label = 0;
	return Mw;
}
		
		
