/* automata.d/src file screengraphics.c */
#include "defs.h"
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "screengraphics.h"
#include <stdio.h>

extern boolean xwindows;
extern char windowname[100];
int whiteindex;
int blackindex; 
char * display_name=0;
Display *display;
GC gc;
Window window;
Visual *visual;
int screen_number;
int screen_height;
int screen_width;
int window_height;
int window_width;
int left;
int top;
float pixelscale;
static XSetWindowAttributes xswa, WinAtt;
static Colormap		colourmap;			/* The colourmap we are using */
unsigned long		colour[8];		
static void set_colour();

void screengraphics_screen_init(blackscreen,x1,y1,x2,y2)
	int blackscreen,x1,y1,x2,y2;
{
	XEvent pe;
	int w = x2 - x1;
	int h = y2 - y1;
	int i;
	float wscale,hscale;
	int incolour = 1;

	xwindows = TRUE;
	left = x1;
	top = y2;
	display = XOpenDisplay(display_name);
	screen_number = DefaultScreen(display);
	screen_height = DisplayHeight(display,screen_number);
	screen_width = DisplayWidth(display,screen_number);
	window_width = 0.5 * screen_width;
	window_height = 0.5 * screen_height;
	wscale = ((float)window_width)/((float)w);
	hscale = ((float)window_height)/((float)h);
	pixelscale = (wscale < hscale)? wscale : hscale;
		
	if (XDisplayCells(display,screen_number) == 2)
		incolour = 0;;
	xswa.backing_store = Always;
	xswa.event_mask = ExposureMask | StructureNotifyMask | ButtonPressMask;
	window = XCreateWindow(display,
			      RootWindow(display, DefaultScreen(display)),
			      0,0,window_width,window_height, 1,
			      DefaultDepth(display, DefaultScreen(display)), InputOutput,
			      DefaultVisual(display, DefaultScreen(display)),
			      CWEventMask | CWBackingStore,
			      &xswa);

	XStoreName(display,window,windowname);
	XMapWindow(display, window);
	(void) XGetWindowAttributes(display, window, &WinAtt);
/*
 I don't know what this function really does, but without it the window isn't
visible. The reason for this is on page 3-11, and needs further investigation */

	colourmap = XDefaultColormap(display, DefaultScreen(display));
	XSetWindowColormap(display, window, colourmap);
	if (blackscreen) {
		whiteindex = 7;
		blackindex = 0;
	}	
	else {
		whiteindex = 0;
		blackindex = 7;	
	}
	if (incolour==1){
		set_colour(blackindex,0,0,0);
		set_colour(whiteindex,1,1,1);
		set_colour(RED,1,0,0);
		set_colour(GREEN,0,1,0);
		set_colour(BLUE,0,0,1);
		set_colour(YELLOW,1,1,0);
		set_colour(CYAN,0,1,1);
		set_colour(MAGENTA,1,0,1);
		XSetWindowColormap(display, window, colourmap);
	}
	else {
		colour[whiteindex] = XWhitePixel(display,screen_number);
		colour[blackindex] = XBlackPixel(display,screen_number);
		for (i=1;i<7;i++)
			colour[i]=colour[7];
	}
	/*
	 * Now for the graphics context.
	 * Easy - just use the default...
	 */
	gc = DefaultGC(display, DefaultScreen(display));






	/*
	 * Now wait until we are in sync with the server.
	 */
	XSync(display, False);
	XSetBackground(display, gc, colour[0]);
	XSetForeground(display, gc, colour[0]);
	XFillRectangle(display, window, gc, 0, 0, window_width, window_height);
	XFlush(display);
/* Now flush the events that are generated at the start out of the events
queue */
	do {
		XPeekEvent(display,&pe);
		XNextEvent(display,&pe);
	}while (pe.type!=Expose);
}

static void 
set_colour(c, r, g, b)
int	c;
int	r, g, b;
{
	XColor	xc;

	xc.flags = DoRed | DoGreen | DoBlue;
	
	xc.red = r * (65535);
	xc.green = g * (65535);
	xc.blue = b * (65535);
	XAllocColor(display, colourmap, &xc);
	colour[c] = xc.pixel;
}


void screengraphics_screen_reset(x1,y1,x2,y2)
	int x1,y1,x2,y2;
{
	int w = x2 - x1;
	int h = y2 - y1;
	float wscale,hscale;
	left = x1;
	top = y2;


	wscale = ((float)window_width)/((float)w);
	hscale = ((float)window_height)/((float)h);
	pixelscale = (wscale < hscale)? wscale : hscale;
	XSetForeground(display, gc, colour[0]);
	XFillRectangle(display, window, gc, 0, 0, 
					 window_width,window_height);
	XFlush(display);
}

int screengraphics_screen_reconfigured()
{
	int ans=0;
	while (XPending(display)!=0) {
		XEvent  pe;
		XNextEvent(display, &pe);
		if (pe.type==ConfigureNotify) {
			XConfigureEvent *ce = (XConfigureEvent *) & pe;
			if (window_width != ce->width || window_height != ce->height){
				ans = 1;
				window_width = ce->width;
				window_height = ce->height;
			}
		}
	} 
	return ans;
}
void screengraphics_screen_clear()
{
	XSync(display,False);
	XDestroyWindow(display,window);
	XCloseDisplay(display);
}


void
screengraphics_circle(x,y,radius,c)
	int x,y,radius,c;
{
	int xx = (int)((x - left) * pixelscale);
	int yy = (int)((top- y) * pixelscale);
	int rr = radius*pixelscale;
	XSetForeground(display, gc,colour[c]);
	XDrawArc(display,window,gc,xx-rr,yy-rr,2*rr,2*rr,0,360*64);
	/*XFlush(display); We don't need to flush every time we do something*/
}

void
screengraphics_text(x,y,string,a,b,c,d,size,col)
	int x,y;
	char * string;
	double a,b,c,d;
	int size;
	int col;
{
	int xx = (int)((x - left) * pixelscale);
	int yy = (int)((top- y) * pixelscale);
	int ssize = size*pixelscale;
	int len=0;
	while (string[len]!='\0')
		len++;
	XSetForeground(display,gc,colour[col]);
	XDrawImageString(display,window,gc,xx-(len*ssize/3),yy,string,len);
	/* we want the centre of the string to be at (xx,yy). Here I'm making
the assumption that characters are 2/3 as wide as tall, which may not be
true. */
	/*XFlush(display); We don't need to flush every time we do something*/
}

void
screengraphics_line(x1,y1,x2,y2,c)
	int x1,y1,x2,y2;
	int c;
{
	int xx1 = (int)((x1 - left)*pixelscale);
	int xx2 = (int)((x2 - left)*pixelscale);
	int yy1 = (int)((top - y1)*pixelscale);
	int yy2 = (int)((top - y2)*pixelscale);
	XSetForeground(display, gc,colour[c]);
	XDrawLine(display, window, gc, xx1, yy1, xx2, yy2);
	/*XFlush(display); We don't need to flush every time we do something*/
}

void
screengraphics_rectangle(x1,y1,x2,y2,c)
	int x1,y1,x2,y2,c;
{
	int xx1 = (int)((x1 - left)*pixelscale);
	int xx2 = (int)((x2 - left)*pixelscale);
	int yy1 = (int)((top - y1)*pixelscale);
	int yy2 = (int)((top - y2)*pixelscale);
	XSetForeground(display, gc,colour[c]);
	XDrawLine(display, window, gc, xx1, yy1, xx1, yy2);
	XDrawLine(display, window, gc, xx1, yy1, xx2, yy1);
	XDrawLine(display, window, gc, xx2, yy1, xx2, yy2);
	XDrawLine(display, window, gc, xx1, yy2, xx2, yy2);
	XFlush(display); 
}

void
screengraphics_clear_outside_rectangle(x1,y1,x2,y2)
	int x1,y1,x2,y2;
{
	int xx1 = (int)((x1 - left) * pixelscale);
	int yy1 = (int)((top- y1) * pixelscale);
	int xx2 = (int)((x2 - left) * pixelscale);
	int yy2 = (int)((top- y2) * pixelscale);
	XSetForeground(display, gc, colour[0]);
	XFillRectangle(display, window, gc,0, 0, xx1, window_height);
	XFillRectangle(display, window, gc,xx2, 0, window_width, window_height);
	XFillRectangle(display, window, gc,xx1, 0, xx2, yy2);
	XFillRectangle(display, window, gc,xx1, yy1, xx2, window_height);
	/*XFlush(display); We don't need to flush every time we do something*/
}


void
screengraphics_mouse_init()
{
}

void
screengraphics_mouse_locate(xp,yp,bp)
	int * xp;
	int * yp;
	int * bp;
{
	int xx,yy;
	int button=0;
	while(button == 0) {
/* keep waiting till you get a mouse signal of the right kind */
		XEvent	pe;
		XNextEvent(display, &pe);
		if (pe.type==ButtonPress){
			XButtonPressedEvent	*be = (XButtonPressedEvent *)&pe;
			if(be->button == Button1)
				button = 1;
			if(be->button == Button2)
				button = 2;
			if(be->button == Button3)
				button = 3;
			if (button){
				xx = be->x;
				yy = be->y;
			}
		}
		else if (pe.type==ConfigureNotify) {
			XConfigureEvent *ce = (XConfigureEvent *) & pe;
			window_width = ce->width;
			window_height = ce->height;
		}
	}
	*bp = button;
	*xp = (int)(xx/pixelscale) + left;
	*yp = top - (int)(yy/pixelscale);
}

void
screengraphics_mouse_clear()
{
} 

