/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/* Generated by Interface Builder */

#import <objc/Object.h>
#import <appkit/color.h>

@interface PrefObj:Object
{
  /******* Outlets to controls on panel ********/

  /*** Editor Inspector Controls ***/
  id rulersB;
  id axesB;
  id arrowsB;
  id verticesB;
  id anchorPointsB;
  id sparseSlider;
  id sparseText;
  
  /*** Displayer Inspector Controls ***/
  
  /* Sliders */
  id ampSlider;
  id ampBSlider;
  id fffaSlider;
  id fffbSlider;
  id ppcSlider;
  id segMaxSlider;
  id segScaleSlider;
  id sepSlider;

  /* Text fields */
  id ampText;
  id ampBText;
  id fffaText;
  id fffbText;
  id ppcText;
  id segMaxText;
  id segScaleText;
  id sepText;

  /* Radio button matrices */
  id redrawRB;
  id textureRB;

  /* Color wells */
  id color0, color1, color2, color3, color4, color5;

  /*** Other settings ***/
  id soundsB;

  /* Views */
  id prefView;
  id eSettingsView;
  id spliningView;
  id textureView;
  id soundsView;
  id colorView;

  /******** Miscellaneous ********/

  char *owner;
  id prefPanel, modeB;
  struct _NXDefault *origDefaults;
  char mode;
}

#define NUM_SETTINGS 24

- init;
- setDefaults:sender;
- revertDefaults:sender;
- revertCurrent:sender;
- readPanel;
- writePanel:(float *) vals;
- showPanel:sender;
- (float *) prepareValsFromOriginal;
- (float *) prepareValsFromCurrent;
- EditorS:sender;
- SoundsS:sender;
- SpliningS:sender;
- TextureS:sender;

- (int) get_segmentSounds;
- (int) get_obnoxiousSounds;
- (NXColor *) get_colors;

/* Types for mode instance variable */
#define EDS 1
#define SPS 2
#define TES 3
#define SOS 4
#define COS 5
#define ALL 6

@end
