/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  file_menu.c: Functions for file menu window.                 */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"

/*------------------------------------------------------------

  Function : file_menu(int)

-------------------------------------------------------------*/
file_menu(invert_num)
int invert_num;
{

	int looping,i,cnt;
	char text_buffer[40], s[5];
	int text_width;
	int okbutton_flg,okbutton_x,okbutton_y;
	XSetWindowAttributes  atr;


	if(invert_num == 6){ /* quit */
		exit(0);
	}
	if(invert_num == 5){ 
		return;
	}

	sub_menuhint.x = 170;
	sub_menuhint.y = 35 + 20*invert_num;
	sub_menuhint.width = 450;
	sub_menuhint.height = 100;
	sub_menuhint.flags = PPosition | PSize;

	sub_menuwin = XCreateSimpleWindow(disp,basewin,sub_menuhint.x,sub_menuhint.y,
	sub_menuhint.width,sub_menuhint.height,
	2,black,white);
	sub_menugc = XCreateGC(disp,sub_menuwin,0,0);
	XSetBackground(disp,sub_menugc,white);
	XSetForeground(disp,sub_menugc,black);
	XSetFunction(disp,sub_menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,sub_menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,sub_menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,sub_menuwin);
	looping = 0;
	show_file_menu(invert_num,0);
	XWarpPointer(disp,None,sub_menuwin,0,0,0,0,200,40);
	cnt = 0;
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != sub_menuwin){
				looping = 1;
			}
			break; 

		case KeyPress:
			i=XLookupString(&ev,s,20,&mykey,0);
			if((i == 1)&&(invert_num > 0)){
				switch(s[0]){
				case '\b':
					if(cnt>0){
						cnt--;
						text_buffer[cnt] = '\0';
						draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,400,24,
						13,65,text_buffer);
					}
					break;
				case '\n':
				case 13:
					if(strlen(text_buffer)!=0){
						if((invert_num == 3)||(invert_num == 4)){
							if(text_buffer[cnt-1] != '/'){
								text_buffer[cnt] = '/';
								text_buffer[cnt+1] = '\0';
							}
						}            
						file_menu_act(text_buffer,invert_num);
						draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,400,24,
						13,65,text_buffer);
					}
					break;

				default:
					if (isprint(s[0]) != 0){
						if(cnt<39){
							text_buffer[cnt] = s[0];
							text_buffer[cnt+1] = '\0';
							if(cnt==0){
								text_buffer[1] = '\0';
							}    
							draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,400,24,
							13,65,text_buffer);
							cnt++;
						}
					}
				}
			}
		default:
			break;
		}
	}
	XFreeGC(disp,sub_menugc);
	XDestroyWindow(disp,sub_menuwin);
}      

/*------------------------------------------------------------

  Function : show_file_menu(int,int)

-------------------------------------------------------------*/
show_file_menu(invert_num,flg)
int invert_num;
int flg;
{

	XClearWindow(disp,sub_menuwin);
	XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,446,96);
	XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,442,92);
	switch(invert_num){
	case 0:
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"<< Working File Name >>",
		strlen("<< Working File Name >>"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,"FILE:",
		strlen("FILE:"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,60,40,file_name,
		strlen(file_name));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,400,45);
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,60,"FILE PATH:",
		strlen("FILE PATH:"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,110,60,file_path,
		strlen(file_path));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,65,400,65);
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,"WORK PATH:",
		strlen("WORK PATH:"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,110,90,work_path,
		strlen(work_path));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,95,400,95);
		break;
	case 1:
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"<< Open File Name >>",
		strlen("<< Open File Name >>"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,file_name,
		strlen(file_name));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,290,45);
		if(flg == 1){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Can not open file !!! ***",strlen("*** Can not open file !!! ***"));
		}
		if(flg == 2){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Now reading !!! ***",strlen("*** Now reading !!! ***"));
		}
		if(flg == 3){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Wrong plane data !!! ***",strlen("*** Wrong plane data !!! ***"));
		}
		if(flg == 4){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Cross max over !!! ***",strlen("*** Cross max over !!! ***"));
		}

		break;
	case 2:
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"<< Save File Name >>",
		strlen("<< Save File Name >>"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,file_name,
		strlen(file_name));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,290,45);
		if(flg == 1){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Can not open file !!! ***",strlen("*** Can not open file !!! ***"));
		}
		if(flg == 2){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Now saving !!! ***",strlen("*** Now saving !!! ***"));
		}
		if(flg == 3){
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Bad work directory !!! ***",strlen("*** Bad work directory !!! ***"));
		}
		break;
	case 3:
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"<< File Directory >>",
		strlen("<< File Directory >>"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,file_path,
		strlen(file_path));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,400,45);
		break;
	case 4:
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"<< Working Directory >>",
		strlen("<< Working Directory >>"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,work_path,
		strlen(work_path));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,400,45);
		break;
	default:
		break;
	}
	if(invert_num > 0){
		draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,400,24,
		13,65," ");
	}
}

/*------------------------------------------------------------

  Function : file_menu_act(char *,int)

-------------------------------------------------------------*/
file_menu_act(text_buffer,invert_num)
char *text_buffer;
int invert_num;
{
	FILE *fp;
	int c,cnt,part,pnum,space_flg;
	double x[3],r1,minus;
	char tmp_file[60];

	switch(invert_num){
	case 0:
		break;

	case 1: /* open */
		strcpy(file_name,text_buffer);
		strcpy(tmp_file,file_path);
		strcat(tmp_file,file_name);
		get_data(tmp_file);
		break;

	case 2: /* save */
		strcpy(file_name,text_buffer);
		strcpy(tmp_file,work_path);
		strcat(tmp_file,file_name);
		write_data(tmp_file);
		break;

	case 3:
		strcpy(file_path,text_buffer);
		show_file_menu(3,0);
		break;

	case 4:
		strcpy(work_path,text_buffer);
		show_file_menu(4,0);
		break;

	default:
		break;
	}
}

/*------------------------------------------------------------

  Function : write_data(char *)

-------------------------------------------------------------*/
write_data(text_buffer)
char *text_buffer;
{

	FILE *fp;
	int c,cnt,part,pnum;
	double x[3],r1,minus;

	fp = fopen(text_buffer,"w+");
	if(fp == 0){
		show_file_menu(2,3);
	}                      
	else{ 
		show_file_menu(2,2);
		cnt = 0;
		while(plane[cnt].r >0.0){
			fprintf(fp,"%d (%f,%f,%f)\n",plane[cnt].side,plane[cnt].x,plane[cnt].y,plane[cnt].z);
			cnt++;
		}
		fclose(fp);
	}
}

/*------------------------------------------------------------

  Function : get_data(char *)

-------------------------------------------------------------*/
get_data(text_buffer)
char *text_buffer;
{

	FILE *fp;
	double r1;
	HPlane *pln_pt;
	float x,y,z;
	int side,ret;
	int err_cnt = 0;
	char  buf[100];

	fp = fopen(text_buffer,"r");
	if(fp == 0){
		show_file_menu(1,1);
	}                      
	else{ 
		total_plane = 0;
		show_file_menu(1,2);
		init_plane();
		pln_pt = &plane[0];
		while(fgets(buf,100,fp)!=NULL){
			if((buf[0] == '0')||(buf[0] =='2')){
				ret = sscanf(buf,"%d (%f,%f,%f)",&side,&x,&y,&z);
				if(ret == 4){
					r1 = pow(x,2.0)+pow(y,2.0)+pow(z,2.0) - 1.0;
					if(r1>0.0){
						total_plane++;
						pln_pt->x = (double)x;
						pln_pt->y = (double)y;
						pln_pt->z = (double)z;
						pln_pt->side = side;
						pln_pt->r = sqrt(r1);
						pln_pt++;
					}
					else{
						err_cnt++;
					}
				}
			}
		}
		fclose(fp);
		if(err_cnt != 0){
			show_file_menu(1,3);
		}                      
		clear_task();
		if(search_cross()==FALSE){
			show_file_menu(1,4);
		}
		show_object(0);
	}
}            

