/***************************************************************************
* This is a simple program to create Julia set images of  
*   Z^2+C
*   C*SINZ
*   C*COSZ
*   C*EXPZ
*   and Mandelbrot set images.
*   The output file is in GIF format....
*                           (C)1992 Massimo Casal
*                  email:casal@udmi5400.cineca.it
***************************************************************************/

int width,height; /*resolution*/
float xm,ym,xx,yx;  /* x and y limits*/ 
float creal,cimag; 
char *file[20],*pal[20];
int f;

calc(xp,yp) 
int xp,yp;
{
 switch(f)  { 
      case 0:
             return(mandel(xp,yp,xm,ym,xx,yx,creal,cimag,width,height));
      case 1:
             return(julia(xp,yp,xm,ym,xx,yx,creal,cimag,width,height));
      case 2:
             return(jsin(xp,yp,xm,ym,xx,yx,creal,cimag,width,height));
      case 3:
             return(jcos(xp,yp,xm,ym,xx,yx,creal,cimag,width,height));
      case 4:
             return(jexp(xp,yp,xm,ym,xx,yx,creal,cimag,width,height));
  }  
}

main(argc,argv)   
int argc;
char *argv[];
{
   int backgr,interlaced,bites;
   int r[256],g[256],b[256];
   int ck1,ck2; /*checks*/
ck1=rd(argc,argv,file,pal,&width,&height,&creal,&cimag,&xm,&xx,&ym,&yx,&f);
   ck2= createpalette(r,g,b,pal);
   if (ck1==4 && ck2!=-1) 
   {backgr = 0;
   interlaced=0; /*1 if u want an interlaced GIF*/   
   bites=8;
   GIFEncode(*file,width,height,interlaced,backgr,bites,r,g,b,calc); 
   }
  else 
   {printf("Usage:%s -mjsce -x xres -y yres -r creal -i cimag\n",argv[0]);
    printf("      [-x1] [-x2] [-y1] [-y2] [-o output] [-p palette]\n");     
    printf("params in [] are optional\n");}
    printf("\n");
 }
 
