/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) 1991 Andrew Marriott.
 */

#include "interface.h"
#include <signal.h>

static void set_stop(obj,value)
FL_OBJECT *obj;
long value;
{
int i;	
	for(i=0;i<MAX_PARAMETERS;i++)
		final_parameters[i] = parameter[i].value;

	number_of_changed_parameters=0;
	for(i=0;i<MAX_PARAMETERS;i++)
	{
		if(initial_parameters[i] == parameter[i].value)
			continue;
		parameters_which_changed[number_of_changed_parameters++] =i;

	}

}

static void set_start(obj,value)
FL_OBJECT *obj;
long value;
{
int i;
	for(i=0;i<MAX_PARAMETERS;i++)
		initial_parameters[i] = parameter[i].value;

	fl_set_call_back(start_stop_button,set_stop, (long)-1);
	fl_set_object_label(start_stop_button,"FINAL");
}

FL_OBJECT *create_animate_input()
{
FL_OBJECT  *but;
	animate_input = fl_bgn_form(FL_SHADOW_BOX,CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT);
	  but = fl_add_input(INPUT_TYPE,0.0,0.0,
		CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"");
	  fl_set_object_align(but,FL_ALIGN_LEFT);
	  fl_set_input(but,"50.0");
	fl_end_form();

	return(but);
}
static void animate(obj,value)
FL_OBJECT *obj;
long value;
{
static FL_OBJECT *but;
static FL_OBJECT *obj;
float min,max,value;
int i,result;

	if(!animate_input ) but=create_animate_input();

	fl_set_form_position(animate_input,(int)(animate_x),(int)animate_y);
	fl_show_form(animate_input,FL_PLACE_POSITION,FALSE,NULL);

	do { obj = fl_do_forms(); }  while (obj != but);
	fl_hide_form(animate_input);
	fl_set_object_label(animate_button,"STOP");
	fl_set_call_back(animate_button,NULL, (long)-1);

	result=sscanf(fl_get_input(obj),"%f",&value);
	if(result !=1)
		fl_show_message("Not a floating point value","","");
	else if(value == 0.0) ; /* do nothing */
	else
	{
	int frame;
	static int increasing = 1;
		obj=NULL;
		while (obj==NULL)
		{
			for(frame=0;;)
			{
			float lambda = (frame)/value;
				for(i=0;i<number_of_changed_parameters;i++)
				{
				register int index=parameters_which_changed[i];
					parameter[index].value = lambda*final_parameters[index]+
 										(1.0-lambda)*initial_parameters[index];
					parameter[index].changed=1;
				}
				update_face_display();/**/
/*				display_face();/**/
				obj=fl_check_forms();
				if(obj==animate_button)break;

        			if(increasing)frame++;
        			else frame--;
        			if(frame>=value)increasing=0;
        			if(frame<=0)increasing=1;
			}
		}
	}

	fl_set_call_back(start_stop_button,set_start, (long)-1);
	fl_set_object_label(start_stop_button,"INITIAL");
	fl_set_call_back(animate_button,animate, (long)-1);
	fl_set_object_label(animate_button,"ANIMATE");
}

static void print();
static int allow_print()
{
	fl_set_object_label(print_button,"PRINT");
	fl_set_call_back(print_button,print, (long)-1);
}

static void ignore_print(obj,value)
FL_OBJECT *obj;
long value;
{
	/* do nothing */
}

static void print(obj,value)
FL_OBJECT *obj;
long value;
{
	fl_set_object_label(print_button,"WAIT");
	savescreen("/tmp/lp",(int)FACE_START_X,(int)(FACE_END_X),
			     (int)FACE_START_Y,(int)(FACE_END_Y));
	system("tops /tmp/lp |lpr -Plwc &");
	fl_set_call_back(print_button,ignore_print, (long)-1);
	signal(SIGALRM,allow_print);
	alarm(120);
	fl_set_object_label(print_button,"");
}
FL_OBJECT *create_browser()
{
FL_OBJECT *br, *but, *obj;
	browser = fl_bgn_form(FL_BORDER_BOX,BROWSER_WIDTH,BROWSER_HEIGHT);
	  but = fl_add_button(FL_NORMAL_BUTTON,0.0,0.0,BROWSER_WIDTH,CONTROL_BUTTON_HEIGHT,"Press here when done");
	  br = fl_add_browser(FL_NORMAL_BROWSER,0.0,CONTROL_BUTTON_HEIGHT+FIELD_GAP,
	      BROWSER_WIDTH,
	      BROWSER_HEIGHT-CONTROL_BUTTON_HEIGHT-2*FIELD_GAP,"");
	fl_end_form();

	if (! fl_load_browser(br,"fascia.hlp",""))
	{
		fl_show_message("Cannot open help file ","fascia.hlp","Sorry");
		return(NULL);
	}
	fl_insert_browser_line(br,1,
	   "                                                     FASCIA HELP PAGE");
	fl_insert_browser_line(br,2,
	   "==============================================================");
	fl_insert_browser_line(br,3,
	   "                  Parameterised face model Copyright Frederic Parke. 10 May 90");
	fl_insert_browser_line(br,4,
	   "                       Fascia interface Copyright Andrew Marriott. 10 Sep 91");
	fl_insert_browser_line(br,5,
	   "                                                      Public Domain code.");
	fl_insert_browser_line(br,6,
	   "==============================================================");

  return(but);
}

static void help(obj,value)
FL_OBJECT *obj;
long value;
{
static FL_OBJECT *but;
	if(!browser ) but=create_browser();
	if(!but) return;

	fl_set_form_position(browser,BROWSER_WINDOW_X,BROWSER_WINDOW_Y);
	fl_show_form(browser,FL_PLACE_POSITION,TRUE,"Fascia Help.");
	do { obj = fl_do_forms(); }  while (obj != but);
	fl_hide_form(browser);
}
static void input_field_update(obj,index)
FL_OBJECT *obj;
long index;
{
char temp[20];
	sprintf(temp,"%*.*lf",SLIDER_PRECISION+2,SLIDER_PRECISION,
	   parameter[index].value);
	fl_set_input(obj,temp);
	parameter[index].changed=1;
}

void field_update(index)
int index;
{
	input_field_update(input_obj[index],index);
	fl_set_slider_bounds(slider_obj[index],parameter[index].min,parameter[index].max);
	fl_set_slider_value(slider_obj[index],parameter[index].value);
}

static void reset_all(obj,index)
FL_OBJECT *obj;
long index;
{
int i;
	for(i=0;i<MAX_PARAMETERS;i++)
	   if(parameter[i].box_label)
	   {
		parameter[i].value=parameter[i].original;
		field_update(i);
	   }
	update_face_display();

}

static void psave_params(obj,value)
FL_OBJECT *obj;
long value;
{
char *filename;
#ifdef OPENDAY
	fl_show_message("What! On openday","You have to be kidding","and let you run amuck? No way.");
	return;
#endif
	filename = fl_show_file_selector("Param Save file?",".","*.prm","save.prm");
	if(filename== NULL) return;
	save_params_file(filename);

}

static void prestore_params(obj,value)
FL_OBJECT *obj;
long value;
{
char *filename;
	filename = fl_show_file_selector("Param Restore file?",".","*.prm","default.prm");
	if(filename== NULL) return;
	if(read_params_file(filename))
/*		reset_all(obj,value); */
		update_face_display();
}

static void dsave_params(obj,value)
FL_OBJECT *obj;
long value;
{
char *filename;
#ifdef OPENDAY
	fl_show_message("What! On openday","You have to be kidding","and let you run amuck? No way.");
	return;
#endif
	filename = fl_show_file_selector("Data Save file?",".","*.dta","save.dta");
	if(filename== NULL) return;
	update_face_display();
}

static void drestore_params(obj,value)
FL_OBJECT *obj;
long value;
{
char *filename;
#ifdef OPENDAY
	fl_show_message("What! On openday","You have to be kidding","and let you run amuck? No way.");
	return;
#endif
	filename = fl_show_file_selector("Data Restore file?",".","*.dta","save.dta");
	if(filename== NULL) return;
printf("File requested is %s\n",filename);
	update_face_display();
}

static void toggle_wire(obj,value)
FL_OBJECT *obj;
long value;
{
	wire= !wire;
	if(wire)fl_set_object_label(obj,"SHADED");
	else 	fl_set_object_label(obj,"WIRE");
	parameter[8].changed=1;       /* simply to force redraw of all objects. */
	open_window(1);
	update_face_display();
}

static void push_off(obj,value)
FL_OBJECT *obj;
long value;
{
#ifdef OPENDAY
	fl_show_message("What! On openday","You have to be kidding","and let you run amuck? No way.");
	return;
#endif
	winset(face_window); winpush();
	winset(form_window);winpush();
 
}

static void pop_off(obj,value)
FL_OBJECT *obj;
long value;
{
	winset(form_window);winpop();
	winset(face_window); winpop();
}

static void piss_off(obj,value)
FL_OBJECT *obj;
long value;
{
#ifdef OPENDAY
	fl_show_message("What! On openday","You have to be kidding","and let you run amuck? No way.");
	return;
#endif
	if (fl_show_question("Do you really want to Quit?","",""))
		exit(0);
}

static void slider_changed(obj,index)
FL_OBJECT *obj;
long index;
{
	parameter[index].value = fl_get_slider_value(obj);
	input_field_update(input_obj[index],index);

	if(index <=MAX_FACE_PARAMETER)
		update_face_display();
	else
		display_face();
}

static void visibility_changed(obj,index)
FL_OBJECT *obj;
long index;
{
int opposite;
	if(fl_get_button(obj))
		opposite=1;
	else
		opposite=0;

	if(index==FLESH )
		object_is_visible[index]=opposite;
	else if(index==LIPS )
		object_is_visible[index]=opposite;
	else if(index==EYELASH )
		object_is_visible[index]=opposite;
	else if(index==TEETH )
		object_is_visible[index]=opposite;
	else if(index==PUPIL )
	{
		object_is_visible[PUPIL]=opposite;
		object_is_visible[IRIS]=opposite;
		object_is_visible[FRINGE]=opposite;
		object_is_visible[EYEWHITE]=opposite;
	}
	update_face_display();
}

static void reset_to_default(obj,index)
FL_OBJECT *obj;
long index;
{
	parameter[index].value=parameter[index].original;
	fl_set_slider_value(slider_obj[index],parameter[index].value);
	input_field_update(input_obj[index],index);
	if(index <=MAX_FACE_PARAMETER)
		update_face_display();
	else
		display_face();
}

static void input_changed(obj,index)
FL_OBJECT *obj;
long index;
{
float min,max,value;
int result;
	fl_get_slider_bounds(slider_obj[index],&min,&max);
	result=sscanf(fl_get_input(obj),"%f",&value);
/*printf("Value is %f, min,max = %f,%f\n",value,min,max);/**/
	if(result !=1)
	{
		parameter[index].value = fl_get_slider_value(obj);
		input_field_update(input_obj[index],index);
		fl_show_message("Not a floating point value","","");
	}
/*
	else if((value<min) || (value>max))
	{
		parameter[index].value = fl_get_slider_value(obj);
		input_field_update(input_obj[index],index);
		fl_show_message("Not within range","","");
	}
*/
	else
	{
		parameter[index].value=value;
		fl_set_slider_value(slider_obj[index],parameter[index].value);
		parameter[index].changed=1;
		if(index <=MAX_FACE_PARAMETER)
			update_face_display();
		else
			display_face();
	}
}
static int make_visibility_controls(base_x,base_y)
double base_x,base_y;
{
FL_OBJECT *obj;
double bbase_x;
int i;

	for(i=0;i<MAX_FEATURES;i++)
		object_is_visible[i] = 1;

	base_x += FORM_BASE_X; base_y += FORM_BASE_Y;
	bbase_x= base_x;

	(void)fl_add_box(BOX_TYPE, base_x,base_y, 2*BOX_WIDTH,BOX_HEIGHT,"");

    /* FLESH */
	obj=fl_add_lightbutton(BUTTON_TYPE_DISPLAY,
	   base_x,base_y+EDGE_GAP,
	   BUTTON_WIDTH_DISPLAY,BUTTON_HEIGHT,"");
	fl_set_call_back(obj,visibility_changed, (long)FLESH);
	fl_set_button(obj,1);
	fl_set_object_label(obj,"FLESH");
	base_x+=BUTTON_WIDTH_DISPLAY+FIELD_GAP;;

    /* LIPS */
	obj=fl_add_lightbutton(BUTTON_TYPE_DISPLAY,
	   base_x,base_y+EDGE_GAP,
	   BUTTON_WIDTH_DISPLAY,BUTTON_HEIGHT,"");
	fl_set_call_back(obj,visibility_changed, (long)LIPS);
	fl_set_button(obj,1);
	fl_set_object_label(obj,"LIPS");
	base_x+=BUTTON_WIDTH_DISPLAY+FIELD_GAP;;

    /* EYELASH */
	obj=fl_add_lightbutton(BUTTON_TYPE_DISPLAY,
	   base_x,base_y+EDGE_GAP,
	   BUTTON_WIDTH_DISPLAY,BUTTON_HEIGHT,"");
	fl_set_call_back(obj,visibility_changed, (long)EYELASH);
	fl_set_button(obj,1);
	fl_set_object_label(obj,"BROW");
	base_x+=BUTTON_WIDTH_DISPLAY+FIELD_GAP;;

    /* TEETH */
	obj=fl_add_lightbutton(BUTTON_TYPE_DISPLAY,
	   base_x,base_y+EDGE_GAP,
	   BUTTON_WIDTH_DISPLAY,BUTTON_HEIGHT,"");
	fl_set_call_back(obj,visibility_changed, (long)TEETH);
	fl_set_button(obj,1);
	fl_set_object_label(obj,"TEETH");
	base_x+=BUTTON_WIDTH_DISPLAY+FIELD_GAP;;

    /* EYES */
	obj=fl_add_lightbutton(BUTTON_TYPE_DISPLAY,
	   base_x,base_y+EDGE_GAP,
	   BUTTON_WIDTH_DISPLAY,BUTTON_HEIGHT,"");
	fl_set_call_back(obj,visibility_changed, (long)PUPIL);
	fl_set_button(obj,1);
	fl_set_object_label(obj,"EYES");
	base_x+=BUTTON_WIDTH_DISPLAY+FIELD_GAP;;

}
static int make_controls(base_x,base_y)
double base_x,base_y;
{
FL_OBJECT *obj;
double bbase_x;

	base_x += FORM_BASE_X; base_y += FORM_BASE_Y;
	bbase_x= base_x;

	(void)fl_add_box(BOX_TYPE, base_x,base_y, 2*BOX_WIDTH,BOX_HEIGHT,"");

    /* EXIT */
	exit_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"EXIT");
	fl_set_call_back(exit_button,piss_off, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

   /* WIRE */
	wire_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT," WIRE ");
	if(wire)	fl_set_object_label(wire_button,"SHADED");
	else 		fl_set_object_label(wire_button,"WIRE");
	fl_set_call_back(wire_button,toggle_wire, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* PARAM SAVE */
	psave_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"Save Params");
	fl_set_call_back(psave_button,psave_params, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* PARAM LOAD */
	prestore_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"Load Params ");
	fl_set_call_back(prestore_button,prestore_params, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* DATA SAVE */
	dsave_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"Save Data");
	fl_set_call_back(dsave_button,dsave_params, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* DATA LOAD */
	drestore_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"Load Data ");
	fl_set_call_back(drestore_button,drestore_params, (long)-1);
	base_x = bbase_x; base_y+= CONTROL_BUTTON_HEIGHT+FIELD_GAP;
 /* MOVE UP TO NEXT ROW */
  /* PUSH */
	push_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"PUSH");
	fl_set_call_back(push_button,push_off, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* HELP */
	help_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"HELP");
	fl_set_call_back(help_button,help, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* RESET ALL */
	reset_all_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"Reset all");
	fl_set_call_back(reset_all_button,reset_all, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* START/STOP ANIMATION */
	start_stop_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"");
	fl_set_call_back(start_stop_button,set_start, (long)-1);
	fl_set_object_label(start_stop_button,"INITIAL");
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* ANIMATE */
	animate_x=base_x;animate_y=base_y;
	animate_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"ANIMATE");
	fl_set_call_back(animate_button,animate, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

  /* PRINT */
	print_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			CONTROL_BUTTON_WIDTH,CONTROL_BUTTON_HEIGHT,"PRINT");
	fl_set_call_back(print_button,print, (long)-1);
	base_x+= CONTROL_BUTTON_WIDTH+FIELD_GAP;

 /* BOTH SIDES OF FORM WINDOW */
  /* POP */
	base_x= FORM_WINDOW_X; base_y=FORM_WINDOW_Y;
	pop_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			FORM_BASE_X-FORM_WINDOW_X,FORM_HEIGHT,"POP");
	fl_set_call_back(pop_button,pop_off, (long)-1);
	base_x= FORM_BASE_X +4*BOX_WIDTH; base_y=FORM_WINDOW_Y;

	pop_button=fl_add_button(FL_NORMAL_BUTTON,
	   		base_x,base_y,
			FORM_WIDTH-base_x,FORM_HEIGHT,"POP");
	fl_set_call_back(pop_button,pop_off, (long)-1);

}
static int make_button(i,base_x,base_y)
int i;
double base_x,base_y;
{
FL_OBJECT *obj;

	if(!parameter[i].box_label) return(0);  /* Ignore null params */
	if(i>=MAX_PARAMETERS) return(2);        /* Ignore if gone too far.*/

	base_x += FORM_BASE_X; base_y += FORM_BASE_Y;

	(void)fl_add_box(BOX_TYPE, base_x,base_y, BOX_WIDTH,BOX_HEIGHT,"");

	slider_obj[i]=obj=fl_add_slider(SLIDER_TYPE,
	   base_x+SLIDER_START_X /*+INPUT_WIDTH+FIELD_GAP*/,
	   base_y+BOX_HEIGHT-SLIDER_HEIGHT-EDGE_GAP,
	   SLIDER_WIDTH,SLIDER_HEIGHT,"");
	fl_set_slider_bounds(obj,parameter[i].min,parameter[i].max);
	parameter[i].value=parameter[i].original;
	fl_set_slider_value(obj,parameter[i].value);
	fl_set_slider_precision(obj,SLIDER_PRECISION);
	fl_set_call_back(obj,slider_changed, (long)i);

	base_x+=START_X;
	input_obj[i]=obj=fl_add_input(INPUT_TYPE,
	   base_x,
	   base_y+EDGE_GAP,/**/
	   INPUT_WIDTH,INPUT_HEIGHT,"");
	fl_set_object_align(obj,FL_ALIGN_LEFT);
	input_field_update(input_obj[i],i);
	fl_set_call_back(obj,input_changed, (long)i);
	base_x+=INPUT_WIDTH+FIELD_GAP;;

	obj=fl_add_button(BUTTON_TYPE_RESET,
	   base_x, base_y+EDGE_GAP,
	   BUTTON_WIDTH_RESET,BUTTON_HEIGHT,"Reset");
	fl_set_call_back(obj,reset_to_default, (long)i);
	base_x+=BUTTON_WIDTH_RESET+FIELD_GAP;;

	(void)fl_add_text(TEXT_TYPE,
	   base_x , base_y+EDGE_GAP,
	   TEXT_WIDTH,TEXT_HEIGHT,parameter[i].box_label);

	return(1);
}
void make_form()
{
int col,i;
double base_x,base_y;

	form = fl_bgn_form(FORM_TYPE,FORM_WIDTH,FORM_HEIGHT);
	   for(i=1,base_x=0,base_y=0;base_y<20*BOX_HEIGHT;i++)
	  	if(make_button(i,base_x,base_y)==1) base_y+=BOX_HEIGHT;

	   for(base_x=3*BOX_WIDTH,base_y=0;base_y<20*BOX_HEIGHT;i++)
	  	if(make_button(i,base_x,base_y)==1) base_y+=BOX_HEIGHT;

	   for(col=1,base_x=BOX_WIDTH,base_y=0;
		((base_y<5*BOX_HEIGHT) && (i<=MAX_PARAMETERS));
			i++)
	   {
	  	if(col==1)
		{
			if(make_button(i,base_x,base_y)==1)
			{
				col=2;base_x += BOX_WIDTH;
			}
		}
	  	else
			if(make_button(i,base_x,base_y)==1)
			{
				col=1;
				base_y+=BOX_HEIGHT;
				base_x=BOX_WIDTH;
			}
	  }
	  make_controls(base_x,base_y);
	  base_y+=BOX_HEIGHT;
	  make_visibility_controls(base_x,base_y);
 /**/

	fl_end_form();
}

void draw_form()
{
	if(!forkflg)
		foreground();
	fl_set_form_position(form,FORM_WINDOW_X,FORM_WINDOW_Y);
	form_window=fl_show_form(form,FL_PLACE_POSITION,FALSE,NULL);
}
