#ident "%W%" %G%
 
/**************************************************************************
# Copyright (C) 1994 Kubota Graphics Corp.
# 
# Permission to use, copy, modify, and distribute this material for
# any purpose and without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies, and that the name of Kubota Graphics not be used in
# advertising or publicity pertaining to this material.  Kubota
# Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
# OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
# "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
# EXPRESS OR IMPLIED.
**************************************************************************/
 
/*
  ======================================================================
  Functions:
	int ddr_vll_return_functions (type, fcns)
	void ddr_vll_install_driver (name)

  ======================================================================
 */
#include "internal/dogen.h"
#include "dore_develop/develop.h"
/*
 ======================================================================
 */
ddr_vll_return_functions(type, fcns)
	DtInt type;
	DtPtr *fcns;
{
    extern DtPtr ddr_vll_return_DCM_fcns();
    extern DtPtr ddr_vll_return_PROM_fcns();
    extern DtPtr ddr_vll_return_DROM_fcns();
    extern DtPtr ddr_vll_return_DROM_methods();

    switch (type) {
    case DDc_DCM:
	*fcns = ddr_vll_return_DCM_fcns();
	break;

    case DDc_PROM:
	*fcns = ddr_vll_return_PROM_fcns();
	break;

    case DDc_DROM:
	*fcns = ddr_vll_return_DROM_fcns();
	break;

    case DDc_DROMMethods:
	*fcns = ddr_vll_return_DROM_methods();
	break;

    default:
	*fcns = (DtPtr) 0;
	break;
    }
}
/*
 ======================================================================
 */
void
ddr_vll_install_driver (name)
	DtPtr name;
{
    extern void ddr_vll_drom_new_class();

    DDdevice_InstallDriver
	    ((name == DcNullPtr) ? (DtPtr)"vll" : name,
	     (DtPtr)"VLL Device Driver",
	     (DtPFI)ddr_vll_return_functions);

    DDclass_AddNotify ((DtPFI)ddr_vll_drom_new_class);
}
/*
 ======================================================================
 */
