/*
# proc: black_pixel_count - returns the total number of pixels in a binary
# proc:                     image with value equal to one.
*/


/************************************************************/
/*         File Name: Pixels.c                              */
/*         Package:   Pixel Level Utilities                 */
/*                                                          */
/*         Contents:  Black_Pixel_Count()                   */
/************************************************************/
#include <stdio.h>
#include <masks.h>
#include <bits.h>
#include <histgram.h>

/************************************************************/
int black_pixel_count(bimage, width, height)
unsigned char *bimage;
int width, height;
{
   FILE *fp;
   short *lut;
   int black_pixels = 0;
   int i, nbytes;

   if((fp = fopen(BITLUT, "r")) == NULL)
      syserr("black_pixel_count", "fopen", BITLUT);
   if((lut = (short *)malloc(LUTLEN * sizeof(short))) == NULL)
      syserr("black_pixel_count", "malloc", "lut");
   fread(lut, sizeof(short), LUTLEN, fp);
   fclose(fp);
   nbytes = SizeFromDepth(width, height, 1);
   for(i = 0; i < nbytes; i++)
       black_pixels += lut[bimage[i]];
   free(lut);
   return(black_pixels);
}
