/*** FILE "fnd.h" ************************************************** 290493 ***/
#ifndef _fnd_h_
#define _fnd_h_

#include <limits.h>

/*** n8, z8, n16, z16, n32, z32, ... ******************************************/

#if !(defined EXACT_MATCH) && !(defined BEST_MATCH)
#define EXACT_MATCH
#endif

/* The unsigned integer types nX are guaranteed to cover 0..2^X-1,
 * the signed integer types zX are guaranteed to cover -2^X..2^X-1!
 */

#ifdef EXACT_MATCH

/******************************************************************************/
/** EXACT MATCH:                                                             **/
/** -only exact matches for the integer types are acceptable:                **/
/******************************************************************************/

/* n8: */
#if UCHAR_MAX!=255
#error "fnd.h: Maximum unsigned char differs from 255!"
#else
typedef unsigned char      n8;                       //0..255
#endif

#define N8_WIDTH 8

/* n16: */
#if USHRT_MAX==65535
typedef unsigned short int n16;                      //0..65535
#elif UINT_MAX==65535
typedef unsigned int       n16;
#elif ULONG_MAX==65535
typedef unsigned long int  n16;
#else
#error "fnd.h: Unable to find exact match for integer-type n16!"
#endif

/* n32: */
#if USHRT_MAX==4294967295LU
typedef unsigned short int n32;                      //0..4294967295
#elif UINT_MAX==4294967295LU
typedef unsigned int       n32;
#elif ULONG_MAX==4295967295LU
typedef unsigned long int  n32;
#else
#error "fnd.h: Unable to find exact match for integer-type n32!"
#endif

/* Define the size of a word (this definition should always come directly after
 * the definition of the biggest nX type!):
 */
#define WORD_WIDTH 32

/* z8: */
#if SCHAR_MIN!=-128
#error "fnd.h: Minimum signed char differs from -128!"
#endif
#if SCHAR_MAX!=127
#error "fnd.h: Maximum signed char differs from 127!"
#endif
typedef signed char        z8;                       //-128..127

#define Z8_WIDTH 8

/* z16: */
#if SHRT_MIN==-32768 && SHRT_MAX==32767
typedef signed short int   z16;                      //-32768..32767
#elif INT_MIN==-32768 && INT_MAX==32767
typedef signed int         z16;
#elif LONG_MIN==-32768 && LONG_MAX==32767
typedef signed long int    z16;
#else
#error "fnd.h: Unable to find exact match for integer-type z16!"
#endif

/* z32: */
#if SHRT_MIN==-2147483648LU && SHRT_MAX==2147483647LU
typedef signed short int   z32;                      //-2147483648..2147483647
#elif INT_MIN==-2147483648LU && INT_MAX==2147483647LU
typedef signed int         z32;
#elif LONG_MIN==-2147483648LU && LONG_MAX==2147483647LU
typedef signed long int    z32;
#else
#error "fnd.h: Unable to find exact match for integer-type z32!"
#endif

#else

/******************************************************************************/
/** BEST MATCH:                                                              **/
/** -the smallest, wide enough, matches for the integer types are wanted:    **/
/******************************************************************************/

/* n8: */
#if UCHAR_MAX!=255
#error "fnd.h: Maximum unsigned char differs from 255!"
#else
typedef unsigned char      n8;                       //0..255
#endif

#define N8_WIDTH CHAR_BIT

/* n16: */
#if USHRT_MAX>=65535
typedef unsigned short int n16;                      //0..65535
#elif UINT_MAX>=65535
typedef unsigned int       n16;
#elif ULONG_MAX>=65535
typedef unsigned long int  n16;
#else
#error "fnd.h: Unable to match integer-type n16!"
#endif

/* n32: */
#if USHRT_MAX>=4294967295L
typedef unsigned short int n32;                      //0..4294967295
#elif UINT_MAX>=4294967295L
typedef unsigned int       n32;
#elif ULONG_MAX>=4295967295L
typedef unsigned long int  n32;
#else
#error "fnd.h: Unable to match integer-type n32!"
#endif

/* Define the size of a word (this definition should be kept inside/next to
 * the definition of the n32/n64/n128 types!):
 */
#define WORD_WIDTH 32

/* z8: */
#if SCHAR_MIN!=-128
#error "fnd.h: Minimum signed char differs from -128!"
#endif
#if SCHAR_MAX!=127
#error "fnd.h: Maximum signed char differs from 127!"
#endif
typedef signed char        z8;                       //-128..127

#define Z8_WIDTH CHAR_BIT

/* z16: */
#if SHRT_MIN<=-32768 && SHRT_MAX>=32767
typedef signed short int   z16;                      //-32768..32767
#elif INT_MIN<=-32768 && INT_MAX>=32767
typedef signed int         z16;
#elif LONG_MIN<=-32768 && LONG_MAX>=32767
typedef signed long int    z16;
#else
#error "fnd.h: Unable to match integer-type z16!"
#endif

/* z32: */
#if SHRT_MIN<=-2147483648LU && SHRT_MAX>=2147483647L
typedef signed short int   z32;                      //-2147483648..2147483647
#elif INT_MIN<=-2147483648LU && INT_MAX>=2147483647L
typedef signed int         z32;
#elif LONG_MIN<=-2147483648LU && LONG_MAX>=2147483647L
typedef signed long int    z32;
#else
#error "fnd.h: Unable to match integer-type z32!"
#endif

#endif

/*** word *********************************************************************/

#if WORD_WIDTH==128
  typedef n128               word;
#elif WORD_WIDTH==64
  typedef n64                word;
#elif WORD_WIDTH==32
  typedef n32                word;
#else
#error "fnd.h: Unable to match integer type word!"
#endif

/*** n1, n24 ******************************************************************/

/* The following types are meant to be used, when it should be clear, which
 * interval the type is meant to cover! Do notice the waste!
 */
typedef n8                 n1;                       //0,1 (boolean)
typedef n32                n24;                      //0..16777215

/*** NULL *********************************************************************/

#ifndef NULL
#define NULL ((void*)0)
#endif

/*** Abs **********************************************************************/

template<class X>
X Abs(X a)
{ return (a<0)?-a:a;
}

/*** Min, Max, Align **********************************************************/

template<class X>
X Min(X a, X b)
{ return (a<b)?a:b;
}

template<class X>
X Max(X a, X b)
{ return (a<b)?b:a;
}

template<class X>
X Align(X a, X b, X c)
{ if (b>=c)
    return c;
  else
    if (b<=a)
      return a;
    else
      return b;
}

/*** Swap *********************************************************************/

template<class X>
void Swap(X& a, X& b)
{ X tmp;
  tmp=a;
  a=b;
  b=tmp;
}

/*** COPYPROTECT **************************************************************/

#define COPYPROTECT(Class_name)\
        private:\
          Class_name(Class_name&);\
          void operator =(Class_name&);

#endif
/******** "fnd.h" *************************************************************/

