/*	ScianMainWindow.c
  	Title Window routines

	Jim Lyons

  	3/15/90  original version by Eric Pepke
	11/5/90  modified to add title screen (JL)
	9/6/91   added help (EP)
	9/10/91  completely rewritten to make title window an ObjWindow (JL)
	10/30/91 redesigned to use ScianTitleFont w/logos
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianWindows.h"
#include "ScianObjWindows.h"
#include "ScianEvents.h"
#include "ScianColors.h"
#include "ScianControls.h"
#include "ScianTextBoxes.h"
#include "ScianIcons.h"
#include "ScianIDs.h"
#include "ScianStyle.h"
#include "ScianHelp.h"

#define MWWIDTH		520
#define MWHEIGHT	376
#define TOPOFTITLE	MWHEIGHT - MAJORBORDER
#define TOPOFSUBTITLE	TOPOFTITLE - 68
#define TOPOFINST	138
#define LEFTOFINST	80
#define TOPOFDISCLAIMER	60

#define TOPOFUNIV	124
#define TOPOFTORCH	176
#define UNIVFONTCOLOR	UIRED
#define TORCHCOLOR	UIGOLD

#define TITLEFONTNAME	"ScianTitle"
#define TITLEFONTSIZE	56
#define TITLEFONTCOLOR	UIBLUE

#define SUBTITLEFONTNAME	"Palatino18"
#define SUBTITLEFONTSIZE	18
#define SUBTITLEFONTCOLOR	UITEXT
#define SUBTITLELINESPACE	2

#define DISCLAIMERFONTNAME	"TimesRoman"
#define DISCLAIMERFONTSIZE	11
#define DISCLAIMERFONTCOLOR	UITEXT
#define DISCLAIMERLINESPACE	4

#ifndef PLAIN
#define PLAIN	0
#endif

static ObjPtr MainWindowClose(theWindow)
WinInfoPtr theWindow;
/* close title window */
{
	if (theWindow -> mainMenu)
	{
		DeleteMenus(theWindow);
	}
	theWindow -> mainMenu = 0;
	return ObjTrue;
}

static ObjPtr MainWindowPress(theInfo, flags)
WinInfoPtr theInfo;
long flags;
/* Press in the title window brings up help window */
{
#ifdef INTERACTIVE
	if (TOOL(flags) == T_HELP)
	{
		ContextHelp((ObjPtr) theInfo);
	}
	else
	{
		DoShowHelp();
	}
#endif
	return NULLOBJ;
}

void MainWindow()
/* Create the title window */
{
	WinInfoPtr winInfo;
	ObjPtr contents, panel, textbox;

	winInfo = NewObjWindow(windowClass, "SciAn", WINDBUF + WINFIXEDSIZE + WINCENTERED, 
			MWWIDTH, MWHEIGHT, MWWIDTH, MWHEIGHT);

	if (winInfo)
	{
		SetVar((ObjPtr) winInfo, HELPSTRING,
			NewString("This is the title window of SciAn.\n"));
		SetMethod((ObjPtr) winInfo, CLOSE, MainWindowClose);
		SetMethod((ObjPtr) winInfo, PRESS, MainWindowPress);

		contents = GetVar((ObjPtr) winInfo, CONTENTS);

		/* put in panel */
		panel = NewPanel(greyPanelClass, 0, MWWIDTH, 0, MWHEIGHT);
		PrefixList(contents, panel);
		SetVar(panel, PARENT, (ObjPtr) winInfo);
		SetVar(panel, BACKGROUND, NewInt(UIWHITE));

		contents = GetVar(panel, CONTENTS); /* contents of panel */

		/* put in title textbox */
		textbox = NewTextBox(0, MWWIDTH, TOPOFTITLE - TITLEFONTSIZE, TOPOFTITLE,
				PLAIN, "Title", "SciAn");
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox, TITLEFONTNAME);
		SetTextSize(textbox, TITLEFONTSIZE);
		SetTextColor(textbox, NewInt(TITLEFONTCOLOR));
		SetTextAlign(textbox, CENTERALIGN);

		/* put in subtitle textbox */
		strcpy(tempStr,"Scientific Visualization Package\n\n\
written by\nEric Pepke, Jim Lyons, and John Murray\n\n");
		strcat(tempStr, SCIANVERSION);
		strcat(tempStr, "\n");
		strcat(tempStr, SCIANDATE);
		textbox = NewTextBox(0, MWWIDTH, 0, TOPOFSUBTITLE,
				PLAIN, "Subtitle", tempStr);
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox, SUBTITLEFONTNAME);
		SetTextSize(textbox, SUBTITLEFONTSIZE);
		SetTextColor(textbox, NewInt(SUBTITLEFONTCOLOR));
		SetTextAlign(textbox, CENTERALIGN);
		SetVar(textbox, LINESPACE, NewInt(SUBTITLELINESPACE));

		/* put in institute name textbox */
		textbox = NewTextBox(LEFTOFINST, MWWIDTH/2, 0, TOPOFINST,
				PLAIN, "Institute name",
				"Supercomputer\nComputations\nResearch Institute");
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox, SUBTITLEFONTNAME);
		SetTextSize(textbox, SUBTITLEFONTSIZE);
		SetTextColor(textbox, NewInt(TITLEFONTCOLOR));
		SetVar(textbox, LINESPACE, NewInt(SUBTITLELINESPACE-1));

		/* put in SCRI logo textbox */
		textbox = NewTextBox(MAJORBORDER, MWWIDTH/2, 0, TOPOFINST,
				PLAIN, "SCRI logo", "!"); /* logo character in title font */
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox, TITLEFONTNAME);
		SetTextSize(textbox, TITLEFONTSIZE);
		SetTextColor(textbox, NewInt(TITLEFONTCOLOR));

		/* put in torches textbox */
		textbox = NewTextBox(MWWIDTH/2, MWWIDTH - MAJORBORDER, 0, TOPOFTORCH,
				PLAIN, "Torches", "F"); /* torches character in title font */
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox, TITLEFONTNAME);
		SetTextSize(textbox, TITLEFONTSIZE);
		SetTextAlign(textbox, RIGHTALIGN);
		SetTextColor(textbox, NewInt(TORCHCOLOR));

		/* put in university name textbox */
		textbox = NewTextBox(MWWIDTH/2, MWWIDTH - MAJORBORDER, 0, TOPOFUNIV,
				PLAIN, "University name",
				"Florida State University\nTallahassee, Florida");
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox, SUBTITLEFONTNAME);
		SetTextSize(textbox, SUBTITLEFONTSIZE);
		SetTextColor(textbox, NewInt(UNIVFONTCOLOR));
		SetTextAlign(textbox, RIGHTALIGN);
		SetVar(textbox, LINESPACE, NewInt(SUBTITLELINESPACE));

		/* put in disclaimer textbox */
		textbox = NewTextBox(MINORBORDER - 2, MWWIDTH - MINORBORDER + 2, 0, TOPOFDISCLAIMER,
				PLAIN, "Disclaimer", 
				"Copyright 1991 by Florida State University. \
Supported by U.S. Department of Energy Contract \
DE-FC05-85ER250000 and the State of Florida. No warranty \
of any kind is made regarding use of this product.");
		PrefixList(contents, textbox);
		SetVar(textbox, PARENT, panel);
		SetTextFont(textbox,  DISCLAIMERFONTNAME );
		SetTextSize(textbox, DISCLAIMERFONTSIZE);
		SetTextColor(textbox, NewInt(DISCLAIMERFONTCOLOR));
		SetTextAlign(textbox, CENTERALIGN);
		SetVar(textbox, LINESPACE, NewInt(DISCLAIMERLINESPACE));
	}
}
