/*ScianIcons.h
  Eric Pepke
  March 22, 1990
  Public stuff for icons
*/

#define ICONSIZE	32	/*Number of pixels an icon is wide*/
#define ICONSHADOW	8	/*Offset down to shadow of icon*/
#define ICONTEXTOFFSET	19	/*Offset down to an icon's text.  Depends on 
				  font*/
/*Big icons*/
#define ICON3DSCALAR	32	/*3-D scalar field*/
#define ICONPHYSOBJ	33	/*Physical object*/
#define ICONMESH	34	/*Mesh*/
#define ICONVECTORS	35	/*Series of vectors*/
#define ICONBOX		36	/*Box attributes*/
#define ICONISOSURFACE	37	/*Isosurface and level*/
#define ICON2DSCALAR	38	/*2-D scalar field*/
#define ICONMATERIAL	39	/*Material properties*/
#define ICONQUESTION	40	/*Big question mark*/
#define ICONGEOMETRY	41	/*Geometry icon*/
#define ICONSLICE	42	/*Slice through a field*/
#define ICONSTOP	43	/*Stop button*/
#define ICONPLAY	44	/*Play button*/
#define ICONREV		45	/*Reverse play button*/
#define ICONFF		46	/*Fast forward button*/
#define ICONFR		47	/*Fast reverse button*/
#define ICONPARENT      48	/*Parent of a directory*/
#define ICONDIMDIF	49	/*Dim diffuse icon*/
#define ICONBRTDIF	50	/*Bright diffuse icon*/
#define ICONDIMTIGHT	51	/*Dim tight icon*/
#define ICONBRTTIGHT	52	/*Bright tight icon*/
#define ICONCLOCK	53	/*Clock icon*/
#define ICONLIGHTS	54	/*Lights icon*/
#define ICONOBSERVER	55	/*Eyeball icon*/
#define ICONFOLDER      56
#define ICONBIN         57
#define ICONBINFILE	57
#define ICONDATA        58
#define ICONDATAFILE	58
#define ICONTEXT        59
#define ICONTEXTFILE	59
#define ICONOBJ         60
#define ICONOBJFILE	60
#define ICONUNKNOWN	61
#define ICON4DSCALAR	62	/*4d + scalar field*/
#define ICONGRID	63	/*Grid for dataset*/
#define ICONJUSTDATA	64	/*Data for dataset*/
#define ICONCONTOURS	65	/*Contours*/
#define ICONCOLOR	66	/*Color*/
#define ICONTRACE	67	/*Tracer*/
#define ICONRENDERER	68	/*Renderer*/
#define ICON1DSCALAR	69	/*1D Scalar Field*/
#define ICON2DVECTOR	70	/*2D Vector Field*/
#define ICON3DVECTOR	71	/*3D Vector Field*/
#define ICON4DVECTOR	72	/*4 or more D Vector field*/
#define ICONSCIANDOC	73	/*SciAn document icon*/
#define ICONCBETWEEN	74	/*Color between vertices icon*/
#define ICONCAROUND	75	/*Color around vertices icon*/
#define ICONCINCONTOUR	76	/*Color between contours*/
#define ICONCTABLE	77	/*Color table icon*/
#define ICONFREEFORM	78	/*Freeform tool icon*/
#define ICONSINE	79	/*Sine tool icon*/
#define ICONTRIANGLE	80	/*Triangle tool icon*/
#define ICONSAWTOOTH	81	/*Sawtooth tool icon*/
#define ICONTOOTHSAW	82	/*Toothsaw tool icon*/
#define ICONSQUARE	83	/*Square wave tool icon*/
#define ICONARROWS	84	/*Arrows icon*/
#define ICONFILEREADER	85	/*File reader icon*/
#define ICONDEFORM	86	/*Deform icon*/

/*Draw icon flags*/
#define DI_DRAWFORE	1	/*Draw the foreground*/
#define DI_DRAWBACK	2	/*Draw the background*/
#define DI_DRAWSHADOW	4	/*Draw the shadow*/
#define DI_SMALLTEXT	8	/*Draw using smaller text*/
#define DI_GREY		16	/*Draw in grey*/

extern ObjPtr iconClass;	/*Class of all icons*/
extern int iconXOff, iconYOff;	/*Offsets for icons on dragging*/

#ifdef PROTO
void InitIcons(void);
void DrawIcon(int, int, int, char *, char *, int, int);
void DrawIconGhost(ObjPtr, int, int);
ObjPtr NewIcon(int, int, int, char *);
#else
void InitIcons();
void DrawIcon();
ObjPtr NewIcon();
void DrawIconGhost();
#endif
