/*ScianFiles.h
  External stuff for ScianFiles.c
  Eric Pepke
  August 17, 1990
*/

#define MAXNFORMATS	40	/*Maximum number of file formats*/

typedef struct
    {
	char *name;		/*Name of the format*/
	char *extension;	/*Default extension*/
	ObjPtr (*reader)();	/*Reader of a file*/
	Bool (*writer)();	/*Writer of a file*/
    } FileFormat;

extern ObjPtr fileClass;
extern ObjPtr allFileReaders;

#ifdef PROTO
void InitFiles(void);
void KillFiles(void);
void DefineFormat(char *, char *, ObjPtr (*reader)(), Bool (*writer)());
void ReadFile(char *, char *);
int FormatInfo(int, char *, char *);
ObjPtr NewFileReader(char *name);
ObjPtr ReadFormattedFile(ObjPtr, char *name);
ObjPtr FindFormatReader(char *format);
ObjPtr FindExtensionReader(char *ext);
WinInfoPtr FileReadersWindow(void);
#else
void InitFiles();
void KillFiles();
void DefineFormat();
void ReadFile();
ObjPtr NewFileReader();
ObjPtr ReadFormattedFile();
ObjPtr FindFormatReader();
ObjPtr FindExtensionReader();
WinInfoPtr FileReadersWindow();
#endif
