/*exampleSTF.c
  Example program to write an STF file

  Compile 

  cc exampleSTF.c -lm -o exampleSTF

  Eric Pepke
*/

#include <stdio.h>
#include <math.h>

#define XSIZE 50
#define YSIZE 50
#define ZSIZE 50

main()
{
    int i, j, k;
    FILE *outFile;
    int dimSizes[3];
    float array[XSIZE][YSIZE][ZSIZE];	/*Data array*/

    /*Fill array*/
    for (i = 0; i < XSIZE; ++i)
    {
	for (j = 0; j < YSIZE; ++j)
	{
	    for (k = 0; k < ZSIZE; ++k)
	    {
		array[i][j][k] =  sin(((double) i) / XSIZE * 6.0)
				+ sin(((double) j) / YSIZE * 7.0)
				+ sin(((double) k) / ZSIZE * 8.0);
	    }
	}
    }

    /*Open the file*/
    outFile = fopen("example.stf", "w");
    if (outFile)
    {
	/*Print out the name, rank, dimensions, bounds*/
	fprintf(outFile, "NAME field\n");
	fprintf(outFile, "RANK 3\n");
	fprintf(outFile, "DIMENSIONS %d %d %d\n", XSIZE, YSIZE, ZSIZE);
	fprintf(outFile, "BOUNDS %g %g %g %g %g %g\n",
			  0.0, (float) XSIZE - 1,
			  0.0, (float) YSIZE - 1,
			  0.0, (float) ZSIZE - 1);
	
	/*It will be scalar data, in row order*/
	fprintf(outFile, "SCALAR\n");
	fprintf(outFile, "ORDER ROW\n");

	/*Emit the data*/
	fprintf(outFile, "DATA\n");
	for (i = 0; i < XSIZE; ++i)
	{
	    for (j = 0; j < YSIZE; ++j)
	    {
		for (k = 0; k < ZSIZE; ++k)
		{
		    fprintf(outFile, "%g ", array[i][j][k]);
		}

		/*Put in a newline every row just to make it easier to
		  read by a person*/
		fprintf(outFile, "\n");
	    }
	}

	fclose(outFile);
    }
    else
    {
	perror("example.stf");
    }
}
